/****************************************************************************
**
**  Name:  emumem.h
**
**  Description:
**     Michelle memory-group routines.
**     include:
**        "Read N bytes memory from Michelle -- EmuReadMemN()"
**        "Write N bytes memory to Michelle  -- EmuSetMemN()"
**        "Memory data comparing             -- EmuCompare()"
**        "Memory data coping                -- EmuCopy()"
**        "Memory data filling               -- EmuFill()"
**        "Memory data testing               -- EmuTest()"
**        "Memory data searching             -- EmuSearch()"
**        "Memory data checksumg             -- EmuChecksum()"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m302/emumem.h_v  $
** 
**    Rev 1.0   12 Feb 1997 14:21:36   gene
** Initial revision.
** 
**    Rev 1.0   10 Jun 1996 08:50:40   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:26   gene
** Initial revision.
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/m302/emumem.h_v   1.0   12 Feb 1997 14:21:36   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_MEM_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/



/****************************************************************************
**
**  EmuReadMemN
**
**  Description: Michelle memory-group routine, to read a chunk memory
**               from "addr" location.
**
**  Parameters:
**     input:
**        addr -- unsigned long
**        patternLen  -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**        return data -- "length" + "N bytes data string"
**
*****************************************************************************/
VOID EmuReadMemN(ADDR *addr, U32 patternLen);

/****************************************************************************
**
**  EmuSetMemN
**
**  Description: Michelle memory-group routine, to write a chunk data
**               from "buff" to "addr" location. The driver program can
**               use this function to implement to download code from a
**               file.
**               The length should be limitted up to 1024 bytes(1KB).
**
**  Parameters:
**     input:
**        addr  -- unsigned long,
**        *buff -- unsigned char,
**        patternLen   -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuSetMemN(ADDR *addr, U8 *buff, U16 patternLen);


/****************************************************************************
**
**  EmuCompare
**
**  Description: Michelle memory-group routine, to compare two memory
**               blocks.
**               Return the locations and its contents, if there has
**               difference.
**               The "addr" and "len" is the addres range of the
**               first block.
**               The "addr2" is the start address of the second block.
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        len -- unsigned long,
**        addr2 -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**        return data -- "length" + "location" + "contents"
**
*****************************************************************************/
VOID EmuCompare(ADDR *addr, U32 len, ADDR *addr2);


/****************************************************************************
**
**  EmuCopy
**
**  Description: Michelle memory-group routine, to copy a memory block
**               data to another block's.
**               The "addr" and "len" is the addres range of the
**               first block.
**               The "addr2" is the start address of the destination
**               block.
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        len -- unsigned long,
**        addr2 -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuCopy(ADDR *addr, U32 len, ADDR *addr2);


/****************************************************************************
**
**  EmuFill
**
**  Description: Michelle memory-group routine, to fill a memory range
**               with a specified pattern.
**               Fill a memory range with a specified pattern.
**               Data pattern is specified in "buff" array.
**               The lengh of the data pattern is "len".
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        len -- unsigned long,
**        *buff -- unsigned char,
**        patternLen   -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuFill(ADDR *addr, U32 len, U8 *buff, U16 patternLen);

/****************************************************************************
**
**  EmuTest
**
**  Description: Michelle memory-group routine, to test a spcified
**               address range working O.K. or not? Is RAM or not?
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        len -- unsigned long,
**
**    *** *pattern[n] -- char ===> optional
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**  NOTE: I have three ways to do this testing, you can decide how
**        to implement it by one of these.
**        1. (Read data from specified address location) -->
**           (Write pre-read data back to the same memory location) -->
**           (Compare these result then check it to report the status)
**        2. Write the defined special data pattern to the specified
**           memory loaction, then check the virolation.
**        3. Like method 2, but driver can select the "data pattern"
**           as she like. In this case, to add a parameter to indicate
**           the data pattern is necessary.
**
*****************************************************************************/
VOID EmuTest(ADDR *addr, U32 len);

/****************************************************************************
**
**  EmuSearch
**
**  Description: Michelle memory-group routine, to search data pattern
**               in the specified address range.
**               Data pattern is specified in "buff" array.
**               The lengh of the data pattern is "len".
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        len -- unsigned long,
**        *buff -- unsigned char,
**        patternLen   -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuSearch(ADDR *addr, U32 len, U8 *buff, U16 patternLen);

/****************************************************************************
**
**  EmuChecksum
**
**  Description: Michelle memory-group routine, to caculate the data
**               sum value of the specified address range.
**               The "addr" and "len" is the address range.
**               The "size" is the sum-width = 0 --> caculate in byte
**                                           = 1 --> caculate in word
**                                           = 2 --> caculate in long word
**
**  Parameters:
**     input:
**        addr -- unsigned long,
**        len -- unsigned long,
**        size  -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
****************************************************************************/
VOID EmuChecksum(ADDR *addr, U32 len);

/******************************** E O F ***********************************/
