/****************************************************************************
**
**  Name:  emumain.c
**
**  Description:
**     Michelle main(base) function routine. Include the control procedure.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m302/emumain.c_v  $
** 
**    Rev 1.7   06 May 1997 14:54:14   gene
** 
**    Rev 1.6   09 Apr 1997 09:15:38   gene
** 
**    Rev 1.5   21 Mar 1997 16:29:04   gene
** added mode_flag initial value
** 
**    Rev 1.4   17 Mar 1997 13:33:56   gene
** 
**    Rev 1.3   10 Mar 1997 11:30:06   gene
** 
**    Rev 1.2   26 Feb 1997 10:16:40   gene
** 
**    Rev 1.1   13 Feb 1997 16:41:30   gene
** changed by jacky
** 
**    Rev 1.2   18 Sep 1996 16:13:28   gene
** added canbase
** 
**    Rev 1.1   19 Jun 1996 16:30:22   gene
** modify EmuSetControl initial value
** 
**    Rev 1.0   11 Jun 1996 17:27:40   gene
** Initial revision.
** 
**    Rev 1.1   12 Jan 1996 16:44:16   gene
** added qualify trace function
** 
**    Rev 1.1   11 Jan 1996 16:38:00   gene
** modified EmuSetControl initial value
** 
**    Rev 1.0   11 Jan 1996 10:48:18   gene
** Initial revision.
** 
**    Rev 1.0   03 Jan 1996 13:50:48   gene
** Initial revision.
** 
**    Rev 1.3   21 Nov 1995 16:44:12   kevin
** got CPU ID from LLFW and put in idData[]
** 
**    Rev 1.2   16 Nov 1995 11:44:50   kevin
** fixed a bug of checking bank size while no map presented
** 
**    Rev 1.1   15 Nov 1995 15:17:14   kevin
** added EmuFunctionTest command
** 
**    Rev 1.0   07 Sep 1995 10:47:24   gene
** Initial revision.
**
**
**  $Header:   S:/tbird/arcmtat2/m302/emumain.c_v   1.7   06 May 1997 14:54:14   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

           /****************************
            *                          *
            *       INCLUDE FILES      *
            *                          *
            ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_GLOBAL_
#include "emuglb.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _COMM_DATA_
#include "commdata.h"
#endif

#ifndef _FUNCTION_TEST_
#include "functest.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_MEM_
#include "emumem.h"
#endif

#ifndef _EMU_SETUP_
#include "emusetup.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#include <conio.h>

extern U16 errorFlag;
extern U8 cpuFlag;
extern U32 bankSize;
extern BOOLEAN mtatExist;
           /****************************
            *                          *
            *     LOCAL DEFINITIONS    *
            *                          *
            ****************************/
#define MCR     0XF004

            /****************************
             *                          *
             *    EXTERNAL VARIABLES    *
             *                          *
             ****************************/

            /****************************
             *                          *
             *     LOCAL PROTOTYPES     *
             *                          *
             ****************************/
VOID InitFwControl(VOID);
VOID InitDataBase(VOID);
RETCODE ReceiveInputCommand(VOID);
RETCODE DispatchCommand(U16 *ac, U8 *av[], U8 *cmdStream);
RETCODE ProcessCommand(U16 ac, U8 *av[]);

            /****************************
             *                          *
             *      EXECUTABLE CODE     *
             *                          *
             ****************************/



/***************************************************************************
**
** FunctionTest
**
**  Description: Michelle Test function.
**
**  Parameters:
**     input:
**        none
**
**     output:
**
****************************************************************************/
VOID FunctionTest(VOID) {
STATUS status;
U16 testId,argc;
U8 *argv[10];

   for(;;) {
      status = GOOD;
      ReceiveStream(); /* read the input commands stream. */
      DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
      if((COMMAND_ID)(*argv[0]) == FUNCTION_TEST) {
         testId = *(U16 *)(argv[1]+1);
         //if (testId != END_TEST) status = EmuFunctionTest(testId);
         OutputStatus(status,ON);
         TransmitStream();
         //outp(MCR,0);
      }
      else {
         OutputStatus(COMMAND_ERROR,ON);
         TransmitStream();
         //outp(MCR,0);
         return;
      }
      if (testId == END_TEST) return;
   }
}

/***************************************************************************
**
**  main()
**
**  Description: Michelle main routine, with its linear control process
**               sequence. We always think this fw process with one single
**               task.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
****************************************************************************/
main() {
   U16 argc;
   U8 *argv[10];
   ERROR_NO errNo;

   //fwId = EB;
   InitDataBase(); /* all data sets setting or default value. */
   InitFwControl(); // Initial hardware and firmware

   while (TRUE) {
      ReceiveStream(); /* read the input commands stream. */
      DispatchCommand(&argc, argv, commandStream); /* parser the input commands stream. */
      errNo = ProcessCommand(argc,argv); /* case switching the command tasks */
      if (errNo == OK) TransmitStream();
      else EmuReportError(errNo);
   }
   return(GOOD);
}

VOID InitFwControl(VOID) {
U8 status;
U16 emmSize,lp;
U32 baseReg[MAX_BASE_REG_NO];
U8 vccFlag;
U16 action[11],ev[11];


//U32 mapAddr1,mapAddr2;
//BUS_EVENT testEvent;
//QUALIFY_LIST condition;
U16 len = 8;
//ADDR addr;
//   testEvent.enable   = ON;
//   testEvent.addrSpec = MASK_ADDR;
//   testEvent.addrLow  = 0x00000480;
//   testEvent.addrHigh = 0xffffffff;
//   testEvent.spareLow = 0x78;
//   testEvent.spareHigh = 0xff;
//   testEvent.dataSpec = MASK_DATA;
//   testEvent.dataLow  = 0x1234;
//   testEvent.dataHigh = 0xffff;
//
//   testEvent.statusFlag = 1;
//   testEvent.status.statusFc = 0x0c;
//   testEvent.status.statusDsLow = 1;
//   testEvent.status.statusDsHigh = 0xff;
//   testEvent.status.statusCsLow = 0x07;
//   testEvent.status.statusCsHigh = 0xffff;

   status = GOOD;
   AccessIceFlag(WRITE_ONE,RESET_FLAG,&C_ON);
   idData[FIRMWARE_TYPE] = 'M'; // This is a MICEpack firmware.
   idData[FIRMWARE_VER] = 0x10; // FW version is 1.0.
   idData[CPU_TYPE] = (U8)(IDCode() & 0xff); // 4:306, 6:307, 7:328
   //SetClockPhase();

   InitCpPort();
   if (InitialTraceMachine()) status |= TRACE_HARDWARE_ERROR;
   InitEpPort();
   if (errorFlag) status |= DOWNLOAD4003_FAILURE;


   switch(emmSize = InitEm() & 0x00ff) {
      case 0x00 :
         bankSize = 0;
         break;
      case 0x01 :
      case 0x10 :
         bankSize = 0x20000; // each bank has 128K
         break;
      case 0x02 :
         bankSize = 0x40000; // each bank has 256K
         break;
      case 0x03 :
      case 0x11 :
         bankSize = 0x80000; // each bank has 512K
         break;
      case 0x12 :
         bankSize = 0x100000; // each bank has 1M
         break;
      case 0x13 :
         bankSize = 0x200000; // each bank has 2M
         break;
   }

   AccessIceFlag(WRITE_ONE,EMM_SIZE,&emmSize);
   AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);

   if (MapTest()) status |= EMM_CONTROL_RAM_ERROR;

 //if (mtatExist) InitCov();
   if (mtatExist) idData[TRACE_EXIST] = ON;
   else idData[TRACE_EXIST] = OFF;


   InitMapTable();

   if (CanTest()) status |= MCE16A_HARDWARE_ERROR;
   EnEmDisViol();
   if (InitialReset(baseReg)) status |= NO_TARGET_VCC;
   DisEmStop();
   AccessBaseReg(WRITE_ALL,noUse,baseReg);
   idData[INIT_HW_STATUS] = status;

//   EmuClrEvent(0); // clear all bus event
//
//   EmuSetEvent(1,(U8 *)&testEvent);
//
//   EmuSetTraceBreak(OFF);
//   EmuSetTraceBuff(1);
//   EmuClrTrig(0); // clear all trigger.
//   for (lp = 0; lp < 11; lp++) // clear ext event and counter 0/1.
//      ev[lp]  =  0;
//   for (lp = 0; lp < 8; lp++) { // if bus events occur then halt ep.
//      ev[lp]  =  lp+1;
//      action[lp]  = 1;
//   }
//   EmuSetTrig(1,1,ev,action,0); // set trigger level 1 that all event break; backward trace.

//   if (iceStartFlag == 0xaaaa) { // Cold start
//      DisableControl();
//      FunctionTest();
//      EnableControl();
//   }
   EnEmDisViol();
   vccFlag = Reset(baseReg);
   DisEmStop();
   AccessBaseReg(WRITE_ALL,noUse,baseReg);

   if ((iceStartFlag == 0xaaaa) && (mtatExist)) { // Cold start & trace board exist.
      EmuClrEvent(0); // clear all event
      EmuSetTimerCounter(0,1,1); // set trigger count0 and count1 are zero.
      EmuSetTraceBreak(OFF);
      EmuSetTraceBuff(1);
      EmuClrTrig(0); // clear all trigger.
      for (lp = 0; lp < 11; lp++) // clear ext event and counter 0/1.
         ev[lp]  =  0;
      for (lp = 0; lp < 8; lp++) { // if bus events occur then halt ep.
         ev[lp]  =  lp+1;
         action[lp]  = 1;
      }
      EmuSetTrig(1,1,ev,action,0); // set trigger level 1 that all event break; backward trace.
   }
   iceStartFlag = 0x0;
   ClrViolFlg();
   EnEmRun();
   Exbp1Disable();
   Exbp2Disable();
   EmuSetMap(0,0,0x0f03); /* map all external */
   EmuSetControl(0xffff); // all control signals enable except bit 15.

}

VOID InitDataBase(VOID) {
U16 phyCpu,size,timerFlag = 0xff,bufNum = 4,brokeReason = BROKE;

   noUse = C_OFF = 0;
   C_ON = 1;
   noUseByte = 0;
   AccessIceFlag(READ_ONE,PHY_CPU_TYPE,&phyCpu);
   AccessIceFlag(CLEAR_ALL,noUse,&noUse);// special for timer flag
   AccessIceFlag(WRITE_ONE,PHY_CPU_TYPE,&phyCpu);
   AccessIceFlag(WRITE_ONE,FLY_RUN,&C_OFF);
   AccessIceFlag(WRITE_ONE,BROKE_REASON,&brokeReason);
   AccessIceFlag(WRITE_ONE,TIMER_FLAG,&noUse);
   AccessIceFlag(WRITE_ONE,TRACE_BUFF,&bufNum);
   AccessIceFlag(WRITE_ONE,VERIFY_FLAG,&C_ON);
   AccessStatusFlag(CLEAR_ALL,noUse,&noUse);
   size = S_BYTE;
   AccessIceFlag(WRITE_ONE,SIZE_FLAG,&size);
   CanBaseAddr = 0xFFEC00;
   //CommRecover();
   AccessIceFlag(WRITE_ONE,MODE_FLAG,&C_OFF);
}

RETCODE ReceiveInputCommand(VOID) { /* Receive data from communication port */
   ReceiveStream();
   return(GOOD);
}

/***************************************************************************
**
**  DispatchCommand
**
**  Description: Dispath the input command stream.
**         Note: Please refer input command protocol format.
**
**  Parameters:
**     input:
**        commandStream : input command stream.
**     output:
**        ac      : argument counter.
**        av      : argument position.
**
****************************************************************************/
RETCODE DispatchCommand(U16 *ac, U8 *av[], U8 *cmdStream) {

   *ac = 1;   /* Initial argument. */
   av[0] = cmdStream;
   cmdStream++;
   while ((*cmdStream) && (*cmdStream != 0xff)){
      av[(*ac)++] = cmdStream;
      cmdStream += *cmdStream + 1;
   }
   return(GOOD);
}

/***************************************************************************
**
**  ProcessCommand
**
**  Description: Idnetidy then command ID and call FW function.
**
**  Parameters:
**     input:
**        commandStream : input command stream.
**        ac            : argument counter.
**        av            : argument position.
**     output:
**        outputStream  : the message of executive result.
**
****************************************************************************/
RETCODE ProcessCommand(U16 ac, U8 *av[]) {
U16 dataLen,flyFlag;
U32 data[10];
LOOP_VAR lp;
STATUS status;

   for (lp = 1; lp < (LOOP_VAR)ac; lp++) {
      dataLen = *(av[lp]);
      switch (dataLen) {
         case 1 : /* byte */
            data[lp] = *(U8 *)(av[lp]+1);
            break;
         case 2 : /* word */
            data[lp] = *(U16 *)(av[lp]+1);
            break;
         case 3 : /* 3 byte */
            data[lp] = *(U32 *)(av[lp]+1) & 0x00ffffff;
            break;
         case 4 : /* long */
            data[lp] = *(U32 *)(av[lp]+1);
            break;
         case 0xff : /* more than 255 */
            data[lp] = *(U16 *)(av[lp]+1);
            break;
         default : /* do nothing */
            data[lp] = 0;
            break;
      }
   }

   if (!ac) return(FALSE);
   status = GOOD;
   AccessIceFlag(READ_ONE,FLYING,&flyFlag);
   if (flyFlag) EmuGetCpuStatus();
   switch ((COMMAND_ID)(*av[0])) {
      case CHECKSUM :
         EmuChecksum((ADDR *)(av[1]+1),(U32)data[2]);
         break;
      case CLR_EVENT :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuClrEvent((U16)data[1]);
         break;
      case CLR_TRIG :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuClrTrig((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case COMPARE :
         EmuCompare((ADDR *)(av[1]+1), (U32)data[2], (ADDR *)(av[3]+1));
         break;
      case COPY :
         EmuCopy((ADDR *)(av[1]+1), (U32)data[2], (ADDR *)(av[3]+1));
         break;
      case FUNCTION_TEST :
         EmuFunctionTest((U16)data[1]);
         break;
      /*  only use at run command
      case ESC_COMMAND :
         break;
      */
      case FILL :
         EmuFill((ADDR *)(av[1]+1), (U32)data[2], (U8 *)(av[3]+1), *av[3]);
         break;
      case GET_ID :
         EmuGetID();
         break;
     // case GET_ALL_CO_REG :
     //    EmuGetAllCoReg();
     //    break;
      case GET_ALL_REG :
         EmuGetAllReg();
         break;
      //case GET_ALL_INTERNAL_REG :
      //   EmuGetAllIntReg();
      //   break;
      case GET_CO_COVERAGE :
         break;
     // case GET_CO_REG :
     //    EmuGetCoReg((U16)data[1]);
     //    break;
      case GET_CONTROL :
         EmuGetControl();
         break;
      case GET_DEPTH :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuGetTraceDepth((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case GET_LAST_BUFF :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuGetTraceInfo();
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case GET_MAP :
         EmuGetMap();
         break;
      case GET_EVENT :
         EmuGetAllEvent();
         break;
      case GET_MAP_SIZE :
         EmuGetMapSize();
         break;
      //case GET_MODE :
      //   EmuGetMode();
      //   break;
      case GET_READY :
         EmuGetReady();
         break;
      case GET_REG :
         EmuGetReg((REG_MODE)data[1], (U16)data[2]);
         break;
      case GET_SIZE :
         EmuGetAccessSize();
         break;
      case GET_STAT :
         EmuGetStatus();
         break;
      case GET_SYNC :
         EmuGetSync();
         break;
      case GET_VERIFY :
         EmuGetVerify();
         break;
      case GET_WAIT :
         EmuGetWait();
         break;
      case GO_COMMAND :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            EmuGo((S16)data[1]);
            return(GOOD);
         }
         break;
    //  case HALT :
    //     EmuHalt();
    //     break;
      case INPUT :
         //EmuInput((U16)data[1], (U16)data[2], (U16)data[3]);
         break;
      case LIST_TRACE :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuListTrace((U16)data[1],(U32)data[2],(U8 *)(av[3]+1));
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case OUTPUT :
         //EmuOutput((U16)data[1], (U8 *)(av[2]+1), (U16)data[3], (U16)data[4]);
         break;
      case READ_MEM_N :
         EmuReadMemN((ADDR *)(av[1]+1), (U16)data[2]);
         break;
      case RESET :
         EmuReset();
         AccessIceFlag(READ_ONE,FLYING,&flyFlag);
         break;
      case SEARCH :
         EmuSearch((ADDR *)(av[1]+1), (U32)data[2], (U8 *)(av[3]+1), *av[3]);
         break;
      case SET_CONTROL :
         EmuSetControl((U16)data[1]);
         break;
      case SET_CO_COVERAGE :
         break;
     // case SET_CO_REG :
     //    EmuSetCoReg((U16)data[1],(U16 *)(av[2]+1));
     //    break;
      case SET_EVENT :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuSetEvent((U16)data[1], (U8 *)(av[2]+1));
         break;
      case SET_ALL_EVENT :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuSetAllEvent((U8 *)(av[1]+1),(U8 *)(av[2]+1),(U8 *)(av[3]+1));
         break;
      case SET_EX_BKPT :
         EmuSetExBkpt((U16)data[1], (ADDR *)(av[2]+1));
         break;
      case SET_EXT_EVENT :
         EmuSetExtEvent((U16)data[1]);
         break;
      //case SET_ID :
      //   EmuSetID((U16)data[1]);
      //   break;
      case SET_MEM_N :
         EmuSetMemN((ADDR *)(av[1]+1), (U8 *)(av[2]+1), *av[2]);
         break;
      case SET_MAP :
         EmuSetMap((U32)data[1], (U32)data[2], (U16)data[3]);
         break;
      case SET_REG :
         EmuSetReg((REG_MODE)data[1], (U16)data[2],(U32)data[3]);
         break;
      case SET_READY :
         EmuSetReady((U16)data[1]);
         break;
      case SET_SIZE :
         EmuSetAccessSize((U16)data[1]);
         break;
      case SET_SYNC :
         EmuSetSync((U16)data[1]);
         break;
      case SET_TRACE_BREAK :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuSetTraceBreak((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case SET_TRACE_BUFF :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist) EmuSetTraceBuff((U16)data[1]);
            else OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case SET_TRIG :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else {
            if (mtatExist)
               EmuSetTrig((U8)data[1],(U16)data[2],(U16 *)(av[3]+1),(U16 *)(av[4]+1),(U16)(data[5]));
            else
               OutputStatus(NO_TRACE_MODULE,ON);
         }
         break;
      case GET_TRIG :
         if (mtatExist) EmuGetAllTrig();
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SET_TIME_COUNT :
         EmuSetTimerCounter((U16)data[1],(U32)data[2],(U32)data[3]);
         break;
      //case SET_TIMER_REG :
      //   EmuEpTimer((U16)data[1]);
      //   break;
      case SET_VERIFY :
         EmuSetVerify((U16)data[1]);
         break;
      case SET_WAIT :
         EmuSetWait((U16)data[1]);
         break;
      case STEP :
         if (flyFlag) status = INVALID_FLY_COMMAND;
         else EmuStepRange((ADDR *)(av[1]+1),(ADDR *)(av[2]+1));
         break;
    //  case STEP_ONE :
    //     if (flyFlag) status = INVALID_FLY_COMMAND;
    //     else EmuStepRange(0,0);
    //     break;
      case TEST :
         EmuTest((ADDR *)(av[1]+1), (U32)data[2]);
         break;
      case GET_CPU_STATUS :
         EmuGetCpuStatus();
         break;
      case ABORT :
         EmuAbort();
         AccessIceFlag(READ_ONE,FLYING,&flyFlag);
         break;
      case DIAGNOSTIC :
         EmuDiagnostic();
         break;
      case ENABLE_SW_BKPT :
         EmuEnSwBkpt();
         break;
      case DISABLE_SW_BKPT :
         EmuDisSwBkpt();
         break;
      case SET_BKPT_CODE :
         EmuSetBkptCode((BKPT_OP_CODE)data[1]);
         break;
      case SET_INT_REG :
         EmuSetIntReg((U16)data[1],(U16)data[2],(U32)data[3],(BOOLEAN)data[4]);
         break;
      case GET_INT_REG :
         EmuGetIntReg((U16)data[1],(U16)data[2],(BOOLEAN)data[3]);
         break;
      case SET_QUAL_TRACE :
         EmuSetQualTrace((U32)data[1],(U32)data[2],(U16)data[3],(U16)data[4]);
         break;
      case DISABLE_QUAL :
         EmuDisableQual();
         break;
      case CORE_TYPE :
         EmuCoreType();
         break;
      case SET_CANBASE :
         EmuSetCanBase((U32)data[1]);
         break;
      case SET_TRACE_OFF_FULL :
         if (mtatExist) EmuSetTrcOffOnFull((U16)data[1]);
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SET_TRIG_OUT_ACT :
         if (mtatExist) EmuSetTrigOutAct((ACTIVE_STATE)data[1]);
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case TRACE_ACTION :
         if (mtatExist) EmuTraceAction((U8)data[1]);
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case READ_STAMP :
         if (mtatExist) EmuReadFrameStamp((U16)data[1],(S32)data[2]);
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case R_FLUSH_ROM :
         EmuGetFROM();
         break;
      case W_FLUSH_ROM :
         EmuSetFROM((U8*)(av[1]+1));
         break;
      case SPA_SET_RANGE :
         if (mtatExist) EmuSPASetRange((U8)data[1],(U8)data[2],(ADDR*)(av[3]+1),(ADDR*)(av[4]+1));
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_CLEAR_RANGE :
         if (mtatExist) EmuSPAClearRange((U8)data[1]);
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_GET_MA_INFO :
         if (mtatExist) EmuSPAGetMAInfo();
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_GET_TA_INFO :
         if (mtatExist) EmuSPAGetTAInfo();
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_GET_CC_INFO :
         if (mtatExist) EmuSPAGetCCInfo((ADDR*)(av[1]+1),(U16)data[2],(U8)data[3]);
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_CLOSE :
         if (mtatExist) EmuSPAClose();
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_SETBKPT :
         if (mtatExist) EmuSPASetBkpt((U8)data[1],(ADDR*)(av[2]+1));
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      case SPA_OPEN :
         if (mtatExist) EmuSPAOpen();
         else OutputStatus(NO_TRACE_MODULE,ON);
         break;
      default :
         EmuReportError(COMMAND_ERROR);
   } /* end switch *data[0]. */
   //AccessIceFlag(READ_ONE,FLYING,&flyFlag);
   //if (flyFlag) EmuGetCpuStatus();
   AccessIceFlag(READ_ONE,FLYING,&flyFlag);
   if (status == INVALID_FLY_COMMAND) OutputStatus(status,ON);
   else if (flyFlag && CheckEpStop()) {
        for (lp = 0; lp < 1000; lp++);
        StartGo(FLY_RUN);
   }
   return(GOOD);
}

/******************************** E O F ***********************************/

