/**************************************************************************
**
**  Name:  emucomm.c
**
**  Description:
**     Michelle command or data communication routines( UART ).
**     include:
**
**  Status:  preliminary
**
**    Rev 1.0   10 May 1996 10:06:04   jacky
** Get file from ATL. V1.3
** 
** Initial revision.
**
**  $Header:   S:/tbird/arcmtat2/m306/emucomm.c_v   1.2   11 Apr 1997 18:21:38   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
***************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _COMM_DATA_
#include "commdata.h"
#endif

#ifndef _LLFW_
#include "emullfw.h"
#endif

#include <conio.h>
#include <string.h>

VOID SPAHandleStatus(U16 runMode);
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define CR             0x0D
#define LF             0x0A
#define LEAD_CODE      ':'
#define DMA0TC         0xffc8
#define IMASK          0Xff28  // Interrupt Mask Register
#define EOI            0Xff22  // End-of-Interrupt Register
#define RBR            0Xf000  // UART port
#define IER            0Xf001
#define IIR            0xf002
#define MCR            0Xf004
#define LSR            0Xf005
#define MSR            0Xf006
#define T0CNT          0Xff50
#define T2CNT          0Xff60
#define enUartRxInt()  outp(IER,1)
#define enUartTxInt()  outp(IER,2)
#define enCpExt1Int()  outp(IMASK,((U8)inp(IMASK)|0X20))
#define disCpExt1Int() outp(IMASK,((U8)inp(IMASK)&0XDF))
#define enCpExt1_TimeInt()      outp(IMASK,((U8)inp(IMASK)&0XDE))
#define disUartInt()   outp(IER,0)
#define RejRxData()    outp(MCR,0)
#define ReadyRxData()  outp(MCR,1)
#define InitUart()     inp(MSR);\
                       inp(LSR);\
                       outpw(EOI,0x8000);\
                       inp(IIR)

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

static U8 *inBufadr;
                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                         /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/
/****************************************************************************
**
**  ReceiveByte
**
**  Description: Receive one byte from communication.
**
**  Parameters:
**     input:
**     output: data from inBuf
**
*****************************************************************************/
U8 ReceiveByte(VOID)
{
static U8 *rbptr;

  do {
     if ((inWrPtr != inRdPtr) && ((U16)timeOut==0)) {
        rbptr=(U8 *)(inBufadr+inRdPtr);
        inRdPtr++;
        if (inRdPtr >= MAX_BUF_SIZE)  inRdPtr=0;
        return *rbptr;
     };
     if (timeOut) return (NULL);
  }while ( 1 );
}
/****************************************************************************
**
**  TransmitByte
**
**  Description: Transmit one byte from communication.
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID TransmitByte(U8 c)
{
static U8 *trptr;

  trptr=(U8 *)&outBuf;
  *(trptr+outWrPtr)=c;
  outWrPtr++;
  if (outWrPtr >= MAX_BUF_SIZE) outWrPtr=0;
  enUartTxInt();
  return;
}

/****************************************************************************
**
**  WaitStringEnd
**
**  Description: Wait for the end of the command string and put data into
**               inBuf.
**
**  Parameters:
**     input:
**     output:clear DTR
**
*****************************************************************************/
VOID WaitStreamEnd(VOID)
{
U8 ch,*chptr;
   enCpExt1Int();
   disUartInt();
   inRdPtr = inWrPtr;
   for(;;) {
      SetWatchDog(5);
      do {
          if (timeOut) {            // the end of the command stream
             RejRxData();
             HltWatchDog();
             outpw(EOI,0x8000);
             enUartRxInt();
             disCpExt1Int();
             inRdPtr=inWrPtr;
             return;
          };
          ch=(U8)(inp(LSR) & 0X1);
      }while(!ch);
      if (!timeOut) {
         HltWatchDog();
         ch = (U8)inp(RBR);    // put char into inBuf
         chptr = (U8 *)(inBufadr+inWrPtr);
         *chptr = ch;
         inWrPtr++;
         if (inWrPtr >= 0x400) inWrPtr=0;
         inRdPtr++;
         if (inRdPtr >= 0x400) inRdPtr=0;
         continue;
      }; //if (!timeOut)
   } // for(;;)
}

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive data from communication and check the length and
**               checksum, the data format is :       XXXXxxx....xxxX
**                                                  length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
VOID ReceiveStream(VOID) {
U8 mice[4] = {'M','I','C','E'};
static U8 aa[4],checksum;
static U16 len;
//register lp;
static U16 lp;
U16 runMode;

   inBufadr=(U8 *)&inBuf;
   dwnldfwfg=timeOut=0;
   enCpExt1_TimeInt(); // set ext1 INT and timer INT
   for (;;) {
      AccessIceFlag(READ_ONE,MODE_FLAG,&runMode);
      checksum=0;
      InitUart();
      enUartRxInt();
      ReadyRxData();     // set DTR to be ready for receiving.
      if ((runMode == SPA_MA_RUN) || (runMode == SPA_TA_RUN) ||
          (runMode == SPA_CC_RUN) ) {
         SetWatchDog(5);
         aa[0] =ReceiveByte();
         if (!timeOut) {
            if ((aa[0]!=':') && (aa[0]!='M')) goto RxError;
         }
         else {
            RejRxData();        // clear DTR to reject data
            HltWatchDog();
            SPAHandleStatus(runMode);
            continue;
         };
      }  //if ((runMode == SPA_MA_RUN) || (runMode == SPA_TA_RUN))
      else {
         aa[0] = ReceiveByte();
         if ((aa[0]!=':') && (aa[0]!='M')) goto RxError;
      }; // else
      if (aa[0]==':') {
         SetWatchDog( 0x78 );   // set the interval time for watchdog
         for (lp =1; lp < 4; lp++)   {
             aa[lp] = ReceiveByte();
             checksum += aa[lp];
               if( timeOut ) goto RxError;
         }; //for (lp =1; lp < 4; lp++)
         HltWatchDog();
         if ( !checksum ) {
           len = *(U16 *)&aa[1];  /* data length */
           if (len > MAX_BUF_SIZE) goto RxError;
         } //if ( checksum == 0 )
         if( checksum ) goto RxError;
      } //if (aa[0]==':')
      if (aa[0] == 'M') {
         SetWatchDog( 0x78 );
         if ((aa[1]=ReceiveByte())!='I') goto RxError;
         if ((aa[2]=ReceiveByte())!='C') goto RxError;
         if ((aa[3]=ReceiveByte())!='E') goto RxError;
         RejRxData();      // warm start
         HltWatchDog();
         disUartInt();
         TransmitByte(LEAD_CODE);
         continue;
      };
      SetWatchDog(len*40);     // set the interval time for watchdog
      for (lp = 0; (U16)lp < len; lp++)  {
         commandStream[lp] = ReceiveByte();
         if ( timeOut ) goto RxError;
         checksum += commandStream[lp];
      };
      RejRxData();      // clear DTR to reject data
      HltWatchDog();
      if ( !checksum )  {
          TransmitByte(ACK);
          commandStreamLen = len;
          inRdPtr=inWrPtr;
          return;
      }; //if (checksum == 0 )
RxError:
      WaitStreamEnd();
      TransmitByte(NACK);
   }; //for (;;)
}

/****************************************************************************
**
**  TransmitStream
**
**  Description: Transmit data(length + data + checksum) to
**               communication port.
**               the data format is :  XXXXxxx....xxxX
**                                   length   data   checksum
**
**  Parameters:
**     input:
**     output:
**
*****************************************************************************/
/*
   Transmit data(length + data + checksum) to communication port.
   the data format is : LENGTH(2 bytes)DATA(number of length)CHECKSUM(1 byte)
*/
VOID TransmitStream(VOID) {
//register lp;
static U16 lp;
static U32 lpcnt;
U8 highLen,lowLen,finalFlag,aa,trchecksum,ch;

   trchecksum = 0;
   for (lp = 0; (U16)lp < (U16)outputStreamLen; lp++)
      trchecksum += outputStream[lp];
   outputStream[outputStreamLen] = (U8)((~trchecksum)+1);
   outputStreamLen++;

   lowLen = LowByte(outputStreamLen);
   highLen = HighByte(outputStreamLen);
   trchecksum = (U8)((~(lowLen+highLen)) + 1);

   enCpExt1_TimeInt();  // set ext1 INT and timer INT

   for (;;) {
      RejRxData();
      InitUart();
      inp(RBR);
      outRdPtr=outWrPtr;
      TransmitByte(LEAD_CODE);
      TransmitByte(lowLen);
      TransmitByte(highLen);
      TransmitByte(trchecksum);
      for (lp = 0; (U16)lp < (U16)outputStreamLen; lp++) {
          TransmitByte(outputStream[lp]);
      };
      finalFlag = 0;
      for (lpcnt = 0; lpcnt < (U32)((U32)outputStreamLen*2000); lpcnt++) {
         if ( outWrPtr == outRdPtr) {
            ReadyRxData();    // ready to receive char
            enUartRxInt();
            finalFlag = 1;
            break;
         };
      };
      if (finalFlag == 0) {
         continue;
      };
      SetWatchDog( 0x96 );
      aa = ReceiveByte();
      switch ( aa ) {
         case ACK:   goto TxOK;
         case NACK:  goto TxError;
         default:                      // error correction
              disUartInt();
              ReadyRxData();
              SetWatchDog(0x40);
              while (!timeOut) {
                 ch=(U8)(inp(LSR) & 0X2);
                 if (ch==0x2) goto TxOK;
              }; //while (!timeOut)
              goto TxError;
      };  // switch
TxOK:
   HltWatchDog();
   return;
TxError:
   HltWatchDog();
   }    // for (;;)
}
/******************************** E O F ***********************************/
