/***************************************************************************
**
**  Name:  emuport.c
**
**  Description:
**     Michelle port-group routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m306/emuport.c_v  $
** 
**    Rev 1.0   19 Mar 1997 15:31:44   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:26   gene
** Initial revision.
** 
** 
**  $Header:   S:/tbird/arcmtat2/m306/emuport.c_v   1.0   19 Mar 1997 15:31:44   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_PORT_
#include "emuport.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/***************************************************************************
**
**  EmuInput
**
**  Description: Michelle input routine,
**
**  Parameters:
**     input:
**        port -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        return data -- "length" + "data"
**
****************************************************************************/
VOID EmuInput(U16 port,U16 len, U16 size) {
U32 m68Reg[MAX_CPU_REG_NO];
U8 dataLen;

   StopRun();
   ClrViolFlg();
   EnEmDisViol();

   AccessCpuReg(READ_ALL,noUse,m68Reg);
   InputData(port,len,size);
   DisEmStop();
   AccessCpuReg(WRITE_ALL,noUse,m68Reg);
   diff = (U8 *)&canTemp;
   if (exceptBreak == GOOD) {
      OutputStatus(GOOD,OFF);
      dataLen = (U8)len;
      OutData(dataLen,diff,ON);
      OutEnd();
   }
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuOutput
**
**  Description: Michelle output routine,
**
**  Parameters:
**     input:
**        port  -- unsigned int,
**        value -- unsigned int
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error
**
****************************************************************************/
VOID EmuOutput(U16 port, U8 *buff, U16 len, U16 size) {
U32 m68Reg[MAX_CPU_REG_NO];

   StopRun();
   ClrViolFlg();
   EnEmDisViol();
   AccessCpuReg(READ_ALL,noUse,m68Reg);
   OutputData(port,len,buff,size);
   DisEmStop();
   AccessCpuReg(WRITE_ALL,noUse,m68Reg);
   if (exceptBreak == GOOD) OutputStatus(GOOD,ON);
   else OutputExceptReason(ON);
}

/******************************** E O F ***********************************/

