/***************************************************************************
**
**  Name:  functest.c
**
**  Description:
**     Michelle function test program
**     include:
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m306/functest.c_v  $
** 
**    Rev 1.1   25 Mar 1997 15:49:44   gene
** addr bus 24-bits => 32-bits
** 
**    Rev 1.0   19 Mar 1997 15:31:44   gene
** Initial revision.
** 
**    Rev 1.2   10 Mar 1997 10:43:38   gene
** 
**    Rev 1.1   13 Feb 1997 16:41:50   gene
** changed by jacky
** 
**    Rev 1.2   24 Jul 1996 13:12:28   gene
** added DTACK internal ready setting before emm test
** 
**    Rev 1.1   23 Jul 1996 09:59:28   gene
** 
**    Rev 1.0   07 Sep 1995 10:47:34   gene
** Initial revision.
** 
** Initial revision.
** 
**  $Header:   S:/tbird/arcmtat2/m306/functest.c_v   1.1   25 Mar 1997 15:49:44   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _FUNCTION_TEST_
#include "functest.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _EMU_SETUP_
#include "emusetup.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_MEM_
#include "emumem.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_SETUP_
#include "emusetup.h"
#endif

#include <memory.h>
#include <dos.h>
#include <conio.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define TEST_BKPT 0x00000502ul
#define ADDR_SHIFT 0x10000ul
#define FRAME_WIDTH 22

#define     MCR     0XF004
#define     P82552B 0XF141
                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/*VOID reverseOrder(U8 *arrayPtr) {
   U8 lp;
   U8 varData[4];

   for (lp = 0; lp < 4; lp++)
      varData[3-lp] = arrayPtr[lp];
   for (lp = 0; lp < 4; lp++)
      arrayPtr[lp] = varData[lp];

} */

/***************************************************************************
**
**  TestTraceBoard
**
**  Description: Michelle main self-testing routine.
**
**  Parameters:
**     input:
**     output:
**        none
**
****************************************************************************/
#define TEST_ITEM 2
STATUS TestTraceBoard(VOID) {

   U8 memData2[] ={
          0x31,0xFC,0x00,0x01,0x02,0x00,    // move.w #1,200
          0x31,0xFC,0x00,0x02,0x02,0x00,    // move.w #2,200
          0x31,0xFC,0x00,0x04,0x02,0x00,
          0x31,0xFC,0x00,0x08,0x02,0x00,
          0x31,0xFC,0x00,0x10,0x02,0x00,
          0x31,0xFC,0x00,0x20,0x02,0x00,
          0x31,0xFC,0x00,0x40,0x02,0x00,
          0x31,0xFC,0x00,0x80,0x02,0x00,
          0x31,0xFC,0x01,0x00,0x02,0x00,
          0x31,0xFC,0x02,0x00,0x02,0x00,
          0x31,0xFC,0x04,0x00,0x02,0x00,
          0x31,0xFC,0x08,0x00,0x02,0x00,
          0x31,0xFC,0x10,0x00,0x02,0x00,
          0x31,0xFC,0x20,0x00,0x02,0x00,
          0x31,0xFC,0x40,0x00,0x02,0x00,
          0x31,0xFC,0x80,0x00,0x02,0x00,
//          0x10,0x38,0x04,0x00,              // move.b 400,d0;
          0x10,0x38,0x00,0x01, 0x10,0x38,0x00,0x02, // move.b d0,1; move.b d0,2
          0x10,0x38,0x00,0x04, 0x10,0x38,0x00,0x08,
          0x10,0x38,0x00,0x10, 0x10,0x38,0x00,0x20,
          0x10,0x38,0x00,0x40, 0x10,0x38,0x00,0x80,
          0x10,0x38,0x01,0x00, 0x10,0x38,0x02,0x00,
          0x10,0x38,0x04,0x00, 0x10,0x38,0x08,0x00,
          0x10,0x38,0x10,0x00, 0x10,0x38,0x20,0x00,
          0x10,0x38,0x40,0x00,
          0x10,0x39,0x00,0x00,0x80,0x00,
          0x10,0x39,0x00,0x01,0x00,0x00,
          0x10,0x39,0x00,0x02,0x00,0x00,
          0x10,0x39,0x00,0x04,0x00,0x00,
          0x10,0x39,0x00,0x08,0x00,0x00,
          0x10,0x39,0x00,0x10,0x00,0x00,
          0x10,0x39,0x00,0x20,0x00,0x00,
          0x10,0x39,0x00,0x40,0x00,0x00,
          0x10,0x39,0x00,0x80,0x00,0x00,
          0x10,0x39,0x01,0x00,0x00,0x00,
          0x10,0x39,0x02,0x00,0x00,0x00,
          0x10,0x39,0x04,0x00,0x00,0x00,
          0x10,0x39,0x08,0x00,0x00,0x00,
          0x10,0x39,0x10,0x00,0x00,0x00,
          0x10,0x39,0x20,0x00,0x00,0x00,
          0x10,0x39,0x40,0x00,0x00,0x00,
          0x10,0x39,0x80,0x00,0x00,0x00,
   };

   U8 regData[] = { 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, 0x04, 0x00 };
   U16 lastBufNo;
   U8 traceBuffData[36*22],*tracePtr ;
   QUALIFY_LIST condition;
   TRACE_HEAD traceHead;
   STATUS status = GOOD,status1;
   S32 lp;
   U16 test16Bit = 0x01, tmpData;
   U32 test32Bit = 0x01, mapSize;
   ADDR address;
   BUS_EVENT testEvt;
   TRIGGER testTrig;
   U32 testStatusLow[TEST_ITEM]={0xA8,0xB8};
   U32 testStatusHigh[TEST_ITEM]={0xF8,0xF8};
   U8 i;

   EmuClrTrig(0); // clear all trigger.
   EmuClrEvent(0); // clear all event.
//   EmuSetTraceBuff(1);
   EmuSetMap(0,0,0); // map all external
   EmuGetMapSize();
   mapSize = *((U32 *)&outputStream[3]);
   EmuSetMap(0,mapSize-1,0x0f01); //  map all emm intetnal SP SD
   address.space = SPACE_SP;
   address.pos = 0x00000400 ;
   EmuSetMemN(&address,memData2,(U16)sizeof(memData2));
   EmuReadMemN(&address,(U32)sizeof(memData2)); // test memory write. template

   address.pos = 0 ;
   EmuSetMemN(&address,regData,(U16)sizeof(regData));

   EmuReset();

// setup event for testing
   memset(&testEvt,0,sizeof(BUS_EVENT));
   testEvt.enable = 0x8001;
   testEvt.statusFlag = 1;
   testEvt.addrSpec = 3;
   testEvt.dataSpec = 3;
   testEvt.addrRangeMask = 0xffffffffl;

// setup trigger for testing
   memset(&testTrig,0,sizeof(TRIGGER));
   testTrig.defined = 1;
   testTrig.ev[0] = 1;
   testTrig.act[0] = 0xC00;
   testTrig.mode = 1;
//   EmuSetTrig(1,1,&(testTrig.ev[0]),&(testTrig.act[0]),0);

// test 1 => data bus, 16 bits
// test 2 => addr bus, 24 bits
   address.pos = TEST_BKPT;
   EmuSetExBkpt(10,&address);

   for (i=0; i < TEST_ITEM; i++) {

      testEvt.status2.status2Low = testStatusLow[i];
      testEvt.status2.status2High = testStatusHigh[i];
      EmuSetEvent(1,(U8*)&testEvt);
      if (*(U16 *)&outputStream[0] != GOOD)
         return(TRACE_BOARD_FAIL); // EP stop, not ev10

      EmuSetTrig(1,1,&(testTrig.ev[0]),&(testTrig.act[0]),1);
      if (*(U16 *)&outputStream[0] != GOOD)
         return(TRACE_BOARD_FAIL); // EP stop, not ev10
      EmuSetReg(M68_REG,R_PC,0x0400);
      EmuGo(TEST_RUN);
      for (lp = 0; lp < 0xfff; lp++); //delay.
      status1 = GOOD;
      for (lp = 0; lp < 100; lp++) {
         EmuGetCpuStatus();
         if ((status1 = *(U16 *)&outputStream[0]) == BKPT1_HALT)
            break;
         if (outputStream[2])
            break; //ep stop. but not ev10
      }

      if (status1 != BKPT1_HALT) { // EP stop and ev10 match
         if (!outputStream[2])     // EP is running.
            EmuAbort();
         return(TRACE_BOARD_FAIL); // EP stop, not ev10
      }
      AccessIceFlag(READ_ONE,TRACED_BUFF_NO,&lastBufNo);
      if (lastBufNo != 0) return(TRACE_BOARD_FAIL);

      EmuGetTraceDepth(0);
      traceHead.traceBufId  = 0;
      traceHead.startFrame = startLogFrameOfTrcBuf[0];
      traceHead.traceform = CYCLE_LIST;
      condition.qFlag = NO;
      status = ListTraceBuffer(&traceHead,&condition,traceBuffData);
      tracePtr = traceBuffData;

      switch (i) {
      case 0: // data bus
         test16Bit = 0x01;
         tracePtr += 4;
         do {
            tmpData = ExchangeHighLow(*(U16 *)tracePtr);
            if ((tmpData & 0xffff) != test16Bit)
               return(TRACE_BOARD_FAIL);
            tracePtr += FRAME_WIDTH;
            test16Bit <<= 1;
         }while (test16Bit != 0x8000l);
         break;
      case 1: // addr bus
         test32Bit = 0x01;
         do {
            if ((*(U32 *)tracePtr & 0xffffffff) != test32Bit)
               return(TRACE_BOARD_FAIL);
            tracePtr += FRAME_WIDTH;
            test32Bit <<= 1;
         }while (test32Bit != 0x80000000l);
         break;
      default:;
      }
   }

//   status |= TestAddrOfVRAMs();
//   status |= TestSeqRAMs();
   Exbp1Disable();
   return(status);
}

/***************************************************************************
**
**
**
**  Description: Michelle main self-testing routine, to have the hidden
**
**  Parameters:
**     input:
**     output:
**        none
**
****************************************************************************/
STATUS HlTestTraceBoard(VOID) {
        return(GOOD);
}



/***************************************************************************
**
**  EmuFunctionTest
**
**  Description: Michelle main self-testing routine, to have the hidden
**               commands. Use the sw driver on the host site to drive
**               the fw function.
**               The driver will handle the input command format then
**               receive the result to perform with meaning.
**
**  Parameters:
**     input:
**        cmdId --
**     output:
**        none
**
****************************************************************************/
STATUS EmuFunctionTest(U16 cmdId) {
   U16 status = GOOD;
   U32 baseReg[BASE_REG_NO];
   U16 emmSize,lp,lp2;
   U32 pcReg, opcReg, maxAddr, maxAddrLen ;
   U8 *tmpTrigPtr;
   STATIC MAP_INFO backupMap[MAX_MAP+1];
   STATIC U32 backupReg[BASE_REG_NO];
   STATIC BUS_EVENT backupBusEv[8];
   STATIC EXEC_EVENT backupExecEv[2];
   STATIC TRIGGER backupTrig[TRIG_NO];
   STATIC U16 readyFlag;
   U32 pcValue[] = {    0x000010, 0x000020, 0x000040, 0x000080,
                        0xF01000, 0xF02000, 0xF04000, 0xF08000 };

//   U8 regForTest[] = { 0x00, 0x01, 0xff, 0xf0,   // value of SSP
//                       0x00, 0x00, 0x04, 0x00 }; // value of PC
   U16 dataLen = (sizeof(pcValue)/sizeof(pcValue[0]));
   ADDR address;

   switch (cmdId) {
      case START_TEST :
         EmuGetMapTable(backupMap);
         AccessBaseReg(READ_ALL,noUse,backupReg);
         AccessExecEvent(READ_ALL,noUse,backupExecEv);
         if (mtatExist) {
            AccessBusEvent(READ_ALL,noUse,backupBusEv);
            EmuGetAllTrig();
            tmpTrigPtr = &(outputStream[3]);
            for (lp = 0; lp < TRIG_NO; lp++) {
                memcpy(&backupTrig[lp],tmpTrigPtr,sizeof(TRIGGER));
                tmpTrigPtr += sizeof(TRIGGER) ;
                tmpTrigPtr++;
            }
         }
         AccessIceFlag(READ_ONE,READY_FLAG,&readyFlag); // set Internal Ready
         ReadyInternal();                              // for DTACK signal
         break;
      case TRACE_BOARD :
         if (mtatExist) {
            if (TestTraceBoard()) status = TRACE_BOARD_FAIL;
         }
         else status = NO_TRACE_MODULE;
         break;
      case EMM1 :
         EmuSetMap(0,0,0);
         AccessIceFlag(READ_ONE,EMM_SIZE,&emmSize);
         address.space = SPACE_SD;
         if (emmSize == 0) {
            status = NO_EMM ;
            break;
         }
         else {
            switch (emmSize) {
               case 0x01 :
               case 0x10 :
                  maxAddr = 0x7FFFFul ;
                  maxAddrLen = 0x20000ul ;
                  break;
               case 2 :
                  maxAddr = 0xFFFFFul ;
                  maxAddrLen = 0x40000ul ;
                  break;
               case 0x03:
               case 0x11 :
                  maxAddr = 0x1FFFFFul ;
                  maxAddrLen = 0x80000ul ;
                  break;
               case 0x12 :
                  maxAddr = 0x3FFFFFul ;
                  maxAddrLen = 0x100000ul ;
                  break;
               case 0x13 :
                  maxAddr = 0x7FFFFFul ;
                  maxAddrLen = 0x200000ul ;
                  break;
            }
            EmuSetMap(0x0L,maxAddr,0x0f01);
      case EMM2 :
      case EMM3 :
      case EMM4 :
            if (cmdId == EMM1)
               address.pos = 0x100;
            else
               address.pos = (U32)((cmdId - EMM1)*maxAddrLen);
            EmuTest(&address,maxAddrLen);
            if (*(U16 *)&outputStream[0])
               status = EMM_FAIL;
         }
         break;
      case MCE16A :
         if (mtatExist) {
            EmuClrTrig(0);
            SetPhyTrig(TEST_RUN);
         }
         if (CanTest() || Reset(baseReg) || MapTest()) {
            status = MCE16A_FAIL;
            break;
         }

         EmuSetMap(0x0L,0x7FFFFL,0x0f01);
         address.space = SPACE_SP;
         for (lp = 0; lp < dataLen; lp++) {
            opcReg = pcReg = pcValue[lp];
            AccessBaseReg(WRITE_ONE,R_PC,&pcReg);
            address.pos = pcValue[lp];
            EmuSetExBkpt(10,&address);
            status = GOOD;
            EmuGo(TEST_RUN); // special run.
            for(lp2 = 0;lp2 < 100;lp2++) {
               EmuGetCpuStatus();
               if ((status = *(U16 *)&outputStream[0]) == BKPT1_HALT) break;
               if (outputStream[2])
                  break; //ep stop. but not ev10
            }

            if (status == BKPT1_HALT) { // EP stop and ev10 match
               AccessBaseReg(READ_ONE,R_PC,&pcReg);
               status = GOOD;
               if (pcReg != opcReg) {
                  status = MCE16A_FAIL;
                  break;
               }
            }
            else if (!outputStream[2]) { // EP is running.
               EmuAbort();
               status = MCE16A_FAIL+1;
               break;
            }
            else {
               status = MCE16A_FAIL+2; // EP stop, not ev10
               break;
            }
         }
         Exbp1Disable();

         break;
      case COV_RBW_MEMORY :
         if (CovMapTest() || InitRecRam())
            status = COV_RBW_FAIL;
         break;
      case END_TEST :
         EmuSetMap(0,0,0);
         for ( lp = 0; lp < MAX_MAP; lp++) {
            if (backupMap[lp].startAddr != BUTTOM_NULL)
               EmuSetMap(backupMap[lp].startAddr,backupMap[lp].endAddr,backupMap[lp].attr);
         }
         if (mtatExist) {
            for (lp = 0; lp < TRIG_NO-1 ; lp++) {
               EmuSetTrig(0,lp+1,backupTrig[lp].ev,backupTrig[lp].act,backupTrig[lp].mode);
            }
            SetPhyTrig(NORMAL_RUN);
            AccessBusEvent(WRITE_ALL,noUse,backupBusEv);   // recover event
         }
         AccessExecEvent(WRITE_ALL,noUse,backupExecEv);
         AccessBaseReg(WRITE_ALL,noUse,backupReg);
         if (readyFlag == 0)
            ReadyInternal();
         else
            ReadyExternal();
         OutputStatus(status,ON);
         return(status);
   }
//   EmuSetMap(0,0,0);
   OutputStatus(status,ON);
   return(status);
}

/***************************************************************************
**
**  EmuDiagnostic
**
**  Description: Michelle main self-testing routine, to have the hidden
**               commands. Use the sw driver on the host site to drive
**               the fw function.
**               The driver will handle the input command format then
**               receive the result to perform with meaning.
**
**  Parameters:
**     input:
**        cmdId --
**     output:
**        none
**
****************************************************************************/
#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))
VOID EmuDiagnostic(VOID) {
   U8 brokeData[10],lp;
   U32 dataAddress;

   OutputStatus(GOOD,ON);
   TransmitStream();
   outp(MCR,0);
   dataAddress = (U32)FP_SEG(brokeData) << 4 + FP_OFF(brokeData);

   for (lp =0; lp < 10; lp++)
      brokeData[lp] = 0;

   outp(P82552B,((U8)inp(P82552B) | 0X10)); //set WRPRAM=H to write Program RAM
   outp(DMA1SL,LowWord(dataAddress));
   outp(DMA1SH,HighWord(dataAddress));
   outp(DMA1DL,0x400);
   outp(DMA1DH,0);
   outp(DMA1TC,10);
   outp(DMA1CW,0xB626);
   outp(P82552B,((U8)inp(P82552B) & 0XEF)); //set WRPRAM=L to write protected Program RAM

   FwReset();
}
/******************************** E O F ***********************************/
