/****************************************************************************
**
** Name: trcevent.h
**
** Description:
**   Bus event setting services header file
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcmtat2/m306/trcevent.h_v  $
** 
**    Rev 1.0   19 Mar 1997 15:31:54   gene
** Initial revision.
** 
**    Rev 1.3   10 Mar 1997 16:43:42   ibin
** 
**    Rev 1.0   10 May 1996 10:03:30   jacky
** Get file from ATL. V1.3
**
** $Header:   S:/tbird/arcmtat2/m306/trcevent.h_v   1.0   19 Mar 1997 15:31:54   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCEVENT_

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/
typedef enum { ADDR_FIELD, DATA_FIELD, STATUS_FIELD } EVENT_FIELD;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) ;
VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) ;
RETCODE ClearAllEvent(VOID) ;
/******************************************************************************
**
**  SetAllBusEvent
**
**  Description:
**
**
**  Parameters:
**    input:
**      events: pointer to event 0 structure and the following should
**              contain bus event 1, 2, 3, ... structure
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetAllBusEvent(BUS_EVENT *events);

/******************************************************************************
**
**  WriteSeqRAMs
**
**  Description:
**    Write state machine data to Sequential RAMs
**
**  Parameters:
**    input:
**      levelID: trigger level
**      data: pointer to the data written into Sequential RAMs
**    output:
**      none
**
*******************************************************************************/
RETCODE WriteSeqRAMs(U8 _far *data,U8 _far *buffer);

/********************************* EOF *************************************/
