/****************************************************************************
**
** Name: trclib.c
**
** Description:
**   Services for MTAT F/W
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcmtat2/m306/trclib.c_v  $
** 
**    Rev 1.0   19 Mar 1997 15:31:44   gene
** Initial revision.
** 
**    Rev 1.0   17 Feb 1997 10:00:46   ibin
** Initial revision.
** 
**    Rev 1.0   15 Nov 1996 18:40:02   gene
** Initial revision.
**
**    Rev 1.0   10 May 1996 10:04:36   jacky
** Get file from ATL. V1.3
**
** $Header:   S:/tbird/arcmtat2/m306/trclib.c_v   1.0   19 Mar 1997 15:31:44   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <dos.h>
#include <conio.h>

#ifndef _TRCLIB_
#include "trclib.h"
#endif

                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))

#define AIBOCI 0x99

/* I/O port address define */

#define pTM8255C  0xF162
#define pTM8255P  0xF163

#define pRpEREC1  0xF100

#define INIT_DATA_pTM8255B  0xEA
#define INIT_DATA_pNXCONFIG 0xB8

/* I/O port corresponding bit define */

#define bitNXRST1  0x01
#define bitNXRST2  0x02
#define bitNXRSTT  0x04

#define bitENPROGX 0x10

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

BOOLEAN mtatExist;
extern U8 mpNXCONFIG;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

RETCODE fmemtst(U8 _far *s, U16 len, U16 mask);

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

VOID Delay(U16 more) {
   register U16 i;

   for (i=0; i < more; i++);
}

RETCODE TestAddrOfVRAMs(VOID) {
   RETCODE err;
   U8 _far *addrDRAM = MK_FP(TMAN_SEG, 0);

   outp(pSEQENBWR, bitACTDIS);
   outp(pBANKWR, 0);
   if ((err = fmemtst(addrDRAM, 0x2000, 0x00FF)) != GOOD) return(err);
   return(GOOD);
}

RETCODE TestSeqRAMs(VOID) {
   RETCODE err;
   U8 _far *seqRAM0 = MK_FP(TMAN_SEG, SEQ_RAM0_OFFSET);
   U8 _far *seqRAM1 = MK_FP(TMAN_SEG, SEQ_RAM1_OFFSET);

   outp(pSEQENBWR, bitSEQENB);
   if ((err = fmemtst(seqRAM0, SEQ_RAM_SIZE, 0xFFFF)) != GOOD) return(0xFF00);
   if ((err = fmemtst(seqRAM1, SEQ_RAM_SIZE, 0xFFFF)) != GOOD) return(0xFF01);
   return(GOOD);
}

RETCODE fmemcmp(U8 _far *s, U8 _far *ct, U16 n) {

   return(GOOD);
}

VOID fmemcpy(U8 _far *s, U8 _far *ct, U16 n) {
   U16 srcSeg, srcOffset, dstSeg, dstOffset, count;

   srcSeg = FP_SEG(ct);
   srcOffset = FP_OFF(ct);
   dstSeg = FP_SEG(s);
   dstOffset = FP_OFF(s);
   count = n;
   _asm {
           pushf
           push  ds
           push  si
           push  es
           push  di
           push  cx
           cld
           mov   ds, srcSeg
           mov   si, srcOffset
           mov   es, dstSeg
           mov   di, dstOffset
           mov   cx, count
      rep  movsb
           pop   cx
           pop   di
           pop   es
           pop   si
           pop   ds
           popf
   }
}

RETCODE fmemtst(U8 _far *s, U16 len, U16 mask) {
   U8 _far *t, data, loAddr, hiAddr;
   U16 i, bit;

   t = s;
   i = len;
   do {
      bit = 1 << (((U8) ((U32) t)) & 0x0F);
      if (mask & bit) {
         loAddr = (U8) ((U32) t);
         hiAddr = (U8) (((U16) ((U32) t)) >> 8);
         data = loAddr ^ hiAddr;
         *t = data;
         if (*t != data) return(1);
         *t = (U8) ~data;
      }
   } while ((--i != 0) && (((U16) ((U32) (++t))) != 0));
   t = s;
   i = len;
   do {
      bit = 1 << (((U8) ((U32) t)) & 0x0F);
      if (mask & bit) {
         loAddr = (U8) ((U32) t);
         hiAddr = (U8) (((U16) ((U32) t)) >> 8);
         data = loAddr ^ hiAddr;
         if (*t != (U8) ~data) return(2);
      }
   } while ((--i != 0) && (((U16) ((U32) (++t))) != 0));
   return(GOOD);
}

/********************************* EOF *************************************/
