/***************************************************************************
**
** Name: trctest.c
**
** Description:
**   Test trace memory
**
** Copyright (C) 1996 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <conio.h>
#include <dos.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

#ifndef _TRCFLEX_
#include "trcflex.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

#ifndef _TRCDIAG_
#include "trctest.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif

                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/

typedef enum { RS_TBUF,TU_TBUF,VW_TBUF,TS_TBUF,TP_TBUF} TBuffer_TYPE;

#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define NPACS       0xFFA4
#define NMPCS       0xFFA8
#define RWTrig     0xF32C

#define Rport       0x00
#define Sport       0x01
#define Tport       0x02
#define Uport       0x03
#define Vport       0x04
#define Wport       0x05

#define ChgWr      0xF338
#define EnBCWr     0x20
#define Done       0x80

#define SEQ       0x04
#define DOE       0x02
#define BCK       0x01

#define MNCtrlAX   0xF32D
#define MNCtrlAY   0xF32E
#define MNCtrlB    0xF32F

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04
#define FSld           0x01

/* MAIN control port corresponding bit define */

#define TOnFly         0x01

/* P0 port address define */

#define WriteP0Byte1    0xF300
#define WriteP0Byte2    0xF301
#define WriteP0Byte3    0xF302
#define WriteP0Byte4    0xF303
#define ReadP0CtrlPort  0xF304
#define P0CtrlPort      0xF307

/* P1 port address define */

#define WriteP1Byte1    0xF308
#define WriteP1Byte2    0xF309
#define WriteP1Byte3    0xF30A
#define WriteP1Byte4    0xF30B
#define ReadP1CtrlPort  0xF30C
#define P1CtrlPort      0xF30F

/* P2 port address define */

#define WriteP2Byte1    0xF310
#define WriteP2Byte2    0xF311
#define WriteP2Byte3    0xF312
#define WriteP2Byte4    0xF313
#define ReadP2CtrlPort  0xF314
#define P2CtrlPort      0xF317

/* P3 port address define */

#define WriteP3Byte1    0xF318
#define WriteP3Byte2    0xF319
#define WriteP3Byte3    0xF31A
#define WriteP3Byte4    0xF31B
#define ReadP3CtrlPort  0xF31C
#define P3CtrlPort      0xF31F

/* P4 port address define */

#define P4CtrlAX       0xF325
#define P4CtrlAY       0xF326
#define P4CtrlB        0xF327

U8 _based(_segname("_CODE")) MNTestByte[] = {
#include "testsram.ttf"
};

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern U8  _far PIOByte[];
extern U8  _far MNTraceByte[];
extern U8  _far MNCPRWByte[];
extern U8  _far P4PIOByte[];
extern U8  _far P4PIPEByte[];
extern U8  trigBuf[4][0x800][2];
extern U8  _far SeqRamBuf[0x4000];
extern U8  FLEXConfig ;
extern U8  AdderBusWidth;
extern U32 TrcBufSize;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

RETCODE RdBC(U8 port) ;
RETCODE TestTrcBuf(U16 addr,TBuffer_TYPE type) ;
U16 RdBCOneAddr(U8 port,U16 addr) ;
VOID SetP0toP4(U8 data);
RETCODE WriteTrigRAMs(U8 _far *data,U8 _far *buffer) ;
                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/******************************************************************************
**
** TestSeqRAM
**
*******************************************************************************/
RETCODE TestSeqRAM(VOID)  {
   RETCODE err;
   U8 j,temp1,temp2;
   U16 i,k,data;

   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);

   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= SMain ;
   }

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   for(i=0;i<=13;i++) {
      data = (0x01 << i);
      for (k=0;k<2;k++) {
         data ^= 0x3FFF;
         outp(MNCtrlAX,BCK);   //Enable MN Output enable
         outp(MNCtrlAX,DOE);
         outp(P4CtrlAX,0x01) ;  //Enable Trigger SSRAM nGW
         outp(0xF32C,(U8) (data >> 8));
         outp(0xF32C,(U8) data) ;
         outp(P4CtrlAX,0) ;  //Disable Trigger SSRAM nGW
         outp(MNCtrlAX,BCK);
         outp(MNCtrlAX,0) ;  //Disable MN Output enable
         outp(P4CtrlAX,0x08) ;  //Enable Trigger SSRAM nOE
         temp1 = (U8)inp(0xF32C);
         temp2 = (U8)inp(0xF32C);
         if ((temp1 != (U8)(data >> 8)) || ( temp2 != (U8) data)) {
         err = ERR_TRIG;
         }
      }
   }
   if (err) return(err);
   k=0;
   for (j=0;j<4;j++) {
      for (i=0;i<0x800;i++) {
            trigBuf[j][i][0] = (U8) k;
            trigBuf[j][i][1] = (U8) (k >> 8);
            k++;
      }
   }
   if((err = WriteTrigRAMs((U8 _far *)&(trigBuf[3][0x800-1][1]),
                 (U8 _far *)&(SeqRamBuf[0]))) != GOOD)
      return(err);

   return(GOOD);
}

RETCODE WriteTrigRAMs(U8 _far *data,U8 _far *buffer) {
   U16 i,srcOffset,desOffset;
   U32 srcSeg,srcPointer,desSeg,desPointer,j;
   RETCODE err;

   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig |= SMain ;
   }

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   srcSeg = FP_SEG(data);
   srcOffset = FP_OFF(data);
   srcPointer = (srcSeg << 4) + srcOffset ;

   desSeg = FP_SEG(buffer);
   desOffset = FP_OFF(buffer);
   desPointer = (desSeg << 4) + desOffset ;

   outp(P4CtrlAX,0x01) ;  //Enable Trigger SSRAM nGW

   outp(MNCtrlAX,BCK);   //Enable MN Output enable
   outp(MNCtrlAX,DOE);

   for(j=0;j<0xFF;j++) {
   outpw(DMA1SL,(U16) srcPointer);    // Enable DMA Write Trigger SSRAM
   outpw(DMA1SH,(U16) (srcPointer >> 16));
   outpw(DMA1DL,RWTrig);
   outpw(DMA1DH,0);
   outpw(DMA1TC,0x4000);
   outpw(DMA1CW,0x7A27);

   outp(P4CtrlAX,0) ;  //Disable Trigger SSRAM nGW
   outp(P4CtrlAX,0x08) ;  //Enable Trigger SSRAM nOE

   outpw(DMA1SL,RWTrig);    // Enable DMA Read Trigger SSRAM
   outpw(DMA1SH,0);
   outpw(DMA1DL,(U16) desPointer);
   outpw(DMA1DH,(U16) (desPointer >> 16));
   outpw(DMA1TC,0x4000);
   outp(MNCtrlAX,BCK);
   outp(MNCtrlAX,0) ;  //Disable MN Output enable
   inp(RWTrig);        // Dummy read
   inp(RWTrig);
   outpw(NPACS,0x0F38);
   outpw(NMPCS,0xC0B8);
   outpw(DMA1CW,0xAE27);
   outpw(NPACS,0x0F3F);
   outpw(NMPCS,0xC0BF);

   for (i=0 ; i<= 0x3FFF ; i++)
       if(*(data-i) != *(buffer+i) ) return(ERR_TRIG) ;
   return(GOOD);
   }
}
/******************************************************************************
**
** TestRSTrcBufDataBus
**
*******************************************************************************/
RETCODE TestRSTrcBufDataBus(U32 *ptr) {
   RETCODE err;
   U16 i,j;
   U32 data,errdata = 0;

   if ((FLEXConfig & P4Pio ) != P4Pio ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P4Pio ;
   }
   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }
   if((err =  FLEXProgram(FLEX_MN,MNTestByte)) != GOOD ) return(err);


   outp(FClkSel0,0x80);    // Change FCLK2/FCLK3 TO CPCLK
   outp(FClkSel1,0);

   outpw(0xF328,0x5A5A); // Set trace address

   for (i=0;i<32;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP0Byte1,(U16) data);
         outpw(WriteP0Byte3,(U16) (data >> 16));
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         if ( ((U16) data != inpw(WriteP0Byte1)) || ((U16) (data >> 16) !=
              inpw(WriteP0Byte3))) {
            err = ERR_TRCBUF_BUS;
            errdata |= (0x01 << i) ;
         }
      }
   }
   (U32) *ptr = errdata ;
   return(err);
}


/******************************************************************************
**
** TestTUTrcBufDataBus
**
*******************************************************************************/
RETCODE TestTUTrcBufDataBus(U32 *ptr) {
   RETCODE err = GOOD;
   U16 i,j;
   U32 data,errdata = 0;

   outpw(0xF328,0x5A5A); // Set trace address

   for (i=0;i<32;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP1Byte1,(U16) data);
         outpw(WriteP1Byte3,(U16) (data >> 16));
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         if ( ((U16) data != inpw(WriteP1Byte1)) || ((U16) (data >> 16) !=
              inpw(WriteP1Byte3))) {
            err = ERR_TRCBUF_BUS ;
            errdata |= (0x01 << i) ;
         }
      }
   }
   (U32) *ptr = errdata ;
   return(err);
}

/******************************************************************************
**
** TestTPTrcBufDataBus
**
*******************************************************************************/
RETCODE TestTPTrcBufDataBus(U32 *ptr) {
   RETCODE err = GOOD;
   U16 i,j;
   U32 data,errdata = 0;

   outpw(0xF328,0x5A5A); // Set trace address

   for (i=0;i<32;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP3Byte1,(U16) data);
         outpw(WriteP3Byte3,(U16) (data >> 16));
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         if ( ((U16) data != inpw(WriteP3Byte1)) || ((U16) (data >> 16) !=
              inpw(WriteP3Byte3))) {
            err = ERR_TRCBUF_BUS;
            errdata |= (0x01 << i) ;
         }
      }
   }
   (U32) *ptr = errdata ;
   return(err);
}
/******************************************************************************
**
** TestVWTrcBufDataBus
**
*******************************************************************************/
RETCODE TestVWTrcBufDataBus(U32 *ptr) {
   RETCODE err = GOOD;
   U16 i,j;
   U32 data,errdata = 0;

   outpw(0xF328,0x5A5A); // Set trace address

   for (i=0;i<32;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outp(0xF32F,0);
         outp(WriteP2Byte1,(U8) data);
         outpw(WriteP2Byte3,(U16) (data << 8));
         outp(0xF32A,(U8) (data<< 24));
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         outp(0xF32F,1);
         if (((U8) data != (U8) inp(WriteP2Byte1)) || ((U16) (data << 8) !=  inpw(WriteP2Byte3))
            || ((U8) (data<< 24) != (U8) inp(0xF328) )){
            err = ERR_TRCBUF_BUS;
            errdata |= (0x01 << i) ;
         }
      }
   }
   (U32) *ptr = errdata ;
   return(err);
}

/******************************************************************************
**
** TestTSTrcBufDataBus
**
*******************************************************************************/
RETCODE TestTSTrcBufDataBus(U32 *ptr) {
   RETCODE err = GOOD;
   U16 i,j;
   U32 data,errdata = 0;

   outpw(0xF328,0x5A5A); // Set trace address

   for (i=0;i<32;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outp(0xF32F,0);
         outpw(0xF32B,(U16) data);
         outpw(0xF32D,(U16) (data >> 16));
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         outp(0xF32F,1);
         if ( ((U16) data != inpw(0xF329)) || ((U16) (data >> 16) != inpw(0xF32B))) {
            err = ERR_TRCBUF_BUS;
            errdata |= (0x01 << i) ;
         }
      }
   }
   (U32) *ptr = errdata ;
   return(err);
}
/******************************************************************************
**
** TestEventTrcBufDataBus
**
*******************************************************************************/
RETCODE TestEventTrcBufDataBus(U32 *ptr) {
   RETCODE err = GOOD;
   U16 i,j;
   U32 data,errdata = 0;

   outpw(0xF328,0x5A5A); // Set trace address

   for (i=0;i<8;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outp(0xF320,(U8) data);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         if ( (U8)data != (U8)inp(0xF327) ) {
            err = ERR_TRCBUF_BUS ;
            errdata |= (0x01 << i) ;
         }
      }
   }
   for (i=0;i<4;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outp(0xF321,(U8) data);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         data &= 0x0F;
         if ( (U8)data != (U8)inp(0xF326) ) {
            err = ERR_TRCBUF_BUS ;
            errdata |= (0x01 << (i+8)) ;
         }
      }
   }
   for (i=0;i<3;i++) {
      data = (0x01 << i);
      for (j=0;j<2;j++) {
         data ^= 0xFFFF;
         data &= 0x06;
         SetP0toP4(nOEA);
         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outp(0xF32F,(U8) data);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
         SetP0toP4(0);
         outp(0xF32F,1);
         outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
         if ( (U8)data != (U8)(inp(0xF32D) << 1)) {
            err = ERR_TRCBUF_BUS ;
            errdata |= (0x01 << (i+12)) ;
         }
      }
   }
   (U32) *ptr = errdata ;
   return(err);
}





/******************************************************************************
**
** TestRSTrcBufAddrBus
**
*******************************************************************************/
RETCODE TestRSTrcBufAddrBus(U32 *ptr) {
   RETCODE Errflag = GOOD;
   U32 TAByte,errdata = 0;
   U8  i;

   outp(P4CtrlAX,0);   //Disable TRCM Output enable
   SetP0toP4(nOEA);

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
      outpw(WriteP0Byte1,(U16) TAByte);
      outpw(WriteP0Byte3,(U16) TAByte);
      outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   }

   SetP0toP4(0);
   outp(P4CtrlAX,nOETRCM);  //Enable TRCM Output enable

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      if ( ((U16) TAByte != inpw(WriteP0Byte1)) ||
           ((U16) TAByte != inpw(WriteP0Byte3)) ) {
           Errflag = ERR_TRCBUF_BUS;
           break;
      }
   }
   if (Errflag) {
      outp(P4CtrlAX,0);   //Disable TRCM Output enable
      SetP0toP4(nOEA);
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP0Byte1,(U16) i);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
      }
      SetP0toP4(0);
      outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         if ((U16) i != inpw(WriteP0Byte1))
            errdata |= (0x01 << i) ;
      }
   }
   *ptr = errdata ;
   return(Errflag);
}

/******************************************************************************
**
** TestTUTrcBufAddrBus
**
*******************************************************************************/
RETCODE TestTUTrcBufAddrBus(U32 *ptr) {
   RETCODE Errflag = GOOD;
   U32 TAByte;
   U32 errdata = 0;
   U8  i;

   outp(P4CtrlAX,0);   //Disable TRCM Output enable
   SetP0toP4(nOEA);

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
      outpw(WriteP1Byte1,(U16) TAByte);
      outpw(WriteP1Byte3,(U16) TAByte);
      outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   }

   SetP0toP4(0);
   outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      if ( ((U16) TAByte != inpw(WriteP1Byte1)) ||
           ((U16) TAByte != inpw(WriteP1Byte3)) )  {
           Errflag = ERR_TRCBUF_BUS ;
           break;
      }
   }
   if (Errflag) {
      outp(P4CtrlAX,0);   //Disable TRCM Output enable
      SetP0toP4(nOEA);
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP1Byte1,(U16) i);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
      }
      SetP0toP4(0);
      outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         if ((U16) i != inpw(WriteP1Byte1))
            errdata |= (0x01 << i) ;
      }
   }
   *ptr = errdata ;
   return(Errflag);
}
/******************************************************************************
**
** TestTPTrcBufAddrBus
**
*******************************************************************************/
RETCODE TestTPTrcBufAddrBus(U32 *ptr) {
   RETCODE Errflag = GOOD;
   U32 TAByte;
   U32 errdata = 0;
   U8  i;

   outp(P4CtrlAX,0);   //Disable TRCM Output enable
   SetP0toP4(nOEA);

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
      outpw(WriteP3Byte1,(U16) TAByte);
      outpw(WriteP3Byte3,(U16) TAByte);
      outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   }

   SetP0toP4(0);
   outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      if ( ((U16) TAByte != inpw(WriteP3Byte1)) ||
           ((U16) TAByte != inpw(WriteP3Byte3)) ) {
           Errflag = ERR_TRCBUF_BUS ;
           break;
      }
   }
   if (Errflag) {
      outp(P4CtrlAX,0);   //Disable TRCM Output enable
      SetP0toP4(nOEA);
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP3Byte1,(U16) i);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
      }
      SetP0toP4(0);
      outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         if ((U16) i != inpw(WriteP3Byte1))
            errdata |= (0x01 << i) ;
      }
   }
   *ptr = errdata ;
   return(Errflag);
}
/******************************************************************************
**
** TestVWTrcBufAddrBus
**
*******************************************************************************/
RETCODE TestVWTrcBufAddrBus(U32 *ptr) {
   RETCODE Errflag = GOOD;
   U32 TAByte;
   U32 errdata = 0;
   U8  i;

   outp(P4CtrlAX,0);   //Disable TRCM Output enable
   SetP0toP4(nOEA);

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
      outp(WriteP2Byte1,(U8) TAByte);
      outpw(WriteP2Byte3,(U16) TAByte);
      outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   }

   SetP0toP4(0);
   outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      if (((U8) TAByte != (U8) inp(WriteP2Byte1)) ||
          ((U16) TAByte  !=  inpw(WriteP2Byte3))) {
           Errflag = ERR_TRCBUF_BUS ;
           break;
      }
   }
   if (Errflag) {
      outp(P4CtrlAX,0);   //Disable TRCM Output enable
      SetP0toP4(nOEA);
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(WriteP3Byte1,(U16) i);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
      }
      SetP0toP4(0);
      outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         if ((U16) i != inpw(WriteP3Byte1))
            errdata |= (0x01 << i) ;
      }
   }
   *ptr = errdata ;
   return(Errflag);
}

/******************************************************************************
**
** TestTSTrcBufAddrBus
**
*******************************************************************************/
RETCODE TestTSTrcBufAddrBus(U32 *ptr) {
   RETCODE Errflag = GOOD;
   U32 TAByte;
   U32 errdata = 0;
   U8  i;

   outp(P4CtrlAX,0);   //Disable TRCM Output enable
   SetP0toP4(nOEA);

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x80);
      else outp(0xf32F,0);
      outpw(0xf328,(U16) TAByte);

      outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
      outpw(0xF32B,(U16) TAByte);
      outpw(0xF32D,(U16) TAByte);
      outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
   }

   SetP0toP4(0);
   outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable

   for(TAByte=0;TAByte <= (U32) (TrcBufSize);TAByte++) {
      if (TAByte > 0xFFFF ) outp(0xf32F,0x81);
      else outp(0xf32F,1);
      outpw(0xf328,(U16) TAByte);

      if ( ((U16) TAByte != inpw(0xF329)) ||
           ((U16) TAByte != inpw(0xF32B))) {
           Errflag = ERR_TRCBUF_BUS ;
           break;
      }
   }
   if (Errflag) {
      outp(P4CtrlAX,0);   //Disable TRCM Output enable
      SetP0toP4(nOEA);
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         outpw(0xF32B,(U16) i);
         outp(P4CtrlAX,0);   //Disable TRCM Byte write enable
      }
      SetP0toP4(0);
      outp(P4CtrlAX,nOETRCM );  //Enable TRCM Output enable
      for (i=0;i < AdderBusWidth;i++) {

         TAByte = (U16) (0x01 <<i);
         outpw(0xf328,(U16) TAByte);

         outp(P4CtrlAX,0xF1);   //Enable TRCM Byte write enable
         if ((U16) i != inpw(0xF329))
            errdata |= (0x01 << i) ;
      }
   }
   *ptr = errdata ;
   return(Errflag);
}

/******************************************************************************
**
** TestRportDataBus
**
*******************************************************************************/
RETCODE TestRportDataBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,i,data = 0x01;
   U32 errdata=0;

   if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
   FLEXConfig &= P4Pipe ;
   if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
   FLEXConfig |= P0Pio ;
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   FLEXConfig |= SMain ;

   outp(FClkSel0,0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   for (i=0;i <= 15;i++) {
      WrBCOneAddr(Rport,0xA5A5,0xFFFF,(U16) ~(data << i),0);
      temp = RdBCOneAddr(Rport,0xA5A5);
      if (temp != (U16) ~(data << i)) ErrFlag = TRUE ;
      WrBCOneAddr(Rport,0xA5A5,0xFFFF,(U16) (data << i),0);
      temp = RdBCOneAddr(Rport,0xA5A5);
      if ( (temp != (U16) (data << i)) || (ErrFlag == TRUE) ) {
         ErrFlag = ERR_BC_BUS;
         errdata |= (data << i) ;
      }
   }
   *ptr = errdata;
   return(ErrFlag);
}
/******************************************************************************
**
** TestSportDataBus
**
*******************************************************************************/
RETCODE TestSportDataBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,i,data = 0x01;
   U32 errdata = 0;

   outp(LA0A1nOE,0x80);

   for (i=0;i <= 15;i++) {
      WrBCOneAddr(Sport,0xA5A5,0xFFFF,(U16) ~(data << i),0);
      temp = RdBCOneAddr(Sport,0xA5A5);
      if (temp != (U16) ~(data << i)) ErrFlag = TRUE ;
      WrBCOneAddr(Sport,0xA5A5,0xFFFF,(U16) (data << i),0);
      temp = RdBCOneAddr(Sport,0xA5A5);
      if ( (temp != (U16) (data << i)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << i) ;
      }
   }
   outp(LA0A1nOE,0);
   *ptr = errdata;
   return(err);
}

/******************************************************************************
**
** TestTportDataBus
**
*******************************************************************************/
RETCODE TestTportDataBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 i,data = 0x01;
   U32 errdata = 0;
   U16 temp;

   for (i=0;i <= 7;i++) {
      WrBCOneAddr(Tport,0x5a5a,0xFFFF,(U8) ~(data << i),0);
      temp = RdBCOneAddr(Tport,0x5a5a);
      if (temp != (U8) ~(data << i)) ErrFlag = TRUE ;
      WrBCOneAddr(Tport,0x5a5a,0xFFFF,(U8) (data << i),0);
      temp = RdBCOneAddr(Tport,0x5a5a);
      if ( (temp != (U8) (data << i)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << i) ;
      }
   }
   *ptr = errdata;
   return(err);
}

/******************************************************************************
**
** TestUportDataBus
**
*******************************************************************************/
RETCODE TestUportDataBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 i,data = 0x01;
   U32 errdata = 0;
   U16 temp;

   for (i=0;i <= 7;i++) {
      WrBCOneAddr(Uport,0xA5A5,0xFFFF,(U8) ~(data << i),0);
      temp = RdBCOneAddr(Uport,0xA5A5);
      if (temp != (U8) ~(data << i)) ErrFlag = TRUE ;
      WrBCOneAddr(Uport,0xA5A5,0xFFFF,(U8) (data << i),0);
      temp = RdBCOneAddr(Uport,0xA5A5);
      if ( (temp != (U8) (data << i)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << i) ;
      }
   }
   *ptr = errdata;
   return(err);
}

/******************************************************************************
**
** TestVportDataBus
**
*******************************************************************************/
RETCODE TestVportDataBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 i,data = 0x01;
   U32 errdata = 0;
   U16 temp;

   for (i=0;i <= 7;i++) {
      WrBCOneAddr(Vport,0xA5A5,0xFFFF,(U8) ~(data << i),0);
      temp = RdBCOneAddr(Vport,0xA5A5);
      if (temp != (U8) ~(data << i)) ErrFlag = TRUE ;
      WrBCOneAddr(Vport,0xA5A5,0xFFFF,(U8) (data << i),0);
      temp = RdBCOneAddr(Vport,0xA5A5);
      if ( (temp != (U8) (data << i)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << i) ;
      }
   }
   *ptr = errdata;
   return(err);
}

/******************************************************************************
**
** TestWportDataBus
**
*******************************************************************************/
RETCODE TestWportDataBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 i,data = 0x01;
   U32 errdata = 0;
   U16 temp;

   for (i=0;i <= 7;i++) {
      WrBCOneAddr(Wport,0xA5A5,0xFFFF,(U8) ~(data << i),0);
      temp = RdBCOneAddr(Wport,0xA5A5);
      if (temp != (U8) ~(data << i)) ErrFlag = TRUE ;
      WrBCOneAddr(Wport,0xA5A5,0xFFFF,(U8) (data << i),0);
      temp = RdBCOneAddr(Wport,0xA5A5);
      if ( (temp != (U8) (data << i)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << i) ;
      }
   }
   *ptr = errdata;
   return(err);
}

/******************************************************************************
**
** TestRportAddrBus
**
*******************************************************************************/
RETCODE TestRportAddrBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,j,data = 0x01;
   U32 errdata = 0;


   WrBCMaskAddr(Rport,0,0,0,0xFFFF,0);
   for (j=0;j<=15;j++) {
      WrBCOneAddr(Rport,(U16) (data << j),0xFFFF,(U16) (data << j),0);
      WrBCOneAddr(Rport,(U16) ~(data << j),0xFFFF,(U16) ~(data << j),0);
   }
   for (j=0;j<=15;j++) {
      temp = RdBCOneAddr(Rport,(U16) (data << j));
      if( temp != (U16) (data << j)) ErrFlag = TRUE ;
      temp = RdBCOneAddr(Rport,(U16) ~(data << j));
      if ( (temp != (U16) ~(data << j)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << j) ;
      }
   }
   *ptr = errdata;
   return(err);
}
/******************************************************************************
**
** TestSportAddrBus
**
*******************************************************************************/
RETCODE TestSportAddrBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,j,data = 0x01;
   U32 errdata = 0;
   U32 i;

   outp(LA0A1nOE,0x80);
   WrBCMaskAddr(Sport,0,0,0,0xFFFF,0);

   for (i=0;i<=0xFFFF;i++)
      WrBCOneAddr(Sport,(U16) i,0xFFFF,(U16) i,0);

   if ((err = RdBC(Sport)) != GOOD) return(err);



   for (j=0;j<=15;j++) {
      WrBCOneAddr(Sport,(U16) (data << j),0xFFFF,(U16) (data << j),0);
      WrBCOneAddr(Sport,(U16) ~(data << j),0xFFFF,(U16) ~(data << j),0);
   }
   for (j=0;j<=15;j++) {
      temp = RdBCOneAddr(Sport,(U16) (data << j));
      if( temp != (U16) (data << j)) ErrFlag = TRUE ;
      temp = RdBCOneAddr(Sport,(U16) ~(data << j));
      if ( (temp != (U16) ~(data << j)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << j) ;
      }
   }
   outp(LA0A1nOE,0);
   *ptr = errdata;
   return(err);
}
/******************************************************************************
**
** TestTportAddrBus
**
*******************************************************************************/
RETCODE TestTportAddrBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,j,data = 0x01;
   U32 errdata = 0;
   U32 i;


   WrBCMaskAddr(Tport,0,0,0,0xFFFF,0);

   for (i=0;i<=0xFFFF;i++) {
      j = (U8) (i >> 8);
      WrBCOneAddr(Tport,(U16) i,0xFFFF,(U8) ((U8) i + j),0);
   }
   if ((err = RdBC(Tport)) != GOOD) return(err);



   for (j=0;j<=15;j++) {
      WrBCOneAddr(Tport,(U16) (data << j),0xFFFF,j,0);
      WrBCOneAddr(Tport,(U16) ~(data << j),0xFFFF,~j,0);
   }
   for (j=0;j<=15;j++) {
      temp = RdBCOneAddr(Tport,(U16) (data << j));
      if( temp != j) ErrFlag = TRUE ;
      temp = RdBCOneAddr(Tport,(U16) ~(data << j));
      if ( (temp != (U8) (~j) ) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << j) ;
      }
   }
   *ptr = errdata;
   return(err);
}

/******************************************************************************
**
** TestUportAddrBus
**
*******************************************************************************/
RETCODE TestUportAddrBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,j,data = 0x01;
   U32 errdata = 0;


   WrBCMaskAddr(Uport,0,0,0,0xFFFF,0);
   for (j=0;j<=15;j++) {
      WrBCOneAddr(Uport,(U16) (data << j),0xFFFF,j,0);
      WrBCOneAddr(Uport,(U16) ~(data << j),0xFFFF,~j,0);
   }
   for (j=0;j<=15;j++) {
      temp = RdBCOneAddr(Uport,(U16) (data << j));
      if( temp != j) ErrFlag = TRUE ;
      temp = RdBCOneAddr(Uport,(U16) ~(data << j));
      if ( (temp != (U8) (~j)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << j) ;
      }
   }
   *ptr = errdata;
   return(err);
}
/******************************************************************************
**
** TestVportAddrBus
**
*******************************************************************************/
RETCODE TestVportAddrBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,j,data = 0x01;
   U32 errdata = 0;


   WrBCMaskAddr(Vport,0,0,0,0xFFFF,0);
   for (j=0;j<=15;j++) {
      WrBCOneAddr(Vport,(U16) (data << j),0xFFFF,j,0);
      WrBCOneAddr(Vport,(U16) ~(data << j),0xFFFF,~j,0);
   }
   for (j=0;j<=15;j++) {
      temp = RdBCOneAddr(Vport,(U16) (data << j));
      if( temp != j) ErrFlag = TRUE ;
      temp = RdBCOneAddr(Vport,(U16) ~(data << j));
      if ( (temp != (U8) ~(j)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << j) ;
      }
   }
   *ptr = errdata;
   return(err);
}
/******************************************************************************
**
** TestWportAddrBus
**
*******************************************************************************/
RETCODE TestWportAddrBus(U32 *ptr)  {
   RETCODE err = GOOD,ErrFlag = GOOD;
   U16 temp,j,data = 0x01;
   U32 errdata = 0;


   WrBCMaskAddr(Wport,0,0,0,0xFFFF,0);
   for (j=0;j<=7;j++) {
      WrBCOneAddr(Wport,(U8) (data << j),0xFFFF,j,0);
      WrBCOneAddr(Wport,(U8) ~(data << j),0xFFFF,~j,0);
   }
   for (j=0;j<=7;j++) {
      temp = RdBCOneAddr(Wport,(U8) (data << j));
      if( temp != j) ErrFlag = TRUE ;
      temp = RdBCOneAddr(Wport,(U8) ~(data << j));
      if ( (temp != (U8) ~(j)) || (ErrFlag == TRUE) ) {
         err = ERR_BC_BUS;
         ErrFlag = FALSE;
         errdata |= (data << j) ;
      }
   }
   *ptr = errdata;
   return(err);
}


RETCODE RdBC(U8 port) {
   U16 readaddr1,CtrlPort,ReadCtrlPort,WrByte1,WrByte2,WrByte3,WrByte4,nOE;
   S32 i;
   U8  addrcnt,k;
   U16 j,tempa;
   RETCODE err;
   struct {
      U16 adder,data;
   } aa[20];

   if((err =  FLEXProgram(FLEX_MN,MNTestByte)) != GOOD ) return(err);
   switch (port) {
      case Rport :
         readaddr1 = 0xF328;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEX;
         break;
      case Sport :
         readaddr1 = 0xF32A;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEY;
         break;
      case Tport :
         readaddr1 = 0xF32C;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEX;
         break;
      case Uport :
         readaddr1 = 0xF32D;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEY;
         break;
      case Vport :
         readaddr1 = 0xF32E;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEX;
         break;
      case Wport :
         readaddr1 = 0xF32F;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEY;
         break;
   }

   for (j=0;j<=10;j++) {
       aa[j].adder = 0;
       aa[j].data = 0;
   }
   j=0;

   outp(CtrlPort,FSld);
   outpw(WrByte1,0xFFFF);
   switch (port) {
      case Rport : case Sport :
         for (i = 0xFFFF; i > 0;i--)  {
            outp(CtrlPort,0);
            outpw(WrByte1,(U16) i);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = inpw(readaddr1);
//          tempb = (U8) inp(readaddr1+addrcnt);
            if ( tempa != (U16) i)  {
               aa[j].adder = (U16) i;
               aa[j].data = tempa;
               j++;
               if (j > 19) j = 0;
            }
         }
      break;
      case Tport : case Uport : case Vport :
         for (i = 0xFFFF; i > 0;i--)  {
            k = (U8) (i >> 8);
            outp(CtrlPort,0);
            outpw(WrByte1,(U16) i);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = (U8) inp(readaddr1);
            if (tempa != ((U8) (k + (U8) i)))  {
               aa[j].adder = (U16) i;
               aa[j].data = tempa;
               j++;
               if (j > 19) j = 0;
            }
         }
      break;
      case Wport :
         for (i = 0xFF; i > 0;i--)  {
            outp(CtrlPort,0);
            outpw(WrByte1,(U16) i);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = (U8) inp(readaddr1);
            if (tempa != ((U8) i))  {
               aa[j].adder = (U16) i;
               aa[j].data = tempa;
               j++;
               if (j > 19) j = 0;
            }
         }
      break;
   }


   for (j=0;j<=10;j++) {
      if (aa[j].adder != 0) {
         if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
         return (1234);
      }
   }
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   return (GOOD);

}

U16 RdBCOneAddr(U8 port,U16 addr) {
   U16 readaddr1,CtrlPort,ReadCtrlPort,WrByte1,WrByte2,WrByte3,WrByte4,nOE;
   U8  addrcnt;
   RETCODE err;
   U16 tempa;

   if((err =  FLEXProgram(FLEX_MN,MNTestByte)) != GOOD ) return(err);
   switch (port) {
      case Rport :
         readaddr1 = 0xF328;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEX;
         break;
      case Sport :
         readaddr1 = 0xF32A;
         addrcnt = 1;
         CtrlPort = P0CtrlPort;
         ReadCtrlPort = ReadP0CtrlPort;
         WrByte1 = WriteP0Byte1;
         WrByte2 = WriteP0Byte2;
         WrByte3 = WriteP0Byte3;
         WrByte4 = WriteP0Byte4;
         nOE =  nOEY;
         break;
      case Tport :
         readaddr1 = 0xF32C;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEX;
         break;
      case Uport :
         readaddr1 = 0xF32D;
         addrcnt = 0;
         CtrlPort = P1CtrlPort;
         ReadCtrlPort = ReadP1CtrlPort;
         WrByte1 = WriteP1Byte1;
         WrByte2 = WriteP1Byte2;
         WrByte3 = WriteP1Byte3;
         WrByte4 = WriteP1Byte4;
         nOE =  nOEY;
         break;
      case Vport :
         readaddr1 = 0xF32E;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEX;
         break;
      case Wport :
         readaddr1 = 0xF32F;
         addrcnt = 0;
         CtrlPort = P2CtrlPort;
         ReadCtrlPort = ReadP2CtrlPort;
         WrByte1 = WriteP2Byte1;
         WrByte2 = WriteP2Byte2;
         WrByte3 = WriteP2Byte3;
         WrByte4 = WriteP2Byte4;
         nOE =  nOEY;
         break;
   }

   outp(CtrlPort,FSld);
   outpw(WrByte1,0xFFFF);
   switch (port) {
      case Rport : case Sport :
            outp(CtrlPort,0);
            outpw(WrByte1,addr);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = inpw(readaddr1);
//          tempb = (U8) inp(readaddr1+addrcnt);
      break;
      case Tport : case Uport : case Vport :
            outp(CtrlPort,0);
            outpw(WrByte1,addr);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            tempa = inp(readaddr1);
      break;
      case Wport :
            outp(CtrlPort,0);
            outpw(WrByte1,addr);
            outpw(WrByte3,0xFFFF);
            outp(CtrlPort,nOE);
            (U8) tempa = (U8) inp(readaddr1);
      break;
   }
   if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
   return (tempa);
}
/******************************************************************************
**
** SetP0toP4
**
*******************************************************************************/
VOID SetP0toP4(U8 data) {

    outp(P0CtrlPort,data);
    outp(P1CtrlPort,data);
    outp(P2CtrlPort,data);
    outp(P3CtrlPort,data);
    outp(P4CtrlB,data);
 }

