/****************************************************************************
**
** Name: trctman.h
**
** Description:
**   Header file for trigger and trace operation
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcmtat2/m306/trctman.h_v  $
** 
**    Rev 1.0   19 Mar 1997 15:31:54   gene
** Initial revision.
** 
**    Rev 1.0   17 Feb 1997 10:00:50   ibin
** Initial revision.
** 
**    Rev 1.0   11 Jan 1996 10:48:42   gene
** Initial revision.
** 
**    Rev 1.0   03 Jan 1996 13:51:10   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:48   gene
** Initial revision.
**
** $Header:   S:/tbird/arcmtat2/m306/trctman.h_v   1.0   19 Mar 1997 15:31:54   gene  $
**
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCTMAN_

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

                       /****************************
                        *                          *
                        *       DEFINITIONS        *
                        *                          *
                        ****************************/

typedef enum { MODE_16BIT, MODE_32BIT } EMU_MODE;
typedef enum { PRE_TRIG, CENTER_TRIG, POST_TRIG } TRIG_LOC;
typedef enum { CLOCK_LIST, CYCLE_LIST } LIST_FORM;
typedef enum { CLOCK_TRACE, CYCLE_TRACE } TRACE_FORM;
typedef enum { SIZE_32k, SIZE_64k,SIZE_128k} TBuffer_SIZE;
typedef enum { RS_TBUF,TU_TBUF,VW_TBUF,TS_TBUF,TP_TBUF} TBuffer_TYPE;

#define FOUND_EXT_BIT   11
#define P0Pipe       0x0E
#define P0Pio        0x01
#define P4Pipe       0x0D
#define P4Pio        0x02
#define MNTrace      0x03
#define SMain        0x04
#define CodeCov      0x08

#define TB32K_SIZE   0x7FFF
#define TB64K_SIZE   0xFFFF
#define TB128K_SIZE  0x1FFFF


/* I/O port corresponding bit define */

#define ReadTC0Byte3   0x03
#define ReadTC1Byte3   0x07
#define ReadGrayCnt    0x08
#define ReadCtrlBit    0x0D
#define ReadTINFO      0x0E

/* MAIN Control port BYTE 4 corresponding bit define */

#define OECtrl         0x01

/* MAIN Control port BYTE 3 corresponding bit define */

#define TMNBrk         0x08      // Read only
#define TBDone         0x04      // Read only
#define TOnFly         0x01

/* MAIN Control port BYTE 2 corresponding bit define */

#define TC1Load        0x80
#define TC0Load        0x40
#define TALoad         0x20
#define PFCLoad        0x10
#define WriteByte3     0x08
#define WriteByte2     0x04
#define WriteByte1     0x02
#define WriteByte0     0x01

/* MAIN Control port BYTE 1 corresponding bit define */

#define TSLoad         0x80
#define TFullBrk       0x60
#define TFull          0x20
#define FTAC           0x10
#define TC1Sel         0x08
#define TC0Sel         0x04
#define TBSel1         0x02
#define TBSel0         0x01

#define SetTC0Counter  0x01
#define SetTC1Counter  0x02
#define TB32k          0x00
#define TB64k          0x04
#define TB128k         0x08

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04

/* P4 control port corresponding bit define */

#define FWrite3        0x80
#define FWrite2        0x40
#define FWrite1        0x20
#define FWrite0        0x10
#define nOETRIG        0x08
#define nOETRCM        0x04
#define nOEBREG        0x02
#define EnByteWr       0x01

/* Serial EEPROM corresponding bit define */

#define PullSKHi       0xFD
#define PullSKLo       0xFC
#define PullCSHi       0x80
#define PullCSLo       0x00
#define ReadEEROM      0xF33C
#define EEROMCS        0xF36C

/* I/O port address define1*/

#define P4CtrlAX      0xF325
#define LA0A1nOE      0xF33C
#define FClkSel0      0xF330
#define FClkSel1      0xF334
#define NPCS5         0xF280

/* P0 port address define */

#define ReadP0Byte1    0xF300
#define ReadP0Byte2    0xF301
#define ReadP0Byte3    0xF302
#define ReadP0Byte4    0xF303
#define ReadP0CtrlPort 0xF304
#define P0CtrlPort     0xF307

/* P1 port address define */

#define ReadP1Byte1    0xF308
#define ReadP1Byte2    0xF309
#define ReadP1Byte3    0xF30A
#define ReadP1Byte4    0xF30B
#define ReadP1CtrlPort 0xF30C
#define P1CtrlPort     0xF30F

/* P2 port address define */

#define ReadP2Byte1    0xF310
#define ReadP2Byte2    0xF311
#define ReadP2Byte3    0xF312
#define ReadP2Byte4    0xF313
#define ReadP2CtrlPort 0xF314
#define P2CtrlPort     0xF317

/* P3 port address define */

#define ReadP3Byte1    0xF318
#define ReadP3Byte2    0xF319
#define ReadP3Byte3    0xF31A
#define ReadP3Byte4    0xF31B
#define ReadP3CtrlPort 0xF31C
#define P3CtrlPort     0xF31F

/* P4 port address define */

#define ReadEvent      0xF327
#define ReadLvTc       0xF326
#define P4CtrlB        0xF327

/* MAINCONTROL port address define */

#define RegByte0      0xF328
#define RegByte1      0xF329
#define RegByte2      0xF32A
#define RegByte3      0xF32B
#define RegByte4      0xF32C
#define MCtrlByte1    0xF32D
#define MCtrlByte2    0xF32E
#define MCtrlByte3    0xF32F
#define nRDMN         0xF328
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  ConfigTrace
**
**  Description:
**    Set the trace memory to 1, 2, 4, 8, 16, 32, 64, 128, or 256 trace buffers
**    Set the trigger location to PRE_TRIG, CENTER_TRIG, or POST_TRIG
**    Set EP to break (or not break) when the trace memory are full
**    This function only changes the global variables "traceBufferNumber",
**    "triggerLocation" ,"ToffOnFull" and "breakOnFull",
**
**  Parameters:
**    input:
**      traceBufNum: number of trace buffers
**      trigLoc: trigger location
**      breakFull: break on trace memory full
**      ToffFull: Trace off on trace memory full
**    output:
**      none
**
*******************************************************************************/
RETCODE ConfigTrace(U16 traceBufNum, TRIG_LOC trigLoc, BOOLEAN breakFull,
                    BOOLEAN ToffFull);

/******************************************************************************
**
**  InitialTraceMachine
**
**  Description:
**    After system power on, this function will check if XLX_EREC1, XLX_EREC2
**    or XLX_TMAN exist, then according to the emulation mode, program these
**    Xilinx Chip to their initial configuration and initial VRAM
**
**  Parameters:
**    input:
**      emuMode: emulation mode (MODE_16BIT or MODE_32BIT)
**    output:
**      none
**
*******************************************************************************/
RETCODE InitialTraceMachine(VOID);

/******************************************************************************
**
**  ListTraceBuffer
**
**  Description:
**    List trace data from trace buffer "trcBufLogID" frame "logFrameNum"
**
**  Parameters:
**    input:
**      log: point to structure shown as follows
**        log->traceBufId: trace buffer logical ID
**        log->traceform: list form (CLOCK_LIST or CYCLE_LIST)
**        log->startFrame: logical frame number from which the list starts
**      qualify: point to structure which includes the qualify-list information
**      frameContents: pointer to list data
**    output:
**      none
**
*******************************************************************************/
RETCODE ListTraceBuffer(TRACE_HEAD *log, QUALIFY_LIST *qualify,
                        VOID *frameContents);

/*****************************************************************************
**
**  ReadTimerCounter
**
******************************************************************************/
RETCODE ReadTimerCounter (U32 *cnt0AfterTraceHalt,U32 *cnt1AfterTraceHalt) ;

/*****************************************************************************
**
**  ReadHaltTimeStamp
**
******************************************************************************/
VOID ReadHaltTimeStamp(U8 *timeStamp)  ;

/*****************************************************************************
**
**  ReadTimeStamp
**
******************************************************************************/
VOID ReadTimeStamp(U16 trcBufLogID,S32 LogID,U8 *timeStamp)  ;

/*****************************************************************************
**
**  SPAListTrace
**
******************************************************************************/
RETCODE SPAListTrace(U8 *timeStamp,U8 *event) ;


/******************************************************************************
**
**  ProgramTMANTrace
**
**  Description:
**    Program XLX_TMAN to TRACE configuration (TMANTraceXCByte[])
**    EP bus can be traced into trace memory, if XLX_TMAN is under TRACE
**    configuration
**
**  Parameters:
**    input:
**      none
**    output:
**      none
**
*******************************************************************************/
RETCODE ProgramTMANTrace(U8 trcSel);

/******************************************************************************
**
**  TraceStop
**
*******************************************************************************/
VOID TraceStop(VOID) ;

/******************************************************************************
**
** TraceStart
**
******************************************************************************/
RETCODE TraceStart(VOID) ;

/******************************************************************************
**
**  GetTrigInfoOfTrcBuf
**
*******************************************************************************/
RETCODE GetTrigInfoOfTrcBuf(U16 trcBufLogID) ;

/******************************************************************************
**
**  IsTMANBreak
**
*******************************************************************************/
BOOLEAN IsTMANBreak(VOID) ;

/*****************************************************************************
**
**  CheckTrigEvent
**
******************************************************************************/
RETCODE CheckTrigEvent(VOID) ;


VOID WriteSerialEEPROM(U8 *ptr)  ;
VOID ReadSerialEEPROM(U8 *ptr)  ;

VOID SetTAddr(U32 addr);
/********************************* EOF *************************************/
