/***************************************************************************
**
**  Name:  emuemul.c
**
**  Description:
**     Michelle emulation-group routines.
**     include:
**     "Read/write registers",
**     "Reset the emulator",
**     "Instruction step(s)"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m307/emuemul.c_v  $
** 
**    Rev 1.0   20 Mar 1997 13:20:26   gene
** Initial revision.
** 
**    Rev 1.1   15 Jan 1997 17:05:58   gene
** 
**    Rev 1.0   15 Jan 1997 15:30:14   gene
** Initial revision.
** 
**    Rev 1.1   19 Sep 1996 09:42:52   gene
** added canbase
** 
**    Rev 1.0   11 Jan 1996 10:50:38   gene
** Initial revision.
** 
**    Rev 1.0   03 Jan 1996 13:50:44   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:47:18   gene
** Initial revision.
** 
** 
**  $Header:   S:/tbird/arcmtat2/m307/emuemul.c_v   1.0   20 Mar 1997 13:20:26   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#include <string.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
enum SPEC_INST {PUSHF = 0x9c, CLI = 0xfa, STI = 0xfb, IRET = 0xcf, POPF = 0x9d, INT3 = 0xcc};
                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/
                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/




/***************************************************************************
**
**  EmuReset
**
**  Description: Michelle reset routine, to reset the CPU and set the
**               certain important registers to be default values.
**               such as "PC", "SP" ....
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
**
****************************************************************************/
VOID EmuReset(VOID) {
STATUS vccFlag,brokeReason;
U32 baseReg[BASE_REG_NO];
U16 traceBufNo,traceing;
U32 preAddr,cnt0,cnt1;
U16 tmpCnt;

   vccFlag = GOOD;
   if (!CheckEpStop()) {
      brokeReason = BROKE;
      AccessBaseReg(READ_ALL,noUse,baseReg);
      GoEnd(baseReg);
      AccessBaseReg(WRITE_ALL,noUse,baseReg);
      AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
      AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
      AccessIceFlag(WRITE_ONE,BROKE_REASON,&brokeReason);
      AccessIceFlag(READ_ONE,TRACEING,&traceing);
      if (mtatExist && traceing) {
         ReadTimerCounter(&cnt0,&cnt1);
         tmpCnt = LowWord(cnt1);
         AccessIceFlag(WRITE_ONE,CNT1_LOW,&tmpCnt);
         tmpCnt = HighWord(cnt1);
         AccessIceFlag(WRITE_ONE,CNT1_HIGH,&tmpCnt);
         tmpCnt = LowWord(cnt0);
         AccessIceFlag(WRITE_ONE,CNT0_LOW,&tmpCnt);
         tmpCnt = HighWord(cnt0);
         AccessIceFlag(WRITE_ONE,CNT0_HIGH,&tmpCnt);
         AccessIceFlag(WRITE_ONE,TRACEING,&C_OFF);
//         AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
      }
   }
   //EmuAbort();

   EnEmDisViol();
   vccFlag = Reset(baseReg);
   DisEmStop();
   AccessBaseReg(WRITE_ALL,noUse,baseReg);

   SetCanBaseAddr(CanBaseAddr,&preAddr);
   if(vccFlag != GOOD) {
      AccessSignals(CLEAR_ALL,noUse,&noUse);
      OutputStatus(NO_VCC,ON);
   }
   else OutputStatus(vccFlag,ON);
}



/***************************************************************************
**
**  EmuGetAllRegs
**
**  Description: Michelle Emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuGetAllReg(VOID) {
STATUS status;
U32 m68Reg[MAX_CPU_REG_NO];
U8 dataLen;


   status = GOOD;
   StopRun();
   status = AccessBaseReg(READ_ALL,noUse,m68Reg);
   status = AccessCpuReg(READ_ALL,noUse,&m68Reg[MAX_BASE_REG_NO]);

   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,OFF);
      if (status == OK) {
         dataLen = sizeof(m68Reg); /* each register length */
         OutData(dataLen,m68Reg,ON);
      }
      OutEnd();
   }
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle Emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuGetReg(REG_MODE regMode,U16 regId) {
STATUS status;
U16 phyCpu;
U32 regValue,srReg;
U8 dataLen;

   status = GOOD;
   StopRun();
   /* Maybe add InitLam function */
   switch (regMode) {
      case M68_REG :
         switch (regId) {
            case R_A7 :
               AccessBaseReg(READ_ONE,R_SR,&srReg);
               if (srReg & 0x2000) // s bit = 1
                  status = AccessBaseReg(READ_ONE,R_SSP,&regValue);
               else status = AccessCpuReg(READ_ONE,R_USP,&regValue);
                break;
            case R_PC :
            case R_SSP:
            case R_SR :
               status = AccessBaseReg(READ_ONE,regId,&regValue);
               break;
            default :
               status = AccessCpuReg(READ_ONE,regId,&regValue);
         }
         break;
      case INTERNAL_REG :
         AccessIceFlag(READ_ONE,PHY_CPU_TYPE,&phyCpu);
         break;
      default :
         status = UNKNOWN_TYPE;
   }
   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,OFF);
      if (status == OK) {
         dataLen = sizeof(regValue);
         OutData(dataLen,&regValue,ON);
      }
      outputStream[outputStreamLen++] = 0x00; /* Output stream length */
      OutEnd();
   }
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuSetReg
**
**  Description: Michelle Emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        reg_id -- integer,
**        value  -- unsigned integer,
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuSetReg(REG_MODE regMode, U16 regId, U32 value) {
STATUS status;
U32 srReg;

   status = GOOD;
   StopRun();
   switch (regMode) {
      case M68_REG :
         switch (regId) {
            case R_A7 :
               AccessBaseReg(READ_ONE,R_SR,&srReg);
               if (srReg & 0x2000) // s bit = 1
                  status = AccessCpuReg(WRITE_ONE,R_SSP,&value);
               else status = AccessCpuReg(WRITE_ONE,R_USP,&value);
                break;
            case R_SR :
       //        if (value & 0x2000) // s bit = 1
       //           status = AccessBaseReg(READ_ONE,R_SSP,&tmpReg);
       //        else
       //           status = AccessCpuReg(READ_ONE,R_USP,&tmpReg);
       //        status = AccessCpuReg(WRITE_ONE,R_A7,&tmpReg);
               // don't add break statement.
            case R_PC :
            case R_SSP :
               status = AccessBaseReg(WRITE_ONE,regId,&value);
               break;
            default :
               status = AccessCpuReg(WRITE_ONE,regId,&value);
         }
         break;
      default :
         status = UNKNOWN_TYPE;
   }
   if (exceptBreak == GOOD) {
      status = status & 0x00ff;
      OutputStatus(status,ON);
   }
   else OutputExceptReason(ON);
}


/***************************************************************************
**
**  StepOne
**
**  Description: Michelle Emulation routine, to execute a instruction
**
**
**  Parameters:
**     input:
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
STATUS StepOne(VOID) {
   U32 baseReg[MAX_BASE_REG_NO];
// U16 signals;

   ClrViolFlg();
   EnEmDisViol();
   AccessBaseReg(READ_ALL,noUse,baseReg);
   InstructionStep(baseReg);
   AccessBaseReg(WRITE_ALL,noUse,baseReg);
   DisEmStop();

   return(CheckViolation());
}

/***************************************************************************
**
**  EmuStepRange
**
**  Description: Michelle Emulation routine, to execute instruction
**               from addr1 to addr2.
**
**  Parameters:
**     input:
**        addr1 -- unsigned long,
**        addr2 -- unsignde long
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuStepRange(ADDR *addr1,ADDR *addr2) {
STATUS status;
U32 baseReg[MAX_BASE_REG_NO];
U32 pc,phyAddr1,phyAddr2;


   status = GOOD;
   phyAddr2 = addr2->pos;
   phyAddr1 = addr1->pos;
   if (phyAddr1 == phyAddr2) status = StepOne();
   else {
      pc = addr1->pos;
      while ( (pc <= phyAddr2) && (pc >= phyAddr1) ) {
         status = StepOne();
         AccessBaseReg(READ_ALL,noUse,baseReg);
         pc = baseReg[R_PC];
         if ((exceptBreak) || (status)) break;
      }
   }
   if (exceptBreak == GOOD) OutputStatus(status,ON);
   else OutputExceptReason(ON);
}

/***************************************************************************
**
**  EmuSetIntReg
**
**  Description: Emulation routine, to set a internal register.
**
**  Parameters:
**     input:
**        regOffset -- unsigned integer,
**        value  -- unsigned long,
**        len  -- unsigned integer.
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuSetIntReg(U16 regOffset,U16 len,U32 value,BOOLEAN reloc) {
   STATUS status = GOOD;

   StopRun();
   status = IntRegister(regOffset,WRITE_ONE,len,&value);
   if (status != GOOD)
      OutputExceptReason(ON);
   else
      OutputStatus(status,ON);
}

/***************************************************************************
**
**  EmuGetIntReg
**
**  Description: Emulation routine, to get a internal register.
**
**  Parameters:
**     input:
**        regOffset -- unsigned integer,
**        len  -- unsigned integer.
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuGetIntReg(U16 regOffset,U16 len,BOOLEAN reloc) {
   STATUS status = GOOD;
   U32 regValue;

   StopRun();
   status = IntRegister(regOffset,READ_ONE,len,&regValue);
   if (status != GOOD)
      OutputExceptReason(ON);
   else {
      OutputStatus(status,OFF);
      OutData(sizeof(regValue),&regValue,ON);
      OutEnd();
   }
}
/******************************** E O F ***********************************/

