/***************************************************************************
**
**  Name:  emutrace.c
**
**  Description:
**     Michelle trace-group routines.
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcmtat2/m307/emutrace.c_v  $
** 
**    Rev 1.1   09 Apr 1997 09:12:40   gene
** 
**    Rev 1.0   20 Mar 1997 13:20:28   gene
** Initial revision.
** 
**    Rev 1.1   15 Jan 1997 16:55:06   gene
** 
**    Rev 1.0   15 Jan 1997 15:30:20   gene
** Initial revision.
** 
**    Rev 1.1   25 Jan 1996 16:19:24   gene
** added qualify trace
** 
**    Rev 1.8   28 Dec 1995 14:47:28   kevin
** exchanged pre and post trigger operations
** 
**    Rev 1.7   19 Dec 1995 09:53:30   kevin
** fixed 'next' problem in trigger window
** 
**    Rev 1.4   15 Nov 1995 14:50:52   kevin
** modify EmuClrEvent() for clear all condition
** 
**    Rev 1.3   02 Nov 1995 10:37:30   kevin
** added a flag of violation break to emuAbort()
** 
**    Rev 1.2   12 Oct 1995 16:52:48   kevin
** added EnEmDisViol() in EmuAbort()
** 
**    Rev 1.1   11 Oct 1995 08:40:54   kevin
** added EnEmRun() into EmuGo and removed EnEmDisViol() from EmuGo()
** 
**    Rev 1.0   07 Sep 1995 10:47:30   gene
** Initial revision.
** 
** 
**  $Header:   S:/tbird/arcmtat2/m307/emutrace.c_v   1.1   09 Apr 1997 09:12:40   gene  $
**
** Copyright (C) 1992 Microtek International, Inc.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _TRCTMAN_
#include "trctman.h"
#endif

#ifndef _EMU_EMUL_
#include "emuemul.h"
#endif

#ifndef _EMU_TRACE_
#include "emutrace.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_LLFW_
#include "emullfw.h"
#endif

#ifndef _EMU_COMM_
#include "emucomm.h"
#endif

#ifndef _EMU_EXTERNAL_
#include "emuext.h"
#endif

#ifndef _TRCEVENT_
#include "trcevent.h"
#endif

#ifndef _CODECOV_
#include "codecov.h"
#endif

#include <string.h>
#include <conio.h>
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define MK_FP(seg, ofs) ((VOID _far *) ((((U32) seg) << 16) | ((U16) ofs)))
#define EXT_EVENT          0x400
#define TRIG_EV            0x3ff /* ev1 .. ev8, ev10, ev11*/
#define BUF_SIZE           0x800 /* 2k */
U8 phyEv[MAX_BUS_EVENT_NO];
BUS_EVENT busEvent[MAX_BUS_EVENT_NO];
EXEC_EVENT execEvent[MAX_EXEC_EVENT_NO];
U16 tcFlag;

U8 trigBuf[TRIG_NO][BUF_SIZE][2];
ACTIVE_STATE TrigOutAction;
TRIGGER trigLevel[TRIG_NO];
TRIGGER trig; //template data
TRIG_OUT trigOut[13]; //  0  -  7   8   9   10     11      12
                      // ev0 - ev7,tc0,tc1,extin,level0-,level1-

// SPA function define and variables
#define SPA_MA_RANGE_NO    4
#define SPA_TA_RANGE_NO    1
#define SPA_CC_RANGE_NO   12
#define SPA_TA_TIME_NO     9
#define CC_INFO_LEN      640

SPA_RANGE_NODE spaMARangeTable[SPA_MA_RANGE_NO],spaTARangeTable;
SPA_CC_RANGE_NODE spaCCRangeTable[SPA_CC_RANGE_NO];
SPA_MA_INFO_NODE spaMAInfoTable[SPA_MA_RANGE_NO];
SPA_TA_INFO_NODE spaTAInfoTable;
U16 spaRangeMatchCounter[4];
U32 TotalRunStamp;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/
extern U8 TrcCtrlByte;
extern U8 _far *SeqRamBuf;   // variable define in XSEG

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/
VOID SPASetEventAndTrig(S16 mode);
VOID SPABakEvtAndTrig(VOID);
VOID SPARestEvtAndTrig(VOID);

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  AccessBusEvent
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS AccessBusEvent(ACCESS_MODE accessMode, U16 evId, BUS_EVENT *value) {
STATUS status;
U16 lp;
BUS_EVENT clrBusEvent,tempBusEvent[MAX_BUS_EVENT_NO];
U8 highByte,lowByte;


   status = GOOD;
   evId--;
   memset(&clrBusEvent,0,sizeof(BUS_EVENT));

   clrBusEvent.statusFlag = 1 ;// use status. 1: PowerView, 0: MICEview

   status = GOOD;
   switch (accessMode) {
      case READ_ONE :
         if (busEvent[evId].statusFlag == 0) {
            memcpy(value,&busEvent[evId],sizeof(BUS_EVENT));
         } else { // use status
            memcpy(&tempBusEvent[evId],&busEvent[evId],sizeof(BUS_EVENT));
            busEvent[evId].dataLow =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataLow);
            busEvent[evId].dataHigh =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataHigh);
            memcpy(value,&busEvent[evId],sizeof(BUS_EVENT));
            memcpy(&busEvent[evId],&tempBusEvent[evId],sizeof(BUS_EVENT));
         }

         break;
      case WRITE_ONE :
         memcpy(&busEvent[evId],value,sizeof(BUS_EVENT));
         busEvent[evId].enable = 1;
         if (busEvent[evId].statusFlag == 0) { // use status
            if (value->enable == 0x8001) {
               ClearAllEvent();
               status = SetAllBusEvent(busEvent);  /* Set event */
            }
         } else {
         // highByte = (U8)busEvent[evId].dataLow;
         // lowByte = (U8)(busEvent[evId].dataLow >> 8);
         // busEvent[evId].dataLow = ((U32)highByte << 8) + (U32)lowByte;
         // highByte = (U8)busEvent[evId].dataHigh;
         // lowByte = (U8)(busEvent[evId].dataHigh >> 8);
         // busEvent[evId].dataHigh = ((U32)highByte << 8) + (U32)lowByte;

            busEvent[evId].dataLow =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataLow);
            busEvent[evId].dataHigh =
               (U32)ExchangeHighLow((U16)busEvent[evId].dataHigh);

            if (value->enable == 0x8001) {
//               status = SetAllBusEventP(busEvent);  /* Set event */
               ClearAllEvent();
               status = SetAllBusEvent(busEvent);  /* Set event */
            }
         }
         if (status != GOOD) busEvent[evId].enable = OFF;
         break;
      case READ_ALL :
         if (busEvent[evId].statusFlag == 0)
            memcpy(value,busEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         else {// use status
            memcpy(tempBusEvent,busEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
            for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
               busEvent[lp].dataLow =
                  (U32)ExchangeHighLow((U16)busEvent[lp].dataLow);
               busEvent[lp].dataHigh =
                  (U32)ExchangeHighLow((U16)busEvent[lp].dataHigh);
            }
            memcpy(value,busEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
            memcpy(busEvent,tempBusEvent,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         }
         break;
      case WRITE_ALL :
         memcpy(busEvent,value,sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
            if (busEvent[lp].enable == OFF)
               memcpy(&busEvent[lp],&clrBusEvent,sizeof(BUS_EVENT));
         }
         if (busEvent[0].statusFlag == 0) { // use status
            status = SetAllBusEvent(busEvent);  /* Set event */
         } else {
//            status = SetAllBusEventP(busEvent);  /* Set event */
            ClearAllEvent();
            status = SetAllBusEvent(busEvent);  /* Set event */
//            memcpy(&tempBusEvent[evId],&busEvent[evId],sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);

            for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
               highByte = (U8)busEvent[lp].dataLow;
               lowByte = (U8)(busEvent[lp].dataLow >> 8);
               busEvent[lp].dataLow = ((U32)highByte << 8) + (U32)lowByte;
               highByte = (U8)busEvent[lp].dataHigh;
               lowByte = (U8)(busEvent[lp].dataHigh >> 8);
               busEvent[lp].dataHigh = ((U32)highByte << 8) + (U32)lowByte;
            }

//            status = SetAllBusEventP(busEvent);  /* Set event */
            ClearAllEvent();
            status = SetAllBusEvent(busEvent);  /* Set event */

//            memcpy(&busEvent[evId],&tempBusEvent[evId],sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO);
         }
         if (status != GOOD)
            for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++)
               busEvent[lp].enable = OFF;
         break;
      case CLEAR_ONE :
         memcpy(&busEvent[evId],&clrBusEvent,sizeof(BUS_EVENT));
         busEvent[evId].enable= OFF;
         if (clrBusEvent.statusFlag == 0) { // use status
            ClearAllEvent();
            status = SetAllBusEvent(busEvent);  /* Set event */
         } else {
//            status = SetAllBusEventP(busEvent);  /* Set event */
            ClearAllEvent();
            status = SetAllBusEvent(busEvent);  /* Set event */
         }
         break;
      case CLEAR_ALL :
         for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++) {
            memcpy(&busEvent[lp],&clrBusEvent,sizeof(BUS_EVENT));
            busEvent[lp].enable= OFF;
         }
         if (clrBusEvent.statusFlag == 0) { // use status
            ClearAllEvent();
//            status = SetAllBusEvent(busEvent);  /* Set event */
         } else {
//            status = SetAllBusEventP(busEvent);  /* Set event */
            ClearAllEvent();
//            status = SetAllBusEvent(busEvent);  /* Set event */
         }
         break;
   }
   return(status);
};

/****************************************************************************
**
**  TransferSpace
**
****************************************************************************/
U16 TransferSpace(U16 space) {
   switch (space) {
      case SPACE_SP :
         return(2);
         break;
      case SPACE_UP :
         return(1);
         break;
      case SPACE_DONT_CARE :
         return(0);
   }
};
/****************************************************************************
**
**  AccessExecEvent
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
VOID AccessExecEvent(ACCESS_MODE accessMode, U16 evId, EXEC_EVENT *execData) {
U16 lp;
EXEC_EVENT clrExecEvent;

   clrExecEvent.enable = OFF;
   clrExecEvent.addr.pos = 0;
   clrExecEvent.addr.space = 0;

   switch (accessMode) {
      case READ_ONE :
         memcpy(execData,&execEvent[evId],sizeof(EXEC_EVENT));
         break;
      case WRITE_ONE :
         execData->enable = ON;
         memcpy(&execEvent[evId],execData,sizeof(EXEC_EVENT));
         execData->addr.space = TransferSpace(execData->addr.space);
         ExbpSet(execData->addr.pos,execData->addr.space,evId+1);
         AccessStatusFlag(WRITE_ONE,BKPT,&evId);
         break;
      case READ_ALL :
         memcpy(execData,execEvent,sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO);
         break;
      case WRITE_ALL :
         memcpy(execEvent,execData,sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO);
         for (lp = 0; lp <= 1 ; lp++) {
            execData[lp].addr.space = TransferSpace(execData[lp].addr.space);
            ExbpSet(execData[lp].addr.pos,execData[lp].addr.space,lp+1);
            if (execData[lp].enable == 0) AccessStatusFlag(CLEAR_ONE,BKPT,&lp);
            else AccessStatusFlag(WRITE_ONE,BKPT,&evId);
         }
         break;
      case CLEAR_ONE :
         memcpy(&execEvent[evId],&clrExecEvent,sizeof(EXEC_EVENT));
         AccessStatusFlag(CLEAR_ONE,BKPT,&evId);
         break;
      case CLEAR_ALL :
         for (lp = 0; lp < MAX_EXEC_EVENT_NO; lp++) {
            memcpy(&execEvent[lp],&clrExecEvent,sizeof(EXEC_EVENT));
            AccessStatusFlag(CLEAR_ONE,BKPT,&lp);
         }
         break;
   }
   //   if (errFlag) return init error or done error.
};

/****************************************************************************
**
**  AccessExecEvent
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReadTraceFrame(U16 frame, TRACE_DATA *frameData,U8 traceMode) {
   return(OK);
}


/****************************************************************************
**
**  ReadTraceCount
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReadTraceCount(TRACE_INFO *traceData) {
   return(GOOD);
};

/****************************************************************************
**
**  EmuHalt
**
**  Description: Michelle trace-group routine, to stop the target CPU.
**               Stop execution of target CPU.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        -- O.K. for Normal return
**        -- Fatal Error code return for HW emulator error :
**             BusRq, Reset, NoClock, CPU not Ready ...
**        return data -- "length" + "PC"
**
**
****************************************************************************/
VOID EmuHalt(VOID) {
STATUS status;
U32 baseReg[MAX_BASE_REG_NO];
U8 dataLen;
U32 pc;

   status = GOOD;
   StopRun();
   ClrViolFlg();
   DisEmStop();
   status = CheckViolation();
   AccessBaseReg(READ_ALL,noUse,baseReg);
   pc = baseReg[R_PC];
   OutputStatus(status,OFF);
   if (status == OK) {
      dataLen = 4;
      OutData(dataLen,&pc,ON);
   }
   OutEnd();
}

/****************************************************************************
**
**  EmuAbort
**
**  Description: Michelle trace-group routine, to abort the michelle.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data -- "length" + "PC" + "brealFlag"
**
**
****************************************************************************/
VOID EmuAbort(VOID) {
STATUS status, flgViolation=0;
//U8 epFlag;
U8 goEndFlag = 0;
U16 traceing;
U32 cnt0,cnt1;
U32 baseReg[MAX_BASE_REG_NO];
U16 tmpCnt;

   status = GOOD;
//   epFlag = (U8)CheckEpStop();
//   if (epFlag == ON) {
//      if (RunAndMatch()) status = CheckHwStatus();
//      if (RunAndMatch())
//         status = GOOD;
//      else status = BROKE;
//   }
//   else status = HALT_USER;

   // added for SPA function
   flagHalt = TRUE;
   AccessIceFlag(WRITE_ONE,MODE_FLAG,&C_OFF);

   goEndFlag = 1;
   AccessBaseReg(READ_ALL,noUse,baseReg);
//   if (status != BROKE) {
      switch (status = GoEnd(baseReg)) {
         case 0:
//            break;
         case 7:
            status = HALT_USER;
            break;
         case 1:
            status = BKPT1_HALT;
            break;
         case 2:
            status = BKPT2_HALT;
            break;
         case 3:
            status = SW_BKPT_HALT;
            break;
         case 4:
            status = TRIG_HALT;
            break;
         case 5:
            status = RBW_HALT;
            break;
         case 6:
//            status = VIOL_HALT;
//            flgViolation = CheckViolation();
//            if (flgViolation != GOOD)
//               status = HALT_USER;
            status = CheckViolation();
            break;
         case 8: // check exceptBreak
            break;
      }
      DisEmStop();
//      if (status == GOOD) {
//         flgViolation = CheckViolation();
//         if (flgViolation != GOOD)
//            status = HALT_USER;
//      }
      EnEmDisViol();
      AccessBaseReg(WRITE_ALL,noUse,baseReg);
//   }
   AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
   AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
   AccessIceFlag(WRITE_ONE,BROKE_REASON,&status);
   Exbp1Disable();
   Exbp2Disable();
   AccessIceFlag(READ_ONE,TRACEING,&traceing);
   if (mtatExist && traceing) {
      AccessIceFlag(WRITE_ONE,TRACEING,&C_OFF);
      ReadTimerCounter(&cnt0,&cnt1);
      tmpCnt = LowWord(cnt1);
      AccessIceFlag(WRITE_ONE,CNT1_LOW,&tmpCnt);
      tmpCnt = HighWord(cnt1);
      AccessIceFlag(WRITE_ONE,CNT1_HIGH,&tmpCnt);
      tmpCnt = LowWord(cnt0);
      AccessIceFlag(WRITE_ONE,CNT0_LOW,&tmpCnt);
      tmpCnt = HighWord(cnt0);
      AccessIceFlag(WRITE_ONE,CNT0_HIGH,&tmpCnt);
//      AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
   }
   if (exceptBreak) 
      OutputExceptReason(OFF);
   else if (flgViolation != GOOD) 
      OutputStatus(flgViolation,OFF);
   else
      OutputStatus(status,OFF);
   OutData(1,&goEndFlag,OFF);
   OutEnd();

}

/****************************************************************************
**
** EmuGo
**
**  Description: Michelle trace-group routine, to set the target CPU free
**               running. Default free running target CPU from current PC.
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "brealFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
****************************************************************************/
U8 timeFlag,timeOver;
STATUS StartGo(S16 mode) {
U32 baseReg[MAX_BASE_REG_NO];
U16 evId,syncIn,phyTrigSet,flyFlag;
STATUS status;
U8 traceInit = 0;   // default TRACE ON

   if (mtatExist) {
      switch (mode) {
      case TEST_RUN:
         traceInit = 1; // default TRACE OFF
         SetPhyTrig(mode);
      case FREE_RUN:
         AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
         break;
      case SPA_MA_RUN:
      case SPA_TA_RUN:
// /* gene */        cnter = 0;
         SPASetEventAndTrig(mode);
         SetPhyTrig(mode);
//         AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
         flagHalt = FALSE;
         traceInit = 1;  // default TRACE OFF
         break;
      case SPA_CC_RUN:
         flagHalt = FALSE;
         SPAProgramTMANCodeCov();
         break;
      default:
         AccessIceFlag(READ_ONE,PHY_TRIG_SET,&phyTrigSet);
         if (phyTrigSet == C_OFF) {
            SetPhyTrig(mode);
            AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_ON);
         }
      }
      AccessIceFlag(READ_ONE,FLYING,&flyFlag);
      if ((flyFlag == C_OFF) && (mode != SPA_CC_RUN)) {
         ProgramTMANTrace(traceInit);   
         AccessIceFlag(WRITE_ONE,TRACEING,&C_ON);
      }
   }
   AccessIceFlag(WRITE_ONE,EP_RUN,&C_OFF);
   AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_ON);
   if (mode == FREE_RUN /*run*/) {
      Exbp1Disable();
      Exbp2Disable();
   }
   else {
      if (mode == FLY_RUN) AccessIceFlag(WRITE_ONE,FLYING,&C_ON);
      evId = 0;
      AccessStatusFlag(READ_ONE,BKPT,&evId);
      if (evId) Exbp1Enable();
      else Exbp1Disable();
      evId = 1;
      AccessStatusFlag(READ_ONE,BKPT,&evId);
      if (evId) Exbp2Enable();
      else Exbp2Disable();
   }
   ClrViolFlg();
   //if (mode == TEST_RUN) EnEmDisViol(); // special for function test.
   //else EnEmRun();
   EnEmRun(); //added by Kevin  10/9/95
// removed by kevin 10/9/95   EnEmDisViol();  // temp instruction.
   AccessBaseReg(READ_ALL,noUse,baseReg);
   GoEp(baseReg);
   AccessIceFlag(WRITE_ONE,RUNNING,&C_ON);
   AccessIceFlag(WRITE_ONE,BROKE_REASON,&C_ON);
   timeOver = timeFlag = 0;
   AccessIceFlag(READ_ONE,SYNC_IN,&syncIn);
   status = GOOD;
   if (syncIn && Pending()) {
      AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);
      status = EP_PENDING;
   }
   return(status);
}

VOID EmuGo(S16 mode) {
STATUS status;

   status = StartGo(mode);
   AccessIceFlag(WRITE_ONE,MODE_FLAG,&mode);
   if (exceptBreak != GOOD) OutputExceptReason(ON);
   else OutputStatus(status,ON);
}

/****************************************************************************
**
** EmuGetCpuStatus
**
**  Description: Michelle trace-group routine, to set the target CPU free
**              running. Default free running target CPU from current PC.
**               "mode" is to indicate the mode of free-running.
**               "mode" = 1 --> no temporary breakpoint is specified.
**               "mode" = 2 --> set temporary breakpoint at "addr" location
**
**  Parameters:
**     input:
**        mode -- int
**        addr -- unsigned long
**
**     output:
**        return status code(error-code) in to the output processor.
**        status-code = "BROKE"     --> Program broke at breakpoint.
**        status-code = "USER_HALT" --> Aborted by user.
**        status-code = "HALT"      --> Target CPU Halted.
**
**        return data -- "length" + "PC" + "brealFlag"
**
**  NOTE: The firmware should reserve an execution breakpoint to be used
**        as the temporary breakpoint implementation.
**
****************************************************************************/
VOID EmuGetCpuStatus(VOID) {
   STATUS status,brokeReason;
//   U8 epFlag;
   U8 goEndFlag = 0;
   U32 baseReg[MAX_BASE_REG_NO];
   U16 flyFlag,syncIn,epRun,runFlag;
   U32 cnt0,cnt1;
   U16 tmpCnt;

   status = GOOD;
   goEndFlag = 0;
   AccessIceFlag(READ_ONE,BROKE_REASON,&brokeReason);
   AccessIceFlag(READ_ONE,RUNNING,&runFlag);
   if (runFlag == OFF) {
      status = brokeReason;
      goEndFlag = 1;
   }
   else {
      AccessIceFlag(READ_ONE,FLYING,&flyFlag);
      AccessIceFlag(READ_ONE,EP_RUN,&epRun);
      AccessIceFlag(READ_ONE,SYNC_IN,&syncIn);
      if ((epRun == C_OFF) && (syncIn)) {
//         if((epFlag = (U8)CheckEpStop()) == OFF)
//            AccessIceFlag(WRITE_ONE,EP_RUN,&C_ON);
//         else status = EP_PENDING;
         if (Pending()) {
            status = EP_PENDING;
            goEndFlag = 1;
         } else {
            AccessIceFlag(WRITE_ONE,EP_RUN,&C_ON);
            AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_ON);
         }
      }
      else {
         if (!RunAndMatch()) {
            if (CheckEpStop()) {
               status = brokeReason;
               goEndFlag = 1;
            }
            else if((timeOver = CheckTimeOut()) != timeFlag) {
               if(timeOver != 0 && (U8)CheckEpStop() == OFF) {
                  SetExceptBreak();
                  status = TIME_OUT;
                  if ((exceptBreak == 1) ||  // Bus request
                      (exceptBreak == 8) ||  // Target is halted
                      (exceptBreak == 16))   // Target is reset
                     goEndFlag = 0;
                  else goEndFlag = 1;
                  timeFlag = timeOver;
               }
            }
         }
         else {
            goEndFlag = 1;
            AccessBaseReg(READ_ALL,noUse,baseReg);
            switch (status = GoEnd(baseReg)) {
               case 0:
                  break;
               case 7:
                  status = HALT_USER;
                  break;
               case 1:
                  status = BKPT1_HALT;
                  break;
               case 2:
                  status = BKPT2_HALT;
                  break;
               case 3:
                  status = SW_BKPT_HALT;
                  break;
               case 4:
                  status = TRIG_HALT;
                  break;
               case 5:
                  status = RBW_HALT;
                  break;
               case 6:
                  status = VIOL_HALT;
                  break;
               case 8: // check exceptBreak
                  break;
            }
            AccessBaseReg(WRITE_ALL,noUse,baseReg);
            DisEmStop();
            AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
            AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
            AccessIceFlag(WRITE_ONE,BROKE_REASON,&status);
            Exbp1Disable();
            Exbp2Disable();
            if (mtatExist) {
               AccessIceFlag(WRITE_ONE,TRACEING,&C_OFF);
               ReadTimerCounter(&cnt0,&cnt1);
               tmpCnt = LowWord(cnt1);
               AccessIceFlag(WRITE_ONE,CNT1_LOW,&tmpCnt);
               tmpCnt = HighWord(cnt1);
               AccessIceFlag(WRITE_ONE,CNT1_HIGH,&tmpCnt);
               tmpCnt = LowWord(cnt0);
               AccessIceFlag(WRITE_ONE,CNT0_LOW,&tmpCnt);
               tmpCnt = HighWord(cnt0);
               AccessIceFlag(WRITE_ONE,CNT0_HIGH,&tmpCnt);
//               AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
            }
         }
      }
   }
   if (exceptBreak) OutputExceptReason(OFF);
   else if (status == GOOD) {
      if (flyFlag) OutputStatus(CPU_FLY,OFF);
      else OutputStatus(GOOD,OFF);
   }
   else OutputStatus(status,OFF);
   OutData(1,&goEndFlag,OFF);
   OutEnd();
}

//VOID EmuGetCpuStatus(VOID) {
//STATUS status;
//U8 epFlag,goEndFlag = 0;
//U16 baseReg[MAX_BASE_REG_NO],traceBufNo,cnt0,cnt1,epRun;
//U16 flyFlag;
//U32 tmpCnt;
//
//   status = GOOD;
//   AccessIceFlag(READ_ONE,FLYING,&flyFlag);
//   AccessIceFlag(READ_ONE,EP_RUN,&epRun);
//   if (epRun == C_OFF) {
//      if((epFlag = (U8)CheckEpStop()) == OFF)
//         AccessIceFlag(WRITE_ONE,EP_RUN,&C_ON);
//      else status = EP_PENDING;
//      goEndFlag = 0;
//      if (exceptBreak) OutputExceptReason(OFF);
//      else OutputStatus(status,OFF);
//      OutData(1,&goEndFlag,OFF);
//      OutEnd();
//      return;
//   }
//   if (!RunAndMatch()) {
//      if((timeOver = CheckTimeOut()) != timeFlag) {
//         if(timeOver != 0 && (U8)CheckEpStop() == OFF) {
//            SetExceptBreak();
//            status = TIME_OUT;
//            goEndFlag = 0;
//            timeFlag = timeOver;
//         }
//      }
//   }
//   else {
//      status = CheckHwStatus();
//      if (status == USER_CC) goEndFlag = 0;
//      else {
//         goEndFlag = 1;
//         AccessBaseReg(READ_ALL,noUse,baseReg);
//         GoEnd(baseReg);
//         AccessBaseReg(WRITE_ALL,noUse,baseReg);
//         DisEmStop();
//         if (status == GOOD) status = CheckViolation();
//         AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
//         Exbp1Disable();
//         Exbp2Disable();
//         if (mtatExist) {
//            ProgramTMANStatic(&traceBufNo,&tmpCnt);
//            cnt1 = HighWord(tmpCnt);
//            cnt0 = LowWord(tmpCnt);
//            AccessIceFlag(WRITE_ONE,TRACED_BUFF_NO,&traceBufNo);
//            AccessIceFlag(WRITE_ONE,COUNTER1,&cnt1);
//            AccessIceFlag(WRITE_ONE,COUNTER0,&cnt0);
//         }
//      }
//   }
//   if (exceptBreak) OutputExceptReason(OFF);
//   else if (status == GOOD) {
//      if (flyFlag) OutputStatus(CPU_FLY,OFF);
//      else OutputStatus(GOOD,OFF);
//   }
//   else OutputStatus(status,OFF);
//   OutData(1,&goEndFlag,OFF);
//   OutEnd();
//}
//

/****************************************************************************
**
**  EmuSetEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     ev_id    -- int,
**     addrspec -- unsigned int,
**     addrlo   -- unsigned long,
**     addrhi   -- unsigned long,
**     dataspec -- unsigned int,
**     datalo   -- unsigned int,
**     datahi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetEvent(U16 evId, U8 *busEventData) {
STATUS status;
BUS_EVENT locEvent;

   status = GOOD;
//   StopRun();
   memcpy(&locEvent,busEventData,sizeof(locEvent));
   status = AccessBusEvent(WRITE_ONE,evId,&locEvent);

   OutputStatus(status,ON);/* Before add other data to outputStream, len - 1 */

}

/****************************************************************************
**
**  EmuSetAllEvent
**
**  Description: Michelle trace-group routine, to define a bus event.
**               Set a bus event, the "addrspec" and "dataspec" are
**               defined as followings:
**               = "0" --> address/data field is not defined
**               = "1" --> address/data field is a single value
**               = "2" --> address/data field is a range value
**               = "3" --> address/data with a mask value.
**
**               "addrhi/datahi" is a wildcard value. "0" means "don't care".
**               EX. wildcard value 0xfffffffc means bit-0 and bit-1 are
**               "don't care".
**
**  Parameters:
**     input:
**     ev_id    -- int,
**     addrspec -- unsigned int,
**     addrlo   -- unsigned long,
**     addrhi   -- unsigned long,
**     dataspec -- unsigned int,
**     datalo   -- unsigned int,
**     datahi   -- unsigned int,
**     stat     -- unsigned int,
**     count    -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetAllEvent(U8 *busData,U8 *execData,U8 *extData) {
STATUS status;

   status = GOOD;
   if (mtatExist) AccessBusEvent(WRITE_ALL,noUse,(BUS_EVENT *)busData);
   else status = NO_TRACE_MODULE;

   AccessExecEvent(WRITE_ALL,noUse,(EXEC_EVENT *)execData);

   memcpy(&extEvent,extData,sizeof(extEvent));

   OutputStatus(status,ON);/* Before add other data to outputStream, len - 1 */
}


/***************************************************************************
**
**  EmuSetExBkpt
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId --
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetExBkpt(U16 evId, ADDR *addr) {
EXEC_EVENT execEvent;

   StopRun();
   execEvent.addr.pos = addr->pos;
   execEvent.addr.space = addr->space;
   evId -= 10;
   AccessExecEvent(WRITE_ONE,evId,&execEvent);
   AccessStatusFlag(WRITE_ONE,BKPT,&evId);

   OutputStatus(GOOD,ON);/* Before add other data to outputStream, len - 1 */

}

/***************************************************************************
**
**  EmuSetExtEvent
**
**  Description: Michelle trace-group routine, to define an execution
**               brekpoint. (Set an execution breakpoint.)
**
**  Parameters:
**     input:
**        evId --
**        addr  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetExtEvent(U16 evData) {

   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   extEvent = evData;
//   SelectExternalTraceBit(HighByte(extEvent));
   OutputStatus(GOOD,ON);
}


/***************************************************************************
**
**  EmuClrEvent
**
**  Description: Michelle trace-group routine, to clear the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**     input:
**        ev_id -- int
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuClrEvent(U16 evId) {
STATUS status;

   status = GOOD;
   if (evId == 0x0) {             // clear all events
      if (mtatExist) AccessBusEvent(CLEAR_ALL,noUse,(BUS_EVENT *)&noUse);
      else status = NO_TRACE_MODULE;
      AccessExecEvent(CLEAR_ALL,noUse,(EXEC_EVENT *)&noUse);
//      extEvent = 0x0800;
//      AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   } else if (evId == 0xFFFF) {   // clear all bus events
      if (mtatExist) AccessBusEvent(CLEAR_ALL,noUse,(BUS_EVENT *)&noUse);
      else status = NO_TRACE_MODULE;
   } else if (evId >= 1 && evId <= 8) {
      if (mtatExist) AccessBusEvent(CLEAR_ONE,evId,(BUS_EVENT *)&noUse);
      else status = NO_TRACE_MODULE;
   } else if (evId == 10 || evId == 11)
      AccessExecEvent(CLEAR_ONE,evId-10,(EXEC_EVENT *)&noUse);
   else {
      AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
      extEvent = 0x0800;
   }

   OutputStatus(status,ON);
}

/***************************************************************************
**
**  EmuGetEvent
**
**  Description: Michelle trace-group routine, to clear the setting of
**               event(s) -- bus or execution breakpoint.
**
**  Parameters:
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetAllEvent(VOID) {
U8 totalLen,lp;
//U8 tempEvBuff[256];
BUS_EVENT tempEvBuff[MAX_BUS_EVENT_NO];

   if (mtatExist) OutputStatus(GOOD,OFF);
   else OutputStatus(NO_TRACE_MODULE,OFF);
   totalLen = (U8)(sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO +
               sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO + sizeof(extEvent));
   OutLength(totalLen);

 AccessBusEvent(READ_ALL,noUse,tempEvBuff);
 for (lp = 0; lp < MAX_BUS_EVENT_NO; lp++)
    OutData(sizeof(BUS_EVENT),(U8 *)(&tempEvBuff[lp]),OFF);
 //OutData(sizeof(BUS_EVENT) * MAX_BUS_EVENT_NO,(U8)tempEvBuff,OFF);

 AccessExecEvent(READ_ALL,noUse,(EXEC_EVENT *)tempEvBuff);
 OutData(sizeof(EXEC_EVENT) * MAX_EXEC_EVENT_NO,tempEvBuff,OFF);

 OutData(sizeof(extEvent),&extEvent,OFF);

 OutData(sizeof(tcFlag),&tcFlag,OFF);

 OutData(sizeof(counter0),&counter0,OFF);

 OutData(sizeof(counter1),&counter1,OFF);

 OutEnd();

}

/***************************************************************************
**
**  EmuListTrace
**
**  Description: Michelle trace-group routine, to list raw data from the
**               trace buffer.
**               List trace buffer content in RAW data format which is
**               similar to the output of LOSTAN command in MICE-III.
**               The "frame" is the starting listing frame. If "frame" is
**               "-1", <ew MICE will return the number of frames in the
**               trace buffer.
**
**  Parameters:
**     input:
**        frame -- U16
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**        list trace -- ("length" + "frame_data") *
**                      (min(256, "rest_frames_ in_trace_buffer"))
**        return count -- "length" + "number"
**
****************************************************************************/
VOID EmuListTrace(U16 traceBufId, S32 frameNo,U8 *condition) {
STATUS status;
U8 frameWidth,frameData[32*26]; // 32 frame, each frame is 26-bytes width
TRACE_HEAD traceHead;
U16 lp;
U8 tempTraceBuff[28];

   if (condition[0]) { // Qualify list has frame number (4 bytes).
      frameWidth = 26;
   } else {
      frameWidth = 22;
   }
   status = GOOD;
//   StopRun();
   traceHead.traceBufId = traceBufId;
   traceHead.startFrame = frameNo;
   traceHead.traceform = CYCLE_TRACE;
   status = ListTraceBuffer(&traceHead,(QUALIFY_LIST *)condition, frameData);
   if (status == GOOD) {
      OutputStatus(GOOD,OFF);
      OutLength((U8)traceHead.frameLen);
      for (lp = 0; lp < traceHead.frameLen; lp++) {
         memcpy (tempTraceBuff,frameData+lp*frameWidth,frameWidth);
//         if (condition)
//            memcpy (tempTraceBuff+frameWidth,frameData+lp*frameWidth+22,4);
         OutData(frameWidth,tempTraceBuff,OFF);
      }
      OutEnd();
   }
   else OutputStatus(status,ON);
}


/***************************************************************************
**
**  EmuSetTraceBuff
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBuff(U16 traceBufNum) {
STATUS status;
TRIG_LOC traceDelay;
U16 breakFull,tmpBufNum,trcOffOnFull;

   status = GOOD;
   //StopRun();
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BREAK,&breakFull);
   AccessIceFlag(READ_ONE,TRCOFF_FULL,&trcOffOnFull);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&tmpBufNum);
   if (traceBufNum != tmpBufNum) {
      status = ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull,
                     (BOOLEAN)trcOffOnFull);
      AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);
      AccessIceFlag(WRITE_ONE,TRACE_BUFF,&traceBufNum);
   }

   OutputStatus(status,ON);
}

/***************************************************************************
**
**  EmuSetTrcOffOnFull
**
**  Description: Michelle trace-group routine, to set the trace config.
**
**  Parameters:
**     input:
**        mode -- U16
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTrcOffOnFull(U16 trcOffOnFull) {
STATUS status;
TRIG_LOC traceDelay;
U16 breakFull,traceBufNum;

   status = GOOD;
   //StopRun();
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BREAK,&breakFull);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   status = ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull,
                   (BOOLEAN)trcOffOnFull); //gene*
//   AccessIceFlag(WRITE_ONE,BUFFER_FILL,&C_OFF);
   AccessIceFlag(WRITE_ONE,TRCOFF_FULL,&trcOffOnFull);

   OutputStatus(status,ON);
}

/***************************************************************************
**
**  EmuGetTraceInfo
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceInfo(VOID) {
U16 lastBufNo,tmpCnt,traceBufNo=1;
U32 cnt0,cnt1;

   AccessIceFlag(READ_ONE,TRACED_BUFF_NO,&lastBufNo);
   AccessIceFlag(READ_ONE,CNT1_LOW,&tmpCnt);
   cnt1 = tmpCnt;
   AccessIceFlag(READ_ONE,CNT1_HIGH,&tmpCnt);
   cnt1 = ((U32)tmpCnt) << 16;
   AccessIceFlag(READ_ONE,CNT0_LOW,&tmpCnt);
   cnt1 = tmpCnt;
   AccessIceFlag(READ_ONE,CNT0_HIGH,&tmpCnt);
   cnt0 = ((U32)tmpCnt) << 16;
//   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNo);

   OutputStatus(GOOD,OFF);

   OutData(sizeof(lastBufNo),&lastBufNo,OFF);

   OutData(sizeof(cnt1),&cnt1,OFF);

   OutData(sizeof(cnt0),&cnt0,OFF);

   OutData(sizeof(traceBufNo),&traceBufNo,OFF);

   OutEnd();
}

/***************************************************************************
**
**  EmuSetTraceBreak
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuSetTraceBreak(U16 breakFull) {
STATUS status;
TRIG_LOC traceDelay;
U16 traceBufNum,trcOffOnFull;

   status = GOOD;
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   AccessIceFlag(WRITE_ONE,TRACE_BREAK,&breakFull);
   AccessIceFlag(READ_ONE,TRCOFF_FULL,&trcOffOnFull);
   status = ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull,
                  (BOOLEAN)trcOffOnFull);

   OutputStatus(GOOD,ON);/* Before add other data to outputStream, len - 1 */
}

/***************************************************************************
**
**  EmuGetTraceDepth
**
**  Description: Michelle trace-group routine, to set the trace mode.
**
**  Parameters:
**     input:
**        mode -- U8
**
**     output:
**        "O.K." -- Normal return
**
****************************************************************************/
VOID EmuGetTraceDepth(U16 traceBufId) {
STATUS status;
U16 buffFill;
U8 tempDepthBuff[8];

   status = GOOD;
   AccessIceFlag(READ_ONE,BUFFER_FILL,&buffFill);
   if (buffFill == ON) {
      if (!gotTrigInfoOfTrcBuf[traceBufId])
         status = GetTrigInfoOfTrcBuf(traceBufId);
      if (status)
         OutputStatus(status,ON);
      else {
         if ((startLogFrameOfTrcBuf[traceBufId] == 0) &&
             (endLogFrameOfTrcBuf[traceBufId] == -1))
            OutputStatus(BUFFER_EMPTY,OFF);
         else
            OutputStatus(GOOD,OFF);
         memcpy (tempDepthBuff,&startLogFrameOfTrcBuf[traceBufId],4);
         memcpy (tempDepthBuff+4,&endLogFrameOfTrcBuf[traceBufId],4);
         OutData(8,tempDepthBuff,ON);
         OutEnd();
      }
   }
   else OutputStatus(BUFFER_EMPTY,ON);
}

/***************************************************************************
**
**  EmuClrTrig()
**
**  Description: Michelle trace-group routine, to clear the trigger setting.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuClrTrig(U16 levelNo) {
U16 lp,action[11],ev[11];;

   for (lp = 0; lp < 11; lp++)
      ev[lp] = action[lp] = 0;
   if (levelNo == 0x0) { // Clear all trigger.
      for (lp = 1; lp <= 4; lp++)
         EmuSetTrig(0,lp,ev,action,1);
   }
   else EmuSetTrig(0,levelNo,ev,action,1);
   OutputStatus(GOOD,ON);/* Before add other data to outputStream, len - 1 */
}


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**    Trigger Out Action state 
**   --------------------------
**    bit   |  12   |   13     
**   -------+-------+----------
**    LOW   |   0   |    0     
**    HIGH  |   1   |    0     
**    HI-Z  |   0   |    1     
**
**************************************************************************/
U8 ConvertTrigOut() {
U8 convData;

   //setData = 0;
   switch (TrigOutAction) {
   case ACTIVE_LOW :
      convData = 0x20; // mask bit12 & bit13 TrigOut.
      break;           // set bit13 (ACT11)
   case ACTIVE_HIGH :
      convData = 0x30; // set bit12,bit13 (ACT10,ACT11)
      break;
   case ACTIVE_HIGHZ :
      convData = 0x20; // mask bit12 & bit13 TrigOut.
      break;
   default:;
   }
   return(convData);
}

/**************************************************************************
**
** Name :
**
** Function  Configuration one level of trigger setting 
**
**    Input  :
**
**    Output :
**
** Notes:
**        EventName | AddrBit | EventName | AddrBit
**      ------------+---------+-----------+----------
**        Tmr-Cnt 0 |   A0    | BusEvent6 |   A8
**        Tmr-Cnt 1 |   A1    | BusEvent7 |   A9
**        BusEvent0 |   A2    |  Ext IN   |   A10
**        BusEvent1 |   A3    | LevelBit0 |   A11
**        BusEvent2 |   A4    | LevelBit1 |   A12
**        BusEvent3 |   A5    |           |           
**        BusEvent4 |   A6    |           |           
**        BusEvent5 |   A7    |           |           
**
**************************************************************************/
U16 SetTrigLevel(TRIGGER *trig, U16 levelNo,S16 runMode) {
U16 lp,traceBufNum;

   for (lp = 0; lp < 13; lp++) {
      trigOut[lp].addr = trigOut[lp].data = 0;
      trigOut[lp].trigoutPtn = 0;
   }

   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   for (lp = 0; lp < (U16)EVENT_NO; lp++) {
      if (!trig->ev[lp]) break;
//      if (tempAddr = (trig->act[lp] & (maskBit << 9))) // ext trigger setting(9)
//         trigOut[lp].addr = tempAddr << 1; // Set ext. trig (10)
//      else trigOut[lp].addr = 0;
//      if (traceBufNum == 1) trigOut[lp].data &= 0xffef; // mask NEXT.
      switch (trig->ev[lp]) {
         case 9 : // external event
//            extEvPin = HighByte(extEvent);
//            if (extEvPin < 8) trigOut[lp].addr = maskBit << 10;
            trigOut[lp].addr = maskBit << 10;
            break;
         case 10 : // count 0
         case 11 : // count 1
            trigOut[lp].addr = maskBit << (trig->ev[lp]-10);
            break;
         default : // ev1 - ev8
            trigOut[lp].addr += (maskBit << (trig->ev[lp]+1));
      }
//      trigOut[lp].data = ConvertTrigOut(trig->act[lp]);
      trigOut[lp].data = trig->act[lp];
      if (trigOut[lp].data & DATA_TRIGOUT)
         trigOut[lp].trigoutPtn = ConvertTrigOut();
      if ((runMode == FREE_RUN) || (runMode == TEST_RUN)) trigOut[lp].data &= 0xfffb; // mask BREAK.
   }

   return(lp);
}

/***************************************************************************
**
**  EmuGetTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuGetAllTrig(VOID) {
U8 dataLen,lp;

   OutputStatus(GOOD,OFF);
   dataLen = sizeof(TRIGGER);
   for (lp = 0; lp < TRIG_NO; lp++) {
      OutData(dataLen,&trigLevel[lp],ON);
   }
   OutEnd();
}

/***************************************************************************
**
**  EmuSetTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetTrig(U8 phySet, U16 levelNo, U16 *events, U16 *actions,U16 mode) {
U16 traceDelay,epRunning;
STATUS status;

   status = GOOD;
   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   levelNo--;
   if (levelNo == 0) {
      switch (mode) {
         case 0:
            traceDelay = PRE_TRIG; break;
         case 1:
            traceDelay = POST_TRIG; break;
         case 2:
            traceDelay = CENTER_TRIG; break;
      }
      AccessIceFlag(WRITE_ONE,TRACE_MODE,&traceDelay);
      trig.mode = mode;
   }
   trig.defined = ON;
   memcpy(trig.ev,events,11*2);
   memcpy(trig.act,actions,11*2);
   memcpy(&trigLevel[levelNo],&trig,sizeof(TRIGGER));
   if (phySet) {
      status = SetPhyTrig(NORMAL_RUN);
      AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_ON);
      AccessIceFlag(READ_ONE,RUNNING,&epRunning);
      if (epRunning)
         TraceStart();  // default TRACE ON
   }
   OutputStatus(status,ON);
}

/***************************************************************************
**
**  SetPhyTrig
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
STATUS SetPhyTrig(S16 runMode) {
U16 evCount,mask2Bit,lp2;
U16 matchAddr;
U16 lp;
U8 far *run0Active;
STATUS status;
U16 levelNo,traceDelay,traceBufNum,breakFull,trcOffOnFull;
U8 extHigh,initHighVal=0,tmpData1,tmpData2;

   status = GOOD;
   AccessIceFlag(READ_ONE,TRACE_MODE,&traceDelay);
   AccessIceFlag(READ_ONE,TRACE_BREAK,&breakFull);
   AccessIceFlag(READ_ONE,TRACE_BUFF,&traceBufNum);
   AccessIceFlag(READ_ONE,TRCOFF_FULL,&trcOffOnFull);
   ConfigTrace(traceBufNum,traceDelay,(BOOLEAN)breakFull,
                 (BOOLEAN)trcOffOnFull);
   mask2Bit = 0x3; // bit 0,1
   for (levelNo = 0; levelNo < 4; levelNo++) {
      evCount = SetTrigLevel(&trigLevel[levelNo],levelNo,runMode);
      /* If timer is set.  */
      switch (TrigOutAction) {
      case ACTIVE_LOW:
         initHighVal = 0x30; // set TrigOut ACT10,ACT11 init to high
         break;
      case ACTIVE_HIGH:
         initHighVal = 0x20; // set TrigOut ACT11 init to high
         break;
//      case ACTIVE_HIZ:
//         initHighVal = 0x00; // set TrigOut ACT11 init to low
//         break;
      }
      for (lp = 0; lp < BUF_SIZE; lp++) { // initing table
         trigBuf[levelNo][lp][0] = (U8) levelNo;
         trigBuf[levelNo][lp][1] = initHighVal;
      }
      extHigh = (U8)(extEvent & 0xFF);
      for (lp2 = 0; lp2 < evCount; lp2++) {
         matchAddr = trigOut[lp2].addr;
         if (matchAddr != 0) {
            if ((matchAddr == ADDR_EXT) && (extHigh == 0)) {
               for (lp = 0; lp < BUF_SIZE; lp++) {
                  if ((lp & matchAddr) == 0) {
                  // ** High Byte **
                     if (trigOut[lp2].data & DATA_TRIGOUT) {  // ** set trig out act **
                        tmpData1 = (U8)(trigBuf[levelNo][lp][1] & 0xCF); 
                        tmpData2 = (U8)(HighByte(trigOut[lp2].data) & 0xCF);
                        trigBuf[levelNo][lp][1] = (U8)(tmpData1 | tmpData2 | trigOut[lp2].trigoutPtn);  
                     } else {  // ** do not set trig out act **
                        trigBuf[levelNo][lp][1] |= HighByte(trigOut[lp2].data);  
                     }
                  // ** low Byte **
                     tmpData1 = trigBuf[levelNo][lp][0];                       // low Byte
                     /*** mask initial level no for setting seq. level ***/
                     trigBuf[levelNo][lp][0] = (U8)((tmpData1 & 0xFC) | LowByte(trigOut[lp2].data));
                  }
               }
            } else {
               for (lp = 0; lp < BUF_SIZE; lp++) {
                  if ((lp & matchAddr) == matchAddr) {
                  // ** High Byte **
                     if (trigOut[lp2].data & DATA_TRIGOUT) {  // ** set trig out act **
                        tmpData1 = (U8)(trigBuf[levelNo][lp][1] & 0xCF); 
                        tmpData2 = (U8)(HighByte(trigOut[lp2].data) & 0xCF);
                        trigBuf[levelNo][lp][1] = (U8)(tmpData1 | tmpData2 | trigOut[lp2].trigoutPtn);  
                     } else {  // ** do not set trig out act **
                        trigBuf[levelNo][lp][1] |= HighByte(trigOut[lp2].data);  
                     }
                  // ** low Byte **
                     tmpData1 = trigBuf[levelNo][lp][0];                       
                     /*** mask initial level no for setting seq. level ***/
                     trigBuf[levelNo][lp][0] = (U8)((tmpData1 & 0xFC) | LowByte(trigOut[lp2].data));
                  }
               }
            }
         }
//	status = WriteSeqRAMs((U8)levelNo,(U8 *)trigBuf);
      }
   }
   status = WriteSeqRAMs((U8 _far *)&(trigBuf[3][BUF_SIZE-1][1]),
                 (U8 _far *)SeqRamBuf);

   outp(0xf346,1);
   run0Active = (U8 far *) MK_FP(0xb000, 0xbfff); // get state machine address 0 pointer
//   if (tcFlag == TC_TIMER) *run0Active = 0xef; // set run0 active.
//   else *run0Active = 0xff; // set run0 inactive.
   return(status);
}

/****************************************************************************
**
**  EmuSetTimerCounter
**
**  Description: Michelle trace-group routine, to define the trigger setting.
**
**  Parameters:
**     input:
**        ******* this function will be defined later............
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
*****************************************************************************/
VOID EmuSetTimerCounter(U16 setFlag, U32 setData0,U32 setData1) {

   tcFlag = setFlag;
   counter0 = setData0;
   counter1 = setData1;
   TrcCtrlByte = (U8)((TrcCtrlByte & 0xFC) | (U8)(setFlag & 0x03));
   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   OutputStatus(GOOD,ON);
}

/***************************************************************************
**
**  EmuSetQualTrace()
**
**  Description: Michelle trace-group routine, to set qualify trace.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuSetQualTrace(U32 addr,U32 addrMask,U16 qStatus,U16 qStatusMask) {

   QualTrace(addr,addrMask,qStatus,qStatusMask);
   OutputStatus(GOOD,ON); /* always return GOOD */
}

/***************************************************************************
**
**  EmuDisableQual()
**
**  Description: Michelle trace-group routine, to disable qualify trace.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
****************************************************************************/
VOID EmuDisableQual(VOID) {

   QualDisable();
   OutputStatus(GOOD,ON); /* always return GOOD */
}

VOID EmuSetTrigOutAct(ACTIVE_STATE trigOutAct) {

   TrigOutAction = trigOutAct;
   OutputStatus(GOOD,ON);
}

VOID EmuTraceAction(U8 action) {
//   STATUS status;

   if (action == 1)
      TraceStart();
   else
      TraceStop();
   OutputStatus(GOOD,ON);
}

VOID EmuReadFrameStamp(U16 bufId,S32 frameNo) {
   U8 stamp[5] = {0,0,0,0,0};

   if (frameNo == 0x80000000l)
      ReadHaltTimeStamp(stamp);
   else
      ReadTimeStamp(0,frameNo,stamp);
   OutputStatus(GOOD,OFF);
   OutData(sizeof(U32),stamp,OFF);
   OutData(sizeof(U8),stamp+4,OFF);
   OutEnd();
}
VOID EmuSetFROM(U8 *data) {

   WriteSerialEEPROM(data);
   OutputStatus(GOOD,ON);
}

VOID EmuGetFROM() {
   U8 data[32];

   ReadSerialEEPROM(data);
   OutputStatus(GOOD,OFF);
   OutData(sizeof(data),data,ON);
   OutEnd();
}

/*******************************
 *  gene 8/2/96 SPA functions  *
 *******************************/

VOID EmuSPASetRange(U8 type,U8 rangeID,ADDR *startAddr,ADDR *endAddr) {
   STATUS status = GOOD;

   switch(type) {
   case MA_RANGE :
      if (rangeID < SPA_MA_RANGE_NO) {
         spaMARangeTable[rangeID].used = TRUE;
         spaMARangeTable[rangeID].start = startAddr->pos;
         spaMARangeTable[rangeID].end = endAddr->pos;
         spaMARangeTable[rangeID].space = startAddr->space;
      } else
         status = INVALID_RANGE_NO;
      break;
   case TA_RANGE :
      if (rangeID < SPA_TA_RANGE_NO) {
         spaTARangeTable.used = TRUE;
         spaTARangeTable.start = startAddr->pos;
         spaTARangeTable.end = endAddr->pos;
         spaTARangeTable.space = startAddr->space;
      } else
         status = INVALID_RANGE_NO;
      break;
   case CC_RANGE :
      if (rangeID < SPA_CC_RANGE_NO) {
         spaCCRangeTable[rangeID].used = TRUE;
         spaCCRangeTable[rangeID].addr = startAddr->pos;
         spaCCRangeTable[rangeID].space = startAddr->space;
      } else
         status = INVALID_RANGE_NO;
      break;
   default: break;
   }
   OutputStatus(status,ON);
}

VOID EmuSPAClearRange(U8 type) {
   STATUS status = GOOD;
   U8 i;

   switch (type) {
   case MA_RANGE:
      for (i = 0; i < SPA_MA_RANGE_NO; i++) {
         spaMARangeTable[i].used = FALSE;
         spaMARangeTable[i].start = 0;
         spaMARangeTable[i].end = 0;
         spaMARangeTable[i].space = 0;
         spaRangeMatchCounter[i] = 0;
      }
      break;
   case TA_RANGE:
      spaTARangeTable.used = FALSE;
      spaTARangeTable.start = 0;
      spaTARangeTable.end = 0;
      spaTARangeTable.space = 0;
      spaRangeMatchCounter[0] = 0;
      break;
   case CC_RANGE:
      for (i = 0; i < SPA_CC_RANGE_NO; i++) {
         spaCCRangeTable[i].used = FALSE;
         spaCCRangeTable[i].addr = 0;
         spaCCRangeTable[i].space = 0;
         spaCCRangeTable[i].status = 0;
      }
      break;
   default: break;
   }
   OutputStatus(status,ON);
}

VOID SPASetEventAndTrig(S16 mode) {
   U8 i, id, evCount = 0, RangeUsed = SPA_MA_RANGE_NO;
   BUS_EVENT tmpBusEvent;

   // initial value
   TotalRunStamp = 0;

   memset(&tmpBusEvent,0,sizeof(BUS_EVENT));
   memset(&trig,0,sizeof(TRIGGER));                        // clear all
   for (i = 1; i < TRIG_NO; i++)                           // bus event
      memcpy(&(trigLevel[i]),&trig,sizeof(TRIGGER));       // and trigger
   tmpBusEvent.enable = 1;
   tmpBusEvent.addrSpec = SINGLE_ADDR;
   tmpBusEvent.addrHigh = 0xFFFFFFFFl;
   tmpBusEvent.addrRangeMask = 0xFFFFFFFFl;
   tmpBusEvent.statusFlag = 1;
   tmpBusEvent.status2.status2Low = 0x0018l;
   tmpBusEvent.status2.status2High = 0x00F8l;
   AccessBusEvent(CLEAR_ALL, noUse,(BUS_EVENT *)&noUse);
   switch(mode) {
   case SPA_TA_RUN :
      memset(&spaTAInfoTable,0,sizeof(SPA_TA_INFO_NODE));
      spaTAInfoTable.shortest = 0xFFFFFFFFl;
      if (spaTARangeTable.used) {                        // range setting
         tmpBusEvent.status2.status2Low |= (((U32)spaTARangeTable.space) << 5);
         tmpBusEvent.addrLow = spaTARangeTable.start;
         AccessBusEvent(WRITE_ONE,1,&tmpBusEvent);
         tmpBusEvent.addrLow = spaTARangeTable.end;
         AccessBusEvent(WRITE_ONE,2,&tmpBusEvent);
         trig.defined = 1;
         trig.ev[evCount] = 1;
         trig.act[evCount++] = 0xC04;
         trig.ev[evCount] = 2;
         trig.act[evCount++] = 0xC04;
      }
      ClearAllEvent();
      SetAllBusEvent(busEvent);  /* Set event */
      memcpy(&(trigLevel[0]),&trig,sizeof(TRIGGER));
      break;
   case SPA_MA_RUN :
      for (i=0; i < SPA_MA_RANGE_NO; i++)
         memset(&(spaMAInfoTable[i]),0,sizeof(SPA_MA_INFO_NODE));
      for (id=0; id < SPA_MA_RANGE_NO; id++) {                      // check for SPA
         if (spaMARangeTable[id].used) {                        // range setting
            tmpBusEvent.status2.status2Low |=
                              (((U32)spaMARangeTable[id].space) << 5);
            tmpBusEvent.addrLow = spaMARangeTable[id].start;
            AccessBusEvent(WRITE_ONE,id*2+1,&tmpBusEvent);
            tmpBusEvent.addrLow = spaMARangeTable[id].end;
            AccessBusEvent(WRITE_ONE,id*2+2,&tmpBusEvent);
            trig.defined = 1;
            trig.ev[evCount] = id*2+1;
            trig.act[evCount++] = 0xC04;
            trig.ev[evCount] = id*2+2;
            trig.act[evCount++] = 0xC04;
         }
      }
      ClearAllEvent();
      SetAllBusEvent(busEvent);  /* Set event */
      memcpy(&(trigLevel[0]),&trig,sizeof(TRIGGER));
      break;
//   case SPA_CC_RUN :
//      break;
   }
}

VOID SPAHandleStatus(U16 mode) {
   U32 baseReg[MAX_BASE_REG_NO];
   U16 runFlag;
   U8 tmpStamp1[5], evNo, rangeNo, lp, tmpEv;
   U32 tRange, phyAddr;

//   QUALIFY_LIST condition;
//   TRACE_HEAD traceHead;
//   U8 traceBuffData[3*19];
   STATUS status;

   AccessIceFlag(READ_ONE,RUNNING,&runFlag);
   if ((runFlag == OFF) && flagHalt) return;

   if (RunAndMatch()) {
//      status = CheckHwStatus();
      status = GoEnd(baseReg);
      if ((status == 4) && runFlag) {
//         GoEnd(baseReg);
         phyAddr = baseReg[R_PC];
         SPAListTrace(tmpStamp1,&tmpEv);
         for (lp=0; lp<8 ;lp++) {
            if (tmpEv & 0x01) break;
            tmpEv = (U8)(tmpEv >> 1);
         }
         evNo = (U8)(lp+1);

         switch(mode) {
         case SPA_MA_RUN :
            if ((evNo >= 1) && (evNo <= 8)) {
               rangeNo = (U8)((evNo-1) >> 1);
               for (lp = 0; lp < SPA_MA_RANGE_NO; lp++) {
                  if (spaRangeMatchCounter[lp]) {
                     spaMAInfoTable[lp].totalStamp += *(U32 *)tmpStamp1;
                  }
               }
               if (spaMARangeTable[rangeNo].used) {
                  if (evNo & 0x01) {
                     if ((phyAddr <= spaMARangeTable[rangeNo].start) ||
                         (phyAddr > spaMARangeTable[rangeNo].end))
                        break;
                   } else {
                     if (phyAddr == spaMARangeTable[rangeNo].end)
                        break;
                   }
               }
               if ((evNo & 0x01) == 1) {
                  (spaMAInfoTable[rangeNo].count)++;
                  spaRangeMatchCounter[rangeNo]++;
               } else {
                  if (spaRangeMatchCounter[rangeNo] > 0)
                     spaRangeMatchCounter[rangeNo]--;
               }
            }
            break;
         case SPA_TA_RUN :
            if (spaRangeMatchCounter[0])
               spaTAInfoTable.tmpStamp += *(U32 *)tmpStamp1;
            if (evNo == 1) {
               if ((phyAddr >= spaTARangeTable.start) && (phyAddr <= spaTARangeTable.end))
                  spaRangeMatchCounter[0]++;
            } else if (evNo == 2) {
               if (spaTAInfoTable.tmpStamp > spaTAInfoTable.longest)
                  spaTAInfoTable.longest = spaTAInfoTable.tmpStamp;
               if (spaTAInfoTable.tmpStamp < spaTAInfoTable.shortest)
                  spaTAInfoTable.shortest = spaTAInfoTable.tmpStamp;
               spaTAInfoTable.totalStamp += spaTAInfoTable.tmpStamp;
               tRange = spaTAInfoTable.tmpStamp / 200;
               for (lp = 0; (tRange != 0) && (lp < 9); lp++)
                  tRange = tRange / 10;
               (spaTAInfoTable.count[lp])++;
               if (spaRangeMatchCounter[0] > 0)
                  spaRangeMatchCounter[0]--;
               spaTAInfoTable.tmpStamp = 0;  // *gene*
            }
            break;
         }
         TotalRunStamp += *(U32 *)tmpStamp1;
         ProgramTMANTrace(1);  // default TRACE OFF
         GoEp(baseReg);
      } else {
//         ReadTimeStamp(0,endLogFrameOfTrcBuf[0],tmpStamp1);
         SPAListTrace(tmpStamp1,&tmpEv);
         TotalRunStamp += *(U32 *)tmpStamp1;
         switch (mode) {
         case SPA_MA_RUN :
            for (lp = 0; lp < SPA_MA_RANGE_NO; lp++) {
               if (spaRangeMatchCounter[lp]) {
                  spaMAInfoTable[lp].totalStamp += *(U32 *)tmpStamp1;
               }
            }
            break;
         case SPA_TA_RUN :
            if (spaRangeMatchCounter[0])
               spaTAInfoTable.tmpStamp += *(U32 *)tmpStamp1;
            break;
         }
         if (runFlag != OFF) {
//            AccessBaseReg(READ_ALL,noUse,baseReg);
//            GoEnd(baseReg);
            AccessBaseReg(WRITE_ALL,noUse,baseReg);
            DisEmStop();
            if (status == GOOD) status = CheckViolation();
            AccessIceFlag(WRITE_ONE,FLYING,&C_OFF);
            AccessIceFlag(WRITE_ONE,RUNNING,&C_OFF);
//            AccessIceFlag(WRITE_ONE,BROKE_REASON,&status);
            Exbp1Disable();
            Exbp2Disable();
         }
         flagHalt = TRUE;
         AccessIceFlag(WRITE_ONE,MODE_FLAG,&C_OFF);
      }
   }
}

VOID EmuSPAGetMAInfo(VOID) {
   U8 i, ENDING = 0xFF;

   OutputStatus(GOOD,OFF);
   OutData(sizeof(U8),&flagHalt,ON);
   OutData(sizeof(TotalRunStamp),&TotalRunStamp,ON);
   for (i = 0; i < SPA_MA_RANGE_NO ; i++) {
      if (spaMARangeTable[i].used) {
         OutData(1,&i,ON);
         OutData(2,&(spaMAInfoTable[i].count),ON);
         OutData(4,&(spaMAInfoTable[i].totalStamp),ON);
      }
   }
   OutData(1,&ENDING,OFF);
   OutEnd();
}

VOID EmuSPAGetTAInfo(VOID) {
   U32 shortest;

   if (spaTAInfoTable.shortest == 0xFFFFFFFFl)
      shortest = 0;
   else
      shortest = spaTAInfoTable.shortest;
   OutputStatus(GOOD,OFF);
   OutData(1,&flagHalt,ON);
   OutData(4,&(spaTAInfoTable.totalStamp),ON);
   OutData(4,&(spaTAInfoTable.longest),ON);
   OutData(4,&shortest,ON);
   OutData(sizeof(spaTAInfoTable.count),spaTAInfoTable.count,ON);
   OutEnd();
}

VOID EmuSPASetBkpt(U8 enable,ADDR *addr) {
   U16 zero = 0, one = 1;

   if (enable) {
      ExbpSet(addr->pos,addr->space,1);
      AccessStatusFlag(WRITE_ONE,BKPT,&zero);
   } else
      AccessStatusFlag(CLEAR_ONE,BKPT,&zero);
   AccessStatusFlag(CLEAR_ONE,BKPT,&one);
   OutputStatus(GOOD,ON);
}

VOID EmuSPAClose(VOID) {
U16 i;

   EmuAbort();
   SPARestEvtAndTrig();
   for (i=0 ; i<2 ; i++) {
      if (execEvent[i].enable) {
         ExbpSet(execEvent[i].addr.pos,execEvent[i].addr.space,i+1);
         AccessStatusFlag(WRITE_ONE,BKPT,&i);
      } else
         AccessStatusFlag(CLEAR_ONE,BKPT,&i);
   }
   AccessIceFlag(WRITE_ONE,PHY_TRIG_SET,&C_OFF);
   AccessIceFlag(WRITE_ONE,MODE_FLAG,&C_OFF);
   OutputStatus(GOOD,OFF);
   OutEnd();
}

VOID EmuSPAOpen(VOID) {

   SPABakEvtAndTrig();
   OutputStatus(GOOD,OFF);
   OutEnd();
}

/******************************************
**  max bytes length is CC_INFO_LEN
**  ==> (len / 8) < CC_INFO_LEN
**  startAddr is 8-bytes boundary
**  len is (8 * n)
*******************************************/
VOID EmuSPAGetCCInfo(ADDR *startAddr,U16 len,U8 flag) {
   U8 outBuf[CC_INFO_LEN],tmpLen;
   U16 byteLen,count,i;

   OutputStatus(GOOD,OFF);
   if (flag == 0) {
      OutData(sizeof(U8),&flagHalt,ON);
      OutEnd();
   } else {
      byteLen = len >> 3; 
      ListCodeCov(startAddr,len,outBuf);
      OutData(sizeof(U8),&flagHalt,ON);
      OutData(sizeof(byteLen),&byteLen,OFF);
      count = (byteLen-1) / 255 ;
      for (i = 0; i < count; i++)
         OutData(255,&(outBuf[i*255]),OFF);
      tmpLen = (U8)(byteLen - (255 * i));
      OutData(tmpLen,&(outBuf[i*255]),OFF);
      OutEnd();
   }
}

VOID SPAProgramTMANCodeCov() {

   ProgramMNCodeCov(spaCCRangeTable);
}

VOID SPABakEvtAndTrig(VOID) {
   memcpy(bakBusEvent,busEvent,sizeof(busEvent));
   memcpy(&bakTrig,&(trigLevel[0]),sizeof(TRIGGER));
}

VOID SPARestEvtAndTrig(VOID) {
   memcpy(busEvent,bakBusEvent,sizeof(busEvent));
   ClearAllEvent();
   SetAllBusEvent(busEvent);
   memcpy(&(trigLevel[0]),&bakTrig,sizeof(TRIGGER));
}
/******************************** E O F ***********************************/
