#
#  Name: makefile.mak
#
#  Description: Make definitions for TBird shared data server
#
#  $Log:   S:/tbird/arcmtat2/m307/makefile.mav  $
#  
#     Rev 1.0   20 Mar 1997 13:20:30   gene
#  Initial revision.
#  
#     Rev 1.2   17 Mar 1997 09:31:28   gene
#  
#     Rev 1.1   26 Feb 1997 10:17:40   gene
#  
#     Rev 1.0   12 Feb 1997 14:21:42   gene
#  Initial revision.
#  
#     Rev 1.2   23 Jul 1996 11:16:06   gene
#  changed for mp302
#  
#     Rev 1.1   11 Jun 1996 14:31:02   gene
#  
#     Rev 1.0   10 Jun 1996 08:50:58   gene
#  Initial revision.
#  
#     Rev 1.3   13 Feb 1996 17:41:40   gene
#  changed directory of tools
#  
#     Rev 1.2   04 Dec 1995 15:52:04   kevin
#  128kb -> 256kb
#  
#     Rev 1.1   15 Nov 1995 16:32:08   kevin
#  function test
#  
#     Rev 1.0   07 Sep 1995 10:47:36   gene
#  Initial revision.
#
#  $Header:   S:/tbird/arcmtat2/m307/makefile.mav   1.0   20 Mar 1997 13:20:30   gene  $
#
#  COPYRIGHT (C) 1992 MICROTEK INTERNATIONAL, INC.
#

.AUTODEPEND
#.SWAP

#
# files
#
SRC = .
ASMSRC = asm
BIN = bin
CCDIR = d:\C600\bin
INC = d:\C600\include
LNKDIR = d:\lnkloc\bin
TMPDIR = c:\temp

#
# paths
#
.PATH.lst = $(SRC)
.PATH.c   = $(SRC)
.PATH.db  = $(ASMSRC)
.PATH.tbl = $(ASMSRC)
.PATH.equ = $(ASMSRC)
.PATH.def = $(ASMSRC)
.PATH.asm = $(ASMSRC)
.PATH.a00 = $(ASMSRC)
.PATH.obj = $(BIN)
.PATH.lib = $(BIN)
.PATH.ssi = $(BIN)
.PATH.lnk = $(BIN)
.PATH.ABS = $(BIN)
.PATH.HEX = $(BIN)

#               *Translator Definitions*
LINK = $(LNKDIR)\xlink86
LOC = $(LNKDIR)\xloc86
PROM = $(LNKDIR)\prom86
OH86 = $(LNKDIR)\xoh86
CV2OMF = $(LNKDIR)\cv2omf
CONV = $(USDDIR)\CONVERT
CHKSUM = mice3chk
CC = $(CCDIR)\cl
#CC = $(CCDIR)\bcc
MASM = $(CCDIR)\masm
#MASM = $(CCDIR)\tasm
CFLAG = /AM /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = /AM /G1 /Gs /Od /Zp /c /FPa /Zi /W3
#CFLAG = /AL /G1 /Gs /Od /Oi /Zp /c /FPa /Zi /W3
#CFLAG = -c -f- -mm -v -vi -y -w
CODEGEN = codegen

#               *Implicit Rules*
.C.obj:
 $(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
# $(CC) $(CFLAG) /I. /I./asm /I$(INC) /Fs$(SRC)\ERR /Fo$(SRC)\bin\$&.obj $(SRC)\$&.C
# $(CC) $(CFLAG) /I. /I$(INC) /Fc$(SRC)\$&.COD /Fo$(BIN)\$&.obj $(SRC)\$&.C
#$(CC) $(CFLAG) -I. -I$(INC) -o$(BIN)\$&.obj $(SRC)\$&.C
# find ": error " $(SRC)\err.lst > $&.lst
# find ": warning " $(TMPDIR)\err.lst >> $&.lst

.A00.obj:
# $(MASM) /Mx /Zi $&.Asm,$(BIN)\$&,$(SRC)\$&;
 $(MASM) /Mx /Zi /W2 /z /Zd /I$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(SRC)\ERR;
#$(MASM) /Mx /Zi /w /z /i$(ASMSRC) $(ASMSRC)\$&.A00,$(BIN)\$&,$(SRC)\ERR;
# find "error " $(SRC)\err.lst > $&.lst
# find "warning " $(TMPDIR)\err.lst >> $&.lst

# define all objs
#LNK_depends =  start.obj emumain.OBJ functest.obj emucomm.obj emuemul.obj \
LNK_depends =  start.obj epm307.obj emumain.OBJ emucomm.obj \
               functest.obj emuemul.obj emuerror.obj emumem.obj emulib.obj \
               emusetup.obj emutrace.obj emullfw.obj covrbw.obj trclib.obj \
               ovmem.obj trcevent.obj trctman.obj trcflex.obj codecov.obj
#

MAIN307.BIN : MAIN307.OMF
 $(PROM)  $(BIN)\MAIN307.ABS TO $(BIN)\MAIN307.BIN ADDRESSES(0400H, 03FFFFH) CHECKSUM

MAIN307.OMF : MAIN307.ABS
 $(CV2OMF) $(BIN)\MAIN307.ABS TO $(BIN)\MAIN307.OMF

MAIN307.ABS : MAIN307.LNK
 $(LOC)  @&&!
            $(BIN)\MAIN307.LNK TO $(BIN)\$&.ABS &
            NOIC &               Do not generate new segment for register initialization
            ORDER(CLASSES(&
                 CODE,&
                 CODE_END,&
                 FAR_DATA_BEG,FAR_DATA,FAR_DATA_END,&
                 DATA_BEG,&
                 DATA,&
                 CONST,&
                 DATA_END,&
                 MSG,&
                 BSS, &
                 BSS_END&
&                 XSEG,&
&                 NMCS2H,&
            )) &
            RESERVE(00H TO 03FFH) &
            ADDRESSES(CLASSES( &
               CODE(00400H), DATA_BEG(080000H),&
               STACK(08C000H),&
               XSEG(090000H),NMCS2H(0D0000H),&
               DATA2(0A0000H),&
               DATA1(0C0000H),&
               DEBSYM(040000H),DEBTYP(048000H)),&
               GROUPS(DGROUP(080000H)) &
            )&
            SEGSIZE(STACK(04000H))&
            MAP &
            ST(INIT)&
            BS
!


#               *Explicit Rules*

# .A00  condition definition start!
epm307.obj : epm307.a00 cpm.equ epm.equ sio.equ cpmio.def \
            nmcs2h.def xseg.def can307.db
start.obj : start.a00
ovmem.obj : ovmem.a00
covrbw.obj : covrbw.a00

# .C  condition definition
emumain.obj  : emumain.c emucomm.h emuerror.h emullfw.h emutypes.h
functest.obj : functest.c functest.h emuerror.h emullfw.h emutypes.h
emucomm.obj : emucomm.c emucomm.h emuerror.h emullfw.h
emuemul.obj  : emuemul.c  emuemul.h emuerror.h emullfw.h
emuerror.obj : emuerror.c emuerror.h emuerror.h emullfw.h
emumem.obj   : emumem.c   emumem.h emuerror.h emullfw.h
emusetup.obj : emusetup.c emusetup.h emuerror.h emullfw.h
emutrace.obj : emutrace.c emutrace.h emuerror.h emullfw.h emutypes.h
emulib.obj   : emulib.c  emulib.h emuerror.h emullfw.h
trctman.obj     : trctman.c trctman.h trcerror.h trclib.h
trcevent.obj    : trcevent.c trcevent.h trcerror.h trclib.h
trclib.obj   : trclib.c trclib.h
trcflex.obj  : trcflex.c trcflex.h trcerror.h trclib.h pio.ttf pipe4.ttf p4pio.ttf pipe.ttf 
codecov.obj  : codecov.c trctman.h trcerror.h trclib.h codcov.ttf

# Template file for dummy low level FW
emullfw.obj   : emullfw.c  emullfw.h


#MAIN307.hex : MAIN307.abs
#$(OH86) $&
# $(CHKSUM) $&.hex 0 0d0000 0ffffb 0ffffe

MAIN307.LNK : $(LNK_depends)
 $(LINK) @&&!
             $(BIN)\start.obj,$(BIN)\emumain.obj,$(BIN)\emulib.obj,&
             $(BIN)\functest.obj,$(BIN)\emucomm.obj,$(BIN)\emuemul.obj,&
             $(BIN)\emuerror.obj,$(BIN)\emumem.obj,$(BIN)\emusetup.obj,&
             $(BIN)\emutrace.obj,$(BIN)\emullfw.obj,$(BIN)\epm307.obj,&
             $(BIN)\ovmem.obj,$(BIN)\covrbw.obj,$(BIN)\trcevent.obj,&
             $(BIN)\trctman.obj,$(BIN)\trclib.obj,$(BIN)\codecov.obj,&
             $(BIN)\trcflex.obj,$(BIN)\MLIBCE.SSI TO $(BIN)\MAIN307.LNK
!

