/****************************************************************************
**
** Name: trcevent.c
**
** Description:
**   Bus event setting services
**
** Status: PRELIMINARY
**
** Copyright (C) 1997 Microtek International. All rights reserved.
**
****************************************************************************/

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include <string.h>
#include <conio.h>
#include <dos.h>

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif
#ifndef _TRCEVENT_
#include "trcevent.h"
#endif
#ifndef _TRCDTST_
#include "trclib.h"
#endif
#ifndef _TRCTMAN_
#include "trctman.h"
#endif
#ifndef _TRCFLEX_
#include "trcflex.h"
#endif


                       /****************************
                        *                          *
                        *    LOCAL DEFINITIONS     *
                        *                          *
                        ****************************/


#define EVENT_QUANTITY 8

U8 _based(_segname("_CODE")) MNCPRWByte[] = {
#include "smain.ttf"
};


#define Rport       0x00
#define Sport       0x01
#define Tport       0x02
#define Uport       0x03
#define Vport       0x04
#define Wport       0x05

#define DMA1SL      0xFFD0
#define DMA1SH      0xFFD2
#define DMA1DL      0xFFD4
#define DMA1DH      0xFFD6
#define DMA1TC      0xFFD8
#define DMA1CW      0xFFDA
#define NPACS       0xFFA4
#define NMPCS       0xFFA8

/* P0-P3 control port corresponding bit define */

#define nOEA           0x10
#define nOEX           0x08
#define nOEY           0x04

/* P0 port address define */

#define WriteP0Byte1    0xF300
#define WriteP0Byte2    0xF301
#define WriteP0Byte3    0xF302
#define WriteP0Byte4    0xF303
#define ReadP0CtrlPort  0xF304
#define P0CtrlPort      0xF307

/* P1 port address define */

#define WriteP1Byte1    0xF308
#define WriteP1Byte2    0xF309
#define WriteP1Byte3    0xF30A
#define WriteP1Byte4    0xF30B
#define ReadP1CtrlPort  0xF30C
#define P1CtrlPort      0xF30F

/* P2 port address define */

#define WriteP2Byte1    0xF310
#define WriteP2Byte2    0xF311
#define WriteP2Byte3    0xF312
#define WriteP2Byte4    0xF313
#define ReadP2CtrlPort  0xF314
#define P2CtrlPort      0xF317

/* P3 port address define */

#define WriteP3Byte1    0xF318
#define WriteP3Byte2    0xF319
#define WriteP3Byte3    0xF31A
#define WriteP3Byte4    0xF31B
#define ReadP3CtrlPort  0xF31C
#define P3CtrlPort      0xF31F

/* P4 port address define */

#define P4CtrlAX   0xF325
#define P4CtrlAY   0xF326
#define P4CtrlB    0xF327

/* MN port address define */

#define SetLo      0xF328
#define SetHi      0xF329
#define MaskLo     0xF32A
#define MaskHi     0xF32B
#define RWTrig     0xF32C
#define MNCtrlAX   0xF32D
#define MNCtrlAY   0xF32E
#define MNCtrlB    0xF32F

/* CPIO port address define */

#define ChgWr      0xF338

/* P0-P3 control port corresponding bit define */

#define nOEA       0x10
#define nOEX       0x08
#define nOEY       0x04
#define FSld       0x01

/* Main control port corresponding bit define */

#define SEQ       0x04
#define DOE       0x02
#define BCK       0x01

/* I/O corresponding bit define */

#define EnBCWr     0x20
#define Done       0x80


U8 ctrlbyte;
U16 _based(_segname("_CODE")) CtrlPort[6]=
{P0CtrlPort,P0CtrlPort,P1CtrlPort,P1CtrlPort,P2CtrlPort,P2CtrlPort};
U16 _based(_segname("_CODE")) ReadCtrlPort[6]=
{ReadP0CtrlPort,ReadP0CtrlPort,ReadP1CtrlPort,ReadP1CtrlPort,ReadP2CtrlPort
,ReadP2CtrlPort};
U16 _based(_segname("_CODE"))  WrByte1[6] =
{WriteP0Byte1,WriteP0Byte1,WriteP1Byte1,WriteP1Byte1,WriteP2Byte1,WriteP2Byte1};
U16 _based(_segname("_CODE"))  WrByte2[6] =
{WriteP0Byte2,WriteP0Byte2,WriteP1Byte2,WriteP1Byte2,WriteP2Byte2,WriteP2Byte2};
U16 _based(_segname("_CODE"))  WrByte3[6] =
{WriteP0Byte3,WriteP0Byte3,WriteP1Byte3,WriteP1Byte3,WriteP2Byte3,WriteP2Byte3};
U16 _based(_segname("_CODE"))  WrByte4[6] =
{WriteP0Byte4,WriteP0Byte4,WriteP1Byte4,WriteP1Byte4,WriteP2Byte4,WriteP2Byte4};
U8 _based(_segname("_CODE"))   nOE[6] =
{nOEX,nOEY,nOEX,nOEY,nOEX,nOEY};

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern U8 FLEXConfig ;
extern U8  _far PIOByte[];
extern U8  _far PIPEByte[];
extern U8  _far P4PIPEByte[];


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

RETCODE SetOneEvent(BUS_EVENT *eventStruc,U8 eventID);
RETCODE SetRangeAddr(U32 addrlo,U32 addrhi,U32 addrmask,U8 eventID) ;
RETCODE SetSingleMask(EVENT_FIELD field,U32 value, U32 mask, U8 eventID) ;

VOID SetExternalTraceBit(U8 value,U8 mask,U8 eventID) ;

VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) ;
VOID SetBCData(U8 port,U16 mask,U16 set) ;

VOID WrBCRangeAddr(U8 port,U16 addr,U16 bit,U16 fcnt,U8 eventID) ;
VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) ;
VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) ;

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  SetExternalTraceBit
**
*******************************************************************************/
VOID SetExternalTraceBit(U8 value,U8 mask,U8 eventID) {
   U8 i,cntvalue = 0;

   for (i=0; i < 8; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
   if ( cntvalue != 0 ) {
      WrBCMaskAddr(Wport,(U16) mask,(U16) value,~(0x01 << eventID),0xFF,
                   (0x01 << cntvalue)) ;
   }
   else {
      WrBCOneAddr(Wport,(U16) value,0x01,0xFF,eventID);
   }
}
/******************************************************************************
**
**  SetAllBusEvent
**
*******************************************************************************/
RETCODE SetAllBusEvent(BUS_EVENT *events) {
   RETCODE err;
   U8 eventID;

   for (eventID = 0; eventID < EVENT_QUANTITY; eventID++) {
      if ((err = SetOneEvent(&events[eventID], eventID)) != GOOD)
         return(err);
   }

   outp(LA0A1nOE,0);

   return(GOOD);
}

/******************************************************************************
**
**  SetRangeAddr
**
**  Description:
**    Set upper or lower bound of range addr of one event
**
**  Parameters:
**    input:
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetRangeAddr(U32 addrlo,U32 addrhi,U32 addrmask,U8 eventID) {
   U16 addrloHiByte,addrloLoByte,addrhiHiByte,addrhiLoByte,fcnthi,fcntlo;
   U16 cntvalue,i;

   addrloHiByte = (U16) (addrlo >> 16) ;
   addrloLoByte = (U16) addrlo ;
   addrhiHiByte = (U16) (addrhi >> 16) ;
   addrhiLoByte = (U16) addrhi ;
   fcnthi = addrhiHiByte-addrloHiByte;
   if (addrmask == 0xFFFFFFFF) {
      switch (fcnthi) {
         case 0 :
            WrBCOneAddr(Rport,addrloHiByte,0x0101,0x0100,eventID);
            break;
         case 1 :
            WrBCOneAddr(Rport,addrhiHiByte,0x0001,0x00,eventID);
            WrBCOneAddr(Rport,addrloHiByte,0x0100,0x00,eventID);
            break;
         case 2 :
            WrBCOneAddr(Rport,addrhiHiByte,0x0001,0x00,eventID);
            WrBCOneAddr(Rport,addrloHiByte+1,0x0001,0x00,eventID);
            WrBCOneAddr(Rport,addrhiHiByte-1,0x0100,0x00,eventID);
            WrBCOneAddr(Rport,addrloHiByte,0x0100,0x00,eventID);
            break;
         default:
            WrBCRangeAddr(Rport,addrloHiByte+1,0x0001,(0xFFFF-(fcnthi-2)),eventID) ;
            WrBCRangeAddr(Rport,addrloHiByte,0x0100,(0xFFFF-(fcnthi-2)),eventID) ;
            break;
      }
   }
   else {
      for (i=0; i <16; i++) if ( (~(addrmask >> 16) >> i) & 1 ) cntvalue++;
      for (i=0;i <= fcnthi;i++) {
         WrBCMaskAddr(Rport,(U16) (addrmask >> 16),(U16) (addrloLoByte+i),
                     ~(0x0101 << eventID),(0x01<< eventID),(0x01 << cntvalue)) ;
      }
   }
   if ( fcnthi != 0 ) {
      if ( addrloLoByte == addrhiLoByte )
         WrBCOneAddr(Sport,addrhiLoByte,0x0101,0,eventID);
      else {
         switch(0xFFFF-addrloLoByte) {
            case 0 :
               WrBCOneAddr(Sport,0xFFFF,0x0001,0,eventID);
               break;
            case 1 :
               WrBCOneAddr(Sport,0xFFFF,0x0001,0,eventID);
               WrBCOneAddr(Sport,0xFFFE,0x0001,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,addrloLoByte,0x0001,((addrloLoByte-2)),eventID);
               break;
         }
         switch(addrhiLoByte) {
            case 0 :
               WrBCOneAddr(Sport,0,0x0100,0,eventID);
               break;
            case 1 :
               WrBCOneAddr(Sport,0,0x0001,0,eventID);
               WrBCOneAddr(Sport,1,0x0001,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,0,0x0001,(0xFFFF-(addrhiLoByte-2)),eventID);
               break;
         }
      }
   }
   else {
      if (addrloLoByte < addrhiLoByte ) {
         fcntlo = addrhiLoByte - addrloLoByte;
         switch (fcntlo) {
            case 1 :
               WrBCOneAddr(Sport,addrloLoByte,0x0101,0,eventID);
               WrBCOneAddr(Sport,addrhiLoByte,0x0101,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,addrloLoByte,0x0101,(0xFFFF-(fcntlo-2)),
                             eventID);
               break;
         }
      }
      else {
         fcntlo =addrloLoByte - addrhiLoByte ;
         switch (fcntlo) {
            case 1 :
               WrBCOneAddr(Sport,addrloLoByte,0x0101,0,eventID);
               WrBCOneAddr(Sport,addrhiLoByte,0x0101,0,eventID);
               break;
            default :
               WrBCRangeAddr(Sport,addrhiLoByte,0x0101,(0xFFFF-(fcntlo-2)),
                             eventID);
               break;
         }
      }
   }
   return(GOOD);
}

/******************************************************************************
**
**  SetSingleMask
**
**  Description:
**    Set addr, data or status field of one event to a single value or
**    a value with mask.
**    For a single value, set the input parameter "mask" to be 0xFFFFFFFF.
**
**  Parameters:
**    input:
**      field: ADDR_FIELD, DATA_FIELD or STATUS_FIELD
**      value: setting value
**      mask: setting mask
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetSingleMask(EVENT_FIELD field,U32 value, U32 mask, U8 eventID) {
   U8 i,cntvalue= 0;

   switch (field) {
      case ADDR_FIELD:
         for (i=0; i < 16; i++) if ( (~(mask >> 16) >> i) & 1 ) cntvalue++;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Rport,(U16) (mask >> 16),(U16) (value >> 16),~(0x0101 << eventID),
                      (0x01<< eventID),(0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Rport,(U16) (value >> 16),0x0101,0x01,eventID);
         }
         cntvalue = 0;
         for (i=0; i < 16; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Sport,(U16) mask ,(U16) value,~(0x0101 << eventID),0,
                      (0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Sport,(U16) value,0x0101,0,eventID);
         }
         break;
      case DATA_FIELD:
         for (i=0; i < 16; i++) if ( (~(mask >> 16) >> i) & 1 ) cntvalue++;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Tport,(U16) (mask >> 16),(U16) (value >> 16),~(0x01 << eventID),
                         0xFF,(0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Tport,(U16) (value >> 16),0x01,0xFF,eventID);
         }
         cntvalue = 0;
         for (i=0; i < 16; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Uport,(U16) mask ,(U16) value,~(0x01 << eventID),0xFF,
                      (0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Uport,(U16) value,0x01,0xFF,eventID);
         }
         break;
      case STATUS_FIELD:
         for (i=0; i < 16; i++) if ( (~mask >> i) & 1 ) cntvalue++ ;
         if ( cntvalue != 0 ) {
            WrBCMaskAddr(Vport,(U16) mask ,(U16) value,~(0x01 << eventID),0xFF,
                      (0x01 << cntvalue)) ;
         }
         else {
            WrBCOneAddr(Vport,(U16) value,0x01,0xFF,eventID);
         }
         break;
   }
   return(GOOD);
}

/******************************************************************************
**
**  SetOneEvent
**
**  Description:
**    Set one busevent
**
**  Parameters:
**    input:
**      *eventStruct: the event setting
**    output:
**      <none>
**
*******************************************************************************/
RETCODE SetOneEvent(BUS_EVENT *eventStruct,U8 eventID) {
   RETCODE err;

   if (eventStruct->enable == NO) return(GOOD);
   switch (eventStruct->addrSpec) {
      case UNDEFINE_ADDR:
         WrBCMaskAddr(Rport,0,0,~(0x0101 << eventID),0,0);
         break;
      case RANGE_ADDR:
         if ((err = SetRangeAddr(eventStruct->addrLow,eventStruct->addrHigh,
             eventStruct->addrRangeMask,eventID)!= GOOD)) return(err);
         break;
      case SINGLE_ADDR:
      case MASK_ADDR:
         if ((err = SetSingleMask(ADDR_FIELD,eventStruct->addrLow,eventStruct
            ->addrHigh,eventID)) != GOOD) return(err);
         break;
   }
   switch (eventStruct->dataSpec) {
      case UNDEFINE_DATA:
         WrBCMaskAddr(Tport,0,0,~(0x01 << eventID),0xFF,0);
         WrBCMaskAddr(Uport,0,0,~(0x01 << eventID),0xFF,0);
         break;
      case SINGLE_DATA:
      case MASK_DATA:
         if ((err = SetSingleMask(DATA_FIELD,eventStruct->dataLow,eventStruct
            ->dataHigh,eventID)) != GOOD) return(err);
         break;
   }
   if ((err = SetSingleMask(STATUS_FIELD,eventStruct->status2.status2Low,eventStruct->status2.status2High,
        eventID)) != GOOD) return(err);
   SetExternalTraceBit(eventStruct->status2.TraceBitLow,eventStruct->status2.TraceBitHigh,eventID);
   return(GOOD);
}

/******************************************************************************
**
**  ClearAllEvent
**
**  Description:
**    Clear all busevent
**
**  Parameters:
**    input:
**    output:
**      <none>
**
*******************************************************************************/
RETCODE ClearAllEvent(VOID) {
   RETCODE err;

   if ((FLEXConfig | P4Pipe ) != P4Pipe ) {
     if((err =  FLEXProgram(FLEX_P4,P4PIPEByte)) != GOOD ) return(err);
     FLEXConfig &= P4Pipe;
   }
   if ((FLEXConfig & P0Pio ) != P0Pio ) {
     if((err =  FLEXProgram(FLEX_PIPE,PIOByte)) != GOOD ) return(err);
     FLEXConfig |= P0Pio ;
   }
   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= SMain ;
   }

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   outp(LA0A1nOE,0x80);
   outp(P4CtrlAX,0) ;  //Disable Bus Register output enable

   WrBCMaskAddr(Rport,0,0,0,0xFFFF,0);
   WrBCMaskAddr(Sport,0,0,0,0xFFFF,0);
   WrBCMaskAddr(Tport,0,0,0,0,0);
   WrBCMaskAddr(Uport,0,0,0,0,0);
   WrBCMaskAddr(Vport,0,0,0,0,0);
   WrBCMaskAddr(Wport,0,0,0,0,0);
}

VOID WrBCMaskAddr(U8 port,U16 addrmask,U16 addrset,U16 datamask,U16 dataset,
                  U16 fcnt) {

   outp(CtrlPort[port],0);
   addrset &= addrmask ;
   SetBCAddr(port,addrmask,addrset,fcnt);
   SetBCData(port,datamask,dataset);
   outp(P4CtrlAY,port);
   ctrlbyte = (U8) inp(ReadCtrlPort[port]);
   ctrlbyte |= EnBCWr;
   outp(ChgWr,0x80);
   outp(CtrlPort[port],ctrlbyte);
   while ((inp(ReadCtrlPort[port]) & Done) != Done ) ;
   outp(CtrlPort[port],0);
   outp(ChgWr,0);
}

VOID WrBCRangeAddr(U8 port,U16 addr,U16 bit,U16 fcnt,U8 eventID) {

   outp(P0CtrlPort,FSld);
   outpw(WriteP0Byte1,fcnt);
   outp(P0CtrlPort,0);
   outpw(WriteP0Byte1,addr);
   outpw(WriteP0Byte3,0xFFFF);
   outpw(WriteP0Byte3,0);
   outp(P0CtrlPort,nOE[port]);
   SetBCData(port,~(bit << eventID),0);
   outp(P4CtrlAY,port);
   ctrlbyte = (U8) inp(ReadP0CtrlPort);
   ctrlbyte |= EnBCWr;
   outp(ChgWr,0x80);
   outp(P0CtrlPort,ctrlbyte);
   while ((inp(P0CtrlPort) & Done) != Done ) ;
   outp(P0CtrlPort,0);
   outp(ChgWr,0);
}

VOID WrBCOneAddr(U8 port,U16 addr,U16 bit,U16 data,U8 eventID) {

   switch(port) {
      case Rport : case Sport :
         outp(CtrlPort[port],FSld);
         outpw(WrByte1[port],0xFFFF);
         outp(CtrlPort[port],0);
         outpw(WrByte1[port],addr);
         outpw(WrByte3[port],0xFFFF);
         outp(CtrlPort[port],nOE[port]);
         SetBCData(port,~(bit << eventID),(data << eventID) );
         outp(P4CtrlAY,port);
         ctrlbyte = (U8) inp(ReadCtrlPort[port]);
         ctrlbyte |= EnBCWr;
         outp(ChgWr,0x80);
         outp(CtrlPort[port],ctrlbyte);
         outp(CtrlPort[port],0);
         outp(ChgWr,0);
         break;
      case Tport : case Uport : case Vport : case Wport :
         outp(CtrlPort[port],FSld);
         outpw(WrByte1[port],0xFFFF);
         outp(CtrlPort[port],0);
         outpw(WrByte1[port],addr);
         outpw(WrByte3[port],0xFFFF);
         outp(CtrlPort[port],nOE[port]);
         SetBCData(port,~(bit << eventID),data);
         outp(P4CtrlAY,port);
         ctrlbyte = (U8) inp(ReadCtrlPort[port]);
         ctrlbyte |= EnBCWr;
         outp(ChgWr,0x80);
         outp(CtrlPort[port],ctrlbyte);
         outp(CtrlPort[port],0);
         outp(ChgWr,0);
         break;
   }
}
/******************************************************************************
**
**  SetBCData
**
*******************************************************************************/
VOID SetBCData(U8 port,U16 mask,U16 set) {

   switch(port) {
      case Rport :  case Sport :
         outp(MNCtrlAY,port);
         outpw(SetLo,set);
         outpw(MaskLo,mask);
      break ;
      case Tport : case Uport : case Vport : case Wport :
         outp(MNCtrlAY,port);
         outp(SetLo,(U8) set);
         outp(MaskLo,(U8) mask);
      break ;
   }
}

/******************************************************************************
**
** SetBCAddr
**
*******************************************************************************/
VOID SetBCAddr(U8 port,U16 mask,U16 set,U16 fcnt) {

   outp(CtrlPort[port],FSld);
   outpw(WrByte1[port],fcnt);
   outp(CtrlPort[port],0);
   outpw(WrByte1[port],set);
   outpw(WrByte3[port],0xFFFF);
   outpw(WrByte3[port],mask);
   outp(CtrlPort[port],nOE[port]);
}

/******************************************************************************
**
**  WriteSeqRAMs
**
*******************************************************************************/
RETCODE WriteSeqRAMs(U8 _far *data,U8 _far *buffer) {
   U16 i,srcOffset,desOffset;
   U32 srcSeg,srcPointer,desSeg,desPointer;
   RETCODE err;

   if ((FLEXConfig & SMain ) != SMain) {
     if((err =  FLEXProgram(FLEX_MN,MNCPRWByte)) != GOOD ) return(err);
     FLEXConfig &= 0x03;
     FLEXConfig |= SMain ;
   }

   outp(FClkSel0,0x0);    // Change FCLK2/FCLK3/FCLK4 TO CPCLK
   outp(FClkSel1,0x80);

   srcSeg = FP_SEG(data);
   srcOffset = FP_OFF(data);
   srcPointer = (srcSeg << 4) + srcOffset ;

   desSeg = FP_SEG(buffer);
   desOffset = FP_OFF(buffer);
   desPointer = (desSeg << 4) + desOffset ;

   outp(MNCtrlAX,BCK);   //Enable MN Output enable
   outp(MNCtrlAX,DOE);

   outpw(DMA1SL,(U16) srcPointer);    // Enable DMA Write Trigger SSRAM
   outpw(DMA1SH,(U16) (srcPointer >> 16));
   outpw(DMA1DL,RWTrig);
   outpw(DMA1DH,0);
   outpw(DMA1TC,0x4000);
   outp(P4CtrlB,0x40) ;  //Enable Trigger SSRAM nGW
   outpw(DMA1CW,0x7A27);

   outp(P4CtrlB,0) ;  //Disable Trigger SSRAM nGW
   outp(P4CtrlAX,nOETRIG) ;  //Enable Trigger SSRAM nOE

   outpw(DMA1SL,RWTrig);    // Enable DMA Read Trigger SSRAM
   outpw(DMA1SH,0);
   outpw(DMA1DL,(U16) desPointer);
   outpw(DMA1DH,(U16) (desPointer >> 16));
   outpw(DMA1TC,0x4000);
   outp(MNCtrlAX,BCK);
   outp(MNCtrlAX,0) ;  //Disable MN Output enable
   inp(RWTrig);        // Dummy read
   inp(RWTrig);
   outpw(NPACS,0x0F38);
   outpw(NMPCS,0xC0B8);
   outpw(DMA1CW,0xAE27);
   outpw(NPACS,0x0F3F);
   outpw(NMPCS,0xC0BF);

   for (i=0 ; i<= 0x3FFF ; i++)
       if(*(data-i) != *(buffer+i) ) return(ERR_TRIG) ;
   return(GOOD);
}

/********************************* EOF *************************************/
