/* CPU Server */!!

inherit(ProvidedLibs, #CpuLib, nil, 2, nil)!!

now(class(CpuLib))!!

/* semiPRIVATE -- should only be called via require(CpuLib)
   Define entry points and load library.  Define any structs required.
*/
Def provide(self, path)
{
  ^initialise( new(self:ancestor), path )
}
!!

now(CpuLib)!!

/* 6/21/1996 9:33 */
/* PUBLIC */
Def getCoreType(self | coreType proc)
{
  proc := getSpecificProcessor(ProcLibClass$Inst);
  if (proc <> 0x1204) /* M68302_MP */
    ^2;
  endif;
  coreType := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETCORETYPE], coreType ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if (lastError <> GOOD) then
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^wordAt(coreType, 0);
}
!!

/* 12/1/1995 17:09 */
/* PUBLIC */
Def getSpaceMode(self | spaceMode)
{
  spaceMode := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETSPACEMODE], spaceMode ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if (lastError <> GOOD) then
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^wordAt(spaceMode, 0);
}
!!

/* PUBLIC */
Def resetCpuOnly(self)
{
  /* 04/25/94 - Nghia
  ** Move the warning message here to be centralized for all caller
  */
  if (errMessageBox(ErrorTextLibClass$Inst, "Warning",
    "Reset target processor without updating window?",
    MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_CPUPRESE_1) = IDNO) then
    ^nil;
  endif;
  
  if pcallLock(self)
    lastError := pcall(procs[#CPURESETCPUONLY]);
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD)
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  ^lastError
}!!

/* PUBLIC */
Def getRegisterWidth(self, regId | name sortIndex type width)
{
  sortIndex := new( Struct, 4 ) ;
  type := new( Struct, 4 ) ;
  width := new( Struct, 4 ) ;
  name := new( Struct, 40) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETREGISTERINFO], regId, name, sortIndex, type, width) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;   
  ^wordAt(width,0);
}
!!

/* PUBLIC */
Def getRegisterSortIndex(self, regId | name sortIndex type width)
{
  sortIndex := new( Struct, 4 ) ;
  type := new( Struct, 4 ) ;
  width := new( Struct, 4 ) ;
  name := new( Struct, 40) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETREGISTERINFO], regId, name, sortIndex, type, width) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;   
  ^wordAt(sortIndex,0);
}
!!

/* PUBLIC */
Def getRegisterType(self, regId | name sortIndex type width)
{
  sortIndex := new( Struct, 4 ) ;
  type := new( Struct, 4 ) ;
  width := new( Struct, 4 ) ;
  name := new( Struct, 40) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETREGISTERINFO], regId, name, sortIndex, type, width) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;   
  ^wordAt(type,0);
}
!!

/* PUBLIC */
Def getRegisterName(self, regId | name line sortIndex type width)
{
  sortIndex := new( Struct, 4 ) ;
  type := new( Struct, 4 ) ;
  width := new( Struct, 4 ) ;
  name := new( Struct, 40) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETREGISTERINFO], regId, name, sortIndex, type, width) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;   
  ^removeNulls(physicalString(name));
}
!!

/* PUBLIC */
Def getRegisterValueText(self, regId, type | valueText)
{
  valueText := new( Struct, 40) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETREGISTERVALUETEXT], regId, type, valueText ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;   
  ^removeNulls(physicalString(valueText));
}
!!

/* PUBLIC */
Def getNumRegs(self | num)
{
  num := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETNUMREGS], num ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if (lastError <> GOOD) then
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^wordAt( num, 0 )
}
!!

/* 5/12/1992 13:35 - PUBLIC
  Set stack pointer. 
*/
Def setStackPointer(self, spAddrDesc)
{ 
  /* The CPU server will consume the spAddrDesc */
  if pcallLock(self)
  then
    lastError := pcall(procs[#CPUSETSP], asLong(spAddrDesc));
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if (lastError <> GOOD)
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;
  ^lastError;  
}
!!

/* 4/1/1992 17:23 - PUBLIC
  Set the Program Counter.
*/
Def setProgramCounter(self, pcAddrDesc)
{ 
  /* The CPU server will consume the pcAddrDesc */
  if pcallLock(self)
  then
    lastError := pcall(procs[#CPUSETPC], asLong(pcAddrDesc));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;
  ^lastError;  
}
!!

/* PRIVATE */
Def addImportProcs(self)
{
    add(self, #INITCSERVER,             1, #(0, 0));
    add(self, #CPUGETREGISTER,          1, #(0, 1));
    add(self, #CPUSETREGISTER,          1, #(0, 1));
    add(self, #CPUGETFPREGISTER,        1, #(0, 1));
    add(self, #CPUSETFPREGISTER,        1, #(0, 1));
    add(self, #CPUGETPC,                1, #(1));
    add(self, #CPUSETPC,                1, #(1));
    add(self, #CPUGETSP,                1, #(1));
    add(self, #CPUSETSP,                1, #(1));
    add(self, #CPUGETFRAMEPTR,          1, #(1));
    add(self, #CPURESETCPU,             1, nil );
    add(self, #CPURESETCPUONLY,         1, nil );
    add(self, #CPUGETSIGNAL,            1, #(0, 1));
    add(self, #CPUSETSIGNAL,            1, #(0, 0));
    add(self, #CPUFINDREGISTERID,       1, #(1, 1));
    add(self, #CPUGETREGISTERWIDTH,     1, #(0, 1));
    add(self, #CPUGETNUMREGS,           1, #(1));
    add(self, #CPUGETREGISTERINFO,      1, #(0, 1, 1, 1, 1));
    add(self, #CPUGETREGISTERVALUETEXT, 1, #(0, 0, 1));
    add(self, #CPUGETNUMBEROFSIGNALS,   1, #(1));
    add(self, #CPUGETSIGNALNAME,        1, #(0, 1));
    add(self, #CPUGETSPACEMODE,         1, #(1));
    add(self, #CPUGETCORETYPE,          1, #(1));
}
!!

/* PUBLIC */
Def findRegisterID(self, regName | idRef)
{
  idRef := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUFINDREGISTERID], asciiz(regName), idRef ) ;
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;
  ^wordAt( idRef, 0 );
}
!!

/* PUBLIC */
Def getFPRegValue(self, regID | struct80)
{
  struct80 := new( Struct, 10 ) ; /* 10 bytes is 80 bits */
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETFPREGISTER], regID, struct80 ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;    
  ^struct80
}
!!

/* PUBLIC */
Def getProgramCounter(self | addrRef)
{
  addrRef := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETPC], addrRef ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if (lastError <> GOOD) then
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^longAt( addrRef, 0 )
}
!!

/* PUBLIC */
Def getRegValue(self, regID | valueRef)
{
  valueRef := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETREGISTER], regID, valueRef ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^longAt( valueRef, 0 )
}
!!

/* PUBLIC */
Def getSignal(self, sigID | bool  sigRef)
{
  sigRef := new( Struct, 4 ) ;
  
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETSIGNAL], sigID, sigRef ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^(atLSB(sigRef, 0) <> 0) /* return nil if byte is 0 */
}
!!

/* PUBLIC */
Def getStackPointer(self | addrRef)
{
  addrRef := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETSP], addrRef ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^longAt( addrRef, 0 )
}
!!

/* PRIVATE 
   Open and initialize variable server library & load trigger dll
*/
Def initialise(self, path)
{
   setName( self, path ) ;
   addImportProcs( self ) ;
   load( self ) ;  /* raises alert if fails: alert(System, self, #libLoad) */
}
!!

/* PUBLIC */
Def reset(self)
{
  /* 04/25/94 - Nghia
  ** Move the warning message here to be centralized for all caller
  */
  if (errMessageBox(ErrorTextLibClass$Inst, "Warning", 
    "Reset target processor and update all windows?",
    MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_CPUPRESE_1) = IDNO) then
    ^nil;
  endif;

  if pcallLock(self)
    lastError := pcall( procs[#CPURESETCPU]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD)
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;  
  if (getCoreType(self) = 1)
    setText(TheToolBarPresenter, "MICEpack/SLD ToolBar (Core: 68008)");
  else
    setText(TheToolBarPresenter, "MICEpack/SLD ToolBar (Core: 68000)");
  endif;
  ^lastError
}
!!

/* PUBLIC */
Def setFPRegValue(self, regID, struct80)
{
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUSETFPREGISTER], regID, struct80 ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^lastError
}
!!

/* PUBLIC */
Def setRegValue(self, regID, newValue)
{
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUSETREGISTER], regID, asLong(newValue) ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^lastError
}
!!

/* PUBLIC */
Def setSignal(self, sigID, bool | byte)
{
  if bool /* N.B.: Actor bool: nil=false, else true */
  then byte := 1 ;
  else byte := 0 ;
  endif ;
  
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUSETSIGNAL], sigID, byte ) ;
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD) then 
    displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);
    ^nil;
  endif;  
  ^byte
}
!!

/* PUBLIC */
Def getNumberOfSignals(self | numSignals)
{
  numSignals := new(Struct, 4);
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETNUMBEROFSIGNALS], numSignals ) ;
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;

  ^wordAt(numSignals, 0);
}
!!

/* PUBLIC */
Def getSignalName(self index | sigName)
{
  sigName := new( Struct, 15 ) ; /* 15 is the max signal name */
                                 /* includes the & needed for */
                                 /* keyboard acceleration. */
  if pcallLock(self)
  then
    lastError := pcall( procs[#CPUGETSIGNALNAME], index, sigName ) ;
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION ;
  endif ;


  if (lastError <> GOOD)
  then
    displayError(ErrorTextLibClass$Inst,lastError,FORCE_POPUP);
    ^nil;
  endif;
  ^removeNulls(physicalString(sigName));
}
!!

