/* Launches Presenters

   Logically, the presenters should be class variables here rather than
   global variables.  We should do this move when we get time to do so.
*/!!

inherit(Object, #PreLauncher, nil, 2, nil)!!

setClassVars(PreLauncher, #($cliRegistered /* boolean flag */
$windowsMenu /* shared menu */
$presenterDict /* launchable presenters */
$inBoot?          /* during boot process? */
$startupScriptFileName
$windowRestoreCompleted
    /* true when all saved windows have been restored */))!!

now(class(PreLauncher))!!

/* 2/21/1997 14:49 */

Def launchSpaPresenter(self, rect, showVal )
{

  if (exists(SpaPresenter) cand TheSpaPresenter) then
    Call BringWindowToTop(getHWnd(TheSpaPresenter));
    show( TheSpaPresenter, SW_SHOWNORMAL);
  else
    /* Open the Spa Presenter; retrieve location and show status if
       they are not already specified. */
    TheSpaPresenter :=
      openWithPosAndState(SpaPresenter,
        rect cor getPos(self, "TheSpaPresenter"),
        getShowState(self, "TheSpaPresenter") cor showVal);
  endif;
}!!

/* 4/19/1994 12:08 - PUBLIC
  Cycles from one active window to the next.
  Multiple memory window enhancements added. 
*/
Def nextWindow(self | actWind actvWindows presenterDict curPos nextPos
      index memObject) {
  /* find out which window is active */
  actWind := Call GetActiveWindow();
  actvWindows := new(OrderedCollection,1);
  presenterDict := getPresenterDict(self);

  /* search the presenter dictionary and match handle to presenter */
  keysDo(presenterDict,
  {using(key | info)
    /* find out which presenters are open */
    info := at(Actor,key);
    if (info = #TheMemoryPresenter)
      index := 0;
      loop
      while index < memoryWindowMax(MultMem)
      begin
        if (memObject := memoryWindowObject(MultMem, index))
          if (memObject cand (Call IsIconic(getHWnd(memObject)) = 0)) then
            /* window is not iconized */
            /* get the handle to the open windows */
            add(actvWindows, getHWnd(memObject));
          endif;
        endif;
        index := index + 1;
      endLoop;
    else
      /* 04/18/94 - Nghia
      ** only call if info is not nil - Fixed GPF bug 
      */
      if ((info <> nil) cand (Call IsIconic(getHWnd(info)) = 0)) then
        /* window is not iconized */
        /* get the handle to the open windows */
        add(actvWindows, getHWnd(info));
      endif;
    endif;
  });
  
  /* get the entry number for the currently active window (if its */
  /* handle matches one of the open windows (safety)) */
  if actWind in actvWindows then
    curPos := find(actvWindows,actWind);
  else
    curPos := 0;
  endif;
  /* if the active window is the last element in the set then */
  /* set the next window to display to the first element in the set */
  if curPos = (size(actvWindows)-1) then
    nextPos := 0;
  else
    nextPos := curPos + 1;
  endif;
  Call BringWindowToTop(actvWindows[nextPos]);
}

!!

/* special processing for opening saved mult memory windows. */
Def openAllSavedMemWindows(self |
      tmpRect showVal tuple launchMethod index label symbol)
{
  tuple := at(getPresenterDict(PreLauncher), #TheMemoryPresenter);
  launchMethod := tuple[3];
  
  index := 0;
  loop
  while index < memoryWindowMax(MultMem)
  begin
    label := memoryWindowLabel(MultMem, index);
    symbol := asSymbol(label);
    tmpRect := getIniWindowPos(self, symbol);
    showVal := getIniWindowState(self, symbol);
      
    /* if tmpRect, window has saved coordinates, and should be opened. */
    if (tmpRect)
      perform(PreLauncher, tmpRect, showVal, launchMethod);
    endif;
    index := index + 1;
  endLoop;
  
  Call BringWindowToTop(getHWnd(TheToolBarPresenter));
}
!!

/* special processing for saving multiple memory presenter's position. */
Def saveAllMemPresenterPos(self | index memObject)
{
  index := 0;
  loop
  while index < memoryWindowMax(MultMem)
  begin
    memObject := memoryWindowObject(MultMem, index);
    if (memObject)
      saveWindowPos(memObject, memoryWindowLabel(MultMem, index));
    else
      /* don't need to test for toolbar; only memory windows here. */
      clearLayoutEntry(Window, memoryWindowLabel(MultMem, index));
    endif;
    index := index + 1;
  endLoop;

  ^#ok
}
!!

/* Return true if presenter symbol passed in is the memory presenter. */
Def memoryPresenter?(self, presenterSymbol)
{
  ^(presenterSymbol = #TheMemoryPresenter);
}
!!

/* Special processing for the multiple memory windows. */
Def closeAllMemPresenters(self | saveOnExit index memObject)
{
  saveOnExit := getIniSaveLayoutOnExit(PreLauncher);
  
  index := 0;
  loop
  while index < memoryWindowMax(MultMem)
  begin
    memObject := memoryWindowObject(MultMem, index);
    if (memObject)
      if (saveOnExit = 1)
        saveWindowPos(memObject, memoryWindowLabel(MultMem, index));
      endif;
      close(memObject);
    else
      clearLayoutEntry(Window, memoryWindowLabel(MultMem, index));
    endif;
    index := index + 1;
  endLoop;

  nilifyWindowsMenu(self);

  ^#ok
}
!!

/* Show presenters using  "ShowWindow"
 *  get the state they were in before we hid them.
 *  $presenterDict[4] is showValue
 */
Def showMemPresenter(self, presenter, index | hwnd iconic showVal)
{
  showVal := getShowStatus(MultMem, index);
  if (showVal = nil)
    showVal := 1;      /* force as visible */
    setShowStatus(MultMem, index, showVal);
  endif;

  hwnd := getHWnd(presenter);
  if (Call IsWindow(hwnd) <> 0)
    show(presenter, showVal);  /* was showval */
    invalidate(presenter);
  endif;

  ^0;
}
!!

/* hide a presenters using  "ShowWindow"
 *  keep a copy of what state they were in before we hid them.
 *  setShowState value replaces $presenterDict[4] for mult memory windows.
 */
Def hideMemPresenter(self, presenter, index | hwnd iconic )
{
  hwnd := hWnd(presenter);
  if (Call IsWindow(hwnd) <> 0)
    iconic :=  Call IsIconic(hwnd);
    if (iconic<>0)
      setShowStatus(MultMem, index, SW_SHOWMINIMIZED);
    else
      setShowStatus(MultMem, index, SW_SHOWNORMAL);
    endif;

    show(presenter, 0);
  endif;
   
  ^0;
}
!!

/* do "ShowWindow" over all memory presenters */
Def hide                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          