/*****************************************************************************
** Name:  varutil.h
**
** Description:
**    Routines to access the CLI for the variable server.
**
** Status:   PRELIMINARY
**
** $Log:   S:/tbird/mt2_68k/varsrv/varutil.h_v  $
** 
**    Rev 1.0   13 Feb 1997 09:08:06   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:25:04   gene
** Initial revision.
** 
**    Rev 1.15   18 Nov 1993 17:32:24   nghia
** Fixed PPR 9191 - Dereference SMALL pointer variable.
** Revised RecreateCliVarTable() prototype to remove compiler warning.
** 
**    Rev 1.14   02 Dec 1992 13:55:32   marilyn
** Updated interfaces.
** 
**    Rev 1.13   04 Nov 1992 17:45:56   marilyn
** Updated interface to MakeCompositeName.
** 
**    Rev 1.12   21 Oct 1992 16:16:30   marilyn
** Updated interfaces.
** 
**    Rev 1.11   15 Oct 1992 17:55:20   marilyn
** No change.
** 
**    Rev 1.10   04 Aug 1992 16:52:50   marilyn
** Added UpdateChildVars prototype.
** 
**    Rev 1.9   31 Jul 1992 16:51:20   marilyn
** Added prototype.
** 
**    Rev 1.8   28 May 1992 16:36:38   marilyn
** Modified interface for GetPtrDereference.
** 
**    Rev 1.7   13 May 1992 11:23:52   marilyn
** Added prototype for GetSubArrayType.
** 
**    Rev 1.6   24 Apr 1992 16:50:10   marilyn
** Added CheckForTypedef routine.
** 
**    Rev 1.5   17 Apr 1992 16:20:10   marilyn
** Added additional prototypes. Some from varservr.c and some from
** varutil.c
** 
**    Rev 1.4   06 Apr 1992 11:17:40   marilyn
** No change.
** 
**    Rev 1.3   04 Apr 1992 10:17:20   marilyn
** Moved CheckWarning from varservr.c
** 
**    Rev 1.2   02 Apr 1992 11:20:48   marilyn
** Added prototypes
** 
**    Rev 1.1   30 Mar 1992 16:49:26   marilyn
** Moved HEADER_AND_FOOTER define to this include file.
** 
**    Rev 1.0   20 Mar 1992 09:40:26   marilyn
** Initial revision.
** 
** $Header:   S:/tbird/mt2_68k/varsrv/varutil.h_v   1.0   13 Feb 1997 09:08:06   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _VARUTIL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _VARSERVR_
#include "varservr.h"
#endif

#ifndef _VARTABLE_
#include "vartable.h"
#endif

#ifndef _STKSERVR_
#include "stkservr.h"
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

#ifndef __MEM_H
#include <mem.h>
#endif



                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define HEADER_AND_FOOTER  2

typedef struct subTypeListNode {
   U16 offset;
   U32 numLines;
   struct subTypeListNode *next;
} SUB_TYPE_LIST_NODE;

typedef struct arrayListNode {

   U32 size;
   U32 numLines;
   struct arrayListNode *next;
   struct arrayListNode *previous;
   SUB_TYPE_LIST_NODE *subNode;
} ARRAY_LIST_NODE;


typedef struct arrayIndexNode {
   U32 index;
   struct arrayIndexNode *next;
} ARRAY_INDEX_NODE;


                       /****************************
                        *                          *
                        *   EXTERNAL PROTOTYPES    *
                        *                          *
                        ****************************/

VOID  CheckForTypedef(TYPE_SUBHEADER_TYPE *varTypeInfo,
                      TYPE_SUBHEADER_TYPE **typedefTypeInfo,
                      TYPE_SUBHEADER_TYPE **baseTypeTypeInfo);

RETCODE CheckWarning(RETCODE retcode,
                     RETCODE *errcode);

RETCODE FreeSubTypes(TYPE_SUBHEADER_TYPE *typeInfo);

RETCODE FreeVSBuf(VS_DISPLAY_PTR displayBufPtr);

RETCODE GetBaseTypeForPointer(TYPE_SUBHEADER_TYPE  *typeInfo);

RETCODE GetComponentAddress(VS_VAR_ENTRY_TYPE *rootVar,
                            TYPE_INDEX *typeIndex,
                            U32 byteOffset,
                            GET_VAR_ADDR_STRUCT *addr,
                            VAR_STORAGE_CLASS *storageClass,
                            BOOLEAN *dereferencedPtr);

RETCODE GetPtrDereference(VAR_REGISTER_CLASS registerClass,
                          VAR_STORAGE_CLASS storageClass,
                          U32 ptrSize,
                          U32 byteOffset,
                          U8 frameNum,
                          U8 frameType,
                          GET_VAR_ADDR_STRUCT *startAddr,
                          GET_VAR_ADDR_STRUCT *newAddr);

RETCODE GetAddress(VAR_REGISTER_CLASS registerClass,
                   VAR_STORAGE_CLASS storageClass,
                   U32 byteOffset,
                   GET_VAR_ADDR_STRUCT *startAddr,
                   GET_VAR_ADDR_STRUCT *newAddr);

VOID GetSubArrayType(TYPE_SUBHEADER_TYPE *typeInfo,
                     TYPE_SUBHEADER_TYPE **baseTypeInfo);

VOID FindSubArrayType(TYPE_SUBHEADER_TYPE *typeInfo,
                      ARRAY_INDEX_NODE *arrayIndices,
                      TYPE_SUBHEADER_TYPE **baseTypeInfo);

VOID  GetSubComponentType(TYPE_SUBHEADER_TYPE *typeInfo,
                          TYPE_SUBHEADER_TYPE **baseTypeInfo);

RETCODE GetVSdispBuf(DESCRIPTOR VSVarId,
                     DESCRIPTOR bufferNum,
                     U8 frameNum,
                     VS_DISPLAY_PTR  *dispPtr);

VOID  MakeCompositeVarName(LPSTR rootVarName,
                           TYPE_SUBHEADER_TYPE *rootVarType,
                           BOOLEAN rootdeferencedPtr,
                           LPSTR compName,
                           ARRAY_INDEX_NODE *arrayIndices,
                           LPSTR varName);

RETCODE MapArrayLine2Offset(TYPE_SUBHEADER_TYPE *typeInfo,
                            U16 lineNum,
                            U16 priorHeaderCount,
                            U32 *offset,
                            U16 *memberIndex,
                            TYPE_INDEX *typeIndex,
                            ARRAY_LIST_NODE **arrayNode,
                            ARRAY_INDEX_NODE **arrayIndexNode);

RETCODE RecreateCliVarTable(VOID);

RETCODE UpdateChildVars(DESCRIPTOR varId,
                        U16 lineNum,
                        U16 bufferNum,
                        TYPE_INDEX typeIndex,
                        GET_VAR_ADDR_STRUCT *addr,
                        BOOLEAN unionEdit);


RETCODE EXPORT VSInit(VOID);

/******************************** E O F ***********************************/
