#define _REG68306_DEFINE_

typedef enum {
   R_PC,R_SSP,R_SR,
   R_A7,R_A6,R_A5,R_A4,R_A3,R_A2,R_A1,R_A0,
   R_D7,R_D6,R_D5,R_D4,R_D3,R_D2,R_D1,R_D0,
   R_USP,
   MAX_CPU_REG_NUM
}CPU_REG;

typedef enum{
   R_HCS0C = 0XC0, R_LCS0C = 0XC2,  // 2 BYTES
   R_HCS1C = 0XC4, R_LCS1C = 0XC6,
   R_HCS2C = 0XC8, R_LCS2C = 0XCA,
   R_HCS3C = 0XCC, R_LCS3C = 0XCE,
   R_HCS4C = 0XD0, R_LCS4C = 0XD2,
   R_HCS5C = 0XD4, R_LCS5C = 0XD6,
   R_HCS6C = 0XD8, R_LCS6C = 0XDA,
   R_HCS7C = 0XDC, R_LCS7C = 0XDE,
   R_HDB0C = 0XE0, R_LDB0C = 0XE2,
   R_HDB1C = 0XE4, R_LDB1C = 0XE6,

   R_PDA   = 0XF0, R_PBA   = 0XF1,  // 1 BYTE
   R_PADD  = 0XF2, R_PBSS  = 0XF3,
   R_PAPA  = 0XF4, R_PBPA  = 0XF5,

   R_ISR   = 0XF8, R_ICR   = 0XFA,  // 2 BYTES

   R_RR    = 0XFC, R_WP    = 0XFD,  // 1 BYTE
   R_SYS   = 0XFE, R_TV    = 0XFF,
   MAX_INTERNAL_REG_NO
}M306_INTERNAL_REG;

typedef enum {
   M68K_REG,       /*  */
   INTERNAL_REG
} REG_MODE ;
