/****************************************************************************
**
**  Name:  unixcli.c
**
**  Description:
**     CLI interface to UnixOpen.
**
**  $Log:   S:/tbird/mt2_68k/cliulib/unixcli.c_v  $
** 
**    Rev 1.0   21 Feb 1997 14:40:08   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:08:32   gene
** Initial revision.
** 
**    Rev 1.4   16 Jul 1993 11:48:36   ernie
** Removed error.h include.  All errors now in errcodec.h
** 
**    Rev 1.3   28 Jun 1993 09:56:36   doug
** errors consolidated in errtext/mkerrors.h
** 
**    Rev 1.2   09 Apr 1993 08:33:16   tom
** Fixed warning.
** 
**    Rev 1.1   06 Apr 1993 15:40:38   tom
** Removed extraneous blank lines.
** 
**    Rev 1.0   06 Apr 1993 15:33:50   tom
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/cliulib/unixcli.c_v   1.0   21 Feb 1997 14:40:08   gene  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *   SYSTEM INCLUDE FILES   *
                        *                          *
                        ****************************/
#include <io.h>
#include <stdio.h>

                       /****************************
                        *                          *
                        *   LOCAL INCLUDE FILES    *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _UNIXOPEN_
#include "unixopen.h"
#endif

#ifndef _UNIXTEXT_
#include "unixtext.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#define BUFFER_SIZE 256

HANDLE cliServerHandle = (HANDLE)NULL;  /* force definition here */

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

RETCODE PRIVATE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr);

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
**  SendCliMessage
**
**  Description:
**     Send a message to the Shell for display in the Shell's transcript
**     window.
**
**  Parameters:
**     cliHandle (in):  CLI Server Handle
**     dllHandle (in):  DLL Handle.
**
**  Return:
**     Return a 1 to indicate success.
**
***************************************************************************/
RETCODE PRIVATE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr) {
   HANDLE msgBufHandle;
   CSERVER_RESULTS FAR *msgBufPtr;
   U16 msgTextSize, loop;

   msgTextSize = lstrlen(msgPtr);
   if ((msgBufHandle = GlobalAlloc(GMEM_MOVEABLE,
         (sizeof(CSERVER_RESULTS) + msgTextSize + 2))) == (HANDLE)NULL) {
      return(ER_OUT_OF_MEMORY);
   }
   else {
      if((msgBufPtr=(CSERVER_RESULTS *)GlobalLock(msgBufHandle)) == NULL) {
         GlobalFree(msgBufHandle);
         return(ER_WINDOWS_MEMLOCK);
      }
   }
   msgBufPtr->target = 0;    /*@@ CLI: not yet def'ed @@*/
   msgBufPtr->variantCode = CLI_SERVER_RESULTS;
   msgBufPtr->resultTextLength = msgTextSize; /* message string length */
   for (loop = 0; loop < msgTextSize; loop++ ) {
      msgBufPtr->messageText[loop] = *msgPtr++;
   }
   msgBufPtr->messageText[msgTextSize+1] = 0;

   SendMessage(cliHandle, CLI_SERVER_RESULTS, msgBufHandle, CLI_SERVER_RESULTS);
   return GOOD;
}

/**************************************************************************
**
**  InitCServer
**
**  Description:
**     Initialize the commands for the Cliulib Server.
**
**  Parameters:
**     cliHandle (in):  CLI Server Handle
**     dllHandle (in):  DLL Handle.
**
**  Return:
**     Return a 1 to indicate success.
**
***************************************************************************/
RETCODE EXPORT
InitCServer(HANDLE cliHandle, HANDLE dllHandle)
{
   CSERVER_NEW_REGISTRATION FAR *msgBufPtr;

   cliServerHandle = cliHandle;
   msgBufPtr =
      (CSERVER_NEW_REGISTRATION FAR *)TMalloc(sizeof(CSERVER_VARIABLE_VALUE));
   if (msgBufPtr == NULL) {
      return(ER_OUT_OF_MEMORY);
   }
   msgBufPtr->stringResourceHandle = dllHandle;

   msgBufPtr->serverNameIndex = 30;
   msgBufPtr->dllNameIndex = 31;
   msgBufPtr->numberOfCommandsIndex = 32;
   msgBufPtr->commandStartIndex = 33;
   SendMessage(cliHandle, CLI_NEW_SVR_REGISTRATION, CLI_NEW_SVR_REGISTRATION,
      (DWORD)msgBufPtr);
   TFree((LPSTR)msgBufPtr);
   return(GOOD);
}

/***************************************************************************
**
**  CliulibUnixOpen
**
**  Description:
**     Shell interface to test the UNIX open capability:  open a UNIX file,
**     display the handle, and close the file.
**
**  Syntax:
**     cliulib__unixopen <file_name>
**
**  Parameters:
**     cmdString (in):  string of command and arguments.
**     argc (in):  number of arguments, +1 for command.
**     argv (in):  array of pointers to command, arguments.
**
*****************************************************************************/
RETCODE EXPORT CliulibUnixOpen(LPSTR cmdString, U32 argc, U32 argv[]) {
   LPSTR fileName;
   S16 fileHandle;
   RETCODE retcode;
   CHAR resourceString[BUFFER_SIZE];
   CHAR fileHandleBuffer[BUFFER_SIZE];
   HANDLE hModule;
   S16 nbytes;

#ifdef UNIT_TESTING
   // beginning of temporary unit test
   VOID EXPORT Test83Main(void);   // declare prototype
   Test83Main();   // run it
   return(1234);   // return bogus code
   // end of temporary unit tests
#endif

   if (argc != 2) {
      return(ER_CLI_SYNTAX);
   }

   // point fileName at beginning of file name string
   fileName = cmdString + (U16)argv[1];

   // open file
   retcode = UnixOpenFile(fileName, &fileHandle);

   // check retcode, results
   if (retcode != GOOD) {
      return(ER_CLIULIB_CLI_OPEN_FAILED);
   }

   /* note: cli has not necessarily been initialized, so we need to explicitly
      retrieve the dll handle */
   hModule = GetModuleHandle("cliulib.dll");
   nbytes = LoadString(hModule, CLIULIB_FILE_HANDLE_STRING,
        resourceString, BUFFER_SIZE);
    if (nbytes == 0)
        return (ER_RESLOAD);
   sprintf(fileHandleBuffer, resourceString, fileHandle);
   SendCliMessage(cliServerHandle, (LPSTR)fileHandleBuffer);
   close(fileHandle);

   return(GOOD);
}

/******************************** E O F ***********************************/
