/***************************************************************************
**
**    Name:    daddq306.h
**
**    Description:
**        Internal definitions for the dequeuer server.
**
** 
** 
**    $Header:
*/

#define _DQ306_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/


                        /********************
                        **                 **
                        **  Definitions    **
                        **                 **
                        ********************/

#define TRACE_FRAME_WIDTH     sizeof(TRACE_INFO) // the length of each trace frame.

typedef struct {
   BOOLEAN     frameValid;
   BOOLEAN     synched;
//   BOOLEAN     programFrame;
   DESCRIPTOR  frameAddr;
   U16         data;
//   U32         ifetch;
   S32         frameNo;
}FRAME_TYPE;


#define MAX_FRAME_NO     (1024/TRACE_FRAME_WIDTH)
#define MAX_FRAME_READ   (1024/TRACE_FRAME_WIDTH)

#define MAX_INST_LEN          6  // 11 word.
#define MAX_RDWR_LEN          18 // 64 word.  NOTE 6+18+2 <= 26
#define AVG_INST_LEN          2  // 2 word.

typedef enum { READ_NOSKIP, READ_SKIP }FRAME_READ_MODE;

typedef enum { PROGRAM_FRAME, DATA_FRAME }FRAME_READ_TYPE;

typedef enum {F_F0=0, F_UD, F_UP, F_F3, F_F4, F_SD, F_SP, F_CPU} FRAME_SPACE;

typedef enum {S_PROGRAM = 0x10, S_DATA, S_DONT_CARE}SPACE_TYPE;

typedef enum {MODE_16BITS, MODE_8BITS} CORETYPE;


typedef struct {
   S32 frameNo;
   U32 addr;
   U32 data;

   U16 dsPin    : 2;  // hardware pin define
   U16 sparePin : 1;
   U16 nDramPin : 1;
   U16 rwPin    : 1;
   U16 fcPin    : 3;
   U16 csPin    : 8;
//   U16 portAB;
//   U32 misc;
}TRC_FRAME;

typedef struct {
   S32 frameNo[MAX_INST_LEN+2+MAX_RDWR_LEN];
   U32 addr[MAX_INST_LEN+2+MAX_RDWR_LEN];
   U16 data[MAX_INST_LEN+2+MAX_RDWR_LEN];
   U16 rwPin[MAX_INST_LEN+2+MAX_RDWR_LEN];
   U16 fcPin[MAX_INST_LEN+2+MAX_RDWR_LEN];
   U16 dsPin[MAX_INST_LEN+2+MAX_RDWR_LEN];
//   U32 misc[MAX_INST_LEN+2+MAX_RDWR_LEN];
}DQ_FRAME;

typedef struct {
    DQ_FILTER       DqFilter;
    BOOLEAN         Search;
    U16             Offset;
    LPSTR           pattern;
    DESCRIPTOR      traceId;
    FRAME_TYPE      *dqFrame;
    CORETYPE        coreType;

    U16 traceBufId;         // New add record for 306 DQ
    S32 frameStart,frameEnd;
    TRC_FRAME frameArray[MAX_FRAME_NO];
}DQ_STATE;
/********************************* E O F *******************************/
