/****************************************************************************
**
**  Name:  listw.h
**
**  Description:
**     Routines to access generic single linked list data structure in
**     Windows.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/inc/listw.h_v  $
** 
**    Rev 1.0   13 Feb 1997 08:49:54   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:26:04   gene
** Initial revision.
** 
**    Rev 1.0   30 Jul 1991 13:57:20   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/inc/listw.h_v   1.0   13 Feb 1997 08:49:54   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _LISTW_

                        /****************************
                         *                          *
                         *       INCLUDE FILES      *
                         *                          *
                         ****************************/

#ifndef _BASETYPE_
#include "basetype.h"
#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif


                        /****************************
                         *                          *
                         *        DEFINITIONS       *
                         *                          *
                         ****************************/

/* Head of list */
typedef struct {
   DESCRIPTOR head;
   DESCRIPTOR current;
} LIST;


/* Global Macros */
#define InitList(list)   ((list)->head = NULL)
#define EmptyList(list)  ((list)->head == NULL)
#define IsTailList(list) ((list)->current == NULL)
#define HeadList(list)   ((list)->current = (list)->head)

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

RETCODE EXPORT AppendList(LIST FAR *list, CALLBACK data);
RETCODE EXPORT RemoveList(LIST FAR *list, CALLBACK data);

CALLBACK EXPORT GetList(LIST FAR *list);
DESCRIPTOR EXPORT NextList(LIST FAR *list);

/* !!!
VOID EXPORT DoList(LIST list, VOID (*Function)(VOID const *));
VOID EXPORT DoListDel(LIST Lst, VOID (*Func)(VOID const*));
*/
/******************************** E O F ***********************************/
