/****************************************************************************
**
**  Name:  map.h
**
**  Description:
**     Map server definitions
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/inc/map.h_v  $
** 
**    Rev 1.2   09 Apr 1997 09:51:02   gene
** 
**    Rev 1.1   10 Mar 1997 11:58:04   gene
** 
**    Rev 1.0   13 Feb 1997 08:49:56   gene
** Initial revision.
** 
**    Rev 1.1   30 May 1996 16:19:28   kevin
** added definitions of MAP_SPC0, MAP_SPC3, and MAP_SPC4
** 
**    Rev 1.0   07 Sep 1995 10:26:06   gene
** Initial revision.
** 
**    Rev 1.2   24 May 1994 07:55:12   tom
** Merged 1.1.2.0 onto trunk (Note:  1.1.1.0 still on branch).
** 
**    Rev 1.1.2.0   19 May 1994 17:03:36   tom
** Define space_type.
** 
**    Rev 1.1   11 Apr 1994 15:49:42   nghia
** Revised to support C++ compiling.
** 
**    Rev 1.0.1.0   19 May 1994 13:43:04   tom
** PDL map changes.
**
**    Rev 1.11   2 Mar 1994 11:34:56   kevin
** Added Space definitions
**
**    Rev 1.10   13 Jul 1993 11:14:28   tom
** Added MapSaveCS, MapRestoreCS, and MapConfigCS entrypoints.
**
**    Rev 1.9   23 Oct 1992 21:26:54   brucea
** Added: InitServer prototype
** 
**    Rev 1.8   03 Sep 1992 14:14:52   john
** moved map changed event to events.h and renamed
** 
**    Rev 1.7   14 Aug 1992 12:55:20   john
** added new enum for clearing the map
** 
**    Rev 1.6   13 Aug 1992 11:44:14   john
** Fixed new compile warnings
**
**    Rev 1.5   04 Aug 1992 15:55:22   john
** GetMapPresent prototype moved here from map.c
**
**    Rev 1.4   01 Aug 1992 17:35:54   john
** moved prototype for mapblockoverlap from map.c
**
**    Rev 1.3   31 Jul 1992 16:46:02   john
** Had to change prototypes to allow calls from actor
**
**    Rev 1.2   27 Jul 1992 13:27:12   john
** Changed prototype on MapSet; added MAP_BLOCK typedef
** 
**    Rev 1.1   22 Jul 1992 14:50:08   doug
** change order to match hardware
** 
**    Rev 1.0   22 Jul 1992 09:51:54   john
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/inc/map.h_v   1.2   09 Apr 1997 09:51:02   gene  $
**
**  Copyright (C) 1992-4 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _MAP_
#define _MAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAP_SD   0X0100
#define MAP_SP   0X0200
#define MAP_UD   0X0400
#define MAP_UP   0X0800
#define MAP_SPC0 0X1000
#define MAP_SPC3 0X2000
#define MAP_SPC4 0X4000

#define MAP_SMM  0X1000
#define MAP_USR  0X2000

#define MAP_TARGET 0X80


typedef enum {MAP_DISABLE, MAP_ENABLE, MAP_TYPE_END = 0x7fff} MAP_TYPE;

typedef enum {MAP_ENTRY_NOT_FOUND, MAP_ENTRY_FOUND, MAP_BLOCK_ALREADY_MAPPED,
              MAP_BLOCKS_IDENTICAL, MAP_NO_FREE_BLOCKS, MAP_ENTRY_CLEAR,
              MAP_BLOCK_END = 0X7FFF} MAP_BLOCK;

typedef struct {
   DESCRIPTOR address;
   U32 blockSize;       /* size of block in bytes */
   U16 accessRights;    /* ram/rom/none */
   U32 blockNumber;     /* which block to map */
   BOOLEAN enabled;
} MEMORY_MAP_DATA;

#define DUMMY_MAP_ORDER 0xFFFFFFFFL

typedef enum {SP_GENERIC, SP_INTEL, SP_MOTOROLA, SP_NONE} SPACE_TYPE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/****************************************************************************
**
**  GetMapBlockCount
**
**  Description:
**     Returns the number of map blocks available in the hw.
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        blockCount: number of blocks
**
*****************************************************************************/
RETCODE EXPORT GetMapBlockCount(WORD *blockCount);

/****************************************************************************
**
**  GetMapBlockGranularity
**
**  Description:
**     Returns the minimum size of map blocks available in the hw.
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        blockGran: size of map block
**
*****************************************************************************/
RETCODE EXPORT GetMapBlockGranularity(U32 *blockGran);

/****************************************************************************
**
**  GetMapBlockSize
**
**  Description:
**     Returns the maximum size of map blocks available in the hw.
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        blockSize: size of map block
**
*****************************************************************************/
RETCODE EXPORT GetMapBlockSize(U32 *blockSize);

/****************************************************************************
**
**  GetMapPresent
**
**  Description:
**     Returns a boolean to indicate if there is any ovly memory
**
**  Parameters:
**     input:
**        none:
**
**     output:
**        (return): true if map memory present
**
*****************************************************************************/
BOOLEAN EXPORT GetMapPresent(VOID);

/****************************************************************************
**
** InitServer
**
** Description:
**    Reads HW to get known resources, initializes map HW
**
** Parameters:
**    input:
**       none:
**
**    output:
**
*****************************************************************************/
RETCODE EXPORT InitServer(VOID);


/****************************************************************************
**
**  MapBlockOverlap
**
**  Description:
**     Checks to see if the block about to be mapped overlaps one already 
**     mapped.
**
**  Parameters:
**     input:
**        map:  structure containing the address, length, access
**                 rights, and enable for setting the map
**        offset: starting offset of the map block
**        
**     output:
**        status: the overlap status of the block to be programmed
**
*****************************************************************************/
RETCODE EXPORT MapBlockOverlap(MEMORY_MAP_DATA *map, U32 offset, 
                               MAP_BLOCK *status);


/****************************************************************************
**
**  MapSet
**
**  Description:
**     Set the overlay map to an address.
**
**     Call MapClear to clear entry and use only target memory.
**
**  Parameters:
**     input:
**        memMap:  structure containing the address, length, access
**                 rights, and enable for setting the map
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapSet(MEMORY_MAP_DATA *memMap);

/****************************************************************************
**
**  MapSetWithIndex
**
**  Description:
**     Set the overlay map specified by an index to an address.
**
**     Call MapClear to clear entry and use only target memory.
**
**  Parameters:
**     input:
**        memMap:  structure containing the address, length, access
**                 rights, and enable for setting the map
**        index:   order of map setting
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapSetWithIndex(MEMORY_MAP_DATA *memMap, U32 Index);

/****************************************************************************
**
**  MapGet
**
**  Description:
**     Get the current setting of the map.
**
**  Parameters:
**     input:
**        mapInfo.blockNumber:  map block entry to get
**     output:
**        mapInfo:  structure that returns information on one block
**
*****************************************************************************/
RETCODE EXPORT MapGet(MEMORY_MAP_DATA *mapInfo);

/****************************************************************************
**
**  MapGetWithIndex
**
**  Description:
**     Get the current setting of the map.
**
**  Parameters:
**     input:
**        mapInfo.blockNumber:  map block entry to get
**        nIndex:  order of map blocks
**
**     output:
**        mapInfo:  structure that returns information on one block
**
*****************************************************************************/
RETCODE EXPORT MapGetWithIndex(MEMORY_MAP_DATA *mapInfo, U16 nIndex);


/****************************************************************************
**
**  MapClear
**
**  Description:
**     Clear the memory map.  Sets all memory to target; overlay is not used.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT MapClear(VOID);

/****************************************************************************
**
**  GetNumMapSetting
**
**  Description:
**     Get num of map setting.
**
**  Parameters:
**     input:
**        num
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT GetNumMapSetting(U16 *num);

/****************************************************************************
**
**  MapConfigCS
**
**  Description:
**     Sends command to chassis to program the probe hardware to match
**     the 683XX internal chip select registers.  Restore the registers from
**     this ascii file first, then sends the command to program the probe HW.
**
**  Parameters:
**     none.
**
*****************************************************************************/
RETCODE EXPORT MapConfigCS(void);

/****************************************************************************
**
**  MapSaveCS
**
**  Description:
**     Gets the 683XX internal chip select registers from the processor
**     and outputs the values in ascii to the entered filename.
**
**  Parameters:
**     fileName (in):  file which will contain register info.
**
*****************************************************************************/
RETCODE EXPORT MapSaveCS(LPSTR fileName);

/****************************************************************************
**
**  MapRestoreCS
**
**  Description:
**     Interface to restore chip selects.
**
**  Parameters:
**     fileName (in):  file which contains register info.
**
*****************************************************************************/
RETCODE EXPORT MapRestoreCS(LPSTR fileName);

/****************************************************************************
**
** MapSaveMap
**
**  Description:
**     Interface to save map setting.
**
**  Parameters:
**     fileName (in):  file which contains map setting.
**
*****************************************************************************/
RETCODE EXPORT MapSaveMap(LPSTR fileName);

/****************************************************************************
**
** MapRestoreMap
**
**  Description:
**     Interface to restore map setting.
**
**  Parameters:
**     fileName (in):  file which contains map setting.
**
*****************************************************************************/
RETCODE EXPORT MapRestoreMap(LPSTR fileName);

RETCODE EXPORT RelinkEP(VOID);
RETCODE EXPORT MapCliDiagnost(LPSTR cmdString, U32 argc, U32 argv[]);

#ifdef __cplusplus
}
#endif

#endif /* _MAP_ */
/******************************** E O F ***********************************/
