/****************************************************************************
**
**  Name:  ERR.C
**
**  Description:
**      Error message strings for IEEE 695 loader.  Entries correspond
**      to error #defines in err.h.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_68k/l695/err.c_v  $
** 
**    Rev 1.0   13 Feb 1997 08:50:42   gene
** Initial revision.
** 
**    Rev 1.0   14 Sep 1995 08:17:20   kevin
** Initial revision.
** 
**    Rev 1.22   30 Aug 1993 11:06:06   ron
** Changes for Load Progress dialog
** 
**    Rev 1.21   10 Aug 1993 09:46:02   nghia
** Added put up hourglass again when display error or warning.
** 
**    Rev 1.20   28 Jun 1993 10:56:16   ron
** changed MessageBox to ErrMessageBox and added corresponding Help Button/Entry
** 
**    Rev 1.19   03 Jun 1993 18:35:16   nghia
** Revised Warning() and WarningEx() to support report warning option.
** Cleanup and added comment block for coding standard.
** 
**    Rev 1.18   19 May 1993 17:59:18   nghia
** Added WarningEx() to report message with extra information.
** 
**    Rev 1.17   22 Mar 1993 17:01:28   nghia
** Moved infomsg[] from errmsg.c to removed that file.
** 
**    Rev 1.16   08 Mar 1993 09:53:10   nghia
** Major cleanup and removed junks.
** 
**    Rev 1.15   12 Jan 1993 14:19:36   courtney
** Info MessageBox (Load complete) is now task-modal (prevents user
** switching to other windows, or exiting app, which crashes windows).
** 
**    Rev 1.14   11 Jan 1993 11:48:16   courtney
** Cleanup - removed commented-out code.
** 
**    Rev 1.13   03 Dec 1992 17:21:52   courtney
** Added _InitInfostring, called to reinitialize text buffer for reporting
** statistics, for each initial load.
** 
**    Rev 1.12   21 Oct 1992 16:15:28   courtney
** Cleaned up error reporting to use string resource.
** Modified Warning, ErrExit, and Query routines to call
** ErrDisplayError on CHECK_MODE, instead of doing a local
** MessageBox/SendToCLI.
** 
**    Rev 1.11   14 Sep 1992 10:40:02   courtney
** Removed ifdef bracketing.
** 
**    Rev 1.10   14 Sep 1992 10:32:36   courtney
** Consolidate status info to single popup (if interactive mode).
** 
**    Rev 1.9   03 Sep 1992 12:06:54   courtney
** Popup load complete boxes when loading from windows (button bar
** or source presenter).
** 
**    Rev 1.8   01 Jun 1992 20:14:46   courtney
** Added option to turn off warnings, via commandline flag.
** 
**    Rev 1.7   20 May 1992 14:14:54   courtney
** Removed LdrGetErrorText.
** 
**    Rev 1.6   12 May 1992 16:46:32   courtney
** If run mode is batch, do not print error text for fatal error (ErrExit),
** the CLI does this.
** Cleanup LdrGetErrorText to work even if CLI not yet init'ed.
** 
**    Rev 1.4   08 May 1992 16:33:38   courtney
** Add LdrGetErrorText.
** 
**    Rev 1.3   07 May 1992 15:54:12   courtney
** New InfoMsg function for informational messages to CLI.
** 
**    Rev 1.2   09 Jan 1992 16:59:10   courtney
** Added Query call.
** 
**    Rev 1.1   31 Dec 1991 10:54:56   courtney
** Added cancel ability to message box.  Added Query function to prompt
** the user who wants to load symbols once they've already been loaded.
** 
**    Rev 1.0   12 Dec 1991 13:44:26   courtney
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/l695/err.c_v   1.0   13 Feb 1997 08:50:42   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef __LDR__
#include "ldr.h"
#endif

#ifndef __VERSION__
#include "version.h"
#endif

#ifndef __ERR__
#include "err.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
/* Note that indiscriminate use of 'char *' type parameters will have
   different effects depending on the memory model used to build this.
   I am assuming Compact model (char * becomes LPSTR).
*/

extern HANDLE cliServerHandle;
extern HANDLE dllServerHandle;
extern BOOL runMode;  /* batch vs. interactive */
extern BOOL reportedLoadAbort; /* synchronize progress handler */
extern U16 ldrwarn;
extern U16 reportOn;
extern U16 reportWarning;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
STATIC CHAR infoString[255] = "";  /* status information */

CHAR *infomsg[] = {
   "Load complete.",
   "bytes code loaded.",
   "module(s) loaded."
};

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/******************************************************************************
**
**  Warning
**
******************************************************************************/
VOID Warning(RETCODE ret) {

   /* Report ret if ret is a warning and reportWarning flag is TRUE */
   if (!reportWarning && ((ret & E_SEVERITY_MASK) == E_WARNING))
      return;
   /* lets let errtext server determine run mode and report appropriately */
   ErrDisplayError(ret, CHECK_MODE);
   if (ret == ER_LOAD_ABORT) {
      reportedLoadAbort = TRUE;
   }
   /* Put up hourglass for loader to continue */
   SetCursor(LoadCursor(NULL, IDC_WAIT)); 
}  /* Warning */

/******************************************************************************
**
**  Query
**
******************************************************************************/
U16 Query(RETCODE ret) {
   S16 status;

   ErrDisplayErrorEx(ret, CHECK_MODE, MB_OKCANCEL | MB_ICONQUESTION,
       (S16 FAR *)&status);
   /* Put up hourglass for loader to continue */
   SetCursor(LoadCursor(NULL, IDC_WAIT)); 

   if (status == IDOK)
      return (QOK);
   else if (status == IDCANCEL)
      return (QCANCEL);

   /* default action is to abort the load process */
   return (QCANCEL);
}  /* Query */

/******************************************************************************
**
** InfoMsg
**
******************************************************************************/
VOID InfoMsg(CHAR *s) {
   if (!reportOn)
      return;
   if (runMode == BATCH)
      SendMessageToCLI(s);
}  /* InfoMsg */

/******************************************************************************
**
**  SendMessageToCLI
**
******************************************************************************/
S16 SendMessageToCLI(CHAR *s) {
   GLOBALHANDLE hmsgBuf;
   CSERVER_RESULTS FAR *lpmsgBuf;
   U16 msgLength;
   U32 err;
   LOOP_VAR i;

   /*
   ** Send (not Post, we don't want them to get queued) text message to CLI.
   ** Used when running in BATCH mode.
   */
   msgLength = lstrlen(s);
   /* note that global allocation is required */
   /* also, we need to allocate for string buffer here */
   if ((hmsgBuf = GlobalAlloc(GHND, sizeof(CSERVER_RESULTS)+msgLength+1))
         == NULL) {
      /* return proper err code */
      return (-1);
   }
   lpmsgBuf = (CSERVER_RESULTS FAR *)GlobalLock(hmsgBuf);
   lpmsgBuf->target = 0;  /* !!! CLI: not yet def'ed */
   lpmsgBuf->variantCode = CLI_SERVER_RESULTS;  /* !!! CLI: not yet def'ed */
   lpmsgBuf->resultTextLength = msgLength;
   /* we've already allocated for buffer */
   for (i=0; i<msgLength; i++)
      lpmsgBuf->messageText[i] = *s++;
   lpmsgBuf->messageText[i] = '\0'; /* NULL terminate string */
   /* Send resultant message to CLI */
   err = SendMessage(cliServerHandle, CLI_SERVER_RESULTS, hmsgBuf,
	   (DWORD)CLI_SERVER_RESULTS);
   return (err);
}  /* SendMessageToCLI */

/******************************************************************************
**
**  InitInfostring
**
******************************************************************************/
VOID InitInfostring(VOID) {
   /* In case the previous load exited with a partially constructed info
   ** buffer (as with user-abort), we need to clear for each load
   */
   infoString[0] = '\0';
}  /* InitInfostring */

/******************************************************************************
**
**  WarningEx
**
******************************************************************************/
VOID WarningEx(RETCODE ret, LPSTR infoStr) {
   /* Report ret if ret is a warning and reportWarning flag is TRUE */
   if (!reportWarning && ((ret & E_SEVERITY_MASK) == E_WARNING))
      return;
   ErrDisplayString(ret,(LPSTR) infoStr, CHECK_MODE);
   /* Put up hourglass for loader to continue */
   SetCursor(LoadCursor(NULL, IDC_WAIT)); 
}  /* WarningEx */

/*********************************** E O F ***********************************/
