/***************************************************************************
**
**  Name: mapdef.h
**
**  Description: Local definitions for map presenter
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/map/mapdef.h_v  $
** 
**    Rev 1.0   13 Feb 1997 08:52:32   gene
** Initial revision.
** 
**    Rev 1.1   21 Jun 1996 15:04:54   kevin
** added some definitions for 302 case
** 
**    Rev 1.0   07 Sep 1995 11:27:56   gene
** Initial revision.
** 
**    Rev 1.0   19 May 1994 10:28:00   tom
** Initial revision.
**
**    Rev 1.0   28 Jan 1994 13:19:12   kevin
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/map/mapdef.h_v   1.0   13 Feb 1997 08:52:32   gene  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
****************************************************************************/
#define _MAPDEF_

#define NULL_ADDR       0xFFFFFFFF
#define MAX_RANGE       32768
#define MIN_RANGE       64
#define MAX_STR_LEN     80
#define MAX_MAPNUM      16
#define ADDMAP          0x00000040
#define EDITINTEL       0x00000100
#define EDIT68K         0x00000200
#define TARGET_MEM      0x80
#define MAX_NAME_LEN    40
#define MAX_MAPSTR_LEN  180

#define GETEDITINDEX(X) ((X)&0x0000000F)
#define ISADDDIALOG(X)  ((X)&0x00000040)
#define GETDLGTYPE(X)   ((X)&0x00000300)

#define GETTYPE(B)      (((B)&0x80)>>7)
#define GETACCESS(B)    ((B)&0x07)

#define HAS_UP(N)        ((N)&0x0008)
#define HAS_UD(N)        ((N)&0x0004)
#define HAS_SP(N)        ((N)&0x0002)
#define HAS_SD(N)        ((N)&0x0001)
#define HAS_SPC0(N)      ((N)&0x0010)
#define HAS_SPC3(N)      ((N)&0x0020)
#define HAS_SPC4(N)      ((N)&0x0040)

#define HAS_SMM(N)       ((N)&0x0010)
#define HAS_USR(N)       ((N)&0x0020)
#define IS68KSPACE(N)    ((N)&0x000f)
#define ISINTELSPACE(N)  ((N)&0x0030)

#define ACCESS_RAM       0
#define ACCESS_ROMBRK    1
#define ACCESS_ROMNOBRK  2
#define ACCESS_NONE      3

#define GETSPACE(b7,b6,b5,b4,b3,b2,b1,b0) \
         ( ((b7)<<7)|((b6)<<6)|((b5)<<5)|((b4)<<4)|((b3)<<3)|((b2)<<2)|((b1)<<1)|(b0) )
