/***************************************************************************
**
**  Name: mapdlg.h
**
**  Description: map presenter definitions
**
**  Status: PRELIMINARY
**
**  $Log:   S:/tbird/mt2_68k/map/mapdlg.h_v  $
** 
**    Rev 1.0   13 Feb 1997 08:52:32   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:27:58   gene
** Initial revision.
** 
**    Rev 1.1   19 May 1994 17:01:20   tom
** Match parameter types.
** 
**    Rev 1.0   19 May 1994 11:33:46   tom
** Initial revision.
**
**    Rev 1.0   28 Jan 1994 13:19:12   kevin
** Initial revision.
**
**  $Header:   S:/tbird/mt2_68k/map/mapdlg.h_v   1.0   13 Feb 1997 08:52:32   gene  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
****************************************************************************/
#define _MAPDLG_


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define HE_MAP 2015
typedef struct tagMAPINFO
{
   DWORD addr;
   DWORD size;
   BYTE  type;
   WORD  space;
} MAPINFO;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  InitPresenter
**
**  Description:
**     Initialize the presenter and get system information.
**
**  Parameters:
**     var1 (in): handle of instance
**
*****************************************************************************/
RETCODE EXPORT InitPresenter(HANDLE);

/****************************************************************************
**
**  MapPresenter
**
**  Description:
**     Entry point of the presenter
**
**  Parameters:
**     var1 (in): handle of the parent window
**
*****************************************************************************/
RETCODE EXPORT MapPresenter(HWND);

/**************************************************************************
**
**  GetMapInfo
**
**  Purpose: get map information from map server
**
**  nIndex (in): bank number
**  pMapInfo (out): map information
**
***************************************************************************/
RETCODE GetMapInfo(U16, MAPINFO *);

/**************************************************************************
**
**  SetMapInfo
**
**  Purpose: send map information to map server
**
**  MapInfo (in): map information
**  bEnable (in): TRUE--enable; FALSE--disable
**  IndexNo (in): index number used only when disabling the setting
**
***************************************************************************/
RETCODE SetMapInfo(MAPINFO, BOOLEAN, U32);
