/* CLI utility library interface routines */!!

inherit(ProvidedLibs, #CLIULibrary, #(counter), 2, nil)!!

now(class(CLIULibrary))!!

/* semiPRIVATE -- should only be called via require(CLIULibrary)
   Define entry points and load library.  Define any structs required.
*/
Def provide(self, path)
{
  ^initialise( new(self:ancestor), path )
}
!!

now(CLIULibrary)!!

/* 12/12/1995 18:29 */
/* Write text to the login screen */
Def writeTextToLogin(self, text)
{
  if pcallLock(self)
    lastError := pcall(procs[#SETLOADINGDLLNAME], asciiz(text));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
}!!

/* 2/4/1992 17:06 */
Def addImportProcs(self)
{
  add(self, #INITCSERVER,        1, #(0, 0));
  add(self, #CLIRIGHTSHIFT,      1, #(1, 1, 1));
  add(self, #CLILEFTSHIFT,       1, #(1, 1, 1));
  add(self, #CLIBITWISENEGATION, 1, #(1, 1));
  add(self, #CLISETACTIVE,       1, #(0));
  add(self, #CLICLEARACTIVE,     1, nil);
  add(self, #CLIGETACTIVE,       1, #(1));
  add(self, #UNIXOPENFILE,       1, #(1, 1));
  add(self, #ABOUTBOX,           1, #(1));
  add(self, #OPENLOGIN,          1, #());
  add(self, #CLOSELOGIN,         1, #());
  add(self, #HOOKF1FILTER,       1, #());
  add(self, #UNHOOKF1FILTER,     1, #());
  add(self, #REGISTERHELPENTRY,  1, #(0, 1, 0));
  add(self, #CLILDRINFODIALOG,   1, #(1));
  add(self, #SAVETOOLBARHANDLE,  1, #(1));
  add(self, #SETLOADINGDLLNAME,   1, #(1));
}!!

/* bitwise negation; ~a */
Def bitwiseNegation(self, a | a2Ref)
{
  a2Ref := new(Struct, 4);
  if pcallLock(self)
    lastError := pcall(procs[#CLIBITWISENEGATION], asLong(a), a2Ref);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);

  if (lastError = 0)
    ^longAt(a2Ref, 0);
  else
    ^nil
  endif;
}!!

/* CLI is inactive*/
Def clearCliActive(self)
{
  if pcallLock(self)
    lastError := pcall(procs[#CLICLEARACTIVE]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError = 0)
    ^0;
  else
    ^nil
  endif;
}!!

/* get CLI active value */
Def getCliActive(self | wordRef)
{
  wordRef := new(Struct, 2);
  if pcallLock(self)
    lastError := pcall(procs[#CLIGETACTIVE], wordRef);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  
  if (lastError = 0)
    ^wordAt(wordRef, 0);
  else
    ^nil
  endif;
}!!

/* left shift; a1 << a2 */
Def leftShift(self, a1, a2 | a3Ref)
{
  a3Ref := new(Struct, 4);
  if pcallLock(self)
    lastError := pcall(procs[#CLILEFTSHIFT], asLong(a1), asLong(a2), a3Ref);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);

  if (lastError = 0)
    ^longAt(a3Ref, 0);
  else
    ^nil
  endif;
}!!

/* right shift; a1 >> a2 */
Def rightShift(self, a1, a2 | a3Ref)
{
  a3Ref := new(Struct, 4);
  if pcallLock(self)
    lastError := pcall(procs[#CLIRIGHTSHIFT], asLong(a1), asLong(a2), a3Ref);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,lastError,CHECK_MODE);

  if (lastError = 0)
    ^longAt(a3Ref, 0);
  else
    ^nil
  endif;
}!!

/* CLI is active*/
Def setCliActive(self)
{
  if pcallLock(self)
    lastError := pcall(procs[#CLISETACTIVE], getCliServerHandle(CliServer));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError = 0)
    ^0;
  else
    ^nil
  endif;
}!!

/* Open the UNIX file; return the hand */
Def unixOpenFile(self, fileName |
      dummyFile dummyTextFile handleRef dummyFile count)
{
  handleRef := new(Struct, 2);
  if pcallLock(self)
    lastError := pcall(procs[#UNIXOPENFILE], asciiz(fileName), handleRef);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);

  if (lastError = 0)
    /* create a File object in order to fill TextFile buffer */
    dummyFile := new(File);
    dummyFile.handle := wordAt(handleRef, 0);  /* DOS handle */
    /* create text file */
    dummyTextFile := new(TextFile);
    setDelimiter(dummyTextFile, asString(asChar(10)));  /* UNIX newline */
    setName(dummyTextFile, fileName);  /* stuff name */
    dummyTextFile.handle := wordAt(handleRef, 0);  /* DOS handle */
    dummyTextFile.readable := 0;    /* readable */
    dummyTextFile.writeable := nil;  /* not writable */
    /* initialize buffer with nulls, then read in up to 512 bytes */
    dummyTextFile.buffer :=
      replicate(asString(asChar(0)), dummyTextFile.bufLen);
    count :=
      bRead(dummyFile, dummyTextFile.buffer, dummyTextFile.bufLen);
    ^dummyTextFile;
  else
    ^nil;
  endif;
}!!

/* display About Box */
Def showAboutBox(self | parent)
{
  lastError := GOOD;
  if (not(TheToolBarPresenter)) then
     parent := getHWnd(ThePort);
  else
     parent := getHWnd(TheToolBarPresenter);
  endif;
  if pcallLock(self)
    lastError := pcall(procs[#ABOUTBOX], asLong(parent));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* display Login bitmap */
Def openLogin(self)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#OPENLOGIN]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* remove Login bitmap */
Def closeLogin(self)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#CLOSELOGIN]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* Install F1 Windows Hook */
Def f1hook(self)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#HOOKF1FILTER]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* Un-Install F1 Windows Hook */
Def f1unhook(self)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#UNHOOKF1FILTER]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* Register a help entry for the F1 hook */
Def registerF1Help(self, hInd, hWnd, helpEntry)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#REGISTERHELPENTRY], hInd, asLong(hWnd), helpEntry);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* display Load information dialog */
Def displayLoadInfo(self | parent)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#CLILDRINFODIALOG], asLong(getHWnd(ThePort)));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!

/* save the tool bar handle, for DLLs to send messages to */
Def saveToolBarHandle(self, hToolBar)
{
  lastError := GOOD;
  if pcallLock(self)
    lastError := pcall(procs[#SAVETOOLBARHANDLE], asLong(hToolBar));
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;
  ^lastError;
}!!
