/* CLASS: INPUTDLG.CLS                                [Ron -- 5/6/93] 
 *
 * Input Dialog Box with Help Button
 * 
 *    Created to use initially for the Variable Window enhancements, but 
 * with general-purpose use in mind.  (Hopefully to be superceded by a 
 * pure C++ implementation of the same thing, someday soon.)
 * After a succesfull runModal(), send getText() message to retrieve 
 * the editText object.  This has been heavily influenced by (stolen from)
 * the bkptdialog class.
 *
 * REQUIRES: globals.h, dialogid.h
 */!!

inherit(Dialog, #InputDlgWithHelp, #(editText /* editText object */
staticText /* static text control (label) */
captionText /* the dialog box caption */
helpEntry /* help Entry point */
), 2, nil)!!

now(class(InputDlgWithHelp))!!

/* PUBLIC
 * Create a new InputDlgWithHelp object
 */
Def open(self | theDlg)
{
   theDlg := new(self);
   ^theDlg;
}
!!

now(InputDlgWithHelp)!!
!!

/* PUBLIC
 * Return the text defined in self.
 */
Def getText(self | tmpstr)
{
   tmpstr := editText;
   ^editText;
}
!!

Def setUp(self, cText, sText, eText, hEntry)
{
   /* Style of dialog box */
   captionText := cText; /* caption */
   helpEntry := hEntry;  /* help entry point */
   staticText := sText;  /* static text -- label for edit control */
   editText := eText;    /* initial text in edit control */
}
!!

/* 
 * Dialog box command processing.
 */
Def command(self, wp, lp)
{ 
   select
      case wp = IDCANCEL
         ^end(self, IDCANCEL);
      endCase
     
      case wp = IDOK
         editText := getItemText(self, DLG_INPUT_TEXT); 
         ^end(self, IDOK);
      endCase

      /* Display Help for the InputDlgWithHelp */  
      case wp = IDHELP
         is contextNumber(TheHelpObject, hWnd, helpEntry);
      endCase        
    
   endSelect;
   ^GOOD;
}
!!

/* PUBLIC
 * By returning a 1 from the INITDIALOG message, we
 * are telling MS-Windows to set the input focus to
 * first tabstop item. (Which is exactly what we want). 
 */
Def initDialog(self, wP, lP | tmp)
{
   registerF1Help(CLIULibraryClass$Inst, HI_INPUT_DLG_WITH_HELP,
      getHWnd(self), helpEntry);
   setText(self, captionText);
   setItemText(self, DLG_INPUT_LABEL, staticText);
   setItemText(self, DLG_INPUT_TEXT, editText);
   ^1; 
} 
!!
