/* Presenter class of the trigger specification window. */!!

inherit(MaxSizeWindow, #TriggerPresenter, #(activeLevel /* currently active level */
levelWin 
hFont   /* holds font size */
charWidth
charHeight
nonScrollArea /* size of header area that isn't scrolled */
theTrigger /* trigger instance for this window */
), 2, nil)!!

now(class(TriggerPresenter))!!

/* 7/29/1996 13:42 */

Def exists(self | handle)
{
   if TheTriggerPresenter
      handle := existsTriggerWindow(TriggerLibClass$Inst);
      if handle 
         setHWnd(TheTriggerPresenter,handle)
      else
         TheTriggerPresenter := nil;
      endif;
   endif;
   ^TheTriggerPresenter;
}!!

Def open(self)
{
   if not(exists(self))
      if not(TheTriggerPresenter:=new(TriggerPresenter,nil,nil,
            "Trigger",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheTriggerPresenter));
      setHWnd(TheTriggerPresenter,openTriggerWindow(TriggerLibClass$Inst,
            nil, 0));
      show(TheTriggerPresenter,SW_SHOW);
   endif;
   ^TheTriggerPresenter;
}!!

Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
  if not(exists(self))
      if not(TheTriggerPresenter := new(TriggerPresenter, nil, nil,
            "Trigger",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheTriggerPresenter));
      if ((newHWnd := openTriggerWindow(TriggerLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(TheTriggerPresenter,newHWnd);
         show(TheTriggerPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^TheTriggerPresenter; 
}!!

now(TriggerPresenter)!!

/* 7/29/1996 13:44 */

Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Trigger window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif;

  if (windRect) then   
    layout := new(String, 18);
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD;
}!!

Def close(self)
{ 
   if (exists(class(self)))
      closeTriggerWindow(TriggerLibClass$Inst);
      TheTriggerPresenter := nil;
   endif;
   freeTrigger(TriggerLibClass$Inst); 
   ^GOOD;
}!!

Def sizeRect(self)
{
  ^rect(90, 40, 200, 200);
}
!!
