/***********************************************************************
**
**  Filename: dm_main.c
**
************************************************************************/

#define NULL 0

                        /****************************
                        *                          *
                        *     GLOBAL DEFINITIONS   *
                        *                          *
                        ****************************/

char array1[] = "1 2 3 5 ";
char array2[] = "4 ";

/* structure of linklist cells; terminates when "next" equals NULL pointer */

typedef struct LINKS {
   struct LINKS *next;      /* pointer to next cell */
   char         *stringPtr; /* pointer to string    */
   short int    length;     /* length of string    */
} CELL_TYPE ;

CELL_TYPE cell[10] = {       /* reserve 30 cells space  */
      { &cell[1], array1 ,     2},      /* initialize first 5 cells */
      { &cell[2], &array1[2] , 2},
      { &cell[3], &array1[4] , 2},
      { NULL,     &array1[6] , 2},
      { NULL,     array2,      2}
};

CELL_TYPE *top;  /* pointer to top cell */

const float pi = 3.1415926536;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

void insert(CELL_TYPE *record, int place);
void remove(int place);
void printall(void);
float cosineFunc(float x);

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/*----------------------------------------------------------------------
** main
**
** Purpose: loop forever inserting a cell into linked list,
**          "printing" to an output buffer, removing the linked cell,
**          then "printing" again.
------------------------------------------------------------------------*/
void main()  {
   static unsigned long staticIterations = 0L;

   static float radianInput, cosineOutput;

   /* initialize top pointer */
   top = &cell[0];

   for (;;) { 
      /* insert one cell at specified place */
      insert(&cell[4] ,3);

      /* output all messages ( writing to 'outbuf')  */
      printall();

      /* remove one cell from linked list */
      remove(3); 

      /* output all messages ( writing to 'outbuf')  */
      printall();

      radianInput = 0.0;
      cosineOutput = cosineFunc(radianInput); /* should be 1 */

      /* radianInput = pi / 4.0; */
      /* cosineOutput = cosineFunc(radianInput); */ /* should be .707107 */
      
      /* number of iterations */
      staticIterations++;
   }
}  /* end of main */

/******************************** E O F ***********************************/
