/************************************************************************/
/*       	                                                     	*/
/*  ENTRY:  Main entry point routine, it does the following		*/
/*									*/
/*     1. Initializes SP as (.startof.(stack) + .sizeof.(stack))	*/
/*	       which was defined at link time				*/
/*	    2. Initializes __HEAP as starting address			*/
/*             of SECTION heap						*/
/*     3. Initializes the frame pointer to zero for debugger	*/
/*	    4. Clears the 'zerovars' section.				*/
/*     5. Calls C initialization routine _START			*/
/*									*/
/*	This module also contains the function _exit() which is called  */
/*	by exit() upon program termination.				*/
/*									*/
/************************************************************************/
           
#include <string.h>		/* DECLARATIONS TO ELIMINATE COMPILER WARNING */

#if _PIC			/* SET BY COMPILER */
    #if _68020 || _68030 || _68040 || _CPU32
	#define ADDR(x) (x).L(PC)
    #else
	#define ADDR(x) (x).W(PC)
    #endif
#else
    #define ADDR(x)     (x)
#endif

#pragma asm
              OPT	CASE
	      COMMON	stack,,D	    * DECLARE stack SECTION
              SECTION   code,,C		    * CODE SECTION
	      XDEF	ENTRY
	      XDEF	__exit
*
              XREF      __START
              XREF      _exit
              XREF      _memset
#if _A5_REL				/* SET BY USER ON COMMAND LINE */
	      XREF	?A5
#endif
*
ENTRY:   MOVE.B	 #4,$FFFA21		* disable watchdog timer location
                                 * and enable internal bus monitor
         MOVE.B    #$40,$FFFA00  * clear FRZBM to allow busmon during freeze
         MOVE.L    #.STARTOF.(stack),SP	* INITIALIZE STACK POINTER
	      ADD.L	#.SIZEOF.(stack),SP	* STACK GROWS DOWN
         LEA       __HEAP,A0		* INITIALIZE HEAP POINTER
         ADDQ.L    #4,A0			* __HEAP POINTS TO ADDRESS -
         MOVE.L    A0,__HEAP		* JUST BEYOND ITSELF
         MOVE.L    #0,A6			* FRAME POINTER INITIALIZATION
	      LEA	.STARTOF.(zerovars),A0		* START OF SECTION
	      MOVE.L	#.SIZEOF.(zerovars),-(SP)	* LENGTH OF THE SECTION
	      CLR.L	-(SP)		    		* ZERO TO STACK
	      MOVE.L	A0,-(SP)			* START OF SECTION
	      JSR	ADDR(_memset)			* CALL MEMSET TO ZERO
	      ADD.L	#12,SP				* SHRINK STACK
              JSR       ADDR(__START)		* CALL C INITIALIZATION ROUTINE
	      MOVE.L	D0,-(SP)		* PUSH RETURN VALUE ON STACK
	      JSR	ADDR(_exit)		* CALL EXIT -- NO RETURN
*
*	      __exit IS CALLED BY exit().  IT SIMPLY EXECUTES A STOP
*	      INSTRUCTION.
*
__exit:
	      STOP      #$2700
              BRA.S	__exit
              RTS
*
*	DEFINE THE SECTION heap AND PLACE __HEAP THERE
*
              SECTION   heap,,D			* HEAP SECTION
              XDEF      __HEAP            
__HEAP	      DS.L      1
              END       ENTRY
#pragma	endasm
