/**************************************************************************
**
** Name: WSPAR.C
**
** Description: Windows Communication DLL for Microtek's MS-PCE Parallel
**		Interface Card
**
** Status: CODED
**
** $Log:   S:/tbird/mt2_68k/sds/wspar.c_v  $
** 
**    Rev 1.0   13 Feb 1997 09:04:06   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:12:22   gene
** Initial revision.
** 
** $Header:   S:/tbird/mt2_68k/sds/wspar.c_v   1.0   13 Feb 1997 09:04:06   gene  $
**
** Copyright (C) 1994 Microtek International, Inc.
**
**************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>
#ifndef _WINDOWS_
#include "windows.h"
#endif

#ifndef _WSCOM_
#include "wscom.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

#ifndef _COMERR_
#include "comerr.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#define RX_RDY		0x01	// data valid if corresponding bit set
#define TX_FULL		0x02	// transmitter full if corresponding bit set

/* use with Borland C++ compiler */
#ifndef _BORLANDC_
#define _BORLANDC_
#endif

/* Global data of DLL */
HANDLE  libInst;                 /* handle of the DLL */
WORD	PCEData;		// address of PCE data port
WORD	PCEStatus;		// address of PCE status port
WORD    dlgIndx = 0x200;          /* default PCE port */
//	int     checkButton = IDD_COM2;  /* check button of InitCom dialog */
//	FARPROC lpfnReceiveCallBack;     /* application Receive Callback */
//	COMSTAT commStat;                /* global communication status */
//	DCB     comDcb;                  /* global Device Control Block of COM port */
U16     timerId;                 /* timer ID for SdatInput callback */
//	BOOL    inReadSemaphore=FALSE;   /* already in read when called again */
BOOL    cancelConn=FALSE;        /* user request to cancel connection */

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/
/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the DLL.
**
**      Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);
    libInst = hInstance;  /* Save the handle */
	ErrInitDLL(MODULE_WSCOM, "wspar.dll");
    /* initialize successfully */
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++
**
**      Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}

#endif

/**************************************************************************
**
** WSComInit
**
** Description: Initialize the parallel (MS-PCE) communication port.
**
**      Parameters:
**    input:
**       hWnd:        Handle to the application window
**       cIndx:       Long pointer to Index of the selected port.
**    output:
**       TRUE/FALSE
**
***************************************************************************/
BOOL FAR PASCAL WSComInit(HWND hWnd, LPWORD cIndx) {
   BOOL InitOk = FALSE;

   PCEData = dlgIndx = *cIndx; /* work with the copy of the global port base */

   /* query user for the com port he wishes to connect to only if the */
   /* port base passed in is zero, otherwise just try to connect */
   if (!dlgIndx) {
      if (libInst != NULL) {
         dlgIndx = 0x200;
            return(FALSE);
      }
   }
   if (cancelConn) {
      cancelConn=FALSE;
      /* return is boolean, but need to indicate to caller that
         user abort was requested */
      *cIndx = -1;
      return (FALSE);
   } else {
      *cIndx = dlgIndx;
   }
   /* Reset Device Control Block to be reconfigured */
//   comDcb.Id = UNINIT;
	PCEData = dlgIndx;
	PCEStatus = PCEData + 1;
   return(InitOk);
}

/**************************************************************************
**
** WSComConfig
**
** Description: This function provides the serial communication
**              configuration services.
**
**      Parameters:
**    input:
**       hWnd        Handle of the main window
**       cIndx       Index to a COM port ID
**    output:
**
**
***************************************************************************/
#pragma argsused
BOOL FAR PASCAL WSComConfig(HWND hWnd, WORD cIndx, BOOLEAN useDTRHandshake)
{
   return(TRUE);
}

/**************************************************************************
**
** WSComRead
**
** Description: This function read numBytes of data from the PCE port
**
** Parameters:
**    input:
**       hWnd           Handle of the Main window.
**       rxBuff         Long pointer to the receiving buffer
**       numBytes       Pointer to number of bytes request to read
**    output:
**       nbytes         Number of bytes read in
**
***************************************************************************/
RETCODE FAR PASCAL WSComRead(U8 FAR *rxBuff, U16 FAR *numBytes) {
S16 num;
U8 FAR *ptr;

	ptr = rxBuff;
	for (num = 0; num < *numBytes; num++)
		{
		if (inp(PCEStatus) & RX_RDY) *ptr++ = inp(PCEData);
		else break;
		}
	*numBytes = (U16)num;
	return(GOOD);
}

/**************************************************************************
**
** WSComWrite
**
** Description: This function send numBytes of data to the PCE port.
**
**      Parameters:
**    input:
**       txBuff         Long pointer to the transmitting buffer
**       numBytes       Number of bytes in the transmitting buffer
**    output:
**       numBytes       Number of bytes written
**
***************************************************************************/
RETCODE FAR PASCAL WSComWrite(U8 FAR *txBuff, U16 *numBytes)
{
U8 FAR *ptr;
U16 bytesSent;

	ptr = txBuff;
	for (bytesSent=0; bytesSent < *numBytes; bytesSent++)
		{
		while (!(inp(PCEStatus) & TX_FULL));
		outp(PCEData, *ptr++);
		}
	*numBytes = bytesSent;
	return(GOOD);
}

/**************************************************************************
**
** WSComRecvTimer
**
** Description:  Function to setup the timer to read data from PCE port
**
**
**      Parameters:
**    input:
**       timeEllapse    Timer interval to ellapse
**       lpfnAppRecv    Long pointer to a Callback function of the application
**                      to process the received data.
**    output:
**       none
**
***************************************************************************/
BOOL FAR PASCAL WSComRecvTimer(WORD timeEllapse,  FARPROC lpfnAppRecv)
{
   /* Set timer to run and register callback function to receive data */
   if (!(timerId=SetTimer(NULL, 0, timeEllapse, lpfnAppRecv))) {
      ErrDisplayError(ER_NO_TIMER_AVAIL, FORCE_POPUP);
      return(FALSE);
   }
   return(TRUE);
}

/**************************************************************************
**
** WSComClose
**
** Description:  Close the connection of the PCE port
**
**      Parameters:
**    input:
**       none
**
**    output:
**       GOOD if no error - error code
**
***************************************************************************/
BOOL FAR PASCAL WSComClose(VOID) {
   KillTimer(NULL,timerId);
   return(TRUE);
}
/**************************************************************************
**
** WSComFlush
**
***************************************************************************/
RETCODE FAR PASCAL WSComFlush(VOID) {
   return(GOOD);
}

/*****************************************************************************
**
** WSComAckRequired
**
** Report that ACK/NAK required for parallel comm
**
*****************************************************************************/
BOOL FAR PASCAL WSComAckRequired(VOID) {
    return(TRUE);
}

/****************************************************************************
**
** WSComUploadPacketSize
**
*****************************************************************************/
RETCODE FAR PASCAL WSComUploadPacketSize(U32 *packetSize)
{
   *packetSize = 256L;
   return(GOOD);
}

/******************************** E O F ***********************************/
