/***************************************************************************
 *
 * Name : ABIFUNC.H
 *
 * Description : export function prototypes of ABI routines in
 *               REG86.C, MEM86.C, SUB86.C, and EXEC86.C
 *
 * Date : 12/07/1992
 *
 *    Copyright (C) 1992 Microtek International Inc.
 *    All Rights Reserved
 *
 ***************************************************************************/
#define _ABI_FUNC_

#ifndef _BASE_TYPE_
#include "basetype.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG86_DEFINE_
#include "reg86.h"
#endif


STATUS emuGetID(U8 *ID_Info);
STATUS emuSetID(U16 idFlag);
STATUS emuGetWait(U16 *count);
STATUS emuSetWait(U16 count);
STATUS emuGetVerify(U16 *verifyFlag);
STATUS emuSetVerify(U16 verifyFlag);
STATUS emuGetSync(U16 *sync);
STATUS emuSetSync(U16 syncFlag);
STATUS emuGetMode();
STATUS emuControl();
//STATUS emuGetControl(U16 *signals);
//STATUS emuSetControl(U8 flag, U16 signals);
STATUS emuGetReady(U16 *readyFlag);
STATUS emuSetReady(U16 readyFlag);
STATUS emuGetStatus(VOID);
STATUS emuGetAccessSize(U16 *sizeFlag);
STATUS emuSetAccessSize(U16 sizeFlag);
STATUS emuSetTimerReg(U16 regNo);
int emuInit();
STATUS emuDiagnostic(VOID);
STATUS emuSelfTest(U16 cmdId);
STATUS emuSetTraceBreak(U16 breakFull);
STATUS emuSetTraceBuff(U16 traceBufNum);
STATUS emuSetTimerCount(U16 tcFlag, U32 tcData);
STATUS emuGetTraceInfo(U16 *lastBuff, U16 *curCNT0, U16 *curCNT1, U16 *bufNO);
STATUS emuGetAllTrig(TRIGGER *trig_record);
STATUS emuSetTrig(TRIGGER *tmpTrig);
STATUS emuClrTrig();
STATUS emuClrTrigLevel(U16 levelNo);
STATUS emuSetTLevel(U16 levelNo, TRIGGER *tmpTrig);
STATUS emuSetBP(U16 evId, ADDR addr);
STATUS emuGetEvent(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 *ext_record,
                 U8 *cntFlag, U32 *timeRecord, U16 *counter);
STATUS emuSetExtEvent(U16 evData);
STATUS emuSetAllEvents(BUS_EVENT *event_record, EXEC_EVENT *bp_record, U16 ext_record);
STATUS emuSetEvent(U16 evId, BUS_EVENT *busEventData);
STATUS emuGetTraceDepth(U16 bufID, BUFFER_DEPTH *trcDepth);
STATUS emuListTraceBuff(int bufID, S32 startFrame,QUALIFY_LIST *cond, U8 *frameLen, TRACE_INFO *frameData);
STATUS emuGo(U16 mode);
STATUS emuGetCpuStatus(U8 *goEnd);
STATUS emuReset(VOID);
STATUS emuAbort(VOID);
STATUS emuStepRange(ADDR addr1, ADDR addr2);
STATUS emuStepOne(VOID);
STATUS emuClrEvent(U16 evId);
STATUS emuGetReg(REG_MODE regMode, S16 regId,U32 *content);
STATUS emuGetAllReg(U16 *cpuReg);
STATUS emuGetAllIntReg(U16 *intReg);
STATUS emuSetReg(REG_MODE regMode, S16 regId, U32 content);
STATUS emuGetCoReg (S16 regId,U8 *content);
STATUS emuGetAllCoReg( U8 **contest);
STATUS emuSetCoReg(S16 coRegId,U8 *content);
STATUS emuOutput(U16 port, U8 *data, U16 len, U16 size);
STATUS emuInput(U16 port, U16 len, U16 size, U8 *buff);
STATUS emuTest(ADDR addr, U32 len);
STATUS emuChecksum(ADDR addr, U32 len, U16 *n);
STATUS emuSearch(ADDR addr1,U32 len, U8 *buff, U16 patternLen, U16 *times);  /* search block for pattern */
STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, U16 *diff);
STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2);
STATUS emuSetMem(ADDR addr, U8 ch);
STATUS emuSetMemN(ADDR addr, U8 *buff, U16 patternLen);
STATUS emuGetMem(ADDR addr, U8 *buff);
STATUS emuGetMemN(ADDR addr, U8 *buff, U16 len);
STATUS emuFill(ADDR addr, U32 len, U8 *buff, U16 patternLen);
STATUS emuSize(SIZE size);
STATUS emuGetMap(MAP_INFO *mapData);
STATUS emuGetMapSize(U8 *emmSize);
STATUS emuSetMap (ADDR addr1, ADDR addr2, U16 attr);
STATUS DiagnosticFunction(DIAG_ID diagID);
STATUS emuInitialize(U16 portAddr, U16 idFlag, U16 testFlag, U16 *testResult);


STATUS emuTrace(TRACE *trcInfo);
STATUS emuCycle(U16 cycInfo);
STATUS emuIce(U8 *MICE_cmd);




/********************************** E O F ************************************/

