/***************************************************************************
**
**  File name : ASMDEF.H
**
**  Description : include file of assembler
**
**  Date : 11/13/1992  by C. H. Lin
**
**
**  Copyright (C) 1993 Microtek International Inc.
**  All Rights Reserved
**
****************************************************************************/


/***************************** Macro Definition ****************************/

#define EXTERN  extern
#define GLOBAL
#define LOCAL   static
#define PUBLIC
#define PRIVATE static

#define TRUE  1
#define FALSE 0
#define MAXOPERAND 3
#define MAXOPCODE  2

#define COUNT(x) (sizeof(x)/sizeof(x[0]))

/*************************** Enumerated Constants **************************/

enum ASM_ERRORS {
    ASM_OK,
    ASM_MNEMONICERR,
    ASM_SYNTAXERR,
    ASM_FORMATERR,
    ASM_TYPEERR,
    ASM_UNDEFSYMBOL,
    ASM_INVALIDNUM,
    ASM_NUMOUTRANGE,
    ASM_JMPOUTRANGE,
    ASM_DEFTOOLARGE,
    ASM_DEFSTORAGE
};

enum OPERAND_TYPE {
    NONE,
    SEG,
    AL,AX,CL,DX, REG8,REG16,
    MEMDIRECT,MEMDIRECTBYTE,MEMDIRECTWORD,
        MEM,MEMBYTE,MEMWORD,MEMDWORD,MEMQWORD,MEMTBYTE,MEMNEAR,MEMFAR,
    DATAONE,DATA8, DATA,
    SEGOFFSET,
    ST,STI
};

/***************************** Type Declaration ****************************/

typedef unsigned char U8;
typedef unsigned int  U16;
typedef unsigned long U32;
typedef char          *STR;
typedef int           BOOLEAN;
typedef long          PCTYPE;
typedef int           RETCODE;

typedef RETCODE (*TYPEROUTINE)();

typedef struct {
    U8 Format[3];
    TYPEROUTINE Type;
} FORMATSTRUCT;

typedef struct {
    TYPEROUTINE Type;
    U8 Codes[MAXOPCODE];
} CODESTRUCT;

typedef struct {
    STR Mnemonic;
    CODESTRUCT *CodeTable;
    int TotalCode;
    FORMATSTRUCT *FormatTable;
    int TotalFormat;
} ASMSTRUCT;

typedef struct {
    char OperandType;
    char MemberID;
    long Number;
} OPERANDSTRUCT;

/****************************** End of File ********************************/
