/***************************************************************************
**
**  File name : ASMTBL.C
**
**  Description : tables used for assembler
**
**  Date : 2/15/1993  by C. H. Lin
**
**
**  Copyright (C) 1993 Microtek International Inc.
**  All Rights Reserved
**
****************************************************************************/


/****************************** Include File *******************************/

#include "asmdef.h"

/*********************** External Function Prototype ***********************/

/* defined in ASMTYPE.C */
EXTERN RETCODE Atype_X                    (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X0sgX                (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xcw_modXrm           (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xd0_mod0sgrm         (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xdw                  (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xdw_laddr_haddr      (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xdw_modregrm         (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xdw_port             (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xreg                 (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xs0_data             (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xs1_disp             (PCTYPE, OPERANDSTRUCT*, U8*,int*);
EXTERN RETCODE Atype_Xs1_modregrm_data    (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xsw_modXrm_data      (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xv_type              (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xwreg_data           (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xw_data              (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xw_modregrm          (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xw_modXrm            (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xw_modXrm_count      (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_Xw_modXrm_data       (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X_disp               (PCTYPE, OPERANDSTRUCT*, U8*,int*);
EXTERN RETCODE Atype_X_ldata_hdata        (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X_ldata_hdata_data   (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X_ldisp_hdisp        (PCTYPE, OPERANDSTRUCT*, U8*,int*);
EXTERN RETCODE Atype_X_loff_hoff_lseg_hseg(OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X_modregrm           (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X_modXrm             (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_X_modXrm_FAR         (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCxxx_modXrm        (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCdxx_11xxxrm       (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCdxx_11xxdrm       (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCdxx_11xxsrm       (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCqxx_modXrm        (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCwxx_modXrm        (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCxtx_modXrm        (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCxxx_110xxrm       (OPERANDSTRUCT*,  U8*, int*);
EXTERN RETCODE Atype_ESCxxx_X             (OPERANDSTRUCT*,  U8*, int*);

/************************ Local Variable Definition ************************/

/*** Format tables ***/
LOCAL FORMATSTRUCT FormatAAA[] = {
   NONE,          NONE,          NONE,          Atype_X
};
LOCAL FORMATSTRUCT FormatADC[] = {
   REG8,          REG8,          NONE,          Atype_Xdw_modregrm,
   REG16,         REG16,         NONE,          Atype_Xdw_modregrm,
   REG8,          MEM,           NONE,          Atype_Xdw_modregrm,
   REG8,          MEMBYTE,       NONE,          Atype_Xdw_modregrm,
   REG16,         MEM,           NONE,          Atype_Xdw_modregrm,
   REG16,         MEMWORD,       NONE,          Atype_Xdw_modregrm,
   MEM,           REG8,          NONE,          Atype_Xdw_modregrm,
   MEMBYTE,       REG8,          NONE,          Atype_Xdw_modregrm,
   MEM,           REG16,         NONE,          Atype_Xdw_modregrm,
   MEMWORD,       REG16,         NONE,          Atype_Xdw_modregrm,
   AL,            DATA8,         NONE,          Atype_Xw_data,
   AX,            DATA,          NONE,          Atype_Xw_data,
   REG8,          DATA8,         NONE,          Atype_Xsw_modXrm_data,
   REG16,         DATA,          NONE,          Atype_Xsw_modXrm_data,
   MEMBYTE,       DATA8,         NONE,          Atype_Xsw_modXrm_data,
   MEMWORD,       DATA,          NONE,          Atype_Xsw_modXrm_data,
   MEM,           DATA,          NONE,          Atype_Xsw_modXrm_data
};
LOCAL FORMATSTRUCT FormatBOUND[] = {
   REG16,         MEM,           NONE,          Atype_X_modregrm,
};
LOCAL FORMATSTRUCT FormatCALL[] = {
   DATA,          NONE,          NONE,          Atype_X_ldisp_hdisp,
   REG16,         NONE,          NONE,          Atype_X_modXrm,
   MEM,           NONE,          NONE,          Atype_X_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_X_modXrm,
   MEMNEAR,       NONE,          NONE,          Atype_X_modXrm,
   MEMFAR,        NONE,          NONE,          Atype_X_modXrm_FAR,
   MEMDWORD,      NONE,          NONE,          Atype_X_modXrm_FAR,
   SEGOFFSET,     NONE,          NONE,          Atype_X_loff_hoff_lseg_hseg
};
LOCAL FORMATSTRUCT FormatDEC[] = {
   REG16,         NONE,          NONE,          Atype_Xreg,
   REG8,          NONE,          NONE,          Atype_Xw_modXrm,
   MEMBYTE,       NONE,          NONE,          Atype_Xw_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_Xw_modXrm,
   MEM,           NONE,          NONE,          Atype_Xw_modXrm
};
LOCAL FORMATSTRUCT FormatDIV[] = {
   REG8,          NONE,          NONE,          Atype_Xw_modXrm,
   REG16,         NONE,          NONE,          Atype_Xw_modXrm,
   MEMBYTE,       NONE,          NONE,          Atype_Xw_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_Xw_modXrm,
   MEM,           NONE,          NONE,          Atype_Xw_modXrm
};
LOCAL FORMATSTRUCT FormatENTER[] = {
   DATA,          DATA8,         NONE,          Atype_X_ldata_hdata_data
};
LOCAL FORMATSTRUCT FormatESC[] = {
   DATA8,         REG8,          NONE,          Atype_ESCxxx_modXrm,
   DATA8,         REG16,         NONE,          Atype_ESCxxx_modXrm,
   DATA8,         MEM,           NONE,          Atype_ESCxxx_modXrm
};
LOCAL FORMATSTRUCT FormatF2XM1[] = {
   NONE,          NONE,          NONE,          Atype_ESCxxx_X
};
LOCAL FORMATSTRUCT FormatFADD[] = {
   MEMDWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   MEMQWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   STI,           ST,            NONE,          Atype_ESCdxx_11xxxrm,
   ST,            STI,           NONE,          Atype_ESCdxx_11xxxrm
};
LOCAL FORMATSTRUCT FormatFADDP[] = {
   STI,           ST,            NONE,          Atype_ESCdxx_11xxxrm
};
LOCAL FORMATSTRUCT FormatFBLD[] = {
   MEMTBYTE,      NONE,          NONE,          Atype_ESCxtx_modXrm
};
LOCAL FORMATSTRUCT FormatFCOM[] = {
   MEMDWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   MEMQWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   STI,           NONE,          NONE,          Atype_ESCxxx_110xxrm
};
LOCAL FORMATSTRUCT FormatFDIV[] = {
   MEMDWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   MEMQWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   STI,           ST,            NONE,          Atype_ESCdxx_11xxdrm,
   ST,            STI,           NONE,          Atype_ESCdxx_11xxdrm
};
LOCAL FORMATSTRUCT FormatFDIVR[] = {
   MEMDWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   MEMQWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   STI,           ST,            NONE,          Atype_ESCdxx_11xxsrm,
   ST,            STI,           NONE,          Atype_ESCdxx_11xxsrm
};
LOCAL FORMATSTRUCT FormatFFREE[] = {
   STI,           NONE,          NONE,          Atype_ESCxxx_110xxrm
};
LOCAL FORMATSTRUCT FormatFIADD[] = {
   MEMWORD,       NONE,          NONE,          Atype_ESCwxx_modXrm,
   MEMDWORD,      NONE,          NONE,          Atype_ESCwxx_modXrm
};
LOCAL FORMATSTRUCT FormatFILD[] = {
   MEMWORD,       NONE,          NONE,          Atype_ESCwxx_modXrm,
   MEMDWORD,      NONE,          NONE,          Atype_ESCwxx_modXrm,
   MEMQWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm
};
LOCAL FORMATSTRUCT FormatFLD[] = {
   MEMDWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   MEMQWORD,      NONE,          NONE,          Atype_ESCqxx_modXrm,
   MEMTBYTE,      NONE,          NONE,          Atype_ESCxtx_modXrm,
   STI,           NONE,          NONE,          Atype_ESCxxx_110xxrm
};
LOCAL FORMATSTRUCT FormatFLDCW[] = {
   MEM,           NONE,          NONE,          Atype_ESCxtx_modXrm
};
LOCAL FORMATSTRUCT FormatIMUL[] = {
   REG8,          NONE,          NONE,          Atype_Xw_modXrm,
   REG16,         NONE,          NONE,          Atype_Xw_modXrm,
   MEMBYTE,       NONE,          NONE,          Atype_Xw_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_Xw_modXrm,
   MEM,           NONE,          NONE,          Atype_Xw_modXrm,
   REG16,         REG16,         DATA,          Atype_Xs1_modregrm_data,
   REG16,         MEM,           DATA,          Atype_Xs1_modregrm_data,
   REG16,         MEMWORD,       DATA,          Atype_Xs1_modregrm_data
};
LOCAL FORMATSTRUCT FormatIN[] = {
   AL,            DX,            NONE,          Atype_Xdw,
   AX,            DX,            NONE,          Atype_Xdw,
   AL,            DATA8,         NONE,          Atype_Xdw_port,
   AX,            DATA8,         NONE,          Atype_Xdw_port
};
LOCAL FORMATSTRUCT FormatINT[] = {
   DATA8,         NONE,          NONE,          Atype_Xv_type
};
LOCAL FORMATSTRUCT FormatJA[] = {
   DATA,          NONE,          NONE,          Atype_X_disp
};
LOCAL FORMATSTRUCT FormatJMP[] = {
   DATA,          NONE,          NONE,          Atype_Xs1_disp,
   REG16,         NONE,          NONE,          Atype_X_modXrm,
   MEM,           NONE,          NONE,          Atype_X_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_X_modXrm,
   MEMNEAR,       NONE,          NONE,          Atype_X_modXrm,
   MEMFAR,        NONE,          NONE,          Atype_X_modXrm_FAR,
   MEMDWORD,      NONE,          NONE,          Atype_X_modXrm_FAR,
   SEGOFFSET,     NONE,          NONE,          Atype_X_loff_hoff_lseg_hseg
};
LOCAL FORMATSTRUCT FormatMOV[] = {
   REG8,          REG8,          NONE,          Atype_Xdw_modregrm,
   REG16,         REG16,         NONE,          Atype_Xdw_modregrm,
   REG8,          MEM,           NONE,          Atype_Xdw_modregrm,
   REG8,          MEMBYTE,       NONE,          Atype_Xdw_modregrm,
   REG16,         MEM,           NONE,          Atype_Xdw_modregrm,
   REG16,         MEMWORD,       NONE,          Atype_Xdw_modregrm,
   MEM,           REG8,          NONE,          Atype_Xdw_modregrm,
   MEMBYTE,       REG8,          NONE,          Atype_Xdw_modregrm,
   MEM,           REG16,         NONE,          Atype_Xdw_modregrm,
   MEMWORD,       REG16,         NONE,          Atype_Xdw_modregrm,
   REG8,          DATA8,         NONE,          Atype_Xwreg_data,
   REG16,         DATA,          NONE,          Atype_Xwreg_data,
   MEMBYTE,       DATA8,         NONE,          Atype_Xw_modXrm_data,
   MEMWORD,       DATA,          NONE,          Atype_Xw_modXrm_data,
   MEM,           DATA,          NONE,          Atype_Xw_modXrm_data,
   AL,            MEMDIRECT,     NONE,          Atype_Xdw_laddr_haddr,
   AL,            MEMDIRECTBYTE, NONE,          Atype_Xdw_laddr_haddr,
   AX,            MEMDIRECT,     NONE,          Atype_Xdw_laddr_haddr,
   AX,            MEMDIRECTWORD, NONE,          Atype_Xdw_laddr_haddr,
   MEMDIRECT,     AL,            NONE,          Atype_Xdw_laddr_haddr,
   MEMDIRECTBYTE, AL,            NONE,          Atype_Xdw_laddr_haddr,
   MEMDIRECT,     AX,            NONE,          Atype_Xdw_laddr_haddr,
   MEMDIRECTWORD, AX,            NONE,          Atype_Xdw_laddr_haddr,
   SEG,           REG16,         NONE,          Atype_Xd0_mod0sgrm,
   SEG,           MEM,           NONE,          Atype_Xd0_mod0sgrm,
   SEG,           MEMWORD,       NONE,          Atype_Xd0_mod0sgrm,
   REG16,         SEG,           NONE,          Atype_Xd0_mod0sgrm,
   MEM,           SEG,           NONE,          Atype_Xd0_mod0sgrm,
   MEMWORD,       SEG,           NONE,          Atype_Xd0_mod0sgrm
};
LOCAL FORMATSTRUCT FormatOUT[] = {
   DX,            AL,            NONE,          Atype_Xdw,
   DX,            AX,            NONE,          Atype_Xdw,
   DATA8,         AL,            NONE,          Atype_Xdw_port,
   DATA8,         AX,            NONE,          Atype_Xdw_port
};
LOCAL FORMATSTRUCT FormatPOP[] = {
   SEG,           NONE,          NONE,          Atype_X0sgX,
   REG16,         NONE,          NONE,          Atype_Xreg,
   MEM,           NONE,          NONE,          Atype_X_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_X_modXrm
};
LOCAL FORMATSTRUCT FormatPUSH[] = {
   SEG,           NONE,          NONE,          Atype_X0sgX,
   REG16,         NONE,          NONE,          Atype_Xreg,
   MEM,           NONE,          NONE,          Atype_X_modXrm,
   MEMWORD,       NONE,          NONE,          Atype_X_modXrm,
   DATA,          NONE,          NONE,          Atype_Xs0_data
};
LOCAL FORMATSTRUCT FormatRCL[] = {
   REG8,          DATAONE,       NONE,          Atype_Xcw_modXrm,
   REG16,         DATAONE,       NONE,          Atype_Xcw_modXrm,
   MEMBYTE,       DATAONE,       NONE,          Atype_Xcw_modXrm,
   MEMWORD,       DATAONE,       NONE,          Atype_Xcw_modXrm,
   MEM,           DATAONE,       NONE,          Atype_Xcw_modXrm,
   REG8,          CL,            NONE,          Atype_Xcw_modXrm,
   REG16,         CL,            NONE,          Atype_Xcw_modXrm,
   MEMBYTE,       CL,            NONE,          Atype_Xcw_modXrm,
   MEMWORD,       CL,            NONE,          Atype_Xcw_modXrm,
   MEM,           CL,            NONE,          Atype_Xcw_modXrm,
   REG8,          DATA8,         NONE,          Atype_Xw_modXrm_count,
   REG16,         DATA8,         NONE,          Atype_Xw_modXrm_count,
   MEMBYTE,       DATA8,         NONE,          Atype_Xw_modXrm_count,
   MEMWORD,       DATA8,         NONE,          Atype_Xw_modXrm_count,
   MEM,           DATA8,         NONE,          Atype_Xw_modXrm_count
};
LOCAL FORMATSTRUCT FormatRET[] = {
   NONE,          NONE,          NONE,          Atype_X,
   DATA,          NONE,          NONE,          Atype_X_ldata_hdata
};
LOCAL FORMATSTRUCT FormatTEST[] = {
   REG8,          REG8,          NONE,          Atype_Xw_modregrm,
   REG16,         REG16,         NONE,          Atype_Xw_modregrm,
   REG8,          MEM,           NONE,          Atype_Xw_modregrm,
   REG8,          MEMBYTE,       NONE,          Atype_Xw_modregrm,
   REG16,         MEM,           NONE,          Atype_Xw_modregrm,
   REG16,         MEMWORD,       NONE,          Atype_Xw_modregrm,
   MEM,           REG8,          NONE,          Atype_Xw_modregrm,
   MEMBYTE,       REG8,          NONE,          Atype_Xw_modregrm,
   MEM,           REG16,         NONE,          Atype_Xw_modregrm,
   MEMWORD,       REG16,         NONE,          Atype_Xw_modregrm,
   AL,            DATA8,         NONE,          Atype_Xw_data,
   AX,            DATA,          NONE,          Atype_Xw_data,
   REG8,          DATA8,         NONE,          Atype_Xw_modXrm_data,
   REG16,         DATA,          NONE,          Atype_Xw_modXrm_data,
   MEMBYTE,       DATA8,         NONE,          Atype_Xw_modXrm_data,
   MEMWORD,       DATA,          NONE,          Atype_Xw_modXrm_data,
   MEM,           DATA,          NONE,          Atype_Xw_modXrm_data
};
LOCAL FORMATSTRUCT FormatXCHG[] = {
   REG16,         AX,            NONE,          Atype_Xreg,
   REG8,          REG8,          NONE,          Atype_Xw_modregrm,
   REG16,         REG16,         NONE,          Atype_Xw_modregrm,
   REG8,          MEM,           NONE,          Atype_Xw_modregrm,
   REG8,          MEMBYTE,       NONE,          Atype_Xw_modregrm,
   REG16,         MEM,           NONE,          Atype_Xw_modregrm,
   REG16,         MEMWORD,       NONE,          Atype_Xw_modregrm,
   MEM,           REG8,          NONE,          Atype_Xw_modregrm,
   MEMBYTE,       REG8,          NONE,          Atype_Xw_modregrm,
   MEM,           REG16,         NONE,          Atype_Xw_modregrm,
   MEMWORD,       REG16,         NONE,          Atype_Xw_modregrm
};

/*** Code tables ***/
LOCAL CODESTRUCT CodeAAA[] = {
   Atype_X,                      0x37, 0x00
};
LOCAL CODESTRUCT CodeAAD[] = {
   Atype_X,                      0xD5, 0x0A
};
LOCAL CODESTRUCT CodeAAM[] = {
   Atype_X,                      0xD4, 0x0A
};
LOCAL CODESTRUCT CodeAAS[] = {
   Atype_X,                      0x3F, 0x00
};
LOCAL CODESTRUCT CodeADC[] = {
   Atype_Xdw_modregrm,           0x10, 0x00,
   Atype_Xw_data,                0x14, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x10
};
LOCAL CODESTRUCT CodeADD[] = {
   Atype_Xdw_modregrm,           0x00, 0x00,
   Atype_Xw_data,                0x04, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x00
};
LOCAL CODESTRUCT CodeAND[] = {
   Atype_Xdw_modregrm,           0x20, 0x00,
   Atype_Xw_data,                0x24, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x20
};
LOCAL CODESTRUCT CodeBOUND[] = {
   Atype_X_modregrm,             0x62, 0x00
};
LOCAL CODESTRUCT CodeCALL[] = {
   Atype_X_ldisp_hdisp,          0xE8, 0X00,
   Atype_X_modXrm,               0xFF, 0x10,
   Atype_X_modXrm_FAR,           0xFF, 0x18,
   Atype_X_loff_hoff_lseg_hseg,  0x9A, 0x00
};
LOCAL CODESTRUCT CodeCBW[] = {
   Atype_X,                      0x98, 0x00
};
LOCAL CODESTRUCT CodeCLC[] = {
   Atype_X,                      0xF8, 0x00
};
LOCAL CODESTRUCT CodeCLD[] = {
   Atype_X,                      0xFC, 0x00
};
LOCAL CODESTRUCT CodeCLI[] = {
   Atype_X,                      0xFA, 0x00
};
LOCAL CODESTRUCT CodeCMC[] = {
   Atype_X,                      0xF5, 0x00
};
LOCAL CODESTRUCT CodeCMP[] = {
   Atype_Xdw_modregrm,           0x38, 0x00,
   Atype_Xw_data,                0x3C, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x38
};
LOCAL CODESTRUCT CodeCMPSB[] = {
   Atype_X,                      0xA6, 0x00
};
LOCAL CODESTRUCT CodeCMPSW[] = {
   Atype_X,                      0xA7, 0x00
};
LOCAL CODESTRUCT CodeCWD[] = {
   Atype_X,                      0x99, 0x00
};
LOCAL CODESTRUCT CodeDAA[] = {
   Atype_X,                      0x27, 0x00
};
LOCAL CODESTRUCT CodeDAS[] = {
   Atype_X,                      0x2F, 0x00
};
LOCAL CODESTRUCT CodeDEC[] = {
   Atype_Xreg,                   0x48, 0x00,
   Atype_Xw_modXrm,              0xFE, 0x08
};
LOCAL CODESTRUCT CodeDIV[] = {
   Atype_Xw_modXrm,              0xF6, 0x30
};
LOCAL CODESTRUCT CodeENTER[] = {
   Atype_X_ldata_hdata_data,     0xC8, 0x00
};
LOCAL CODESTRUCT CodeESC[] = {
   Atype_ESCxxx_modXrm,          0xD8, 0x00
};
LOCAL CODESTRUCT CodeF2XM1[] = {
   Atype_ESCxxx_X,               0xD9, 0xF0
};
LOCAL CODESTRUCT CodeFABS[] = {
   Atype_ESCxxx_X,               0xD9, 0xE1
};
LOCAL CODESTRUCT CodeFADD[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x00,
   Atype_ESCdxx_11xxxrm,         0xD8, 0xC0
};
LOCAL CODESTRUCT CodeFADDP[] = {
   Atype_ESCdxx_11xxxrm,         0xDE, 0xC0
};
LOCAL CODESTRUCT CodeFBLD[] = {
   Atype_ESCxtx_modXrm,          0xDF, 0x20
};
LOCAL CODESTRUCT CodeFBSTP[] = {
   Atype_ESCxtx_modXrm,          0xDF, 0x30
};
LOCAL CODESTRUCT CodeFCHS[] = {
   Atype_ESCxxx_X,               0xD9, 0xE0
};
LOCAL CODESTRUCT CodeFCLEX[] = {
   Atype_ESCxxx_X,               0xDB, 0xE2
};
LOCAL CODESTRUCT CodeFCOM[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x10,
   Atype_ESCxxx_110xxrm,         0xD8, 0xD0
};
LOCAL CODESTRUCT CodeFCOMP[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x18,
   Atype_ESCxxx_110xxrm,         0xD8, 0xD8
};
LOCAL CODESTRUCT CodeFCOMPP[] = {
   Atype_ESCxxx_X,               0xDE, 0xD9
};
LOCAL CODESTRUCT CodeFDECSTP[] = {
   Atype_ESCxxx_X,               0xD9, 0xF6
};
LOCAL CODESTRUCT CodeFDISI[] = {
   Atype_ESCxxx_X,               0xDB, 0xE1
};
LOCAL CODESTRUCT CodeFDIV[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x30,
   Atype_ESCdxx_11xxdrm,         0xD8, 0xF0
};
LOCAL CODESTRUCT CodeFDIVP[] = {
   Atype_ESCdxx_11xxxrm,         0xDE, 0xF8
};
LOCAL CODESTRUCT CodeFDIVR[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x38,
   Atype_ESCdxx_11xxsrm,         0xD8, 0xF0
};
LOCAL CODESTRUCT CodeFDIVRP[] = {
   Atype_ESCdxx_11xxxrm,         0xDE, 0xF0
};
LOCAL CODESTRUCT CodeFENI[] = {
   Atype_ESCxxx_X,               0xDB, 0xE0
};
LOCAL CODESTRUCT CodeFFREE[] = {
   Atype_ESCxxx_110xxrm,         0xDD, 0xC0
};
LOCAL CODESTRUCT CodeFIADD[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x00
};
LOCAL CODESTRUCT CodeFICOM[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x10
};
LOCAL CODESTRUCT CodeFICOMP[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x18
};
LOCAL CODESTRUCT CodeFIDIV[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x30
};
LOCAL CODESTRUCT CodeFIDIVR[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x38
};
LOCAL CODESTRUCT CodeFILD[] = {
   Atype_ESCwxx_modXrm,          0xDB, 0x00,
   Atype_ESCqxx_modXrm,          0xDF, 0x28
};
LOCAL CODESTRUCT CodeFIMUL[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x08
};
LOCAL CODESTRUCT CodeFINCSTP[] = {
   Atype_ESCxxx_X,               0xD9, 0xF7
};
LOCAL CODESTRUCT CodeFINIT[] = {
   Atype_ESCxxx_X,               0xDB, 0xE3
};
LOCAL CODESTRUCT CodeFIST[] = {
   Atype_ESCwxx_modXrm,          0xDB, 0x10
};
LOCAL CODESTRUCT CodeFISTP[] = {
   Atype_ESCwxx_modXrm,          0xDB, 0x18,
   Atype_ESCqxx_modXrm,          0xDF, 0x38
};
LOCAL CODESTRUCT CodeFISUB[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x20
};
LOCAL CODESTRUCT CodeFISUBR[] = {
   Atype_ESCwxx_modXrm,          0xDA, 0x28
};
LOCAL CODESTRUCT CodeFLD[] = {
   Atype_ESCqxx_modXrm,          0xD9, 0x00,
   Atype_ESCxtx_modXrm,          0xDB, 0x28,
   Atype_ESCxxx_110xxrm,         0xD9, 0xC0
};
LOCAL CODESTRUCT CodeFLD1[] = {
   Atype_ESCxxx_X,               0xD9, 0xE8
};
LOCAL CODESTRUCT CodeFLDCW[] = {
   Atype_ESCxtx_modXrm,          0xD9, 0x28
};
LOCAL CODESTRUCT CodeFLDENV[] = {
   Atype_ESCxtx_modXrm,          0xD9, 0x20
};
LOCAL CODESTRUCT CodeFLDL2E[] = {
   Atype_ESCxxx_X,               0xD9, 0xEA
};
LOCAL CODESTRUCT CodeFLDL2T[] = {
   Atype_ESCxxx_X,               0xD9, 0xE9
};
LOCAL CODESTRUCT CodeFLDLG2[] = {
   Atype_ESCxxx_X,               0xD9, 0xEC
};
LOCAL CODESTRUCT CodeFLDLN2[] = {
   Atype_ESCxxx_X,               0xD9, 0xED
};
LOCAL CODESTRUCT CodeFLDPI[] = {
   Atype_ESCxxx_X,               0xD9, 0xEB
};
LOCAL CODESTRUCT CodeFLDZ[] = {
   Atype_ESCxxx_X,               0xD9, 0xEE
};
LOCAL CODESTRUCT CodeFMUL[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x08,
   Atype_ESCdxx_11xxxrm,         0xD8, 0xC8
};
LOCAL CODESTRUCT CodeFMULP[] = {
   Atype_ESCdxx_11xxxrm,         0xDE, 0xC8
};
LOCAL CODESTRUCT CodeFNOP[] = {
   Atype_ESCxxx_X,               0xD9, 0xD0
};
LOCAL CODESTRUCT CodeFPATAN[] = {
   Atype_ESCxxx_X,               0xD9, 0xF3
};
LOCAL CODESTRUCT CodeFPREM[] = {
   Atype_ESCxxx_X,               0xD9, 0xF8
};
LOCAL CODESTRUCT CodeFPTAN[] = {
   Atype_ESCxxx_X,               0xD9, 0xF2
};
LOCAL CODESTRUCT CodeFRNDINT[] = {
   Atype_ESCxxx_X,               0xD9, 0xFC
};
LOCAL CODESTRUCT CodeFRSTOR[] = {
   Atype_ESCxtx_modXrm,          0xDD, 0x20
};
LOCAL CODESTRUCT CodeFSAVE[] = {
   Atype_ESCxtx_modXrm,          0xDD, 0x30
};
LOCAL CODESTRUCT CodeFSCALE[] = {
   Atype_ESCxxx_X,               0xD9, 0xFD
};
LOCAL CODESTRUCT CodeFSQRT[] = {
   Atype_ESCxxx_X,               0xD9, 0xFA
};
LOCAL CODESTRUCT CodeFST[] = {
   Atype_ESCqxx_modXrm,          0xD9, 0x10,
   Atype_ESCxxx_110xxrm,         0xDD, 0xD0
};
LOCAL CODESTRUCT CodeFSTCW[] = {
   Atype_ESCxtx_modXrm,          0xD9, 0x38
};
LOCAL CODESTRUCT CodeFSTENV[] = {
   Atype_ESCxtx_modXrm,          0xD9, 0x30
};
LOCAL CODESTRUCT CodeFSTP[] = {
   Atype_ESCqxx_modXrm,          0xD9, 0x18,
   Atype_ESCxtx_modXrm,          0xDB, 0x38,
   Atype_ESCxxx_110xxrm,         0xDD, 0xD8
};
LOCAL CODESTRUCT CodeFSTSW[] = {
   Atype_ESCxtx_modXrm,          0xDD, 0x38
};
LOCAL CODESTRUCT CodeFSUB[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x20,
   Atype_ESCdxx_11xxdrm,         0xD8, 0xE0
};
LOCAL CODESTRUCT CodeFSUBP[] = {
   Atype_ESCdxx_11xxxrm,         0xDE, 0xE8
};
LOCAL CODESTRUCT CodeFSUBR[] = {
   Atype_ESCqxx_modXrm,          0xD8, 0x28,
   Atype_ESCdxx_11xxsrm,         0xD8, 0xE0
};
LOCAL CODESTRUCT CodeFSUBRP[] = {
   Atype_ESCdxx_11xxxrm,         0xDE, 0xE0
};
LOCAL CODESTRUCT CodeFTST[] = {
   Atype_ESCxxx_X,               0xD9, 0xE4
};
LOCAL CODESTRUCT CodeFWAIT[] = {
   Atype_X,                      0x9B, 0x00
};
LOCAL CODESTRUCT CodeFXAM[] = {
   Atype_ESCxxx_X,               0xD9, 0xE5
};
LOCAL CODESTRUCT CodeFXCH[] = {
   Atype_ESCxxx_110xxrm,         0xD9, 0xC8
};
LOCAL CODESTRUCT CodeFXTRACT[] = {
   Atype_ESCxxx_X,               0xD9, 0xF4
};
LOCAL CODESTRUCT CodeFYL2X[] = {
   Atype_ESCxxx_X,               0xD9, 0xF1
};
LOCAL CODESTRUCT CodeFYL2XP1[] = {
   Atype_ESCxxx_X,               0xD9, 0xF9
};
LOCAL CODESTRUCT CodeHLT[] = {
   Atype_X,                      0xF4, 0x00
};
LOCAL CODESTRUCT CodeIDIV[] = {
   Atype_Xw_modXrm,              0xF6, 0x38
};
LOCAL CODESTRUCT CodeIMUL[] = {
   Atype_Xw_modXrm,              0xF6, 0x28,
   Atype_Xs1_modregrm_data,      0x69, 0x00
};
LOCAL CODESTRUCT CodeIN[] = {
   Atype_Xdw,                    0xEC, 0x00,
   Atype_Xdw_port,               0xE4, 0x00
};
LOCAL CODESTRUCT CodeINC[] = {
   Atype_Xreg,                   0x40, 0x00,
   Atype_Xw_modXrm,              0xFE, 0x00
};
LOCAL CODESTRUCT CodeINSB[] = {
   Atype_X,                      0x6C, 0x00
};
LOCAL CODESTRUCT CodeINSW[] = {
   Atype_X,                      0x6D, 0x00
};
LOCAL CODESTRUCT CodeINT[] = {
   Atype_Xv_type,                0xCC, 0x00
};
LOCAL CODESTRUCT CodeINTO[] = {
   Atype_X,                      0xCE, 0x00
};
LOCAL CODESTRUCT CodeIRET[] = {
   Atype_X,                      0xCF, 0x00
};
LOCAL CODESTRUCT CodeJA[] = {
   Atype_X_disp,                 0x77, 0x00
};
LOCAL CODESTRUCT CodeJAE[] = {
   Atype_X_disp,                 0x73, 0x00
};
LOCAL CODESTRUCT CodeJB[] = {
   Atype_X_disp,                 0x72, 0x00
};
LOCAL CODESTRUCT CodeJBE[] = {
   Atype_X_disp,                 0x76, 0x00
};
LOCAL CODESTRUCT CodeJCXZ[] = {
   Atype_X_disp,                 0xE3, 0x00
};
LOCAL CODESTRUCT CodeJE[] = {
   Atype_X_disp,                 0x74, 0x00
};
LOCAL CODESTRUCT CodeJG[] = {
   Atype_X_disp,                 0x7F, 0x00
};
LOCAL CODESTRUCT CodeJGE[] = {
   Atype_X_disp,                 0x7D, 0x00
};
LOCAL CODESTRUCT CodeJL[] = {
   Atype_X_disp,                 0x7C, 0x00
};
LOCAL CODESTRUCT CodeJLE[] = {
   Atype_X_disp,                 0x7E, 0x00
};
LOCAL CODESTRUCT CodeJMP[] = {
   Atype_Xs1_disp,               0xE9, 0X00,
   Atype_X_modXrm,               0xFF, 0x20,
   Atype_X_modXrm_FAR,           0xFF, 0x28,
   Atype_X_loff_hoff_lseg_hseg,  0xEA, 0x00
};
LOCAL CODESTRUCT CodeJNE[] = {
   Atype_X_disp,                 0x75, 0x00
};
LOCAL CODESTRUCT CodeJNO[] = {
   Atype_X_disp,                 0x71, 0x00
};
LOCAL CODESTRUCT CodeJNP[] = {
   Atype_X_disp,                 0x7B, 0x00
};
LOCAL CODESTRUCT CodeJNS[] = {
   Atype_X_disp,                 0x79, 0x00
};
LOCAL CODESTRUCT CodeJO[] = {
   Atype_X_disp,                 0x70, 0x00
};
LOCAL CODESTRUCT CodeJP[] = {
   Atype_X_disp,                 0x7A, 0x00
};
LOCAL CODESTRUCT CodeJS[] = {
   Atype_X_disp,                 0x78, 0x00
};
LOCAL CODESTRUCT CodeLAHF[] = {
   Atype_X,                      0x9F, 0x00
};
LOCAL CODESTRUCT CodeLDS[] = {
   Atype_X_modregrm,             0xC5, 0x00
};
LOCAL CODESTRUCT CodeLEA[] = {
   Atype_X_modregrm,             0x8D, 0x00
};
LOCAL CODESTRUCT CodeLEAVE[] = {
   Atype_X,                      0xC9, 0x00
};
LOCAL CODESTRUCT CodeLES[] = {
   Atype_X_modregrm,             0xC4, 0x00
};
LOCAL CODESTRUCT CodeLOCK[] = {
   Atype_X,                      0xF0, 0x00
};
LOCAL CODESTRUCT CodeLODSB[] = {
   Atype_X,                      0xAC, 0x00
};
LOCAL CODESTRUCT CodeLODSW[] = {
   Atype_X,                      0xAD, 0x00
};
LOCAL CODESTRUCT CodeLOOP[] = {
   Atype_X_disp,                 0xE2, 0x00
};
LOCAL CODESTRUCT CodeLOOPE[] = {
   Atype_X_disp,                 0xE1, 0x00
};
LOCAL CODESTRUCT CodeLOOPNE[] = {
   Atype_X_disp,                 0xE0, 0x00
};
LOCAL CODESTRUCT CodeMOV[] = {
   Atype_Xdw_modregrm,           0x88, 0x00,
   Atype_Xwreg_data,             0xB0, 0x00,
   Atype_Xw_modXrm_data,         0xC6, 0x00,
   Atype_Xdw_laddr_haddr,        0xA0, 0x00,
   Atype_Xd0_mod0sgrm,           0x8C, 0x00
};
LOCAL CODESTRUCT CodeMOVSB[] = {
   Atype_X,                      0xA4, 0x00
};
LOCAL CODESTRUCT CodeMOVSW[] = {
   Atype_X,                      0xA5, 0x00
};
LOCAL CODESTRUCT CodeMUL[] = {
   Atype_Xw_modXrm,              0xF6, 0x20
};
LOCAL CODESTRUCT CodeNEG[] = {
   Atype_Xw_modXrm,              0xF6, 0x18
};
LOCAL CODESTRUCT CodeNOP[] = {
   Atype_X,                      0x90, 0x00
};
LOCAL CODESTRUCT CodeNOT[] = {
   Atype_Xw_modXrm,              0xF6, 0x10
};
LOCAL CODESTRUCT CodeOR[] = {
   Atype_Xdw_modregrm,           0x08, 0x00,
   Atype_Xw_data,                0x0C, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x08
};
LOCAL CODESTRUCT CodeOUT[] = {
   Atype_Xdw,                    0xEE, 0x00,
   Atype_Xdw_port,               0xE6, 0x00
};
LOCAL CODESTRUCT CodeOUTSB[] = {
   Atype_X,                      0x6E, 0x00
};
LOCAL CODESTRUCT CodeOUTSW[] = {
   Atype_X,                      0x6F, 0x00
};
LOCAL CODESTRUCT CodePOP[] = {
   Atype_X0sgX,                  0x07, 0x00,
   Atype_Xreg,                   0x58, 0x00,
   Atype_X_modXrm,               0x8F, 0x00
};
LOCAL CODESTRUCT CodePOPA[] = {
   Atype_X,                      0x61, 0x00
};
LOCAL CODESTRUCT CodePOPF[] = {
   Atype_X,                      0x9D, 0x00
};
LOCAL CODESTRUCT CodePUSH[] = {
   Atype_X0sgX,                  0x06, 0x00,
   Atype_Xreg,                   0x50, 0x00,
   Atype_X_modXrm,               0xFF, 0x30,
   Atype_Xs0_data,               0x68, 0x00
};
LOCAL CODESTRUCT CodePUSHA[] = {
   Atype_X,                      0x60, 0x00
};
LOCAL CODESTRUCT CodePUSHF[] = {
   Atype_X,                      0x9C, 0x00
};
LOCAL CODESTRUCT CodeRCL[] = {
   Atype_Xcw_modXrm,             0xD0, 0x10,
   Atype_Xw_modXrm_count,        0xC0, 0x10
};
LOCAL CODESTRUCT CodeRCR[] = {
   Atype_Xcw_modXrm,             0xD0, 0x18,
   Atype_Xw_modXrm_count,        0xC0, 0x18
};
LOCAL CODESTRUCT CodeREP[] = {
   Atype_X,                      0xF3, 0x00
};
LOCAL CODESTRUCT CodeREPNE[] = {
   Atype_X,                      0xF2, 0x00
};
LOCAL CODESTRUCT CodeRET[] = {
   Atype_X,                      0xC3, 0x00,
   Atype_X_ldata_hdata,          0xC2, 0x00
};
LOCAL CODESTRUCT CodeRETF[] = {
   Atype_X,                      0xCB, 0x00,
   Atype_X_ldata_hdata,          0xCA, 0x00
};
LOCAL CODESTRUCT CodeROL[] = {
   Atype_Xcw_modXrm,             0xD0, 0x00,
   Atype_Xw_modXrm_count,        0xC0, 0x00
};
LOCAL CODESTRUCT CodeROR[] = {
   Atype_Xcw_modXrm,             0xD0, 0x08,
   Atype_Xw_modXrm_count,        0xC0, 0x08
};
LOCAL CODESTRUCT CodeSAHF[] = {
   Atype_X,                      0x9E, 0x00
};
LOCAL CODESTRUCT CodeSAL[] = {
   Atype_Xcw_modXrm,             0xD0, 0x20,
   Atype_Xw_modXrm_count,        0xC0, 0x20
};
LOCAL CODESTRUCT CodeSAR[] = {
   Atype_Xcw_modXrm,             0xD0, 0x38,
   Atype_Xw_modXrm_count,        0xC0, 0x38
};
LOCAL CODESTRUCT CodeSBB[] = {
   Atype_Xdw_modregrm,           0x18, 0x00,
   Atype_Xw_data,                0x1C, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x18
};
LOCAL CODESTRUCT CodeSCASB[] = {
   Atype_X,                      0xAE, 0x00
};
LOCAL CODESTRUCT CodeSCASW[] = {
   Atype_X,                      0xAF, 0x00
};
LOCAL CODESTRUCT CodeSHR[] = {
   Atype_Xcw_modXrm,             0xD0, 0x28,
   Atype_Xw_modXrm_count,        0xC0, 0x28
};
LOCAL CODESTRUCT CodeSTC[] = {
   Atype_X,                      0xF9, 0x00
};
LOCAL CODESTRUCT CodeSTD[] = {
   Atype_X,                      0xFD, 0x00
};
LOCAL CODESTRUCT CodeSTI[] = {
   Atype_X,                      0xFB, 0x00
};
LOCAL CODESTRUCT CodeSTOSB[] = {
   Atype_X,                      0xAA, 0x00
};
LOCAL CODESTRUCT CodeSTOSW[] = {
   Atype_X,                      0xAB, 0x00
};
LOCAL CODESTRUCT CodeSUB[] = {
   Atype_Xdw_modregrm,           0x28, 0x00,
   Atype_Xw_data,                0x2C, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x28
};
LOCAL CODESTRUCT CodeTEST[] = {
   Atype_Xw_modregrm,            0x84, 0x00,
   Atype_Xw_data,                0xA8, 0x00,
   Atype_Xw_modXrm_data,         0xF6, 0x00
};
LOCAL CODESTRUCT CodeWAIT[] = {
   Atype_X,                      0x9B, 0x00
};
LOCAL CODESTRUCT CodeXCHG[] = {
   Atype_Xreg,                   0x90, 0x00,
   Atype_Xw_modregrm,            0x86, 0x00
};
LOCAL CODESTRUCT CodeXLAT[] = {
   Atype_X,                      0xD7, 0x00
};
LOCAL CODESTRUCT CodeXOR[] = {
   Atype_Xdw_modregrm,           0x30, 0x00,
   Atype_Xw_data,                0x34, 0x00,
   Atype_Xsw_modXrm_data,        0x80, 0x30
};

/************* Global Variable Definition for Related Modules **************/

/*                    Assembler Table                  */
/* Records must be sorted using mnemonic symbol as key */

GLOBAL ASMSTRUCT AsmTable[] = {
"AAA",     CodeAAA,     COUNT(CodeAAA),     FormatAAA,   COUNT(FormatAAA),
"AAD",     CodeAAD,     COUNT(CodeAAD),     FormatAAA,   COUNT(FormatAAA),
"AAM",     CodeAAM,     COUNT(CodeAAM),     FormatAAA,   COUNT(FormatAAA),
"AAS",     CodeAAS,     COUNT(CodeAAS),     FormatAAA,   COUNT(FormatAAA),
"ADC",     CodeADC,     COUNT(CodeADC),     FormatADC,   COUNT(FormatADC),
"ADD",     CodeADD,     COUNT(CodeADD),     FormatADC,   COUNT(FormatADC),
"AND",     CodeAND,     COUNT(CodeAND),     FormatADC,   COUNT(FormatADC),
"BOUND",   CodeBOUND,   COUNT(CodeBOUND),   FormatBOUND, COUNT(FormatBOUND),
"CALL",    CodeCALL,    COUNT(CodeCALL),    FormatCALL,  COUNT(FormatCALL),
"CBW",     CodeCBW,     COUNT(CodeCBW),     FormatAAA,   COUNT(FormatAAA),
"CLC",     CodeCLC,     COUNT(CodeCLC),     FormatAAA,   COUNT(FormatAAA),
"CLD",     CodeCLD,     COUNT(CodeCLD),     FormatAAA,   COUNT(FormatAAA),
"CLI",     CodeCLI,     COUNT(CodeCLI),     FormatAAA,   COUNT(FormatAAA),
"CMC",     CodeCMC,     COUNT(CodeCMC),     FormatAAA,   COUNT(FormatAAA),
"CMP",     CodeCMP,     COUNT(CodeCMP),     FormatADC,   COUNT(FormatADC),
"CMPSB",   CodeCMPSB,   COUNT(CodeCMPSB),   FormatAAA,   COUNT(FormatAAA),
"CMPSW",   CodeCMPSW,   COUNT(CodeCMPSW),   FormatAAA,   COUNT(FormatAAA),
"CWD",     CodeCWD,     COUNT(CodeCWD),     FormatAAA,   COUNT(FormatAAA),
"DAA",     CodeDAA,     COUNT(CodeDAA),     FormatAAA,   COUNT(FormatAAA),
"DAS",     CodeDAS,     COUNT(CodeDAS),     FormatAAA,   COUNT(FormatAAA),
"DEC",     CodeDEC,     COUNT(CodeDEC),     FormatDEC,   COUNT(FormatDEC),
"DIV",     CodeDIV,     COUNT(CodeDIV),     FormatDIV,   COUNT(FormatDIV),
"ENTER",   CodeENTER,   COUNT(CodeENTER),   FormatENTER, COUNT(FormatENTER),
"ESC",     CodeESC,     COUNT(CodeESC),     FormatESC,   COUNT(FormatESC),
"F2XM1",   CodeF2XM1,   COUNT(CodeF2XM1),   FormatF2XM1, COUNT(FormatF2XM1),
"FABS",    CodeFABS,    COUNT(CodeFABS),    FormatF2XM1, COUNT(FormatF2XM1),
"FADD",    CodeFADD,    COUNT(CodeFADD),    FormatFADD,  COUNT(FormatFADD),
"FADDP",   CodeFADDP,   COUNT(CodeFADDP),   FormatFADDP, COUNT(FormatFADDP),
"FBLD",    CodeFBLD,    COUNT(CodeFBLD),    FormatFBLD,  COUNT(FormatFBLD),
"FBSTP",   CodeFBSTP,   COUNT(CodeFBSTP),   FormatFBLD,  COUNT(FormatFBLD),
"FCHS",    CodeFCHS,    COUNT(CodeFCHS),    FormatF2XM1, COUNT(FormatF2XM1),
"FCLEX",   CodeFCLEX,   COUNT(CodeFCLEX),   FormatF2XM1, COUNT(FormatF2XM1),
"FCOM",    CodeFCOM,    COUNT(CodeFCOM),    FormatFCOM,  COUNT(FormatFCOM),
"FCOMP",   CodeFCOMP,   COUNT(CodeFCOMP),   FormatFCOM,  COUNT(FormatFCOM),
"FCOMPP",  CodeFCOMPP,  COUNT(CodeFCOMPP),  FormatF2XM1, COUNT(FormatF2XM1),
"FDECSTP", CodeFDECSTP, COUNT(CodeFDECSTP), FormatF2XM1, COUNT(FormatF2XM1),
"FDISI",   CodeFDISI,   COUNT(CodeFDISI),   FormatF2XM1, COUNT(FormatF2XM1),
"FDIV",    CodeFDIV,    COUNT(CodeFDIV),    FormatFDIV,  COUNT(FormatFDIV),
"FDIVP",   CodeFDIVP,   COUNT(CodeFDIVP),   FormatFADDP, COUNT(FormatFADDP),
"FDIVR",   CodeFDIVR,   COUNT(CodeFDIVR),   FormatFDIVR, COUNT(FormatFDIVR),
"FDIVRP",  CodeFDIVRP,  COUNT(CodeFDIVRP),  FormatFADDP, COUNT(FormatFADDP),
"FENI",    CodeFENI,    COUNT(CodeFENI),    FormatF2XM1, COUNT(FormatF2XM1),
"FFREE",   CodeFFREE,   COUNT(CodeFFREE),   FormatFFREE, COUNT(FormatFFREE),
"FIADD",   CodeFIADD,   COUNT(CodeFIADD),   FormatFIADD, COUNT(FormatFIADD),
"FICOM",   CodeFICOM,   COUNT(CodeFICOM),   FormatFIADD, COUNT(FormatFIADD),
"FICOMP",  CodeFICOMP,  COUNT(CodeFICOMP),  FormatFIADD, COUNT(FormatFIADD),
"FIDIV",   CodeFIDIV,   COUNT(CodeFIDIV),   FormatFIADD, COUNT(FormatFIADD),
"FIDIVR",  CodeFIDIVR,  COUNT(CodeFIDIVR),  FormatFIADD, COUNT(FormatFIADD),
"FILD",    CodeFILD,    COUNT(CodeFILD),    FormatFILD,  COUNT(FormatFILD),
"FIMUL",   CodeFIMUL,   COUNT(CodeFIMUL),   FormatFIADD, COUNT(FormatFIADD),
"FINCSTP", CodeFINCSTP, COUNT(CodeFINCSTP), FormatF2XM1, COUNT(FormatF2XM1),
"FINIT",   CodeFINIT,   COUNT(CodeFINIT),   FormatF2XM1, COUNT(FormatF2XM1),
"FIST",    CodeFIST,    COUNT(CodeFIST),    FormatFIADD, COUNT(FormatFIADD),
"FISTP",   CodeFISTP,   COUNT(CodeFISTP),   FormatFILD,  COUNT(FormatFILD),
"FISUB",   CodeFISUB,   COUNT(CodeFISUB),   FormatFIADD, COUNT(FormatFIADD),
"FISUBR",  CodeFISUBR,  COUNT(CodeFISUBR),  FormatFIADD, COUNT(FormatFIADD),
"FLD",     CodeFLD,     COUNT(CodeFLD),     FormatFLD,   COUNT(FormatFLD),
"FLD1",    CodeFLD1,    COUNT(CodeFLD1),    FormatF2XM1, COUNT(FormatF2XM1),
"FLDCW",   CodeFLDCW,   COUNT(CodeFLDCW),   FormatFLDCW, COUNT(FormatFLDCW),
"FLDENV",  CodeFLDENV,  COUNT(CodeFLDENV),  FormatFLDCW, COUNT(FormatFLDCW),
"FLDL2E",  CodeFLDL2E,  COUNT(CodeFLDL2E),  FormatF2XM1, COUNT(FormatF2XM1),
"FLDL2T",  CodeFLDL2T,  COUNT(CodeFLDL2T),  FormatF2XM1, COUNT(FormatF2XM1),
"FLDLG2",  CodeFLDLG2,  COUNT(CodeFLDLG2),  FormatF2XM1, COUNT(FormatF2XM1),
"FLDLN2",  CodeFLDLN2,  COUNT(CodeFLDLN2),  FormatF2XM1, COUNT(FormatF2XM1),
"FLDPI",   CodeFLDPI,   COUNT(CodeFLDPI),   FormatF2XM1, COUNT(FormatF2XM1),
"FLDZ",    CodeFLDZ,    COUNT(CodeFLDZ),    FormatF2XM1, COUNT(FormatF2XM1),
"FMUL",    CodeFMUL,    COUNT(CodeFMUL),    FormatFADD,  COUNT(FormatFADD),
"FMULP",   CodeFMULP,   COUNT(CodeFMULP),   FormatFADDP, COUNT(FormatFADDP),
"FNOP",    CodeFNOP,    COUNT(CodeFNOP),    FormatF2XM1, COUNT(FormatF2XM1),
"FPATAN",  CodeFPATAN,  COUNT(CodeFPATAN),  FormatF2XM1, COUNT(FormatF2XM1),
"FPREM",   CodeFPREM,   COUNT(CodeFPREM),   FormatF2XM1, COUNT(FormatF2XM1),
"FPTAN",   CodeFPTAN,   COUNT(CodeFPTAN),   FormatF2XM1, COUNT(FormatF2XM1),
"FRNDINT", CodeFRNDINT, COUNT(CodeFRNDINT), FormatF2XM1, COUNT(FormatF2XM1),
"FRSTOR",  CodeFRSTOR,  COUNT(CodeFRSTOR),  FormatFLDCW, COUNT(FormatFLDCW),
"FSAVE",   CodeFSAVE,   COUNT(CodeFSAVE),   FormatFLDCW, COUNT(FormatFLDCW),
"FSCALE",  CodeFSCALE,  COUNT(CodeFSCALE),  FormatF2XM1, COUNT(FormatF2XM1),
"FSQRT",   CodeFSQRT,   COUNT(CodeFSQRT),   FormatF2XM1, COUNT(FormatF2XM1),
"FST",     CodeFST,     COUNT(CodeFST),     FormatFCOM,  COUNT(FormatFCOM),
"FSTCW",   CodeFSTCW,   COUNT(CodeFSTCW),   FormatFLDCW, COUNT(FormatFLDCW),
"FSTENV",  CodeFSTENV,  COUNT(CodeFSTENV),  FormatFLDCW, COUNT(FormatFLDCW),
"FSTP",    CodeFSTP,    COUNT(CodeFSTP),    FormatFLD,   COUNT(FormatFLD),
"FSTSW",   CodeFSTSW,   COUNT(CodeFSTSW),   FormatFLDCW, COUNT(FormatFLDCW),
"FSUB",    CodeFSUB,    COUNT(CodeFSUB),    FormatFDIV,  COUNT(FormatFDIV),
"FSUBP",   CodeFSUBP,   COUNT(CodeFSUBP),   FormatFADDP, COUNT(FormatFADDP),
"FSUBR",   CodeFSUBR,   COUNT(CodeFSUBR),   FormatFDIVR, COUNT(FormatFDIVR),
"FSUBRP",  CodeFSUBRP,  COUNT(CodeFSUBRP),  FormatFADDP, COUNT(FormatFADDP),
"FTST",    CodeFTST,    COUNT(CodeFTST),    FormatF2XM1, COUNT(FormatF2XM1),
"FWAIT",   CodeFWAIT,   COUNT(CodeFWAIT),   FormatAAA,   COUNT(FormatAAA),
"FXAM",    CodeFXAM,    COUNT(CodeFXAM),    FormatF2XM1, COUNT(FormatF2XM1),
"FXCH",    CodeFXCH,    COUNT(CodeFXCH),    FormatFFREE, COUNT(FormatFFREE),
"FXTRACT", CodeFXTRACT, COUNT(CodeFXTRACT), FormatF2XM1, COUNT(FormatF2XM1),
"FYL2X",   CodeFYL2X,   COUNT(CodeFYL2X),   FormatF2XM1, COUNT(FormatF2XM1),
"FYL2XP1", CodeFYL2XP1, COUNT(CodeFYL2XP1), FormatF2XM1, COUNT(FormatF2XM1),
"HLT",     CodeHLT,     COUNT(CodeHLT),     FormatAAA,   COUNT(FormatAAA),
"IDIV",    CodeIDIV,    COUNT(CodeIDIV),    FormatDIV,   COUNT(FormatDIV),
"IMUL",    CodeIMUL,    COUNT(CodeIMUL),    FormatIMUL,  COUNT(FormatIMUL),
"IN",      CodeIN,      COUNT(CodeIN),      FormatIN,    COUNT(FormatIN),
"INC",     CodeINC,     COUNT(CodeINC),     FormatDEC,   COUNT(FormatDEC),
"INSB",    CodeINSB,    COUNT(CodeINSB),    FormatAAA,   COUNT(FormatAAA),
"INSW",    CodeINSW,    COUNT(CodeINSW),    FormatAAA,   COUNT(FormatAAA),
"INT",     CodeINT,     COUNT(CodeINT),     FormatINT,   COUNT(FormatINT),
"INTO",    CodeINTO,    COUNT(CodeINTO),    FormatAAA,   COUNT(FormatAAA),
"IRET",    CodeIRET,    COUNT(CodeIRET),    FormatAAA,   COUNT(FormatAAA),
"JA",      CodeJA,      COUNT(CodeJA),      FormatJA,    COUNT(FormatJA),
"JAE",     CodeJAE,     COUNT(CodeJAE),     FormatJA,    COUNT(FormatJA),
"JB",      CodeJB,      COUNT(CodeJB),      FormatJA,    COUNT(FormatJA),
"JBE",     CodeJBE,     COUNT(CodeJBE),     FormatJA,    COUNT(FormatJA),
"JC",      CodeJB,      COUNT(CodeJB),      FormatJA,    COUNT(FormatJA),
"JCXZ",    CodeJCXZ,    COUNT(CodeJCXZ),    FormatJA,    COUNT(FormatJA),
"JE",      CodeJE,      COUNT(CodeJE),      FormatJA,    COUNT(FormatJA),
"JG",      CodeJG,      COUNT(CodeJG),      FormatJA,    COUNT(FormatJA),
"JGE",     CodeJGE,     COUNT(CodeJGE),     FormatJA,    COUNT(FormatJA),
"JL",      CodeJL,      COUNT(CodeJL),      FormatJA,    COUNT(FormatJA),
"JLE",     CodeJLE,     COUNT(CodeJLE),     FormatJA,    COUNT(FormatJA),
"JMP",     CodeJMP,     COUNT(CodeJMP),     FormatJMP,   COUNT(FormatJMP),
"JNA",     CodeJBE,     COUNT(CodeJBE),     FormatJA,    COUNT(FormatJA),
"JNAE",    CodeJB,      COUNT(CodeJB),      FormatJA,    COUNT(FormatJA),
"JNB",     CodeJAE,     COUNT(CodeJAE),     FormatJA,    COUNT(FormatJA),
"JNBE",    CodeJA,      COUNT(CodeJA),      FormatJA,    COUNT(FormatJA),
"JNC",     CodeJAE,     COUNT(CodeJAE),     FormatJA,    COUNT(FormatJA),
"JNE",     CodeJNE,     COUNT(CodeJNE),     FormatJA,    COUNT(FormatJA),
"JNG",     CodeJLE,     COUNT(CodeJLE),     FormatJA,    COUNT(FormatJA),
"JNGE",    CodeJL,      COUNT(CodeJL),      FormatJA,    COUNT(FormatJA),
"JNL",     CodeJGE,     COUNT(CodeJGE),     FormatJA,    COUNT(FormatJA),
"JNLE",    CodeJG,      COUNT(CodeJG),      FormatJA,    COUNT(FormatJA),
"JNO",     CodeJNO,     COUNT(CodeJNO),     FormatJA,    COUNT(FormatJA),
"JNP",     CodeJNP,     COUNT(CodeJNP),     FormatJA,    COUNT(FormatJA),
"JNS",     CodeJNS,     COUNT(CodeJNS),     FormatJA,    COUNT(FormatJA),
"JNZ",     CodeJNE,     COUNT(CodeJNE),     FormatJA,    COUNT(FormatJA),
"JO",      CodeJO,      COUNT(CodeJO),      FormatJA,    COUNT(FormatJA),
"JP",      CodeJP,      COUNT(CodeJP),      FormatJA,    COUNT(FormatJA),
"JPE",     CodeJP,      COUNT(CodeJP),      FormatJA,    COUNT(FormatJA),
"JPO",     CodeJNP,     COUNT(CodeJNP),     FormatJA,    COUNT(FormatJA),
"JS",      CodeJS,      COUNT(CodeJS),      FormatJA,    COUNT(FormatJA),
"JZ",      CodeJE,      COUNT(CodeJE),      FormatJA,    COUNT(FormatJA),
"LAHF",    CodeLAHF,    COUNT(CodeLAHF),    FormatAAA,   COUNT(FormatAAA),
"LDS",     CodeLDS,     COUNT(CodeLDS),     FormatBOUND, COUNT(FormatBOUND),
"LEA",     CodeLEA,     COUNT(CodeLEA),     FormatBOUND, COUNT(FormatBOUND),
"LEAVE",   CodeLEAVE,   COUNT(CodeLEAVE),   FormatAAA,   COUNT(FormatAAA),
"LES",     CodeLES,     COUNT(CodeLES),     FormatBOUND, COUNT(FormatBOUND),
"LOCK",    CodeLOCK,    COUNT(CodeLOCK),    FormatAAA,   COUNT(FormatAAA),
"LODSB",   CodeLODSB,   COUNT(CodeLODSB),   FormatAAA,   COUNT(FormatAAA),
"LODSW",   CodeLODSW,   COUNT(CodeLODSW),   FormatAAA,   COUNT(FormatAAA),
"LOOP",    CodeLOOP,    COUNT(CodeLOOP),    FormatJA,    COUNT(FormatJA),
"LOOPE",   CodeLOOPE,   COUNT(CodeLOOPE),   FormatJA,    COUNT(FormatJA),
"LOOPNE",  CodeLOOPNE,  COUNT(CodeLOOPNE),  FormatJA,    COUNT(FormatJA),
"LOOPNZ",  CodeLOOPNE,  COUNT(CodeLOOPNE),  FormatJA,    COUNT(FormatJA),
"LOOPZ",   CodeLOOPE,   COUNT(CodeLOOPE),   FormatJA,    COUNT(FormatJA),
"MOV",     CodeMOV,     COUNT(CodeMOV),     FormatMOV,   COUNT(FormatMOV),
"MOVSB",   CodeMOVSB,   COUNT(CodeMOVSB),   FormatAAA,   COUNT(FormatAAA),
"MOVSW",   CodeMOVSW,   COUNT(CodeMOVSW),   FormatAAA,   COUNT(FormatAAA),
"MUL",     CodeMUL,     COUNT(CodeMUL),     FormatDIV,   COUNT(FormatDIV),
"NEG",     CodeNEG,     COUNT(CodeNEG),     FormatDIV,   COUNT(FormatDIV),
"NOP",     CodeNOP,     COUNT(CodeNOP),     FormatAAA,   COUNT(FormatAAA),
"NOT",     CodeNOT,     COUNT(CodeNOT),     FormatDIV,   COUNT(FormatDIV),
"OR",      CodeOR,      COUNT(CodeOR),      FormatADC,   COUNT(FormatADC),
"OUT",     CodeOUT,     COUNT(CodeOUT),     FormatOUT,   COUNT(FormatOUT),
"OUTSB",   CodeOUTSB,   COUNT(CodeOUTSB),   FormatAAA,   COUNT(FormatAAA),
"OUTSW",   CodeOUTSW,   COUNT(CodeOUTSW),   FormatAAA,   COUNT(FormatAAA),
"POP",     CodePOP,     COUNT(CodePOP),     FormatPOP,   COUNT(FormatPOP),
"POPA",    CodePOPA,    COUNT(CodePOPA),    FormatAAA,   COUNT(FormatAAA),
"POPF",    CodePOPF,    COUNT(CodePOPF),    FormatAAA,   COUNT(FormatAAA),
"PUSH",    CodePUSH,    COUNT(CodePUSH),    FormatPUSH,  COUNT(FormatPUSH),
"PUSHA",   CodePUSHA,   COUNT(CodePUSHA),   FormatAAA,   COUNT(FormatAAA),
"PUSHF",   CodePUSHF,   COUNT(CodePUSHF),   FormatAAA,   COUNT(FormatAAA),
"RCL",     CodeRCL,     COUNT(CodeRCL),     FormatRCL,   COUNT(FormatRCL),
"RCR",     CodeRCR,     COUNT(CodeRCR),     FormatRCL,   COUNT(FormatRCL),
"REP",     CodeREP,     COUNT(CodeREP),     FormatAAA,   COUNT(FormatAAA),
"REPE",    CodeREP,     COUNT(CodeREP),     FormatAAA,   COUNT(FormatAAA),
"REPNE",   CodeREPNE,   COUNT(CodeREPNE),   FormatAAA,   COUNT(FormatAAA),
"REPNZ",   CodeREPNE,   COUNT(CodeREPNE),   FormatAAA,   COUNT(FormatAAA),
"REPZ",    CodeREP,     COUNT(CodeREP),     FormatAAA,   COUNT(FormatAAA),
"RET",     CodeRET,     COUNT(CodeRET),     FormatRET,   COUNT(FormatRET),
"RETF",    CodeRETF,    COUNT(CodeRETF),    FormatRET,   COUNT(FormatRET),
"ROL",     CodeROL,     COUNT(CodeROL),     FormatRCL,   COUNT(FormatRCL),
"ROR",     CodeROR,     COUNT(CodeROR),     FormatRCL,   COUNT(FormatRCL),
"SAHF",    CodeSAHF,    COUNT(CodeSAHF),    FormatAAA,   COUNT(FormatAAA),
"SAL",     CodeSAL,     COUNT(CodeSAL),     FormatRCL,   COUNT(FormatRCL),
"SAR",     CodeSAR,     COUNT(CodeSAR),     FormatRCL,   COUNT(FormatRCL),
"SBB",     CodeSBB,     COUNT(CodeSBB),     FormatADC,   COUNT(FormatADC),
"SCASB",   CodeSCASB,   COUNT(CodeSCASB),   FormatAAA,   COUNT(FormatAAA),
"SCASW",   CodeSCASW,   COUNT(CodeSCASW),   FormatAAA,   COUNT(FormatAAA),
"SHL",     CodeSAL,     COUNT(CodeSAL),     FormatRCL,   COUNT(FormatRCL),
"SHR",     CodeSHR,     COUNT(CodeSHR),     FormatRCL,   COUNT(FormatRCL),
"STC",     CodeSTC,     COUNT(CodeSTC),     FormatAAA,   COUNT(FormatAAA),
"STD",     CodeSTD,     COUNT(CodeSTD),     FormatAAA,   COUNT(FormatAAA),
"STI",     CodeSTI,     COUNT(CodeSTI),     FormatAAA,   COUNT(FormatAAA),
"STOSB",   CodeSTOSB,   COUNT(CodeSTOSB),   FormatAAA,   COUNT(FormatAAA),
"STOSW",   CodeSTOSW,   COUNT(CodeSTOSW),   FormatAAA,   COUNT(FormatAAA),
"SUB",     CodeSUB,     COUNT(CodeSUB),     FormatADC,   COUNT(FormatADC),
"TEST",    CodeTEST,    COUNT(CodeTEST),    FormatTEST,  COUNT(FormatTEST),
"WAIT",    CodeWAIT,    COUNT(CodeWAIT),    FormatAAA,   COUNT(FormatAAA),
"XCHG",    CodeXCHG,    COUNT(CodeXCHG),    FormatXCHG,  COUNT(FormatXCHG),
"XLAT",    CodeXLAT,    COUNT(CodeXLAT),    FormatAAA,   COUNT(FormatAAA),
"XOR",     CodeXOR,     COUNT(CodeXOR),     FormatADC,   COUNT(FormatADC),
};

GLOBAL int AsmTableLen = COUNT(AsmTable);

/****************************** End of File ********************************/
