/****************************************************************************
** File name : Cmdline.c  For MICE-III
**
**  Modification:(mainly for 8086F)
**  0. in SUB86.C, in chk_ID(), add MICE value for 8086 MAX and MIN,
**     NEC V20/V30.
**  1. modify CONTROL command:
**     0. in CMDLINE.C, add syntax for 8086Min--69, 8086Max--70,
**        NEC8086Min--71, NEC8086Max--72 and their syntax hints.
**        add arguments in argument table, update ExpandCmd().
**     1. in SYNTAX.C, in CheckSyntax(), add case 69, 70, 71, 72.
**     2. in SYNLIB.C, add global array as follow except *ctlNameEB[] &
**         *ctlNameDefault[]:
**              *ctl8086Min[],    *ctl8086Max[],
**              *ctlNEC8086Min[], *ctlNEC8086[],
**         add global pointer **ctlName, global variable flagTotal;
**         in SyntaxCtrlCmd(), get the content of **ctlName;
**     3. in COMPLEX.C, add "extern **ctlName, flagTotal", add local variable
**         delimiter.
**     4. in SUB86.C, add extern **ctlName & flagTotal. In emuGetControl(),
**         add if (MICE >=11) { ... }, emuSetControl() not changed.
**  2. modify EVENT command:
**     the question is how to deal with EV4 of 8086F. Is to change EXEC_EVENT,
**     or add struct EXEC_EVENT0 as follow:
**        struct { int defined; int runFlag, U32 addr, U16 count };
**     0. abidef.h, add struct EXEC_EVENT0;
**     1. cmdline.c
**        a. struct array cmdRecord[] (only add comments)
**        b. string array *cmdHints[], add "E2"
**        c. struct array cmdArgu[],  fit 25 & add 75 for EV4 and Event
**        d. CheckEventTrig(), add if (MICE >=11) ...;
**        e. ExpandCmd(), change the synIdx of EV4 and Event.
**        f. ShowCmdHints() add if (c=='E' && MICE >=11) hintIdx= "E2"(30)
**     2. syntax.c
**        a. CheckSyntax(), change check synIdx of C_EVENT, add case 25, 75
**        b. update SyntaxEventCmd()
**     3. synlib.c
**        a. add IsExecEvent2()
**     4. complex.c
**        a. add extern EXEC_EVENT0 bp_record0;(declared in exec86.c)
**        b. modify EventCmd();
**        c. modify DisplayExecEvent();
**        d. add to call emuSetBP0() for EV4.
**        e. SaveCmd()
**        f. RecallCmd()
**     5. exec86.c
**        a. emuClrEvent()
**        b. emuClrBP()
**        c. emuSetAllEvents() (this routine may be unused.)
**        d. emuSetBP() modified.
**        e. emuSetBP0();
**
**
**
**    Copyright (C) 1992, 1993 Microtek International, Inc.
**    All Rights Reserved
**
**    Programmed by Chung-Yee Joyce Lin
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "cmdid.h"
#include  "oldext.h"
#include  "basetype.h"
#ifndef _SD_ABI_EXT_
#include  "sdabiext.h"
#endif
#ifndef _SD_ABI_DEF_
#include  "sdabidef.h"
#endif
#ifndef _ABI_FUNC_
#include  "abifunc.h"
#endif
#ifndef _LINUMDEF_
#include "linumdef.h"
#endif

/**************************************************************************
**
** Definitions
**
***************************************************************************/

/******  Define argument Numbers ***********/

enum ARG_IDX {
   A_ALL         = 100,   /* 100  */
   A_AND              ,   /* 101  */
   A_APPEND           ,   /* 102  */
   A_THEN             ,   /* 103  */
   A_ASSEMBLY         ,   /* 104  */
   A_BACKWARD         ,   /* 105  */
   A_BREAK            ,   /* 106  */
   A_BREAKPOINT       ,   /* 107  */
   A_BYTE             ,   /* 108  */
   A_CALL             ,   /* 109  */
   A_CASE             ,   /* 110  */
   A_CENTER           ,   /* 111  */
   A_CLEAR            ,   /* 112  */
   A_CLOSE            ,   /* 113  */
   A_CODE             ,   /* 114  */
   A_COMMAND          ,   /* 115  */
   A_COPROCESSOR      ,   /* 116  */
   A_DATA             ,   /* 117  */
   A_DELAY            ,   /* 118  */
   A_DISABLE          ,   /* 119  */
   A_DRQ              ,   /* 120  */
   A_ENABLE           ,   /* 121  */
   A_EXTERNAL         ,   /* 122  */
   A_OR               ,   /* 123  */
   A_NOT              ,   /* 124  */
   A_FOREVER          ,   /* 125  */
   A_FORWARD          ,   /* 126  */
   A_FROM             ,   /* 127  */
   A_GLOBAL           ,   /* 128  */
   A_GUARD            ,   /* 129  */
   A_HIGH             ,   /* 130  */
   A_HOLD             ,   /* 131  */
   A_INPUT            ,   /* 132  */
   A_INSTRUCTION      ,   /* 133  */
   A_INT              ,   /* 134  */
   A_INTERNAL         ,   /* 135  */
   A_JOURNAL          ,   /* 136  */
   A_LENGTH           ,   /* 137  */
   A_LOG              ,   /* 138  */
   A_LONG             ,   /* 139  */
   A_LOW              ,   /* 140  */
   A_MENU             ,   /* 141  */
   A_MIXED            ,   /* 142  */
   A_MONITOR          ,   /* 143  */
   A_NEXT             ,   /* 144  */
   A_NMI              ,   /* 145  */
   A_NUMBER           ,   /* 146  */
   A_ON               ,   /* 147  */
   A_OFF              ,   /* 148  */
   A_OUTPUT           ,   /* 149  */
   A_OVER             ,   /* 150  */
   A_PEREQ            ,   /* 151  */
   A_REGISTER         ,   /* 152  */
   A_RESET            ,   /* 153  */
   A_RET              ,   /* 154  */
   A_RUN              ,   /* 155  */
   A_SOFTKEY          ,   /* 156  */
   A_SOURCE           ,   /* 157  */
   A_STACK            ,   /* 158  */
   A_SYMBOL           ,   /* 159  */
   A_TILL             ,   /* 160  */
   A_TIMER            ,   /* 161  */
   A_TMON             ,   /* 162  */
   A_TRACE            ,   /* 163  */
   A_TROFF            ,   /* 164  */
   A_TRON             ,   /* 165  */
   A_WAIT             ,   /* 166  */
   A_WINDOW           ,   /* 167  */
   A_WITH             ,   /* 168  */
   A_WORD             ,   /* 169  */
   A_RANGE            ,   /* 170  */
   A_COUNT            ,   /* 171  */
   A_EXTERNAL1        ,   /* 172  */
   A_LIST             ,   /* 173  */
   A_QUEUE            ,   /* 174  */
   A_ENABLE1          ,   /* 175  */
   A_DISABLE1         ,   /* 176  */
   A_INTR             ,   /* 177  */
   A_HLDRQ            ,   /* 178  */
   A_RESET1           ,   /* 179  */
   A_IF               ,   /* 180  */
   A_ELSE             ,   /* 181  */
   A_MODULE 		  ,   /* 182  */
   A_INTEL			  ,   /* 183  */
   A_NEC			  ,   /* 184  */
   A_NATIVE 		  ,   /* 185  */
   A_EMULATION		  ,   /* 186  */
   A_TRACE1 			  /* 187  */
};

/*****************   Other Definitions  *************************/

#define  CNT_NUMBER(arr)   ( sizeof( arr ) / sizeof( arr[0] )  )

#define  CMDERROR     0
#define  EXPANDABLE   1
#define  INEXPANDABLE 2

#define  ERROR          0
#define  CORRECT        1
#define  COMMAND_ERR    5
#define  RE_INPUT       -4
#define  FUNCTION_KEY   -5
#define  LINE_ERR       78
#define  WORD_ERR       79
#define  WORD_ERR220    80      // Chen 05/25/94
#define  MEM_ERR        81      // Chen 05/25/94
#define  ERR_BUF_FULL   82      // Chen 05/25/94
#define  SYNTAX_OK      -1
#define  SHOWHINT       1
#define  SCROLL_UP       2
#define  SCROLL_DOWN     3

/********** Special Key Definitions *********/
#define  ETX    0x03
#define  BS     0x08
#define  CR     0x0d
#define  ESC    0x1b
#define  SP     0x20 /*   */
#define  EXCL   0x21 /* ! */
#define  DQ     0x22 /* " */
#define  SQ     0x27 /* ' */
#define  PS     0x25 /* % */
#define  LP     0x28 /* ( */
#define  RP     0x29 /* ) */
#define  KMA    0x2c /* , */
#define  EQUAL  0x3d /* = */
#define  CURSOR 0x10 /*  */

/**************************************************************************
**
** Externals
**
**************************************************************************/

EXTERN S16 MaskRedrawFlag, noRAM, BreakNumber;
EXTERN U32 RedrawFlag;
EXTERN U16 curLineNum;
EXTERN CURRENT_MODULE curModule;
EXTERN S8  dspMode, langMode;
//EXTERN S8  error_msg[];
EXTERN S16 backLevel;
EXTERN FLAG syntaxErrFlag;
EXTERN FLAG lastPrompted;
extern int COMVPMax;
extern UCHAR isAF8;

extern int nBufFull;    // added by Chen 06/09/94   declared in DISPLAY.C
extern U32 RunStart;    // declared in PROCESS.C, added by Chen 07/08/94
extern int NECflag; 	//Frank 8/25/84, declared in sub86.c

/**************************************************************************
**
** Global  Declarations
**
***************************************************************************/

GLOBAL S16 cmdIdx;                 // command ID
GLOBAL S16 synIdx;                 // syntax type ID
GLOBAL U8 lineBuf[512];            // the buffer for command input line
GLOBAL S8 *cmdFileKeyPtr;
GLOBAL S16 cmdLineArgc;
//GLOBAL S8 cpuMode;        //added by frank, 4/20/1994, for CONTROL
                            //avoid to call GetCpuMode() every time.
int nRelinkMICE = FALSE;    // added by Chen, 07/11/94

/*************************************************************
** Command  Table :                                         **
*************************************************************/

GLOBAL struct cmdStruc {
   const S8 cmdText[12];
   const U8 minValidNo, synType;
} cmdRecord[] = {
 /* 0  : C_ASSEMBLE      */   "assemble",      1,    41,
 /* 1  : C_BACK          */   "back",          2,     0,
 /* 2  : C_BREAKPOINT    */   "breakpoint",    2,    44,
 /* 3  : C_BYTE          */   "byte",          1,    12,
 /* 4  : C_CHECKSUM      */   "checksum",      2,    13,
 /* 5  : C_CLEAR         */   "clear",         2,    27,
 /* 6  : C_CLOCK         */   "clock",         4,     8,
 /* 7  : C_CLOSE         */   "close",         3,     0,
 /* 8  : C_COMPARE       */   "compare",       3,    14,
 /* 9  : C_CONTROL       */   "control",       3,    23,
 /* 10 : C_COPY          */   "copy",          1,    22,
 /* 11 : C_COVERAGE      */   "coverage",      3,    66, //only LAM2 has
 /* 12 : C_CPU			 */   "cpu",           2,    65, //8086 & V20/V30 -->79
 /* 13 : C_CREATE        */   "create",        2,    28,
 /* 14 : C_DELETE        */   "delete",        2,    29,
 /* 15 : C_DISASSEMBLE   */   "disassemble",   1,    15,
 /* 16 : C_DOS           */   "dos",           3,    30,
 /* 17 : C_DOUBLE        */   "double",        3,    53,
 /* 18 : C_DOWNLOAD      */   "download",      2,    31,
 /* 19 : C_DWORD         */   "dword",         2,    53,
 /* 20 : C_EV1           */   "ev1",           3,    76, //1 <--186LAM,  1--8086LAM
 /* 21 : C_EV2           */   "ev2",           3,    76, //52<--186LAM, 52--8086LAM
 /* 22 : C_EV3           */   "ev3",           3,    76, //2 <--186LAM,  2--8086LAM
 /* 23 : C_EV4           */   "ev4",           3,    76, //3 <--186LAM, 25--8086LAM
 /* 24 : C_EV5           */   "ev5",           3,     2, //3 <--186LAM,  3--8086LAM
 /* 25 : C_EV6           */   "ev6",           3,     3, //3 <--186LAM,  3--8086LAM
 /* 26 : C_EV7           */   "ev7",           3,     3, //186LAM NO,    3--8086LAM
 /* 27 : C_EV8           */   "ev8",           3,     3, //186LAM NO, 8086LAM NO
 /* 28 : C_EVENT         */   "event",         1,    42, //74<--186LAM, 75--8086LAM
 /* 29 : C_EXTENSION     */   "extension",     2,    61,
 /* 30 : C_FILL          */   "fill",          1,    16,
 /* 31 : C_FIND          */   "find",          3,    59,
 /* 32 : C_FLOAT         */   "float",         2,    12,
 /* 33 : C_GO            */   "go",            1,     4,
 /* 34 : C_HALT          */   "halt",          2,     0,
 /* 35 : C_HELP          */   "help",          1,     5,
 /* 36 : C_HISTORY       */   "history",       2,     9,
 /* 37 : C_ICE			 */   "ice",           2,    67, //a Powerful command
 /* 38 : C_IDENTIFY      */   "identify",      2,     0,
 /* 39 : C_INCLUDE       */   "include",       3,    32,
 /* 40 : C_INITIALIZE    */   "initialize",    3,    66, //only LAM2 has
 /* 41 : C_INPUT         */   "input",         1,    17,
 /* 42 : C_INTERVAL      */   "interval",      3,     6,
 /* 43 : C_JOURNAL       */   "journal",       2,    33,
 /* 44 : C_JUMP          */   "jump",          1,     7,
 /* 45 : C_LIST          */   "list",          1,    18,
 /* 46 : C_LOAD          */   "load",          3,    31,
 /* 47 : C_LOG           */   "log",           3,    54,
 /* 48 : C_LONG          */   "long",          2,    53,
 /* 49 : C_MAP           */   "map",           2,    24,  //73<--LAM
 /* 50 : C_MEMORY        */   "memory",        1,    15,
 /* 51 : C_MODE          */   "mode",          2,    57,
 /* 52 : C_MODULE        */   "module",        4,     0,
 /* 53 : C_MONITOR       */   "monitor",       3,    40,
 /* 54 : C_NOMONITOR     */   "nomonitor",     1,    27,
 /* 55 : C_OPTIONS       */   "options",       2,    34,
 /* 56 : C_OUTPUT        */   "output",        1,    19,
 /* 57 : C_PATCH         */   "patch",         1,    49,
 /* 58 : C_PATH          */   "path",          4,    62,
 /* 59 : C_QUALIFY       */   "qualify",       3,    68, //63 <-- LAM
 /* 60 : C_QUERY         */   "query",         3,    35,
 /* 61 : C_QUIT          */   "quit",          1,    48,
 /* 62 : C_READY         */   "ready",         3,     8,
 /* 63 : C_RECALL        */   "recall",        3,     0,
 /* 64 : C_REGISTER      */   "register",      1,    26,
 /* 65 : C_RESET         */   "reset",         3,    20,
 /* 66 : C_SAVE          */   "save",          2,     0,
 /* 67 : C_SEARCH        */   "search",        2,    16,
 /* 68 : C_SETUP         */   "setup",         3,     0,
 /* 69 : C_SIZE          */   "size",          2,    21,
 /* 70 : C_SOFTKEY       */   "softkey",       2,    36,
 /* 71 : C_SRECALL       */   "srecall",       2,    31,
 /* 72 : C_SSAVE         */   "ssave",         2,    31,
 /* 73 : C_STEP          */   "step",          1,    43,
 /* 74 : C_SYMBOL        */   "symbol",        3,    37,
 /* 75 : C_SYNC          */   "sync",          2,    10,
 /* 76 : C_TEST          */   "test",          2,    13,
 /* 77 : C_TIMEBASE      */   "timebase",      2,    51,  // Different between LAM and LAM2
 /* 78 : C_TLEVEL        */   "tlevel",        2,    50,   // Only for LAM2
 /* 79 : C_TRIGGER       */   "trigger",       1,    46,  // 11<- LAM
 /* 80 : C_UPDATE        */   "update",        3,    38,
 /* 81 : C_UPLOAD        */   "upload",        1,    31,
 /* 82 : C_URECALL       */   "urecall",       2,    39,
 /* 83 : C_USAVE         */   "usave",         2,    39,
 /* 84 : C_VERIFY        */   "verify",        1,     6,
 /* 85 : C_VIEW          */   "view",          2,    58,
 /* 86 : C_WAIT          */   "wait",          3,    47,
 /* 87 : C_WATCH         */   "watch",         1,    60,
 /* 88 : C_WORD          */   "word",          2,    12,
 /* 89 : C_RESTART       */   "restart",       4,    0,     // Chen 07/08/94
 /* 90 : C_DOSA          */   "dosa",          4,    78     // Chen 07/12/94
};


/**************************************************************************
**
** Local Variables
**
***************************************************************************/

/*************************************************************
** Command  Line Help : Commands Hints  Table               **
*************************************************************/
LOCAL S8 *cmdHints[] = {
 /* A: */ "Assemble",
 /* B: */ "BAck BReakpoint Byte",
 /* C: */ "CHecksum CLear CLOCk CLOse COMpare CONtrol COVerage Copy CPu CReate",
 /* D: */ "DElete Disassemble DOS DOSA DOUble DOwnload DWord",
 /* E: */ "EV1 EV2 EV3 EV4 EV5 EV6 EV7 EV8 Event EXtension",
 /* F: */ "Fill FINd FLoat",
 /* G: */ "Go",
 /* H: */ "HAlt Help HIstory",
 /* I: */ "ICe IDentify INClude INItialize Input INTerval",
 /* J: */ "JOurnal Jump",
 /* K: */ "",
 /* L: */ "List LOAd LOG LOng",
 /* M: */ "MAp Memory MOde MODUle MONitor",
 /* N: */ "Nomonitor",
 /* O: */ "OPtions Output",
 /* P: */ "Patch PATH",
 /* Q: */ "QUAlify QUEry Quit",
 /* R: */ "REAdy RECall Register RESet RESTart",    // add "RESTart" by Chen
 /* S: */ "SAve SEarch SETup SIze SOftkey SRecall SSave Step SYMbol SYnc",
 /* T: */ "TEst TImebase TLevel Trigger",
 /* U: */ "UPDate Upload URecall USave",
 /* V: */ "Verify VIew",
 /* W: */ "WAIt Watch WOrd",
 /* X: */ "",
 /* Y: */ "",
 /* Z: */ "",
 /* for LAM */
 /* 26: */ "CHecksum CLear CLOCk CLOse COMpare CONtrol Copy CPu CReate",
 /* 27: */ "EV1 EV2 EV3 EV4 EV5 EV6 Event EXtension",
 /* 28: */ "ICE IDentify INClude Input INTerval",
 /* 29: */ "TEst TImebase Trigger",
 /* 30: */ "EV1 EV2 EV3 EV4 EV5 EV6 EV7 Event EXtension",
 };


/*************************************************************
** Argument   Table :                                       **
*************************************************************/
LOCAL struct argStruc {
   const S8 argText[12];
   const U8  minValidNo;
}  argRecord[] = {
 /* 100 :  A_ALL         */  "all",         1,
 /* 101 :  A_AND         */  "and",         2,
 /* 102 :  A_APPEND      */  "append",      1,
 /* 103 :  A_THEN        */  "then",        1,
 /* 104 :  A_ASSEMBLY    */  "assembly",    1,
 /* 105 :  A_BACKWARD    */  "backward",    2,
 /* 106 :  A_BREAK       */  "break",       2,
 /* 107 :  A_BREAKPOINT  */  "breakpoint",  1,
 /* 108 :  A_BYTE        */  "byte",        1,
 /* 109 :  A_CALL        */  "call",        1,
 /* 110 :  A_CASE        */  "case",        1,
 /* 111 :  A_CENTER      */  "center",      2,
 /* 112 :  A_CLEAR       */  "clear",       2,
 /* 113 :  A_CLOSE       */  "close",       1,
 /* 114 :  A_CODE        */  "code",        1,
 /* 115 :  A_COMMAND     */  "command",     1,
 /* 116 :  A_COPROCESSOR */  "coprocessor", 1,
 /* 117 :  A_DATA        */  "data",        1,
 /* 118 :  A_DELAY       */  "delay",       2,
 /* 119 :  A_DISABLE     */  "disable",     1,
 /* 120 :  A_DRQ         */  "drq",         2,
 /* 121 :  A_ENABLE      */  "enable",      1,
 /* 122 :  A_EXTERNAL    */  "external",    1,
 /* 123 :  A_OR          */  "or",          1,
 /* 124 :  A_NOT         */  "not",         1,
 /* 125 :  A_FOREVER     */  "forever",     2,
 /* 126 :  A_FORWARD     */  "forward",     2,
 /* 127 :  A_FROM        */  "from",        2,
 /* 128 :  A_GLOBAL      */  "global",      1,
 /* 129 :  A_GUARD       */  "guard",       1,
 /* 130 :  A_HIGH        */  "high",        1,
 /* 131 :  A_HOLD        */  "hold",        1,
 /* 132 :  A_INPUT       */  "input",       1,
 /* 133 :  A_INSTRUCTION */  "instruction", 2,
 /* 134 :  A_INT         */  "int",         1,
 /* 135 :  A_INTERNAL    */  "internal",    1,
 /* 136 :  A_JOURNAL     */  "journal",     1,
 /* 137 :  A_LENGTH      */  "length",      1,
 /* 138 :  A_LOG         */  "log",         1,
 /* 139 :  A_LONG        */  "long",        1,
 /* 140 :  A_LOW         */  "low",         1,
 /* 141 :  A_MENU        */  "menu",        1,
 /* 142 :  A_MIXED       */  "mixed",       2,
 /* 143 :  A_MONITOR     */  "monitor",     1,
 /* 144 :  A_NEXT        */  "next",        1,
 /* 145 :  A_NMI         */  "nmi",         1,
 /* 146 :  A_NUMBER      */  "number",      1,
 /* 147 :  A_ON          */  "on",          1,
 /* 148 :  A_OFF         */  "off",         2,
 /* 149 :  A_OUTPUT      */  "output",      2,
 /* 150 :  A_OVER        */  "over",        1,
 /* 151 :  A_PEREQ       */  "pereq",       1,
 /* 152 :  A_REGISTER    */  "register",    1,
 /* 153 :  A_RESET       */  "reset",       1,
 /* 154 :  A_RET         */  "ret",         1,
 /* 155 :  A_RUN         */  "run",         1,
 /* 156 :  A_SOFTKEY     */  "softkey",     1,
 /* 157 :  A_SOURCE      */  "source",      2,
 /* 158 :  A_STACK       */  "stack",       1,
 /* 159 :  A_SYMBOL      */  "symbol",      1,
 /* 160 :  A_TILL        */  "till",        1,
 /* 161 :  A_TIMER       */  "timer",       2,
 /* 162 :  A_TMON        */  "tmon",        2,
 /* 163 :  A_TRACE       */  "trace",       2,
 /* 164 :  A_TROFF       */  "troff",       4,
 /* 165 :  A_TRON        */  "tron",        2,
 /* 166 :  A_WAIT        */  "wait",        1,
 /* 167 :  A_WINDOW      */  "window",      1,
 /* 168 :  A_WITH        */  "with",        1,
 /* 169 :  A_WORD        */  "word",        1,
 /* 170 :  A_RANGE       */  "range",       2,
 /* 171 :  A_COUNT       */  "count",       2,
 /* 172 :  A_EXTERNAL1   */  "external",    2,
 /* 173 :  A_LIST        */  "list",        1,
 /* 174 :  A_QUEUE       */  "queue",       1,
 /* 175 :  A_ENABLE1     */  "enable",      2,
 /* 176 :  A_DISABLE1    */  "disable",     2,
 /* 177 :  A_INTR        */  "intr",        1,
 /* 178 :  A_HLDRQ       */  "hldrq",       1,
 /* 179 :  A_RESET1      */  "reset",       2,
 /* 180 :  A_IF          */  "if",          1,
 /* 181 :  A_ELSE        */  "else",        2,
 /* 182 :  A_MODULE 	 */  "module",      2,
 /* 183 :  A_INTEL		 */  "intel",       1,
 /* 184 :  A_NEC		 */  "nec",         1,
 /* 185 :  A_NATIVE 	 */  "native",      2,
 /* 186 :  A_EMULATION	 */  "emulation",   1,
 /* 187 :  A_TRACE1 	 */ "trace",        1
};


/***********************************************************
** Command --- Argument Indices Table                     **
***********************************************************/
LOCAL U8 a1[]  = { A_ALL, 0 };
LOCAL U8 a2[]  = { A_CLEAR, 0 };
LOCAL U8 a3[]  = { A_LENGTH, 0 };
LOCAL U8 a4[]  = { A_NUMBER, A_MIXED, A_SOURCE, A_INSTRUCTION,
                   A_MODULE, 0 };
LOCAL U8 a5[]  = { A_RUN, A_FROM, A_TILL, 0 };
LOCAL U8 a6[]  = { A_ALL, A_GLOBAL,0 };
LOCAL U8 a7[]  = { A_APPEND, A_CLOSE, 0 };
LOCAL U8 a8[]  = { A_BYTE, A_WORD, 0 };
LOCAL U8 a9[]  = { A_CLEAR, A_COUNT, 0 };
LOCAL U8 a10[] = { A_EXTERNAL, A_INTERNAL, 0 };
LOCAL U8 a11[] = { A_INTERNAL, A_COPROCESSOR, 0 };
LOCAL U8 a12[] = { A_OFF,A_ON,0 };
LOCAL U8 a13[] = { A_BYTE,A_INPUT,A_LONG,A_WORD,0 };
LOCAL U8 a14[] = { A_HIGH,A_LOW,0 };
LOCAL U8 a15[] = { A_HOLD,A_NMI,A_PEREQ,A_RESET,A_DISABLE,A_ENABLE,0};
LOCAL U8 a16[] = { A_INPUT,A_ON,A_OFF,A_OUTPUT,0 };
LOCAL U8 a17[] = { A_AND,A_BACKWARD, A_RUN, A_CLEAR, A_CENTER,A_DELAY,
                   A_FORWARD,A_OR,A_THEN,0};
LOCAL U8 a18[] = { A_BREAKPOINT,A_CASE,A_JOURNAL,A_LOG,A_OFF,A_ON,A_SYMBOL,0 };
LOCAL U8 a19[] = { A_BREAKPOINT,A_CODE,A_REGISTER,A_STACK,A_TRACE1, A_DATA,
                    A_ON, A_OFF,0 };
LOCAL U8 a20[] = { A_WINDOW, A_SOFTKEY,0 };
LOCAL U8 a21[] = { A_FOREVER, A_OVER, A_TILL, A_RET, A_CALL, 0 };
LOCAL U8 a22[] = { A_BREAK, A_CLEAR, A_RESET, A_NEXT,0 };
LOCAL U8 a23[] = { A_CLEAR, A_WITH, 0 };
LOCAL U8 a24[] = { A_APPEND,A_CLOSE, 0 };
LOCAL U8 a25[] = { A_DISABLE, A_ENABLE, 0 };
LOCAL U8 a26[] = { A_WAIT,0};
LOCAL U8 a27[] = { A_RANGE, A_CLEAR, A_ENABLE1, A_DISABLE1, A_EXTERNAL1,0};
LOCAL U8 a28[] = { A_ASSEMBLY, A_SOURCE, A_MIXED, 0 };
LOCAL U8 a29[] = { A_BACKWARD, A_FORWARD, 0 };
LOCAL U8 a30[] = { A_COMMAND, A_QUEUE,0 };
LOCAL U8 a31[] = { A_CLEAR, A_DISABLE1, A_ENABLE1, A_LIST, A_RESET1, 0 };
LOCAL U8 a32[] = { A_DISABLE, A_ENABLE, A_HOLD, A_INTR, A_NMI, A_RESET, 0 };
LOCAL U8 a33[] = { A_DISABLE, A_ENABLE, A_HLDRQ, A_INT, A_NMI, A_RESET, 0 };
LOCAL U8 a34[] = { A_RUN, A_COUNT, A_CLEAR, 0 };
LOCAL U8 a35[] = { A_RUN, A_IF, A_ELSE, A_THEN, A_RESET1, A_FORWARD,
                   A_BACKWARD, A_CENTER, A_DELAY,A_CLEAR,
                   A_TRACE, A_TIMER, A_ON, A_OFF,0 };
LOCAL U8 a36[] = { A_CLEAR, A_COUNT, A_RANGE, A_EXTERNAL1, 0 };
LOCAL U8 a37[] = { A_TRACE, A_TIMER, A_CLEAR, A_ON, A_OFF,
                   A_OR, A_AND, A_NOT,0};
LOCAL U8 a38[] = { A_INTEL, A_NEC, 0};
/*************************************************************
** Command  Line Help : Argument Hints  Table               **
*************************************************************/
LOCAL struct {
   U8  *argPtr;
   const S8 *argHints;
}  cmdArgu[] = {
 /*   0 */    0, "no argument",
 /*   1 */   a9, "[adx [datum] [status] [COunt cnt]|CLear]",
 /*   2 */  a14, "{High|Low}",
 /*   3 */   a2, "[adr|CLear]",
 /*   4 */   a5, "[@n|[Run] [FRom adr]|[FRom adr] [Till] adr1]",
 /*   5 */    0, "[command_keyword]",
 /*   6 */  a12, "[On|OFf]",
 /*   7 */    0, "adr",
 /*   8 */  a10, "[Internal|External]",
 /*   9 */    0, "[number]",
 /*  10 */  a16, "[{Input|OUtput} {On|OFf}]",
 /*  11 */  a17, "[[Run] ev_seq [BAckward|CEnter|FOrward|DElay count] |CLear]", // only for LAM
 /*  12 */    0, "[adr [data1 [...data16]]]",
 /*  13 */   a3, "adr1 {adr2|Length length}",
 /*  14 */   a3, "adr1 {adr2|Length length} adr3",
 /*  15 */   a3, "[adr1 [adr2|Length length]]",
 /*  16 */   a3, "adr1 {adr2|Length length} data1 [...data16]",
 /*  17 */   a8, "[Byte|Word] port",
 /*  18 */   a4, "[Number|{INstru|MIxed|SOurce|MOdule} [frame]|frame [abs1 abs2] [stat]]",
 /*  19 */   a8, "[Byte|Word] port data",
 /*  20 */    0, "[cs[:ip]]",
 /*  21 */   a8, "[Byte|Word]",
 /*  22 */   a3, "adr1 {adr2|Length length} [adr3]",
 /*  23 */	a15, "[[INT0][INT1][INT2][INT3][Nmi][DRQ0][DRQ1][Reset][Hold][Pereq]{E|D}]",
 /*  24 */    0, "[abs1 abs2 {I|IR|E|ER|G}]",
 /*  25 */  a34, "[[Run] adr [COunt count]|CLear]",
 /*  26 */  a11, "[reg_id [hex_data] |Internal|Coprocessor]",
 /*  27 */    0, "[no1 [no2]]",
 /*  28 */    0, "%symbol hex_address",
 /*  29 */	  0, "%symbol",
 /*  30 */    0, "[dos_command]",
 /*  31 */    0, "filename",
 /*  32 */    0, "filename [(arg0,...,arg9)]",
 /*  33 */   a7, "[filename [Append]|Close]",
 /*  34 */  a18, "[{Symbol|Log|Journal|Breakpoint|Case} {On|OFf}]",
 /*  35 */    0, "[%%module]{%symbol|#line_number} |hex_address",
 /*  36 */    0, "[{K1|K2|K3|K4|K5|K6|K7|K8|K9|K10} \"command_description\"]",
 /*  37 */   a6, "[All|Global|%%module]",
 /*  38 */  a19, "[{Breakpoint|Code|Register|Stack|Trace|Data} {On|OFf}]",
 /*  39 */  a20, "[Window|Softkey]",
 /*  40 */  a13, "[[%%module]%symbol|adr [number] [Byte|Word|Long]]",
 /*  41 */    0, "[adr]",
 /*  42 */   a2, "[1|2|3|4|5|6|7|8|CLear]",
 /*  43 */  a21, "[[Over] [count|FOrever|adr1 adr2]|Till {Ret|Call|{@reg|adr}=value}]",
 /*  44 */    0, "[adr [count]]",
 /*  45 */    0, "[filename]",
 /*  46 */  a35, "[[Run] {level#_seq} [FOrward|BAckward|CEnter|DElay count] |CLear]",
 /*  47 */    0, "[0|1|2|3|4|5]",
 /*  48 */    0, "[Y]",
 /*  49 */  a23, "[adr1 {[adr2] [With adr3 adr4]}|CLear]",
 /*  50 */	a37, "[level# [event_seq [TImer {On|OFf}] [TRace {On|OFf}]|CLear]|CLear]",
 /*  51 */    0, "LAM1 [1|10|100|1000|10000]      LAM2 [0.1|1|10|100|1000]",
 /*  52 */   a2, "[adx [datum] [status]|CLear]",
 /*  53 */    0, "[adr [data1 [data2 [...data8]]]]",
 /*  54 */  a24, "[filename [Append]|Close]",
 /*  55 */	a15, "[[INT0][INT1][INT2][INT3][INT4][Nmi][Reset][Hold][Pereq]{E|D}]", // for Control 186EB
 /*  56 */  a27, " ", // for Control Cmd 186EC
 /*  57 */  a28, "[SOurce|MIxed|Assembly]",
 /*  58 */    0, "[@n|adr|[%%module] [#line_number]]",
 /*  59 */  a29, "[\"string\"] [%%module] [#line_number] [FOrward|BAckward]",
 /*  60 */    0, "[@n][%variable_name]",
 /*  61 */   a2, "[.ext[ .ext[ .ext[ .ext]]]|CLear]",
 /*  62 */   a2, "[path[ path[ path[ path]]]|CLear]",
 /*  63 */   a2, "[CLear|adx [status]]",
 /*  64 */  a26, "[Wait|count]",
 /*  65 */  a30, "[Command|Queue]",
 /*  66 */  a31, "[adr1 adr2[ CLear]|ENable|DIsable|CLear|REset|{I|O|S|R|W}|List [adr]]",
 /*  67 */    0, "ICE_command",
 /*  68 */  a27, "{1|2} {RAnge adr1 adr2|adx}[status]| [1|2][CLear|DIsable|ENable]",
 /*  69 */  a32, "[[Nmi][Reset][Intr][Hold] {Enable|Disable}]",
 /*  70 */  a32, "[[Nmi][Reset][Intr][RQ0][RQ1] {Enable|Disable}]",
 /*  71 */  a33, "[[Nmi][Reset][Int][Hldrq] {Enable|Disable}]",
 /*  72 */  a33, "[[Nmi][Reset][Int][RQ0][RQ1] {Enable|Disable}]",
 /*  73 */	 a1, "[abs1 abs2 {I|IR|E}|All E]",
 /*  74 */   a2, "[1|2|3|4|5|6|CLear]",  //186LAM
 /*  75 */   a2, "[1|2|3|4|5|6|7|CLear]", //8086LAM
 /*  76 */	a36, "[{RAnge abs1 abs2|adx} [datum] [status] [EXt tbits] [COunt cnt]|CLear]",
 /*  77 */    0, "This command doesn't exist in this version ! ",
 /*  78 */	  0, "dos_command",     // added by Chen, 07/12/94
 /*  79 */  a38, "[Intel|Nec]",
 /*  80 */	  0, "[abs1 abs2 {I|IR|ID|E|ER|ED|G}]"
};



/*************************************************************
** Local variable declarations                              **
*************************************************************/
LOCAL S16  argc= 0;
LOCAL S8 argv[90][80], expStr[20], hisBuf[32][512];
LOCAL S16 pHisPtr = 0 ,hisIdx = 0, lHisPtr = 0;

// Chen 05/26/94    ; it must be used in ERROR.C, so change it to GLOBAL
// LOCAL S16 posPtr = 0;
GLOBAL S16 posPtr = 0;


/*************************************************************
**                                                          **
** Private function prototypes                                **
**                                                          **
*************************************************************/
PRIVATE RETCODE ExpandCmd( const S8 *cmdBuf, const FLAG showHint);
PRIVATE RETCODE ExpandArg( const S16 index, const S8 *argBuf, const S16 posPtr );
PRIVATE RETCODE CRPressed( FLAG isHis, S16 posPtr, const FLAG wasIns, const FLAG isSymbol, FLAG isFromKbd );
PRIVATE RETCODE GetLastWord(S8 *aWord, const S16 posPtr ) ;
PRIVATE RETCODE GetCmdSyn( RETCODE *cmdFlag, S16 posPtr, FLAG showHint);
PRIVATE RETCODE CheckEventTrig();
PRIVATE RETCODE AddKeyinToLineBuf( S8 Keyin, S16 *posPtr, FLAG wasIns);
PRIVATE RETCODE AddExpToLineBuf( S8 *expStr, S16 *posPtr, FLAG wasIns );
PRIVATE RETCODE InputParsing(VOID);
PRIVATE VOID BSPressed( FLAG *isDQ, FLAG *isSQ, FLAG *isSymbol, FLAG *isParen, S16 *posPtr);
PRIVATE VOID CheckSpecial( S16 posPtr, FLAG *isSQ, FLAG *isDQ, FLAG *isParen, FLAG *isSymbol);
PUBLIC S8 *StrmnCopy( S8 *dest, const S8 *src, const S16 start, const S16 maxlen );
// PRIVATE VOID ShowCmdHints( const S16 c );
// PRIVATE VOID ShowSyntaxHint( const S16 syntaxNo);
// changed by Chen, 09/03/94
PUBLIC VOID ShowCmdHints( const S16 c );
PUBLIC VOID ShowSyntaxHint( const S16 syntaxNo );


/**************************************************************************
**
** Execution codes ( PUBLIC )
**
***************************************************************************/

/**************************************************************************
**
** Name : InitArray
**
** Function : Initializes an array.
**
**    Input  : Pointer to Array, Size of Array, Initial value.
**    Output : Pointer to Array.
**
**************************************************************************/
PUBLIC VOID InitArray( S8 *ptr, S16 len, S8 value )
{
   S16 i;
   for (i=0; i<len; i++) ptr[i] = value;
} /* end of InitArray */

/**************************************************************************
**
** Name : DisplayPrompt
**
** Function :  At "Go Run" mode, displays "Run>", otherwise displays ">"
**             as line prompt.
**
**    Input  :  none
**    Output :  none
**
**************************************************************************/
PUBLIC VOID DisplayPrompt(FLAG vpFlag)
{
S16 iceStatus;
U8 goEndFlag;
U8 *tmpStr= " SW bkpt is encountered!\r\n";

   VPOut = COMVP;
   iceStatus = emuGetCpuStatus(&goEndFlag);
   switch (iceStatus) {
      case GOOD : // cpu is running
         if (!vpFlag) DisplayStr("Run>");
         else DisplayStrAtViewport("Run>");
         break;
      case CPU_FLY :
         if (!vpFlag) DisplayStr("Fly>");
         else DisplayStrAtViewport("Fly>");
         break;
      case BKPT2_HALT :
         if (!noRAM && BreakNumber && !lastPrompted) {
            emuAbort();
            SimIRET();
            sw_restore();
            emuClrEvent(6+LAM2);
            if (bp_record[1].defined) emuSetBP(LAM2+5, bp_record[1].addr);
            if (wn_isup(VP[REGVP].Ptr)) UpdateREGVP();
            if (wn_isup(VP[CODVP].Ptr)) UpdateCODVP(-1);
            if (!vpFlag) DisplayStr(tmpStr);
            else DisplayStrAtViewport(tmpStr);
            lastPrompted = TRUE;
         }
      case BKPT1_HALT :
      case TRIG_HALT :
         if (!lastPrompted) {
//          sprintf(tmpBuf," %s!\n\r", error_msg[iceStatus]);
//          if (!vpFlag) DisplayStr(tmpBuf);
//          else DisplayStrAtViewport(tmpBuf);
            error_handle(iceStatus);
            lastPrompted = TRUE;
         }
      default :
         if (!vpFlag) DisplayStr(">");
         else DisplayStrAtViewport(">");
   }

} /* end of DisplayPrompt() */

/**************************************************************************
**
** Name : ClearLine
**
** Function : Clears command line on screen.
**
**    Input  : lineBuf, posPtr
**    Output : none
**
** Notes:
**
**************************************************************************/
PUBLIC VOID ClearLine(void)
{
U8 goEndFlag;
S16 lineLen, rr, cc, promptLen, xx, xOrg;
LOCAL S8 *clrLine =   // 77 blank characters.
"                                                                             ";

   VPOut = COMVP;
   save_curs(&rr,&cc);                            // get current cursor position
   lineLen = strlen(lineBuf);
   promptLen = (emuGetCpuStatus(&goEndFlag) == GOOD) ? 4 : 1; // prompt "Run>" 4, ">" 1
   xOrg = rr - (( posPtr + promptLen - cc ) / 78);
   set_cur( xOrg, 0 );
   xx = ( lineLen + promptLen);
   while (xx > 0 ) {
      DisplayStrAtViewport( clrLine );
      xx -= 78;
      if (xx >= 0) DisplayCharAtViewport(0);
      DisplayCMDCURSOR();
   }
   set_cur( xOrg, 0 );
   JournalStr("\\\n\r");
} /* end of ClearLine */

/**************************************************************************
**
** Name : StrmnCopy
**
** Function :  Copies a given number of bytes (maxlen) from one string (src)
**             into another (dest) started from the specified position
**             (start).
**
**    Input  : src, start, maxlen
**    Output : dest
**
** Notes:
**
**************************************************************************/
PUBLIC S8 *StrmnCopy( S8 *dest, const S8 *src, const S16 start, const S16 maxlen )
{
S16 i,j;

   for ( i=0, j=start; i<maxlen ; i++, j++ ) dest[i] = src[j];
   dest[maxlen] = '\0';
   return(dest);

}  /* end of StrmnCopy */

/**************************************************************************
**
** Name : ExecuteCmd
**
** Function : Executes a command line.
**
**    Input  : lineBuf (Global )
**    Output : none
**
** Notes:
**
**************************************************************************/
PUBLIC VOID ExecuteCmd(FLAG isHisCmd)
{
RETCODE check,chkFlag;
U8 *ptr=0;

   chkFlag = GetCmdSyn(  &check, strlen(lineBuf), isHisCmd );
   if (chkFlag < 0 ) return;
   if (chkFlag == WORD_ERR ) {
      prn_ferr(chkFlag);
      return;
   }

// Chen 05/25/94    ; for Softkey keyin more than 80 characters
//
//   if (chkFlag == WORD_ERR220 ) {
//      prn_ferr(chkFlag);
//      return;
//   }

   if (cmdIdx >= 0 || (ptr=strchr(lineBuf,PS)) != NULL) {
      if (!InputParsing()) {
         prn_ferr(COMMAND_ERR);
         return;
      }
      else if (ptr) {
        cmdIdx = C_WATCH;
        synIdx = cmdRecord[ C_WATCH ].synType;
      }
   }
   else {
      prn_ferr(COMMAND_ERR);
      return;
   }
   chkFlag = CheckSyntax(argc, argv);
   cmdLineArgc = argc;
   if (chkFlag == CORRECT) {
     CmdProcess(cmdIdx);
     return;
   }
   if (chkFlag==ERROR) {
      prn_ferr( syntaxErrFlag ); /* syntax error */
      return;
   }
   wn_up( FuncKeyVP );
}                       /* end of ExecuteCmd() */

/**************************************************************************
**
** Name : HistoryCmd()
**
** Function : Displays history list or executes previous command line
**            when its history reference number was given.
**
**    Input  : History No (0 : list all.)
**    Output : none
**
** Notes: pHisPtr : Physical History pointer (the position in HisBuf)
**        lHisPtr : Logical History pointer (the number of commad lines which
**                 were ever saved as history. )
**
**************************************************************************/
PUBLIC VOID HistoryCmd ( S16 hNo )
{
#define MAX_HISTORY 32
S16 i,j, idx ;
S8 temp[530];

   if (lHisPtr < 1) return;  // no history
   VPOut = COMVP;
//   if ( (hNo > lHisPtr) || (hNo > MAX_HISTORY) ) {
// Chen 05/25/94
   if ( (hNo > lHisPtr) || (hNo > MAX_HISTORY) || (hNo < 0) ) {
      prn_ferr(1);
      return;
   }
  /*-------------------------------------------------------------------
   If the saved command lines are more than 32, only the last 32 command
   lines are saved as history.
   ----------------------------------------------------------------------*/
   if (lHisPtr > pHisPtr ) { // more than 32 lines
      if ( !hNo ) {        // display history list
         for ( i=1, j= pHisPtr; j < MAX_HISTORY; i++, j++ ) {
            sprintf(temp," %2X. %s\n\r",i, hisBuf[ j ] );
            DisplayStr( temp );
         }
         for ( j=0; j < pHisPtr; i++, j++ ) {
            sprintf(temp," %2X. %s\n\r",i, hisBuf[ j ] );
            DisplayStr( temp );
         }
      }
      else {             // executes the specified command line
         idx = ( pHisPtr + hNo - 1) % MAX_HISTORY;
         DisplayPrompt(FALSE);
         sprintf(temp,"%s\n\r", hisBuf[ idx ] );
         DisplayStr( temp );
         strcpy(lineBuf, hisBuf[ idx ]);
         ExecuteCmd(1);
      }
   }
   else {              // The history saved is less than 32 command lines
     if ( !hNo ) {     // Diplays history
        for ( i=0; i < lHisPtr; i++ ) {
           sprintf(temp," %2X. %s\n\r",i+1, hisBuf[ i ] );
           DisplayStr( temp );
        }
     }
     else {            // executes the specified command line
        DisplayPrompt(FALSE);
        sprintf(temp,"%s\n\r", hisBuf[ hNo-1 ] );
        DisplayStr( temp );
        strcpy(lineBuf, hisBuf[hNo-1]);
        ExecuteCmd(1);
     }
   }
}                        /* end of HistoryCmd ( FLAG hNo ) */

/**************************************************************************
**
** Name : InputProcess()
**
** Function : Main entry of the keyin proccess
**
**    Input  : none
**    Output : none
**
** Notes: will fill the values of cmdIdx and SynIdx which are global variables.
**
**************************************************************************/
PUBLIC RETCODE InputProcess()
{
RETCODE chkFlag;

   VPOut = COMVP;
   DisplayPrompt(FALSE);
   while ( 1 ) {
      wn_up( FuncKeyVP );
      VPOut = COMVP;
      csr_type( BOT_LINE );
      cmdIdx = synIdx = -1;
      if (auto_flag) {
         chkFlag = KeyinProcess( KbdBuf, 0 );
         auto_flag = 0;
      }
      else chkFlag = KeyinProcess(NULL, 1 );
      if ( chkFlag >= LINE_ERR ) {
            if ( isAF8 ) {
                CloseHelpWindows(2);
            }
         DisplayStr("\n\r");
         return( chkFlag );
      }
      if (( chkFlag == RE_INPUT ) || (chkFlag == FUNCTION_KEY)) {
         if (chkFlag == RE_INPUT) {
            DisplayCharAtViewport( '\r');
            DisplayPrompt(TRUE);
         }
         else DisplayPrompt(FALSE );
         continue;  /* CR pressed with no input or ESC was pressed */
      }
      if ( cmdIdx < 0 ) {
         wn_up( FuncKeyVP );
         return( COMMAND_ERR );
      }
      chkFlag = CheckSyntax(argc, argv);
	  cmdLineArgc = argc;
      if (chkFlag == CORRECT) return (SYNTAX_OK);
      if (chkFlag==ERROR) return ( syntaxErrFlag );
   }
}  /* end of InputProcess() */

/**************************************************************************
**
** Name : KeyinProcess( )
**
** Function : Processes user keyin.
**
**    Input  : input string(if not input from keyboard), and isFromKbd
**    Output : Command Index, Syntax Index (global)
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE KeyinProcess( S8 *strBuf, FLAG isFromKbd )
{
EXTERN FLAG nullLine;

S8  k, *ptr, *ptr1, goEndFlag;
S8 *aWord, *tempBuf1;
S16 cnt=0, charIdx = 0;
S16 l, cc, rr, pos;
FLAG isDQ = 0,isSQ = 0,isSymbol = 0,notNext=1,isHis = 0,isParen = 0;
FLAG chkCmdHint = 1, chkDisplayFunc = 1, wasIns=0, chkSynHint = 0;
RETCODE chkFlag = -1, chk;
U32 addr;
STATUS status;
int temp;


   VPOut = COMVP;
   memset(lineBuf, NULL, sizeof(lineBuf));
   cmdIdx = synIdx = -1;
   posPtr = 0;
   cmdFileKeyPtr = strBuf;

//   aWord = malloc(81);
// Chen 05/25/94
//    if ( (aWord=malloc(81))==NULL ) {
    if ( (aWord=malloc(256))==NULL ) {
        return (MEM_ERR);
    }

   while ( notNext ) {
        if ( isAF8 && (strlen(lineBuf) >= 76) ) {
            CloseHelpWindows(2);
        }   // close the help window when the input line wraped

      Keyin = (isFromKbd) ? get_key() : strBuf[ charIdx++ ];
      if (!Keyin && isFromKbd)
         return(FUNCTION_KEY); // bkpt was set through mouse
      cmdFileKeyPtr++;
      if   ( ( ((k= Keyin) >= KEY_F10 ) && ( k <= KEY_F1 ) ) ||
           ( ( k >= KEY_CF10 ) && ( k <= KEY_CF1 ) ) ||
//           ( ( k >= KEY_AF10 ) && ( k <= KEY_AF5 ) ) ) {
           ( ( k >= KEY_AF10 ) && ( k <= KEY_AF4 ) ) ) {    // Chen 06/02/94
            if ( isAF8 && (k!=KEY_AF8) ){
                CloseHelpWindows(2);
            }
           if (k==KEY_F1) GetCmdSyn(  &chkFlag, posPtr, isFromKbd);
           chkSynHint = chkCmdHint = KEY_F1_F10();
           if ( k <= KEY_F3 && k >= KEY_F10 && k != KEY_F6 && !nullLine ) {
              free(aWord);
              return( FUNCTION_KEY );
           }
           else if ( k == KEY_AF4 && !nullLine ) {      // Chen 06/10/94
              free(aWord);
              return( FUNCTION_KEY );
           }
           else if ( k == KEY_AF7 || k == KEY_AF5 ) {   // Chen 08/11/94
                temp = VPOut;
                VPOut = COMVP;
                ClearLine();
                DisplayPrompt(FALSE);
                DisplayStr(lineBuf);
                VPOut = temp;
           }
      }
      else if ( ( Keyin >= KEY_SF10 ) && ( Keyin <= KEY_SF1 ) ) {
            if ( isAF8 ) {
                CloseHelpWindows(2);
            }
              KEY_SF1_SF10();
              free(aWord);
              return(RE_INPUT);
      }
      else if ( ( Keyin >= -50 ) && ( Keyin <= -16 ) ) {
            if ( isAF8 ) {
                CloseHelpWindows(2);
            }
              LogInteraction( Keyin );
              chkFlag = KEY_AF_AH();
              if (chkFlag || cmdfile_flag) {
                 free(aWord);
                 return( RE_INPUT );
              }
      }
      else {
         switch (Keyin) {
            case KEY_CG :  // Ctrl_G, added by Chen, 07/11/94
                nRelinkMICE = TRUE;
                DisplayStr("\n\r Re-linking MICE ...\n\r");
                if ( InitMICEGbls() == FALSE ) {
                    PopMessage("Reset MICE and Re-link it  ");
                }
                else {
                    DisplayStr("\n\r Re-link MICE in success!\n\r");
                }
                MonVarCount = 0;    // clear DATVP
                RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);
                UpdateVP();
                UpdateCODVP(-1);
                backLevel = 0;
                RunStart = 0L;  // reset the download start address
                free(aWord);
                return(FUNCTION_KEY);
            case ESC :
               CloseHelpWindows(2);
               ClearLine();
               free(aWord);
               // Chen 06/09/94
                memset(lineBuf, NULL, sizeof(lineBuf));
                posPtr = 0;
               return RE_INPUT;
            case LF  :
            case CR  :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
               if ( (cnt =strlen(lineBuf)) > 0 )
                  chkFlag = CRPressed(isHis, posPtr, wasIns, isSymbol, isFromKbd);
               DisplayStr( "\n\r" );
               wn_up( FuncKeyVP );
               if ( ( chkFlag < 0 ) || (cnt < 1 ))  {
                  free(aWord);
                  return RE_INPUT;
               }
               if (chkFlag >= LINE_ERR) {
                  free(aWord);
                  return chkFlag;
               }
               if ( cmdIdx < 0 ) {
                  free(aWord);
                  return CMDERROR;
               }
               chkCmdHint = chkDisplayFunc = chkSynHint = 0;
               notNext=0;
               break;
            case BS  :
               if (posPtr < 1) break;
               CheckSpecial(posPtr, &isSQ, &isDQ, &isParen, &isSymbol);
               BSPressed(&isDQ, &isSQ, &isSymbol, &isParen, &posPtr);
               if (isHis) isHis = 0;
               chkCmdHint = chkDisplayFunc = chkSynHint =  1;
               break;
            case KMA :
            case SP  :
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
            // maximum command word expanding is 11: Disassemble
            // maximum command argument is 11: Coprocessor
            // now assume the maximum length is 20.
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               chk = GetCmdSyn(  &chkFlag, posPtr, isFromKbd);
               if (chk == WORD_ERR) {
                  free(aWord);
                  return WORD_ERR;
               }

                // Chen 05/25/94
                //
                // if (chkFlag == WORD_ERR220 ) {
                //     prn_ferr(chkFlag);
                //     return;
                // }

               if (cmdIdx >= 0 ) {
                  CheckSpecial(posPtr, &isSQ, &isDQ, &isParen, &isSymbol);
                  if ( (chk == 1) &&  (!isSQ) && (!isDQ) && !isParen ){
                     chk = GetLastWord( aWord, posPtr );
                     if (chk == WORD_ERR) {
                        free(aWord);
                        return chk;
                     }
                     // Chen 05/25/94
                     // if (chk == WORD_ERR220) {
                     //    free(aWord);
                     //    return chk;
                     // }
                     chkFlag = ExpandArg ( cmdIdx, aWord, posPtr );
                  }
                  if (( chkFlag == EXPANDABLE) && (chk > 0) && (!isSQ) &&
                     (!isDQ) && (!isSymbol) ) {
                     if (!AddExpToLineBuf(expStr, &posPtr, wasIns)) {
                        free(aWord);
                        return LINE_ERR;
                     }
                  }
                  else if (!AddKeyinToLineBuf(Keyin, &posPtr, wasIns)) {
                        free(aWord);
                        return LINE_ERR;
                  }     // added by Chen 06/13/94
               }
               else if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                  free(aWord);
                  return LINE_ERR;
               }

// changed by Chen 06/13/94
//               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
//                  free(aWord);
//                  return LINE_ERR;
//               }
               chkCmdHint=chkDisplayFunc=isSymbol=isHis=chkSynHint = 0;
               break;
            case PS:
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                  free(aWord);
                  return LINE_ERR;
               }
               isSymbol =1;
               chkCmdHint = chkDisplayFunc = isHis = chkSynHint = 0;
               break;
            case DQ :
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                  free(aWord);
                  return LINE_ERR;
               }
               if ( (!isSQ) && (!isDQ) ) isDQ =1;
               else { if (isDQ) isDQ = 0; }
               chkCmdHint = chkDisplayFunc = isHis = chkSynHint = 0;
               break;
            case SQ :
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                  free(aWord);
                  return LINE_ERR;
               }
               if ( (!isSQ) && (!isDQ) ) isSQ =1;
               else { if (isSQ) isSQ = 0; }
               chkCmdHint = chkDisplayFunc = isHis = chkSynHint = 0;
               break;
            case LP :
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                  free(aWord);
                  return LINE_ERR;
               }
               if (cmdIdx != C_TRIGGER) isParen =1;
               chkCmdHint = chkDisplayFunc = isHis = chkSynHint = 0;
               break;

            case RP :
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               if (isParen) isParen = 0;
               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                  free(aWord);
                  return LINE_ERR;
               }
               chkCmdHint = chkDisplayFunc = isHis = chkSynHint = 0;
               break;
            case KEY_TAB:
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
               ChangeActiveViewport();
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_CPGUP :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
                if ( COMVPMax )     // 186err.lst NO.33
                    break;
               BackTraceUp();
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_CHOME :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
                if ( COMVPMax )     // 186err.lst NO.33
                    break;
               if (dspMode == ASM) break;
               ViewTopPage();
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_CEND :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
                if ( COMVPMax )     // 186err.lst NO.33
                    break;
               if (dspMode == ASM) break;
               UpdateCODVP( CODVP_BOTTOM );
               VP[CODVP].Ptr->r = CodeVPRange.LFcount-1;
               VP[CODVP].Ptr->c = 0;
               v_ch( CURSOR, VP[CODVP].Ptr );
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_CPGDN :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
                if ( COMVPMax )     // 186err.lst NO.33
                    break;
               BackTraceDown();
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_PGUP :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
                if ( COMVPMax )     // 186err.lst NO.33
                    break;
               if (dspMode != ASM ) {
                  chk=GetAddrInCODVP( VP[CODVP].Ptr->row_org, &addr );  // get curLineNum
                  if (chk==6) Addr2LinNum( addr, &curLineNum);
                  if ( curLineNum == 1) {
                     beep_vv( BPMEDIUM, BPMIDDLE);
                     break;
                  }
               }
               l = VP[CODVP].Height - 4;
               if ( l < 0 ) break;      // 04/27/94
               VP[CODVP].Ptr->c = 0;
               v_ch( SP , VP[CODVP].Ptr );
               if ( VP[CODVP].Ptr->row_org < l )  {
                  rr = VP[CODVP].Ptr->r - VP[CODVP].Ptr->row_org;
                  HideCursor();
                  UpdateCODVP( CODVP_PGUP );
                  ShowCursor();
                  VP[CODVP].Ptr->r = VP[CODVP].Ptr->row_org+rr;
               }
               else {
                  VP[CODVP].Ptr->row_org -= l ;
                  VP[CODVP].Ptr->r -= l;
                  wn_upd( VP[CODVP].Ptr );
                  GetCodeVPRange(2);  // 2 : PARTIAL
               }
               while (GetAddrInCODVP( VP[CODVP].Ptr->r, &addr ) == 2)
                   VP[CODVP].Ptr->r++;
               VP[CODVP].Ptr->c = 0;
               v_ch( CURSOR, VP[CODVP].Ptr );
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_PGDN :
                if ( isAF8 ) {
                    CloseHelpWindows(2);
                }
                if ( COMVPMax )     // 186err.lst NO.33
                    break;
// Chen 06/27/94    ; cannot scroll over the current module
                if ( langMode==MIX  && dspMode==ASM ||
                     langMode==HIGH && dspMode==ASM ) {
//                    langMode = ASM;
                    beep_vv(BPMEDIUM, BPMIDDLE);
                    break;
                }
               if (IsLastRowOfModule(Keyin)) {
                  beep_vv(BPMEDIUM, BPMIDDLE);
                  break;
               }
               l = VP[CODVP].Height - 4;
               if ( l < 0 ) break;      // 04/27/94     Chen
               VP[CODVP].Ptr->c = 0;
               v_ch( SP , VP[CODVP].Ptr );
               if ( (VP[CODVP].Ptr->row_org + 2*l ) >= CodeVPRange.LFcount) {
                  rr = VP[CODVP].Ptr->r - VP[CODVP].Ptr->row_org;
                  HideCursor();
                  UpdateCODVP( CODVP_PGDN );
                  ShowCursor();
                  if (CodeVPRange.LFcount <= rr )
                     VP[CODVP].Ptr->r = VP[CODVP].Ptr->row_org +
                                        CodeVPRange.LFcount-1;
                  else VP[CODVP].Ptr->r = VP[CODVP].Ptr->row_org + rr;

               }
               else {
                  VP[CODVP].Ptr->row_org += l;
                  VP[CODVP].Ptr->r += l;
                  if (VP[CODVP].Ptr->r > CodeVPRange.LFcount-1)
                     VP[CODVP].Ptr->r = CodeVPRange.LFcount-1;
                  wn_upd( VP[CODVP].Ptr );
                  GetCodeVPRange(2);  // 2 : PARTIAL
               }
//               while (GetAddrInCODVP( VP[CODVP].Ptr->r, &addr ) == 2)
// Chen 06/03/94
// ASM mode with 300 created symbols, scroll page down too slow
                while ( GetAddrInCODVP(VP[CODVP].Ptr->r, &addr)==2 &&
                        VP[CODVP].Ptr->r<50 ) {
                    VP[CODVP].Ptr->r++;
                }
               VP[CODVP].Ptr->c = 0;
               v_ch( CURSOR, VP[CODVP].Ptr );
               chkSynHint = chkCmdHint = 0;
               break;
            case KEY_UP :
               if (ActVP == CODVP) {
                    if ( isAF8 ) {
                        CloseHelpWindows(2);
                    }
                  if ( dspMode != ASM ) {
                     chk = GetAddrInCODVP( VP[ActVP].Ptr->r, &addr ); // get curLineNum
                     if (chk==6) Addr2LinNum( addr, &curLineNum);
                     if (curLineNum == 1) {
                        beep_vv( BPMEDIUM, BPMIDDLE);
                        break;
                     }
                  }
                  VP[CODVP].Ptr->c = 0;
                  v_ch( SP, VP[CODVP].Ptr );
                  while (1) {
                     --(VP[CODVP].Ptr->r);
                     if ( VP[CODVP].Ptr->r < VP[CODVP].Ptr->row_org ) {
                        VP[CODVP].Ptr->r++;
                        ScrollVPLine( VP[CODVP].Ptr, SCROLL_UP );
                     }
                     if (GetAddrInCODVP( VP[CODVP].Ptr->r, &addr ) != 2) break;
                  }
                  VP[CODVP].Ptr->c = 0;
                  v_ch( CURSOR, VP[CODVP].Ptr );
                  chkSynHint = chkCmdHint = 0;
               }
               else {
                  if (!HisPressed( KEY_UP)) break;
                  posPtr=  strlen(lineBuf);
                  chkCmdHint = chkSynHint = chkDisplayFunc = isHis = 1;
               }
               break;
            case KEY_DN :
               if (ActVP == CODVP) {
                    if ( isAF8 ) {
                        CloseHelpWindows(2);
                    }
// Chen 06/27/94    ; cannot scroll over the current module
                if ( langMode==MIX  && dspMode==ASM ||
                     langMode==HIGH && dspMode==ASM ) {
//                    langMode = ASM;
                    beep_vv(BPMEDIUM, BPMIDDLE);
                    break;
                }
                  if (IsLastRowOfModule(Keyin)) {
                     beep_vv( BPMEDIUM, BPMIDDLE);
                     break;
                  }
                  VP[CODVP].Ptr->c = 0;
                  v_ch( SP, VP[CODVP].Ptr );
                  while (1) {
                     VP[CODVP].Ptr->r++;
                     if (VP[CODVP].Ptr->r > VP[CODVP].Ptr->row_org +
                         VP[CODVP].Height-3) {
                        VP[CODVP].Ptr->r--;
                        ScrollVPLine( VP[CODVP].Ptr, SCROLL_DOWN );
                     }
                     if (GetAddrInCODVP( VP[CODVP].Ptr->r, &addr ) != 2) break;
                  }
                  VP[CODVP].Ptr->c = 0;
                  v_ch( CURSOR, VP[CODVP].Ptr );
                  chkSynHint = chkCmdHint = 0;
               }
               else {
                  if (!HisPressed( KEY_DN )) break;
                  posPtr= strlen(lineBuf);
                  chkCmdHint = chkSynHint = chkDisplayFunc = isHis = 1;
               }
               break;
            case KEY_LEFT  :
               if ( posPtr < 1  ) break;
               --posPtr;
               save_curs(&rr,&cc);
               if (!cc) set_cur(--rr,77);
               else set_cur(rr,--cc);
               DisplayCMDCURSOR();
               chkCmdHint = chkSynHint = chkDisplayFunc = 1;
               break;
            case KEY_RIGHT  :
               if ( posPtr >= strlen(lineBuf) ) break;
               ++posPtr;
               save_curs(&rr,&cc);
               if (cc == 77) set_cur(++rr, 0);
               else set_cur(rr,++cc);
               DisplayCMDCURSOR();
               chkCmdHint = chkSynHint  = 1;
               chkDisplayFunc = 0;
               break;
            case KEY_HOME:
               save_curs(&rr,&cc);
             //  if (emuGetStatus() == CPU_RUN) l = 4;
             //  else l = 1;
               l = 1;
               pos = ( posPtr + l ) / 78;
               set_cur(rr-pos, l );
               DisplayCMDCURSOR();
               posPtr = chkSynHint = 0;
               chkCmdHint = chkDisplayFunc = 1;
               break;
            case KEY_END :
               save_curs(&rr,&cc);
               cnt = strlen(lineBuf);
               pos = (cc + cnt - posPtr ) / 78;
               l = ( cc + cnt - posPtr  ) % 78;
               set_cur( rr + pos, l );
               posPtr = cnt;
               DisplayCMDCURSOR();
               chkCmdHint = chkDisplayFunc = 0;
               chkSynHint = 1;
               break;
            case KEY_DEL :
               cnt = strlen(lineBuf);
               if ((cnt < 1) || (posPtr >= cnt) ) break;
//               if ((tempBuf1 = malloc(512)) == NULL) break;
// Chen
               if ((tempBuf1 = malloc(1024)) == NULL) break;

               memset(tempBuf1, NULL, sizeof(tempBuf1) );
               if (posPtr > 0) StrmnCopy(tempBuf1, lineBuf, 0, posPtr );
               ptr1 = lineBuf;
               ptr = ptr1 + posPtr + 1;
               save_curs(&rr,&cc);
               DisplayStr( ptr );
               DisplayCh( NULL );
               set_cur(rr,cc);
               DisplayCMDCURSOR();
               strcat(tempBuf1, ptr );
               memset( lineBuf, NULL, sizeof(lineBuf) );
               strcpy( lineBuf, tempBuf1 );
               free(tempBuf1);
               chkCmdHint = chkDisplayFunc = chkSynHint = isHis = 0;
               break;
            case KEY_INS :
               if (wasIns) {
                  wasIns = 0;
                  csr_type( BOT_LINE );
               }
               else {
                  wasIns = 1;
                  csr_type( BOT_BLOCK );
               }
               chkCmdHint = chkDisplayFunc = chkSynHint = 0;
               break;
            default  :
            // Chen 06/09/94
//            if ( nBufFull==TRUE && strlen(lineBuf)>=80-20 ) {
//                free(aWord);
//                return ( ERR_BUF_FULL );
//            }

            // Chen 05/26/94
                if ( strlen(lineBuf)>=512-20 ) {
                    free(aWord);
                    return LINE_ERR;
                }

               if ((Keyin < 0x20) || (Keyin > 0x7E )) break;
               if ( posPtr < strlen(lineBuf) )
                  CheckSpecial(posPtr, &isSQ, &isDQ, &isParen, &isSymbol);
               if (isFromKbd && !isSQ && !isDQ && !isSymbol)
                  Keyin = ch_toupper( Keyin );
               if (!AddKeyinToLineBuf( Keyin, &posPtr, wasIns)) {
                    free(aWord);
                    return ( LINE_ERR );
               }
               chkCmdHint = chkSynHint = 1;
               chkDisplayFunc = isHis =  0;
               break;
         }     /* end of switch (Keyin ) */
      } /* end of if */
      if ( chkCmdHint || chkDisplayFunc || chkSynHint ) {
         pos  = (posPtr < strlen(lineBuf)) ? posPtr+1 : posPtr;
         chk = GetLastWord( aWord,  pos );
         if (chk == WORD_ERR) {
            free(aWord);
            return chk;
          }
          // Chen 05/25/94
          // if (chk == WORD_ERR220) {
          //    free(aWord);
          //    return chk;
          // }
         if ( chkDisplayFunc && ((posPtr<1) || (chk <0)) ) {
            if (lineBuf[0] == NULL) {
               isSymbol = isDQ = isSQ = isParen = 0;
               cmdIdx = synIdx = -1;
            }
            wn_up( FuncKeyVP );
         }
         else
            if (isFromKbd) {
               if (chkSynHint && ((chk == 1) || ( chk>1 &&
                   lineBuf[posPtr-1] == SP)))  {
                  if (isHis) chk = GetCmdSyn( &chkFlag, posPtr, isFromKbd);
                  if (cmdIdx >= 0 ) {
                     CheckEventTrig();
                     ShowSyntaxHint( synIdx );
                  }
               }
               else if ( (chkCmdHint) && (chk > 1))
                         ShowCmdHints(aWord[0]);

            }
      }  /* end of if ( chkCmdHint || chkDisplayFunc )  */
   }  /* end of while  */
   free(aWord);
   return (chkFlag);
}                  /* end of KeyinProcess() */

/**************************************************************************
**
** Execution codes (Local )
**
**************************************************************************/

/**************************************************************************
**
** Name : CRPressed()
**
** Function :  Processes after the CR key pressed .
**
**    Input  : isHis,  wasIns, posPtr, lineBuf(global)
**
**    Output : cmdIdx, synIdx (global)
**
** RETCODE : -1 : lineBuf consists of all blanks or null; 1 : argument;
**            2 : command
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE CRPressed( FLAG isHis, S16 posPtr, const FLAG wasIns, const FLAG isSymbol, FLAG isFromKbd )
{
S8  aWord[81];
// Chen 05/25/94
// S8 aWord[256];

 S8 tempChar, tmpBuf[20], *ptr=0;
 S16 tempCnt = 0, cnt, rr, cc, x, y, pos;
 RETCODE  chk, chkFlag;

   CloseHelpWindows(2);
   memset(expStr, NULL, sizeof(expStr));
   chk = GetCmdSyn(  &chkFlag, strlen(lineBuf) ,isFromKbd);
   if (chk == WORD_ERR ) return WORD_ERR;

// Chen 05/25/94
//   if (chk == WORD_ERR220 ) return WORD_ERR220;

   if (cmdIdx >= 0 )  {
      chk = GetLastWord( aWord,  posPtr );
      if (chk == WORD_ERR) return chk;
      // Chen 05/25/94
      // if (chk == WORD_ERR220) return chk;

      if (chk == 1) chkFlag = ExpandArg ( cmdIdx, aWord, posPtr );
      if ( !isSymbol && (chkFlag == EXPANDABLE)  )
         if (!AddExpToLineBuf( expStr, &posPtr, wasIns )) return LINE_ERR;
      cnt = strlen(lineBuf);
      if (posPtr != cnt ) {
         save_curs(&rr,&cc);
         cnt = strlen(lineBuf);
         x = (cc + cnt - posPtr ) / 78;
         y = ( cc + cnt - posPtr  ) % 78;
         set_cur( rr + x, y );
         posPtr = cnt;
         chk = GetLastWord( aWord,  posPtr );
         if (chk == WORD_ERR) return chk;
         // Chen 05/25/94
         // if (chk == WORD_ERR220) return chk;

         if (chk == 1) chkFlag = ExpandArg ( cmdIdx, aWord, posPtr );
         if ( !isSymbol && (chkFlag == EXPANDABLE)  )
            if (!AddExpToLineBuf( expStr, &posPtr, wasIns )) return LINE_ERR;
      }
   }
   if ( cmd_flag && !cmdfile_flag) {
      do {
         tempChar = lineBuf[tempCnt++];
         logb(tempChar);
      } while ( tempChar != NULL);
      logb(CR);
      logb(LF);
   }
   if (isHis) ++hisIdx;   /* hisIdx is used by Cursor UP and DN */
   else
      if ( !isHis && !cmdfile_flag && ( cmdIdx != C_HISTORY ))  {
         pHisPtr %= 32;  /* Physical History Ptr */
         strcpy( hisBuf[pHisPtr++], lineBuf);
         hisIdx = pHisPtr;
         ++lHisPtr;          /* Logical History Ptr */
      }
   save_curs(&rr,&cc);
   cnt = strlen(lineBuf);
   x = (cc + cnt - posPtr ) / 78;
   y = ( cc + cnt - posPtr  ) % 78;
   set_cur( rr + x, y );
   if (chkFlag == CMDERROR && (ptr=strchr(lineBuf,PS)) == NULL ) return chk;
   if (InputParsing() && ptr) {
      cmdIdx = C_WATCH;
      synIdx = cmdRecord[ C_WATCH ].synType;
      return( INEXPANDABLE );
   }
   return chk;
}  /* end of CRPressed */

/**************************************************************************
**
** Name : BSPressed
**
** Function :  Processes after the Backspace key pressed .
**
**    Input  : lineBuf, isDQ, isSQ, isSymbol, isParen, posPtr
**    Output : lineBuf, isDQ, isSQ, isSymbol, isParen, posPtr
**
** Notes:
**
**************************************************************************/
PRIVATE VOID BSPressed( FLAG *isDQ, FLAG *isSQ, FLAG *isSymbol, FLAG
*isParen,  S16 *posPtr)
{
S8 aWord[81];
// Chen 05/25/94
// S8 aWord[256];

S8 k;
S8 tempBuf[512], tempBuf1[512];
S16 j, cnt, pos, cc, rr;
RETCODE chkFlag ;
FLAG wasCUR = 0;

   cnt = strlen(lineBuf);
   pos = *posPtr;
   memset(tempBuf, NULL, sizeof(tempBuf) );
   memset(tempBuf1, NULL, sizeof(tempBuf1) );
   StrmnCopy(tempBuf, lineBuf, 0, pos );
   if (pos < cnt) {
      wasCUR = 1;
      StrmnCopy(tempBuf1, lineBuf, pos, cnt - pos );
   }
   if (((( k= tempBuf[pos-1]) == SP ) || (k==KMA) || (!wasCUR)) && !(*isDQ) &&
      !(*isSQ) && !(*isSymbol) && !(*isParen) ) {
      tempBuf[--pos] = NULL;
      DisplayCh( BS );
      if (wasCUR) {
         save_curs(&rr,&cc);
         DisplayStr( tempBuf1 );
         DisplayCh( NULL );
         set_cur(rr,cc);
         DisplayCMDCURSOR();
      }
      CheckSpecial(pos, isSQ, isDQ, isParen, isSymbol);
      if ((*isSQ) || (*isDQ) || (*isSymbol) || (*isParen)) goto ToTheEnd;
      while ((( k = tempBuf[pos-1] ) >= 'a' ) && ( k <= 'z') && ( pos > 0 ) ) {
         tempBuf[--pos] = NULL;
         DisplayCh( BS );
         if (wasCUR) {
            save_curs(&rr,&cc);
            DisplayStr( tempBuf1 );
            DisplayCh( NULL );
            set_cur(rr,cc);
            DisplayCMDCURSOR();
         }
      }
   }
   else {
      tempBuf[--pos] = NULL;
      DisplayCh( BS );
      if (wasCUR) {
         save_curs(&rr,&cc);
         DisplayStr( tempBuf1 );
         DisplayCh( NULL );
         set_cur(rr,cc);
         DisplayCMDCURSOR();
      }
   }
ToTheEnd:
   if (wasCUR) strcat(tempBuf,tempBuf1);
   memset(lineBuf, NULL, sizeof(lineBuf) );
   strcpy(lineBuf, tempBuf );
   CheckSpecial(pos, isSQ, isDQ, isParen, isSymbol);
   *posPtr = pos;
}  /* end of BSPressed */

/**************************************************************************
**
** Name : HISPressed
**
** Function :  Processes after UP or DN key pressed .
**
**    Input  : key (indicates UP or DN)
**    Output : lineBuf
**
** RETCODE : 0 : history Buffer is null;   1 : non-null ;
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE HisPressed( S16 key )
{

  if ( lHisPtr < 1 ) return 0;      // No history is ever stored.
/*-----------------------------------------------------------------------
   If UP arrow was pressed, get relatively previous record.
   If no previous record was found, rotate to the last record.
   pHisPtr(Physical His.Ptr.) indicated the location where the last record
   was saved to.
 -----------------------------------------------------------------------*/
  if ( key == KEY_UP )
     hisIdx = (hisIdx < 1) ? (lHisPtr >= 32 ? 31 : pHisPtr-1 ) : hisIdx -1 ;
/*-----------------------------------------------------------------------
   If DOWN arrow was pressed, get next record.
   If no next record was found, rotate to the first record.
 -----------------------------------------------------------------------*/
  else {
     if (lHisPtr >= 32) hisIdx = (hisIdx >= 31 ) ? 0 : hisIdx + 1;
     else               hisIdx = (hisIdx >= pHisPtr-1)  ? 0 : hisIdx + 1;
  }
/*-----------------------------------------------------------------------
   Replaces current line with the new one gotten from History Buffer.
 -----------------------------------------------------------------------*/
  ClearLine( );
  memset(lineBuf, NULL, sizeof(lineBuf) );
  strcpy(lineBuf, hisBuf[hisIdx]);
  DisplayPrompt(FALSE);
  DisplayStr( hisBuf[ hisIdx ]  );
}

/**************************************************************************
**
** Name : CheckEventTrig
**
** Function :  Check if the parameter following Event or TRIgger command
**             is a valid number. If yes, get the corresponding synIdx.
**             This function is mainly for syntax hint displayings and
**             argument expansions.
**
**    Input  : lineBuf, cmdIdx
**    Output : synIdx
**
** RETCODE : CORRECT, ERROR.
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE CheckEventTrig()
{
S8 aWord[81];

  S16 no ;
  S16 len, i=0, j=0;

  if ( cmdIdx != C_EVENT ) return( ERROR );
  len = strlen(lineBuf);
  memset( aWord, NULL, sizeof(aWord) );

  while (((lineBuf[i] == SP) || ( lineBuf[i] == KMA )) && (i < len) ) i++;
  while (( lineBuf[i] != SP) && ( lineBuf[i] != KMA )  && (i < len) ) i++;
  while (((lineBuf[i] == SP) || ( lineBuf[i] == KMA )) && (i < len) ) i++;
  while ( (lineBuf[i] != SP) && ( lineBuf[i] != KMA ) && (i < len))
	  aWord[j++] = lineBuf[i++];
  if (( j <= 0 ) || ( j > 2 )) return (ERROR);
  if ( ( (no=atoi(aWord)) > 0 ) && ( no < 9 ) ) {
  if ( MICE < I8088MAX && LAM2 )  //188/186
		  switch( no ) {
			 case 1:
			 case 2:
			 case 3:
			 case 4: synIdx = 76; break;
			 case 5: synIdx = 2;  break;
			 case 6:
			 case 7:
			 case 8: synIdx = 3;  break;
		   default : break;
		  }
	else if ( (MICE < I8088MAX || MICE == I80286) && !LAM2)  // is LAM
		  switch(no){
			 case 1: synIdx = 1;  break;
			 case 2: synIdx = 52; break;
			 case 3: synIdx = 2;  break;
			 case 4:
			 case 5:
			 case 6: synIdx = 3;  break;
			 case 7:
			 case 8: return(ERROR);
		  }
	else if ( (MICE >= I8088MAX && MICE <= V30MIN) && !LAM2 ) //8088, 8086, V20, V30
		  switch(no){
			 case 1: synIdx = 1;  break;
			 case 2: synIdx = 52; break;
			 case 3: synIdx = 2;  break;
			 case 4: synIdx = 25; break;
			 case 5:
			 case 6:
			 case 7: synIdx = 3;  break;
			 case 8: return(ERROR);
		  }
	  else return(ERROR);
	return (CORRECT);
  }
  return (ERROR);
}


/*****************************************************************************
**
** Name : CheckSpecial
**
** Function :  Checks if the input is enclosed by quotation marks or a symbol
**
**    Input  : posPtr, lineBuf(global)
**    Output : isSQ :    the string is(1)/isn't(0) enclosed by single quotations.
**             isDQ :    the string is(1)/isn't(0) enclosed by double quotations.
**             isParen:  the string is(1)/isn't(0) enclosed by parentheses.
**             isSymbol: the string is(1)/isn't(0) prefixed by '%'.
** RETCODE : none
**
** Notes:
**
*****************************************************************************/
PRIVATE void CheckSpecial( S16 posPtr, FLAG *isSQ, FLAG *isDQ, FLAG *isParen, FLAG *isSymbol)
{
// S8 aWord[100];
// Chen
S8 aWord[256];

S8 k;
RETCODE chk;
S16 i, rp=0, dqCnt=0, sqCnt=0, len;
S16 sq[80], dq[256];

   *isSQ = *isDQ = *isParen = *isSymbol = 0;
   chk = GetLastWord( aWord,  posPtr );
   len = strlen( lineBuf );
// the word is prefixed by '%' -- it's a symbol !
   if (( aWord[0] == PS ) && ( (len == posPtr)  || (( posPtr < len) &&
       ((k=lineBuf[posPtr-1]) != SP) && (k != KMA)))) {
      *isSymbol = 1;
      return;
   }
   memset(sq,  NULL, sizeof(sq) );
   memset(dq,  NULL, sizeof(dq) );
  /*-----------------------------------------------------------------------
    Records the position of each ' and " and ( from the end of the string.
   ----------------------------------------------------------------------*/
   for (i=posPtr-1; i >= 0; i--) {
       if ( (k=lineBuf[i]) == SQ ) sq[ sqCnt++ ] = i; // records the positions of (')
       else
          if (  k == DQ ) dq[ dqCnt++ ] = i;  // records the positions of (")
          else
             if (  k == RP ) rp = 1;          // ')' is found
             else
                if (( k == LP ) && (!rp) && (cmdIdx !=  C_TRIGGER) )
                {   // '(' but with no ')' -- isParen=1 , //FRANK, 7/11/94
                   *isParen= 1;
                   return;
                }
   }
  /*--------------------------------------------------------------------------
    Decide which flag should be on :
      . If both (') and (") appeared(but not in pair) , the one prior to
        the other is on; otherwise, the one appeared is on.
        eg1. "It's enclosed in double qu...  => isDQ =1;
        eg2. ' " is a double quotation mark  => isSQ =1;
        eg3. "jsklslkdf sdjkls               => isDQ =1;
        eg4. 'sfdjkfjs fjdskfd               => isSQ =1;
   ------------------------------------------------------------------------*/
   if ( (dqCnt%2) && (sqCnt%2) ) {
      if ( sq[0] < dq[0] ) *isSQ = 1;    // eg. 'kjsdfk"
      else *isDQ = 1;                    // eg. "fdsfs'jf
   }
   else
      if (dqCnt%2) *isDQ = 1;          // eg. "jdlksajl
      else
         if (sqCnt%2) *isSQ = 1;       // eg. 'djskjks
}

/**************************************************************************
**
** Name : GetCmdSyn
**
** Function : Gets Command from lineBuf, then gets CmdIdx and SynIdx by
**            calling ExpandCmd
**    Input : lineBuf, posPtr, showHint
**
**    Output: cmdFlag ( EXPANDABLE/CMDERROR/INEXPANDABLE )
**
** RETCODE : -1 : lineBuf consists of all blanks or null; 1 : argument;
**            2 : command
** Notes:
**
**************************************************************************/
PRIVATE RETCODE GetCmdSyn(  RETCODE *cmdFlag, S16 posPtr, FLAG showHint)
{
 RETCODE chk, chkFlag;
 S8  *ptr, *ptr1, *ptr2, *ptr3;
S8 aWord[81];
// Chen
// S8 aWord[256];

 S16 i = 0,j=0;

  /*------------------------------------------
    Gets Command(First word ) from the string.
   ------------------------------------------*/
   chk = GetLastWord( aWord,  posPtr );  // chk =-1:home or blanks, 1:arg. 2:cmd.
   if ((chk < 0 ) || (chk == WORD_ERR)) return chk;
// Chen 05/25/94
//   if ((chk < 0 ) || (chk == WORD_ERR220)) return chk;

   if (chk == 1 ) {
       memset(aWord, NULL, sizeof(aWord) );
       while ( (lineBuf[i] == SP) || ( lineBuf[i] == KMA ) ) i++;
       while ( (lineBuf[i] != SP) && ( lineBuf[i] != KMA ) ) aWord[j++] = lineBuf[i++];
   }
 /*-----------------------------------------------------------------------------
   Checks legitimacy and expandability of the command and get cmdIdx and synIdx
  ----------------------------------------------------------------------------*/
   chkFlag = ExpandCmd( aWord, showHint );
   *cmdFlag = chkFlag;
   return chk;
}
/**************************************************************************
**
** Name : GetLastWord
**
** Function : Gets the last word ahead of the cursor from the line buffer.
**
**    Input  : lineBuf, posPtr
**    Output : aWord
**
** RETCODE : -1 : lineBuf consists of all blanks or null; 1 : argument;
**            2 : command
** Notes:
**
**************************************************************************/
PRIVATE RETCODE GetLastWord( S8 *aWord,  const S16 posPtr )
{
S8 k;
S16  start, end, j, len;

// int posDQ;          // Chen     05/25/94
// char *tmpDQ;        // Chen     05/25/94
// U8 tmpBuf[512];     // Chen     05/26/94    ; temp of lineBuf[]

//    memset(tmpBuf, NULL, sizeof(tmpBuf));

   if ( posPtr < 1 ) return -1;   // HOME position : no last word
   end = posPtr;
   memset(aWord, NULL, sizeof(aWord) );
  /*----------------------------------------
    Find the end of the wanted string.
   ---------------------------------------*/
   while ((((k=lineBuf[--end]) == SP) || ( k == KMA )) && (end >= 0));
   if (end < 0 ) return -1;      // all blanks : no last word
   start = end;
  /*--------------------------------------
    Find the head of the wanted string.
   -------------------------------------*/
   while ((((k=lineBuf[--start]) != SP) && ( k != KMA )) && (start >= 0));

   if (start < 0) {

// Chen 05/25/94
      if ((len = end+1) > 80) return WORD_ERR;
/*
        strcpy(tmpBuf, lineBuf);
        if ( strstr(strupr(tmpBuf), "SOFTKEY")==NULL ) {
            if ( (len=end+1)>80 ) {
                return WORD_ERR;
            }
        }
        else if ( (tmpDQ=strchr(lineBuf, '"'))==NULL ) {
            if ( (len=end+1)>80 ) {
                return WORD_ERR;
            }
        }
        else {
            *tmpDQ = NULL;
            posDQ = strlen(lineBuf);
            *tmpDQ = '"';
            if ( (len=posPtr-posDQ-1)>220 ) {
                return WORD_ERR220;
            }
        }
*/

      StrmnCopy(aWord, lineBuf, 0, len );
      return 2;                 // The gotten word is a command.
   }


// Chen 05/25/94
   if ((len = end-start) > 80) return WORD_ERR;
/*
    strcpy(tmpBuf, lineBuf);
    if ( strstr(strupr(tmpBuf), "SOFTKEY")==NULL ) {
        if ( (len=end-start)>80 ) {
            return WORD_ERR;
        }
    }
    else if ( (tmpDQ=strchr(lineBuf, '"'))==NULL ) {
        if ( (len=end-start)>80 ) {
            return WORD_ERR;
        }
    }
    else {
        *tmpDQ = NULL;
        posDQ = strlen(lineBuf);
        *tmpDQ = '"';
        if ( (len=posPtr-posDQ-1)>220 ) {
            return WORD_ERR220;
        }
    }
*/

   StrmnCopy( aWord, lineBuf, start+1, len );
   j=0;
   while ((((k=lineBuf[j]) == SP) || ( k == KMA )) && (j <= start)) ++j;
   if ( j == (start+1) ) return 2; // The gotten word is a command.
   else return 1;                  // The gotten word is an argument.
}

/**************************************************************************
**
** Name : AddKeyinToLineBuf
**
** Function : Adds keyin to lineBuf
**
**    Input  : lineBuf, keyin, posPtr, wasIns
**    Output : lineBuf, posPtr
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE AddKeyinToLineBuf( S8 Keyin, S16 *posPtr, FLAG wasIns )
{
 S8 tempBuf[512];
 S16 pos, cnt, rr, cc;
 FLAG wasCur = 0;


 pos = *posPtr;

// a command line can't be more than 512 chars.
 if (pos > 511) return(ERROR);

 cnt = strlen(lineBuf);
 /*---------------------------------------------------------------------------
   wasCur = 1 : cursor is not at the end of the input line.
   wasCur = 0 : cursor is at the end of the input line.
   wasIns = 1 : Insert mode on.
   wasIns = 0 : Insert mode off.
   If (cursor is not at the end of a line) AND (Insert mode off) overwrite.
   If (cursor is not at the end of a line) AND (Insert mode on)  Insert.
   if (neither of above) add to the end of the lineBuf.
 ---------------------------------------------------------------------------*/
 if (pos < cnt ) wasCur = 1;
 if (wasCur && wasIns) {
    memset(tempBuf, NULL, sizeof(tempBuf) );
    if (pos > 0) StrmnCopy(tempBuf, lineBuf, 0, pos );
    DisplayCh( Keyin);
    save_curs(&rr,&cc);
    DisplayStr( lineBuf+pos );

    if ( nBufFull == TRUE ) {       // Chen 06/13/94
        set_cur(rr-1,cc);
    }
    else {
        set_cur(rr,cc);
    }

    DisplayCMDCURSOR();
    tempBuf[pos] = Keyin;
    tempBuf[pos+1] = NULL;
    strcat(tempBuf, lineBuf+pos );
    strcpy(lineBuf, tempBuf);
    pos++;
 }
 else {
    lineBuf[ pos++ ] = Keyin;
    DisplayCh( Keyin );
 }
 *posPtr = pos;
 return(CORRECT);
}

/**************************************************************************
**
** Name : AddExpToLineBuf
**
** Function : Adds the expanded string (expStr) to line buffer(lineBuf)
**
**    Input  : lineBuf(global), expStr, posPtr, wasIns
**    Output : lineBuf(global), posPtr
**
** Notes:
**
**************************************************************************/
/* marked by Chen 06/13/94
PRIVATE RETCODE AddExpToLineBuf( S8 *expStr, S16 *posPtr, FLAG wasIns )
{
 S8 tempBuf[512] ;
 S16 len,i,j, cnt, pos, cc, rr;
 FLAG wasCur = 0;

 pos = *posPtr;
 len = strlen(expStr);
 if (pos + len > 511) return(ERROR); // a command line can't be more than 512 chars
 cnt = strlen(lineBuf);

// ---------------------------------------------------------------------------
//   wasCur = 1 : cursor is not at the end of the input line.
//   wasCur = 0 : cursor is at the end of the input line.
//   wasIns = 1 : Insert mode on.
//   wasIns = 0 : Insert mode off.
//   If (cursor is not at the end of a line) AND (Insert mode off) overwrite.
//   If (cursor is not at the end of a line) AND (Insert mode on)  Insert.
//   if (neither of above) add to the end of the lineBuf.
// ---------------------------------------------------------------------------

 if ( pos < cnt ) wasCur = 1;
 if ( wasCur ) {
    if (Keyin == KEY_ENTER) return(CORRECT); //added by Frank, 5/06/1994
    if (!wasIns) {     // INS off
       for ( i=pos, j=0; j < len ; i++, j++ ) lineBuf[i] = expStr[j];
       if ( i >= cnt ) lineBuf[i] = NULL;
       DisplayStr(expStr);
    }
    else {            // INS on
       memset(tempBuf, NULL, sizeof(tempBuf) );
       if (pos > 0) StrmnCopy(tempBuf, lineBuf, 0, pos );
       DisplayStr(expStr);
       save_curs(&rr,&cc);
       DisplayStr( lineBuf+pos );
       set_cur(rr, cc );
       if (pos > 0 ) strcat( tempBuf, expStr );
       else          strcpy( tempBuf, expStr );
       strcat( tempBuf, lineBuf+pos );
       strcpy(lineBuf, tempBuf);
    }
    pos += len;
 }
 else {
    strcat( lineBuf, expStr );
    DisplayStr( expStr );
    pos = strlen( lineBuf );
 }
 *posPtr = pos;
 return(CORRECT);
}
*/


PRIVATE RETCODE AddExpToLineBuf( S8 *expStr, S16 *posPtr, FLAG wasIns )
{
 S8 tempBuf[512] ;
 S16 len,i,j, cnt, pos, cc, rr;
 FLAG wasCur = 0;

int cc1, rr1, cc2, rr2, cc3, rr3;   // Chen 06/14/94


 pos = *posPtr;
 len = strlen(expStr) + 1;  // Chen 06/13/94    ; add a SPACE

// a command line can't be more than 512 chars
 if (pos + len > 511) return(ERROR);

 cnt = strlen(lineBuf);
/*---------------------------------------------------------------------------
   wasCur = 1 : cursor is not at the end of the input line.
   wasCur = 0 : cursor is at the end of the input line.
   wasIns = 1 : Insert mode on.
   wasIns = 0 : Insert mode off.
   If (cursor is not at the end of a line) AND (Insert mode off) overwrite.
   If (cursor is not at the end of a line) AND (Insert mode on)  Insert.
   if (neither of above) add to the end of the lineBuf.
---------------------------------------------------------------------------*/
 if ( pos < cnt ) wasCur = 1;
 if ( wasCur ) {
    if (Keyin == KEY_ENTER) return(CORRECT); //added by Frank, 5/06/1994
    if ( !wasIns ) {     // INS off
       for ( i=pos, j=0; j<len-1; i++, j++ ) {
            if ( i >= 511 ) {       // Chen 06/15/94
                lineBuf[511] = NULL;
                break;
            }
            lineBuf[i] = expStr[j];
        }
        if ( len <= 20 ) {      // Chen 06/27/94    ; add a space
            lineBuf[pos+len-1] = SPACE;
        }
       if ( i >= cnt ) lineBuf[i] = NULL;
       memset( tempBuf, NULL, sizeof(tempBuf) );
       strcpy( tempBuf, expStr );
       strcat( tempBuf, " " );
       DisplayStr( tempBuf );       // add a SPACE
    }
    else {            // INS on
       memset( tempBuf, NULL, sizeof(tempBuf) );
       if (pos > 0) StrmnCopy(tempBuf, lineBuf, 0, pos );
       save_curs(&rr2, &cc2);       // added by Chen, 06/29/94
       rr3 = rr2 + (cc2 + strlen(lineBuf) - pos)/78;
       cc3 = (cc2 + strlen(lineBuf) - pos) % 78 - 1;
       DisplayStr(expStr);
       DisplayStr( " " );
       save_curs(&rr, &cc);
       DisplayStr( lineBuf+pos );
       save_curs(&rr1, &cc1);       // Chen 06/14/94
        if ( rr1==VP[COMVP].Maxr && rr==rr1 && cc1<cc3 ) {
            csr_mvwn( rr1-1, cc, VP[COMVP].Ptr );
        }
        else if ( rr1==VP[COMVP].Maxr && rr<rr1 && cc1<cc3 ) {
            csr_mvwn( rr-1, cc, VP[COMVP].Ptr );
        }
        else {
            csr_mvwn( rr, cc, VP[COMVP].Ptr );
        }
        if ( pos > 0 ) {
            strcat( tempBuf, expStr );
            strcat( tempBuf, " " );
        }
        else if ( pos == 0 ) {
            strcpy( tempBuf, expStr );  // pos == 0
            strcat( tempBuf, " " );
        }
        strcat( tempBuf, lineBuf+pos );
        strcpy(lineBuf, tempBuf);
    }
    pos += len;
 }
 else {
    strcpy( tempBuf, expStr );
    strcat( tempBuf, " " );     // add a SPACE to linebuf and display it
    if ( (pos = strlen(lineBuf)) < 78-20 ) {
        while ( lineBuf[pos-1] == ' ' ) {
            lineBuf[pos-1] = NULL;
            save_curs(&rr, &cc);
            if ( cc > 2 ) {
                set_cur(rr,cc-1);
            }
            pos = strlen( lineBuf );
        }
    }
    strcat( lineBuf, tempBuf );
    DisplayStr( tempBuf );
    pos = strlen( lineBuf );
 }
 *posPtr = pos;
 return(CORRECT);
}



/**************************************************************************
**
** Name : ExpandCmd
**
** Function :  Checks the legitimacy and expandability of a command,
**             gets the cmdIdx, synIdx, and displays the syntax hints.
**
**    Input  : aWord, showHint
**    Output : cmdIdx, synIdx, expStr ( Global )
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE ExpandCmd ( const S8 *cmdBuf, const FLAG showHint )
{
U8 inputCmdLen, textLen, hintIdx, cnt, len;
S8 cmdTxt[15];
FLAG cmdFlag = CMDERROR;
S16 mode=0;

   cmdIdx = synIdx = -1;
   inputCmdLen = strlen( cmdBuf );
   memset(expStr, NULL, sizeof(expStr) );
   memset(cmdTxt, NULL, sizeof(cmdTxt) );
 /*--------------------------------------------------------------------
  Matches the input within struct cmdRecord to see if it is a legal
  command. If matched store, give the command number to cmdIdx, and
  get the syntax number for synIdx. If the input is expandable,
  assign the expanded part to the global variable expStr.
  --------------------------------------------------------------------*/
   for ( cnt=0; cnt< CNT_NUMBER( cmdRecord ) ; cnt++ ) {
      strcpy(cmdTxt, cmdRecord[cnt].cmdText);
      if ( ( strnicmp( cmdTxt, cmdBuf, 1) == 0 )  &&
           ( inputCmdLen >=  cmdRecord[cnt].minValidNo ) &&
           ( inputCmdLen <= ( textLen = strlen(cmdTxt))) &&
           ( strnicmp( cmdTxt, cmdBuf, inputCmdLen ) == 0 ) ) {
		len = textLen - inputCmdLen;
		if ( len > 0 ) {
            cmdFlag = EXPANDABLE;
            StrmnCopy( expStr, cmdTxt, inputCmdLen, len);
         } else cmdFlag = INEXPANDABLE;
         cmdIdx =  cnt;
		 synIdx = cmdRecord[ cnt ].synType;    //80C186 & LAM2

		 if (cmdIdx == C_CONTROL){
			 switch (MICE){
				 case 3 : synIdx = 55; break;  //188EB
				 case 4 : synIdx = 56; break;  //188EC
				 case 7 : synIdx = 55; break;  //186EB
				 case 8 : synIdx = 56; break;  //186EC
				 case 9 : synIdx = 70; break;  //8088(MAX)
				 case 10: synIdx = 69; break;  //8088(MIN)
                 case 11: synIdx = 70; break;  //8086(MAX)
                 case 12: synIdx = 69; break;  //8086(MIN)
				 case 13:
					  if (NECflag) synIdx = 72; //V20(MAX)
					  else synIdx = 70;
					  break;
				 case 14:
					  if (NECflag) synIdx = 71;
                      else synIdx = 69;
                      break;  //V20(MIN)
				 case 15:
                      if (NECflag) synIdx = 72;
					  else synIdx = 70;
					  break;				   //V30(MAX)
				 case 16:
					  if (NECflag) synIdx = 71;
					  else synIdx = 69;
					  break;				   //V30(MIN)
			 }
		 }
		 if (cmdIdx == C_CPU ){
			if (MICE >= I8088MAX && MICE <= V30MIN)
			  synIdx = 79;
			if (MICE == I80C188EB || MICE == I80C186EB)
			  synIdx = 77;
		 }
		 if (cmdIdx == C_MAP){
			 if (MICE >= I8088MAX && MICE <= V30MIN)
				synIdx = 80;
			 else if (!HEMM) synIdx = 73;
			 else synIdx = 24;
		 }
         if (!LAM2){
            if (cmdIdx == C_COVERAGE || cmdIdx == C_INITIALIZE)
                  synIdx = 77; //not exist
            if (cmdIdx == C_QUALIFY ) synIdx=63;
            if (cmdIdx == C_TRIGGER ) synIdx = 11;
         }
		 if (MICE < I8088MAX && !LAM2 || MICE == I80286){ // 80186/188 & 286
			if (cmdIdx == C_EV1 ) synIdx= 1;
			if (cmdIdx == C_EV2 ) synIdx= 52;
			if (cmdIdx == C_EV3 ) synIdx= 2;
			if (cmdIdx == C_EV4 ) synIdx = 3;
			if (cmdIdx == C_EV5 ) synIdx = 3;
	  //	if (cmdIdx == C_EV6 ) synIdx = 3;
			if (cmdIdx == C_EV7 ) synIdx = 77; //not exist
			if (cmdIdx == C_EV8 ) synIdx = 77;	//not exist
			if (cmdIdx == C_EVENT ) synIdx = 74;
         }
		 else if ( MICE >= I8088MAX && MICE <= V30MIN){ //8086 & 8088 & V20 & V30
			if (cmdIdx == C_EV1 ) synIdx= 1;
			if (cmdIdx == C_EV2 ) synIdx= 52;
			if (cmdIdx == C_EV3 ) synIdx= 2;
			if (cmdIdx == C_EV4) synIdx = 25;
			if (cmdIdx == C_EV5 ) synIdx = 3;
	  //	if (cmdIdx == C_EV6 ) synIdx = 3;
			if (cmdIdx == C_EV7 ) synIdx = 3;
			if (cmdIdx == C_EV8 ) synIdx = 77;
            if (cmdIdx == C_EVENT) synIdx = 75;
         }
         if (showHint) ShowSyntaxHint( synIdx );
         break;
      }
   }
   return( cmdFlag );
}  /* end of ExpandCmd */

/**************************************************************************
**
** Name : ExpandArg
**
** Function : Checks the expandability of an argument. If it's expandable,
**            put the expanded part to expStr.
**
**    Input  : cmdIdx, aWord, posPtr
**    Output : expStr ( global )
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE ExpandArg (  const S16 index, const S8 *argBuf, const S16 posPtr )
{
U8 inputArgLen, textLen, argFlag, argIdx, syntaxNo;
U8 len, count, argcmd, no, tempIdx, *argStr;
S8  argTxt[20];
S16 cmdId;

   argFlag = INEXPANDABLE;
   inputArgLen = strlen ( argBuf );
 /*--------------------------------------------------------------------
  In the cases of "TRigger #" or "Event #", the argument expansion and
  syntax hints are according to the exact Trigger or Event number.
  --------------------------------------------------------------------*/
   if (CheckEventTrig()) ShowSyntaxHint( synIdx );
   argStr = cmdArgu[ synIdx ].argPtr;
   if (!argStr) return argFlag;
   memset(expStr, NULL, sizeof(expStr) );
   memset(argTxt, NULL, sizeof(argTxt) );
 /*--------------------------------------------------------------------
  Matches the input within struct argRecord to see if it is expandable.
  If the input matched, store the expanded part to the global variable
  expStr.
  --------------------------------------------------------------------*/
   while (( tempIdx= *argStr) != NULL ) {
      argIdx = tempIdx - 100;
      strcpy(argTxt , argRecord[ argIdx ].argText);
      ++argStr;
      if ( ( strnicmp( argTxt,  argBuf, 1 ) == 0 )  &&
           ( inputArgLen >=   argRecord[ argIdx ].minValidNo ) &&
           ( inputArgLen <= ( textLen = strlen(argTxt))) &&
           ( strnicmp( argTxt, argBuf, inputArgLen ) == 0 ) ) {
         len = textLen - inputArgLen;
         if ( len > 0 ) {
            argFlag = EXPANDABLE;
            StrmnCopy(expStr, argTxt, inputArgLen, len);
         }
         break;
      }
   }
   return( argFlag );
} /* end of ExpandArg */

/**************************************************************************
**
** Name : ShowCmdHints( const S16 c )
**
** Function :  Displays Commands Hints on Command Help Viewport
**
**    Input  : First character of a command
**    Output : none
**
** Notes: 1. It works after inputting the first letter of a input line.
**        2. For 186/188 EB and EC, CPU command doesn't apply.
**
**************************************************************************/
// PRIVATE VOID ShowCmdHints( const S16 c )
// changed by Chen, 09/03/94
PUBLIC VOID ShowCmdHints( const S16 c )
{
S16 hintIdx, mode=0;
S8 temp[90];

   if ( ( c >= 'A' ) && ( c <= 'Z') ) {
      memset( temp, NULL, sizeof(temp) );
      hintIdx =  c - 'A' ;
      /*------------------------------------------------------
         Here are hints for EB and EC when 'C' is inputted.
      ------------------------------------------------------*/
      if ( c == 'C') GetCpuMode( &mode );
      if ( mode > 1 )
          sprintf( temp, " COMMANDS: CHecksum CLear CLOse COMpare CONtrol Copy CReate" );
      /*------------------------------------------------------
         Here are hints for others if they are available.
      ------------------------------------------------------*/
      else if ( *cmdHints[ hintIdx ]  != NULL ){
         if (c == 'C' && !LAM2) hintIdx = 26;
		 if (c == 'E' && !LAM2 && (MICE < I8088MAX || MICE == I80286) )
			  hintIdx = 27;
		 else if (c=='E' && !LAM2 && (MICE >= I8088MAX) ) hintIdx = 30;
         if (c == 'I' && !LAM2) hintIdx = 28;
         if (c == 'T' && !LAM2) hintIdx = 29;
         sprintf( temp, " COMMANDS: %s", cmdHints[ hintIdx ] );
      }
      else sprintf( temp , " No matching commands ! ");
      v_stpl(0, 0, temp, CmdHelpVP);
   }
}  /* end of ShowCmdHints */

/**************************************************************************
**
** Name : ShowSyntaxHint( const S16 c )
**
** Function :  Displays Syntax Hints on Command Help Viewport.
**
**    Input  : syntax number.
**    Output : none
**
** Notes:
**
**************************************************************************/
// PRIVATE VOID ShowSyntaxHint( const S16 syntaxNo)
// changed by Chen, 09/03/94
PUBLIC VOID ShowSyntaxHint( const S16 syntaxNo)
{
S8 temp[90];

   sprintf(temp," Hints: %s", cmdArgu[ syntaxNo ].argHints );
   v_stpl(0, 0, temp, CmdHelpVP);

}  /* end of ShowSyntaxHint */

/**************************************************************************
**
** Name : InputParsing
**
** Function :   Parses the input line(lineBuf) and fills argc, argv[][]
**
**    Input  :  lineBuf
**    Output :  argc, argv[][] (regional)
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE InputParsing(VOID)
{
S16 lcnt,j,l;
S8 k;

   lcnt = strlen(lineBuf);     // length of lineBuf
   argc = 0;                   // arguments counter
   memset(argv,  NULL, sizeof(argv) );
   j=0;                        // lineBuf index
   /*--------------------------------------------------------------------
         Bypass blanks, commas and the command.
   --------------------------------------------------------------------*/
   while ( ( ( (k= lineBuf[j] ) == SP ) || (k ==KMA) )  && (j < lcnt) ) ++j;
   if (lineBuf[j] == PS) { // >%symbol (or %%module%symbol) (Watch)
      l=0;
      while ( ( (k=lineBuf[j]) != SP ) && (k != KMA) && (j < lcnt)
      && (l<80)) argv[argc][l++] = lineBuf[j++];
      if (l <= 1) return(FALSE); // %
      ++argc;
   }
   else if (cmdIdx < 0) return(FALSE);
   while ( ((k=lineBuf[j]) != SP ) && ( k != KMA) && (j < lcnt) ) ++j;

   /*--------------------------------------------------------------------
         Get arguments .
   --------------------------------------------------------------------*/
   while  (j < lcnt )  {
      while ((( (k= lineBuf[j]) == SP ) || (k==KMA)) && (j < lcnt ) ) ++j;
      if ( j >= lcnt ) break;
      l=0;  // character counter for an argument.
   /*--------------------------------------------------------------------
     All words enclosed in quotation marks (' or ") or parentheses "( and )"
     in INClude command or preceding by "DOS" command are considered the
     same argument. The length of an argument is not more than 80 characters.
     But the contents in quotation marks can't be more than 32 chars except
     SOftkey command which allows 80 chars.
    --------------------------------------------------------------------*/
      if ( ( (k=lineBuf[j]) == SQ) || (k == DQ) ) { // with quotation marks
         do { argv[argc][l++] = lineBuf[j++];
         } while ((lineBuf[j] != k ) && (j <= lcnt) &&
                  ((( cmdIdx == C_SOFTKEY) && (l<80)) ||
// Chen 05/25/94
//                  ((( cmdIdx == C_SOFTKEY) && (l<220)) ||
                   (( cmdIdx != C_SOFTKEY) && (l<33)) ));
         argv[argc][ l++ ] = lineBuf[j++];
      }
      else
         if ((cmdIdx == C_INCLUDE) && (lineBuf[j] == LP)) { // INClude command
            do { argv[argc][l++] = lineBuf[j++];            // with arguments
            } while ((lineBuf[j] != RP ) && (j <= lcnt) && (l<80));
            argv[argc][ l++ ] = lineBuf[j++];
         }
         else
//            if (cmdIdx == C_DOS ) {  // DOS command_descriptions
// changed by Chen, 07/12/94
            if ( cmdIdx == C_DOS || cmdIdx == C_DOSA ) {  // DOS command_descriptions
               while (( j < lcnt ) && (l<80)) argv[argc][ l++ ] = lineBuf[j++];
               ++argc;
               break;
            }
            else {       // normal parameters
               while ( ( (k=lineBuf[j]) != SP ) && (k != KMA) && (j < lcnt)
                     && (l<80)) argv[argc][ l++ ] = lineBuf[j++];
            }
      ++argc;
   }
   return(TRUE);
} /* end of InputParsing */


/******************************** End of File *****************************/

