/***************************************************************************
**
** File name : cmd_f.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**    3. Change "USDtoupper()" to "ch_toupper()".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

#define TABLE_LEN   16
#define RESV_NULL   12
#define ARG_F_ERROR -2

/**************************************************************************
**
** Local variables
**
***************************************************************************/

int cmdfile_ESC = 0;
static char temp_str[80]="\0";

char if_word[IF_COUNT][IF_WORD_LEN];
char word[CMD_LENGTH], word2[CMD_LENGTH], word3[CMD_LENGTH];
char ond_cmd_line[CMDFILEBUFSIZE], *dd_ptr;
int if_w_count;
int if_true;
char cmd_file_get[80];
char *RESV[] = {
   "GOTO",     // 0
   "IF_NOT",   // 1
   "IF",       // 2
   "ELSE",     // 3
   "PAUSE",    // 4
   "REM",      // 5
   "GET",      // 6
   "ERROR",    // 7
   "TICK",     // 8
   "BELL",     // 9
   "INCLUDE",  // 10
   "ECHO",     // 11
   "LOOPEND",  // 12, RESV_NULL
   "LOOP",     // 13
   "\\",       // 14
   ":",        // 15
};

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern int tick_count;
extern int cmdfile_end_flag;

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : ReadCmdFile(int code)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

ReadCmdFile(int code)
{
int r;

   d_buf[d_buf_idx] = 0;
   if (cmdfile_end_flag)
      r = END;
   else if (chk_hlt() != ESC && !down_ESC_send)
      r = GetOneLineFromCmdFile();
   else
      r = END;
   if (r == END) EndCmdFile();
   else if (CmdFileBuf[0] != ESC) {
      if (!in_get_str2) d_buf_idx = d_buf[0] = 0;
   }
   return (r);
}    /* end of ReadCmdFile(int code) */

/**************************************************************************
**
** Name : GetOneLineFromCmdFile()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

GetOneLineFromCmdFile()
{
char a, ch, c, *ptr, *p2, lab_temp[40], *ptr1, bufbuf[162], buf[200];
char cmd_f_bak[80], cmd_fname[80], bbb[80];
int i, ii, j, r, rr, rrr, code;
int len;
char *token;
int nQuotationUnmatch = FALSE;

   if (CheckCommandFileError() == CMD_F_ERROR) {
      prn_ferr(10);
      d_putc(LF);
      return (END);
   }
big_loop:
   while ((rrr=lin_token()) == OK) {
      if (resv_code < RESV_NULL)  keep_it_for_IF = 0;
again:
      if (resv_code < RESV_NULL && echo_flag) {
         if (in_get_str2)  d_prntf("\n\r");
         DisplayPrompt(FALSE);
         d_prntf(CmdFileBuf);
         i = strlen(CmdFileBuf);
         strcpy(buf, CmdFileBuf);
         buf[i-1] = CR;
      }
again2:
      switch(resv_code) {
      case -1:   /* error occurred! */
         prn_ferr(37);
         break;
      case 0:   /* GOTO */
         strcpy(lab_temp, word2);
         fseek(SUBMIT[which].fd, 0L, 0);
         temp_str[0] = '\0';
         strcat(temp_str, ":");
         strcat(temp_str, lab_temp);
         len = strlen(temp_str);
         while (1) {
            if (fgets(bufbuf, 161, SUBMIT[which].fd) == NULL) {
               prn_ferr(7);
               return (END);
            }
            if (bufbuf[0] != ':')  continue;
            if (strstr(bufbuf, temp_str) == NULL)  continue;
            token = strtok(bufbuf, " \n");
            if (strlen(token) == len)  break;
         }
         lab_ptr = SUBMIT[which].labptr_tmp;
         break;
      case 1:   /* IF_NOT */
      case 2:   /* IF */
         sscanf(CmdFileBuf,"%s %s", word2, word);
         p2 = word2;
         if (!strnicmp(word,"GET",3)) {
            if (ptr1 = index(CmdFileBuf,'=')) {
               while (!isalnum(c = *++ptr1))  ;
               while (isalnum(c = *ptr1++) && c)  *p2++ = c;
               code = 2;
            }
         }
         else if (ptr1 = index(CmdFileBuf,'"')) {
            while (c = *++ptr1) {
//               if (c=='"' || c =='\'')  break;
//               else  *p2++ = c;
// changed by Chen, 07/12/94
                if ( c == '"' ) {
                    break;
                }
                else if ( c == LF ) {
                    nQuotationUnmatch = TRUE;
                    break;
                }
                else {
                    *p2++ = c;
                }
            }
            code = 1;
            ptr1++;
         }
//         if (!ptr1) {
//            prn_ferr(0);
//            break;
//         }
// changed by Chen, 07/12/94
         if ( !ptr1 || nQuotationUnmatch==TRUE ) {
            nQuotationUnmatch = FALSE;
            prn_ferr(83);
            break;
         }

         *p2 = '\0';
         if ((CheckIF(word2,code) && resv_code == 2) ||
            (!CheckIF(word2,code) && resv_code == 1)) {
            if_true = 1;
            strcpy(CmdFileBuf, ptr1);
            DecideReserveWord();
            goto again2;
         }
         else {
            if_true = 0;
            break;
         }
      case 3:   /* ELSE */
         if (!if_true) {
            if_true = 1;
            if (skipdummy(CmdFileBuf, &ptr1, 1)) {
               prn_ferr(9);
               break;
            }
            else {
               strcpy(CmdFileBuf, ptr1);
               DecideReserveWord();
               goto again2;
            }
         }
         else  break;
      case 6:   /* GET */
         cmdfile_flag = 0;
         d_putc(CR);
         if (get_str2(cmd_file_get, 50) == ESC)
            cmdfile_end_flag = 1;
         cmdfile_flag = 1;
         d_prntf("\r\n");
         if (ptr = index(cmd_file_get, CR))  *ptr = '\0';
         break;
      case 5:   /* REM */
         break;
      case 13:  /* LOOP */
         L_brace();
         continue;
      case 12:  /* LOOPEND */
         if (R_brace() == CMD_F_ERROR) {
            d_prntf(CmdFileBuf);
            prn_ferr(11);
            break;
         }
         continue;
      case 14:  /* \ */
         cmdfile_ESC = 1;
         CmdFileBuf[0] = ESC;
         CmdFileBuf[1] = CR;
         return (0);
      case 15:  /* : */
         if (rr=cre_label(word, word3))  prn_ferr(rr);
         continue;
      case 4:   /* PAUSE */
         i = GetNumber();
         if (i > 0)  pause_delay(i);
         else if (i != -2) {   /* ignore "PAUSE 0" and no delay */
//          d_prntf("\r Press <ESC> to abort command file, any other key to continue");
            cmdfile_flag = 0;
            c = getc_mpds();
            cmdfile_flag = 1;
//          d_prntf("\r\n");
            if (c == ESC) {
               cmdfile_end_flag = 1;
               return (END);
            }
         }
         break;
      case 8:   /* TICK */
         i = tick_count = GetNumber();
         if (i == -1)  prn_ferr(0);
         else if (i != -2)  USDSetTimer(i);
         break;
      case 9:   /* BELL */
         i = GetNumber();
         if (i == -1)  prn_ferr(0);
         else if (i != -2)
            do
               bell();
            while (--i > 0);
         break;
      case 7:   /* ERROR */
         if (!stricmp(word2,"ABORT"))  error_abort = ON;
         else if (!stricmp(word2,"CONTINUE"))  error_abort = OFF;
         else  prn_ferr(37);
         break;
      case 11:   /* ECHO */
         if (word2[0] == NULL) {
            sprintf(bbb,"\rECHO is: %s\r\n", echo_flag ? "ON" : "OFF");
            d_prntf(bbb);
         }
         else if (!stricmp(word2,"ON")) {
            if (!in_get_str2 && !echo_flag) {
               echo_flag = 1;
//               d_o_prompt();
            }
            echo_flag = 1;
         }
         else if (!stricmp(word2,"OFF")) {
            if (!in_get_str2 && echo_flag)  d_prntf("\r               \r");
            echo_flag = 0;
         }
         else  prn_ferr(25);
         break;
      default:
         if (!in_get_str2)  DisplayPrompt(FALSE);
         if (CmdFileBuf[0] != CR) {
            ptr1 = index(CmdFileBuf, LF);
            *ptr1 = CR;
         }
         return (0);
      }  // end of switch
   }  // end of while
   if (rrr == FAIL) {
      for (j = SUBMIT[which].lop_start+1 ; j <= looptr; j++)
         if (LOOP[j].if_close != 1) {
            prn_ferr(6);
            break;
         }
      lab_ptr = SUBMIT[which].lab_start;
      i = looptr;
      looptr = SUBMIT[which].lop_start;
      SUBMIT[which].lab_start = SUBMIT[which].line_count = 0;
      strcpy(cmd_fname, cmd_f_bak);
      SUBMIT[which].lop_start = -1;
      now_loop = SUBMIT[which].lop_start;
      for ( ; i > looptr; i--)
         LOOP[i].start_l = LOOP[i].end_l = LOOP[i].count=LOOP[i].if_close=0;
   }
   return (END);
}         /* end of GetOneLineFromCmdFile() */

/**************************************************************************
**
** Name : EndCmdFile()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

EndCmdFile()
{
   keep_it_for_IF = 0;
   if (which == 0)  cmdfile_flag = 0;   // is first level, clear cmdfile_flag
   if (!echo_flag) {
      echo_flag = 1;
//      if (!in_get_str2)  d_o_prompt();
   }
   fclose(SUBMIT[which].fd);
// if (which)  fclose(SUBMIT[which].fd);
}        /* end of EndCmdFile() */

/*
   Example:
      "BELL 2"   return (2)
      "BELL"      return (0)
      "BELL  qwt.."   return (-1)
      "BELL 0"   return (-2)
*/

/**************************************************************************
**
** Name :   GetNumber()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

static GetNumber()
{
int i, a;
char c, *par;

   i = 0;
   if (!skipdummy(CmdFileBuf, &par, 1)) {
      for (i = 0; ; ) {
         c = toupper(*par);
         /* because toupper() is a macro, par is incremented later */
         par++;
         if (isxdigit(c)) {
            if (isdigit(c))  a = c - '0';
            else  a = 10 + c - 'A';
            i = (i<<4) | a;
         }
         else {
            if (c!=CR && c!=SP && c!=LF) i = -1;
            break;
         }
      }
      if (i == 0) i = -2;
   }
   return (i);
}           /* end of GetNumber() */

/**************************************************************************
**
** Name : In_wh_loop(int pos)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

In_wh_loop(int pos)
{
int j;

   now_loop = SUBMIT[which].lop_start;
   for (j = looptr ; j > SUBMIT[which].lop_start; j--)
      if (LOOP[j].start_l < pos)
         if (LOOP[j].end_l > pos || !LOOP[j].end_l) {
            now_loop = j;
            return (LOOP[j].if_close);
         }
   return (0);
}         /* end of In_wh_loop(int pos) */

/**************************************************************************
**
** Name : R_brace()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

R_brace()
{
int j, i=0;
char c, *ptr;
char bufbuf[162];

   for (loop_chk = looptr ; loop_chk > SUBMIT[which].lop_start; loop_chk--)
      if ((i=LOOP[loop_chk].if_close) != 1)  break;
   if (loop_chk >= 0) {
      if (i == 0) {      /* the first iteration of this loop */
         if (word2[0]) {
            ptr = word2;
            while ((c=*ptr++) != ' ' && c != ',' && c != LF && c != '\0')  ;
            *--ptr = '\0';
         }
         LOOP[loop_chk].end_l = SUBMIT[which].line_count;
         LOOP[loop_chk].count = (word2[0]) ? atoi(word2) : 1;
         if (LOOP[loop_chk].count > 1)  LOOP[loop_chk].if_close = -1;
      }
      LOOP[loop_chk].count--;
      if (LOOP[loop_chk].count > 0) {
         fclose(SUBMIT[which].fd);
         SUBMIT[which].fd = fopen(SUBMIT[which].cmd_line,"rt");
         j = LOOP[loop_chk].start_l;
         SUBMIT[which].line_count = j;
         for (i = 1 ; i < j; i++)
            fgets(bufbuf, sizeof(bufbuf)-1, SUBMIT[which].fd);
         cmd_fgets();
      }
      else  LOOP[loop_chk].if_close = 1;
   }
   else  return (CMD_F_ERROR);
   return (1 - CMD_F_ERROR);
}         /* end of R_brace() */

/****************
return value of lin_token:
   OK
   FAIL
   ESC
****************/

/**************************************************************************
**
** Name :  lin_token()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

lin_token()
{
char *pc, *pt, *p2, c, c1, c2;

start:
   if (chk_hlt() == ESC || down_ESC_send) {
      down_ESC_send = 0;
      return (ESC);
   }
   pt = (char *) CmdFileBuf;
   word[0] = word2[0] = word3[0] = '\0';
// any_G_mesg();
   if (!cmd_fgets())  return (FAIL);
   SUBMIT[which].line_count++;
   skipdummy(ond_cmd_line, &pc, 0);
   pc--;
   while ((c = *(++pc))) {
      if (c == '%') {
         c1 = *(pc+1);
         if (isdigit(c1)) {
            c1 -= '0';
//          c1--;
            if (c1 >= 0 && c1 <= SUBMIT[which].arg_count) {
               c2 = SUBMIT[which].arg_len[c1];
               strncpy(pt, SUBMIT[which].arg[c1], c2);
               pt += c2;
               pc++;
               continue;
            }
            else {
               strncpy(pt, pc, 2);
               *(pt + 2) = LF;
               *(pt + 3) = '\0';
               resv_code = -1;
               goto RET;
            }
         }
      }
      *pt++ = c;
   }
   *pt = '\0';
   DecideReserveWord();
RET:
   return (OK);
}          /* end of lin_token() */

/**************************************************************************
**
** Name : DecideReserveWord()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

static DecideReserveWord()
{
   sscanf(CmdFileBuf,"%s %s %s", word, word2, word3);
   if (word[0]) {
      if (in_get_str2 && word[0] != '\\') {
         resv_code = TABLE_LEN;
         return;
      }
      if (word[0] == '\\')
         resv_code = 14;
      else if (word[0] == ':')
         resv_code = 15;
      else
         for (resv_code = 0; resv_code < TABLE_LEN; resv_code++)
            if (stricmp(word, RESV[resv_code]) == 0)  break;
   }
   else {
      CmdFileBuf[0] = CR;
      resv_code = TABLE_LEN;
   }
}         /* end of DecideReserveWord() */

/**************************************************************************
**
** Name : cre_label(s,s2)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

cre_label(s,s2)
char *s, *s2;
{
char *ptr = (char *) CmdFileBuf;
int i, ii, r;

   for (i = SUBMIT[which].lab_start; i < lab_ptr; i++)
      if (!strncmp(upLABEL[i].name, s+1, 10))  break;    /* label exists! */
   ii = SUBMIT[which].line_count;
   if (!s2[0])  ii++;
   else  skipdummy(CmdFileBuf, &ptr, 1);
   if (i < lab_ptr && upLABEL[i].lin_c != ii)  r = 7;
   else if (i >= lab_ptr) {
      if (lab_ptr < LABEL_SIZE) {
         strncpy(upLABEL[lab_ptr].name, s+1, 10);
         upLABEL[lab_ptr].lin_c = ii;
         upLABEL[lab_ptr].pos = ptr - CmdFileBuf;
         lab_ptr++;
         r = 0;
      }
      else  r = 39;
   }
   else  r = 0;
   return (r);
}         /* end of cre_label(s,s2) */

/**************************************************************************
**
** Name : CheckIF(s,code)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CheckIF(s,code)
char *s;
int code;
{
int i, j, r, len, cc;
char c, *dest, *src;
char *d_tmp;

   if (code == 1) {
      if (!d_buf[0])  return (0);
      dest = if_word[0] - 1;
      cc = 0;
      src = s - 1;
/* new! 1-14-87
for IF "   FLAG == DATA "    case */
      while (!isalnum(c = *++src))  ;
      src--;
      dd_ptr = d_buf;
      for (i = 0; i < IF_COUNT; i++)  if_word[i][0] = '\0';
      if_w_count = 0;
      do {
         c = *++src;
         if (!ispunct(c) && c != SP) {
            c = ch_toupper(c);
            if (cc < IF_WORD_LEN) {
               *++dest = c;
               cc++;
            }
         }
         else {
            *++dest = '\0';
            do
               c = *++src;
            while (c==SP || ispunct(c));   /* skip delimeters */
            if (c) {
               dest = if_word[++if_w_count] - 1;
               c = ch_toupper(c);
               *++dest = c;
               cc = 1;
            }
         }
      } while (c && if_w_count < IF_COUNT);
try_next:
      while ((r=match_1_w(0)) == 1)  ;
      if (r == -1)  return (0);
      d_tmp = dd_ptr;
      for (i = 1; i <= if_w_count; i++) {
         if ((r=match_1_w(i)) == -1)  return (0);
         if (r == 1) {
            dd_ptr = d_tmp;
            goto try_next;
         }
      }
      return (1);
   }
   else
/* for "GET" sub-command */
      return (!stricmp(cmd_file_get, s));
}         /* end of CheckIF(s,code) */

/**************************************************************************
**
** Name : match_1_w(no)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

match_1_w(int no) {
char c, patn[162];
int i, j, r;

   do
      c = *dd_ptr++;
   while (c == SP || c == LF || c == CR || ispunct(c));
   if (!c)  return (-1);
   dd_ptr -= 2;
   i = -1;
   do {
      c = *++dd_ptr;
      patn[++i] = c;
   } while (c != SP && c != LF && c && c != CR && !ispunct(c));
   patn[i] = '\0';
   return ((stricmp(if_word[no],patn)) ? 1 : 0);
}     /* end of match_1_w(no) */

/**************************************************************************
**
** Name : skipdummy(str, p_p, code)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

skipdummy(str, p_p, code)
char *str;
unsigned long *p_p;
int code;
{
char c, *ptr;

   ptr = str - 1;
second:
   while ( (c = *(++ptr)) == SP )  ;
   if (code) {
      while ((c = *(++ptr)) != SP && c != LF && c && c != CR)  ;
      if (c == LF || !c || c == CR)  return (1);
      code = 0;
      goto second;
   }
   *p_p = (unsigned long ) ptr;
   return (c == LF || c == '\0');
}         /* end of skipdummy(str, p_p, code) */

/**************************************************************************
**
** Name :  cmd_fgets()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

static cmd_fgets()
{
static char AltKeys[] = {
   KEY_AA, KEY_AB, KEY_AC, KEY_AD, KEY_AE, KEY_AF, KEY_AG, KEY_AH,
   KEY_AI, KEY_AJ, KEY_AK, KEY_AL, KEY_AM, KEY_AN, KEY_AO, KEY_AP,
   KEY_AQ, KEY_AR, KEY_AS, KEY_AT, KEY_AU, KEY_AV, KEY_AW, KEY_AX,
   KEY_AY, KEY_AZ
};
static struct AttentionKeyTag {
   char Char, Key;
} AttentionKeyTbl[] = {
   '1', KEY_F1,   '2', KEY_F2,   '3', KEY_F3,   '4', KEY_F4,    '5', KEY_F5,
   '6', KEY_F6,   '7', KEY_F7,   '8', KEY_F8,   '9', KEY_F9,    'A', KEY_F10,
   'U', KEY_UP,   'D', KEY_DN,   'L', KEY_LEFT, 'R', KEY_RIGHT, 'H',KEY_HOME,
   'E', KEY_END,  'I', KEY_INS,  'K', KEY_DEL,  'B', KEY_BACK
};
char buf[CMDFILEBUFSIZE+1], *ptr, ch, ch2;
int read_ok = FALSE, more_data;
int count = 0, i;

   while (fgets(buf, sizeof(buf)-1, SUBMIT[which].fd) != NULL) {
      read_ok = TRUE;
      if ( (ptr=strstr(buf, "\\\\")) != NULL ) {
         *ptr = '\0';
         more_data = TRUE;
      }
      else  more_data = FALSE;

   /*** convert special characters ***/
      for (ptr = buf; *ptr && count < sizeof(ond_cmd_line) - 2; ) {
         ch = *ptr;
         if      (ch == '\t')  ch = SP;
         else if (ch == '^')   ch = ESC;
         else if (ch == '~')   ch = KEY_ENTER;
         else if (ch == '?' && ptr[1]) {
            ptr++;
            if (isalpha(*ptr))
               ch = AltKeys[toupper(*ptr) - 'A'];
            else  ptr--;
         }
         else if (ch == '!' && ptr[1]) {
            ptr++;
            ch2 = toupper(*ptr);
            for (i = 0; i <
                 sizeof(AttentionKeyTbl)/sizeof(struct AttentionKeyTag); i++)
               if (ch2 == AttentionKeyTbl[i].Char) {
                  ch = AttentionKeyTbl[i].Key;
                  break;
               }
            if (i == sizeof(AttentionKeyTbl)/sizeof(struct AttentionKeyTag))
               ptr--;
         }
         ond_cmd_line[count++] = ch;
         ptr++;
      }  /* end of for */
      if (more_data && ond_cmd_line[count - 1] != SP)
         ond_cmd_line[count++] = ' ';   // append a space
      if (!more_data)  break;
   }  /* end of while */
   if (!read_ok)  return (FALSE);
   if (ond_cmd_line[count - 1] != LF)
      ond_cmd_line[count++] = '\n';
   ond_cmd_line[count] = '\0';
   return (TRUE);
}          /* end of cmd_fgets() */

/**************************************************************************
**
** Name : CheckCommandFileError()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CheckCommandFileError()
{
   if (error_abort) {
      if (usd_prn_ferr ||
          CheckIF("NOT READY",1) || CheckIF("NOT STEP",1) ||
          CheckIF("CAN'T STEP",1) || CheckIF("CAN`T STEP",1) ||
          CheckIF("BUS REQUESTING",1) || CheckIF("ERROR",1))
         return (CMD_F_ERROR);
   }
   return (OK);
}         /* end of CheckCommandFileError() */


/****************************** End of File ******************************/

