/***************************************************************************
**
** File name : complex.c for MICE-III
**
** A. Date -- 10/18/1992 By Cheerson
**     0. Received from Matthew's initial verson.
**     1. Add header and Docs.
**     2. Group externals, local define...
**     3. Delete all send_ESC calling.
**
** B. Date -- 10/24/1992 By Cheerson
**     0. Add a flag and two temp-counter to deal with the non-alignment
**        memory-dump/display.
**     1. Dump memory display start from offset 0.
**     2. Display SPACE if not the indicate address/memory-cell.
**     3. Add "DumpOneLine()" routine.
**
** C. Date -- 10/25/1992 By Cheerson
**     0. Rename "float_cmd()" to be "FloatCmd()".
**     1. Modify the FloatCmd routine.
**
** D. Date -- 10/27/1992 By Cheerson
**     0. Include "abi86.h" for the ABI's define and its externals.
**     1. Modify the Clear command.
**     2. Modify the Breakpoint command.
**     3. Modify the Compare command.
**
**
**    Copyright (C) 1992, 1993 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "funcext.h"
#include  "database.h"

#include "dialog.h"
#include "dad.h"
#include "errno.h"

#ifndef _ABI_FUNC_
#include "abifunc.h"
#endif

#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif

#ifndef _SD_ABI_
#include "sdabi.h"
#endif

#ifndef _ABI_EXTERNAL_
#include "abiexts.h"
#endif

#ifndef _LINUMDEF_
#include "linumdef.h"
#endif

#include "sdabiext.h"

/**************************************************************************
**
** Externals
**
**************************************************************************/
extern unsigned char dsm_buf[];
extern U16 int_regs[];    /* original 88 error, should be NUM_INT(128) */
extern U16 cop_regs[];    /* original 7, define NUM_COP1 in reg86.h */
extern U8  st_regs[8][10]; /*  define NUM_COP2 in reg86.h */
//extern char bno[];      /* MICE-III have not BUFFER command. */

extern U8 lineBuf[];  //6/14/1994
extern S16 cmdLineArgc; //6/14/1994
extern int ESCflag;
EXTERN char langMode, dspMode;
EXTERN U8 *actionStr[];
EXTERN S16 flagTotal;  //added by Frank, 4/14/1994, for 8086F CONTROL
EXTERN U8 **ctlName;   //updated by Frank, 4/14/1994, for 8086F CONTROL
// EXTERN QUALIFY qualifyRec;  //added by Frank.

// extern int COMVPMax;
/**************************************************************************
**
** Local define
**
***************************************************************************/

//#define NO_DIFF         ( -7)   /* No difference in memory compare */
/**************************************************************************
**
** Global variables
**
***************************************************************************/
char *cpuRegTable[] = {
   "AX", "BX", "CX", "DX", "SP", "BP", "SI", "DI",
   "DS", "SS", "ES", "CS", "IP", "FS", "OF", "DF",
   "IF", "TF", "SF", "ZF", "AF", "PF", "CF", "AL",
   "BL", "CL", "DL", "AH", "BH", "CH", "DH",
   NULL
};
char *copRegTable[] = {
   "CNTRLW", "STATUSW", "TAGW", "IPOFF", "CSSEL", "DATAOFF", "DATASEL",
   "ST0", "ST1", "ST2", "ST3", "ST4", "ST5", "ST6", "ST7", NULL
};
char *intRegMaster[] = {
   ""      ,"EOI"   ,"POLL"   , "POLSTS", "IMASK" ,"PRMSK", "INSERV","REQST",
   "INTSTS","TCUCON","DMA0CON","DMA1CON","I0CON" ,"I1CON" ,"I2CON" ,"I3CON",
   "T0CNT" ,"T0CMPA","T0CMPB" ,"T0CON"  ,"T1CNT" ,"T1CMPA","T1CMPB","T1CON" ,
   "T2CNT" ,"T2CMPA",""       ,"T2CON"  ,
   "UMCS"  ,"LMCS"  ,"PACS"   ,"MMCS"    ,"MPCS"  ,
   "D0SRCL","D0SRCH","D0DSTL","D0DSTH"  ,"D0TC"  ,"D0CON",
   "D1SRCL","D1SRCH","D1DSTL","D1DSTH"  ,"D1TC"  ,"D1CON",
   "RFBASE","RFTIME","RFCON" ,
   "PWRSAV","PWRCON",""      ,"STEPID"  ,""      ,""     , ""      ,"RELREG",
    NULL
};
char *intRegSlave[] = {
   "IVR"   ,"EOI"   ,"POLL"  , "POLSTS", "IMASK" ,"PRMSK", "INSERV","REQST",
   "INTSTS","TCUCON","DMA0CON","DMA1CON","I0CON" ,"I1CON" ,""     ,""      ,
   "T0CNT" ,"T0CMPA","T0CMPB" ,"T0CON"  ,"T1CNT" ,"T1CMPA","T1CMPB","T1CON" ,
   "T2CNT" ,"T2CMPA",""       ,"T2CON"  ,
   "UMCS"  ,"LMCS"  ,"PACS"  ,"MMCS"    ,"MPCS"  ,
   "D0SRCL","D0SRCH","D0DSTL","D0DSTH"  ,"D0TC"  ,"D0CON",
   "D1SRCL","D1SRCH","D1DSTL","D1DSTH"  ,"D1TC"  ,"D1CON",
   "RFBASE","RFTIME","RFCON" ,
   "PWRSAV","PWRCON",""      ,"STEPID"  ,""      ,""     , ""      ,"RELREG",
   NULL
};
char *intReg186EB[] = {
   ""      ,"EOI"   ,"POLL"  ,"POLSTS","IMASK" ,"PRMSK" ,"INSERV","REQST" ,
   "INTSTS","TCUCON","SCUCON","I4CON" ,"I0CON" ,"I1CON" ,"I2CON" ,"I3CON" ,
   "T0CNT" ,"T0CMPA","T0CMPB","T0CON" ,"T1CNT" ,"T1CMPA","T1CMPB","T1CON" ,
   "T2CNT" ,"T2CMPA",""      ,"T2CON" ,
   "P1DIR" ,"P1PIN" ,"P1CON" ,"P1LTCH","P2DIR" ,"P2PIN" ,"P2CON" ,"P2LTCH",
   "B0CMP" ,"B0CNT" ,"S0CON" ,"S0STS" ,"S0RBUF","S0TBUF",
   "B1CMP" ,"B1CNT" ,"S1CON" ,"S1STS" ,"S1RBUF","S1TBUF",
   "GCS0ST","GCS0SP","GCS1ST","GCS1SP","GCS2ST","GCS2SP","GCS3ST","GCS3SP",
   "GCS4ST","GCS4SP","GCS5ST","GCS5SP","GCS6ST","GCS6SP","GCS7ST","GCS7SP",
   "LCSST" ,"LCSSP" ,"UCSST" ,"UCSSP" ,"RELREG",
   "RFBASE","RFTIME","RFCON" ,"RFADDR","PWRCON",""      ,"STEPID",
   NULL
};

char *intReg186EC[] = {
   "MPICP0", "MPICP1", "SPICP0", "CPICP1", "",      "SCUIRL","DMAIRL","TIMIRL",
   "WDTRLDH","WDTRLDL","WDTCNTH","WDTCNTL",
   "T0CNT" ,"T0CMPA",  "T0CMPB", "T0CON" , "T1CNT" ,"T1CMPA","T1CMPB","T1CON" ,
   "T2CNT" ,"T2CMPA",  ""      , "T2CON" ,
   "P1DIR" ,"P1PIN" ,  "P1CON" , "P1LTCH", "P2DIR" ,"P2PIN" ,"P2CON" ,"P2LTCH",
   "B0CMP" ,"B0CNT" ,  "S0CON" , "S0STS" , "S0RBUF","S0TBUF",
   "B1CMP" ,"B1CNT" ,  "S1CON" , "S1STS" , "S1RBUF","S1TBUF",
   "GCS0ST","GCS0SP",  "GCS1ST", "GCS1SP", "GCS2ST","GCS2SP","GCS3ST","GCS3SP",
   "GCS4ST","GCS4SP",  "GCS5ST", "GCS5SP", "GCS6ST","GCS6SP","GCS7ST","GCS7SP",
   "LCSST" ,"LCSSP" ,  "UCSST" , "UCSSP" , "RELREG",
   "RFBASE","RFTIME",  "RFCON" , "RFADDR", "PWRCON","PWRSAV","STEPID",
   "D0SRCL","D0SRCH",  "D0DSTL", "D0DSTH", "D0TC",  "D0CON", "DMAPRI","DMAHALT",
   "D1SRCL","D1SRCH",  "D1DSTL", "D1DSTH", "D1TC",  "D1CON",
   "D2SRCL","D2SRCH",  "D2DSTL", "D2DSTH", "D2TC",  "D2CON",
   "D3SRCL","D3SRCH",  "D3DSTL", "D3DSTH", "D3TC",  "D3CON",
   NULL
};
U16 intervalFlag = 0;
U32 tillData, tillMem;
U16 tillReg,tillRegType;

int iBpNumber;  // added by Frank; 4/22, 1994
/**************************************************************************
**
** Local variables
**
***************************************************************************/
LOCAL U16 FlagsBit[] = {
   0x0800, 0x0400, 0x0200, 0x0100, 0x0080, 0x0040, 0x0010, 0x0004, 0x0001
};
LOCAL unsigned char fmtC186master[] = {
/* offset, count, visible_flag */
   0x20,   8,     0,1,0,1,1,1,1,1,
   0x30,   8,     1,1,1,1,1,1,1,1,
   0x50,   8,     1,1,1,1,1,1,1,1,
   0x60,   4,     1,1,0,1,
   0xA0,   5,     1,0,0,0,0,
   0xC0,   6,     1,1,1,1,1,1,
   0xD0,   6,     1,1,1,1,1,1,
   0xE0,   3,     1,1,1,
   0xF0,   8,     1,1,0,1,0,0,0,1,
   0xFF
};
LOCAL unsigned char fmtC186slave[] = {
/* offset, count, visible_flag */
   0x20,   8,     1,1,0,0,1,1,1,1,
   0x30,   8,     1,1,1,1,1,1,0,0,
   0x50,   8,     1,1,1,1,1,1,1,1,
   0x60,   4,     1,1,0,1,
   0xA0,   5,     1,0,0,0,0,
   0xC0,   6,     1,1,1,1,1,1,
   0xD0,   6,     1,1,1,1,1,1,
   0xE0,   3,     1,1,1,
   0xF0,   8,     1,1,0,1,0,0,0,1,
   0xFF
};
LOCAL unsigned char fmt186EB[] = {
/* offset, count, visible_flag */
   0x00,   8,     0,1,0,1,1,1,1,1,
   0x10,   8,     1,1,1,1,1,1,1,1,
   0x30,   8,     1,1,1,1,1,1,1,1,
   0x40,   4,     1,1,0,1,
   0x50,   8,     1,1,1,1,1,1,1,1,
   0x60,   6,     1,1,1,1,1,1,
   0x70,   6,     1,1,1,1,1,1,
   0x80,   8,     1,1,1,1,1,1,1,1,
   0x90,   8,     1,1,1,1,1,1,1,1,
   0xA0,   5,     1,1,1,1,1,
   0xB0,   7,     1,1,1,1,1,0,1,
   0xFF
};
LOCAL unsigned char fmt186EC[] = {
/* offset, count, visible_flag */
   0x00,   8,     1,1,1,1,0,1,1,1,
   0x20,   4,     1,1,1,1,
   0x30,   8,     1,1,1,1,1,1,1,1,
   0x40,   4,     1,1,0,1,
   0x50,   8,     1,1,1,1,1,1,1,1,
   0x60,   6,     1,1,1,1,1,1,
   0x70,   6,     1,1,1,1,1,1,
   0x80,   8,     1,1,1,1,1,1,1,1,
   0x90,   8,     1,1,1,1,1,1,1,1,
   0xA0,   5,     1,1,1,1,1,
   0xB0,   7,     1,1,1,1,1,1,1,
   0xC0,   8,     1,1,1,1,1,1,1,1,
   0xD0,   6,     1,1,1,1,1,1,
   0xE0,   6,     1,1,1,1,1,1,
   0xF0,   6,     1,1,1,1,1,1,
   0xFF
};
LOCAL char fileheader[] = "$SAVE_H/W_SETTINGS$$";
unsigned char my_buf[256];

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : DoubleCmd()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC DoubleCmd(unsigned long addr1)
{
double Get8Bytes();
double fff;
char str[30], *ptr, buf2[40];
int i, isESC=0;

   if (cmd_syntax.argc < 2) {
      while (1) {
         d_prnCSIP(addr1);
         if ((errorCode=emuGetMemN(addr1, my_buf, 8L)) != OK)
            return (errorCode);
         fff=Get8Bytes();
         gcvt( fff,10, str);
         sprintf(buf2,"   %-21s", str);
         DisplayStr(buf2);
         isESC = get_str2(buf2,30);
         if ( isESC == ESC ) {
            DisplayStr("\\\n\r");
            break;
         }
         DisplayStr("\n\r");
         if (( buf2[0] != CR ) && ( buf2[0] != LF )) {
            if (Set8Bytes(buf2) == FALSE) {
               DisplayStr(" Data error!\r\n");
               continue;
            }
            if ((errorCode=SdEmuSetMemN(addr1, my_buf, 8)) != OK)
            return (errorCode);
         }
         AdvanceAddr(&addr1, 8);
      }
   }
   else {
      for (i=0; i< addr_block.count; ) {
         ptr = addr_block.buff + i;
         if ((errorCode=SdEmuSetMemN(addr1, ptr , 8)) != OK)
            return(errorCode);
         i += 8;
         AdvanceAddr(&addr1, 8);
      }
   }
   return(OK);
}         /* end of doublecmd() */

/**************************************************************************
**
** Name :  FloatCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
FloatCmd(unsigned long addr1)
{
float Get4Bytes();
float fff;
char str[30], *ptr, buf2[40];
int i, isESC=0;

   if (cmd_syntax.argc < 2) {
      while ( 1 ) {
         d_prnCSIP(addr1);
         if ((errorCode=emuGetMemN(addr1, my_buf, 4L)) != OK)
            return(errorCode);
         fff=Get4Bytes();
         gcvt( (double) fff,10, str);
         sprintf(buf2,"   %-21s", str);
         DisplayStr(buf2);
         isESC = get_str2(buf2,30);
         if ( isESC == ESC ) {
            DisplayStr("\\\n\r");
            break;
         }
         DisplayStr("\n\r");
         if (( buf2[0] != CR ) && ( buf2[0] != LF )) {
            if (Set4Bytes(buf2) == FALSE) {
               DisplayStr(" Data error!\r\n");
               continue;
            }
            if ((errorCode=SdEmuSetMemN(addr1, my_buf, 4)) != OK)
               return(errorCode);
         }
         AdvanceAddr(&addr1, 4);
      }
   }
   else {
      for (i=0; i< addr_block.count; ) {
         ptr = addr_block.buff + i;
         if ((errorCode=SdEmuSetMemN(addr1, ptr , 4)) != OK)
            return(errorCode);
         i += 4;
         AdvanceAddr(&addr1, 4);
      }
   }
   return(OK);
}         /* end of floatcmd() */

/**************************************************************************
**
** Name : Set8Bytes(ptr)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE Set8Bytes(char *ptr)
{
char *p;
double d;

   p = index(ptr,CR);
   if (p) *p = '\0';       // DOS/16M
   d = strtod(ptr, &p);
   if (*p || (d == HUGE_VAL) || (d == -HUGE_VAL)) return (FALSE);
   memcpy(my_buf, &d, sizeof(d));
   return (TRUE);
}        /* end of Set8Bytes(ptr) */

/**************************************************************************
**
** Name : Set4Bytes(ptr)
**
** Function: Converts a string to a single precision floating point value,
**           and stores it to a 4-byte memory location.
**
**    Input  : pointer to string.
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE Set4Bytes(char *ptr)
{
char *p;
double d, d2;
float f;

   p = index(ptr,CR);
   if (p) *p = '\0';       // DOS/16M
   d = strtod(ptr, &p);
   d2 = fabs(d);
   if (*p || (((d2 < 1.175e-38 ) || (d2 > 3.4e38)) && d2)) return(FALSE);
   f = (float)d;
   memcpy(my_buf, &f, sizeof(f));
   return (TRUE);
}        /* end of Set4Bytes(ptr) */



/**************************************************************************
**
** Name     : DisassembleCmd()
**
** Function :
**
**   Input  :
**
**   Output :
**
** Notes    :
**
**************************************************************************/
DisassembleCmd(U32 addr, U32 len)
{
int line, count, dsize;
unsigned char *ptr;
char symbol[50], c;
U16 offset;

   DisplayStr("LOC       OBJ CODE       SOURCE CODE\r\n");
//   SetPutsBuf(NULL, 16, (len == 0x10000) ? 0 : -1);
// changed by Chen, 07/25/94
   SetPutsBuf(NULL, 16, (len >= 0xffff) ? 0 : -1);
   line = count = 0;

   while (len != 0) {
      if ( ((addr >> 16) * 0x10 + (addr & 0xffff)) >0xfffff) break;
    // Read memory data
      if (count == 0) {
         if (len > 256) count = 256;
		 else count = (len + 10 > 256) ? 256 : len + 10;
         if ((errorCode=GetMemWrap(addr, my_buf, count)) != OK)
            return(errorCode);
         ptr = my_buf;
      }
    // Disassembling
      if (dsmAddr2Sym(addr, symbol) == TRUE && symbol[1]) {
         sprintf(dsm_buf,"%17s%s:", "", symbol);   // append symbol line
         if (PutsMore(dsm_buf) == ESC) return;
      }
      dsize = Disassemble(addr, ptr, count, dsm_buf);
      if (dsize == 0) {    // code data is not enough
         count = 0;        // reset count to read new data
         continue;
      }
      if (PutsMore(dsm_buf) == ESC) return;
    // Update address, ...
        offset = (U16)(addr & 0x0000FFFF);
        addr = (addr & 0xFFFF0000) + ((addr + dsize) & 0x0000FFFF);   // wrap
        if (offset >= offset + dsize){
            offset += dsize;
            addr = ( (addr&0xFFFF0000)+0x10000000) + offset;
            count= 0;
         }
      len = (len > dsize) ? len - dsize : 0;
      if (count != 0) count -= dsize;
      ptr += dsize;
   }    // end of while

}   // end of DisassembleCmd()


/***************************************************************************
**
**  Name: DisassembleV20()
**
**  Description:
**     disassemble codes to get one line of instruction
**
**  Input:  address PC, code data, code length
**
**  Output: formatted instruction
**
**  Return: instruction length if codes are enough, 0 otherwise
**
****************************************************************************/
int validDis=0;
U32 dsmLoc[52];
U8  dsmBuffer[52][81];
int DisassembleV20(U32 curLoc, U8 *Buffer)
{
static U32 maskAddr = 0xFFFFFFFF;
U32  frame, offset, addr;
char c, *ptr,temp[80];
int i, ret;
char temp2[50], temp1[50], *ptr1; // Add by Gates Hua , Date : 02/17/1995
char temp3[50]; // Add by Gates Hua , Date : 02/17/1995
U16 ll; // Add by Gates Hua , Date : 02/17/1995
int ii; // Add by Gates Hua , Date : 02/17/1995


   curLoc &= maskAddr;
    if ( ADDR2ABS(curLoc) > 0xfffff ) {
        strcpy(Buffer, "(absolute address overflow)");
        return 1;
    }

   if ( !validDis || curLoc < dsmLoc[0] || curLoc > dsmLoc[validDis-1] )  {
        memset(dsmBuffer, NULL, sizeof(dsmBuffer));
        memset(dsmLoc, NULL, sizeof(dsmLoc));
      send_str2("D ");
      send_csip(curLoc);
      send_CR_wait(CR);
      while (receive() != CR);
      for (i=0;i < 51;) {
         ptr = dsmBuffer[i];
         while ((c=receive()) != CR && c != HAND_SHAKE) *ptr++ = c;
         *--ptr = NULL;
         if (c == HAND_SHAKE) {
            if (strstr(dsmBuffer[i], "More") == NULL) break;
                send_CR_wait(CR);
                continue;
         }

        if ( strstr(dsmBuffer[i], "Disassembly completed") != NULL ) {
            // Added by Gates, 02/17/95
            while (receive() != HAND_SHAKE);
            break;
        }

         if (dsmBuffer[i][0] == ' ') continue;
         if ( strstr(dsmBuffer[i], "LOC ") != NULL )
                continue;
         sscanf(dsmBuffer[i],"%lx:%lx", &frame, &offset);
         dsmLoc[i] = (U32)(frame << 16 & 0xFFFF0000) + (U32)(offset & 0xFFFF);
         i++;
      }
      validDis = i-1;
      send_ESC();
   }

   ret = FAIL;
   for (i=0; i<validDis; i++)
   if ( curLoc == dsmLoc[i] ) {
      ret = OK;
      break;
   }

   if ( Buffer != NULL ) {
      strcpy( Buffer, dsmBuffer[i] );

/*  Changed by Gates Hua , 02/17/1995
      if ( SymLoaded == OK && (ptr = strstr( Buffer, "CALL" )) != NULL ) {
         sscanf( ptr, "CALL     %lx:%lx", &frame, &offset );
         addr = (frame<<16 & 0xFFFF0000) + (offset & 0xFFFF);
         dsmAddr2Sym(addr, temp);
         ptr += 9;
         strcpy( ptr, temp );
      }
*/
// Add by Gates Hua , 02/17/1995
      if ( SymLoaded == OK ) {

           ll = strlen(Buffer);
           while( (ll>1)&&(Buffer[ll-1] == ' ') ) ll--;
           while( (ll>1)&&(Buffer[ll-1] != ' ') ) ll--;

           if (ll>1) {
               ptr1 = &Buffer[ll];
               strcpy(temp3,ptr1);

               ptr1 = temp3;
               ii = 0;
               c = *ptr1;
               while( ((c>='0')&&(c<='9'))||((c>='A')&&(c<='F'))||((c>='a')&&(c<='f')) ) {
                   ptr1++;
                   c = *ptr1;
                   ii++;
               }
               if ( (ii==4)&&(c==':') ) {
                   sscanf(temp3,"%lx:%lx", &frame ,&offset);
                   addr = (frame<<16 & 0xFFFF0000) + (offset & 0xFFFF);
                   if (dsmAddr2Sym(addr, temp2)==TRUE && temp2[1]) {
                       strcpy(temp1,&temp3[9]);
                       strcpy(temp3,temp2);
                       strcat(temp3,temp1);
                   }
               }
               if ((ptr1=strstr(temp3,",")) != NULL) {
                   ptr1++;
                   ii = 0;
                   c = *ptr1;
                   while( ((c>='0')&&(c<='9'))||((c>='A')&&(c<='F')) ) {
                       ptr1++;
                       c = *ptr1;
                       ii++;
                   }
                   if ( (ii==4)&&(c==':') ) {
                       ptr1=strstr(temp3,",");
                       ptr1++;
                       sscanf(ptr1,"%lx:%lx", &frame ,&offset);
                       addr = (frame<<16 & 0xFFFF0000) + (offset & 0xFFFF);
                       if (dsmAddr2Sym(addr, temp2)==TRUE && temp2[1]) {
                           ptr1 += 9;
                           strcpy(temp1,ptr1);
                           ptr1 -= 9;
                           strcpy(ptr1,temp2);
                           strcat(temp3,temp1);
                       }
                   }
               }
               strcpy(&Buffer[ll] , temp3);
           }
      }

   }

   if ( ret == OK )
      return(dsmLoc[i+1]-dsmLoc[i]);
   else
      return 1;  // unreachable statement !

}   // end of DisassembleV20()


/**************************************************************************
**
** Name     : TransDisassembleCmd()
**
** Function : support INTEL 286
**
**   Input  :
**
**   Output :
**
** Notes    :
**
**************************************************************************/
// added by Chen, 07/20/94
// Mr. Liu told us to rewrite the Assemble and Disassemble command by using
// transparent mode in order to support INTEL 286.
// This routine is only for Disassemble command of INTEL 286 model, and it
// must be completed in order to support uploading action, such as
// "PutOneAsmRowinBuf()" in SLD.C
//
int TransDisassembleCmd(U32 addr, U32 len)
{
char *ptr, c, key;
U32  frame, offset, addr1;
char temp2[50], temp1[50], *ptr1; // Add by Gates Hua , Date : 02/17/1995
char temp3[50], ccc; // Add by Gates Hua , Date : 02/17/1995
U16 ll; // Add by Gates Hua , Date : 02/17/1995
int ii; // Add by Gates Hua , Date : 02/17/1995

    send_str2("D ");
    send_csip(addr);
    if ( len > 0 ) {
        if ( len >= 0x10000 )
            len = 0xffff;
        send_str2(" L ");
        send_long(len);
    }
    send(CR);
    for (;;) {
        key = chk_hlt();
        if ( key == ESC || ESCflag ) {
            ESCflag = 0;
            send_ESC();
            DisplayStr("\n\r");
            break;
        }
        ptr = tx_buf;
        while ( (c=receive()) != HAND_SHAKE && (c != CR) && !ESCflag )
            *ptr++ = c;
        if ( ESCflag ) {
            ESCflag = 0;
            send_ESC();
            DisplayStr("\n\r");
            break;
        }
        *ptr = NULL;
        if ( c == HAND_SHAKE && *--ptr == '>' )
            break;

// Add by Gates Hua , Date : 02/17/1995
      if ( SymLoaded == OK ) {
           ccc = c;

           ll = strlen(tx_buf);
           while( (ll>1)&&(tx_buf[ll-1] == ' ') ) ll--;
           while( (ll>1)&&(tx_buf[ll-1] != ' ') ) ll--;

           if (ll>1) {
               ptr1 = &tx_buf[ll];
               strcpy(temp3,ptr1);

               ptr1 = temp3;
               ii = 0;
               c = *ptr1;
               while( ((c>='0')&&(c<='9'))||((c>='A')&&(c<='F'))||((c>='a')&&(c<='f')) ) {
                   ptr1++;
                   c = *ptr1;
                   ii++;
               }
               if ( (ii==4)&&(c==':') ) {
                   sscanf(temp3,"%lx:%lx", &frame ,&offset);
                   addr1 = (frame<<16 & 0xFFFF0000) + (offset & 0xFFFF);
                   if (dsmAddr2Sym(addr1, temp2)==TRUE && temp2[1]) {
                       strcpy(temp1,&temp3[9]);
                       strcpy(temp3,temp2);
                       strcat(temp3,temp1);
                   }
               }
               if ((ptr1=strstr(temp3,",")) != NULL) {
                   ptr1++;
                   ii = 0;
                   c = *ptr1;
                   while( ((c>='0')&&(c<='9'))||((c>='A')&&(c<='F')) ) {
                       ptr1++;
                       c = *ptr1;
                       ii++;
                   }
                   if ( (ii==4)&&(c==':') ) {
                       ptr1=strstr(temp3,",");
                       ptr1++;
                       sscanf(ptr1,"%lx:%lx", &frame ,&offset);
                       addr1 = (frame<<16 & 0xFFFF0000) + (offset & 0xFFFF);
                       if (dsmAddr2Sym(addr1, temp2)==TRUE && temp2[1]) {
                           ptr1 += 9;
                           strcpy(temp1,ptr1);
                           ptr1 -= 9;
                           strcpy(ptr1,temp2);
                           strcat(temp3,temp1);
                       }
                   }
               }
               strcpy(&tx_buf[ll] , temp3);
           }

           ptr1 = tx_buf;
           ii = 0;
           c = *ptr1;
           while( ((c>='0')&&(c<='9'))||((c>='A')&&(c<='F'))||((c>='a')&&(c<='f')) ) {
               ptr1++;
               c = *ptr1;
               ii++;
           }
           if ( (ii==4)&&(c==':') ) {
               sscanf(tx_buf,"%lx:%lx", &frame ,&offset);
               addr1 = (frame<<16 & 0xFFFF0000) + (offset & 0xFFFF);
               if (dsmAddr2Sym(addr1, temp2)==TRUE && temp2[1]) {
                   ll = strlen(temp2);
                   temp2[ll] = 0x0A;
                   temp2[ll+1] = NULL;
                   sprintf(temp1,"                    ");
                   DisplayStr(temp1);
                   DisplayStr(temp2);
               }
           }
           c = ccc;
      }

        DisplayStr(tx_buf);
        if ( c == HAND_SHAKE && strstr(tx_buf,"[ More ]") != NULL ) {
            for (;;) {
                if ( cmdfile_flag ) {
                    GetOneLineFromCmdFile();
                    key = CmdFileBuf[0];
                }
                else {
                    key = get_key();
                }
                if ( key == ESC ) {
                    send_ESC();
                    DisplayStr("\r\n");
                    return (OK);
                }
                if ( key == SPACE || key == CR )  {
                    send(key);
                    while (receive() != CR);
                    while (receive() != CR);
                    DisplayStr("\r\n");
                    break;
                }
            }
        }
    }
    return (OK);

}   // end of TransDisassembleCmd()



/**************************************************************************
**
** Name     : AssembleCmd()
**
** Function : support INTEL 80186
**
**   Input  :
**
**   Output :
**
** Notes    :
**
**************************************************************************/
AssembleCmd(U32 addr)
{
U8 *codebuf;
S8 input[80], temp[80];
int codebufsize, errcode, i;
U16 offset;

   for (codebufsize = 0x7FFF; 1; codebufsize >>= 1)
      if ( (codebuf=(U8 *)malloc(codebufsize)) != NULL )  break;
      memset(codebuf, '\0', codebufsize);
   DisplayStr("LOC               SOURCE CODE\r\n");
   while (1) {
      if ( ((addr >> 16) * 0x10 + (addr & 0xffff)) >0xfffff) break;
      d_prnCSIP(addr);
      DisplayStr("         ");
      i = get_str2(input, sizeof(input) - 2);
      if (i == ESC) {
         DisplayStr("\\\r\n");
         break;
      }
      DisplayStr("\r\n");

      i = codebufsize;
      errcode = Assemble(addr, input, codebuf, &i);
      if (errcode == ASM_DEFSTORAGE)   // pseudo instruction DS
         addr = (addr & 0xFFFF0000) + ((addr + i) & 0x0000FFFF);
      else if (errcode != ASM_OK) {   // error!
       //  sprintf(temp," %s\r\n",asmErrorMsg(errcode));
         DisplayStr(" Assemble Error.\n\r");
      }
      else if (i > 0) {   // not null instruction
         if ((errorCode=SetMemWrap(addr, codebuf, i)) != OK)
            return (errorCode);
        offset = (U16)(addr & 0x0000FFFF);
        addr = (addr & 0xFFFF0000) + ((addr + i) & 0x0000FFFF);   // wrap
        if (offset >= offset + i){
            offset += i;
            addr = ( (addr&0xFFFF0000)+0x10000000) + offset;
         }
      }
   }
   free(codebuf);
   return(OK);
}   // end of AssembleCmd()


/**************************************************************************
**
** Name     : TransAssembleCmd()
**
** Function : support INTEL 286
**
**   Input  :
**
**   Output :
**
** Notes    :
**
**************************************************************************/
// added by Chen, 07/20/94
// Mr. Liu told us to rewrite the Assemble and Disassemble command by using
// transparent mode in order to support INTEL 286.
//
int TransAssembleCmd(U32 addr)
{
char *ptr, c, input[40];
int i;

    memset(input, NULL, sizeof(input));
    send_str2("A ");
    send_csip(addr);
    send(CR);
    for (;;) {
        ptr = tx_buf;
        while ( (c=receive()) != HAND_SHAKE && c != CR )
            *ptr++ = c;
        *ptr = NULL;
        DisplayStr(tx_buf);
        if ( c == HAND_SHAKE ) {
            i = get_str2(input, sizeof(input)-2);
            if ( i == ESC ) {
                DisplayStr("\\\r\n");
                send_ESC();
                break;
            }
            ptr = strtok(input, "\r\n");
            if ( ptr != NULL ) {
                ptr = input;
                while ( c = *ptr++ ) {
                    send(c);
                    receive();
                }
            }
            send(CR);
        }
    }
    return(OK);

}   // end of TransAssembleCmd()





/**************************************************************************
**
** Name : StepCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE StepCmd()
{
U32 addr;

  /* Step [Over] addr1 addr2 */
   if (cmd_syntax.argc == 3 || cmd_syntax.argc == 4) {
      if (!addr_block.CSflag1) {
         emuGetReg(I86_REG, CS, &addr);
         addr = (addr << 16) + addr_block.addr1;
      } else addr = addr_block.addr1;
      if (CheckOverflow((U16)(addr>>16), (U16)addr)) return( ABS_OVERFLOW );
   }
   switch (cmd_syntax.argc) {
      case 3 : /* step range / addr1 addr2 */
         errorCode = StepRangeCmd(0,addr,addr+addr_block.length-1);
         break;
      case 4 : /* step Over & range within / addr1 addr2 */
         errorCode = StepRangeCmd(1,addr,addr+addr_block.length-1);
         break;
      case 5 : /* step till return */
         if (langMode != HIGH) errorCode = StepInstructions(2,-1L,1);
//		   else if (StepInstructions(7, 1L, 0) == FAIL)
		 else if (StepInstructions(7, -1L, 1) == FAIL)
//				   errorCode = StepInstructions(2, -1L, 0 );
                 errorCode = StepInstructions(2, -1L, 1 );
         break;
      case 6 : /* step till call */
         errorCode = StepInstructions(3,-1L,1);
         break;
      case 7 : /* step till mem=?? */
         tillMem = addr_form.addr;
         tillData = cmd_syntax.argv[0];
         errorCode = StepInstructions(5,-1L,1);
         break;
      case 8 : /* step till reg_id=????   */
         tillReg = (U16) cmd_syntax.argv[1];
         tillRegType = (U16) cmd_syntax.argv[2];
         tillData = cmd_syntax.argv[0];
         errorCode = StepInstructions(4,-1L,1);
         break;
      case 9 : /* step till PC=????   */
         tillData = cmd_syntax.argv[0];
         errorCode = StepInstructions(6,-1L,1);
         break;
      default: /* case 1 : step count,  case 2 : step Over/Call */
         if (langMode != HIGH)
            errorCode = StepInstructions(cmd_syntax.argc-1,
                                         (long)cmd_syntax.argv[0], 1);
         else errorCode = StepStatements(cmd_syntax.argc-1,
                                         (long)cmd_syntax.argv[0]);
   }
//   if (COMVPMax)  UpdateCODVP(-1);
   return(errorCode);
}  /* end of StepCmd() */

/**************************************************************************
**
** Name : StepStatements()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE RETCODE StepStatements(U8 flag, S32 count)
{
S32 ii;
U32 addr, addr2;
FLAG flag1;
U8 temp[80];
RETCODE ret;

   errorCode = OK;
   flag1 = flag ? 1 : 2;
   for ( ii=0; ;ii++ ) {
      if ((count > 0 && ii >= count) || errorCode != OK) break;
      if (chk_hlt() == ESC) break;
      emuGetReg(I86_REG, REG_PC, &addr);
      if (dspMode != HIGH) errorCode = StepInstructions(flag, 1L, 0);   // single step
      else if ((ret=GetAddressRange( addr, &addr2 )) == FAIL)
         errorCode = StepInstructions(flag, 1L, 0);  // single step
      else if (ret == LASTLINE) {
         if (StepInstructions(7, 1L, 0) == FAIL)
            errorCode = StepInstructions(flag, 1L, 0 );
      }
      else errorCode = StepRangeCmd( flag1, addr, addr2);
      emuGetReg(I86_REG, REG_PC, &addr);
      sprintf(temp,"\r %lX steps encountered", 1+ii);
      DisplayStr(temp);
      if (ChkBreak(addr) != -1 ) {
         sprintf(temp,"\r\n SW bkpt at %04X:%04X is encountered",
                 (U16)(addr>>16), (U16)addr );
         DisplayStr(temp);
         break;
      }
   }
   DisplayStr("\r\n");
   return(errorCode);
}

/**************************************************************************
**
** Name : StepInstructions()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
StepInstructions(U8 flag, long count, int displayFlag)
{
U32 addr, oldSP, newSP, addr1;
int j, insType, stepDone;
U32 nextAddr;
U8 tmpBuf[80], offset, updateFlag=FALSE;
U32 tmpReg, max;
int stepForever;
long i;
BLOCK_INFO blkInfo;
int ret;
U32 addr2;
int key;

   if (flag == 7 && GetLevelRetAddr(0,1,&nextAddr,&addr1) == FAIL)
		return(FAIL);

   if (count == -1) stepForever=1;
   else stepForever=0;
   stepDone = 0;

   for (i=0;;i++) {
      if (!stepForever) {
        if (i >= count) break;
      }   /* i must be 1*/

      emuGetReg(I86_REG, REG_PC,&addr);
// marked by Chen, 07/11/94
//      emuGetReg(I86_REG, REG_SP, &oldSP);

      switch (flag) {
      case 0:
         if (dspMode != langMode) {
            emuGetMemN(addr, tmpBuf, 8L);
            insType = IsStepCall(addr, tmpBuf, &nextAddr);
            if (insType == 1 || insType == 3) updateFlag = TRUE;
         }
         errorCode=emuStepOne();
         break;
      case 1: /* step over */
         emuGetMemN(addr, tmpBuf, 8L);
         insType = IsStepCall(addr, tmpBuf, &nextAddr);
//		   if (insType == 1 || insType == 3 || insType == 4 || insType == 5) {
		 if (insType == 1 || insType == 4 || insType == 5) {
            if ((errorCode=emuRunUntil(nextAddr)) != OK) break;
		 } else if (insType == 3){
			DisplayStr( " Cannot Step over Correctly, run \"Breakpoint & Go\" to skip.\n\r");
			displayFlag = 0;
		 }
		 else errorCode=emuStepOne();
         break;
      case 2: /* step till RET */
         emuGetMemN(addr, tmpBuf, 8L);
         insType = IsStepCall(addr, tmpBuf, &nextAddr);
         if (insType == 1 || insType == 3 || insType == 4 || insType == 5) {
			if ((errorCode=emuRunUntil(nextAddr)) != OK) break;
         } else errorCode=emuStepOne();
         if (insType == 2) stepForever = 0;
         break;
      case 3: /* step till CALL */
         emuGetMemN(addr, tmpBuf, 8L);
         insType = IsStepCall(addr, tmpBuf, &nextAddr);
         if (insType == 1 || insType == 3) stepDone = 1;
         else errorCode=emuStepOne();
         break;
      case 4: /*step till @reg_id=???? */
         max = (( tillRegType == I86_REG && tillReg <= FLAGS ||
                  tillRegType >= I87_REG ) ? 0xFFFF :
                  (tillRegType == I86_REG && tillReg <= CF) ? 1 : 0xFF );
         if (tillData > max) {
            if (displayFlag) DisplayStr(" Hex data error!\r\n");
            return(OK);
         }
         GetRegister(tillRegType, tillReg, &tmpReg);
         if ((tmpReg & max) == tillData) stepDone = 1;
		 else errorCode=emuStepOne();
         break;
      case 5: /* step till mem=???? */
         emuGetMemN(tillMem, tmpBuf, 1L);
         if (tmpBuf[0] == (U8)tillData) stepDone = 1;
         else errorCode=emuStepOne();
         break;
      case 6: /* step till PC=????? */
         emuGetReg(I86_REG, REG_PC, &tmpReg);
         addr = ((tmpReg & 0xffff0000) >> 12) + (tmpReg & 0xffff);
         if (addr == tillData) stepDone = 1;
         else errorCode=emuStepOne();
         break;
      case 7:  //High Level step till return
	  //   errorCode = emuRunUntil(nextAddr);
		  key = chk_hlt();
		  if ( key == ESC || ESCflag ) {
			 ESCflag = 0 ;
			 goto halt;
		  }
		  if ((ret=GetAddressRange( addr, &addr2 )) == FAIL)
			 goto halt;
		  else errorCode = StepRangeCmd( 1, addr, addr2);
		  emuGetReg(I86_REG, REG_PC,&addr);
		  if (addr == nextAddr) goto halt;
	 }	/* end of switch */

      if (errorCode != OK) break;
      if (displayFlag) {
         offset = stepDone ? 0 : 1;
         sprintf(tmpBuf,"\r %lX steps encountered", i+offset);
         DisplayStr(tmpBuf);
      }
      if (stepDone || (errorCode=emuGetAllReg(cpuReg)) != OK ) break;
//      emuGetReg(I86_REG, REG_SP,&newSP);
//      if (oldSP != newSP)
//         RedrawFlag = REDRAWREG+REDRAWCOD+REDRAWDAT+REDRAWSTA;
//      else
//         RedrawFlag = REDRAWREG+REDRAWCOD+REDRAWDAT;
// marked by Chen, 07/11/94. The stack viewport must be updated everytime.
      RedrawFlag = REDRAWREG+REDRAWCOD+REDRAWDAT+REDRAWSTA;
      if (!updateFlag)
         MarkNewPCinCodeVP();  // if needn't reset codeVP, REDRAWCOD is masked off
      if (RedrawFlag & REDRAWCOD) {   /* need reset code viewport ? */
         UpdateCODVP(-1);
         RedrawFlag &= ~REDRAWCOD;
      }

      UpdateVP();
      emuGetReg(I86_REG, REG_PC,&addr);
      if (ChkBreak(addr) != -1) {
         if (displayFlag) {
            sprintf(tmpBuf,"\r\n SW bkpt at %04X:%04X is encountered",
                    (U16)(addr>>16), (U16)addr );
            DisplayStr(tmpBuf);
         }
         break;
      }
   }  /* end of for */


halt:
   if (displayFlag ) DisplayStr("\r\n");
   if (errorCode == HALT_USER) {
      RedrawFlag = REDRAWREG+REDRAWCOD+REDRAWSTA+REDRAWDAT;
      MarkNewPCinCodeVP();  // if needn't reset codeVP, REDRAWCOD is masked off
      if (RedrawFlag & REDRAWCOD) {   /* need reset code viewport ? */
         UpdateCODVP(-1);
         RedrawFlag &= ~REDRAWCOD;
      }
      UpdateVP();
      return(OK);
   } else return(errorCode);
}       /* end of StepInstructions() */

/**************************************************************************
**
** Name :StepRangeCmd
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
StepRangeCmd(U8 flag, U32 addr1, U32 addr2)
{
U32 addr;
U16 i, j, i2, i3;
U32 nextAddr, prevAddr;
U8 tmpBuf[200];
BLOCK_INFO blkInfo;
U32 tmpBufSize;
U32 blockEndAddr;
U32 tempEndAddr;
U32 dummy;
int modNum;
char modName[41];
int ASMflag = 0;
int direction = 1;

	 if (addr1 == addr2){
		 j = emuStepOne();
		 emuGetAllReg(cpuReg);
		 goto endDeal;
	 }

	 else if (addr2 > addr1) {
		tmpBufSize = addr2 - addr1+1;
		if (tmpBufSize > 0x50) tmpBufSize = 0x50;
	  }
	 else{
		tmpBufSize = 30L;
		direction = -1;
	 }

	 emuGetMemN(addr1, tmpBuf, tmpBufSize);
	 i = IsStepCall2(addr1, tmpBuf, &prevAddr, &nextAddr, tmpBufSize-1,
		  direction);
     emuGetReg(I86_REG, REG_PC,&addr);
	 i3 = GetBlockInfo( addr1, &blkInfo);
	 blockEndAddr = blkInfo.endAddr;
	 if (IdentifyCurrentModule(TRUE, addr1, &modNum,
		  modName, &dummy, &dummy) == OK && i3 == FAIL)
		  ASMflag = 1;

	 switch (i) {
		   case 1:	// CALL extern_func()
				 if (flag == 1) //step over
					 j = emuRunUntil(nextAddr);
				 else{
					 j = emuStepRange(addr1, addr2);
		   //		 if (flag != 2 || langMode != HIGH) break;
		   //		 emuGetReg(I86_REG, REG_PC,&addr);
		   //		 if ((addr < addr1 || addr > addr2+1) &&
		   //			  GetBlockInfo(addr, &blkInfo) == FAIL){
		   //				  emuRunUntil(addr2+1);
		   //		  }
				 }
				 break;
		   case 2: //RET/RETF/IRET
				 if (GetBlockInfo( addr, &blkInfo) == OK)
					j = emuStepRange(addr, blkInfo.endAddr);
				 else j = emuStepOne();
				 break;
		   case 3: //INT
				 DisplayStr( "  exist INTERRUPT, please SKIP,\n\r" );
				 DisplayStr( "  or change MODE to ASM and trace into it.\n\r");
				 return(OK);
		   case 4: //LOOP
		   case 5: //REPZ/REPNZ
				   j = emuRunUntil(nextAddr);
			  //   j = emuStepRange(addr1, addr2);
				 break;
		   case 6: //JMP , sometimes jump here and there in one line.
				  if (prevAddr == addr1)
					 j = emuStepOne();
				  else if ( addr1 < addr2 )
					 j = emuStepRange(addr1, addr2);
				  else {
					   j = emuRunUntil(prevAddr);
					   j = emuStepOne();
				  }
				  break;
		   case 7:
				  j = emuRunUntil(nextAddr);
				  break;
		   case 0:
				  if (addr1 < addr2)
					  j = emuStepRange(addr1, addr2);
				  else
					  j = emuStepOne();
				  break;
		  default: break;
	 }
	 while (ASMflag == 0 && i != 2){
		   emuGetReg(I86_REG, REG_PC,&addr);
		   i2 = GetBlockInfo( addr, &blkInfo);
		   tempEndAddr = blkInfo.endAddr;
		   if ( (addr < addr1 || addr > addr2) && i2 == OK
			   && blkInfo.endAddr == blockEndAddr ) break;
		   if ( i2 == FAIL){
			   j = emuStepOverRange(addr, addr+50);
		   }
		   else if ( blkInfo.endAddr != blockEndAddr ){
			   if (flag == 1 ){ //step over
					j = emuStepOverRange(addr, blkInfo.endAddr);
			   }
			   else break;
		   }
		   emuGetReg(I86_REG, REG_PC,&addr);
		   if (addr > addr1 && addr < addr2)
			  j = emuStepOverRange(addr, addr2);
		   else if (addr == addr1 || addr == addr2)
			  j = emuStepOne();
	 }

endDeal:
   errorCode = j;
   RedrawFlag = REDRAWREG+REDRAWCOD+REDRAWSTA+REDRAWDAT;
   MarkNewPCinCodeVP();   // if needn't reset codeVP, REDRAWCOD is masked off
   if (RedrawFlag & REDRAWCOD) {   /* need reset code viewport ? */
      UpdateCODVP(-1);
      RedrawFlag &= ~REDRAWCOD;
   }
   UpdateVP();
   return(j);
}       /* end of StepRangeCmd() */



#define   SEARCH  99
U8    oldBuf[80];  // 06/28/1994 James - Get rid of duplicated line.
S16   search_flag = 0;
int moreFlag = 0;
extern int nTurnCnt;

// Moved to global var by James 12/26/1994
   U32 oldaddr = 0x0;
/**************************************************************************
**
** Name : List
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC RETCODE ListCmd()
{
   char *ptr, key, c;
   int i, sub;
   char tmpBuf[512];
   unsigned int cnt=0, james=0;
//   U32 oldaddr = 0xfffff;
   S16 ret, lAttr;

   oldBuf[0] = '\0';  // 06/28/1994 James Wang
   tmpBuf[0] = '\0';
   lAttr = 0xffff;
   moreFlag = 0;
   search_flag = 0;
   send_ESC();

   switch (cmd_syntax.argc) {
         case 0:   /* List */
            send('L');
            break;
         case 1:   /* List Number */
            send_str2("L N");
            break;  // argv[0] = 1,      2,     3,     4
         case 2:   /* List {INstruction|MIxed|SOurce|MOdule} [frame] */
            lAttr = cmd_syntax.argv[0];
            if (cmd_syntax.argv[0] >= 2 && cmd_syntax.argv[0] <= 4)  {
                if ( SymLoaded == FAIL ) {
                    DisplayStr(" Symbol loaded in failure!\n\r");
                    return (OK);
                }   // added by Chen, 07/06/94
                send_str2("L I ");
            }
            else send_str2("L I ");
            if (cmd_syntax.argv[1] >= 0) send_word((U16) cmd_syntax.argv[1]);
            break;
         case 3:   /* List frame [abs1 abs2] [status] [trace_bits] */
            send_str2("L ");
            send_word((U16) cmd_syntax.argv[0]);
			if ( cmd_syntax.argv[2] > 0 ){
                send(' ');
                for (i=4; i >= 0; i--) {
                    c=(cmd_syntax.argv[1]>>i*4)&0xf;
                    send(hex[c]);
                }
                send(' ');
                for (i=4; i >= 0; i--) {
                    c=(cmd_syntax.argv[2]>>i*4)&0xf;
                    send(hex[c]);
                }
            }
            if (cmd_syntax.argv[3] > 0) send_stat((U16) cmd_syntax.argv[3]);
			if ( cmd_syntax.argv[4] == 1){
				 if ( LAM2 ) send_str2(" EXT");
				 send(' ');
				 send_str2(cmd_syntax.asc);
			}
            break;
         default:
            break;
   }
   send_CR_wait(CR);
   for (;;) {
         if (chk_hlt() == ESC || ESCflag) {
              ESCflag=0;
              send_ESC();
              break;
         }
         ptr = tx_buf;
         while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
         *ptr = NULL;
        if ( strstr(tx_buf,"empty") != NULL ) {
            DisplayStr(tx_buf);
            continue;
        }   // added by Chen, 07/06/94
        if ( tx_buf[0] == '>' || tx_buf[3] == '>' ) {
               send_ESC();
               send_ESC();
               break;
        }   // Frank 06/27/94 ; tx_buf[3] for "RUN>"
        //  05/27/1994 James Wang
         if ( cmd_syntax.argc == 2 && lAttr == 1 )
            ChkSymIn();
         else if ( cmd_syntax.argc == 2 && lAttr >=2 && lAttr <= 4 ) {
            if ( (ret = ChkSrcIn(tmpBuf, &oldaddr)) == OK || ret == SEARCH ) {
               if ( lAttr != 2 && !james && ret != SEARCH && cnt != 12 )
                  cnt++;
               if ( search_flag ) {
                    if ( ret != SEARCH ) {
                        search_flag = 0;
                        nTurnCnt = 0;
                        DisplayStr(tmpBuf);
                    }
                    else {
                     if ( moreFlag ) {
                        moreFlag = 0;
                        EraseTurn();
                        DisplayStr("\r\n");
                     }
                     DisplayTurn();
                  }
               }
               else
                  DisplayStr(tmpBuf);
            }
         }
         if ( ( lAttr != 3 && lAttr != 4 )
         || (strstr(tx_buf,"[ More ]") != NULL && cnt == 12) ) { // 06/23 James
            if ( search_flag ) {
                EraseTurn();
                DisplayStr("\r\n");
            }
            DisplayStr(tx_buf);
         }
         if (strstr(tx_buf,"[ More ]") != NULL && (cnt == 12
              || (lAttr != 3 && lAttr != 4)) ) {
                moreFlag = 1;
              for (;;) {
                  if ( cmdfile_flag ) {     // Chen 05/31/94
//                        GetOneLineFromCmdFile();
//                        key = CmdFileBuf[0];
//                        key = CR;
                        key = ESC;
                  }
                  else  key = get_key();
                  if (key == ESC) {
                        DisplayStr("\r\n");
                        send_ESC();
                        return(OK);
                  }
                  if (key == SPACE || key == CR)  {
                        send(key);
                        while (receive() != CR);
                        while (receive() != CR);
                        if ( (lAttr != 3 && lAttr != 4) || cnt == 12 ) // James
                           DisplayStr("\r\n");
                        if ( cnt == 12 ) cnt = 0; // james
                        if (key == SPACE && (lAttr == 3 || lAttr == 4) )
                           james = 1;
                        break;
                  }
              }
         }
   }

   EraseTurn();
   DisplayStr("\r\n");
   send_ESC();
   return(OK);

}  /* end of ListCmd() */


#include "usym3.h"   // 05/27/1994 James Wang
/**************************************************************************
**
** Name : ChkSymIn
**
** Function    Replace of addr with symbol name for tx_buf, if addr is a
**             routine name. on List Instruction mode.
**
**    Input  : tx_buf
**
**    Output : tx_buf
**
** Notes:      Programming by James Wang
**
**************************************************************************/
PUBLIC RETCODE ChkSymIn( VOID )
{
int ItemNo;
int i;
U8  *ptr = NULL, *ptr1 = NULL, *ptr2 = NULL, Symbol[50];
static U8 HexArr[] = "0123456789ABCDEF";
U32 absaddr = 0;
static U8 symSGN = '%';

   if ( tx_buf[0] == '\0' ) return(1);
   ptr = tx_buf;
   while ( *ptr != '\0' ) {
      if ( *ptr == 'J' || ( *ptr == 'C' && *(ptr+1) == 'A' ) ) {
         ptr += 9;
         break;
      }
      else ptr++;
   }
   if ( *ptr == '\0' ) return(1);
   ptr1 = ptr;
   for (i=0; i<5; i++)
      if ( (ptr2 = strchr(HexArr, *ptr1)) == NULL ) return(1);
      else {
//         absaddr = absaddr*16 + (ptr2-HexArr);
         absaddr = (U32)((absaddr*16) & 0x000FFFFF)
                     + (U32)((ptr2-HexArr) & 0x000FFFFF);
         ptr1++;
      }
   absaddr &= 0x000FFFFF;
   for (i=0; i<4; i++)
      comsym.addr[i] = (U8) ( (absaddr >> (8 * (3-i))) & 0x000000FF);
   comsym.mask = MSK_ABS;
   if ( AddrToSym(&ItemNo) == FALSE ) return(1);
   sprintf(Symbol,"%c%s ;[%05lX]", symSGN, comsym.name, absaddr);
   strcpy(ptr, Symbol);
   strcat(tx_buf,"\r\n");

   return(1);
}


/**************************************************************************
**
** Name : ChkSrcIn
**
** Function    According to address in tx_buf , finding source line if
**             it had. on List Mixed or Source mode.
**
**    Input  : tx_buf
**
**    Output : tmpBuf
**
** Notes:      Programming by James Wang
**
**************************************************************************/
PUBLIC RETCODE ChkSrcIn( U8 *tmpBuf , U32 *oldaddr)
{
U8  Buf1[128];
U32 old, addr, absaddr = 0;
U32 curFrame = 0;
S16 ret;

   if (strstr(tx_buf,"[ More ]") != NULL && cmd_syntax.argv[0] != 2) {
      send(CR);
      while (receive() != CR);
      while (receive() != CR);
      return(FAIL);
   }
   if ( !strncmp(tx_buf,"     ",5) )  return (FAIL); // no frame No. in this line
   if ( GetFramebyTrace( &curFrame ) != OK )  return (FAIL);
   if ( GetAddressbyTrace( &absaddr ) != OK ) return (FAIL);

   absaddr &= 0x000FFFFF;
// if ( absaddr & 1 ) absaddr--; // adjust funtion's start address.
   addr = ( (absaddr << 12) & 0xff000000) + ( absaddr & 0x00000fff);
   old = *oldaddr;
   *oldaddr = addr;

   switch ( (int) cmd_syntax.argv[0] ) {
   case 2:   case 3:
//   if ( Addr2SourceLine(addr, Buf1) == OK ) {
   // 02/22/95
   if ( (ret = Addr2SourceLine(addr, Buf1)) == OK ) {
//      *oldaddr = addr;
      if ( !strcmp(Buf1, oldBuf) && cmd_syntax.argv[0] != 2 ) {  // process multiple statement.
//            if ( !search_flag && !moreFlag ) DisplayStr(" ");
            strcpy(tmpBuf,".");
            search_flag = 1;
            return (SEARCH);
      }
      else {
         strcpy(oldBuf, Buf1);
         if ( cmd_syntax.argv[0] != 2)
            sprintf(tmpBuf," Frame:%04lX  %s", curFrame, Buf1);
         else
            sprintf(tmpBuf," < %s", Buf1);
         ChkFullLine(tmpBuf);
         return (OK);
      }
   }

   // added: source not found. 02/22/95
   else if ( ret == -2 ) return(FAIL);

   else {
//    if ( *oldaddr == 0xfffff ) {
//       *oldaddr = addr;
//       return (FAIL);
//    }
//    if ( cmd_syntax.argv[0] == 2 ) return (FAIL);
//      while ( addr > *oldaddr ) {
//      (*oldaddr)++;
//      if ( Addr2SourceLine(*oldaddr, Buf1) == OK ) {
      while ( addr > old ) {
      old++;
      if ( Addr2SourceLine(old, Buf1) == OK ) {
         if ( !strcmp(Buf1, oldBuf) ) {  // process multiple statement.
//            if ( !search_flag && !moreFlag ) DisplayStr(" ");
            strcpy(tmpBuf,".");
            search_flag = 1;
            return (SEARCH);
         }
         else {
            strcpy(oldBuf, Buf1);
            sprintf(tmpBuf," Frame:%04lX  %s", curFrame, Buf1);
            ChkFullLine(tmpBuf);
            return (OK);
         }
      } // find source line.
    } // end of while
   return (FAIL);
   }
   break;

   case 4:
   if ( ( ret = Addr2Block(absaddr, Buf1)) == 0 || ret == 1
            || ret == 2 || ret == 3 ) {
      if ( ret == 2 || !strlen(oldBuf) ) {
         sprintf( tmpBuf, " Frame:%04lX%s  %s", curFrame,
            ret == 1 ? "  Procedure Enter" : ( ret == 2 ? "  Procedure  Exit" : "                 "),
            Buf1 );
         ChkFullLine(tmpBuf);
         strcpy( oldBuf, Buf1 );
         return (OK);
      }

      if ( !strcmp(&Buf1[15], &oldBuf[15]) ) {
//            if ( !search_flag && !moreFlag ) DisplayStr(" ");
         strcpy(tmpBuf,".");
         search_flag = 1;
         return (SEARCH);
      } else  {
           sprintf( tmpBuf, " Frame:%04lX%s  %s", curFrame,
               ret == 1 ? "  Procedure Enter" : ( ret == 2 ? "  Procedure  Exit" : "                 "),
               Buf1 );
           ChkFullLine(tmpBuf);
           strcpy(oldBuf, Buf1);
           return (OK);
        }
   }
   return (FAIL);
   break;
   }
}

/**************************************************************************
**
** Name : GetFramebyTrace
**
** Function    According to content in tx_buf , finding current frame
**
**    Input  : tx_buf
**
**    Output : u32
**
** Notes:      Programming by James Wang
**
**************************************************************************/
PRIVATE RETCODE GetFramebyTrace( U32 *u32 )
{
S16 i, ii, cnt=0;
U8  *ptr = NULL;
static U8 HexArr[] = "0123456789ABCDEF";

   if ( tx_buf[0] == '\0' || strlen(tx_buf) < 12 ) return (FAIL);
   ii = 0;
   *u32 = 0;
   while (1) {
      if ( tx_buf[ii] == '\0' ) return (FAIL);
      if ( isHexaDecimal( tx_buf[ii] ) )
         cnt++;
      else cnt = 0;
      ii++;
      if (cnt == 4) break;
   }
   if ( cnt != 4 ) return (FAIL);
   ii -= 4;
   for ( i=ii; i < ii+4; i++) {
      if ( (ptr = strchr(HexArr, tx_buf[i]) ) == NULL ) return (FAIL);
      else
         *u32 = (U32)((*u32*16) & 0x000FFFFF)
                     + (U32)((ptr-HexArr) & 0x000FFFFF);
      }
   return (OK);
}
/**************************************************************************
**
** Name : GetAddressbyTrace
**
** Function    According to address in tx_buf , finding current address
**
**    Input  : tx_buf
**
**    Output :
**
** Notes:      Programming by James Wang
**
**************************************************************************/
PUBLIC RETCODE GetAddressbyTrace( U32 *u32 )
{
S16 i, ii, cnt=0;
U8  *ptr = NULL;
static U8 HexArr[] = "0123456789ABCDEF";

   if ( tx_buf[0] == '\0' || strlen(tx_buf) < 12 ) return (FAIL);
   ii = 0;
   *u32 = 0;
   while (1) {
      if ( tx_buf[ii] == '\0' ) return (FAIL);
      if ( isHexaDecimal( tx_buf[ii] ) )
         cnt++;
      else cnt = 0;
      ii++;
      if (cnt == 5) break;
   }
   if ( cnt != 5) return (FAIL);
   ii -= 5;
   for ( i=ii; i < ii+5; i++) {
      if ( (ptr = strchr(HexArr, tx_buf[i]) ) == NULL ) return (FAIL);
      else
         *u32 = (U32)((*u32*16) & 0x000FFFFF)
                     + (U32)((ptr-HexArr) & 0x000FFFFF);
      }
   return (OK);
}
/**************************************************************************
**
** Name : isHexaDecimal
**
** Function    this char is hex ?
**
**    Input  : char c;
**
**    Output : 1 - successly or 0 - fail
**
** Notes:      Programming by James Wang
**
**************************************************************************/
PUBLIC RETCODE isHexaDecimal( U8 c )
{
   return ( ( c >= 0x30 && c <= 0x39 ) ? 1 :
            ( ( c >= 'A' && c <= 'F' ) ? 1 : 0 ) );
}

/**************************************************************************
**
** Name : ChkFullLine
**
** Function    checking input line, is full : cut the tail of line.
**
**    Input  : line buffer.
**
**    Output :
**
** Notes:      Programming by James Wang
**
**************************************************************************/
PRIVATE RETCODE ChkFullLine( U8 *buffer )
{

   if ( strlen(buffer) >= 77 )
      buffer[77] = '\0';  // a full line in screen
   strcat(buffer,"\r\n");
   return (1);

}

/**************************************************************************
**
** Name : SetDefaultFrame
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  no use
PRIVATE SetDefaultFrame(long *frame)
{
   emuGetTraceDepth(curBuf-1,&traceDepth[curBuf-1]);
   *frame = -8;
   if (*frame < traceDepth[curBuf-1].startFrame ||
       *frame > traceDepth[curBuf-1].endFrame)
      *frame = traceDepth[curBuf-1].startFrame;
}   // end of SetDefaultFrame()
*/

/**************************************************************************
**
** Name : IntervalCmd
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
void IntervalCmd()
{

   if (cmd_syntax.argc < 1 ){
      if( intervalFlag )
          DisplayStr(" Time interval ON.\n\r");
      else
          DisplayStr(" Time interval OFF.\n\r");
   }
   else{
      intervalFlag = cmd_syntax.argv[0];
      emuSetInterval(intervalFlag);
   }
}


/**************************************************************************
**
** Name :TriggerlevelCmd
**
** Function: Trigger level(s) settings or display.
**
**  STYLE :  STY_TRANSPARENT
**
**    Input  : lineBuf
**
**    Output : messages on screen.
**
** Notes: Coded by Matthew Hsiao
**
**************************************************************************/
PUBLIC RETCODE TriggerLevelCmd( int trId )
{
char *ptr, c;
char tmpBuf[512];

// copy lineBuf[] to tmpBuf[]
    strncpy(tmpBuf, lineBuf, 512);
    tmpBuf[511] = NULL;

  send_str2("T L ");

// for filter space , 6/16/1994
  ptr = strstr(strupr(tmpBuf), "TLEVEL");
  ptr += strlen("TLevel");

  while ( (c=*ptr++) != ' ' && c);
  if (c == ' ') while (c=*ptr++) send(c);

  send_CR_wait(CR);
  for (;;) {
	ptr = tx_buf;
	while ((c=receive()) != HAND_SHAKE && c != CR) *ptr++ = c;
	if (c == HAND_SHAKE) break;
	*ptr = NULL;
	DisplayStr(tx_buf);
  } 
  return(OK);
}

/**************************************************************************
**
** Name : EventCmd()
**
** Function: Sets/displays/clears event(s).
**
**    Input  : evId( 0 : all events; 1-8: event number )
**             cmd_syntax :
**             .argc = 0 : Display event(s).
**             .argc = 1 : Clear event(s).
**             .argc = 2 : Set event(s).
**             .argv[0]  : For ext. event setting.  1: High 0: Low
**             addr_form : For exec. event setting.
**             ev_def    : For bus event setting.
**             event_record, ext_record, bp_record.
**
**    Output : messages on screen, or event_record, or bp_record, or ext_record
**
** Notes: Coded by C. Joyce Lin
**
**************************************************************************/
PUBLIC RETCODE EventCmd(U8 evId)
{
 U8 i, temp[80];
 int bitNo;
 int tempEV;
 U16 extEvent;
 U32 addr;
 extern int MICE;
 U16 flag;
 U16 count;
 S16 diff;

 if ( MICE >= 9 && !LAM2) diff = 8;   //how many events(total)
 else diff = LAM2+7;

/************** Display event settings **********/
  if (!cmd_syntax.argc ) {
     if ( !evId && existTraceBoard== ON )
		DisplayAllEvents();
     else if (evId > 0 && evId < LAM2+3 ) DisplayBusEvent( evId );
	 else if ( evId == LAM2+3 ) {
		if (!LAM2 ) tempEV = 3;
			else tempEV = 5;
        if (ext_record & 0x01) sprintf(temp," EV%i (External) High\n\r", tempEV);
        else sprintf(temp," EV%i (External) Low\n\r", tempEV);
        DisplayStr(temp);
     }
     else if (evId > LAM2+3) DisplayExecEvent(evId);
     return( OK );
  }

/************** Sets a event  *******************/
  if ( cmd_syntax.argc==2 ) {
     if (evId == LAM2+3 ) {
        if ((errorCode=emuSetExtEvent( (U16) cmd_syntax.argv[0] )) !=OK)
             return(errorCode);
     }
     else
        if (evId > LAM2+3 ) {  /* sets exec. event */
           if (!addr_form.csFlag) {
              if ((errorCode = emuGetReg(I86_REG, CS, &addr)) != OK)
                 return(errorCode);
              addr =(addr << 16) + addr_form.addr;
           } else addr = addr_form.addr;
		   if ( (MICE >=9 || MICE != I80286) && evId == 4){
               flag  = (U16) cmd_syntax.argv[0];
               count = (U16) cmd_syntax.argv[1];
               errorCode= emuSetBP0( flag,addr,count ); //   4/14/1994
           }
           else errorCode= emuSetBP( evId, addr );
           return(errorCode);
        }
        else {
           if ( (MICE >=1 && MICE <=4) || (MICE == 9) || (MICE == 10) ||
                (MICE ==13) || (MICE == 14) ) { // 8_BIT DATA
              if ( ev_def.dataSpec &&  (((ev_def.dataLo&0xff00) != 0) ||
                   ((ev_def.dataHi&0xff00) != 0xff00))) {
                 DisplayStr(" Data setting error, due to 8_bits CPU\n\r");
                 return( OK );
              }
              else{
                   ev_def.dataSpec = 3;
                   ev_def.dataHi &= 0xff;
              }
           }
           if ((errorCode=emuSetEvent(evId, &ev_def)) != OK) return(errorCode);
       }
     return(OK);
  }
/************** Clears event(s)  *******************/
  if ((errorCode = emuClrEvent(evId)) != OK)
      return(errorCode);
  return(OK);
}

/**************************************************************************
**
** Name : DisplayExecEvent()
**
** Function: Displays one of the Execution Events(EV6, EV7,EV8) settings.
**
**    Input  : evId( indicates the event number to be displayed.)
**             bp_record( global structure with execution event settings.)
**
**    Output : messages on screen.
**
** Notes: Coded by C. Joyce Lin
**
**************************************************************************/
static DisplayExecEvent(U8 evId)
{
U8 temp[80];
U32 addr;
int sub;
U8 runStr[5];

   memset(runStr, '\0', 5);
   if ( (MICE >= 9 && MICE != I80286) && !LAM2 ){
      if ( evId == 4 && bp_record[0].defined) {
            printf("%i", bp_record[0].runFlag);
            if (bp_record[0].runFlag) memcpy(runStr,"Run",3);
            addr = bp_record[0].addr;
            sprintf(temp, " EV4 (Execution) %s %04X:%04X COunt %04X\n\r",
                    runStr, (U16)(addr >> 16),(U16)addr,bp_record[0].count);
            DisplayStr(temp);
            return;
      }
   }
   sub = evId-4-LAM2;

   if (bp_record[sub].defined) {
      addr = bp_record[sub].addr;
      sprintf(temp, " EV%1d (Execution) %04X:%04X\n\r", evId, (U16)(addr >> 16),
                    (U16)addr);
   }
   else sprintf(temp, " EV%1d (Execution) Clear\n\r",evId);
   DisplayStr(temp);
}

/**************************************************************************
**
** Name : DisplayBusEvent()
**
** Function: Displays one of the Bus Events(EV1 to EV4) settings.
**                                   or (EV1 and EV2)
**    Input  : evId( indicates the event number to be displayed.)
**             event_record( global structure with bus event settings.)
**
**    Output : messages on screen.
**
** Notes: Coded by C. Joyce Lin
**
**************************************************************************/
static DisplayBusEvent(U8 evId )
{
   char *ptr, c;
   static char temp[5] = "EV ";

  temp[2] = evId + '0';
  send_str2(temp);
  send_CR_wait(CR);

  for(;;){
      ptr = tx_buf;
      while( (c=receive()) != HAND_SHAKE && c != CR )
          if ( c != '>' ) *ptr++ = c;
       *ptr = 0;
      if ( strstr(tx_buf, temp) != NULL )
          DisplayStr(tx_buf);
      if (c == HAND_SHAKE) break;
  }
  return (OK);

/******
	U8 busEvAddr[40], busEvDatum[40], busEvStat[40], i, temp[130];
	U8 busEvCount[10];

   i = evId-1;
   if (event_record[i].defined) {
	  if (!LAM2) {
		  GetBusEventInfo( busEvAddr, busEvDatum, busEvStat,
                       busEvCount, event_record[i]);
		  sprintf(temp," EV%1d (bus) %s %s %s COunt %s\n\r",
              evId, busEvAddr, busEvDatum,
              busEvStat, busEvCount);
	  }
   }
   else sprintf(temp," EV%1d (bus) Clear\n\r", evId );
   DisplayStr( temp );
   *****/
}

static DisplayAllEvents()
{
	 char *ptr, c;

	 send('E');
	 send_CR_wait(CR);

	 ptr = tx_buf;
	 while( (c=receive()) != HAND_SHAKE )
          if ( c != '>' ) *ptr++ = c;
       *ptr = 0;
	 DisplayStr(tx_buf);

  return (OK);
}

/**************************************************************************
**
** Name : Get8Bytes()
**
** Function: Converts the contents of an 8-byte memory to double precision
**           floating point value.
**
**    Input  :  a string
**    Output :  a double value
**
** Notes:
**
**************************************************************************/
static double Get8Bytes()
{
union {
   double ff;
   unsigned char cc[8];
} FFF;
int i;
   for(i=0 ; i<8 ; i++) FFF.cc[i]=my_buf[i];
   return(FFF.ff);
}        /* end of Get8Bytes() */

/**************************************************************************
**
** Name : Get4Bytes()
**
** Function: Converts the contents of a 4-byte memory to single precision
**           floating point value.
**
**    Input  :  a string
**    Output :  a float
**
** Notes:
**
**************************************************************************/
static float Get4Bytes()
{
union {
   float ff;
   unsigned char cc[4];
} FFF;
int i;

   for(i=0 ; i<4 ; i++) FFF.cc[i]=my_buf[i];
   return(FFF.ff);
}        /* end of Get4Bytes() */

/**************************************************************************
**
** Name : d_prnCSIP(l)
**
** Function : display as follow: cs:ip. eg., 1000:2030
**
**    Input  : 32 bit,
**
**    Output :
**
** Notes:
**
**************************************************************************/
static d_prnCSIP(unsigned long l)
{
int i, j;
char temp[4];

   j = (l >> 16) & 0xffff;
   hex2asc(&temp[2], j&0xff);
   hex2asc(&temp[0], (j>>8)&0xff);
   for (i=0;i<4;i++) DisplayCh(temp[i]);
   DisplayCh(':');
   j = l & 0xffff;
   hex2asc(&temp[2], j&0xff);
   hex2asc(&temp[0], (j>>8)&0xff);
   for (i=0;i<4;i++) DisplayCh(temp[i]);
}        /* end of d_prnCSIP(l) */

/**************************************************************************
**
** Name : DumpCmd()
**
** Function : Memory dump; for now only byte size access/display support
**
**     Input  : start address, and the length
**
**    Output :
**
** Notes:
**    return the dataCnt -- which indicate how many bytes are displayed.
**
**************************************************************************/
DumpCmd(U32 addr, U32 len)
{
char output[80], dataStr[49], asciiStr[17], temp[10],  c;
U8   dataBuf[256], *ptr;
int  offset, line, size, i;
U16 count;  // Chen 06/03/94 ; it was a S16 in the old version

   if (sizeFlag == 0)   // byte size
      DisplayStr("           00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F      ASCII-CODE\r\n");
   else                 // word size
     DisplayStr("             00    02    04    06    08    0A    0C    0E       ASCII-CODE\r\n");

   SetPutsBuf(NULL, 16, (len <= 0x10000) ? 0 : -1);

   if (sizeFlag == 1) {   // word size; need adjust len and addr if necessary
      len += (len & 1) ? 1 : ((addr & 1) ? 2 : 0);
      addr &= 0xFFFFFFFE;   // set even address
   }

   asciiStr[16] = '\0';
   memset(dataStr, ' ', sizeof(dataStr));
   offset = addr & 0x0000000F;
   dataStr[offset * 3] = '\0';

   line = count = 0;
   while (len != 0) {
      if (count == 0) {    // need read new data
         if (offset > 0)   // current address is not on paragraph boundary
            count = (offset+len > 16) ? 16 - offset : len;
         else
            count = (len > 256) ? 256 : len;
//         if ((errorCode=emuGetMemN(addr, dataBuf, (U32)count)) != OK)
// Chen 06/03/94
         if ((errorCode=emuGetMemN(addr, dataBuf, count)) != OK)
            return(errorCode);
         ptr = dataBuf;
      }

      size = (count > 16) ? 16 : count;   // bytes displayed each time
      memset(asciiStr, ' ', 16);
      if (sizeFlag == 0)   // byte size
         for (i = 0; i < size; i++) {
            asciiStr[offset + i] = isprint(ptr[i]) ? ptr[i] : '.';
            sprintf(temp, "%02X ", (U16)ptr[i]);
            strcat(dataStr, temp);
         }
      else                 // word size
         for (i = 0; i < size; i += 2) {
            asciiStr[offset + i]   = isprint(ptr[i+1]) ? ptr[i+1] : '.';
            asciiStr[offset + i+1] = isprint(ptr[i])   ? ptr[i]   : '.';
            sprintf(temp, "%04X  ", *((U16*) &ptr[i]) );
            strcat(dataStr, temp);
         }

      if (offset > 0) {
         addr &= 0xFFFFFFF0;   // let displayed addr be on paragraph boundary
         offset = 0;
      }
      sprintf(output, "%04lX:%04lX  %-48s  %-16s",
         addr >> 16, addr & 0x0000FFFF, dataStr, asciiStr);
      if (PutsMore(output) == ESC) return;
      dataStr[0] = '\0';
// Chen 06/04/94    ; fix a bug: FFFF:F Length 10 && F000:FFFF Length 10
//      AdvanceAddr(&addr, 16);
        AdvanceAddrDump(&addr, 16);
      len -= size;
      count -= size;
      ptr += size;
   }
   return(OK);
}

/**************************************************************************
**
** Name : SetMemCmd()
**
** Function
**
**     Input  : addr, len ; 1 --> byte
**                     2 --> word
**                     4 --> long
**
**    Output :
**
** Notes:
**
**************************************************************************/
SetMemCmd(U32 addr, U32 len)
{
U8 dataBuf[8];
char buf1[40], buf2[40], *ptr;
int i;
U32 max, num;

   while (1) {
   /*** Display content of memory ***/
      if ((errorCode=emuGetMemN(addr, dataBuf, len)) != OK)
         return (errorCode);
      sprintf(buf1, " %04lX:%04lX    ", addr >> 16, addr & 0x0000FFFF);
      DisplayStr(buf1);
      buf1[0] = '\0';
      for (i = 0; i < len; i++) {
         sprintf(buf2,"%02X", dataBuf[len - 1 - i]);
         strcat(buf1, buf2);
      }
      strcat(buf1," ");
      DisplayStr(buf1);
   /*** Modify value ***/
      if (get_str2(buf1,30) == ESC) {
         DisplayStr("\\\r\n");
         break;
      }
      DisplayStr("\r\n");
      ptr = strtok(buf1, " \t\r\n");
      if (ptr != NULL) {   // has input
         max = (1 << (8 * len)) - 1;
         if (IsInNumberRange(ptr, HEX, 0, max, &num) != 1) {
            DisplayStr(" Hex data error!\r\n");
            continue;
         }
         if ((errorCode=SdEmuSetMemN(addr, (U8 *)&num, len)) != OK)
            return (errorCode);
      }
      AdvanceAddr(&addr, len);
   }  /* end while */
   return(OK);
}        /* end of SetMemCmd() */

/**************************************************************************
**
** Name : ChecksumCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/****
ChecksumCmd(U32 addr, U32 length)
{
int checksum;
char BUF[60];
   if ((errorCode=emuChecksum(addr, length, &checksum)) != OK )
      return(errorCode);
   else {
     if (!sizeFlag) sprintf(BUF," Checksum is %02X\n\r", checksum);
     else sprintf(BUF," Checksum is %04X\n\r", checksum);
     DisplayStr(BUF);
     return(OK);
   }
}
*****/
/**************************************************************************
**
** Name : TestCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/********************
TestCmd(U32 addr, U32 length)
{
char BUF[60];
   if ( (errorCode=emuTest(addr, length)) == OK )
     DisplayStr(" Memory test completed -- no failure found\r\n" );
   else {
     sprintf(BUF," Memory test ternimated -- failure at %04X:%04X \n\r",
		 HighWord(ret_addr1), LowWord(ret_addr1));
     DisplayStr(BUF);
   }
   return(OK);
}
**************/

/**************************************************************************
**
** Name : CompareCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
CompareCmd(U32 addr1, U32 length, U32 addr2)
{
U16 diff;
char BUF[80];
      errorCode = emuCompare(addr1, length, addr2, &diff);
      if ( errorCode == NO_DIFF )
         DisplayStr( " No different data\r\n" );
      else if (errorCode != OK)  return(errorCode);
      else {
          sprintf(BUF," %d differences in this memory compare\n\r",diff);
          DisplayStr(BUF);
      }
      return(OK);
}  /* end of CompareCmd() */


/**************************************************************************
**
** Name : SearchCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
SearchCmd(U32 addr1, U32 length, char *buff, U16 count) {
char  BUF[60];
int times;

        errorCode = emuSearch(addr1, length, buff, count, &times);

        if (errorCode == NO_FOUND)
             DisplayStr(" No such data in the memory!\r\n");
        else if (errorCode != OK)  return(errorCode);
        else {
           sprintf(BUF," %d occurrences in this memory search\n\r",times);
           DisplayStr(BUF);
        }
   return(OK);
}    /* end of searchcmd()   */



/**************************************************************************
**
** Name : RegisterCmd()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:   no argument: argc = 0;
**          INternal   : argc = 1, argv[0] = 1
**          COprocessor: argc = 1, argv[0] = 2
**          reg_id     : argc = 2; argv[0] = reg. ID, argv[1] = reg. type
**          reg_id data: argc = 3, argv[0] = reg. ID, argv[1] = reg. type, argv[2]=data
**          reg_id     : argc = 6; argv[0] = reg. ID, argv[1] = Internal
**          reg_id     : argc = 7; argv[0] = reg. ID, argv[1] = Processor
**
**************************************************************************/
int RegisterCmd()
{
U16  regId, regType;
U32  max,value;
char buf[240];
extern int NECflag;

   switch (cmd_syntax.argc) {
   case 0:   /* REGISTER */
      if ((errorCode=emuGetAllReg(cpuReg)) != OK)  return (errorCode);
        // added by Chen, 07/22/94
        if ( NECflag == 1 ) {
            formatRegNEC(buf);
        }
//		  else if ( MICE == I80286 ) {
//            formatReg286(buf);
//        }
        else {
            formatReg(buf);
        }
      DisplayStr(buf);
      break;
   case 1:   /* REGISTER Internal/Coprocessor */
        if (cmd_syntax.argv[0] == 1) {
            emuPrintIntReg();
            send_ESC();
        }
        else {
            emuPrintCopReg();
            send_ESC();
        }
      break;
   case 2:   /* REGISTER regId */
      regId = (U16)cmd_syntax.argv[0];
      regType = (U16)cmd_syntax.argv[1];
      ModifyRegister(regType, regId);
        if ( regType == I87_REG ) {     // Chen 06/06/94
            send_ESC();
        }
      break;
   case 3:   /* REGISTER regId value */
      regId   = (U16)cmd_syntax.argv[0];
      regType = (U16)cmd_syntax.argv[1];
      value   = (U16)cmd_syntax.argv[2];
      max = (( regType == I86_REG && regId <= FLAGS ||
               regType >= I87_REG ) ? 0xFFFF :
              (regType == I86_REG && regId <= CF) ? 1 : 0xFF );
      if (value < 0 || value > max) {
         DisplayStr(" Hex data error!\r\n");
         return (OK);
      }
      SetRegister(regType, regId, &value);
      break;
   case 4:	// (V20/V30) Register regId
	  strncpy (buf, lineBuf, 239);
	  memset(lineBuf, '\0', 512);
	  strncpy (lineBuf, "ICE ", 4);
	  strcat(lineBuf, buf);
	  IceMode();
	  break;
   case 5: // (V20/V30) Register regId content
      regId   = (U16)cmd_syntax.argv[0];
	  regType = 0;	 //(U16)cmd_syntax.argv[1];
	  value   = (U32)cmd_syntax.argv[2];
	  SetReg(regType, regId, value);  // ABI function, see reg86.c
	  break;
   case 6:  // Register Internal, added by Chen, 09/02/94
	  strncpy (buf, lineBuf, 239);
      memset(lineBuf, NULL, 512);
      strcpy (lineBuf, "ICE ");
	  strcat(lineBuf, buf);
	  IceMode();
	  break;
   case 7:  // Register Processor, added by Chen, 09/02/94
	  strncpy (buf, lineBuf, 239);
      memset(lineBuf, NULL, 512);
      strcpy (lineBuf, "ICE ");
	  strcat(lineBuf, buf);
	  IceMode();
	  break;
   }  /* end of switch */

   RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);   //  mask off REDRAWCOD
   UpdateVP();
   UpdateCODVP(-1);
   return (OK);
}       /* end of RegisterCmd() */



/**************************************************************************
**
** Name : ModifyRegister(regType, regId)
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE ModifyRegister(U16 regType, U16 regId)
{
U16  contents[5];
int  nameIndex, mode;
char buf[40], temp[10], **nameBase;

   switch (regType) {
     case I86_REG:
        nameBase = cpuRegTable;
        break;
     case I87_REG:
        nameBase = copRegTable;
        break;
     case INT_REG_MASTER:
        nameBase = intRegMaster;
        break;
     case INT_REG_SLAVE:
        nameBase = intRegSlave;
        break;
     case INT_REG_186EB:
        nameBase = intReg186EB;
        break;
     case INT_REG_186EC:
        nameBase = intReg186EC;
        break;
   }
   nameIndex = regId;
   while (1) {
   /*** get register name and value ***/
      GetRegister(regType, regId, &contents[0]);
      if (regType == I87_REG) break;
      sprintf(buf," %-8s", nameBase[ nameIndex ]);
      if (((regType == I86_REG) && (regId <= FLAGS)) ||
            (regType >= I87_REG) )   // 16-bit register
         sprintf(temp,"%04X ", contents[0]);
      else if ((regType == I86_REG) && (regId <= CF))   // 1-bit flag
         sprintf(temp,"%d ", contents[0] & 1);
      else                                       // 8-bit register
         sprintf(temp,"%02X ", contents[0] & 0x00FF);
      strcat(buf, temp);

   /*** input value ***/
      if (InputRegister(buf, regType, regId, contents) == FALSE)  break;

   /*** advance to next register ***/
      do {
         nameIndex++;
         if (nameBase[nameIndex] == NULL) {   // end of Table
            regId = nameIndex = 0;
         }
         else  regId++;
      } while ( nameBase[nameIndex][0] == '\0' || (( MICE==1 || MICE==5) &&
                regType >= INTERNAL_REG && (regId== PWRCON || regId== STEPID)));
   }  /* end of while */
}  /* end of ModifyRegister() */

/**************************************************************************
**
** Name : InputRegister(regId, contents)
**
** Function
**
**    Input  :
**
**    Output :
**
**    Return : TRUE if success, FALSE if ESC key is pressed
**
** Notes:
**
**************************************************************************/
PRIVATE InputRegister(char *prompt, U16 regType, U16 regId, U16 *contents)
{
U32  value, max;
int  index, change;
char buf[40], *tokPtr;

   change = FALSE;
   for (index = 0; index < 5; ) {   // 5 words in STx
      if (index == 0)
         DisplayStr(prompt);
      else {   // not first word of STx
         DisplayStr("         ");
         sprintf(buf,"%04X ", contents[index]);
         DisplayStr(buf);
      }
      if (get_str2(buf,30) == ESC) {
         DisplayStr("\\\r\n");
         if (change)  SetRegister(regType, regId, contents);
         return (FALSE);
      }
      DisplayStr("\r\n");

      tokPtr = strtok(buf, " \t\r\n");
      if (tokPtr != NULL) {
         max = (( regType == I86_REG && regId <= FLAGS ||
                  regType >= I87_REG ) ? 0xFFFF :
                 (regType == I86_REG && regId <= CF) ? 1 : 0xFF );
         if (IsInNumberRange(tokPtr, HEX, 0, max, &value) != 1) {
            DisplayStr(" Hex data error!\r\n");
            continue;
         }
         else {
            change = TRUE;
            contents[index] = value;
         }
      }
      if (regType != I87_REG || (regType == I87_REG && regId < COPBASE2)) // not STx
         break;
      index++;   // advance to next word of STx
   }  /* end of for */
   if (change)  SetRegister(regType, regId, contents);
   return (TRUE);
}  /* end of InputRegister() */

/**************************************************************************
**
** Name : GetRegister(regId, content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PUBLIC GetRegister(U16 regType, U16 regId, U16 *content)
{
U16 realID;
U32 temp;
// U8 tmpContent;   Frank 06/07/94


   if (regType == I87_REG)  {                      // coprocessor register
      emuGetCoReg(regId, (U8 *)content);
   //   emuGetCoReg(regId, &tmpContent);
  //    *content = tmpContent;
   }
   else
   if (((regType == I86_REG) && (regId <= FLAGS)) ||
            (regType >= INTERNAL_REG) ) {   // 16-bit register
      if (regType >= INTERNAL_REG) {
          realID = (U16)ConvertInternalRegID(regType, regId);
          regType = INTERNAL_REG;
      }
      else realID = regId;
      emuGetReg(regType, realID, &temp);
      *content = (U16)temp;
   }
   else if ((regType == I86_REG) && (regId <= CF)) {     // 1-bit flag
      emuGetReg(regType, FLAGS, &temp);
      *content = (temp & FlagsBit[regId - OF]) ? 1 : 0;
   }
   else {                                          // 8-bit register
      emuGetReg(regType, (regId - AL) & 0x0003, &temp);
      if (regId <= DL)   // AL,BL,CL,DL
         *content = temp & 0x00FF;
      else               // AH,BH,CH,DH
         *content = (temp & 0xFF00) >> 8;
   }
}  /* end of GetRegister() */

/**************************************************************************
**
** Name : SetRegister(regType,regId, content)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE SetRegister(U16 regType, U16 regId, U16 *content)
{
U16 originalID, index=0, cnt, offset, size;
U32 NewValue;

   if (regType == I87_REG)                          // coprocessor register
      emuSetCoReg(regId, (U8 *)content);
   else {
      if (regType == I86_REG && regId <= FLAGS ||        // 16-bit register
          regType >= INTERNAL_REG) {
         if (regType >= INTERNAL_REG)
            originalID = (U16)ConvertInternalRegID(regType, regId);
         else originalID = regId;
         NewValue = *content;
      }
      else if (regType == I86_REG && regId <= CF) {       // 1-bit flag
         originalID = FLAGS;
         emuGetReg(regType, originalID, &NewValue);
         if (*content)
            NewValue |= (U32)FlagsBit[regId - OF];
         else
            NewValue &= ~(U32)FlagsBit[regId - OF];
      }
      else {                                       // 8-bit register
         originalID = (regId - AL) & 0x0003;
         emuGetReg(regType, originalID, &NewValue);
         if (regId <= DL)   // AL,BL,CL,DL
            NewValue = (NewValue & 0xFF00) | (*content & 0x00FF);
         else               // AH,BH,CH,DH
            NewValue = (NewValue & 0x00FF) | ((*content & 0x00FF) << 8);
      }
      emuSetReg(regType>INTERNAL_REG ? INTERNAL_REG : regType, originalID, NewValue);
   }
}  /* end of SetRegister() */

/**************************************************************************
**
** Name : MapCmd()
**
** Function
**
**    Input  :  cmd_syntax.argv[0]=abs1, .argv[1]=abs2, .aargv[2]=attribute
**                        .argc =0:no argu, =1:external, =3:other
**    Output :
**
** Notes:
**
**************************************************************************/
MapCmd()
{
static U16 emmSizeArray[] = {256, 512, 1024, 2048, 4096};
U8   emmSizeID;
char buf[80];
char c, *ptr;

/*** Display map information of memory ***/

// Chen, 12/28/94
// Dome told us not to change the Map setting
    if ( MICE >= I8088MAX && MICE <= V30MIN ) {
        Transparent(); /* set map via transparent mode */
        return;
    }

   if (cmdLineArgc == 0) {
      emuGetMapSize(&emmSizeID);
      sprintf(buf," Emulation Memory Size = %dK Bytes\r\n", emmSizeArray[emmSizeID]);
      DisplayStr(buf);
   }
   Transparent(); /* set map via transparent mode */
}  /* end of MapCmd() */



/**************************************************************************
**	
** Name :  SaveCmd()
**
**************************************************************************/
SaveCmd()
{
char *ptr, c;
// char tmpBuf[80];
char tmpBuf[256];   // Chen 06/27/94

   send_str2("SAVE"); /* save into NOVRAM */
   send_CR_wait(CR);
   ptr = tmpBuf;
   while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
   *ptr = NULL;
   if (strstr(tmpBuf,"Memory map") != NULL) 
	   DisplayStr(" Memory map, timebase were saved to NOVRAM\n\r");
//   else DisplayStr(tmpBuf);
   else if (strstr(tmpBuf,"inconsistent") != NULL) // added by Chen 08/11/94
        DisplayStr(" NOVRAM parameters inconsistent!\n\r");
   else    // added by Chen, 08/11/94
        DisplayStr("\n\r");
   return(TRUE);
}         /* end of SaveCmd() */

/**************************************************************************
**
** Name : RecallCmd()
**
**    RETCODE: TRUE( OK ), FALSE( ERROR ).
**
** Notes: Coded by C. Joyce Lin
**
**************************************************************************/
RecallCmd(U8 entryMode)
{
char *ptr, c;
// char tmpBuf[80];
char tmpBuf[256];   // Chen 06/27/94

   send_str2("RECALL");
   send_CR_wait(CR);
   ptr = tmpBuf;
   while ((c=receive()) != HAND_SHAKE) *ptr++ = c;
   *ptr = NULL;
    if (strstr(tmpBuf,"Memory map") != NULL)
        DisplayStr(" Memory map, timebase were recalled from NOVRAM\n\r");
    else if (strstr(tmpBuf,"inconsistent") != NULL) // added by Chen 07/06/94
        DisplayStr(" NOVRAM parameters inconsistent!\n\r");
//    else DisplayStr(tmpBuf);  // marked by Chen, 07/06/94
    else    // added by Chen, 07/06/94
        DisplayStr(" Recalled from NOVRAM in failur\n\r");
   return(OK);
}        /* end of Recallcmd() */


/**************************************************************************
**
** Name :  GetMemWrap
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int GetMemWrap(U32 addr, U8 *buf, U16 len)
{
U32 maxsize;
int retcode;

   maxsize = 0x10000 - (addr & 0x0000FFFF);
   if (len <= maxsize)
      return (emuGetMemN(addr, buf,  len));
   else {
      if ((retcode=emuGetMemN(addr, buf,  maxsize)) != OK)
         return (retcode);
      return (emuGetMemN(addr & 0xFFFF0000, &buf[maxsize],  len - maxsize));
   }
}

/**************************************************************************
**
** Name :
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int SetMemWrap(U32 addr, U8 *buf, U16 len)
{
U32 maxsize;
int retcode;

   maxsize = 0x10000 - (addr & 0x0000FFFF);
   if (len <= maxsize)
      return (SdEmuSetMemN(addr, buf,  len));
   else {
      if ((retcode=SdEmuSetMemN(addr, buf,  maxsize)) != OK)
         return (retcode);
      return (SdEmuSetMemN(addr & 0xFFFF0000, &buf[maxsize],  len - maxsize));
   }
}

/**************************************************************************
**
** Name :
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
AdvanceAddr(U32 *addr, int len)
{
long segment, offset;

   segment = *addr & 0xFFFF0000;
   offset = (*addr & 0x0000FFFF) + len;
   *addr = segment + (offset & 0x0000FFFF);
   if (offset >= 0x10000) *addr += 0x10000000;
   else if (offset < 0) *addr -= 0x10000000;

}

/**************************************************************************
**
** Name :
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:   coded by Chen Jun   06/06/94
**
**************************************************************************/
AdvanceAddrDump(U32 *addr, int len)
{
long segment, offset;
U32 tmpAddr;


    segment = *addr & 0xFFFF0000;
    offset = (*addr & 0x0000FFFF) + len;
    if ( offset >= 0x10000 ) {
        segment += 0x10000000;
        *addr = segment + (offset & 0x0000FFFF);
    }
    else {
        tmpAddr = ( (segment>>12) & 0x000FFFF0 ) + offset;
        if ( tmpAddr >= 0x00100000 ) {
            *addr = ((tmpAddr<<12) & 0xF0000000) + (tmpAddr & 0x0000FFFF);
        }
        else {
            *addr = segment + (offset & 0x0000FFFF);
        }
    }


/*
    segment = *addr & 0xFFFF0000;
    offset = *addr & 0x0000FFFF;
    tmpAddr = (((segment>>12)&0x000FFFF0)+offset+len) & 0x000FFFFF;
    *addr = ((tmpAddr&0x000F0000)<<12) + (tmpAddr&0x0000FFFF);
*/

}


/**************************************************************************
**
** Name : ConvertInternalRegID()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes: Coded by C. Joyce Lin
**
**************************************************************************/
PRIVATE int ConvertInternalRegID(U16 regType, U16 regId)
{
U16 index=0, cnt, offset, size;
U8 *fmtBase;
int realID;

  if (regType == INT_REG_MASTER) {
     fmtBase = fmtC186master;
     size =sizeof( fmtC186master );
  }
  else if (regType == INT_REG_SLAVE) {
     fmtBase = fmtC186slave;
     size =sizeof( fmtC186slave );
  }
  else if (regType == INT_REG_186EB) {
     fmtBase = fmt186EB;
     size =sizeof( fmt186EB );
  }
  else  {
     fmtBase = fmt186EC;
     size =sizeof( fmt186EC );
  }
  realID = regId+1;
  while (index < size ) {
     offset = (U16)(fmtBase[ index++ ]);
     cnt    = (U16)(fmtBase[ index++ ]);
     realID -= (int)cnt;
     if (realID <= 0 ) {
        realID = (int)offset + 2* ( realID + (int)cnt - 1) ;
        break;
     }
     else index += cnt;
  }
  return( realID );
}



/********************************** Notes *******************************
**
**   At the END of Process.c, there are 3 commands to be dealed with.
**   1. ICE function ICEmode()
**   2. COVerage and INItialize,  function CovIniCmd()
**      ; These two commands are written in transparent way. - Chen
**   Dealing by this way only because of the file size.
**
**   Noted by : Frank Chang
*************************** End of File **********************************/

