/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       UCO1.C
Engineer:     Amy Wang
Description:  the common symbol processing routines of CONV3

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <search.h>
#include <errno.h>
#include <dos.h>
#include <signal.h>
#include <math.h>
#include "uco1.h"
#include "uco2.h"

int NameComp();
int AddrComp();
int ModComp();

char file_header[21]="*MICROTEK 1993 MICE*";
struct symindex bigname;
struct adrindex bigaddr,sameaddr;
int rloc[INDEX_RANGE];
int rotCnt=0;
char rotChar[]={'|','/','-','\\'};

extern int (*call)();
extern int ErrorOut();
extern int mri68k51z80();

/*---------- defining constants and variables for timer interrupt   ------*/
//#define TIMER_TICK 0x1c
//unsigned long TickCount=0;
//void (interrupt far *old_handler)();
//union REGS regs;
//int fixedrow,fixedcol;
//double seccnt,ms;
//int hh=0,mm=0,ss=0;
//char timestr[] = "00:00:00 00.00";
//int CntlCHandler1();
//int CntlCHandler2();

/*=========================   INTERRUPT    =========================*/

/**************************************************************************/
/***** The following routines are the interrupt-timer related  to      ****/
/***** process the display of the converter program                    ****/
/**************************************************************************/

CntlCHandler1()
{
   close(fdin);
   close(fdsy);
   close(fds1);
   close(fds2);
   close(fds3);
   close(fds4);
   close(fds5);
   unlink(fns1);
   unlink(fns2);
   unlink(fns3);
   unlink(fns4);
   unlink(fns5);
   unlink(fnsy);
   signal(SIGINT,SIG_DFL);
   abort();
}

CntlCHandler2()
{
   signal(SIGINT, SIG_IGN);
   prn_exit("");
}

/***************************************************************************/
/***** ProcessCmdLine()                                               ******/
/***************************************************************************/

ProcessCmdLine(int argc,char *argv[])
{
   int i,bo,outflag=0;
   char *fnout,*ptr,c;
   char tbuf[200];

   if (argc == 1)  {
      printf("Syntax:   CONV3 inputfile [-O outputfile] [-R|-R3] [-L2|-L3|-L4]\n\n");
      printf("          inputfile     : specify the input symbol file\r\n");
      printf("          -O outputfile : specify a different output filename\r\n");
      printf("          -R            : reverse the high byte and low byte,\r\n");
      printf("                          only valid for 2500AD format and IAR MPDS format,\r\n");
      printf("                          with Z80, 64180, 6502, 8051, etc.\r\n");
      printf("          -R3           : only valid for IAR MPDS format with H8/64180\r\n");
      printf("          -L2/L3/L4     : specify the symbol address length for MRI S-format\r\n");
      exit(0);
   }
   for (i=2; i < argc; i++) {
      strcat(tbuf," ");
      strcat(tbuf,argv[i]);
   }
   if      (strstr(tbuf,"-O")  == NULL || strstr(tbuf,"-o") == NULL ) ;
   else if (strstr(tbuf,"-R")  == NULL || strstr(tbuf,"-r") == NULL ) ;
   else if (strstr(tbuf,"-R3") == NULL || strstr(tbuf,"-r3") == NULL) ;
   else if (strstr(tbuf,"-L2") == NULL || strstr(tbuf,"-l2") == NULL) ;
   else if (strstr(tbuf,"-L3") == NULL || strstr(tbuf,"-l3") == NULL) ;
   else if (strstr(tbuf,"-L4") == NULL || strstr(tbuf,"-l4") == NULL) ;
   else if (strchr(tbuf,'-') == NULL) {
           printf("Unknown switch!\n");
           exit(0);
   }
   ptr = argv[1];
   while (*ptr != '\0') {
      *ptr = toupper(*ptr);
      ptr++;
   }
   memset(fnin,NULL,sizeof(fnin));
   memset(fnsy,NULL,40);
   memset(fnmp,NULL,40);
   memset(fnls,NULL,40);
   i = 1;
   while ( i < argc && (c=argv[i][0]) != '-' && c != '/') {
      strcpy(fnin[i-1], argv[i]);
      inputFileCnt = i;
      i++;
   }
   while (i < argc) {
      strcpy(temp1,argv[i]);
      if (temp1[0] == '-' || temp1[0] == '/')  {
         c=toupper(temp1[1]);
         if (c == 'O')  {
            ptr = (char *)temp1+2;
            if (*ptr == NULL)  ptr = argv[++i];
            fnout = ptr;
            outflag = 1;
         }
         if (strncmp(&temp1[1],"R3",2)==0 || strncmp(&temp1[1],"r3",2)==0) R3Flag = 1;
         else if (c == 'R')  ReverseFlag = 1;
         if (c == 'L') {
            LengFlag = 1;
            AddrUnit = temp1[2]-'0';
         }
      }
      else {
         printf("Input syntax error!\nSyntax:   CONV3 inputfile [inputfile...] [-O outputfile] [-R|-R3] [-L2|-L3|-L4]");
         exit(0);
      }
      i++;
   }
   CheckFilename(outflag,fnout);

   if ((fdsy=open(fnsy,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)   {
      close(fdin);
      PrintError("Error opening table output file!");
      abort();
   }
   write(fdsy,file_header,20);

/* signal(SIGINT,CntlCHandler2); */

   memset(blkSymBuf,NULL,sizeof(blkSymBuf));
   memset(lineInfoPos,NULL,sizeof(lineInfoPos));
   memset(modpos,NULL,sizeof(modpos));
   totalinxcnt = 0;
   memset(&modloc,NULL,sizeof(modloc));
   memset(&modinxcnt,NULL,sizeof(modinxcnt));
   memset(&lineInfoLoc,NULL,sizeof(lineInfoLoc));

   if ((modloc=malloc(sizeof(struct module_location))) == NULL)
      prn_exit("Error allocating memory!\r\n");
   memset(modloc,NULL,sizeof(struct module_location));
   if ((modpos=modloc->ptr=malloc(sizeof(long)*NO_MODULE)) == NULL)
      prn_exit("Error allocating memory!\r\n");

   if ((modinxcnt=malloc(sizeof(struct module_index_count))) == NULL)
      prn_exit("Error allocating memory!\r\n");
   memset(modinxcnt,NULL,sizeof(struct module_index_count));
   if ((modinxpos=modinxcnt->ptr=malloc(sizeof(int)*NO_MODULE)) == NULL)
      prn_exit("Error allocating memory!\r\n");

   if ((lineInfoLoc=malloc(sizeof(struct line_info_location))) == NULL)
      prn_exit("Error allocating memory!\r\n");
   memset(lineInfoLoc,NULL,sizeof(struct line_info_location));
   if ((lineInfoPos=lineInfoLoc->ptr=malloc(sizeof(long)*NO_MODULE)) == NULL)
      prn_exit("Error allocating memory!\r\n");

   if ((typePosBuf=malloc((sizeof(long)*TYPEBUFNO))) == NULL)
      prn_exit("Error allocating memory!\r\n");
   memset( typePosBuf, NULL, sizeof(long)*TYPEBUFNO );
   typePosInxCnt = 0;
   *srtbuf = buffer;
   *srtadrbuf = buffer;
}

PrintError(char *msg)
{
   switch (errno) {
      case EACCES:
         printf("\r\nFile access error!");
         break;
      case EEXIST:
         printf("\r\nFile already exists!");
         break;
      case EMFILE:
         printf("No more file handles available!");
         break;
      case ENOENT:
         printf("File not found!");
         break;
   }
   printf("%s",msg);
}

/**************************************************************************/
/***** NormalExit()                                                  ******/
/**************************************************************************/

NormalExit()
{
 int ii;
 long lpos;
 struct module_location *ptr;
 struct module_index_count *mptr;
 struct line_info_location *lptr;

   ProcessAddressEntries();

   lpos = tell(fdsy);    modinx++;
   write(fdsy,(unsigned char *)&att,sizeof(struct attribute));
   write(fdsy,(unsigned char *)&modinx,sizeof(modinx));
   write(fdsy,(unsigned char *)&totalinxcnt,sizeof(totalinxcnt));
   write(fdsy,(unsigned char *)&totalsymcnt,sizeof(totalsymcnt));
   write(fdsy,(unsigned char *)&gblsymcnt,sizeof(int));
   write(fdsy,(unsigned char *)&inxcnt,sizeof(inxcnt));
   write(fdsy,(unsigned char *)&typePosInxCnt,sizeof(typePosInxCnt));
   write(fdsy,(unsigned char *)&typePosBuf[0], sizeof(long)*typePosInxCnt);
   free(typePosBuf);
   if (gblsymcnt != 0)
      write(fdsy,(unsigned char *)&gblinxpos,sizeof(struct two_long));
   if (totalsymcnt > 0)
      write(fdsy,(unsigned char *)&startpos,sizeof(struct two_long));
   if (modinx > 0) {
      ii = modinx;
      while (modloc != NULL) {
         if (ii > NO_MODULE) {
            write(fdsy,(unsigned char *)modloc->ptr,NO_MODULE*sizeof(long));
            ii -= NO_MODULE;
         } else  {
            write(fdsy,(unsigned char *)modloc->ptr,ii*sizeof(long));
            ii -= ii;
         }
         free(modloc->ptr);
         ptr = modloc->next;
         free(modloc);
         modloc = ptr;
      }
      ii = modinx;
      while (modinxcnt != NULL) {
         if (ii > NO_MODULE) {
            write(fdsy,(unsigned char *)modinxcnt->ptr,NO_MODULE*sizeof(int));
            ii -= NO_MODULE;
         } else {
            write(fdsy,(unsigned char *)modinxcnt->ptr,ii*sizeof(int));
            ii -= ii;
         }
         free(modinxcnt->ptr);
         mptr = modinxcnt->next;
         free(modinxcnt);
         modinxcnt = mptr;
      }
      ii = modinx;
      while (lineInfoLoc != NULL) {
         if (ii > NO_MODULE) {
            write(fdsy,(unsigned char *)lineInfoLoc->ptr,NO_MODULE*sizeof(long));
            ii -= NO_MODULE;
         } else  {
            write(fdsy,(unsigned char *)lineInfoLoc->ptr,ii*sizeof(long));
            ii -= ii;
         }
         free(lineInfoLoc->ptr);
         lptr = lineInfoLoc->next;
         free(lineInfoLoc);
         lineInfoLoc = lptr;
      }
   } else {
      free(modloc->ptr);
      free(modloc);
      free(modinxcnt->ptr);
      free(modinxcnt);
      free(lineInfoLoc->ptr);
      free(lineInfoLoc);
   }
   write(fdsy,(unsigned char *)&lpos,sizeof(long));  /*start pos of junk*/
   fcloseall();
   close(fdin);
   close(fdsy);
   close(fds1);
   close(fds2);
   close(fds3);
   close(fds4);
   close(fds5);
   unlink(fns1);
   unlink(fns2);
   unlink(fns3);
   unlink(fns4);
   unlink(fns5);
   rmtmp();
   return;
}

/************************************************************/
/*** prn_exit(msg) : abnormal exit                        ***/
/*** print a message to the screen and exit the program   ***/
/************************************************************/

prn_exit(char *msg)
{
 struct module_location *ptr;
 struct module_index_count *mptr;
 struct line_info_location *lptr;

   while (modloc != NULL) {
      free(modloc->ptr);
      ptr = modloc->next;
      free(modloc);
      modloc = ptr;
   }
   while (modinxcnt != NULL) {
      free(modinxcnt->ptr);
      mptr = modinxcnt->next;
      free(modinxcnt);
      modinxcnt = mptr;
   }
   while (lineInfoLoc != NULL) {
      free(lineInfoLoc->ptr);
      lptr = lineInfoLoc->next;
      free(lineInfoLoc);
      lineInfoLoc = lptr;
   }
   if (typePosBuf != NULL) free(typePosBuf);
   if (finx != NULL) free( finx );
   if (minx != NULL) free( minx );
   if (pcnt != NULL) free( pcnt );
   close(fdin);
   printf("%s",msg);
   close(fds1);
   close(fds2);
   close(fds3);
   close(fds4);
   close(fds5);
   unlink(fns1);
   unlink(fns2);
   unlink(fns3);
   unlink(fns4);
   unlink(fns5);
   close(fdsy);
   unlink(fnsy);
   signal(SIGINT,SIG_DFL);
   abort();
}

/**************************************************************************/
/***** CheckFilename()                                                 ****/
/**************************************************************************/

CheckFilename(int outflag, char *fnout)
{
 char *cptr1,*cptr2;
 int  redo=0;

/* processing the input filename */
   cptr1 = strrchr(fnin[0],'.');
   cptr2 = strrchr(fnin[0],'\\');
   if (cptr1 == NULL)   strcpy(fnmp,fnin[0]);
   else {
      if (cptr2 == NULL) memcpy(fnmp,fnin[0],strlen(fnin[0])-strlen(cptr1));
      else if (strlen(cptr1) > strlen(cptr2)) strcpy(fnmp,fnin[0]);
      else memcpy(fnmp,fnin[0],strlen(fnin[0])-strlen(cptr1));
   }
   strcpy(fnls,fnmp);
   strcat(fnmp,".MAP");
   strcat(fnls,".LST");

/* processing the output filename */
   if (outflag)  {
      cptr1 = fnout;
      while (*cptr1 != '\0') {
         *cptr1 = toupper(*cptr1);
         cptr1++;
      }
      cptr1 = strrchr(fnout,'.');
      cptr2 = strrchr(fnout,'\\');
      if (cptr2 != NULL) cptr2++;
      else {
         cptr2 = strchr(fnout,':');
         if (cptr2 == NULL) cptr2 = fnout;
         else cptr2++;
      }
      if (*cptr2 != NULL)  {
         if ((cptr1 != NULL) && strlen(cptr1) < strlen(cptr2)) *cptr1 = NULL;
         strcpy(fnsy,fnout);      strcat(fnsy,".USD");
         return(OK);
      }
      redo = 1;
   }
   cptr1 = strrchr(fnin[0],'.');
   cptr2 = strrchr(fnin[0],'\\');
   if (cptr2 != NULL) cptr2++;
   else {
      cptr2 = strrchr(fnin[0],':');
      if (cptr2 == NULL) cptr2 = fnin[0];
      else cptr2++;
   }
   if (cptr1 == NULL) strcpy(fnsy,cptr2);
   else {
      if (strlen(cptr1) < strlen(cptr2))
         memcpy(fnsy,cptr2,strlen(cptr2)-strlen(cptr1));
      else strcpy(fnsy,cptr2);
   }
   if (redo)  {
      char  name[42];
      memset(name,NULL,42);
      strcpy(name,fnout);
      strcat(name,fntb);
      strcpy(fnsy,name);
   }
   strcat(fnsy,".USD");
   return(OK);
}

/*****************************************************************************/
/***** OpenTempFile(n)                                                   *****/
/*****************************************************************************/

OpenTempFile(int cnt)
{
 char *cp1;
 FILE *fp;
 int  opencnt=0;

   memset(fns3,NULL,40);
   cp1 = tempnam(NULL,"USDCNV");
   strcpy(fns3,cp1);
   if ((fds3=open(fns3,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)   {
      PrintError("Error opening temporary file!\n");
      prn_exit("");
   }
   memset(fns1,NULL,40);
   cp1 = tempnam(NULL,"USDCNV");
   strcpy(fns1,cp1);
   if ((fds1=open(fns1,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)   {
      PrintError("Error opening temporary file!\n");
      prn_exit("");
   }
   else opencnt++;
   if (cnt == 1) return(opencnt);

   memset(fns2,NULL,40);
   cp1 = tempnam(NULL,"USDCNV");
   strcpy(fns2,cp1);
   if ((fds2=open(fns2,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)   {
      PrintError("Error opening temporary file!\n");
      prn_exit("");
   }
   else opencnt++;
   if (cnt == 2) return(opencnt);

   memset(fns4,NULL,40);
   cp1 = tempnam(NULL,"USDCNV");
   strcpy(fns4,cp1);
   if ((fds4=open(fns4,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)   {
      PrintError("Error opening temporary file!\n");
      prn_exit("");
   }
   else opencnt++;

   memset(fns5,NULL,40);
   cp1 = tempnam(NULL,"USDCNV");
   strcpy(fns5,cp1);
   if ((fds5=open(fns5,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE)) == -1)   {
      PrintError("Error opening temporary file!\n");
      prn_exit("");
   }
   else opencnt++;

   if (opencnt < cnt ) prn_exit("Error opening temp files!\r\n");
   return(OK);
}

/****************************************************************************/
/***** CheckMRIFormat()                                                 *****/
/****************************************************************************/

CheckMRIFormat(int inputFileNum)
{
 FILE *fp;
 char line[80];
 int mriyes=0;

   if ((fp=fopen(fnin[ inputFileNum ],"rt")) == NULL)
      prn_exit("Error opening input file!\r\n");
   while (fgets(line,80,fp) != NULL)  {
      if (strstr(line,"$$") == NULL) continue;
      else {
         mriyes = 1;
         call = mri68k51z80;
         break;
      }
   }
   fclose(fp);
   if (!mriyes) call = ErrorOut;
   return;
}

ErrorOut()
{
    prn_exit("Invalid input file format!\r\n");
}

/**************************************************************************/
/***** ProcessModSym(ffdd)                                           ******/
/**************************************************************************/

ProcessModSym(int ffdd)
{
 struct module_location *ptr;
 struct module_index_count *mptr;
 div_t result;

   putchar(rotChar[rotCnt&3]);
   putchar(0x8);
   rotCnt++;
   totalsymcnt += modsymcnt;
   gblmod.mod_symno = modsymcnt;
   if (modsymcnt > 0) sort_symbol(ffdd,modsymcnt,1);
   *modinxpos++ = inxcnt;
   *modpos++ = tell(fdsy);
   write(fdsy,(unsigned char *)&gblmod,sizeof(struct module));
   if (inxcnt > 0)  {
      totalinxcnt += inxcnt;
      write(fdsy,(unsigned char *)syminx,sizeof(struct symindex)*inxcnt);
      memset(&bigname,NULL,sizeof(bigname));
      free(syminx);
      inxcnt = 0;
   }
   lseek(ffdd,0L,0);
   result = div(modinx,NO_MODULE-1);
   if (result.quot > 0 && result.rem == 0) {
      ptr = modloc;
      while (ptr->next != NULL) ptr = ptr->next;
      if ((ptr->next=malloc(sizeof(struct module_location))) == NULL)
         prn_exit("Error allocating memory!\r\n");
      else {
         memset(ptr->next,NULL,sizeof(struct module_location));
         ptr = ptr->next;
         if ((ptr->ptr=malloc(sizeof(long)*NO_MODULE)) == NULL)
            prn_exit("Error allocating memory!\r\n");
         else modpos = ptr->ptr;
      }
      mptr = modinxcnt;
      while (mptr->next != NULL) mptr = mptr->next;
      if ((mptr->next=malloc(sizeof(struct module_index_count))) == NULL)
         prn_exit("Error allocating memory!\r\n");
      else {
         memset(mptr->next,NULL,sizeof(struct module_index_count));
         mptr = mptr->next;
         if ((mptr->ptr=malloc(sizeof(int)*NO_MODULE)) == NULL)
            prn_exit("Error allocating memory!\r\n");
         else modinxpos = mptr->ptr;
      }
   }
}

/**************************************************************************/
/***** ProcessLinnumInfo()                                           ******/
/**************************************************************************/
ProcessLinnumInfo()
{
 div_t result;
 struct line_info_location *ptr;
 U8 *tmpBuf;
 U32 startAddr=0L, endAddr=0L;

   tmpBuf = malloc( 8 + lineInfoLen );
   memcpy( tmpBuf,(U8 *)&modinx, sizeof(modinx));             // 2 bytes
   memcpy( tmpBuf+2,(U8 *)&linnumFrame, sizeof(linnumFrame)); // 2 bytes
   memcpy( tmpBuf+4,(U8 *)&lineInfoLen, sizeof(lineInfoLen)); // 4 bytes
   if (lineInfoLen) {
      lseek(fds4,0L,0);
      read(fds4, tmpBuf+8, lineInfoLen );
   }
   if (lineInfoLen >= 4 && !blkcnt ) {
      startAddr = (U32) tmpBuf[11];
      startAddr = (startAddr << 8 ) + tmpBuf[10];
      startAddr += ((U32)linnumFrame << 16);
      gblmod.modStart = startAddr;
      endAddr = (U32) tmpBuf[lineInfoLen+7];
      endAddr = (endAddr << 8 ) + tmpBuf[lineInfoLen+6];
      endAddr += ((U32)linnumFrame << 16);
      gblmod.modEnd = endAddr;
   }
   if (lineInfoLen) {
      *lineInfoPos++ = tell(fdsy);
      write(fdsy, tmpBuf, lineInfoLen+8 );
   }
   else *lineInfoPos++ = 0L;
   free( tmpBuf );
   lseek(fds4,0L,0);
   lineInfoLen = 0L;
   result = div(modinx+1,NO_MODULE-1);
   if (result.quot > 0 && result.rem == 0) {
      ptr = lineInfoLoc;
      while (ptr->next != NULL) ptr = ptr->next;
      if ((ptr->next=malloc(sizeof(struct line_info_location))) == NULL)
         prn_exit("Error allocating memory!\r\n");
      else {
         memset(ptr->next,NULL,sizeof(struct line_info_location));
         ptr = ptr->next;
         if ((ptr->ptr=malloc(sizeof(long)*NO_MODULE)) == NULL)
            prn_exit("Error allocating memory!\r\n");
         else lineInfoPos = ptr->ptr;
      }
   }
}

/**************************************************************************/
/***** ProcessLinnumInfo695()                                           ******/
/**************************************************************************/
ProcessLinnumInfo695(U32 start, U32 end)
{
 div_t result;
 struct line_info_location *ptr;
 U8 *tmpBuf;

   tmpBuf = malloc( 8 + lineInfoLen );
   memcpy( tmpBuf,(U8 *)&modinx, sizeof(modinx));        // 2 bytes
   memset( tmpBuf+2, NULL, sizeof(linnumFrame)); // 2 bytes
   memcpy( tmpBuf+4,(U8 *)&lineInfoLen, sizeof(lineInfoLen)); // 4 bytes
   if (lineInfoLen) {
      lseek(fds4,0L,0);
      read(fds4, tmpBuf+8, lineInfoLen );
   }
   if (lineInfoLen >= 4 && !blkcnt ) {
      gblmod.modStart = start;
      gblmod.modEnd = end;
   }
   if (lineInfoLen) {
      *lineInfoPos++ = tell(fdsy);
      write(fdsy, tmpBuf, lineInfoLen+8 );
   }
   else *lineInfoPos++ = 0L;
   free( tmpBuf );
   lseek(fds4,0L,0);
   lineInfoLen = 0L;
   result = div(modinx+1,NO_MODULE-1);
   if (result.quot > 0 && result.rem == 0) {
      ptr = lineInfoLoc;
      while (ptr->next != NULL) ptr = ptr->next;
      if ((ptr->next=malloc(sizeof(struct line_info_location))) == NULL)
         prn_exit("Error allocating memory!\r\n");
      else {
         memset(ptr->next,NULL,sizeof(struct line_info_location));
         ptr = ptr->next;
         if ((ptr->ptr=malloc(sizeof(long)*NO_MODULE)) == NULL)
            prn_exit("Error allocating memory!\r\n");
         else lineInfoPos = ptr->ptr;
      }
   }
}
/**************************************************************************/
/***** ProcessGblSym(ffdd)                                           ******/
/**************************************************************************/

ProcessGblSym(int ffdd)
{
 int  i;

   if (gblsymcnt <= 0) return;
   totalsymcnt += gblsymcnt;
   lseek(ffdd,0L,0);
   memset(&startpos,NULL,sizeof(struct two_long));
   i = modinx;     modinx = -1;
   gblinxpos.ll1 = tell(fdsy);
   sort_symbol(ffdd,gblsymcnt,1);
   modinx = i;
   totalinxcnt += inxcnt;
   gblinxpos.ll2 = tell(fdsy);
   write(fdsy,(unsigned char *)&syminx[0],sizeof(struct symindex)*inxcnt);
   free(syminx);
}

/*************************************************************************/
/***** ProcessAddressEntries()                                      ******/
/*************************************************************************/

ProcessAddressEntries()
{
   MergeSize = MRGADRSZ;    RecLen = ADRRECLEN;
   startpos.ll1 = tell(fdsy);
   sort_symbol(fds3,totalsymcnt,0);
   startpos.ll2 = tell(fdsy);
   write(fdsy,(unsigned char *)&adrinx[0],sizeof(struct adrindex)*inxcnt);
   free(adrinx);
}

/*************************************************************************/
/***** ResetEnvironment()                                           ******/
/*************************************************************************/

ResetEnvironment()
{
   modsymcnt = 0;        inxcnt=0;      srtinx=0;
   memset(&gblmod,NULL,sizeof(struct module));
}

/****************************************************************************/
/***** sort_symbol(fdi,cnt);                                            *****/
/****************************************************************************/

sort_symbol(int fdi, int cnt, int sflag) // sflag= 0: address;  = 1: symbol
{
 int i,j,k,pcs,actcnt,fdo;
 char fno[20],*cp1,*cp2;
 long lpos,lpos2;
 unsigned long ultmp;

   pcs = cnt / MergeSize + 1;                 // MergeSize == 1300
   if (cnt >= MergeSize) actcnt = MergeSize;
   else     actcnt = cnt;
   lseek(fdi,0L,0);


   k = (cnt / INDEX_RANGE) + 2;
   if (sflag) {  /* allocating memory for symbol and address indexes */
      if ((syminx=(struct symindex *)malloc(k*sizeof(struct symindex))) == NULL)
         prn_exit("Insufficient memory!");
   }
   switch (pcs)   {
      case 1:    // symbol counts(modsymcnt or gblsymcnt) < MergeSize (1300)
         if (sflag)  {           // sort by name
            lseek(fdi,0L,0);
            k=actcnt;
            memset(srtbuf,NULL,sizeof(buffer));
            read(fdi,srtbuf[0],k*RecLen);
            qsort(srtbuf,k,RecLen,NameComp);
            if (strcmpi(bigname.name,&srtbuf[k][2]) < 0)
               strcpy(bigname.name,&srtbuf[k][2]);
            lseek(fdi,0L,0);
            write(fdi,srtbuf[0],k*RecLen);
            update_filepos(fdi,cnt,sflag);
         }
         else {                // sort by addr
            RecLen = ADRRECLEN;
            lseek(fdi,0L,0);
            k=actcnt;
            memset(srtadrbuf,NULL,sizeof(buffer));
            read(fdi,srtadrbuf[0],k*RecLen);
            qsort(srtadrbuf,k,RecLen,AddrComp);
            AddrSubsortName(k);
            lseek(fdi,0L,0);
            write(fdi,srtadrbuf[0],k*RecLen);
            update_filepos(fdi,cnt,sflag);
         }
         break;

      default:   // modsymcnt or gblsymcnt >= MergeSize
         cp1 = tempnam(NULL,"USDCNV");
         strcpy(fno,cp1);
         if ((fdo=open(fno,O_RDWR | O_BINARY | O_CREAT | O_TRUNC,
              S_IREAD | S_IWRITE)) == -1)   {
            PrintError("Error opening temp file!");
            prn_exit("");
         }
         if (sflag) {          /* sorting the symbols by  name ...  */
            lseek(fdi,0L,0);
            lseek(fdo,0L,0);
            k=actcnt;
            for (j=pcs; j > 0; j--)  {
               memset(srtbuf[0],NULL,RecLen*k);
               read(fdi,srtbuf[0],RecLen*k);
               qsort(srtbuf,k,RecLen,NameComp);
               write(fdo,srtbuf[0],RecLen*k);
               if (strcmpi(bigname.name,&srtbuf[k][2]) < 0)
                  strcpy(bigname.name,&srtbuf[k][2]);
               if (j - 1 == 1 )    k = cnt % MergeSize;
            }
            merge_symbol(fdo,fdi,cnt,pcs,sflag);
            update_filepos(fdi,cnt,sflag);
         }
         else {               /* sorting the symbols by  addr ...  */
            lseek(fdi,0L,0);
            lseek(fdo,0L,0);
            k=actcnt;
            for (j=pcs; j > 0 ; j--)  {
               memset(srtadrbuf[0],NULL,RecLen*k);
               read(fdi,srtadrbuf[0],RecLen*k);
               qsort(srtadrbuf,k,RecLen,AddrComp);
               AddrSubsortName(k);
               write(fdo,srtadrbuf[0],RecLen*k);
               if (memcmp(bigaddr.addr,&srtadrbuf[k-1][6],AddrUnit) < 0)
                  memcpy(bigaddr.addr,&srtadrbuf[k-1][6],AddrUnit);
               if (j - 1 == 1 )    k = cnt % MergeSize;
            }
            merge_symbol(fdo,fdi,cnt,pcs,sflag);
            update_filepos(fdi,cnt,sflag);
         } // end if (sflag)
         close(fdo);
         if (remove(fno) == -1) prn_exit("Error deleting temp file !\n");
         free(fno);
         break;
   }   /* end switch */
   lseek(fdi,0L,0);
   return;
}

/****************************************************************************/
/***** AddrSubsortName(count);                                          *****/
/****************************************************************************/
AddrSubsortName(int count)
{
 int i,start,cnt;

   for (i=1,start=0,cnt=0; i<count; i++) {
      if (AddrComp(srtadrbuf[start],srtadrbuf[i]) != 0) {
         if (cnt > 0) {
            qsort(&srtadrbuf[start][0],cnt+1,ADRRECLEN,ModComp);
            cnt = 0;
         }
         start = i;
      }
      else {
         cnt++;
         continue;
      }
   }
   if (cnt > 0) qsort(&srtadrbuf[start][0],cnt+1,ADRRECLEN,ModComp);
}

/****************************************************************************/
/***** ModComp(*s1, *s2);                                               *****/
/****************************************************************************/
ModComp(unsigned char *s1, unsigned char *s2)
{
 struct atag {
    int inx;
    long fpos;
    unsigned char addr[6];
 } *ss1, *ss2;
 long i;
 int j;

   ss1 = (struct atag *)s1;
   ss2 = (struct atag *)s2;
   i = ss1->fpos - ss2->fpos;
   if (ss1->inx > ss2->inx) return(1);
   else
      if (ss1->inx == ss2->inx) {
         if (i > 0) return(1);
         else if (i == 0) return(0);
         else if (i < 0) return(-1);
      }
      else if (ss1->inx < ss2->inx) return(-1);
}

/***************************************************************************/
/*** merge_symbol(fdi,fdo,cnt,pcs)                                      ****/
/***************************************************************************/

merge_symbol(int fdi, int fdo, int cnt, int pcs, int sflag)
{                                       /*sflag= 1: by name, 0: by abs addr */
 unsigned char (*outbuf)[SYMRECLEN];
 unsigned char (*outadrbuf)[ADRRECLEN];
 int i,j,k,l,pp,jj,mn,zz;

   lseek(fdo,0L,0);
   lseek(fdi,0L,0);
   *outbuf = outblock;
   *outadrbuf = outblock;
   minx = (int *)calloc(pcs  ,sizeof(int));
   if (minx == NULL) prn_exit("Memory allocation error!\n");
   finx = (int *)calloc(pcs  ,sizeof(int));
   if (finx == NULL) prn_exit("Memory allocation error!\n");
   pcnt = (int *)calloc(pcs  ,sizeof(int));
   if (pcnt == NULL) prn_exit("Memory allocation error!\n");

   memset(minx,NULL,sizeof(int)*pcs);
   memset(finx,NULL,sizeof(int)*pcs);
   memset(pcnt,NULL,sizeof(int)*pcs);
   memset(outbuf[0],NULL,RecLen*INDEX_RANGE);

   unit = MergeSize / pcs;
   last_piece = cnt % MergeSize;

   for (i=0; i < pcs  ; i++) sym_fill_in(fdi,i,pcs,sflag);
   pp=0;
   mn = 0;
   do {
      /* check each piece if need any refill */
      for (j=0; j < pcs  ; j++) {
         if (j == pcs  -1 && *(pcnt+j) == last_piece) continue;
         else if (j < pcs  -1 && *(pcnt+j) == MergeSize) continue;
         else if (*(minx+j) == unit) sym_fill_in(fdi,j,pcs,sflag);
      }
      /* get any element to be compared with */
      for (j=0; j < pcs; j++)  {
         if (j == pcs  -1 && *(pcnt+j) == last_piece) continue;
         else if (j < pcs  -1 && *(pcnt+j) == MergeSize) continue;
         else {
            l = unit*j + *(minx+j);
            jj = j;
         }
         break;
      }    /* end for j */
      /* get the smallest one from the top elements of the n-piece */
      for (j=0; j < pcs; j++)  {
         if (j == pcs  -1 && *(pcnt+j) == last_piece) continue;
         else if (j < pcs  -1 && *(pcnt+j) == MergeSize) continue;
         k = unit*j + (*(minx+j));
         if (sflag)    zz = NameComp(srtbuf[l],srtbuf[k]);
         else          zz = AddrComp(srtadrbuf[l],srtadrbuf[k]);
         if (!zz && !sflag) zz = ModComp(srtadrbuf[l],srtadrbuf[k]);
         if (zz > 0) {
            jj = j;
            l = k;
         }
      }    /* end for j */
      if (sflag) memcpy(outbuf[pp],srtbuf[l],RecLen);
      else       memcpy(outadrbuf[pp],srtadrbuf[l],RecLen);
      pp++;
      if (pp == INDEX_RANGE)   {
         if (sflag) {
            write(fdo,outbuf[0],RecLen*pp);
            memset(outbuf[0],NULL,pp*RecLen);
         } else {
            write(fdo,outadrbuf[0],RecLen*pp);
            memset(outadrbuf[0],NULL,pp*RecLen);
         }
         pp = 0;
      }
      (*(pcnt+jj))++;
      (*(minx+jj))++;
      mn++;
   } while (mn < cnt);
   if (sflag) {
      write(fdo,outbuf[0],RecLen*pp);
      memset(outbuf[0],NULL,pp*RecLen);
   } else {
      write(fdo,outadrbuf[0],RecLen*pp);
      memset(outadrbuf[0],NULL,pp*RecLen);
   }
   free(minx);
   free(finx);
   free(pcnt);
   return;
}

/***************************************************************************/
/***** update_filepos(sflag,lpos,cnt,fdo)                               ****/
/***************************************************************************/

update_filepos(int fdi, int cnt, int sflag)
{
 int i,x,y,pcs,tcnt,icnt,j,rlocpos,samecnt=0,sameinx=0,totaldiffcnt=0;
 unsigned long ltmp;
 unsigned char *ttmp;
 unsigned char (*outadrbuf)[ADRRECLEN];
 long lpos,spos,ll;
 struct adrindex *aptr;

   pcs = cnt / MergeSize + 1;
   icnt = tcnt = cnt;
   lseek(fdi,0L,0);
   ttmp = (unsigned char *)calloc(INDEX_RANGE,RecLen);
   if (ttmp == NULL) prn_exit("Error allocating memory!\n");
   switch (sflag)   {
      case 1: /* SYB: by name: n(1),name(n),addr(AddrUnit) */
         ll = lpos = tell(fdsy);
         for (i=0,inxcnt=0,y=0; pcs > 0; pcs--,cnt-=icnt)  {
             memset(srtbuf[0],NULL,sizeof(srtbuf));
             if (pcs > 1)   icnt = MergeSize;
             else if (pcs == 1) icnt = cnt;
             spos = tell(fdi);
             read(fdi,srtbuf[0],icnt*RecLen);
             for (x=0; x < icnt; x++)   {
                if (strcmpi(&srtbuf[x][2],bigname.name) > 0)
                   strcpy(bigname.name,&srtbuf[x][2]);
                memcpy(ttmp+y,&srtbuf[x][1],(int)srtbuf[x][1]+1);
                y += (int)srtbuf[x][1]+1;
                memcpy(ttmp+y,&srtbuf[x][42],AddrUnit);
                y += AddrUnit;
                memcpy(ttmp+y,&srtbuf[x][48],2);
                y += 2;
                i++;
                if (!(i % INDEX_RANGE))  {
                   write(fdsy,ttmp,y);
                   memset(ttmp,NULL,INDEX_RANGE*RecLen);
                   y = 0;
//                 ll = lpos = tell(fdsy);
                   ll = tell(fdsy);
                }
                if ((i % INDEX_RANGE) == 1)   {
                   if ((tcnt - i) >= INDEX_RANGE)
                      syminx[inxcnt].cnt = INDEX_RANGE;
                   else syminx[inxcnt].cnt = tcnt - i + 1;
                   syminx[inxcnt].fpos = tell(fdsy);
                   memcpy(syminx[inxcnt++].name,&srtbuf[x][2],40);
                }
                if (AbsFlag && !H8Flag && !R3Flag)  {
                   absaddr(&srtbuf[x][42]);
                   memcpy(&srtbuf[x][42],absad,AddrUnit);
                }
                memcpy(&srtbuf[x][36],&modinx,2);
                memcpy(&srtbuf[x][38],&lpos,4);
                memcpy(srtadrbuf[x],&srtbuf[x][36],ADRRECLEN); //ADRRECLEN==12
                lpos = ll + y;
             }
             lseek(fdi,spos,0);
             write(fdi,srtbuf[0],icnt*RecLen);
             write(fds3,srtadrbuf[0],icnt*ADRRECLEN);
             write(fdsy,ttmp,y);
             memset(ttmp,NULL,INDEX_RANGE*RecLen);
             y = 0;
             ll = lpos = tell(fdsy);
         }
         syminx[inxcnt].cnt = 0;
         syminx[inxcnt].fpos = 0L;
         strcpy(syminx[inxcnt++].name,bigname.name);
         break;

      case  0: /* SYB: by addr: addr(AddrUnit),n(1),name(n),log_addr(AddrUnit) if (AbsFlag) */
         j = 2 + 4 + AddrUnit;
         memset(&sameaddr,NULL,sizeof(struct adrindex));
         *outadrbuf = outblock;
         memset(outadrbuf[0],NULL,sizeof(outblock));
         lseek(fds1,0L,0);
         for (i=0,y=0,inxcnt=0; pcs > 0; pcs--,cnt-=icnt)  {
            memset(srtadrbuf[0],NULL,sizeof(buffer));
            if (pcs > 1)   icnt = MergeSize;
            else if (pcs == 1) icnt = cnt;
            read(fdi,srtadrbuf[0],icnt*RecLen);
            for (x=0; x < icnt; x++)   {
               if (memcmp(sameaddr.addr,&srtadrbuf[x][6],AddrUnit) == 0)
                  samecnt++;
               else {
                  sameaddr.cnt = samecnt;
                  memcpy(outadrbuf[sameinx++],&sameaddr,sizeof(sameaddr));
                  totaldiffcnt++;
                  if (sameinx == (INDEX_RANGE*SYMRECLEN/ADRRECLEN)) {
                     write(fds1,outadrbuf[0],sameinx*ADRRECLEN);
                     sameinx = 0;
                  }
                  memcpy(sameaddr.addr,&srtadrbuf[x][6],AddrUnit);
                  sameaddr.fpos = (int) i;
                  samecnt = 1;
               }
               if (memcmp(&srtadrbuf[x][6],bigaddr.addr,AddrUnit) > 0)
                  memcpy(bigaddr.addr,&srtadrbuf[x][6],AddrUnit);
               i++;
               memcpy(ttmp+y,srtadrbuf[x],j);
               y += j;
               if (!(i % INDEX_RANGE))  {
                  write(fdsy,ttmp,y);
                  memset(ttmp,NULL,y);
                  y = 0;
               }
            }
            sameaddr.cnt = samecnt;
            memcpy(outadrbuf[sameinx++],&sameaddr,sizeof(sameaddr));
            totaldiffcnt++;
            write(fds1,outadrbuf[0],sameinx*ADRRECLEN);
            sameinx = 0;
            write(fdsy,ttmp,y);
            memset(ttmp,NULL,y);
            y = 0;
         }
//       adrinx[inxcnt].cnt = 0;
//       adrinx[inxcnt].fpos = i-1;
//       memcpy(adrinx[inxcnt++].addr,bigaddr.addr,AddrUnit);
// create the addreess indexes:
         i = totaldiffcnt / INDEX_RANGE + 2;
         lseek(fds1,0L,0);
         if ((adrinx=(struct adrindex *)malloc(i*sizeof(struct adrindex))) == NULL)
            prn_exit("Insufficient memory!");

         sameinx = 0;
         cnt = totaldiffcnt;   pcs = totaldiffcnt / MergeSize + 1;
         for (i=0,y=0,inxcnt=0; pcs > 0; pcs--,cnt-=icnt)  {
            memset(srtadrbuf[0],NULL,sizeof(buffer));
            if (pcs > 1)   icnt = MergeSize;
            else if (pcs == 1) icnt = cnt;
            read(fds1,srtadrbuf[0],icnt*RecLen);
            if (i == 0) {
               aptr = (struct adrindex *) srtadrbuf[0];
               adrinx[inxcnt].fpos = aptr->fpos;
               memcpy(adrinx[inxcnt].addr,aptr->addr,AddrUnit);
            }
            for (x=0; x < icnt; x++)   {
               i++;
               aptr = (struct adrindex *) srtadrbuf[x];
               if (sameinx >= INDEX_RANGE) {
                  adrinx[inxcnt++].cnt = sameinx;
                  sameinx = 0;
                  adrinx[inxcnt].fpos = aptr->fpos;
                  memcpy(adrinx[inxcnt].addr,aptr->addr,AddrUnit);
               }
               sameinx += aptr->cnt;
            }
         }
         adrinx[inxcnt++].cnt = sameinx;
         memcpy(adrinx[inxcnt].addr,bigaddr.addr,AddrUnit);
//       memcpy(adrinx[inxcnt].addr,aptr->addr,AddrUnit);
         adrinx[inxcnt].cnt = 0;
         adrinx[inxcnt++].fpos = 0L;
         break;
   }  /* end switch */
   free(ttmp);
   return;
}


/***************************************************************************/
/*** sym_fill_in(i)                                                     ****/
/***************************************************************************/

sym_fill_in( int fdi, int inx, int pcs, int sflag)
{
// sflag =1: by name,  =0 by addr
 int i,j,k;
 int zz,yy;
 long iii;

   i = inx * MergeSize + *(finx+inx);        /* starting record in file */
   if (inx == pcs  -1)  k = MergeSize * inx + last_piece -1;
   else    k = MergeSize * (inx+1) - 1;
   if ((j=i+unit-1 - k) < 0)  j = unit;
   else j = k - i + 1;
   if (j == 0) return;
   iii = ((long)i) * RecLen;
   lseek(fdi ,iii,0);
   if (sflag) read(fdi ,srtbuf[unit*inx],j*RecLen);
   else       read(fdi ,srtadrbuf[unit*inx],j*RecLen);
   *(minx+inx) = 0;
   *(finx+inx) += j;
}

/***************************************************************************/
/***** absaddr(addr)                                                   *****/
/***************************************************************************/

absaddr(unsigned char *addr)
{
 unsigned long cs,ip;

   cs = (unsigned long)addr[0];
   cs = (cs << 8) + addr[1];
   ip = (unsigned long)addr[2];
   ip = (ip << 8) + addr[3];
   if (AddrUnit == 6)  {
      ip = (ip << 8) + addr[4];
      ip = (ip << 8) + addr[5];
   }
   cs = cs << 4;
   cs += ip;
   memset(absad,NULL,6);
   absad[0] = (unsigned char)(cs >> 24);
   absad[1] = (unsigned char)(cs >> 16);
   absad[2] = (unsigned char)(cs >> 8);
   absad[3] = (unsigned char)cs;
   return;
}

/***************************************************************************/
/**** AddrComp(s1,s2)                                                 *****/
/***************************************************************************/

AddrComp(unsigned char *s1, unsigned char *s2)
{
   return(memcmp((s1+6),(s2+6),AddrUnit));
}

/***************************************************************************/
/**** NameComp(s1,s2)                                                 *****/
/***************************************************************************/

NameComp(unsigned char *s1, unsigned char *s2)
{
   return(strcmpi(s1+2,s2+2));
}


chk_heap()
{
 int status;

   status = _heapchk();
   printf("\n");
   switch (status)  {
      case _HEAPOK:
         printf("\t\t********** far heapchk OK! \n");
         break;
      case _HEAPEMPTY:
         printf("\t\t********** far Heap is empty!\n");
         break;
      case _HEAPBADBEGIN:
         printf("\t\t********** far Error: bad start! \n");
         break;
      case _HEAPBADNODE:
         printf("\t\t********** far Error: bad node in heap \n");
         break;
   }
   status = _nheapchk();
   switch (status)  {
      case _HEAPOK:
         printf("\t\t********** NEAR heapchk OK! \n");
         break;
      case _HEAPEMPTY:
         printf("\t\t********** NEAR Heap is empty!\n");
         break;
      case _HEAPBADBEGIN:
         printf("\t\t********** NEAR Error: bad start! \n");
         break;
      case _HEAPBADNODE:
         printf("\t\t********** NEAR Error: bad node in heap \n");
         break;
   }
}
