/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       UCO1.H
Engineer:     Amy Wang
Description:  defining all the constants and data structures for CONV3
              the include file for UCO1.C, UCO2.C, UCO3.C

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#define S_IFMT      0170000         /* file type mask */
#define S_IFDIR     0040000         /* directory */
#define S_IFCHR     0020000         /* character special */
#define S_IFREG     0100000         /* regular */
#define S_IREAD     0000400         /* read permission, owner */
#define S_IWRITE    0000200         /* write permission, owner */
#define S_IEXEC     0000100         /* execute/search permission, owner */

/***  defining constants for OMF86   ***/
#define     OMF86      0x82
#define     LHEADR     0x82
#define     LNAMES     0x96
#define     TYPDEF     0x8e
#define     PUBDEF     0x90
#define     THEADR     0x80
#define     COMENT     0x88
#define     LOCSYM     0x92
#define     LINNUM     0x94
#define     DEBSYM     0x7e
#define     BLKDEF     0x7a
#define     BLKEND     0x7c
#define     MODEND     0x8a
#define     ENDREC     0x78
#define     REGINT     0x70
#define     PEDATA     0x84
#define     PIDATA     0X86

/*** defining constants for OMF51   ***/
#define     OMF51_START     0x02
#define     OMF51_END       0x04

/*** defining constants for OMF 286/386  ***/
#define     BOOT_286   0xa2
#define     BOOT_386   0xb2

/*** defining constants for 2500AD   ***/
#define     AD2500_START     0xfe
#define     AD2500_EOF       0xff

/*** defining constants for Intermetrics Object Language ***/
#define     INTERTOOL_START   '.'

/*** defining constants for MRI format including 68K,51,Z80,64180 ***/
#define     MRI64180            'S'
#define     MRI_68K_51_Z80      '$'
#define     SPACE               ' '

/*** defining constants for IEEE695 format ***/
#define     MB      0xe0      /* module begin */
#define     AT      0xf1      /* attribute records */
#define     ATI     0xc9
#define     ATN     0xce
#define     AS      0xe2      /* value records */
#define     ASI     0xc9
#define     ASN     0xce
/* public */
#define     NI      0xe8      /* public symbol */
/* block begin */
#define     BB      0xf8
/* typedef */
#define     TYPEDEF 0x01      /* module scope type definition */
#define     NN      0xf0      /* variable names */
#define     TY      0xf2      /* define types */
/* high level module scope beginning */
#define     MS      0x03
/* global function */
#define     GBLFUN  0x04
/* line number information */
#define     LINUM   0x05
/* local function */
#define     LOCFUN  0x06
#define     BE      0xf9      /* block end */
#define     ME      0xe1      /* module end */
#define     LINE    0x05      /* lines begin */

/*** defining constants for SYSROF format ***/
#define     SYSROF_CS1    0x00
#define     SYSROF_CS2    0x80
#define     SYSROF_HD     0x04
#define     SYSROF_UN     0x06
#define     SYSROF_SC     0x08
#define     SYSROF_DU     0x30
#define     SYSROF_DUS    0x40
#define     SYSROF_DPS    0x32
#define     SYSROF_DSY    0x34
#define     SYSROF_TR     0x7f

#define     PLM_SOURCE  '0'
#define     C_SOURCE    '1'
#define     OTHERS      '2'

#define     NO_MODULE   500   /* unlimited number, but alloc 500 at a time */
#define     NO_BLOCK    512
#define     INDEX_RANGE 100
#define     TYPERECNO   50
#define     TYPEBUFNO   656   /* There are at most 656*50=32800 types allowed */
#define     BLKINFOSZ   58
#define     SYMRECLEN  50

#define      OK       0
#define      FAIL     -1

#define BLKBUFSZ     60                /* # of entries in blkInfo */
#define MRGSYMSZ   1300                /* # of entries in array buffer */
#define BLKSYM     100                 /* # of entries in blkSymBuf    */
#define ADRRECLEN  12
#define MRGADRSZ   5200


 // Defines basic types
typedef unsigned char  U8;
typedef signed   char  S8;
typedef unsigned int   U16;
typedef signed   int   S16;
typedef unsigned long  U32;
typedef signed   long  S32;

/*-----------  module           structure   ----------------------------------*/

struct  module {
        int           mod_inx;     /* the module index >= 0 */
        char          mod_name[40];
        int           mod_symno;   /* the number of module-wide symbol */
        U32           modStart;   /* start address (acquired from BLKDEF) */
        U32           modEnd;     /* end address (acquired from BLKDEF) */
        U32           blkStartPos;
        int           blkCnt;
};

/*-------------  misc structures  -----------------------------------------*/

struct  module_location {
        long *ptr;
        struct module_location *next;
};

struct  module_index_count {
        int *ptr;
        struct module_index_count *next;
};

struct  line_info_location {
        long *ptr;
        struct line_info_location *next;
};

struct  two_long   {
        long  ll1;
        long  ll2;
};

struct  attribute  {
        int  addrunit;
        int  absflag;
};

struct symindex  {
        long     fpos;
        int      cnt;
        char     name[40];
};

struct adrindex    {
        long    fpos;
        int     cnt;
        unsigned char    addr[6];
};

struct DTindex  {
        unsigned long loc;
        unsigned long len;
};

typedef struct {
    U16  lineNum, offset;
} LINNUMINFO;

typedef unsigned char  U8;
typedef signed   char  S8;
typedef unsigned int   U16;
typedef signed   int   S16;
typedef unsigned long  U32;
typedef signed   long  S32;
