/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       UCO2.C
Engineer:     Amy Wang
Description:  scanning OMF86, OMF85, OMF51

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <search.h>
#include <errno.h>
#include "uco1.h"
#include "uco3.h"
#define BLOCK_DISCARD 0xFF
#define BLOCK_START   1
#define BLOCK_END     0

/****************************************************************************/
/***** omf86()                                                           ****/
/****************************************************************************/

omf86()
{
//#define BUFSIZE 4096
// Changed by Gates Hua , Date : 01/10/1995
#define BUFSIZE 10240
 U8 addr[6], *lineNumInfo, hasLineNum=0, *typeRecord, scope=0, *typeBuf;
 U8 firstEntered=1, c, isProc, tempBlk[BLKINFOSZ];
 U8 *tmpBlkSym, *ptr;
 U8 *ttmp;
 S16 i,j,k, lenCnt=0, typeCnt, blkInfoInx=0;
 S32 lpos,blen;
 U32 start=0xffffffff, end = 0L;
 U32 blkSymPos, tmpStart, tmpEnd;
 U16 frame, retByte;
 U8 blockState[20], blkStateCnt=0;

   memset(blkInfo , NULL , BLKBUFSZ*BLKINFOSZ);
   memset(blockState, BLOCK_END, sizeof(blockState));
   lseek(fdin,0L,0);
   do {
      if (kbhit()) getch();
      read(fdin,temp,3);
      len = (long)temp[2];
      len=(len<<8) + temp[1];
      switch(temp[0]) {              /* 1st byte of omf86 rec is the type */
         case THEADR:
            read(fdin,temp1,len);
            if ( modsymcnt > 0 || hasLineNum || blkcnt > 0)  {
               gblmod.mod_inx = ++modinx;
               gblmod.blkCnt = blkcnt;
               gblmod.modStart = start;
               gblmod.modEnd   = end;
               if (blkInfoInx > 0) {
                  if (!gblmod.blkStartPos)
                     gblmod.blkStartPos = (U32)tell(fdsy);
                  write(fdsy, &blkInfo[0][0], blkInfoInx * BLKINFOSZ);
                  memset( blkInfo , NULL , blkInfoInx * BLKINFOSZ);
               }
               ProcessLinnumInfo();
               ProcessModSym(fds2);
            }
            blkcnt = blkInfoInx = hasLineNum=0;
            ResetEnvironment();
            i = temp1[0];
            strncpy(gblmod.mod_name,&temp1[1],i);
            gblmod.mod_name[i]='\0';
            start = 0xffffffff;
            end = 0L;
            break;
         case LINNUM:
            lineNumInfo = malloc( len );
            read( fdin, lineNumInfo, len);
            if (lineNumInfo[0] || lineNumInfo[1]) {
               free(lineNumInfo);
               break;
            }
            linnumFrame = (U16) lineNumInfo[3];
            linnumFrame = (linnumFrame << 8) +lineNumInfo[2];
            lineInfoLen += (len-5);
            hasLineNum = 1;
            blen= tell(fds4);
            write( fds4, lineNumInfo+4, len-5 ); // skip line num. base and ChkSum
            free(lineNumInfo);
            break;
         case TYPDEF:
            if (typePosInxCnt >= TYPEBUFNO-1) {// discard the rest type records
               lseek(fdin,(long) len,1);       // if there are more than 32800 types
               break;
            }
            if (firstEntered) {
               typeCnt = firstEntered=0;
               if ((typeBuf = malloc(BUFSIZE)) == NULL) {
                  prn_exit("Error allocating memory!\r\n");
                  break;
               }
               memset( typeBuf, NULL, BUFSIZE);
            }
            if (typeCnt >= TYPERECNO) {
               typePosBuf[typePosInxCnt++] = (U32)tell(fdsy);
               write( fdsy, typeBuf, lenCnt );
               memset( typeBuf, NULL, BUFSIZE);
               lenCnt = typeCnt = 0;
            }
            typeRecord = malloc( len + 3 );
            typeCnt++;
            memcpy( typeRecord, temp, 3);
// by Joyce Lin, 11/25/94
//          read( fdin, temp1, len );
//          memcpy( typeRecord+3, temp1, len);
            read( fdin, typeRecord+3, len );
            memcpy( &typeBuf[lenCnt], typeRecord, len+3 );
            lenCnt += (len+3);
            free( typeRecord );
            break;
         case PUBDEF:
            if (typeCnt) {  // process last records of TYPDEF
               if (typePosInxCnt < TYPEBUFNO)
                  typePosBuf[typePosInxCnt++] = (U32)tell(fdsy);
               write( fdsy, typeBuf, lenCnt );
               typeCnt=0;
            }
            if (!firstEntered) {  // free the buffer of TYPDEF
               free( typeBuf );
               firstEntered=1;
            }
            read (fdin,temp1,5);
            len -= 5;
            if ((len < (long)temp1[4]) || (temp1[0] ||
                 temp1[1]))  {
               lseek(fdin,(long)len,1);
               break;
            }
            else {
               cframe[0] = temp1[3];
               cframe[1] = temp1[2];
               len--;
               i=get_symbol((int)temp1[4],fds1); /*global symbol */
               gblsymcnt += i;
            }
            break;
         case DEBSYM:
            read(fdin,temp1,6);
            if ((c=temp1[0]&7) == 0 || c == 2) {
               if (!c) {        // non-stacked variable
                  if (temp1[1] || temp1[2]) {  // not in [frame:offset] format
                     lseek( fdin, (long)(len-6), 1 );
                     break;
                  }
                  cframe[0] = temp1[4];
                  cframe[1] = temp1[3];
                  j = (int) temp1[5];
                  len -= 7;
                  if (len < (long)j) break;
                  if (!scope) {  // module symbol
                     i=get_symbol( j, fds2);
                     modsymcnt += i;
                  }
                  else {        // static variable in block
                     i=GetBlockSymbol( j, c );
                     blkSymCnt += i;
                  }
               }
               else {           // local variable
//                if (temp1[1] > 1) {  // scope > 1
// ignore chkstk() level generated by ll86  05/31/1994 James Wang
                  if (scope > 2) {
                     lseek( fdin, (long)(len-6), 1 );
                     break;
                  }
/* Changed by Gates Hua , For bugs of load.omf , Date : 01/10/1995
                  cframe[0] = '\0';
                  cframe[1] = temp1[1];
                  j = (int) temp1[2];
                  lseek( fdin, -3L, 1);
*/
                  if ( temp1[1]&0x80 ) {
                     cframe[0] = temp1[1]&0x7F;
                     cframe[1] = temp1[2];
                     j = (int) temp1[3];
                     lseek( fdin, -2L, 1);
                  }
                  else {
                     cframe[0] = '\0';
                     cframe[1] = temp1[1];
                     j = (int) temp1[2];
                     lseek( fdin, -3L, 1);
                  }

                  len -= 4;
                  if (len < (long)j) break;
                  i=GetBlockSymbol( j, c );
                  blkSymCnt += i;
               }
            }
            else lseek( fdin, (long)(len-6), 1 );
            break;
         case BLKDEF: {
            U32 blkLen=0l;

            blockState[blkStateCnt++] = BLOCK_START;
            read(fdin,temp1,len);
            if (temp1[0] || temp1[1]) break;
            memset(tmpsym,NULL,SYMRECLEN);
            tmpsym[0] = 0x0;
            tmpsym[1] = temp1[4] >= 39 ? 39 : temp1[4];
            memcpy(&tmpsym[2],&temp1[5],(int)tmpsym[1]);
            addr[0] = temp1[3];      // frame
            addr[1] = temp1[2];
            i=4 + (int)temp1[4] + 1;
            blkLen  = (U32)temp1[3+i];
            blkLen  = (blkLen << 8) + temp1[2+i];
            if (!blkLen) {
               blockState[--blkStateCnt] = BLOCK_DISCARD;
               blkStateCnt++;
               break;
            }
            scope++;
            addr[2] = temp1[i+1];    // block offset
            addr[3] = temp1[i];
            memcpy(&tmpsym[42],addr,AddrUnit);
            isProc = temp1[4+i] & 0x80;
            retByte = !isProc ? 0 : (temp1[4+i] & 0x40 ? 4 : 2);

            j = retByte ? 2 : 0;
            j += (i + 5);
            if (!temp1[4]) {            // no type idx while name len is 0
               tmpsym[48] = '\0';
               tmpsym[49] = '\0';
            }
            else if (temp1[j] & 0x80) { // typeIdx >= 128
               tmpsym[48] = temp1[1+j];
               tmpsym[49] = (unsigned char)(temp1[j] & 0x7F);
            }
            else {                    // typeIdx < 128
               tmpsym[48] = temp1[j];
               tmpsym[49] = '\0';
            }
            if (scope == 1) {
               write(fds2,tmpsym,SYMRECLEN);
               modsymcnt++;
               memset(tempBlk, NULL, sizeof(tempBlk));
               if (isProc) {
                  frame =  (U16)temp1[3];
                  frame = (frame << 8) + temp1[2];
                  tmpStart = (U16)temp1[1+i];
                  tmpStart = ((U32)frame << 16) + (tmpStart << 8) + temp1[i];
                  tmpEnd  = blkLen + tmpStart - 1;
                  if (tmpStart < start ) start = tmpStart;
                  if (tmpEnd > end)      end   = tmpEnd;
                  memcpy( &tempBlk[0], &tmpsym[2], 40 );   // name : 40 bytes
                  memcpy( &tempBlk[40], (U8 *)&tmpStart, sizeof(U32) ); //start
                  memcpy( &tempBlk[44], (U8 *)&tmpEnd, sizeof(U32) );  // end
                  memcpy( &tempBlk[48], (U8 *)&retByte, sizeof(U16) );
                  // 2: 2-byte retAddr, 4: 4-byte retAddr
                  memcpy( &tempBlk[50], &temp1[5+i], 2 );  // offset
               }
            }
            else if (scope == 2 ) {
               write(fds5,tmpsym,SYMRECLEN);
               blkSymCnt++;
            }
            break;
        }
         case BLKEND: {
            U8 state=blockState[--blkStateCnt];

            blockState[blkStateCnt] = BLOCK_END;
            if (state == BLOCK_DISCARD) {
               read(fdin,temp1,len);
               break;
            }
            scope--;
            if (!scope && tempBlk[48]) {
               j= blkSymCnt * SYMRECLEN;
               if ((tmpBlkSym = malloc(j)) == NULL)
                  prn_exit("Error allocating memory!\r\n");
               lseek( fds5, 0L, 0);
               read(fds5, tmpBlkSym, j );
               blkSymPos = (U32)tell(fdsy);
               ttmp = (unsigned char *)calloc(blkSymCnt, SYMRECLEN);
               if (ttmp == NULL) prn_exit("Error allocating memory!\n");
               ptr = tmpBlkSym;
               for (i=0, j=0; i < blkSymCnt; i++)   {
                  k = 2 + *(ptr+1);
                  memcpy( ttmp+j, ptr, k);
                  j += k;
                  memcpy( ttmp+j, ptr+42, AddrUnit);
                  j += AddrUnit;
                  memcpy( ttmp+j, ptr+48, 2);
                  j  += 2;
                  ptr += SYMRECLEN;
               }
               write( fdsy, ttmp, j );
               memcpy( &tempBlk[52], (U8 *)&blkSymPos, sizeof(U32));
               memcpy( &tempBlk[56], (U8 *)&blkSymCnt, sizeof(U16));
               memcpy( blkInfo[blkInfoInx++], tempBlk, BLKINFOSZ );
               blkcnt++;
               if (blkInfoInx >= BLKBUFSZ) {
                  if (!gblmod.blkStartPos)
                     gblmod.blkStartPos = (U32)tell(fdsy);
                  write(fdsy, &blkInfo[0][0], blkInfoInx * BLKINFOSZ);
                  memset( blkInfo , NULL , blkInfoInx * BLKINFOSZ);
                  blkInfoInx = 0;
               }
               free(ttmp);
               free(tmpBlkSym);
               lseek( fds5, 0L, 0);
               blkSymCnt= blkSymInx = 0;
            }
            read(fdin,temp1,len);
            break;
         }
         case MODEND:
            if ( modsymcnt > 0 || hasLineNum || blkcnt > 0) {
               gblmod.mod_inx = ++modinx;
               gblmod.blkCnt = blkcnt;
               gblmod.modStart = start;
               gblmod.modEnd   = end;
               if (blkInfoInx) {
                  if (!gblmod.blkStartPos)
                     gblmod.blkStartPos = (U32)tell(fdsy);
                  write(fdsy, &blkInfo[0][0], blkInfoInx * BLKINFOSZ);
                  memset( blkInfo , NULL , blkInfoInx * BLKINFOSZ);
               }
               ProcessLinnumInfo();
               ProcessModSym(fds2);
               blkcnt = blkInfoInx = hasLineNum = 0;
               ResetEnvironment();
               start = 0xffffffff;
               end = 0L;
            }
         /* process the global symbols if it's the last input file */
            if (inputFileInx== inputFileCnt-1)
               ProcessGblSym(fds1);
            break;
         case PIDATA:
         case PEDATA:
//          if (dataloc == 0) dataloc = (U32)tell(fdin);
            lseek(fdin,(long) len,1);
            break;
         default:
            lseek(fdin,(long) len,1);
      } /* end switch */
   }   while (temp[0] != MODEND && temp[0] != ENDREC);

   return;
}

/************************************************************************/
/*** get_symbol(slen,ffdd)                                           ****/
/************************************************************************/

get_symbol(int slen,int ffdd)
{
   int scnt=0,br,k, typeIdx, nameLen;
   long i=0L;

   do {
      memset(tmpsym,NULL,SYMRECLEN);
      i += (slen+4);
      do {
         br=read(fdin,temp1,slen+4);
      } while (br == 0);
      tmpsym[0]=0x0;
      nameLen = slen > 39 ? 39 : slen;
      tmpsym[1]=(unsigned char)nameLen;  // len. of name can't be over 40 chars.
      memcpy(&tmpsym[2],temp1,nameLen);
      memcpy(&tmpsym[42],cframe,2);
      tmpsym[44] = temp1[slen+1];
      tmpsym[45] = temp1[slen];
      br = (int)temp1[slen+2];
      if (br & 0x80)  {
         tmpsym[48] = temp1[slen+3];
         tmpsym[49] = (unsigned char)(br & 0x7F);
         read(fdin,temp1,1);
         i++;
         slen = (long)temp1[0];
      }
      else {
         tmpsym[48] = temp1[slen+2];
         tmpsym[49] = '\0';
         slen = (long)temp1[slen+3];
      }
      memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
      if (srtinx == MRGSYMSZ)  {
         write(ffdd,srtbuf[0],SYMRECLEN*MRGSYMSZ);
         memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
         srtinx = 0;
      }
      scnt++;
   } while (i < len);
   k= SYMRECLEN * srtinx;
   write(ffdd,&srtbuf[0][0],k);
   memset(srtbuf[0],NULL, k );
   srtinx = 0;
   return(scnt);
}

/*******************************************************************/
/*** GetBlockSymbol(slen, frameMethod)                          ****/
/*******************************************************************/

GetBlockSymbol(int slen, U8 type)
{
   int scnt=0,br,k, nameLen;
   long i=0L;

   do {
      memset(tmpsym,NULL,SYMRECLEN);
      i += (slen+4);
      do {
         br=read(fdin,temp1,slen+4);
      } while (br == 0);
      tmpsym[0]= type; // frame method ( static(0) or local (2) )
      nameLen = slen > 39 ? 39 : slen;
      tmpsym[1]=(unsigned char)nameLen;  // len. of name can't be over 39 chars.
      memcpy(&tmpsym[2],temp1,nameLen);
      tmpsym[42] = cframe[1];
      tmpsym[43] = cframe[0];
      memcpy(&tmpsym[44],&temp1[slen],2);
      br = (int)temp1[slen+2];
      if (br & 0x80)  {
         tmpsym[48] = temp1[slen+3];
         tmpsym[49] = (unsigned char)(br & 0x7F);
         read(fdin,temp1,1);
         i++;
         slen = (long)temp1[0];
      }
      else {
         tmpsym[48] = temp1[slen+2];
         tmpsym[49] = '\0';
         slen = (long)temp1[slen+3];
      }
      memcpy( blkSymBuf[blkSymInx++], tmpsym, SYMRECLEN );
      if (blkSymInx >= BLKSYM ) {
        write(fds5, blkSymBuf[0], sizeof(blkSymBuf));
        memset( blkSymBuf[0], NULL, sizeof(blkSymBuf));
        blkSymInx = 0;
      }
      scnt++;
   } while (i < len);
   k= SYMRECLEN * blkSymInx;
   write(fds5, &blkSymBuf[0][0], k );
   memset( blkSymBuf[0],NULL, k);
   blkSymInx = 0;
   return(scnt);
}

/*=====================   IEEE695  ===========================================*/
#define T_BUFSIZE 10240
#define TYPERECLEN 1024
#define LINELEN   20480
#define ON  1
#define OFF 0

Ieee695()
{
 U8 addr[6], *lineNumInfo,hasLineNum=0,*typeRecord,*typeRec,scope=0, *typeBuf;
 U8 firstEntered=1, c, tempBlk[BLKINFOSZ];
 U8 *tmpBlkSym, *ptr, locfun_flag = OFF, gblsym_flag = ON;
 U8 *ttmp, line_inc=0;
 S16 i,j,k, lenCnt=0, typeCnt, Cnt=0, stack_sz;
 S32 lpos;
 U32 start=0xffffffff, end = 0L;
 U32 blkSymPos, tmpStart, tmpEnd;
 U32 addr3;

 memset(blkInfo, NULL, BLKBUFSZ*BLKINFOSZ);
 lseek(fdin, 0L, 0);

   while (1)   // seek debug data part.
   {
      read(fdin, temp, 1);
      if (temp[0]==0xE2)
      {
         read(fdin, temp, 1);
         if (temp[0]==0xD7)
         {
            read(fdin, temp, 1);
            if (temp[0]==0x03)
            {
               read(fdin, temp, 1);   // temp[0] == 0x84.
               read(fdin, temp, 4);
               addr3 = ((U32)temp[0] << 24) + ((U32)temp[1] << 16)
                  + ((U32)temp[2] << 8) + (U32)temp[3];
               lseek(fdin, addr3, 0);
               break;
            }
            else { lseek(fdin, (long)-2, 1); continue;}
         }
         else { lseek(fdin, (long)-1, 1); continue;}
      }
      else continue;
   }

 do {
      if (kbhit()) getch();
      read(fdin, temp, 1);
      switch (temp[0])
      {
         case NI: // process Public
            if (gblsym_flag==OFF)
               break;
            read(fdin,temp1,1); // skip public name index >31
            if (temp1[0]<=31)
               break;
            if (temp1[0]>0x80 && temp1[0]<0x90)
               read(fdin,temp2,temp1[0]-0x80);
            read(fdin,temp1,1); // read public name
            if (temp1[0]==0)
               break;           // non-name public
            read(fdin,&temp1[1],temp1[0]);
            temp1[temp1[0]+1] = '\0';
            i = get_symbol695((int)temp1[0],fds1);  /*global symbol*/
            gblsymcnt +=i;
            break;

         case  BB:  //process block
            read(fdin,temp1,1);
            switch(temp1[0])
            {
               case TYPEDEF: // Part 1 in Debug.
                  gblsym_flag = OFF; // close NI flag.
                  read(fdin,temp2,1); // skip block size.
                  read(fdin,temp1,temp2[0]-0x80);
                  read(fdin,temp2,1); // read module name.
                  read(fdin,temp1,temp2[0]);
                  temp1[temp2[0]] = '\0';

            if ( modsymcnt > 0 || hasLineNum || blkcnt > 0)
            {
               gblmod.mod_inx = ++modinx;
               gblmod.blkCnt = blkcnt;
               gblmod.modStart = start;
               gblmod.modEnd   = end;
               if (blkcnt)
               {
                  gblmod.blkStartPos = (U32)tell(fdsy);
                  write(fdsy, &blkInfo[0][0], blkcnt * BLKINFOSZ);
                  memset( blkInfo , NULL , blkcnt * BLKINFOSZ);
               }
                 ProcessLinnumInfo695(start,end);
                 ProcessModSym(fds2);
            }
            blkcnt = hasLineNum = 0;
            ResetEnvironment();

            strncpy(gblmod.mod_name,temp1,temp2[0]);
            start = 0xffffffff;
            end = 0L;

                  // initialization
                  lenCnt = typeCnt = Cnt = 0;
                  if ((typeBuf = malloc(T_BUFSIZE)) == NULL ||
                     (typeRecord = malloc( TYPERECLEN ))== NULL)
                  {
                     prn_exit("Error allocating memory!\r\n");
                     break;
                  }
                  memset( typeBuf, NULL, T_BUFSIZE);
                  typeRec = typeRecord;
                  do
                  {
                     read(fdin,temp2,1);
                     if (temp2[0]==NN || temp2[0]==BE)
                     {
                        typeCnt++;
                        if (Cnt==0) // first record
                           memset( typeRecord, NULL, TYPERECLEN);
                        else
                           {
                              memcpy(&typeBuf[lenCnt-Cnt],typeRecord,Cnt);
                              typeRec = typeRecord;
                              Cnt = 0;
                           }
                        if (typeCnt >= TYPERECNO)
                        {
                        typePosBuf[typePosInxCnt++] = (U32)tell(fdsy);
                        write( fdsy, typeBuf, lenCnt );
                        memset( typeBuf, NULL, T_BUFSIZE);
                        lenCnt = typeCnt = Cnt = 0;
                        }
                     }
                     *typeRec = temp2[0];
                     typeRec++;
                     Cnt++;
                     lenCnt++;
                  } while (temp2[0]!=BE);

                  lenCnt--;
                  // saving the rest of typedef < TYPERECNO
                  typePosBuf[typePosInxCnt++] = (U32)tell(fdsy);
                  write(fdsy,typeBuf,lenCnt);
                  free( typeBuf );
                  free( typeRecord );
                  break;

               case LINE: // line number info.
                        line_inc = 1; // line level.
                        hasLineNum = 1;
                        lineInfoLen = 0;
                        if ((lineNumInfo = malloc(LINELEN))==NULL)
                           prn_exit("Allocating memory error!\r\t");
                        memset(lineNumInfo,NULL,BUFSIZE);
                        ptr = lineNumInfo;

                        read(fdin,temp1,1); // skip line size
                        if (temp1[0]>0x80 && temp1[0]<0x90)
                        {
                           temp1[0]-=0x80;
                           read(fdin,temp2,temp1[0]);
                        }
                        else
                           read(fdin,temp2,2);

                        read(fdin,temp1,1); //read module name
                        *ptr++ = temp1[0];
                        read(fdin,temp2,temp1[0]);
                        memcpy(ptr,temp2,temp1[0]);
                        ptr+=temp1[0];
                        lineInfoLen += temp1[0]+1;

                        do
                        {
                           read(fdin,temp2,1);
                           if (temp2[0]==BB)
                           {
                              read(fdin,temp1,1);
                              if (temp1[0]==LINE) // nested line
                                 line_inc++;
                              lseek(fdin,(long)-1,1);
                           }
                           if (temp2[0]==BE)
                           {
                              read(fdin,temp1,1);
                              if (temp1[0]==NN || temp1[0]==BB ||
                                       temp1[0]==AT || temp1[0]==BE)
                                 line_inc--;
                              lseek(fdin,(long)-1,1);
                           }
                           if (line_inc==1 && temp2[0]!=BE)
                           {
                              *ptr = temp2[0];
                              ptr++;
                              lineInfoLen++;
                           }
                        }while (line_inc>0);
                        write(fds4,lineNumInfo,lineInfoLen);
                        free(lineNumInfo);
                        break;

               case MS: // high level module scope start
                        scope++;
                        break;

               case LOCFUN: //local function
                        locfun_flag = ON;
               case GBLFUN: //global function
                        scope++;
                        read(fdin,temp2,1);//skip block size. 00=unknown
                        if (temp2[0]>0x80 && temp2[0]<0x90)
                           read(fdin,temp1,temp2[0]-0x80);
                        read(fdin,temp2,1);//read block name.
                        if (temp2[0]==0) // unnamed procedure
                        {
                           locfun_flag = OFF;
                           break;
                        }
                        read(fdin,temp1,temp2[0]);
                        temp1[temp2[0]]='\0';
                        memset(tmpsym,NULL,SYMRECLEN);
//                      tmpsym[0] = 0x00;
                        tmpsym[1] = temp2[0]>=39? 39:temp2[0];
                        memcpy(&tmpsym[2],temp1,(int)tmpsym[1]);

                        read(fdin,temp2,1); //read stack space  !!!
                        if (temp2[0]>0x80 && temp2[0]<0x90)
                        {
                           temp2[0]-=0x80;
                           read(fdin,temp1,temp2[0]);
                           stack_sz = temp1[0];
                           for (i=temp2[0];i>1;i--)
                              stack_sz = (stack_sz<<8) + temp1[i-1];
                        }
                        else
                           stack_sz = (S16)temp2[0];

                        read(fdin,temp2,1); //read return type index
                        if (temp2[0]>0x80 && temp2[0]<0x90)
                        {
                           temp2[0]-=0x80;
                           read(fdin,temp1,temp2[0]);
                           memcpy(&tmpsym[48],temp1,temp2[0]);
                        }
                        else
                        {
                           tmpsym[49] = temp2[0];
                           tmpsym[48] = '\0';
                        }
                        read(fdin,temp2,1);//read addr
                        if (temp2[0]>0x80 && temp2[0]<0x90)
                        {
                           temp2[0]-=0x80;
                           read(fdin,temp1,temp2[0]);
                           memcpy(&tmpsym[46-temp2[0]],temp1,temp2[0]);
                        }
                        else
                        {
                           read(fdin,&temp2[1],3);
                           memcpy(&tmpsym[42],temp2,4);
                        }

                        if (scope == 3 )
                        {  // block name like as local variable
                           write(fds5,tmpsym,SYMRECLEN);
                           blkSymCnt++;
                           break;
                        }
                        if (scope == 2)  // normal procedure
                        {  // save proc name as variable
                           blkSymCnt = 0;
                           if (locfun_flag==ON)
                           {  // static procedure
                              write(fds2,tmpsym,SYMRECLEN);
                              modsymcnt++;
                              locfun_flag = OFF;
                           }
                           else
                           {  // global procedure
                              write(fds1,tmpsym,SYMRECLEN);
                              gblsymcnt++;
                           }
                           memset(tempBlk, NULL, sizeof(tempBlk));
                           tmpStart = (U8)tmpsym[42];
                           tmpStart = (U16)(tmpStart << 8) + (U16)tmpsym[43];
                           tmpStart = (U32)(tmpStart << 8) + (U32)tmpsym[44];
                           tmpStart = (U32)(tmpStart << 8) + (U32)tmpsym[45];
                           if (tmpStart < start ) start = tmpStart;
          memcpy(&tempBlk[0],&tmpsym[2],40);//name: 40 bytes
          memcpy(&tempBlk[40],&tmpsym[42],sizeof(U32)); //start
          memcpy(&tempBlk[48],&tmpsym[48],sizeof(U16)); //return type index
          tempBlk[50] = stack_sz>>8 & 0xff;  // stacksize.
          tempBlk[51] = (U8)stack_sz & 0xff;
                        }
                        break;

               default: // ignore other block
                        break;

            } // end of switch temp1[0]
            break;

         case BE:
               //process block end in block 3.
               if (scope<1) break;
               if (scope==2)
                  {
                     read(fdin,temp2,1);  // read block end address
                     if (temp2[0]>0x80 && temp2[0]<0x90)
                     {
                        temp2[0]-=0x80;
                        memset(tmpsym,NULL,SYMRECLEN);
                        read(fdin,temp1,temp2[0]);
                        memcpy(&tmpsym[46-temp2[0]],temp1,temp2[0]);
                     }
                     else
                     {
                        read(fdin,&temp2[1],3);
                        memcpy(&tmpsym[42],temp2,4);
                     }
                     tmpEnd = (U8)tmpsym[42];
                     tmpEnd = (U16)(tmpEnd << 8) + (U16)tmpsym[43];
                     tmpEnd = (U32)(tmpEnd << 8) + (U32)tmpsym[44];
                     tmpEnd = (U32)(tmpEnd << 8) + (U32)tmpsym[45];
                     if (tmpEnd > end)   end = tmpEnd;
                     memcpy(&tempBlk[44],&tmpsym[42],sizeof(U32) );  // end
                     blkSymPos = (U32)tell(fdsy);
                     memcpy( &tempBlk[52], (U8 *)&blkSymPos, sizeof(U32));
                     memcpy( &tempBlk[56], (U8 *)&blkSymCnt, sizeof(U16));
                     memcpy( blkInfo[blkcnt++], tempBlk, BLKINFOSZ );
                     if (!blkSymCnt)  // non-symbol in block
                     {
                        memset( &tempBlk[52], NULL, sizeof(U32));
                        lseek( fds5, 0L, 0);
                        scope--;
                        break;
                     }
                     if (tempBlk[48] || tempBlk[49])
                     { // process local variable
                        j= blkSymCnt * SYMRECLEN;
                        if ((tmpBlkSym = malloc(j)) == NULL)
                           prn_exit("Error allocating memory!\r\n");
                        lseek( fds5, 0L, 0);
                        read(fds5, tmpBlkSym, j );
                        ttmp = (unsigned char *)calloc(blkSymCnt, SYMRECLEN);
                        if (ttmp == NULL)
                           prn_exit("Error allocating memory!\n");
                        ptr = tmpBlkSym;
                        for (i=0, j=0; i < blkSymCnt; i++)
                        {
                           k = 2 + *(ptr+1);
                           memcpy( ttmp+j, ptr, k);
                           j += k;
                           memcpy( ttmp+j, ptr+42, AddrUnit);
                           j += AddrUnit;
                           memcpy( ttmp+j, ptr+48, 2);
                           j  += 2;
                           ptr += SYMRECLEN;
                        }
                        write( fdsy, ttmp, j );
                        free(ttmp);
                        free(tmpBlkSym);
                        lseek( fds5, 0L, 0);
                        blkSymCnt= blkSymInx = 0;
                        scope--;
                        break;
                     }
                  } // end of scope=2.
                  else  // scope !=2
                  {
                     scope--;
                     break;
                  }
                  break;

         case NN:
            // process module && local variable
            if (scope==1 || scope==2)
            {
               read(fdin,temp1,1); // skip variable name index >31
               if (temp1[0]<=31)
                  break;
               if (temp1[0]>0x80 && temp1[0]<0x90)
                  read(fdin,temp2,temp1[0]-0x80);
               read(fdin,temp1,1); // read variable name
               if (temp1[0]==0 || temp1[0] >= 100 )
                  break;           // non-name module or local symbol.
               read(fdin,temp2,temp1[0]);
               temp2[temp1[0]] = '\0';

               if (scope==1)
               { // process module variable
                  i=getmodsym695(temp1[0],fds2);
                  modsymcnt += i;
               }
               else
                  if (scope==2)
                  {  // process procedure variable
                     i=getblksym695(temp1[0],fds5);
                     blkSymCnt += i;
                  }
            }
               break;

         case ME:
      /*    if (read(fdin,temp1,1)>0)
            {  // not in end of file
               lseek(fdin,(long)-1,1);
               temp[0] = '\0';
               break;
            }     */
            if ( modsymcnt > 0 || hasLineNum || blkcnt > 0) {
               gblmod.mod_inx = ++modinx;
               gblmod.blkCnt = blkcnt;
               gblmod.modStart = start;
               gblmod.modEnd   = end;
               if (blkcnt) {
                  gblmod.blkStartPos = (U32)tell(fdsy);
                  write(fdsy, &blkInfo[0][0], blkcnt * BLKINFOSZ);
                  memset( blkInfo , NULL , blkcnt * BLKINFOSZ);
               }
               ProcessLinnumInfo695(start,end);
               ProcessModSym(fds2);
               blkcnt = hasLineNum = 0;
               ResetEnvironment();
               start = 0xffffffff;
               end = 0L;
            }
         /* process the global symbols if it's the last input file */
            if (inputFileInx== inputFileCnt-1)
               ProcessGblSym(fds1);
            break;
         default:
            break;
      }
    } while (temp[0]!=ME);
}

/************************************************************************/
/*** get_symbol695(slen,ffdd)                                           ****/
/************************************************************************/

int get_symbol695(int slen,int ffdd)
{
   int  nameLen;

   memset(tmpsym,NULL,SYMRECLEN);
   nameLen = slen > 39 ? 39 : slen;
   tmpsym[1]=(unsigned char)nameLen;  // len. of name can't be over 40 chars.
   memcpy(&tmpsym[2],&temp1[1],nameLen);

   read(fdin,temp1,2); // read ATI
   if (temp1[0]==AT && temp1[1]==ATI)
   {
      read(fdin,temp1,1); //skip symbol name index
      if (temp1[0]>0x80 && temp1[0]<0x90)
         read(fdin,temp2,temp1[0]-0x80);
      read(fdin,temp1,1); //read symbol type index
      if (temp1[0]>0x80 && temp1[0]<0x90)
      {
         read(fdin,temp2,temp1[0]-0x80);
         memcpy(&tmpsym[48],temp2,2);
      }
      else
      {
         tmpsym[49] = temp1[0];
         tmpsym[48] = '\0';
      }
   }
   else
      return 0;

   read(fdin,temp1,1); //read attribute definition
   tmpsym[0] = temp1[0];

   if (tmpsym[49] || tmpsym[48]) //skip number of elements, if index!=0
   {
      read(fdin,temp1,1);
      if (temp1[0] > 0x80 && temp1[0] < 0x90)
         read(fdin, temp2, temp1[0] - 0x80);
   }

   read(fdin,temp1,2); //read ASI
   if (temp1[0]==AS && temp1[1]==ASI)
   {
      read(fdin,temp1,1); //skip symbol name index
      if (temp1[0]>0x80 && temp1[0]<0x90)
         read(fdin,temp2,temp1[0]-0x80);
      read(fdin,temp2,1);
      if (temp2[0]>0x80 && temp2[0]<0x90)
      {
         temp2[0]-=0x80;
         read(fdin,temp1,temp2[0]); //read symbol absolution addr.
         memcpy(&tmpsym[46-temp2[0]],temp1,temp2[0]);
      }
      else
      {
         read(fdin,&temp2[1],3); // read symbol indirectly addr.
         memcpy(&tmpsym[42],temp2,4);
      }
   }
   else
      return 0;

   write(ffdd,tmpsym,SYMRECLEN);
   return 1;

}


/************************************************************************/
/*** getmodsym695(slen,ffdd)                                           ****/
/************************************************************************/

int getmodsym695(int slen,int ffdd)
{
   int  nameLen;

   memset(tmpsym,NULL,SYMRECLEN);
// tmpsym[0]=0x0;
   nameLen = slen > 39 ? 39 : slen;
   tmpsym[1]=(unsigned char)nameLen;  // len. of name can't be over 40 chars.
   memcpy(&tmpsym[2],temp2,nameLen);

   read(fdin,temp1,2); // read ATN
   if (temp1[0]==AT && temp1[1]==ATN)
   {
      read(fdin,temp1,1); //skip symbol name index
      if (temp1[0]>0x80 && temp1[0]<0x90)
         read(fdin,temp2,temp1[0]-0x80);
      read(fdin,temp1,1); //read symbol type index
      if (temp1[0]>0x80 && temp1[0]<0x90)
      {
         read(fdin,temp2,temp1[0]-0x80);
         memcpy(&tmpsym[48],temp2,2);
      }
      else
      {
         tmpsym[49] = temp1[0];
         tmpsym[48] = '\0';
      }
   }
   else
      return 0;

   read(fdin,temp1,1); //read attribute definition
   tmpsym[0] = temp1[0];
   if (temp1[0]==4 || temp1[0]==5)
   {  // extern fuction , extern variable
      // write(ffdd,tmpsym,SYMRECLEN);
      return 0;
   }

   read(fdin,temp1,2); //read ASN
   if (temp1[0]==AS && temp1[1]==ASN)
   {
      read(fdin,temp1,1); //skip symbol name index
      if (temp1[0]>0x80 && temp1[0]<0x90)
         read(fdin,temp2,temp1[0]-0x80);
      read(fdin,temp2,1);
      if (temp2[0]>0x80 && temp2[0]<0x90)
      {
         temp2[0]-=0x80;
         read(fdin,temp1,temp2[0]); //read symbol absolution addr.
         memcpy(&tmpsym[46-temp2[0]],temp1,temp2[0]);
      }
      else
      {
         read(fdin,&temp2[1],3); // read symbol indirectly addr.
         memcpy(&tmpsym[42],temp2,4);
      }
    //tmpsym[45] = '\0';
   }
   else
      return 0;

   write(ffdd,tmpsym,SYMRECLEN);
   return 1;

}

/*******************************************************************/
/*** getblksym695(slen, frameMethod)                          ****/
/*******************************************************************/

int getblksym695(int slen, int ffdd)
{
   int  nameLen;

   memset(tmpsym,NULL,SYMRECLEN);
   tmpsym[0]=0x0;
   nameLen = slen > 39 ? 39 : slen;
   tmpsym[1]=(unsigned char)nameLen;  // len. of name can't be over 40 chars.
   memcpy(&tmpsym[2],temp2,nameLen);

   read(fdin,temp1,2); // read ATN
   if (temp1[0]==AT && temp1[1]==ATN)
   {
      read(fdin,temp1,1); //skip symbol name index
      if (temp1[0]>0x80 && temp1[0]<0x90)
         read(fdin,temp2,temp1[0]-0x80);
      read(fdin,temp1,1); //read symbol type index
      if (temp1[0]>0x80 && temp1[0]<0x90)
      {
         read(fdin,temp2,temp1[0]-0x80);
         memcpy(&tmpsym[48],temp2,2);
      }
      else
      {
         tmpsym[49] = temp1[0];
         tmpsym[48] = '\0';
      }
   }
   else
      return 0;

   read(fdin,temp1,1); //read attribute definition
   tmpsym[0] = temp1[0];

   if (tmpsym[0]==1 || tmpsym[0]==2 || tmpsym[0]==10)
   { // automatic, living register, locked register
      read(fdin,temp2,1);  // read offset or register index
      if (temp2[0]>0x80 && temp2[0]<0x90)
      {
         temp2[0]-=0x80;
         read(fdin,temp1,temp2[0]);
         memcpy(&tmpsym[46-temp2[0]],temp1,temp2[0]);
      }
      else
         memcpy(&tmpsym[45],temp2,1);
      if (tmpsym[0] == 2 || tmpsym[0] == 10)
      { // read register var offset as parameter.
         read(fdin, temp2, 1);
         if (temp2[0] != NN && temp2[0] != BE)
            tmpsym[42] = temp2[0];
         else
            lseek(fdin,(long)-1,1);
      }
   }
   else if (tmpsym[0]==3) // static variable.
        {
            read(fdin,temp1,2); //read ASN
            if (temp1[0]==AS && temp1[1]==ASN)
            {
               read(fdin,temp1,1); //skip symbol name index
               if (temp1[0]>0x80 && temp1[0]<0x90)
               read(fdin,temp2,temp1[0]-0x80);
               read(fdin,temp2,1);
               if (temp2[0]>0x80 && temp2[0]<0x90)
               {
                  temp2[0]-=0x80;
                  read(fdin,temp1,temp2[0]); //read symbol absolution addr.
                  memcpy(&tmpsym[46-temp2[0]],temp1,temp2[0]);
               }
               else
               {
                  read(fdin,&temp2[1],3); // read symbol indirectly addr.
                  memcpy(&tmpsym[42],temp2,4);
               }
            } // end of ASN
        } // end of static variable.
   else
      return 0; // ignore other attribute.

    //tmpsym[45] = '\0';
   write(ffdd,tmpsym,SYMRECLEN);
   return 1;

}

/*=====================   OMF 51   ===========================================*/

#define       DATAREC       0x06
#define       FILEEND       0x04
#define       MODNAME       0x10
#define       SYMREC        0x12

struct sstack {
        int top;
        int item[20];
};
int blkinx=-1;

/*****************************************************************************/
/**** omf51()                                                            *****/
/*****************************************************************************/

omf51()
{
 unsigned int accmodlen=0,saveaddr=0xffff,slen,addr;
 int i;
 struct sstack blkstk;
 char *bblock[NO_BLOCK];

   lseek(fdin,0L,0);
   do {
           if (kbhit()) getch();
           read(fdin,temp,3);
           len = 0;
           memcpy(&len,&temp[1],2);
           switch (temp[0])  {
                   case OMF51_START:
                           lseek(fdin,len,1);
                           break;

                   case DATAREC:
                           lseek(fdin,len,1);
                           break;

                   case MODNAME:
                           read(fdin,temp1,2);
                           switch (temp1[0])  {
                                   case 0x00:   /* module start */
                                           modinx++;
                                           ResetEnvironment();
                                           blkinx=-1;    accmodlen = 0;    saveaddr = 0xffff;
                                           gblmod.mod_inx = modinx;
                                           memset(&blkstk,0xff,sizeof(blkstk));
                                           slen = (unsigned int)temp1[1];
                                           read(fdin,temp1,slen+1);
                                           strncpy(gblmod.mod_name,temp1,39);
                                           gblmod.mod_name[39]='\0';
                                           break;
                                   case 0x02:   /* proc start */
                                           blkinx++;    // blkcnt++;
                                           push(&blkstk,blkinx);
                                           slen = (unsigned int) temp1[1];
                                           read(fdin,temp1,slen+1);
                                           bblock[blkinx]=calloc(slen+1,sizeof(char));
                                           memset(bblock[blkinx],NULL,slen+1);
                                           memcpy(bblock[blkinx],temp1,slen);
                                           break;
                                   case 0x05:   /* proc end */
                                           if ((i=pop(&blkstk)) != -1)  free(bblock[i]);
                                           slen = (unsigned int) temp1[1];
                                           lseek(fdin,(long)slen+1,1);
                                           break;
                                   case 0x03:   /* module end */
                                           lseek(fdin,len-2,1);
                                           ProcessModSym(fds2);
                                           ResetEnvironment();
                                           break;
                           }  /* end switch temp1[0] */
                           break;

                   case SYMREC:
                           read(fdin,temp1,7);
                           switch (temp1[0])  {
                                   case 0x01:     /* global symbols */
                                           gblsymcnt += GetSymbol51(fds1);
                                           break;
                                   case 0x00:     /* module/local symbols */
                                           if (blkstk.top==-1 ||
                                               blkstk.item[blkstk.top]==-1)
                                                   modsymcnt += GetSymbol51(fds2);
                                           else lseek(fdin,len-7,1);
                                           break;
                                   case 0x02:     /* segment symbols */
                                   case 0x03:     /* line number records */
                                           lseek(fdin,len-7,1);
                                           break;
                           }  /* end switch temp1[0]  */
                           break;

                   case FILEEND:
                           if (inputFileInx== inputFileCnt-1)
                              ProcessGblSym(fds1);
                   default:
                           break;
           }   /* end switch */
   } while (temp[0] != FILEEND);
   return;
}


/****************************************************************************/
/***** push()                                                            ****/
/****************************************************************************/

push(stk,ii)
struct sstack *stk;
int ii;
{
        (stk->top)++;
        if (stk->top >= 19) return(FAIL);
        stk->item[stk->top] = ii;
        return(OK);
}

/****************************************************************************/
/***** pop()                                                             ****/
/****************************************************************************/

pop(stk)
struct sstack *stk;
{
        int  ii;

        if (stk->top < 0) return(-1);
        ii = stk->item[stk->top];
        stk->item[stk->top] = 0x00;
        (stk->top)--;
        return(ii);
}

/****************************************************************************/
/***** GetSymbol51()                                                     ****/
/****************************************************************************/

GetSymbol51(ffdd)
int ffdd;
{
        long acclen=0;
        unsigned int addr,slen;
        int cnt=0,nameonly;

        len -= 7;
        addr = 0;
        memcpy(&addr,&temp1[3],2);
        slen = (unsigned int) temp1[6];
        memset(tmpsym,NULL,SYMRECLEN);
        tmpsym[42] = (unsigned char)(addr >> 8);
        tmpsym[43] = (unsigned char)addr;
        while (acclen < len-1)  {
                if (acclen+slen+6 >= len-1)  nameonly = 0;
                else nameonly = 6;
                acclen += read(fdin,temp1,slen+nameonly);
                tmpsym[1] = (unsigned char)(slen & 0xff);
                memcpy(&tmpsym[2],temp1,slen);
                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                cnt++;
                if (srtinx == MRGSYMSZ)  {
                        write(ffdd,srtbuf[0],SYMRECLEN*srtinx);
                        memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                        srtinx = 0;
                }
                if (nameonly == 0) break;
                memset(tmpsym,NULL,SYMRECLEN);
                tmpsym[43] = temp1[slen+2];
                tmpsym[42] = temp1[slen+3];
                slen = (unsigned int)temp1[slen+5];
        }
        write(ffdd,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
        srtinx = 0;
        lseek(fdin,1L,1);
        return(cnt);
}


/*============================== OMF85 ====================================*/

#define     HEADER     0x02
#define     CONTENT    0x06
#define     MODUEND    0x04
#define     ENDFILE    0x0e
#define     PUBSYM     0x16
#define     USERSYM    0x12
#define     MODNAME    0x10


omf85()
{
        lseek(fdin,0L,0);
        do {
                if (kbhit()) getch();
                read(fdin,temp,3);
                len = 0;
                memcpy(&len,&temp[1],2);
                switch (temp[0])  {
                        case MODNAME:         /* 0x10 */
                                if (modsymcnt > 0 ) {
                                   gblmod.mod_inx = ++modinx;
                                   ProcessModSym(fds2);
                                }
                                ResetEnvironment();
                                read(fdin,temp1,len);
                                strncpy(gblmod.mod_name,&temp1[1],39);
                                gblmod.mod_name[39]='\0';
                                break;

                        case PUBSYM:          /* 0x16 */
                                gblsymcnt += GetSymbol85(fds1);
                                break;

                        case USERSYM:         /* 0x12 */
                                modsymcnt += GetSymbol85(fds2);
                                break;

                        case ENDFILE:         /* 0x0e */
                                lseek(fdin,len,1);
                                if ( modsymcnt > 0 ) {
                                   gblmod.mod_inx = ++modinx;
                                   ProcessModSym(fds2);
                                   ResetEnvironment();
                                }
                                if (inputFileInx== inputFileCnt-1)
                                   ProcessGblSym(fds1);
                                break;

                        case HEADER:          /* 0x02 */
                        case CONTENT:         /* 0x06 */
                        case MODUEND:         /* 0x04 */
                        default:
                                lseek(fdin,(long)len,1);
                                break;
                }  /* end switch */
        } while (temp[0] != ENDFILE);

        return;

}


/****************************************************************************/
/***** GetSymbol85()                                                     ****/
/****************************************************************************/

GetSymbol85(ffdd)
int ffdd;
{
        long acclen=0;
        unsigned int slen;
        int cnt=0,nameonly;

        read(fdin,temp1,4);
        len -= 4;
        slen = (unsigned int) temp1[3];
        memset(tmpsym,NULL,SYMRECLEN);
        tmpsym[42] = temp1[2];
        tmpsym[43] = temp1[1];
        while (acclen < len-1)  {
                if (acclen+slen+4 >= len-1)  nameonly = 0;
                else nameonly = 4;
                acclen += read(fdin,temp1,slen+nameonly);
                tmpsym[1] = (unsigned char)(slen & 0xff);
                memcpy(&tmpsym[2],temp1,slen);
                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                cnt++;
                if (srtinx == MRGSYMSZ)  {
                        write(ffdd,srtbuf[0],SYMRECLEN*srtinx);
                        memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                        srtinx = 0;
                }
                if (nameonly == 0) break;
                memset(tmpsym,NULL,SYMRECLEN);
                tmpsym[43] = temp1[slen+1];
                tmpsym[42] = temp1[slen+2];
                slen = (unsigned int)temp1[slen+3];
        }    /* end while */
        write(ffdd,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
        srtinx = 0;
        lseek(fdin,2L,1);
        return(cnt);
}

