/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       UCO3.C
Engineer:     Amy Wang
Description:  processing 2500AD, IAR, Intermetrics OL,
              MRI 68K, Z80, 51, 64180, 86  file formats

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <search.h>
#include <errno.h>
#include "uco1.h"
#include "uco3.h"

int addr_size[]= {0,1,2,3,4,4,6};
int GlobalFlag = 1;
FILE *fpmp;
long ftell();

/******************************************************************************/
/***** ad2500()                                                          *****/
/******************************************************************************/

ad2500()
{
 int len,i,j,k,tmpaddrsz;
 char name[100];
 char *cp1,*cp2,*cp3;
 unsigned char addrtype;
 long lpos,mpos;
 FILE *fpls;

   lseek(fdin,1L,0);
// modinx = -1;
   read(fdin,temp1,1);
   while (temp1[0] != AD2500_EOF) {
      len = (int)temp1[0];
      if (modsymcnt > 0 ) {
         gblmod.mod_inx = ++modinx;
         ProcessModSym(fds1);
      }
      ResetEnvironment();
      read(fdin,temp1,len+5);
      memset(name,NULL,100);
      memcpy(name,temp1,len);
      cp1 = strrchr(name,'.');
      cp2 = strrchr(name,':');
      cp3 = strrchr(name,'\\');
      if (cp2 == NULL)  {
         if (cp3 == NULL)    cp2 = name;
         else   cp2 = ++cp3;
      }
      else {
         if (cp3 == NULL)    cp2++;
         else if (strlen(cp2) > strlen(cp3))  cp2 = ++cp3;
         else   ++cp2;
      }
      if (cp1 == NULL)    strcpy(gblmod.mod_name,cp2);
      else if (strlen(cp1) > strlen(cp2)) strcpy(gblmod.mod_name,cp2);
      else memcpy(gblmod.mod_name,cp2,strlen(cp2)-strlen(cp1));
      i = len+3;
      addrtype = temp1[i];
      if ((addrtype == 4) || (addrtype == 6))  att.absflag = AbsFlag = 1;
      att.addrunit = AddrUnit = addr_size[(int)addrtype];
      tmpaddrsz = addr_size[(int)addrtype];
      if (R3Flag) {
         att.addrunit = AddrUnit = 3;
         att.absflag = AbsFlag = 1;
      }
      i++;

      memset(srtbuf,NULL,sizeof(srtbuf));
      srtinx = 0;          len = (int)temp1[i];
      while (len != AD2500_START)  {
         if (srtinx == MRGSYMSZ)   {
                 write(fds1,srtbuf[0],SYMRECLEN*MRGSYMSZ);
                 memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                 srtinx = 0;
         }
         read(fdin,temp1,len+tmpaddrsz+1);
         memset(tmpsym,NULL,SYMRECLEN);
         tmpsym[1] = (unsigned char)len;
         memcpy(&tmpsym[2],temp1,len);
         switch (addrtype)  {
             case 2:
                if (R3Flag) {
                   tmpsym[43] = temp1[len+1];
                   tmpsym[44] = temp1[len];
                }
                else if (ReverseFlag)  {
                   tmpsym[42] = temp1[len+1];
                   tmpsym[43] = temp1[len];
                }
                else memcpy(&tmpsym[42],&temp1[len],2);
                break;

             case 3:
                if (R3Flag) {
                   tmpsym[42] = temp1[len+2];
                   tmpsym[43] = temp1[len+1];
                   tmpsym[44] = temp1[len];
                }
                else if (ReverseFlag) {
                   tmpsym[42] = temp1[len];
                   tmpsym[43] = temp1[len+2];
                   tmpsym[44] = temp1[len+1];
                }
                else memcpy(&tmpsym[42],&temp1[len],3);
                break;

             case 4:
             case 5:
                if (AbsFlag)  {
                   tmpsym[42] = temp1[len+1];
                   tmpsym[43] = temp1[len];
                   tmpsym[44] = temp1[len+3];
                   tmpsym[45] = temp1[len+2];
                }
                else memcpy(&tmpsym[42],&temp1[len],4);
                break;

             case 6:
                tmpsym[42] = temp1[len+1];
                tmpsym[43] = temp1[len];
                tmpsym[44] = temp1[len+5];
                tmpsym[45] = temp1[len+4];
                tmpsym[46] = temp1[len+3];
                tmpsym[47] = temp1[len+2];
                break;

             default:
                break;
         }   /* end switch */
         memcpy(srtbuf[srtinx],tmpsym,SYMRECLEN);
         srtinx++;    modsymcnt++;
         len = (int)temp1[len+tmpaddrsz];
      }      /* end  while len   */
      write(fds1,srtbuf[0],SYMRECLEN*srtinx);
      memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
      srtinx = 0;
      read(fdin,temp1,1);
   }    /* end while temp1  */
   gblmod.mod_inx = ++modinx;
   ProcessModSym(fds1);
   ResetEnvironment();
/*
   fpmp=fopen(fnmp,"r");
   if (fpmp != NULL) Get2500ADGlobals();
   ProcessGblSym(fds1);
*/
   return;
}
/*
Get2500ADGlobals()
{
 char line[200];
 unsigned long ul;
 unsigned int ui1,ui2;

   while (fgets(line,140,fpin) != NULL)  {
      if (strstr(line,"****************") != NULL) break;
      if (strstr(line,"Filename :") != NULL) continue;
      if (strstr(line,"Global Symbol Name") != NULL) continue;
   }
}
*/
/*==================    Intermetrics Object Language   =====================*/

#define RB '}'
FILE *fpin;
struct  {
        unsigned long  start;
        unsigned long  end;
        unsigned long  defg;
} loc;
int defgcnt=0;

/****************************************************************************/
/***** InterTools                                                       *****/
/****************************************************************************/

InterTools()
{
        int i,j,k;
        char *cptr,*cp,name[42],type[2],info[2];
        unsigned long ul,addr;
        char line[100];

        if ((fpin=fopen(fnin[inputFileInx],"rt")) == NULL) {
                prn_exit("Error opening input file!\n");
        }

        GetLocInfo();
/* fds1 for module symbols      fds2 for global symbols    */

        while (fgets(line,80,fpin) != NULL)  {
                if (strncmp(line,".dcl",4) != 0) continue;
                sscanf(&line[4],"%*s %*1s %s %s",name,type);
                if (name[0] == NULL || name[0] == RB) continue;
                if ((cptr=strchr(name,RB)) != NULL) *cptr = '\0';
                switch (type[0])  {
                        case 'm':
                               if (modsymcnt > 0) {
                                   gblmod.mod_inx = ++modinx;
                                   write(fds1,srtbuf[0],modsymcnt*SYMRECLEN);
                                   memset(srtbuf[0], NULL, modsymcnt*SYMRECLEN);
                                   ProcessModSym(fds1);
                                }
                                ResetEnvironment();
                                if ((cp=strrchr(name,'\\')) != NULL) cp++;
                                else cp = name;
                                cptr = strrchr(name,'.');
                                if (strlen(cp) > strlen(cptr))
                                        memcpy(gblmod.mod_name,cp,strlen(cp)-strlen(cptr));
                                else if (strlen(cp) < strlen(cptr))
                                        strcpy(gblmod.mod_name,cp);
                                break;
                        case 'r':
                                sscanf(&line[4],"%*s %*1s %*s %*s %s",info);
                                fgets(line,80,fpin);
                                cptr=strchr(line,'#');
                                if (cptr == NULL)  sscanf(line,"%*1s %*s %*1s %d",&ul);
                                else sscanf(line,"%*1s %*s %*1s %lx",&ul);
                             // blkcnt++;
                                memset(tmpsym,NULL,SYMRECLEN);
                                tmpsym[1] = (unsigned char)strlen(name);
                                memcpy(&tmpsym[2],name,strlen(name));
                                tmpsym[42] = (unsigned char)(ul >> 16);
                                tmpsym[43] = (unsigned char)(ul >> 8);
                                tmpsym[44] = (unsigned char)(ul & 0xff);
                                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                                modsymcnt++;
                                if (srtinx == MRGSYMSZ)  {
                                        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                                        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                                        srtinx = 0;
                                }
                                if (CheckGlobal(name,ul) == OK)         {
                                        write(fds2,tmpsym,SYMRECLEN);
                                        gblsymcnt++;
                                }
                                break;
                        case 'v':
                                cptr = strchr(line,RB);
                                sscanf(cptr,"%*1s %*1s %*d %s",info);
                                if (info[0] != 's') break;
                                cptr = strchr(line,'#');
                                if (cptr != NULL) sscanf(cptr,"%*1s %lx",&ul);
                                else sscanf(&line[4],"%*d %*s %*1s %*d %*1s %d",&ul);
                                memset(tmpsym,NULL,SYMRECLEN);
                                tmpsym[1] = (unsigned char)strlen(name);
                                memcpy(&tmpsym[2],name,strlen(name));
                                tmpsym[42] = (unsigned char)(ul >> 16);
                                tmpsym[43] = (unsigned char)(ul >> 8);
                                tmpsym[44] = (unsigned char)(ul & 0xff);
                                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                                modsymcnt++;
                                if (srtinx == MRGSYMSZ)  {
                                        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                                        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                                        srtinx = 0;
                                }
                                if (CheckGlobal(name,ul) == OK)         {
                                        write(fds2,tmpsym,SYMRECLEN);
                                        gblsymcnt++;
                                }
                                break;
                        default:
                                break;
                }   /* end switch */
        } /* end while */
        if (modsymcnt > 0) {
           write(fds1,srtbuf[0],modsymcnt*SYMRECLEN);
           memset(srtbuf[0],NULL,modsymcnt*SYMRECLEN);
        }
        gblmod.mod_inx = ++modinx;
        ProcessModSym(fds1);
        ResetEnvironment();
        if (inputFileInx== inputFileCnt-1) ProcessGblSym(fds2);
        return;
}


GetLocInfo()
{
        char *cptr;
        char model[10];
        int id;
        char line[100];

        memset(model,NULL,10);
        while (fgets(line,80,fpin) != NULL && strncmp(line,".id",3) == 0) {
                if ((cptr=strstr(&line[3],"target")) != NULL)  {
                        sscanf(cptr,"%*1s %*s %*1s %s %*1s",model);
                        if ((cptr=strchr(model,'"')) != NULL)  *cptr = NULL;
                        if (strcmp(model,"68000") == 0) id = 1;
                        else if (strcmp(model,"68020") == 0) id = 2;
                        else if (strncmp(model,"86",2) == 0) id = 3;
                        switch (id) {
                                case 1:
                                        AddrUnit = att.addrunit = 3;
                                        break;
                                case 2:
                                        AddrUnit = att.addrunit = 4;
                                        break;
                                case 3:
                                        prn_exit("Converter will accept OMF format for 86 series models.\r\n");
                                        break;
                                default:
                                        prn_exit("Invalid input file!\r\n");
                                        break;
                        }
                }
        }
        loc.start = ftell(fpin);
        while (fgets(line,80,fpin) != NULL && strncmp(line,".seg",4) != 0)
                loc.start = ftell(fpin);
        loc.defg = ftell(fpin);
        while (fgets(line,80,fpin) != NULL && strncmp(line,".defg",5) != 0)
                loc.defg = ftell(fpin);
        defgcnt++;
        while (fgets(line,80,fpin) != NULL && strncmp(line,".defg",5) == 0)
                defgcnt++;
        loc.end = ftell(fpin);
        if (strncmp(line,".start",6) != 0) {
                while (fgets(line,80,fpin) != NULL && strncmp(line,".start",6) != 0)
                        loc.end = ftell(fpin);
        }
}

CheckGlobal(name,addr)
char *name;
unsigned long addr;
{
        unsigned long savepos;
        char *cptr,aname[40];
        unsigned long ul;
        int chkcnt=0;
        char line[100];

        savepos = ftell(fpin);
        fseek(fpin,loc.defg,0);
        while (fgets(line,80,fpin) != NULL && strncmp(line,".defg",5) != 0) ;
        do {
                sscanf(&line[7],"%s %*s %*1s %lx",aname,&ul);
                if ((cptr=strchr(aname,RB)) != NULL) *cptr = NULL;
                if ((cptr=strchr(aname,'_')) != NULL) cptr++;
                else cptr = aname;
                chkcnt++;
                if (strcmp(cptr,name) == 0 && ul == addr)   {
                        fseek(fpin,savepos,0);
                        return(OK);
                } else    fgets(line,80,fpin);
        } while (chkcnt < defgcnt);
        fseek(fpin,savepos,0);
        return(FAIL);
}


/*===============   MRI Format: 68K, 51, Z80 and 64180   ==================*/

#define    M68K     0
#define    M51      1
#define    MZ80     2
#define    M86      3

int MriType=0;
unsigned long MRIpubloc,MRImodloc,MRIsegloc;
struct M86SegInfo {
        char *name;
        unsigned char cs[2];
        struct M86SegInfo *next;
} *seghead, *curptr;

/*****************************************************************************/
/****   mri68k51z80()                                                     *****/
/*****************************************************************************/

mri68k51z80()
{
        unsigned long ul[4];
        char name[4][42];
        int i,ret;
        char line[100];

        if ((fpin=fopen(fnin[inputFileInx],"rt")) == NULL)
                prn_exit("Error opening input file!\r\n");
        if (LengFlag) {
                att.addrunit = AddrUnit;
                att.absflag = AbsFlag = 0;
                MriType = M68K;
        } else if (!CheckEnvAtt()) prn_exit("Invalid symbol file format! \r\n");
        if ((fpmp=fopen(fnmp,"rt")) == NULL) {
                if (MriType == M86) prn_exit("Error opening map file!\r\n");
                else GlobalFlag = 0;
        }
        if (MriType == M86) GetMapLocM86();
        fseek(fpin,0L,0);
        while (fgets(line,180,fpin) != NULL && strstr(line,"$$") == NULL)  ;
/* skip the first module for 68K only */
//      if (MriType == M68K)   {
//              while (fgets(line,180,fpin) != NULL && strstr(line,"$$") == NULL)  ;
//      }
        do {
                if (line[0] == ':') break;
                if (strstr(line,"$$") != NULL)  {
                        if (modsymcnt > 0)   {
                           gblmod.mod_inx = ++modinx;
                           write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                           memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                           srtinx = 0;
                           ProcessModSym(fds1);
                        }
                        ResetEnvironment();
                        ret = sscanf(line," %*2s %s",name[0]);
                        if (name[0][0] == NULL)        {
//                              modinx--;
                                break;
                        }
                        else {
                                strcpy(gblmod.mod_name,name[0]);
                                if (MriType == M86) GetModSymM86();
                                continue;
                        }
                }
                if (strstr(line,"$") == NULL) break;
                if (MriType == M86) continue;
                else if (line[0] == '0')   /* M51 */
                        ret = sscanf(line,"%*s %s %lx%*1s",name[0],&ul[0]);
                else if (MriType == M68K)
                        ret = sscanf(line,
                                " %s %*1s%lx %s %*1s%lx %s %*1s%lx %s %*1s%lx ",
                                name[0],&ul[0],name[1],&ul[1],name[2],&ul[2],name[3],&ul[3]);
                else if (MriType == MZ80)
                        ret = sscanf(line,
                                " %s %lx%*1s %s %lx%*1s %s %lx%*1s %s %lx%*1s",
                                name[0],&ul[0],name[1],&ul[1],name[2],&ul[2],name[3],&ul[3]);
                for (i=0; i < ret/2; i++)  {
                        memset(tmpsym,NULL,SYMRECLEN);
                        tmpsym[1] = (unsigned char)strlen(name[i]);
                        strcpy(&tmpsym[2],name[i]);
                        if (AddrUnit == 2)  {
                                tmpsym[42] = (unsigned char)(ul[i] >> 8);
                                tmpsym[43] = (unsigned char)ul[i];
                        } else if (AddrUnit == 3)  {
                                tmpsym[42] = (unsigned char)(ul[i] >> 16);
                                tmpsym[43] = (unsigned char)(ul[i] >> 8);
                                tmpsym[44] = (unsigned char)ul[i];
                        } else if (AddrUnit == 4)  {
                                tmpsym[42] = (unsigned char)(ul[i] >> 24);
                                tmpsym[43] = (unsigned char)(ul[i] >> 16);
                                tmpsym[44] = (unsigned char)(ul[i] >> 8);
                                tmpsym[45] = (unsigned char)ul[i];
                        }
                        memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                        modsymcnt++;
                        if (srtinx == MRGSYMSZ)  {
                                write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                                memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                                srtinx = 0;
                        }
                }  /* end for */
        } while (fgets(line,180,fpin) != NULL);
/* processing the last module */
//      if (MriType != M68K && MriType != M86)  {
        if (srtinx)  {
           gblmod.mod_inx = ++modinx;
           write(fds1,srtbuf[0],SYMRECLEN*srtinx);
           memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
           srtinx = 0;
           ProcessModSym(fds1);
           ResetEnvironment();
        }
        freeseglist();
/* processing the globals */
        if (MriType == M86) GetGlobalsM86();
        else if (GlobalFlag) GetGlobals68k51z80();
        if (inputFileInx== inputFileCnt-1) ProcessGblSym(fds1);
        return;
}


/*****************************************************************************/
/***** CheckEnvAtt()                                                     *****/
/*****************************************************************************/

CheckEnvAtt()
{
        int doneflag=0;
        char line[100];

        fseek(fpin,0L,0);
        while (fgets(line,100,fpin) != NULL)  {
                if (strncmp(line,"$$",2) == 0)  {
                        fgets(line,100,fpin);
                        if (line[0] == '0')   {
                                MriType = M51;
                                att.addrunit = AddrUnit = 2;
                                att.absflag = AbsFlag = 0;
                                doneflag = 1;
                                return(doneflag);
                        }
                        else MriType = MZ80;
                }
                if (line[0] == ':')   {
/* Z80 */               if (strncmp(&line[7],"00",2) == 0) {
                                att.addrunit = AddrUnit = 2;
                                att.absflag = AbsFlag = 0;
                                doneflag = 1;
                                break;
                        }
                        else if (strncmp(&line[7],"02",2) == 0) {
                                MriType = M86;
                                att.addrunit = AddrUnit = 4;
                                att.absflag = AbsFlag = 1;
                                doneflag = 1;
                                break;
                        }
                }
                else if (line[0] == 'S')   {
                        MriType = M68K;
                        fgets(line,100,fpin);
                        if (strncmp(line,"S1",2) == 0)  {
                                att.addrunit = AddrUnit = 3;
                                att.absflag = AbsFlag = 0;
                                doneflag = 1;
                                break;
                        }
                        else if (strncmp(line,"S2",2) == 0)  {
                                att.addrunit = AddrUnit = 3;
                                att.absflag = AbsFlag = 0;
                                doneflag = 1;
                                break;
                        }
                        else if (strncmp(line,"S3",2) == 0)  {
                                att.addrunit = AddrUnit = 4;
                                att.absflag = AbsFlag = 0;
                                doneflag = 1;
                                break;
                        }
                }
        }  /* end while */
        return(doneflag);
}

/**************************************************************************/
/***** GetMapLocM86()                                                  ****/
/**************************************************************************/
#define ALLFS 0XFFFFFFFF

GetMapLocM86()
{
        char name[20],str[20];
        int ret;
        struct M86SegInfo *sptr;
        char line[100];

        /* getting public, segment and module location in map file */
        MRIpubloc = MRIsegloc = MRImodloc = ALLFS;
        while (fgets(line,180,fpmp) != NULL) {
                if (strstr(line,"Microtec Research, Inc.") != NULL) continue;
                if (strstr(line,"MODULE SUMMARY") != NULL) {
                        fgets(line,180,fpmp);
                        fgets(line,180,fpmp);
                        fgets(line,180,fpmp);
                        MRImodloc = ftell(fpmp);
                }
                else if (strstr(line,"SEGMENT SUMMARY") != NULL) {
                        fgets(line,180,fpmp);
                        fgets(line,180,fpmp);
                        fgets(line,180,fpmp);
                        MRIsegloc = ftell(fpmp);
                }
                else if (strstr(line,"PUBLIC SYMBOL TABLE") != NULL) {
                        fgets(line,180,fpmp);
                        fgets(line,180,fpmp);
                        fgets(line,180,fpmp);
                        MRIpubloc = ftell(fpmp);
                }
                if (MRImodloc != ALLFS && MRIsegloc != ALLFS && MRIpubloc != ALLFS)
                        break;
        } /* end while */

        /* build segment list: name and segment value for each segment */
        seghead = curptr = NULL;
        fseek(fpmp,MRIsegloc,0);
        while (fgets(line,180,fpmp) != NULL) {
                if (strstr(line,"PUBLIC SYMBOL TABLE") != NULL) break;
                if (strstr(line,"Microtek Research, Inc.") != NULL) continue;
                if (strstr(line,"SEGMENT") != NULL &&
                        strstr(line,"ALIGNMENT") != NULL) continue;
                ret = sscanf(line,"%s %s ",name,str);
                if (ret <= 1 || strcmp(name,"Public") == 0) continue;
                if (checkseglist(name)) continue;
                if ((sptr=(struct M86SegInfo *)malloc(sizeof(struct M86SegInfo))) == NULL)  {
                        freeseglist();
                        prn_exit("Memory allocation error!\r\n");
                }
                memset(sptr,NULL,sizeof(struct M86SegInfo));
                insertseglist(sptr);
                curptr = sptr;
                if (((curptr->name)=(char *)malloc(strlen(name)+1)) == NULL) {
                        freeseglist();
                        prn_exit("Memory allocation error!\r\n");
                }
                strcpy(curptr->name,name);
                getsegvalue();
        }
        return;
}

insertseglist(ptr)
struct M86SegInfo *ptr;
{
        struct M86SegInfo *aptr;

        if (seghead == NULL) seghead = ptr;
        else {
                aptr = seghead;
                while (aptr->next != NULL) aptr = aptr->next;
                aptr->next = ptr;
        }
}

checkseglist(name)
char *name;
{
        struct M86SegInfo *ptr;

        ptr = seghead;
        while (ptr != NULL) {
                if (strcmp(name,ptr->name) == 0) return(1);
                else ptr = ptr->next;
        }
        return(0);
}

freeseglist()
{
        struct M86SegInfo *ptr,*aptr;

        ptr = aptr = seghead;
        while (ptr != NULL) {
                free(ptr->name);
                aptr =ptr->next;
                free(ptr);
                ptr = aptr;
        }
}

getsegvalue()
{
        unsigned long savepos;
        char name[20];
        unsigned int ui;
        char line[100];

        savepos = ftell(fpmp);
        fseek(fpmp,MRIpubloc,0);
        while (fgets(line,180,fpmp) != NULL) {
                if (strstr(line,"START ADDRESS") != NULL) break;
                if (strstr(line,"Microtec Research, Inc.") != NULL) continue;
                if (strstr(line,"SYMBOL") != NULL  &&
                        strstr(line,"SEGMENT:OFFSET") != NULL) continue;
                if (strstr(line,curptr->name) == NULL) continue;
                sscanf(&line[30],"%s ",name);
                if (strcmp(name,"") == 0) continue;
                if (strcmp(name,curptr->name) != 0) continue;
                sscanf(&line[60],"%x",&ui);
                curptr->cs[0] = ui >> 8;
                curptr->cs[1] = (unsigned char) ui;
                break;
        }
        fseek(fpmp,savepos,0);
        return;
}

/**************************************************************************/
/***** GetModSymM86()                                                  ****/
/**************************************************************************/

GetModSymM86()
{
        unsigned int ui1,ui2;
        char modname[42],symname[42];
        int ret;
        char line[100];

        lseek(fds1,0L,0);
        fseek(fpmp,MRIpubloc,0);
        while (fgets(line,180,fpmp) != NULL) {
                if (strstr(line,"START ADDRESS") != NULL) break;
                if (strstr(line,"Microtec Research, Inc.") != NULL) continue;
                if (strstr(line,"SYMBOL") != NULL &&
                        strstr(line,"SEGMENT:OFFSET") != NULL) continue;
                memset(symname,NULL,sizeof(symname));
                memset(modname,NULL,sizeof(modname));
                ret = sscanf(line,"%s %s ",symname,modname);
                if ( ret <= 2 && strcmp(symname,"") == 0) continue;
                if (strcmp(modname,gblmod.mod_name) != 0) continue;
                sscanf(&line[60],"%x%*c%x",&ui1,&ui2);
                memset(tmpsym,NULL,SYMRECLEN);
                tmpsym[1] = strlen(symname);
                strcpy(&tmpsym[2],symname);
                tmpsym[42] = (unsigned char) (ui1 >> 8);
                tmpsym[43] = (unsigned char) ui1;
                tmpsym[44] = (unsigned char) (ui2 >> 8);
                tmpsym[45] = (unsigned char) ui2;
                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                modsymcnt++;
                if (srtinx == MRGSYMSZ)  {
                        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                        srtinx = 0;
                }
        }
        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        srtinx = 0;
        return;
}

/*************************************************************************/
/***** GetGlobalsM86()                                              ******/
/*************************************************************************/

GetGlobalsM86()
{
        unsigned int ui1,ui2;
        char symname[42];
        int ret;
        char line[100];

        fseek(fpmp,MRIpubloc,0);
        lseek(fds1,0L,0);
        while (fgets(line,180,fpmp) != NULL) {
                if (strstr(line,"START ADDRESS") != NULL) break;
                if (strstr(line,"Microtec Research, Inc.") != NULL) continue;
                if (strstr(line,"SYMBOL") != NULL &&
                        strstr(line,"SEGMENT:OFFSET") != NULL) continue;
                memset(symname,NULL,sizeof(symname));
                ret = sscanf(line,"%s ",symname);
                if (ret <= 0 && strcmp(symname,"") == 0) continue;
                sscanf(&line[60],"%x%*c%x",&ui1,&ui2);
                memset(tmpsym,NULL,SYMRECLEN);
                tmpsym[1] = strlen(symname);
                strcpy(&tmpsym[2],symname);
                tmpsym[42] = (unsigned char) (ui1 >> 8);
                tmpsym[43] = (unsigned char) ui1;
                tmpsym[44] = (unsigned char) (ui2 >> 8);
                tmpsym[45] = (unsigned char) ui2;
                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                gblsymcnt++;
                if (srtinx == MRGSYMSZ)  {
                        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                        srtinx = 0;
                }
        }
        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        srtinx = 0;
        return;

}
/****************************************************************************/
/***** GetGlobals68k51z80()                                              ****/
/****************************************************************************/

GetGlobals68k51z80()
{
        char name[2][42];
        int i,ret;
        unsigned long ul[2];
        char line[100];

        while (fgets(line,180,fpmp) != NULL) {
                if (strstr(line,"PUBLIC SYMBOL") != NULL ||
                    strstr(line,"Public Symbol") != NULL) break;
                else continue;
        }
        if (MriType == M68K) {
                GetGlobals68k();
                return;
        }
        while (fgets(line,180,fpmp) != NULL)  {
                if (strstr(line,"**LOCAL SYMBOLS") != NULL ||
                    strstr(line,"**Local Symbols") != NULL) break;
                if (strstr(line,"Microtec") != NULL) continue;
                memset(&ul[0],NULL,sizeof(ul));
                if (MriType == M51)
                        ret = sscanf(line,"%s %*1s %lx %s %*1s %lx",name[0],&ul[0],name[1],&ul[1]);
                else if (MriType == MZ80)
                        ret = sscanf(line,"%s %lx %s %lx",name[0],&ul[0],name[1],&ul[1]);
                if (ret <= 0) continue;
                for (i=0; i < ret/2 ; i++) {
                        memset(tmpsym,NULL,SYMRECLEN);
                        tmpsym[1] = (unsigned char)strlen(name[i]);
                        strcpy(&tmpsym[2],name[i]);
                        tmpsym[42] = (unsigned char)(ul[i] >> 8);
                        tmpsym[43] = (unsigned char)ul[i];
                        memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                        gblsymcnt++;
                        if (srtinx == MRGSYMSZ)  {
                                write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                                memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                                srtinx = 0;
                        }
                }  /* end for */
        } /* end while */
        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        srtinx=0;
        return;

}


/***************************************************************************/
/***** GetGlobals68k()                                                  ****/
/***************************************************************************/

GetGlobals68k()
{
        char name[42];
        int id,ret;
        unsigned long ul;
        char line[100];

        while (fgets(line,180,fpmp) != NULL && strstr(line,"ADDRESS") == NULL) ;
        while (fgets(line,180,fpmp) != NULL)  {
                if (strstr(line,"Microtec ") != NULL) continue;
                if (strstr(line,"CROSS REFERENCE") != NULL) break;
                if (strstr(line,"ERROR") != NULL) break;
                if (strstr(line,"START ADDRESS") != NULL) break;
                ul = 0;   id = 0;
                ret = sscanf(line,"%s ",name);
                if (ret <= 0) continue;
                ret = sscanf(&line[54]," %lx",&ul);
                if (ret <= 0) continue;
                memset(tmpsym,NULL,SYMRECLEN);
                tmpsym[1] = (unsigned char)strlen(name);
                strcpy(&tmpsym[2],name);
                if (AddrUnit == 3)  {
                        tmpsym[42] = (unsigned char)(ul >> 16);
                        tmpsym[43] = (unsigned char)(ul >> 8);
                        tmpsym[44] = (unsigned char) ul;
                } else if (AddrUnit == 4)  {
                        tmpsym[42] = (unsigned char)(ul >> 24);
                        tmpsym[43] = (unsigned char)(ul >> 16);
                        tmpsym[44] = (unsigned char)(ul >> 8);
                        tmpsym[45] = (unsigned char) ul;
                }
                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                gblsymcnt++;
                if (srtinx == MRGSYMSZ)  {
                        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                        srtinx = 0;
                }
        }  /* end while */
        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        srtinx=0;
        return;
}

/*---------------------   MRI64180   -------------------------------------*/

/*****************************************************************************/
/***** mri64180()                                                       ******/
/*****************************************************************************/

mri64180()
{
        unsigned long ul,ua[3];
        int cnt,i,j;
        char line[100],name[10];

        if ((fpin=fopen(fnin[inputFileInx],"rt")) == NULL)
                prn_exit("Error opening map file as the input file!\r\n");

        memset(name,NULL,10);
        while (fgets(line,180,fpin) != NULL) {
                if (strstr(line,"S0") == line) continue;
                else if (strstr(line,"S1") == line) break;
                else if (strstr(line,"S9") == line) break;
                else if (strstr(line,"S6") == line) {
                        i = strlen(line) - 2 - 8;
                        cnt = i / 14;
                        for (i=8; cnt > 0; cnt--,i+=6) {
                                memset(tmpsym,NULL,SYMRECLEN);
                                strncpy(name,&line[i],8);
                                sscanf(name," %s ",&tmpsym[2]);
                                tmpsym[1] = (unsigned char)strlen(&tmpsym[2]);
                                i += 8;
                                memset(name,NULL,10);
                                memcpy(name,&line[i],6);
                                ul = 0L;
                                sscanf(name," %lx ",&ul);
                                tmpsym[44] = (unsigned char) ul;
                                tmpsym[43] = (unsigned char) ((ul & 0x0000ff00) >> 8);
                                tmpsym[42] = (unsigned char) ((ul & 0x00ff0000) >> 16);
                                gblsymcnt++;
                                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                                if (srtinx == MRGSYMSZ)  {
                                        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                                        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
                                        srtinx = 0;
                                }
                        }   // end for
                }   // end if
        } // end while
        if (srtinx > 0) {
                write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        }
        if (inputFileInx== inputFileCnt-1) ProcessGblSym(fds1);
        return;
}



