/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       UCO4.C
Engineer:     Amy Wang
Description:  processing OMF 286/386, HITACHI SYSROF/H8 file formats

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <search.h>
#include <errno.h>
#include "uco1.h"
#include "uco3.h"

unsigned long ABSTXTloc,DEBTXTloc,lastloc;
unsigned long segloc[7];   /* 0:MODULES, 1:TYPES, 2:SYMBOLS, 3:LINES */
                           /* 4:PUBLICS, 5:EXTERNALS, 6:SRCLINES     */
struct DTindex GDTable,IDTable,LDTable; /*loc,len*/
unsigned char GetDPL(),dscrp[8],curdpl;
unsigned long GetLimit();
unsigned int cursel;
int iplen,alen,llen;  /* alen: len of real addr, llen: len of the len field*/
char SrcType;

/****************************************************************************/
/***** omf2386()                                                       ******/
/****************************************************************************/

omf2386()
{
        int i,j,k,modlen;
        long lpos;
        unsigned long ul1,ul2,mbyte,abyte,Sga,Pga;
        unsigned int  sel,ui1,ui2;
        unsigned char uc,dpl;

//      if (OpenTempFile(2) < 2) prn_exit("Error opening temp files!\r\n");
        if (yes386) { iplen = 4; alen = 4; llen = 4; }
        else { iplen = 2;  alen = 3; llen = 2; }

/* processing the TOC in the partition */
        lseek(fdin,76L,0);
        read(fdin,temp1,28);
        memcpy(&ABSTXTloc,temp1,4);
        memcpy(&DEBTXTloc,&temp1[4],4);
        memcpy(&lastloc,&temp1[8],4);

/* getting the GDT,IDT,LDT table information from ABSTXT section */
        lseek(fdin,ABSTXTloc,0);
        for (i=0; i < 4; i++) {
                read(fdin,temp1,alen+llen);
                ul1 = 0L;
                ul2 = tell(fdin);
                memcpy(&ul1,&temp1[alen],llen);
                lseek(fdin,ul1,1);
                switch (i) {
                        case 1:
                                GDTable.loc = ul2;
                                GDTable.len = ul1;
                                break;
                        case 2:
                                IDTable.loc = ul2;
                                GDTable.len = ul1;
                                break;
                        case 3:
                                LDTable.loc = ul2;
                                LDTable.len = ul1;
                                break;
                        default:
                                break;
                }
        }  /* end for */

/* processing the TOC from DEBTXT section, getting fileloc for each seg */
        if (DEBTXTloc == 0)
                prn_exit("Debugging information is not present.\r\n");
        lseek(fdin,DEBTXTloc,0);
        read(fdin,temp1,4);
        memcpy(&ui1,temp1,2);          /* # of segments */
        memcpy(&ui2,&temp1[2],2);      /* len of the TOC */
        read(fdin,temp1,ui2);
        for (i=0; i < ui1; i++) memcpy(&segloc[i],&temp1[i*4],4);
        if (segloc[0] == 0)
                prn_exit("Debugging information is not enough.\r\n");
        for (i=1; i < 7; i++) if (segloc[i] != 0) break;
        mbyte = segloc[i] - segloc[0];   /*get total byte counts for MODULES*/

/* processing each module in MODULES */
        lseek(fdin,segloc[0],0);
        if (yes386)  modlen = 2 + 6*7 + 2 + 1 + 1 + 4;  /*trans id =47 */
        else         modlen = 2 + 4*6 + 2 + 1 + 4;      /*trasn id =28 */
        abyte = 0;
        abyte += (i=read(fdin,temp1,modlen+1));
        while (abyte < mbyte)  {
                if (modsymcnt > 0) {
                   gblmod.mod_inx = ++modinx;
                   ProcessModSym(fds1);
                }
                ResetEnvironment();
/* getting module information */
//              modinx++;
                ul1 = 0;
                memcpy(&ul1,&temp1[2],iplen);
                memcpy(&ui1,&temp1[2+iplen],2);
//              gblmod.mod_inx = modinx;
                if (yes386) uc = temp1[47];
                else uc = temp1[28];
                if (uc > 244) uc = 256 - uc;
                if (uc == 6)        SrcType = C_SOURCE;
                else if (uc == 2)   SrcType = PLM_SOURCE;
                else                SrcType = OTHERS;
                cursel = ui1;
                GetDescriptor(cursel);
                curdpl = GetDPL();
                cursel = cursel & 0xfc | curdpl;
                Pga = Sga = 0;
                memcpy(&Sga,&temp1[2+(iplen+2)*2],iplen);
                memcpy(&Pga,&temp1[2+(iplen+2)*4],iplen);
                j = (int)temp1[modlen];
                abyte += (i=read(fdin,temp1,j));
                memcpy(gblmod.mod_name,temp1,j);
                lpos = tell(fdin);
                abyte += (i=read(fdin,temp1,modlen+1));
                if (abyte > mbyte) {
                        GetSymbols2386(Sga,0xffffffff);
                        GetPublics2386(Pga,0xffffffff);
                } else {
                        ul1 = 0;   ul2 = 0;
                        memcpy(&ul1,&temp1[2+(iplen+2)*2],iplen);
                        memcpy(&ul2,&temp1[2+(iplen+2)*4],iplen); /* for publics */
                        if (Sga != ul1) GetSymbols2386(Sga,ul1);
                        if (Pga != ul2) GetPublics2386(Pga,ul2);
                }
                lseek(fdin,lpos,0);
                read(fdin,temp1,modlen+1);
        } /* end while */

/* processing the last module */
        gblmod.mod_inx = ++modinx;
        ProcessModSym(fds1);
        ResetEnvironment();

/* processing the globals */
        if (inputFileInx== inputFileCnt-1) ProcessGblSym(fds2);
//      NormalExit();
        return;
}


GetDescriptor(sel)
unsigned int sel;
{
        unsigned long savepos,loc;
        struct DTindex *dtable;

        savepos = tell(fdin);
        memset(dscrp,NULL,8);
        if (sel & 0x4) dtable = &LDTable;
        else dtable = &GDTable;
        loc = (unsigned long)((sel >> 3) * 8);
        if (loc > dtable->len) return;
        loc += dtable->loc;
        lseek(fdin,loc,0);
        read(fdin,dscrp,8);
        lseek(fdin,savepos,0);
        return;
}

unsigned char GetDPL()
{
        unsigned char dpl;
        dpl = ((dscrp[5] >> 5) & 0x3);
        return(dpl);
}

unsigned long GetLimit()
{
        unsigned long limit=0;
        if (yes386) limit = (unsigned long)(dscrp[6] & 0xf);
        limit = (limit << 8) + dscrp[1];
        limit = (limit << 8) + dscrp[0];
        return(limit);
}

GetSymbols2386(spos,npos)
unsigned long spos,npos;
{
        unsigned long abyte=0,tbyte,savepos,base,ul1,ul2,acclen=0,blen;
        int i,j,code,BPflag=0;
        unsigned int sel;
        unsigned char dpl;

        if (npos == 0xffffffff) {
                if (segloc[3] != 0) ul1 = segloc[3];
                else  {
                        for (i=4; i < 7; i++) if (segloc[i] != 0) break;
                        if (i == 7) ul1 = lastloc;
                        else ul1 = segloc[i];
                }
                tbyte = ul1 - (segloc[2] + spos);
        }
        else tbyte = npos - spos;
        savepos = tell(fdin);
        lseek(fdin,segloc[2]+spos,0);
        abyte += (i=read(fdin,temp1,1));
        code = (int)temp1[0];
        while (abyte < tbyte) {
                switch (code) {
                        case 0:
                                abyte += (i=read(fdin,temp1,iplen+llen+1));
                                j = (int) temp1[iplen+llen];
                                blen = 0;
                                memcpy(&blen,&temp1[iplen],llen);
                                if (SrcType == C_SOURCE)        acclen = blen;
                                else if (SrcType == PLM_SOURCE) acclen += blen;
                                abyte += (i=read(fdin,temp1,j+1));
                                code = (int) temp1[j];
                                break;
                        case 1:
                                abyte += (i=read(fdin,temp1,iplen+2+1+iplen+llen+1));
                                ul1 = 0;
                                memcpy(&ul1,temp1,iplen);
                                j = (int) temp1[iplen+2+1+iplen+llen];
                                abyte += (i=read(fdin,temp1,j+1));
                                code = (int) temp1[j];
                                blen = 0;
                                memcpy(&blen,&temp1[iplen+2+1+iplen],llen);
                                if (yes386 && SrcType == PLM_SOURCE) acclen += blen;
                                memset(tmpsym,NULL,SYMRECLEN);
                                tmpsym[1] = (unsigned char) j;
                                memcpy(&tmpsym[2],temp1,j);
                                tmpsym[42] = (unsigned char) (cursel >> 8);
                                tmpsym[43] = (unsigned char) (cursel & 0xff);
                                if (yes386) {
                                        tmpsym[44] = (unsigned char) (ul1 >> 24);
                                        tmpsym[45] = (unsigned char) (ul1 >> 16);
                                        tmpsym[46] = (unsigned char) (ul1 >> 8);
                                        tmpsym[47] = (unsigned char) ul1;
                                } else {
                                        tmpsym[44] = (unsigned char) (ul1 >> 8);
                                        tmpsym[45] = (unsigned char) ul1;
                                }
                                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                                modsymcnt++;
                                if (srtinx == MRGSYMSZ) {
                                   write(fds1,srtbuf[0],SYMRECLEN*MRGSYMSZ);
                                   memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                                   srtinx = 0;
                                }
                                break;
                        case 3:
                                BPflag = 0;   base = 0;
                                abyte += (i=read(fdin,temp1,iplen+2+1));
                                code = (int)temp1[iplen+2];
                                memcpy(&base,temp1,iplen);
                                memcpy(&sel,&temp1[iplen],2);
                                if (sel < 0xfffc) {
                                        GetDescriptor(sel);
                                        dpl = GetDPL();
                                        sel = sel & 0xfc | dpl;
                                }
                                break;
                        case 4:
                                BPflag = 1;
                        case 2:
                                abyte += (i=read(fdin,temp1,1));
                                code = (int)temp1[0];
                                break;
                        case 5:
                                ul1 = 0;
                                abyte += (i=read(fdin,temp1,iplen+2+1));
                                memcpy(&ul1,temp1,iplen);
                                j = (int)temp1[iplen+2];
                                abyte += (i=read(fdin,temp1,j+1));
                                code = (int)temp1[j];
                                if (BPflag) break;
                                ul1 += base;
                                memset(tmpsym,NULL,SYMRECLEN);
                                tmpsym[1] = (unsigned char) j;
                                memcpy(&tmpsym[2],temp1,j);
                                tmpsym[42] = (unsigned char) (sel >> 8);
                                tmpsym[43] = (unsigned char) sel;
                                if (yes386) {
                                        tmpsym[44] = (unsigned char) (ul1 >> 24);
                                        tmpsym[45] = (unsigned char) (ul1 >> 16);
                                        tmpsym[46] = (unsigned char) (ul1 >> 8);
                                        tmpsym[47] = (unsigned char) ul1;
                                } else {
                                        tmpsym[44] = (unsigned char) (ul1 >> 8);
                                        tmpsym[45] = (unsigned char) ul1;
                                }
                                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                                modsymcnt++;
                                if (srtinx == MRGSYMSZ) {
                                   write(fds1,srtbuf[0],SYMRECLEN*MRGSYMSZ);
                                   memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                                   srtinx = 0;
                                }
                                break;
                        default:
                                abyte += (i=read(fdin,temp1,iplen+2+1));
                                j = (int) temp1[iplen+2];
                                abyte += (i=read(fdin,temp1,j+1));
                                code = (int) temp1[j];
                                break;
                } /* end switch */
        } /* end while */
        write(fds1,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        srtinx = 0;
        lseek(fdin,savepos,0);
        return;
}

GetPublics2386(spos,npos)
unsigned long spos,npos;
{
        unsigned long savepos,tbyte,abyte=0,ul1;
        int i,j,k;
        unsigned int sel;
        unsigned char dpl;

        if (npos == 0xffffffff) {
                if (segloc[5] != 0) ul1 = segloc[5];
                else  {
                        for (i=6; i < 7; i++) if (segloc[i] != 0) break;
                        if (i == 7) ul1 = lastloc;
                        else ul1 = segloc[i];
                }
                tbyte = ul1 - (segloc[4] + spos);
        }
        else tbyte = npos - spos;
        savepos = tell(fdin);
        lseek(fdin,segloc[4]+spos,0);
        k = (iplen + 2) + 2 + 1 + 1;
        abyte += (i=read(fdin,temp1,k));
        while (abyte < tbyte) {
                ul1 = 0;
                memcpy(&ul1,temp1,iplen);
                memcpy(&sel,&temp1[iplen],2);
                j = (int) temp1[k-1];
                if (sel < 0xfffc) {
                        GetDescriptor(sel);
                        dpl = GetDPL();
                        sel = sel & 0xfc | dpl;
                }
                memset(tmpsym,NULL,SYMRECLEN);
                tmpsym[42] = (unsigned char) (sel >> 8);
                tmpsym[43] = (unsigned char) sel;
                if (yes386) {
                        tmpsym[44] = (unsigned char) (ul1 >> 24);
                        tmpsym[45] = (unsigned char) (ul1 >> 18);
                        tmpsym[46] = (unsigned char) (ul1 >> 8);
                        tmpsym[47] = (unsigned char) ul1;
                } else {
                        tmpsym[44] = (unsigned char) (ul1 >> 8);
                        tmpsym[45] = (unsigned char) ul1;
                }
                abyte += (i=read(fdin,temp1,j+k));
                tmpsym[1] = (unsigned char) j;
                memcpy(&tmpsym[2],temp1,j);
                memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                gblsymcnt++;
                if (srtinx == MRGSYMSZ) {
                   write(fds2,srtbuf[0],SYMRECLEN*MRGSYMSZ);
                   memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                   srtinx = 0;
                }
                memcpy(temp1,&temp1[j],k);
        } /* end while */
        write(fds2,srtbuf[0],SYMRECLEN*srtinx);
        memset(srtbuf[0],NULL,SYMRECLEN*srtinx);
        srtinx = 0;
        lseek(fdin,savepos,0);
        return;

}


/*============================ SYSROF ===================================*/

int oflen,seglen;
unsigned long *section;

sysrof()
{
        int code,ilen,i,j,k,alm=0,ep=0,SFlag=0,stype,atype,unit=-1,secno;
        unsigned long ul1,ul2,ul3,cstart,cend;
        unsigned int ui1,ui2;
        char name[100],*cp1,*cp2,*cp3;


//      if (OpenTempFile(2) < 2) prn_exit("Error opening temp files!\r\n");
        lseek(fdin,0L,0);
        read(fdin,temp,2);
        do {
           code = (int)(temp[0] & 0x7f);
           ilen = (int)temp[1];
           read(fdin,temp1,ilen);
           switch (code) {
              case SYSROF_HD:
                 if (((temp1[0]&0xf0)>>4) != 0)
                         prn_exit("Invalid symbol file format!\r\n");
                 alm = 1;
                 i = 13;
                 j = (int) temp1[i++];
                 j = (j << 8) + temp1[i];
                 i = 21;
                 att.absflag = AbsFlag = (int)((temp1[i]&0x80)>>7);
                 i++;
                 oflen = (int)temp1[i] / 8;
                 seglen = (int)temp1[++i] / 8;
                 if (AbsFlag == 0) att.addrunit = AddrUnit = oflen;
                 else att.addrunit = AddrUnit = oflen + seglen;
                 i = 25;
                 ep = (int)temp1[i];
                 if (!alm) i += 4;
                 if (ep && AbsFlag)  i += seglen;
                 if (ep) i += oflen;
                 i++;
                 k = (int) temp1[i];    /* length of target os name */
                 i += k;
                 k = (int) temp1[++i];  /* length of target system name */
                 i += k;
                 k = (int) temp1[++i];  /* length of module name */
                 i += k;
                 i++;
                 if (strstr(&temp1[i],"H8") != NULL) H8Flag = 1;
                 break;

              case SYSROF_UN:
                 unit++;
                 secno = (int)temp1[1];
                 secno = (secno << 8) + temp1[2];
                 break;

              case SYSROF_SC:
                 i=0;
                 secno--;
                 if (temp1[i++] != 0) break;
                 ul1=0L;  ui1=0;
                 ul1 = (unsigned long)temp1[i++];
                 ul1 = (ul1<<8) + temp1[i++];
                 ul1 = (ul1<<8) + temp1[i++];
                 ui1 = (unsigned int) temp1[i++];
                 ui1 = (ui1<<8) + temp1[i++];
                 i++;   i++;
                 break;

              case SYSROF_DU:
                 if (modsymcnt > 0)  {
                    gblmod.mod_inx = ++modinx;
                    write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                    memset(srtbuf,NULL,SYMRECLEN*srtinx);
                    srtinx = 0;
                    ProcessModSym(fds1);
                 }
//               modinx++;
                 ResetEnvironment();
//               gblmod.mod_inx = modinx;
                 i = 3;
                 j = (int) temp1[i++];
                 j = (j << 8) + (int)temp1[i++];
                 section = (unsigned long *)calloc(j,sizeof(unsigned long));
                 if (section == NULL) prn_exit("Memory allocation error!\r\n");
                 for (ul1=0,k=0,i+=2; k < j; k++,i+=4) {
                    ul1 = (unsigned long)temp1[i++];
                    ul1 = (ul1 << 8) + (unsigned long)temp1[i++];
                    ul1 = (ul1 << 8) + (unsigned long)temp1[i++];
                    section[k] = ul1;
                 }
                 break;

              case SYSROF_DUS:
                 i=5;    j = temp1[i++];
                 memset(name,NULL,100);
                 memcpy(name,&temp1[i],j);
                 cp1 = strrchr(name,'.');
                 cp2 = strrchr(name,':');
                 cp3 = strrchr(name,'\\');
                 if (cp2 == NULL)  {
                    if (cp3 == NULL)    cp2 = name;
                    else   cp2 = ++cp3;
                 }
                 else {
                    if (cp3 == NULL)    cp2++;
                    else if (strlen(cp2) > strlen(cp3))  cp2 = ++cp3;
                    else   ++cp2;
                 }
                 if (cp1 == NULL)    strcpy(gblmod.mod_name,cp2);
                 else if (strlen(cp1) > strlen(cp2)) strcpy(gblmod.mod_name,cp2);
                 else memcpy(gblmod.mod_name,cp2,strlen(cp2)-strlen(cp1));
                 break;

              case SYSROF_DPS:
                 if (temp1[0] == 0x00) SFlag = 1;
                 else if (temp1[0] == 0x80) {
                    SFlag = 0;
                    free(section);
                 }
                 break;

              case SYSROF_DSY:
                 stype = (int) (temp1[0] >> 1);
                 if (stype > 3) break;
                 memset(tmpsym,NULL,SYMRECLEN);
                 i=3;
                 tmpsym[1] = temp1[i++];
                 memcpy(&tmpsym[2],&temp1[i],tmpsym[1]);
                 i += (int) tmpsym[1];
                 atype = (int) temp1[i++];
                 if (atype == 1 || atype == 3 || atype == 6 || atype == 0xff) break;
                 i += 2;
                 j = (int) temp1[i++];
                 j = (j << 8) + (int) temp1[i++];
                 ui1 = (unsigned int) temp1[i++];
                 ui1 = (ui1 << 8) + (unsigned int) temp1[i++];
                 ul1 = section[j] + (unsigned long)ui1;
                 tmpsym[42] = (unsigned char) (ul1 >> 16);
                 tmpsym[43] = (unsigned char) (ul1 >> 8);
                 tmpsym[44] = (unsigned char) ul1;
                 memcpy(srtbuf[srtinx++],tmpsym,SYMRECLEN);
                 if (srtinx == MRGSYMSZ)  {
                    write(fds1,srtbuf[0],SYMRECLEN*MRGSYMSZ);
                    memset(srtbuf[0],NULL,SYMRECLEN*MRGSYMSZ);
                    srtinx = 0;
                 }
                 modsymcnt++;
/*               if (atype == 2 || atype == 5 || atype == 4) {  */
                    write(fds2,tmpsym,SYMRECLEN);
                    gblsymcnt++;
/*               }    */
                 break;

              case SYSROF_TR:
                 free(section);
                 if (modsymcnt > 0) {
                    write(fds1,srtbuf[0],SYMRECLEN*srtinx);
                    memset(srtbuf,NULL,SYMRECLEN*srtinx);
                    srtinx = 0;
                 }
                 gblmod.mod_inx = ++modinx;
                 ProcessModSym(fds1);
                 ResetEnvironment();
                 if (inputFileInx== inputFileCnt-1)
                    ProcessGblSym(fds2);
                 break;

              default:
                 break;
           }
           memcpy(temp,&temp1[ilen-2],2);
        } while (code != SYSROF_TR);

//      NormalExit();
        return;
}


