/***************************************************************************
**
** File name : cpu.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Change "cmd_argv[]" to be "cmd_syntax.asc[]".
**     4. Remove all "send_ESC()" calling from this file.
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "dos16.h"
#include  "database.h"

/**************************************************************************
**
** Local define
**
***************************************************************************/

/**************************************************************************
**
** Local variables
**
***************************************************************************/

int size_code[] = { 2, 2, 2, 3, 4, 5, 6 };
int size_symbol[] = { 0, 0, 2, 3, 4, 4, 6 };
int  donotlog = 0;

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern char *strchr();
extern int (*absaddr)();
extern int absad86();


/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

InitMICEGbls()
{
extern int nRelinkMICE; // added by Chen, 07/11/94, declared in CMDLINE.C

#ifndef MICEPACK
    if ( nRelinkMICE == FALSE ) {
      v_st("\n\n                 ( Linking MICE, please wait... )", VPLink);
      memset(MICEBuf, NULL, MICEBUFSIZE+1);   // added by Chen, 07/14/94
    }
    else {
        nRelinkMICE = FALSE;
    }
#endif
   if (emuInit() != OK) return (FALSE);
   if(SymLoaded == OK) free_all();
   env.Sabsflag = env.Saddrunit = -2;
   absaddr = absad86;
   env.Saddrunit = size_symbol[size_code[env.Maddrid]];
   env.Miplen= env.Maddrunit = 4;
   env.Scsiplen = env.Mcsiplen = (env.Maddrunit<<1) + 1;
   env.addr_limit = 0xffff;
   env.ChipGroup = CHIP86;
   env.MICEGroup = MICE3;
   caseFlag = 0;   // default : case insensitive
   return(TRUE);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*
DisplayTraceVPRange()
{
   char bbb[180];
   int VPtmp;
   VPtmp = VPOut;
   VPOut = COMVP;
   sprintf(bbb,"\n\rTraceVPRange().flag=%d, start=%x, end=%x",TraceVPRange.flag,TraceVPRange.start,TraceVPRange.end);
   d_prntf(bbb);
   VPOut = VPtmp;
}
*/
/**************************************************************************
**
** Name : LogCmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
LogCmd()
{
char buf[80], ff,  logged, logCmdorMenu, appendCmdorMenu;
WORD w1;
int fd_log, logFileExist;

   VPOut = COMVP;
   if ( cmd_syntax.argc == 3 ) {  // Close
      logFileExist = 0;
      if ( (cmd_logged == TRUE) ){   // && cmd_syntax.argv[0]
         Blog_close();
         logFileExist = 1;
         DisplayStr(" Command log file is closed!\n\r");
      }
      if ( (menu_logged == TRUE) && (cmd_syntax.argv[0] != 1)) {
         CloseMenuLogFile();
         logFileExist = 1;
         DisplayStr(" Menu log file is closed!\n\r");
      }
      if ( !logFileExist ) prn_ferr( 58 );
   }
   else {
      if ( cmd_syntax.argc == 0 ) { // Display
         ff = 0;
         if (log_cmd_file[0]) {
            sprintf(buf," Command Log file: %15s     Log toggle: %s\r\n",log_cmd_file,(cmd_flag ? "ON" : "OFF" ));
            DisplayStr( buf );
            ff = 1;
         }
         if (log_menu_file[0]) {
            sprintf(buf," Menu Log file:    %15s     Log toggle: %s\r\n",log_menu_file,(menu_flag ? "ON" : "OFF" ));
            DisplayStr( buf );
            ff = 1;
         }
         if (!ff) prn_ferr( 58 );
      }
      else { // Open log file
         if (cmd_syntax.argc == 2) {  // Append
            ff = 'A';
            if (cmd_syntax.argv[0] == 2) {
               if (cmd_logged && (stricmp( log_cmd_file, cmd_syntax.asc )==0))
                  cmd_syntax.argv[0] = 1; // log command
            //   else
             //     if (menu_logged && (stricmp( log_menu_file,
            //          cmd_syntax.asc ) ==0)) cmd_syntax.argv[0] = 0; // log menu
            }
         }
         else ff = 'O'; /* Over-write */
         if      (cmd_logged && cmd_syntax.argv[0]) Blog_close();
         else if (menu_logged && !cmd_syntax.argv[0]) CloseMenuLogFile();
         if (open_a_o( cmd_syntax.asc, (LPINT)&fd_log, ff)==OPEN_OK) {
            logged = TRUE;
            logCmdorMenu = 1;
            strcpy( buf, cmd_syntax.asc);
         }
         else {
            logged = FALSE;
            logCmdorMenu = 0;
            buf[0] = '\0';
         }
         if (!cmd_syntax.argv[0]) { // Menu Log
            menu_logged = logged;
            menu_flag   = logCmdorMenu;
            fd_menu_log = fd_log;
            strcpy( log_menu_file, buf );
         }
         else {   // Command Log
            cmd_logged = logged;
            cmd_flag   = logCmdorMenu;
            fd_cmd_log = fd_log;
            strcpy( log_cmd_file, buf );
         }
      }
   }
}        /* END OF LogCmd() */

/**************************************************************************
**
** Name : journalcmd()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

JournalCmd()
{
int i,j;
char buf[80], ff;
WORD w1;

   VPOut = COMVP;
   if ( cmd_syntax.argc == 1 ) {
     if ( out_logged == TRUE ) {
       Olog_close();
       DisplayStr(" Journal file is closed!\n\r");
     }
   }
   else if( cmd_syntax.argc == 2 ) {
     if(out_logged == TRUE) Olog_close();
     strcpy(log_out_file,cmd_syntax.asc);
     if(cmd_syntax.argv[0] == 1) ff = 'A';  /* APPEND */
     else ff = 'O'; /* Over-write */
     if(open_a_o(log_out_file,(LPINT)&fd_out_log,ff)==OPEN_OK) {
       out_logged = TRUE;
       out_flag = 1;
     } else {
       out_logged = FALSE;
       out_flag = 0;
     }
   }
   else if( cmd_syntax.argc == 0 ) {
     sprintf(buf," Journal file: %s        Journal toggle: %s\r\n",log_out_file,(out_flag?"ON":"OFF"));
     d_prntf(buf);
   }

   if(!usd_prn_ferr)  w1 = out_flag ? ON : OFF;

}      /* END OF journalcmd() */

/**************************************************************************
**
** Name : LogInteraction(c)
**
** Function : log one movement onto the menu log file
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
LogInteraction( int ch )
{
static char AltKeys[] = {
   KEY_AA, KEY_AB, KEY_AC, KEY_AD, KEY_AE, KEY_AF, KEY_AG, KEY_AH,
   KEY_AI, KEY_AJ, KEY_AK, KEY_AL, KEY_AM, KEY_AN, KEY_AO, KEY_AP,
   KEY_AQ, KEY_AR, KEY_AS, KEY_AT, KEY_AU, KEY_AV, KEY_AW, KEY_AX,
   KEY_AY, KEY_AZ
};
static struct  {
   char key, letter;
} ArrowKeys[] = {
   KEY_UP,   'U', KEY_DN,  'D', KEY_LEFT, 'L', KEY_RIGHT, 'R',
   KEY_HOME, 'H', KEY_END, 'E', KEY_BACK, 'B', KEY_INS,   'I', KEY_DEL, 'K'
}; static char digits[] = "123456789A";
char tempChar='\0';
int cnt, found = 0;

   if (!menu_flag || cmdfile_flag) return( FALSE );
   if (menuLogCnt == 512) {
      _lwrite(fd_menu_log,(LPSTR)MENU_LOG_BUF, 512);
      menuLogCnt = 0;
   }
   if      ( ch == KEY_ENTER )  MENU_LOG_BUF[menuLogCnt++]= '~';
   else if ( ch == KEY_ESC )    MENU_LOG_BUF[menuLogCnt++]= '^';
   else if ( ( ch >= KEY_F10 ) && ( ch <= KEY_F1 ) ) {
           MENU_LOG_BUF[menuLogCnt++]= '!';
           tempChar = digits[ (-1) * ch - 59 ];
   }
   else if ( ch >= 500 ) {
           if (ch == 599 ) MENU_LOG_BUF[menuLogCnt++]= ' ';
           else {
              for (cnt = 0; cnt < ch-500; cnt++) {
                  MENU_LOG_BUF[menuLogCnt++]= '!';
                  if (menuLogCnt == 512) {
                     _lwrite(fd_menu_log,(LPSTR)MENU_LOG_BUF, 512);
                     menuLogCnt = 0;
                  }
                  MENU_LOG_BUF[menuLogCnt++]= 'D';
                  if (menuLogCnt == 512) {
                     _lwrite(fd_menu_log,(LPSTR)MENU_LOG_BUF, 512);
                     menuLogCnt = 0;
                  }
              }
           }
   }
   else {
      found = 0;
      for (cnt = 0; cnt < 9; cnt ++ ) {
         if ( ch == ArrowKeys[ cnt ].key ) {
            MENU_LOG_BUF[menuLogCnt++]= '!';
            tempChar = ArrowKeys[ cnt ].letter;
            found = 1;
            break;
         }
      }
      if (!found) {
         found = 0;
         for (cnt = 0; cnt < 26; cnt++) {
            if ( ch == AltKeys[ cnt ] ) {
               MENU_LOG_BUF[menuLogCnt++]= '\n';
               if (menuLogCnt == 512) {
                  _lwrite(fd_menu_log,(LPSTR)MENU_LOG_BUF, 512);
                  menuLogCnt = 0;
               }
               MENU_LOG_BUF[menuLogCnt++]= '?';
               tempChar = cnt + 'A' ;
               found = 1;
               break;
            }
         }
         if (!found) MENU_LOG_BUF[menuLogCnt++]= ch;
      }
   }
   if (tempChar) {
      if (menuLogCnt == 512) {
         _lwrite(fd_menu_log,(LPSTR)MENU_LOG_BUF, 512);
         menuLogCnt = 0;
      }
      MENU_LOG_BUF[menuLogCnt++]= tempChar;
   }
}    /* end of LogInteraction( ch ) */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

Olog_close()
{
   if(out_logged == TRUE) {
      if(log_cnt) _lwrite(fd_out_log,(LPSTR)O_BUF,log_cnt);
      _lwrite(fd_out_log,(LPSTR)"\r\n",2);
      _lclose(fd_out_log);
      out_logged = FALSE;
      log_cnt = out_flag = 0;
      log_out_file[0] = '\0';
   }
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
Blog_close()
{
   if(cmd_logged == TRUE) {
      if(b_cnt) _lwrite(fd_cmd_log,(LPSTR)BAT_BUF,b_cnt);
      _lclose(fd_cmd_log);
      cmd_logged = FALSE;
      b_cnt = cmd_flag = 0;
      log_cmd_file[0] = '\0';
   }
}

/**************************************************************************
**
** Name : CloseMenuLogFile()
**
** Function : Close menu log file
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

CloseMenuLogFile()
{
   if (menu_logged == TRUE) {
      if (menuLogCnt) _lwrite(fd_menu_log,(LPSTR)MENU_LOG_BUF, menuLogCnt);
      _lclose(fd_menu_log);
      menu_logged = FALSE;
      menuLogCnt = menu_flag = 0;
      log_menu_file[0] = '\0';
   }
}

/**************************************************************************
**
** Name : OptionsCmd()
**
** Function
**
** Notes:
**   1. no argument,  cmd_syntax.argc = 0;
**   2. else          cmd_syntax.argc = 2 ;
**      {Symbol|Log|Journal|Breakpoint|Case}
**             cmd_syntax.argv[0] = {0|1|2|3|4}
**      {On|OFf} : cmd_syntax.argv[1] = { 0 | 1 }
**************************************************************************/

OptionsCmd()
{
int i,j;
char buf[80];
WORD ww, w1;

extern int nFillFlag;   // Chen 06/03/94


   VPOut = COMVP;
   if (cmd_syntax.argc == 2) {
      switch ((int)cmd_syntax.argv[0]) {
         case 0: /* Symbol */
            ww = 0; /*MN_O_SYMBOL;*/
            if(cmd_syntax.argv[1] == 0) sym_flag = 1; /* ON */
            else if(cmd_syntax.argv[1] == 1) sym_flag= 0;      /* OFF */
            else prn_ferr(25);
            RedrawFlag = ~MaskRedrawFlag;
            nFillFlag = TRUE;   // Chen 06/03/94
            UpdateVP();
            break;
         case 1:   /* Log */
            donotlog=1;
            ww = 1; /*MN_O_LOG;*/
            if (cmd_syntax.argv[1] == 0) { /* On */
               if (cmd_logged==TRUE) cmd_flag=1;
               if (menu_logged==TRUE) menu_flag=1;
               if (cmd_logged == FALSE && menu_logged == FALSE) prn_ferr(58);
            }
            else
               if (cmd_syntax.argv[1] == 1) { /* OFf */
                  if (cmd_logged==TRUE) cmd_flag=0;
                  if (menu_logged==TRUE) menu_flag=1;
                  if (cmd_logged == FALSE && menu_logged == FALSE) prn_ferr(58);
               }
               else prn_ferr(25);
            break;
         case 2: /* Journal */
            ww = 2; /*MN_O_JOURNAL;*/
            if (cmd_syntax.argv[1] == 0) { /* On */
               if (out_logged==TRUE) {
                  out_flag=1;
               }
               else prn_ferr(59);
            }
            else
               if (cmd_syntax.argv[1] == 1) { /* OFf */
                  if (out_logged==TRUE) {
                     out_flag=0;
                  }
                  else prn_ferr(59);
               }
               else prn_ferr(25);
            break;
         case 3: /* Breakpoint */
            ww = 3; /*MN_O_SW;*/
            if (cmd_syntax.argv[1] == 0) {  /* On */
               VNFlag = 0;
               init_sw();
               if (noRAM == 1) {
                  prn_ferr(49);
                  DisplayStr(" Please check if the S/W breakpoint vector is mapped to RAM location.\r\n");
               }
            }
            else
               if (cmd_syntax.argv[1] == 1) { /* OFf */
                  VNFlag = noRAM = 1;
                  emuClrBP(5+LAM2);
               }
               else prn_ferr(25);
            break;
         case 4: /* Case */
            caseFlag = (cmd_syntax.argv[1] == 0) ? 1 : 0;
            sprintf(buf," Case sensitive: %s\r\n", caseFlag ? "ON" :"OFF" );
            DisplayStr(buf);
            break;
         default :
            prn_ferr(25);
      }
      if (!usd_prn_ferr) w1 = cmd_syntax.argv[1];
   }
   else
      if (cmd_syntax.argc == 0) {
         sprintf(buf," SYMBOL  toggle: %s",((sym_flag)?"ON ":"OFF"));
         sprintf(buf+20,"               LOG            toggle: %s",((cmd_flag)?"ON\r\n":"OFF\r\n"));
         DisplayStr(buf);
         sprintf(buf," JOURNAL toggle: %s",((out_flag)?"ON ":"OFF"));
         sprintf(buf+20,"               S/W BREAKPOINT toggle: %s",((!noRAM)?"ON\r\n":"OFF\r\n"));
         DisplayStr(buf);
         sprintf(buf," Case sensitive: %s\r\n", caseFlag ? "ON ":"OFF" );
         DisplayStr(buf);
      }
      else prn_ferr(25);
   return(TRUE);
}         /* end of OptionsCmd() */

/**************************** End of File **********************************/
