/***************************************************************************
**
**  File name : DAD.H
**
**  Description : export function prototypes of DAD
**
**  Date : 3/3/1993  by C. H. Lin
**
**
**  Copyright (C) 1993 Microtek International Inc.
**  All Rights Reserved
**
****************************************************************************/


/****************************** Disassembler *******************************/

int Disassemble(long CSIP, unsigned char *Code, int CodeLen,  char *Buffer);
int DeqDisasm  (long PC,   unsigned char *Code, int CodeLen,  char *Buffer);
/*  return instruction length if success, 0 if codes are not enough  */

enum INST_TYPES {   // instruction types
   INST_CALL = 1, INST_RET, INST_INT, INST_LOOP, INST_REP
};

int IsStepCall(unsigned long Addr, unsigned char *Code,
               unsigned long *NextAddr);
/*  return 1 if is CALL instruction,
           2 if RET/RETF/IRET,
           3 if INT/INTO,
           4 if LOOP/LOOPZ/LOOPNZ,
           5 if REPZ/REPNZ str_manipulation
           0 otherwise  */

int dsmAddr2Sym(unsigned long Addr,  char *Symbol);
/*  return 1 if Addr can be converted to symbol (%xxx), 0 otherwise  */


/******************************** Assembler ********************************/

enum ASM_ERRORS {
    ASM_OK,
    ASM_MNEMONICERR,
    ASM_SYNTAXERR,
    ASM_FORMATERR,
    ASM_TYPEERR,
    ASM_UNDEFSYMBOL,
    ASM_INVALIDNUM,
    ASM_NUMOUTRANGE,
    ASM_JMPOUTRANGE,
    ASM_DEFTOOLARGE,
    ASM_DEFSTORAGE
};

int Assemble(unsigned long CSIP, char *Instruction,
             unsigned char *Codes, int *Length);
/* return error code;
   Length must be initialized as size of buffer for storing codes */

char *asmErrorMsg(int ErrorCode);

int asmSym2Addr(char *Symbol,  unsigned long *Addr);
/*  return 1 if symbol can be converted to address, 0 otherwise  */

/********************************* Dequeuer ********************************/

deqListNumber(int bufferID);

deqListFrame(int bufferID, long StartFrame,
             unsigned long Addr1, unsigned long Addr2, unsigned char Status);

deqListTrace(int bufferID, long StartFrame, int Command);
/* Command =  1: List Instruction, 2: List Source */

SetPutsBuf(char *OutputBuffer, int MaxRows, int InitialCount);
/* if OutputBuffer != NULL, output is placed in it, else on screen */
/* if OutputBuffer = NULL and InitialCount < 0, then no [More] */

int PutsMore(char *s);
/* return code of pressed key */

/****************************** End of File ********************************/
