/* dialog.h

The following data structure(s) are for allocating the underlying data
storage for the specified form(s) in your application.

The typedef name for each form's data structure is the form name in capital
letters.  The data structure has a member for each item (field, memo, or
scrollable region) on the form; the member name is the name of the item.  The
member for a scroll region is an array of the data structure for the scroll
region (the structure has a member for each of its fields).  Members are not
included if the OMITFROMSTRUCT option is turned ON for that particular item.

*/

typedef struct                      /* Data form data structure               */
{
    UCHAR log;
    UCHAR logfile[13];
    UCHAR journal;
    UCHAR joufile[13];
} FCLOSELOGJOU;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} FDOWNLOAD;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} FUPLOAD;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} YSSAVE;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} SSAVE;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} SRECALL;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} YSRECALL;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
} YLOAD;

typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
    UCHAR arguments[164];
} FINCLUDE;


typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
    UCHAR append;
} FJOURNAL;


typedef struct                      /* Data form data structure               */
{
    UCHAR filename[31];
    UCHAR append;
} FLOG;

typedef struct                      /* Data form data structure               */
{
    UCHAR checkbegin[14];
    UCHAR checkend[14];
} MCHECKSUM;


typedef struct                      /* Data form data structure               */
{
    UCHAR compbeg[14];
    UCHAR compend[14];
    UCHAR compdest[14];
} MCOMPARE;


typedef struct                      /* Data form data structure               */
{
    UCHAR copybeg[14];
    UCHAR copyend[14];
    UCHAR copydest[14];
} MCOPY;


typedef struct                      /* Data form data structure               */
{
    UCHAR disasmbeg[14];
    UCHAR disasmend[14];
} MDISASSEMBLY;


typedef struct                      /* Data form data structure               */
{
    UCHAR dumpbeg[14];
    UCHAR dumpend[14];
} MDUMP;


typedef struct                      /* Data form data structure               */
{
    UCHAR fillbeg[14];
    UCHAR fillend[14];
    UCHAR data[191];
} MFILL;


typedef struct                      /* Data form data structure               */
{
    UCHAR searchbeg[14];
    UCHAR searchend[14];
    UCHAR data[191];
} MSEARCH;


typedef struct                      /* Data form data structure               */
{
    UCHAR testbeg[14];
    UCHAR testend[14];
} MTEST;


typedef struct                      /* Data form data structure               */
{
    UCHAR symbol;
    UCHAR log;
    UCHAR journal;
    UCHAR swbp;
    UCHAR caseFlag;
} OTOGGLE;


typedef struct                      /* Data form data structure               */
{
    UCHAR screen;
    UCHAR softkey;
} OURECALL;


typedef struct                      /* Data form data structure               */
{
    UCHAR screen;
    UCHAR softkey;
} OUSAVE;

typedef struct                      /* Data form data structure               */
{
    UCHAR mapOptions;
    UCHAR mapbeg[14];
    UCHAR mapend[14];
    UCHAR mapattr[3];
} SMAP1;

typedef struct                      /* Data form data structure               */
{
    UCHAR traceBufID[5];
    UCHAR startFrame[10];
    UCHAR endFrame[10];
    UCHAR format[14];
    UCHAR begAddr[14];
    UCHAR endAddr[14];
    UCHAR status[21];
    UCHAR traceBits[11];
    UCHAR frameToStart[9];
} TLIST;

typedef struct                      /* Data form data structure               */
{
    UCHAR addr[14];
} YADDRESS;


typedef struct                      /* Data form data structure               */
{
    UCHAR symname[42];
    UCHAR addr[14];
} YCREATE;


typedef struct                      /* Data form data structure               */
{
    UCHAR symname[41];
} YDELETE;


typedef struct                      /* Data form data structure               */
{
    UCHAR symname[43];
} YSYMBOL;


typedef struct                      /* Data form data structure               */
{
    UCHAR option[7];
    UCHAR mname[21];
} YLIST;

typedef struct                      /* Data form data structure               */
{
    UCHAR synci;
    UCHAR synco;
} TSYNC;

typedef struct                      /* Data form data structure               */
{
    UCHAR bp;
    UCHAR reg;
    UCHAR code;
    UCHAR stack;
    UCHAR trace;
    UCHAR data;
} OUPDATE;


typedef struct                      /* Data form data structure               */
{
    UCHAR operation[10];
    UCHAR variable[42];
    UCHAR element[6];
    UCHAR type[5];
} MMONITOR;

typedef struct                      /* Data form data structure               */
{
    UCHAR action[10];
    UCHAR address[21];
    UCHAR count[7];
} TSW;

typedef struct                      /* Data form data structure               */
{
    UCHAR timerOp;
    UCHAR timer[6];
    UCHAR cnt0Op;
    UCHAR cnt0[6];
    UCHAR cnt1Op;
    UCHAR cnt1[6];
} TTIMER;

typedef struct                      /* Data form data structure               */
{
    UCHAR k1[221];
    UCHAR k2[221];
    UCHAR k3[221];
    UCHAR k4[221];
    UCHAR k5[221];
    UCHAR k6[221];
    UCHAR k7[221];
    UCHAR k8[221];
    UCHAR k9[221];
    UCHAR k10[221];
} ODEFINE;



typedef struct {
    UCHAR operation[6];
    UCHAR eventseq[22];
    UCHAR action[6];
    UCHAR mode[9];
    UCHAR count[5];
} TTRIGGER;


typedef struct {
    UCHAR operation[6];
    UCHAR levelno[2];
    UCHAR eventseq[57];
    UCHAR trace[4];
    UCHAR timer[4];
} LAM2TLEVEL;


typedef struct {
    UCHAR operation[6];
    UCHAR trace[4];
    UCHAR timer[4];
    UCHAR action[6];
    UCHAR state[201];
    UCHAR mode[9];
    UCHAR count[5];
} LAM2TRIGGER;


typedef struct
{
    UCHAR event1[8];
    UCHAR logic1[4];
    UCHAR event2[8];
    UCHAR logic2[4];
    UCHAR event3[8];
    UCHAR logic3[4];
    UCHAR event4[8];
    UCHAR logic4[4];
    UCHAR event5[8];
} LAM2TRIGSEQ;



/*
typedef struct {
    UCHAR levelno[2];
    UCHAR operation[6];
    UCHAR eventseq[57];
    UCHAR lam2action[21];
    UCHAR timer[4];
    UCHAR trace[4];
    UCHAR mode[9];
    UCHAR count[5];
} LAM2TRIGGER;
*/

/*
typedef struct
{
    UCHAR reset;
    UCHAR run;
    UCHAR then1[2];
    UCHAR if1[2];
    UCHAR else1[2];
} LAM2TRIGACT;
*/

/*
typedef struct                      // Data form data structure
{
    UCHAR evName[6];
    UCHAR on;
    UCHAR extIn;
    UCHAR act1[8];
    UCHAR act2[6];
    UCHAR act3[5];
    UCHAR act4[5];
    UCHAR extOut;
    UCHAR item1181[6];
    UCHAR item1140;
    UCHAR item1150;
    UCHAR item1083[8];
    UCHAR item1082[6];
    UCHAR item1121[5];
    UCHAR item1120[5];
    UCHAR item1160;
    UCHAR item1182[6];
    UCHAR item1141;
    UCHAR item1151;
    UCHAR item1087[8];
    UCHAR item1086[6];
    UCHAR item1123[5];
    UCHAR item1122[5];
    UCHAR item1161;
    UCHAR item1183[6];
    UCHAR item1142;
    UCHAR item1152;
    UCHAR item1091[8];
    UCHAR item1090[6];
    UCHAR item1125[5];
    UCHAR item1124[5];
    UCHAR item1162;
    UCHAR item1184[6];
    UCHAR item1143;
    UCHAR item1153;
    UCHAR item1095[8];
    UCHAR item1094[6];
    UCHAR item1127[5];
    UCHAR item1126[5];
    UCHAR item1163;
    UCHAR item1185[6];
    UCHAR item1144;
    UCHAR item1154;
    UCHAR item1099[8];
    UCHAR item1098[6];
    UCHAR item1129[5];
    UCHAR item1128[5];
    UCHAR item1164;
    UCHAR item1186[6];
    UCHAR item1145;
    UCHAR item1155;
    UCHAR item1103[8];
    UCHAR item1102[6];
    UCHAR item1131[5];
    UCHAR item1130[5];
    UCHAR item1165;
    UCHAR item1187[6];
    UCHAR item1146;
    UCHAR item1156;
    UCHAR item1107[8];
    UCHAR item1106[6];
    UCHAR item1133[5];
    UCHAR item1132[5];
    UCHAR item1166;
    UCHAR item1188[6];
    UCHAR item1147;
    UCHAR item1157;
    UCHAR item1111[8];
    UCHAR item1110[6];
    UCHAR item1135[5];
    UCHAR item1134[5];
    UCHAR item1167;
    UCHAR item1189[6];
    UCHAR item1148;
    UCHAR item1158;
    UCHAR item1115[8];
    UCHAR item1114[6];
    UCHAR item1137[5];
    UCHAR item1136[5];
    UCHAR item1168;
    UCHAR item1190[6];
    UCHAR item1149;
    UCHAR item1159;
    UCHAR item1119[8];
    UCHAR item1118[6];
    UCHAR item1139[5];
    UCHAR item1138[5];
    UCHAR item1169;
    UCHAR mode[11];
    UCHAR cnt0[7];
    UCHAR cnt1[7];
} TTRIGGER;
*/

typedef struct                      /* Data form data structure               */
{
    UCHAR op[6];
    UCHAR address[26];      // 30+1
    UCHAR datum[11];        // 24+1
    UCHAR stat1[21];
    UCHAR count[6];

    UCHAR item224[6];
    UCHAR item258[26];
    UCHAR item256[11];
    UCHAR stat2[21];
    UCHAR item285[6];

    UCHAR item225[6];
    UCHAR item261[26];
    UCHAR item259[11];
    UCHAR stat3[21];
    UCHAR item286[6];

    UCHAR item226[6];
    UCHAR item264[26];
    UCHAR item262[11];
    UCHAR stat4[21];
    UCHAR item287[6];


//    UCHAR item227[6];
//    UCHAR item234[23];
//    UCHAR item212[11];
//    UCHAR stat5[21];
//    UCHAR item228[6];
//    UCHAR item235[23];
//    UCHAR item213[11];
//    UCHAR stat6[21];
//    UCHAR item229[6];
//    UCHAR item236[23];
//    UCHAR item214[11];
//    UCHAR stat7[21];
//    UCHAR item230[6];
//    UCHAR item237[23];
//    UCHAR item215[11];
//    UCHAR stat8[21];
} TEVENT;

typedef struct {
    UCHAR op[6];
    UCHAR address[26];      // 31
    UCHAR datum[11];        // 25
    UCHAR status[21];
    UCHAR count[6];
} ONE_BUS_EVENT;

typedef struct {
    ONE_BUS_EVENT ev[8];
} BUS_EVENTS;

typedef UCHAR U8;
typedef UCHAR BOOLEAN;
typedef unsigned int U16;
typedef unsigned long U32;

typedef struct
{
    UCHAR evName[6];
    BOOLEAN on;
    BOOLEAN extIn;
    U8 act1[8];
    U8 act2[6];
    U8 act3[5];
    U8 act4[5];
    BOOLEAN extOut;
} T_EV;

typedef struct
{
    T_EV tEv[11];
    U8 mode[11];
    U8 cnt0[7];
    U8 cnt1[7];
} TLEVEL;
