/***************************************************************************
**
** File name : display.c
**
**
**
** Changing :
**
** A. Date -- 10/19/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**   ? 3. Why so many routines in other .c files call the eraseCMDCURSOR();
**       but it is a null and empty routine!!
**     4. Delete the "send_ESC()" calling.
**
** B. Date -- 10/22/1992 By Cheerson
**     0.
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include "reg86.h"
#ifndef _SD_ABI_DEF_
#include "sdabidef.h"
#endif
#include "abiexts.h"
#ifndef _LINUMDEF_
#include "linumdef.h"
#endif

/**************************************************************************
**
** Definitions
**
***************************************************************************/
#define ADDR2ABS(addr)  (U32)((addr>>12)&0x0FFFF0) + (U16)addr

/**************************************************************************
**
** Local variables
**
***************************************************************************/

char DataBuf[80];
char bdrBuf[80];
extern STR typeArr[];
void ShowCPUType( void );

int nBufFull = FALSE;       // Chen 06/09/94

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern unsigned int cpu_regs[];
//extern unsigned int cpu_flags;
extern char my_buf[];
extern unsigned char langMode;
extern unsigned char sourceName[];
extern char existTraceBoard, dspMode;

/**************************************************************************
**
** Name : DisplayCh()
**
** Function : display a character at the viewport 'VPOut'
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayCh(unsigned char Ch )
{

   JournalCh( Ch );
   DisplayCharAtViewport( Ch );

}  /*  of DisplayCh()  */

/**************************************************************************
**
** Name : DisplayCharAtViewportScreen()
**
** Function : display a character at the viewport 'VPOut'
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayCharAtViewport(unsigned char Ch )
{

   switch ( Ch ) {
     case   CR    :
       VP[VPOut].Ptr->c = 0;
       csr_plwn( VP[VPOut].Ptr );
       break;
     case   LF    :
       v_ch( LF, VP[VPOut].Ptr );
        if ( VP[VPOut].Ptr->r > VP[VPOut].Maxr ) {
            wn_scrl( 1, UP, VP[VPOut].Ptr );
            nBufFull = TRUE;    // Chen 06/09/94
        }
        else {
            nBufFull = FALSE;   // Chen 06/09/94
        }
       break;
     case   BS    :
     case   KEY_DEL  :
       if ( VP[VPOut].Ptr->c == 0 ) {
         if ( ( --( VP[VPOut].Ptr->r ) ) < 0 ) {
            ++( VP[VPOut].Ptr->r );
            break;
         }
         VP[VPOut].Ptr->c = VP[VPOut].Maxc;
         if ( VP[VPOut].Ptr->row_org > VP[VPOut].Ptr->r ) {
            wn_msadj( VP[VPOut].Ptr );
            wn_upd( VP[VPOut].Ptr );
         }
         v_ch( ' ', VP[VPOut].Ptr );
         --( VP[VPOut].Ptr->r );
         VP[VPOut].Ptr->c = VP[VPOut].Maxc;
       } else {
         --( VP[VPOut].Ptr->c );
         if ( VP[VPOut].Ptr->col_org > VP[VPOut].Ptr->c ) {
            wn_msadj( VP[VPOut].Ptr );
            wn_upd( VP[VPOut].Ptr );
         }
         v_ch( ' ', VP[VPOut].Ptr );
         --( VP[VPOut].Ptr->c );
       }
       csr_plwn( VP[VPOut].Ptr );
       break;
     default    :
       v_ch( Ch, VP[VPOut].Ptr );
       break;
   }  /*  of switch ( Ch )   */

}  /*  of DisplayCharAtViewport()  */

/**************************************************************************
**
** Name : DisplayStr( Str )
**
** Function : display a string at the viewport 'VPOut
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayStr( Str )
unsigned char  *Str;
{

   JournalStr( Str );
   DisplayStrAtViewport( Str );

}  /*  of DisplayStr()  */


/**************************************************************************
**
** Name : DisplayStrAtViewport( Str )
**
** Function : display a string at the viewport VPOut
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayStrAtViewport( unsigned char *Str )
{
char  *Tmp;


   while ( ( Tmp = strchr( Str, CR ) ) != NULL ) {
     *Tmp = '\0';
     v_st( Str, VP[VPOut].Ptr );
     VP[VPOut].Ptr->c = 0;
     csr_plwn( VP[VPOut].Ptr );
     *Tmp = CR;
     Str = Tmp + 1;
   }

   v_st( Str, VP[VPOut].Ptr );

    if ( VP[VPOut].Ptr->r > VP[VPOut].Maxr ) {
        wn_scrl( 1, UP, VP[VPOut].Ptr );
        nBufFull = TRUE;    // Chen 06/09/94
    }
    else {      // Chen 06/13/94
        nBufFull = FALSE;
    }

}  /*  of DisplayStrAtViewport()  */


/**************************************************************************
**
** Name : DisplayPosCh( Row, Col, Ch )
**
** Function : display a character at indicated position of the viewport
**           'VPOut'
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayPosCh( int Row, int Col, unsigned char Ch )
{
 char  Str[2];


 Str[0] = Ch;
 Str[1] = '\0';

 sw_opt( CLRENDROW, OFF, VP[VPOut].Ptr );

 v_stpl( ( Row + VP[VPOut].Ptr->row_org ), ( Col + VP[VPOut].Ptr->col_org ),
    Str, VP[VPOut].Ptr );

 sw_opt( CLRENDROW, ON, VP[VPOut].Ptr );

}  /*  of DisplayPosCh()  */

/**************************************************************************
**
** Name : DisplayPosStr( Row, Col, Str )
**
** Function : display a string at indicated position of the viewport 'VPOut'
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayPosStr( Row, Col, Str )
int   Row, Col;
unsigned char  *Str;
{

   sw_opt( CLRENDROW, OFF, VP[VPOut].Ptr );

   v_stpl( ( Row + VP[VPOut].Ptr->row_org ), ( Col + VP[VPOut].Ptr->col_org ),
    Str, VP[VPOut].Ptr );

   sw_opt( CLRENDROW, ON, VP[VPOut].Ptr );


}  /*  of DisplayPosStr()  */

/**************************************************************************
**
** Name :
**
** Function :  display command cursor '_'
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DisplayCMDCURSOR()
{
 csr_plwn( VP[COMVP].Ptr );

}  /*  of DisplayCMDCURSOR()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  erase command cursor '_'                      */

EraseCMDCURSOR()
{
}  /*  of EraseCMDCURSOR()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  mark the source line that current PC indicates             */

MarkPC( Bufy )
int  Bufy;
{
 if ( CurrentPC >= 0 )  /*  clear the original PC-indicated line  */

    v_chattrow( CurrentPC, CODVPINDENT-1,
      ' ', COLOR( VP[CODVP].TextColor, VP[CODVP].BackgrndColor ),
      ENDROW, ATT, VP[CODVP].Ptr );

 /*  update current PC 'CurrentPC'  */

 if ( ( CurrentPC = Bufy ) < 0 )  return;

 /*  mark the new PC-indicated line  */

/* CORE 90.08.014 */

#ifdef NEC_PC9801
 v_chattrow( CurrentPC, CODVPINDENT-1, ' ', LBLA_BLU, ENDROW, ATT,
             VP[CODVP].Ptr );
#else
 v_chattrow( CurrentPC, CODVPINDENT-1, ' ', COLOR( VP[CODVP].BackgrndColor,
             VP[CODVP].TextColor ), ENDROW, ATT, VP[CODVP].Ptr );
#endif

}  /*  of MarkPC()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  scroll the source line that current PC indicates to the top          */

NewPCPage( Topy )
int  Topy;
{
 char  Str[2];
 int   Oldc;

 /*  redraw the CODE viewport  */


 VP[CODVP].Ptr->c = 0;  /*  for scrolling  */
 v_ch( ' ', VP[CODVP].Ptr );
 sw_msorg( Topy, VP[CODVP].Ptr->col_org, VP[CODVP].Ptr );
 wn_upd( VP[CODVP].Ptr );

 /*  mark the source line that current PC indicates  */

 MarkPC( Topy );
 VP[CODVP].Ptr->r = Topy;  /*  for scrolling  */
 VP[CODVP].Ptr->c = 0;  /*  for scrolling  */
 v_ch( '\x10', VP[CODVP].Ptr );

}  /*  of NewPCPage()  */

/**************************************************************************
**
** Name : UpdateVP()
**
** Function : update the contents of viewports according to the flag
**            'RedrawFlag'
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UpdateVP()
{
 if ( wn_isup( VP[REGVP].Ptr ) && ( RedrawFlag & REDRAWREG ) &&
      ( ! ( MaskRedrawFlag & REDRAWREG ) ) )  UpdateREGVP();

 if ( wn_isup( VP[CODVP].Ptr ) && ( RedrawFlag & REDRAWCOD ) &&
      ( ! ( MaskRedrawFlag & REDRAWCOD ) ) )  UpdateCODVP(0);
 else  if ( RedrawFlag & REDRAWCOD )  GetPC(&PC);

 if ( wn_isup( VP[STAVP].Ptr ) && ( RedrawFlag & REDRAWSTA ) &&
      ( ! ( MaskRedrawFlag & REDRAWSTA ) ) )  UpdateSTAVP();

 if ( wn_isup( VP[BREVP].Ptr ) && ( RedrawFlag & REDRAWBRE ) &&
      ( ! ( MaskRedrawFlag & REDRAWBRE ) ) )  UpdateBREVP( 0 );

 if ( wn_isup( VP[TRAVP].Ptr ) && ( RedrawFlag & REDRAWTRA ) &&
      ( ! ( MaskRedrawFlag & REDRAWTRA ) ) )  UpdateTRAVP( 0 );

 if ( wn_isup( VP[DATVP].Ptr ) && ( RedrawFlag & REDRAWDAT ) &&
      ( ! ( MaskRedrawFlag & REDRAWDAT ) ) )  UpdateDATVP();

 RedrawFlag = 0L;

}  /*  of UpdateVP()  */

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  update the contents of the REGISTER viewport             */

UpdateREGVP()
{
static int  KnowRow = FALSE;  /*  indicate whether the rows needed to show
               registers are known              */
static int  LFCount;          /*  rows needed to show registers        */
static int  WarningMsg = 0;   /*  0 : no warning message,
               1 : has warning message           */
char        RowBuf[ REGBUFCOL + 1 ];
int        Bufx, i, Oldr, tmpVP;
extern int NECflag;

   tmpVP = VPOut;
   if (emuGetAllReg(cpuReg) != OK) {
/*  can't get REGISTER information  */
       WarningMsg = 1;
       VPOut = REGVP;
       DisplayPosStr( VP[REGVP].Height - 3, 0,
         " ( Warning! Cannot update REGISTER viewport. )" );
       DisplayPosStr( VP[REGVP].Height - 3, 46,
         "                                              " );
       VPOut = tmpVP;
       return;
   } else  if ( WarningMsg == 1 ) {
       WarningMsg = 0;
       VPOut = REGVP;
       DisplayPosStr( VP[REGVP].Height - 3, 0,
            "                                              " );
   }
   if ( ! KnowRow ) {  /*  count the rows needed to show registers  */
       KnowRow = TRUE;
       LFCount = i = 3;
   }
    // added by Chen, 07/22/94
    if ( NECflag == 1 ) {
        formatRegNEC(MICEBuf);
    }
//    else if ( MICE == I80286 ) {  // for 80286
//        formatReg286(MICEBuf);
//    }
    else {
        formatReg(MICEBuf);
    }
 /*  modify the display buffer of the REGISTER viewport  */
   sw_opt( WNECHO, OFF, VP[REGVP].Ptr );
   Oldr = VP[REGVP].Ptr->r;
   for (i=0, Bufx=0, VP[REGVP].Ptr->r=0; VP[REGVP].Ptr->r < LFCount;
      i++, Bufx = 0, VP[REGVP].Ptr->r++ ) {
      while ( MICEBuf[i] != LF ) {
         if ( MICEBuf[i] != CR ) {
            if ( Bufx < REGBUFCOL )  RowBuf[Bufx++] = MICEBuf[i];
         }
          i++;
       }
       for ( ; Bufx < REGBUFCOL; )  RowBuf[Bufx++] = ' ';
      v_stcpy( RowBuf, TO_WN, ROW, VP[REGVP].Ptr );
   }
 /*  redraw the REGISTER viewport  */
   sw_opt( WNECHO, ON, VP[REGVP].Ptr );
   if ( VP[REGVP].Ptr->row_org >= REGVPLine )
       sw_msorg( VP[REGVP].Ptr->r = 0, VP[REGVP].Ptr->col_org, VP[REGVP].Ptr );
   else  VP[REGVP].Ptr->r = Oldr;
   wn_upd( VP[REGVP].Ptr );
   VPOut = tmpVP;
}  /*  of UpdateREGVP()  */

/**************************************************************************
**
** Name : UpdateCODVP(flag)
**
** Function : update the contents of the CODE viewport
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UpdateCODVP(int flag)
{
static int  WarningMsg = 0;   /*  0 : no warning message,
                                  1 : has warning message  */
static int  need_reset = TRUE;
char *RowBuf, att;
int  Bufx, i, tmpVP;
unsigned long addr, oldAddr= 0xFFFFFFFF, absPC, abs;

extern int nFillFlag;       // Chen 06/03/94
extern int nMaxToMin;       // Chen 06/29/94
int nMarkPC = FALSE;        // Chen 07/01/94


   if (flag == -1) {
      need_reset = TRUE;
   }
   if (!wn_isup(VP[CODVP].Ptr))  return;
   if ( flag != CODVP_PREV && flag != CODVP_NEXT && flag != CODVP_PGUP &&
        flag != CODVP_PGDN && flag != CODVP_BOTTOM &&
        (MaskRedrawFlag & REDRAWCOD) )
      return;
   if ( flag==0 && need_reset && nFillFlag==FALSE ) {     // Chen 06/03/94
      flag = -1;
      need_reset = FALSE;
   }
   // added by Chen 06/29/04
   // After pressing Alt_F7 to minimum COM viewport, view to current PC
   if ( flag==0 && nMaxToMin==TRUE ) {
      flag = -1;
      need_reset = TRUE;
      nMaxToMin = FALSE;
   }

   /*  set data that will be displayed in CODE viewport to CODBuf[]  */
   tmpVP = VPOut;
   if (SetCodeVPData( flag ) == FAIL) {   /*  can't get CODE information  */
      WarningMsg = 1;
      VPOut = CODVP;
      DisplayPosStr( VP[CODVP].Height - 3, 0,
         " ( Warning! Cannot update CODE viewport. )" );
      DisplayPosStr( VP[CODVP].Height - 3, 42,
         "                                          " );
      VPOut = tmpVP;
      return;
   } else  if ( WarningMsg == 1 ) {
      WarningMsg = 0;
      VPOut = CODVP;
      DisplayPosStr( VP[CODVP].Height - 3, 0,
         "                                          " );
   }
   if ((RowBuf = malloc( CODBUFCOL + 1 )) == NULL) {
      VPOut = tmpVP;
      return;
   }
   strcpy( RowBuf, langMode == 1 ? "SOURCE" : ( langMode == 2 ? "MIXED" :
                                  "ASSEMBLY" ));
   if (dspMode) sprintf( bdrBuf, " %s \xCD\xCD %s ", RowBuf, sourceName );
   else sprintf( bdrBuf, " %s ", RowBuf );
   VP[CODVP].Ptr->title = bdrBuf;
   v_titleatt( bdrBuf, 0, VP[CODVP].Ptr );

   /*  clear the original PC-indicated line  */
   if ( CurrentPC >= 0 )  MarkPC( -1 );
   /*  erase display buffer of CODE viewport  */
   sw_opt( WNECHO, OFF, VP[CODVP].Ptr );
   ms_clr( VP[CODVP].Buf );

   /*  modify display buffer of CODE viewport  */
   for ( i = 0, VP[CODVP].Ptr->r = 0; VP[CODVP].Ptr->r < CodeVPRange.LFcount; i++, VP[CODVP].Ptr->r++ ) {
      Bufx = (CODBuf[i]== '<' || dspMode == HIGH) ? CODVPINDENT-1 : CODVPINDENT;
      memset( RowBuf, ' ', CODVPINDENT );
      while ( (CODBuf[i] != LF) && (CODBuf[i] != '\0') ) {
         if ( CODBuf[i] != CR )
            if ( Bufx < CODBUFCOL )  RowBuf[Bufx++] = CODBuf[i];
         i++;
      }
      memset( &RowBuf[Bufx], ' ', CODBUFCOL - Bufx );
      v_stcpy( RowBuf, TO_WN, ROW, VP[CODVP].Ptr );
      if ( CODBuf[i] == '\0' )  break;
   }
   SetBKPTinCodeVP();

   /*  redraw the CODE viewport  */
   sw_opt( WNECHO, ON, VP[CODVP].Ptr );
// sw_msorg( 0, VP[CODVP].Ptr->col_org, VP[CODVP].Ptr );
   wn_upd( VP[CODVP].Ptr );
   GetCodeVPRange( ALL );

   /*  mark the source line that current PC indicates  */
   emuGetReg( I86_REG, REG_PC, &addr );
   absPC = ADDR2ABS( addr );
/*
   for ( i = 0; i < CodeVPRange.LFcount; i++ ) {
      if ( (Bufx=GetAddrInCODVP(i, &addr)) == 1 || Bufx == 3 || Bufx == 6 ) {
         abs = ADDR2ABS( addr );
         if (Bufx != 3 && abs == absPC ) {
            MarkPC(i);
            break;
         }
         else if ( absPC > oldAddr && absPC < abs ) {
            MarkPC(i-1);
            break;
         }
         oldAddr = abs;
      }
   }
*/
    // changed by Chen, 07/01/94
    for ( i = 0; i < CodeVPRange.LFcount; i++ ) {
        if ( (Bufx=GetAddrInCODVP(i,&addr)) == 1 || Bufx == 6 ) {
            abs = ADDR2ABS( addr );
            if ( abs == absPC ) {
                MarkPC(i);
                nMarkPC = TRUE;
                break;
            }
        }
    }
    if ( nMarkPC == FALSE ) {
        for ( i = 0; i < CodeVPRange.LFcount; i++ ) {
            if ( (Bufx=GetAddrInCODVP(i,&addr))==1 || Bufx==3 || Bufx==6 ) {
                abs = ADDR2ABS( addr );
                if ( absPC > oldAddr && absPC < abs ) {
                    MarkPC(i-1);
                    break;
                }
                oldAddr = abs;
            }
        }
    }

   /*  for scrolling in the code viewport  */
   VP[CODVP].Ptr->r = 0;
   VP[CODVP].Ptr->c = 0;
   if (flag <= 0 || flag == CODVP_VIEW) {
      VP[CODVP].Ptr->r = VP[CODVP].Ptr->row_org;
      while (GetAddrInCODVP( VP[CODVP].Ptr->r, &addr ) == 2 &&
         VP[CODVP].Ptr->r < VP[CODVP].Maxr ) VP[CODVP].Ptr->r++;
      v_ch( '\x10', VP[CODVP].Ptr );
   }
   free(RowBuf);
   VPOut = tmpVP;
}  /*  of UpdateCODVP()  */

/**************************************************************************
**
** Name :
**
** Function : update the contents of the STACK viewport
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

UpdateSTAVP()
{
static int  WarningMsg = 0;  /*  0 : no warning message,
              1 : has warning message  */
char Addr[30], Data[10];
char RowBuf[ STABUFCOL + 1 ];
int Len, i, tmpVP;
char c, *ptr;
unsigned long l;

 /*  get the value of the stack pointer  */
   tmpVP = VPOut;
   emuGetReg(I86_REG, REG_SP, &l);
   if (GetMemWrap(l, my_buf,256) != OK) {  /*  can't get the STACK information  */
      WarningMsg = 1;
      VPOut = STAVP;
      DisplayPosStr( VP[STAVP].Height - 3, 0,
             " ( Warning! Cannot update STACK viewport. )" );
      DisplayPosStr( VP[STAVP].Height - 3, 43,
             "                                           " );
      VPOut = tmpVP;
      return;
   }
    if ( WarningMsg == 1 ) {
       WarningMsg = 0;
       VPOut = STAVP;
       DisplayPosStr( VP[STAVP].Height - 3, 0,
         "                                           " );
   }
 /*  modify the display buffer of the STACK viewport  */
   sw_opt( WNECHO, OFF, VP[STAVP].Ptr );
   for ( i = 0; i < STABUFCOL; i++ )  RowBuf[i] = ' ';
   adr2str(l,&Addr[0]);
   Addr[9] = EQUAL;
   Addr[10] = '\0';
   hex2asc(&Data[0], my_buf[1]);
   hex2asc(&Data[2], my_buf[0]);
   Data[4]=NULL;
   strcpy( RowBuf, "SP->" );
   strcat( RowBuf, Addr );
   strcat( RowBuf, Data );
 /*  change '\0' to be SP  */
   RowBuf[18] = SP;
   VP[STAVP].Ptr->r = VP[STAVP].Maxr;
    v_stcpy( RowBuf, TO_WN, ROW, VP[STAVP].Ptr );
   for (VP[STAVP].Ptr->r=VP[STAVP].Maxr-1, i=2;
      VP[STAVP].Ptr->r > VP[STAVP].Maxr - StaBufRow; VP[STAVP].Ptr->r--) {
      AdvanceAddrWrap(&l, 2);
      adr2str(l,&Addr[0]);
      Addr[9] = EQUAL;
      Addr[10] = NULL;
      hex2asc(&Data[0], my_buf[i+1]);
      hex2asc(&Data[2], my_buf[i]);
      Data[4]=NULL;
      strcpy( RowBuf, "    " );
      strcat( RowBuf, Addr );
      strcat( RowBuf, Data );
 /*  change '\0' to be SP  */
      RowBuf[18] = SP;
      v_stcpy( RowBuf, TO_WN, ROW, VP[STAVP].Ptr );
      i += 2;
   }
 /*  redraw the STACK viewport  */
   sw_opt( WNECHO, ON, VP[STAVP].Ptr );
// sw_msorg( ( VP[STAVP].Ptr->r = VP[STAVP].Maxr ) - VP[STAVP].Height + 3, VP[STAVP].Ptr->col_org, VP[STAVP].Ptr );
   wn_upd( VP[STAVP].Ptr );
   VPOut = tmpVP;
}  /*  of UpdateSTAVP()  */

/**************************************************************************
**
** Name : UpdateBREVP( PageFlag )
**
** Function : update the contents of the BREAKPOINT viewport
**
**     Input  :    ( PageFlag )    0         : current page,
**                         BREVP_PREV : previous page,
**                         BREVP_NEXT : next page
**
**    Output :
**
** Notes:
**
**************************************************************************/

UpdateBREVP( int PageFlag )
{
static int CurrentPage = 0;  /*  indicate the page that is displayed
                                 at the BREAKPOINT viewport currently  */
char RowBuf[ BREBUFCOL + 1 ], temp[80];
int  Oldr, i, len;
unsigned long addr;

   v_titleatt( " BREAKPOINT ", 0, VP[BREVP].Ptr );

   /*  get page# that will be displayed at the BREAKPOINT viewport  */
   switch ( PageFlag ) {
   case 0:
      if ( ( ( CurrentPage * (2*BREBUFROW) + 1 ) > BreakNumber ) ||
          ( ( (CurrentPage+1) * (2*BREBUFROW) ) < BreakNumber ) ) {
         if ( BreakNumber <= (2*BREBUFROW) )  CurrentPage = 0;
         else  CurrentPage = ( BreakNumber - 1 ) / (2*BREBUFROW);
         sw_msorg( VP[BREVP].Ptr->r = 0, VP[BREVP].Ptr->col_org, VP[BREVP].Ptr );
      }
      break;
   case BREVP_PREV:
      if ( CurrentPage == 0 ) {
         v_titleatt( NULLP, 0, VP[BREVP].Ptr );
         return( 0 );
      } else {
         CurrentPage--;
         sw_msorg( VP[BREVP].Ptr->r = 0, VP[BREVP].Ptr->col_org, VP[BREVP].Ptr );
      }
      break;
   case BREVP_NEXT:
      if ( ( (CurrentPage+1) * (2*BREBUFROW) + 1 ) > BreakNumber ) {
         v_titleatt( NULLP, 0, VP[BREVP].Ptr );
         return( 0 );
      } else {
         CurrentPage++;
         sw_msorg( VP[BREVP].Ptr->r = 0, VP[BREVP].Ptr->col_org, VP[BREVP].Ptr );
      }
      break;
   default:
      v_titleatt( NULLP, 0, VP[BREVP].Ptr );
      return( 0 );
   }

   /*  erase the display buffer of the BREAKPOINT viewport  */
   sw_opt( WNECHO, OFF, VP[BREVP].Ptr );
   ms_clr( VP[BREVP].Buf );

   /*  modify the display buffer of the BREAKPOINT viewport  */
   Oldr = VP[BREVP].Ptr->r;
   VP[BREVP].Ptr->r = 0;
   RowBuf[0] = '\0';
   for (i = (CurrentPage*(2*BREBUFROW)); i < BreakNumber; i++) {
      if (SwBreak[i].sym[0] != '\0')
//     && asmSym2Addr(SwBreak[i].sym, &addr) && addr == SwBreak[i].address)
         sprintf(temp," %3X. %s  count=%X", i+1,
                 SwBreak[i].sym, SwBreak[i].count);
      else
         sprintf(temp," %3X. %04lX:%04lX  count=%X", i+1,
                (SwBreak[i].address & 0xFFFF0000L) >> 16,
                 SwBreak[i].address & 0x0000FFFFL, SwBreak[i].count);
      if (strlen(temp) <= 38) {
         len = strlen(temp);
         memset(&temp[len], ' ', 38 - len);
         temp[38] = '\0';
      }
      else {   // output is too long
         if (RowBuf[0] != '\0') {
            len = strlen(RowBuf);
            memset(&RowBuf[len], ' ', BREBUFCOL - len);
            v_stcpy( RowBuf, TO_WN, ROW, VP[BREVP].Ptr );
            ++(VP[BREVP].Ptr->r);
         }
         strcpy(RowBuf, temp);
         temp[0] = '\0';
      }
      if (RowBuf[0] != '\0' || i == BreakNumber-1) {
         strcat(RowBuf, temp);
         /*  copy RowBuf to display buffer of BREAKPOINT viewport  */
         len = strlen(RowBuf);
         memset(&RowBuf[len], ' ', BREBUFCOL - len);
         v_stcpy( RowBuf, TO_WN, ROW, VP[BREVP].Ptr );
         ++(VP[BREVP].Ptr->r);
         RowBuf[0] = '\0';
      }
      else  strcpy(RowBuf, temp);
      if (VP[BREVP].Ptr->r >= BREBUFROW)  break;
   }  /* end of for */

   /*  redraw the BREAKPOINT viewport  */
   sw_opt( WNECHO, ON, VP[BREVP].Ptr );
   VP[BREVP].Ptr->r = Oldr;
   wn_upd( VP[BREVP].Ptr );
   v_titleatt( NULLP, 0, VP[BREVP].Ptr );
   return ( 1 );
}  /*  of UpdateBREVP()  */

/**************************************************************************
**
** Name :
**
** Function :  update the contents of the TRACE viewport
**
**    Input  :
**
**    Output :
**
** Notes:   changed for MICE-III, by Frank, on 5/18/1994
**          change the source of MICEBuf by execute emuGetMICEBuf()
**
**************************************************************************/
UpdateTRAVP( flag )
int  flag;                 /* -1         : start frame,
                               0         : refresh,
                              TRAVP_PREV : previous page,
                              TRAVP_NEXT : next page        */
{
 static int  WarningMsg = 0;  /*  0 : no warning message,
              1 : has warning message       */
 static int  need_reset = TRUE;
 char        RowBuf[ TRABUFCOL + 1 ];
 int        Bufx, i, tmpVP;
 U8     dummy;

 if (!existTraceBoard || emuGetCpuStatus(&dummy) == CPU_FLY) return;
 if (flag == -1)  need_reset = TRUE;
 if (!wn_isup(VP[TRAVP].Ptr))  return;
 if ( flag != TRAVP_PREV && flag != TRAVP_NEXT &&
     (MaskRedrawFlag & REDRAWTRA) )
    return;
 if (flag == 0 && need_reset) {
    flag = -1;
    need_reset = FALSE;
 }

  tmpVP = VPOut;
  emuGetMICEBuf();
  VPOut = TRAVP;
//  set the data that will be displayed at the TRACE viewport to MICEBuf[]
// if ( SetTraceVPData(flag)==FAIL ) { //  can't get the TRACE information
//    WarningMsg = 1;
//    VPOut = TRAVP;
//    DisplayPosStr( VP[TRAVP].Height - 3, 0,
//         " ( Warning! Cannot update TRACE viewport. )" );
//    DisplayPosStr( VP[TRAVP].Height - 3, 43,
//         "                                           " );
//    VPOut = tmpVP;
//    return;
// } else  if ( WarningMsg == 1 ) {
//       WarningMsg = 0;
//       VPOut = TRAVP;
//       DisplayPosStr( VP[TRAVP].Height - 3, 0,
//            "                                           " );
//    }

 if ( ( flag != 0 ) && ( MICEBuf[0] == '\0' ) ) {
    v_titleatt( NULLP, 0, VP[TRAVP].Ptr );
    VPOut = tmpVP;
    return;
 }

 /*  erase the display buffer of the TRACE viewport  */

 sw_opt( WNECHO, OFF, VP[TRAVP].Ptr );

 ms_clr( VP[TRAVP].Buf );

 /*  modify the display buffer of the TRACE viewport  */
 for ( i = 0,  Bufx = 0, VP[TRAVP].Ptr->r = 0; VP[TRAVP].Ptr->r < TRABUFROW;
       i++, Bufx = 0, VP[TRAVP].Ptr->r++ ) {

     while ( ( MICEBuf[i] != LF ) && ( MICEBuf[i] != '\0' ) ) {

       if ( MICEBuf[i] != CR )
     if ( Bufx < TRABUFCOL )  RowBuf[Bufx++] = MICEBuf[i];

       i++;
     }

     for ( ; Bufx < TRABUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[TRAVP].Ptr );

     if ( MICEBuf[i] == '\0' )  break;
 }

 /*  redraw the TRACE viewport  */

 sw_opt( WNECHO, ON, VP[TRAVP].Ptr );
// sw_msorg( VP[TRAVP].Ptr->r = 0, VP[TRAVP].Ptr->col_org, VP[TRAVP].Ptr );
 wn_upd( VP[TRAVP].Ptr );

 v_titleatt( NULLP, 0, VP[TRAVP].Ptr );
 VPOut = tmpVP;
}  /*  of UpdateTRAVP()  */


/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
/*  update the contents of the DATA viewport                */
UpdateDATVP()
{
char RowBuf[81], temp[100], sym[41], addrStr[14];
unsigned char *ptr;
int  count=1, len, num;
int  Oldr, i, j, k;
unsigned int type;
unsigned long addr, curPC, curFP;
unsigned long getCSIPStr();
EXTERN TYPE_INFO typeInfo;
EXTERN ARRAY_INFO arrInfo;
EXTERN STRUCT_INFO struInfo;
BLOCK_INFO blkInfo;

/*** Erase the display buffer of the DATA viewport ***/
   sw_opt(WNECHO, OFF, VP[DATVP].Ptr);
   ms_clr(VP[DATVP].Buf);
   MonVPfull = 0;

/*** Modify the display buffer of the DATA viewport ***/
   Oldr = VP[DATVP].Ptr->r;
   emuGetReg( I86_REG, REG_PC, &curPC );
   emuGetReg( I86_REG, REG_FP, &curFP );
   for (VP[DATVP].Ptr->r=0, i = 0; !MonVPfull && i < MonVarCount; i++) {
   /* Fill number and symbol/address */
      addr = getCSIPStr(&MonVar[i].Addr[0]);
      type = MonVar[i].Type;
      strcpy( addrStr, MonVar[i].Addr );
      memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
      memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
      memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
      if (MonVar[i].Sym[0] != '\0' && type && GetTypeInfo(type) == OK) {
         if (typeInfo.scope) for (k=0; k < typeInfo.scope; k++) temp[k] = '*';
         temp[typeInfo.scope] = NULL;
         if (typeInfo.type != ARRAY)
//            sprintf( RowBuf,"%2X.%s %s%s", i+1, typeArr[typeInfo.type],
//                            temp, MonVar[i].Sym );
// Chen
            // 06/16/1994 James Wang
//          sprintf( RowBuf,"%2X.%s %%%s%s", i+1, typeArr[typeInfo.type],
//                          temp, MonVar[i].Sym );
            {
            if (typeInfo.type == UNION)
            sprintf( RowBuf,"%2X.%s %%%s%s", i+1, "union",
                            temp, MonVar[i].Sym );
            else
            sprintf( RowBuf,"%2X.%s %%%s%s", i+1, typeArr[typeInfo.type],
                            temp, MonVar[i].Sym );
            }
         else {
            memset( sym, NULL, sizeof(sym) );
            for (k=0; k < arrInfo.dim; k++)
            {
               // 06/08/1994 James Wang  : process pointer to array
               if (typeInfo.scope) arrInfo.size[k] /= 4;
               // 06/09/1994 James Wang  : process float with array
               if (arrInfo.subType == SINGLE && ( k == arrInfo.dim-1) )
                  arrInfo.size[k] /= 32;
               if (arrInfo.subType == DOUBLE && ( k == arrInfo.dim-1) )
                  arrInfo.size[k] /= 64;
               sprintf(sym, "%s[%d]", sym, arrInfo.size[k]);
            }
//            sprintf( RowBuf,"%2X.%s %s%s%s", i+1, typeArr[arrInfo.subType],
//                            temp, MonVar[i].Sym, sym );
// Chen
            sprintf( RowBuf,"%2X.%s %%%s%s%s", i+1, typeArr[arrInfo.subType],
                            temp, MonVar[i].Sym, sym );
         }
         if (MonVar[i].isLocal == 2) {
            addr = curFP + (S32)addr;
            sprintf(addrStr, "%04X:%04X", (U16)(addr>>16), (U16)addr);
         }
// Chen
//         if (MonVar[i].isLocal && GetSymByAddr(0,MonVar[i].blkAddr,sym,&k) ==OK) {
//            sprintf( temp, "(%s)", sym );
//            strcat( RowBuf, temp );
//         }
        if ( MonVar[i].isLocal ) {
            GetSymByAddr(0,MonVar[i].blkAddr,sym,&k);
            sprintf( temp, "(%s)", sym );
            strcat( RowBuf, temp );
        }

// 05/30/1994 James Wang : GetSymByAddr() destroy type, arr, stru data structure.
      memset( &typeInfo , NULL, sizeof( TYPE_INFO ));
      memset( &arrInfo , NULL, sizeof( ARRAY_INFO ));
      memset( &struInfo , NULL, sizeof( STRUCT_INFO ));
      GetTypeInfo(type);

            // 06/08/1994 James Wang  : process pointer to array
            for (k=0; k < arrInfo.dim; k++) {
               if (typeInfo.scope) arrInfo.size[k] /= 4;
            // 06/09/1994 James Wang  : process float with array
            if (arrInfo.subType == SINGLE && (k == arrInfo.dim-1) )
               arrInfo.size[k] /= 32;
            if (arrInfo.subType == DOUBLE && (k == arrInfo.dim-1) )
               arrInfo.size[k] /= 64;
         }

         k = strlen(RowBuf);
         if (k < DATBUFCOL) memset(RowBuf + k, ' ', DATBUFCOL - k);
         v_stcpy(RowBuf, TO_WN, ROW, VP[DATVP].Ptr);
         (VP[DATVP].Ptr->r)++;
         j=0;
         if ( MonVar[i].isLocal && (((k=GetBlockInfo(curPC, &blkInfo, &addr)) !=
              OK) || (k == OK && blkInfo.startAddr != MonVar[i].blkAddr))) {
            strcpy(RowBuf, "   < not alive >");
            j=1;
         }
/*       else if ( GetContentStr( TRUE, FALSE, addr,typeInfo.type,typeInfo.len,
                   temp)==OK){
            sprintf(RowBuf," %s=%s", addrStr, temp);
            j=1;
         }  */    // Marked by James Wang 06/01/1994
// added by Jmaes Wang 06/01/1994
         else {
            U8  arr[8], ptr[10];
            U32 u32;
            if (typeInfo.scope) {
               for (k=0; k < typeInfo.scope; k++) {
                  ptr[k] = '*';
                  if ( typeInfo.type == ARRAY ) // 06/14/1994 James Wang
                     continue;
                  len = typeInfo.ptrLen[k]/8;
                  if ((len != sizeof(U32) && len != sizeof(U16)) ||
                     emuGetMemN( addr, arr, len) != OK) return(FAIL);
                     if (len < sizeof(U32)) {
                        emuGetReg(I86_REG, DS, &u32);
                        addr =  ((u32&0x0FFFFL) << 16) + *(U16 *)&arr[0];
                     }
                     else addr = *(U32 *)&arr[0];
                     if (!addr) break;
               }
               if (!addr) {
                  sprintf( RowBuf, "   [%04X?%04X]", (U16)(addr>>16),(U16)addr);
                  j = 1;
               }
               else {
            if ( GetContentStr( FALSE, FALSE, addr,typeInfo.type,typeInfo.len,
                   temp)==OK) {
            sprintf(RowBuf,"   [%04X:%04X]=%s", (U16)(addr>>16), (U16)addr, temp);
                   j = 1;
                  }
               }
            sprintf(addrStr, "%04X:%04X", (U16)(addr>>16), (U16)addr);
            }
            else
            if ( GetContentStr( TRUE, FALSE, addr,typeInfo.type,typeInfo.len,
                   temp)==OK) {
            sprintf(RowBuf,"   [%04X:%04X]=%s", (U16)(addr>>16), (U16)addr, temp);
            j = 1;
            }
         }

         if (j) {
            k = strlen(RowBuf);
            memset(RowBuf + k, ' ', DATBUFCOL - k);
            v_stcpy( RowBuf, TO_WN, ROW, VP[DATVP].Ptr );
            if (++(VP[DATVP].Ptr->r) >= DATBUFROW) {
               MonVPfull = 1;
               break;
            }
            continue;
         }
         sprintf(RowBuf,"   %s=", addrStr);
         if (typeInfo.type == ARRAY) {
            count = 1;
            for (j=0; j < arrInfo.dim; j++) count *= arrInfo.size[j];
            if (typeInfo.scope) len=4; else  // 06/14/1994 James
            if ((k=arrInfo.subType) == SINT || k== UNINT) len=2;
            else if (k == SLONG || k== UNLONG || k== SINGLE) len=4;
            else if (k == DOUBLE) len = 8;
            else if (k == LDOUBLE) len = 10;
            else {
              len = 1;
              count *= (typeInfo.len/8);
            }
            if (count > 256) count = 256;
         }
         else {
            count = (typeInfo.len/8) > 256 ? 256 : typeInfo.len/8 ;
            len = 1;
         }
         for (k=0; k < struInfo.itemCnt; k++)
            if (struInfo.itemName[k]) free(struInfo.itemName[k]);
      }
      else {
         sprintf(RowBuf,"%2X.%s=", i+1, addrStr);
         count = MonVar[i].Count;
         type  = MonVar[i].Format;
         if (type == 0) len = 1;
         else if (type == 1) len = 2;
         else len = 4;
         if (len * count > 256)  count = 256 / len;   // char my_buf[256]
      }
   /* Fill data */
      emuGetMemN(addr, my_buf, len * count);
      ptr = my_buf;
      num = 4/len;   // max number of data listed in one line
      if ( len == 8 ) num = 8/len; // 06/09/1994 James Wang
      while (count) {
         if (num > count) num = count;
         count -= num;
         AdvanceAddr(&addr, num * len);
         for (j = 0; j < num; j++, ptr += len) {
            if (len == 1)
               sprintf(DataBuf,"%02X", (int)*ptr);
            else if (len == 2)
               sprintf(DataBuf,"%04X", *(int *)ptr);
            else
               if ( len == 4 )  // 06/13/1994 James
               sprintf(DataBuf,"%08lX", *(long *)ptr);
            else  // 06/13/1994 James
               sprintf(DataBuf,"%08lX%08lX", *(long *)(ptr+4), *(long *)ptr );
            strcat(RowBuf, DataBuf);
            if (j != num-1)  strcat(RowBuf, " ");
         }
         k = strlen(RowBuf);
         memset(RowBuf + k, ' ', DATBUFCOL - k);
         v_stcpy( RowBuf, TO_WN, ROW, VP[DATVP].Ptr );
         if (++(VP[DATVP].Ptr->r) >= DATBUFROW) {
            MonVPfull = 1;
            break;
         }
         if (count)
            sprintf(RowBuf,"   %04lX:%04lX=", addr >> 16,addr & 0x0000FFFF);
      }  /* end of while */
   }  /*  end of for ( i = 0, VP[DATVP].Ptr->r = 0; ... )  */

/*** Redraw the DATA viewport ***/
   sw_opt(WNECHO, ON, VP[DATVP].Ptr);
// sw_msorg(0, VP[DATVP].Ptr->col_org, VP[DATVP].Ptr);
   VP[DATVP].Ptr->r = Oldr;
   wn_upd(VP[DATVP].Ptr);
   v_titleatt(NULLP, 0, VP[DATVP].Ptr);
}  /*  of UpdateDATVP()  */


/****************************************************************************
**
** Name     : formatReg()
**
** Function : Format 8086 CPU Registers
**
**   Input  :
**
**   Output :
**
** Notes    :
**
****************************************************************************/
formatReg(char *Buffer)
{
char *REG_line1=" AX=%04X  BX=%04X  CX=%04X  DX=%04X  SP=%04X  BP=%04X  SI=%04X  DI=%04X\r\n";
char *REG_line2=" DS=%04X  SS=%04X  ES=%04X  CS=%04X  IP=%04X  FS=%04X  ----ODITSZ-A-P-C\r\n";
char *REG_line3=" PC=%05lX                                              %s\r\n";
char *B;
char flagStr[17];
int i;
unsigned long addr;
   B = Buffer;
   sprintf(B,REG_line1,cpu_regs[AX],cpu_regs[BX],cpu_regs[CX],cpu_regs[DX],
        cpu_regs[RSP],cpu_regs[BP],cpu_regs[SI],cpu_regs[DI]);
   B += 73;
    sprintf(B,REG_line2,cpu_regs[DS],cpu_regs[SS],cpu_regs[ES], cpu_regs[CS],
      cpu_regs[IP], cpu_regs[FLAGS]);
   B += 73;
   for (i=15;i>=0;i--)
      if ((cpu_regs[FLAGS]>>i) & 1) flagStr[15-i]='1'; else flagStr[15-i]='0';
   flagStr[16]=0;
   addr = cpu_regs[CS];
   addr = (addr << 4) + cpu_regs[IP];
   sprintf(B, REG_line3, addr&0xfffff, flagStr);
}   // end of formatReg()


/****************************************************************************
**
** Name     : formatRegNEC(Buffer)
**
** Function : Format NEC V20, V30 Registers
**
**   Input  :
**
**   Output :
**
** Notes    : added by Chen, 07/22/94
**
****************************************************************************/
formatRegNEC(char *Buffer)
{
char *REG_line1=" AW=%04X  BW=%04X  CW=%04X  DW=%04X  SP=%04X  BP=%04X  IX=%04X  IY=%04X\r\n";
char *REG_line2="DS0=%04X  SS=%04X DS1=%04X  PS=%04X  PC=%04X PSW=%04X  M---VDIBSZ-A-P-C\r\n";
char *REG_line3=" IP=%05lX                                              %s\r\n";
char *B;
char flagStr[17];
int i;
unsigned long addr;
   B = Buffer;
   sprintf(B,REG_line1,cpu_regs[AX],cpu_regs[BX],cpu_regs[CX],cpu_regs[DX],
        cpu_regs[RSP],cpu_regs[BP],cpu_regs[SI],cpu_regs[DI]);
   B += 73;
    sprintf(B,REG_line2,cpu_regs[DS],cpu_regs[SS],cpu_regs[ES], cpu_regs[CS],
      cpu_regs[IP], cpu_regs[FLAGS]);
   B += 73;
   for (i=15;i>=0;i--)
      if ((cpu_regs[FLAGS]>>i) & 1) flagStr[15-i]='1'; else flagStr[15-i]='0';
   flagStr[16]=0;
   addr = cpu_regs[CS];
   addr = (addr << 4) + cpu_regs[IP];
   sprintf(B, REG_line3, addr&0xfffff, flagStr);
}   // end of formatRegNEC()



/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
unsigned long getCSIPStr(asc_buf)
unsigned char *asc_buf;
{
int ii;
unsigned long l, ll;
unsigned char *ptr, c;

   l = 0;
   ptr = asc_buf;
   if (strstr((unsigned char *)asc_buf, ":") != NULL) {
      for (ii=0;ii < 4; ii++) {
         c = *ptr++;
   if (c == ':') break;
         l *= 16;
         l += asc__h(c);
      }
   } else emuGetReg(I86_REG, DS, &l);
   ll = 0;
   c = *ptr++;    /* skip the ":" */
   if (c != ':') *ptr--;
   for (ii=0;ii < 4; ii++) {
      c = *ptr++;
      if (c == NULL) break;
      ll *= 16;
      ll += asc__h(c);
   }
   l = (l << 16) + ll;
   return(l);
}

/**************************************************************************
**
** Name :
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
PRIVATE AdvanceAddrWrap(U32 *addr, int len)
{
long segment, offset;

   segment = *addr & 0xFFFF0000;
   offset = (*addr & 0x0000FFFF) + len;
   *addr = segment + (offset & 0x0000FFFF);
   return;
}

/****************************************************************************
**
** Name     :
**
** Function :
**
**    Input :
**
**   Output :
**
** Notes    :    Coded by Chen Jun
**
****************************************************************************/
void ShowCPUType( void )
{
WINDOWPTR cpuMsg;
extern int MICE;    // indicate CPU type, relate to CPU_MODULE in abidef.h

    csr_hide();
    cpuMsg = wn_def( 0, 0, 1, 7, LWHI_RED, BDR_NULLP );
    wn_up( cpuMsg );
    switch ( MICE ) {
        case 0 :    // no CPU module definition
            break;
        case 1 :
            v_st( " 80188", cpuMsg );
            break;
        case 2 :
            v_st( " 188EA", cpuMsg );
            break;
        case 3 :
            v_st( " 188EB", cpuMsg );
            break;
        case 4 :
            v_st( " 188EC", cpuMsg );
            break;
        case 5 :
            v_st( " 80186", cpuMsg );
            break;
        case 6 :
            v_st( " 186EA", cpuMsg );
            break;
        case 7 :
            v_st( " 186EB", cpuMsg );
            break;
        case 8 :
            v_st( " 186EC", cpuMsg );
            break;
        case 9 :
            v_st( "8088MAX", cpuMsg );
            break;
        case 10 :
            v_st( "8088MIN", cpuMsg );
            break;
        case 11 :
            v_st( "8086MAX", cpuMsg );
            break;
        case 12 :
            v_st( "8086MIN", cpuMsg );
            break;
        case 13 :
            v_st( " V20MAX", cpuMsg );
            break;
        case 14 :
            v_st( " V20MIN", cpuMsg );
            break;
        case 15 :
            v_st( " V30MAX", cpuMsg );
            break;
        case 16 :
            v_st( " V30MIN", cpuMsg );
            break;
        case 17 :
            v_st( " 80286", cpuMsg );
            break;
        default :
            break;      // for maitain
    }

}       // end of ShowCPUType()



/****************************************************************************
**
** Name     :
**
** Function :
**
**    Input :   nTurnCnt -- global, 0: '-'; 1: '\': 2: '|'; 3: '/'
**
**   Output :   none
**
** Notes    :   Coded by Chen Jun, 07/11/94
**
****************************************************************************/
int nTurnCnt = 0;
void DisplayTurn( void )
{
int nRow, nCol;

    // locate the cursor at (nRow, 0)
    csr_plwn(VP[COMVP].Ptr);
    save_curs(&nRow, &nCol);
    set_cur(nRow, 0);

    // hide the current cursor
    csr_hide();

    // show the indicator according to "nTurnCnt"
    switch ( nTurnCnt ) {
        case 0 :
            DisplayStr("-");
            nTurnCnt++;
            break;
        case 1 :
            DisplayStr("\\");
            nTurnCnt++;
            break;
        case 2 :
            DisplayStr("|");
            nTurnCnt++;
            break;
        case 3 :
            DisplayStr("/");
            nTurnCnt = 0;
            break;
        default :
            break;
    }

    // retrieve the cursor and show it
    csr_show();
    set_cur(nRow, 0);

}   // end of DisplayTurn()



/****************************************************************************
**
** Name     :
**
** Function :
**
**    Input :   none
**
**   Output :   none
**
** Notes    :   Coded by Chen Jun, 07/11/94
**
****************************************************************************/
void EraseTurn( void )
{
int nRow, nCol;

    // locate the cursor at (nRow, 0)
    csr_plwn(VP[COMVP].Ptr);
    save_curs(&nRow, &nCol);
    set_cur(nRow, 0);

    // erase the indicator
    DisplayStr(" ");

    // retrieve the cursor and show it
    set_cur(nRow, 0);

}   // end of EraseTurn()


/**************************** End of File **********************************/


