/***************************************************************************
**
** File name : down.c
**
** Download file to Michelle.
**
** Changing :
**
** A. Date -- 10/21/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**     3. Delete all "MICEEchoESC()" calling.
**     4. Change all "cmd_argv[]" to be "cmd_syntax.asc[]".
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/

#include <stdio.h>
#include  <types.h>
#include  <stat.h>
#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
//#include  "download.h"
#include  "reg86.h"
#include  "database.h"
#ifndef _SD_ABI_EXT_
#include "sdabiext.h"
#endif

/**************************************************************************
**
** Local define
**
***************************************************************************/
#define REGINT       0x70
#define PIDATA       0x86
#define DAT_TYP      0x84
#define MOD_END_REC  0x8A


/**************************************************************************
**
** Local variables
**
***************************************************************************/

unsigned long next_ip;
unsigned char tt;
unsigned char first_c;
int bf_count;
int stopwatch;
int skipLFCR = 0;
int first_CR_SP;

unsigned char asc2hex();
char cs_val[4], cs_old[4], tmp_ip[4];
char dis_cs;
unsigned char dw_buf[2048];
unsigned char dw_buf2[512];
FILE *dfd;
unsigned int old_cs, old_ip;
int dw_byte;
unsigned int len_86;
unsigned long ip_val;
int downCmdFlag=0;

/**************************************************************************
**
** Externals
**
**************************************************************************/

extern unsigned int cs;
extern int downLoadMode;
EXTERN S8  dspMode, langMode;       // Chen
extern U32 RunStart;    // declared in PROCESS.C, added by Chen 07/08/94

/**************************************************************************
**
** Execution codes
**
**************************************************************************/

/**************************************************************************
**
** Name : DownloadCmd(filename)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

DownloadCmd(char *filename)
{
char *hlld_lmalloc();
struct malloc_tag down_ptr_malloc;
int tmp_out_flag;
char *ptr;
struct stat buffer;

   if (access(filename, 0) || // added by James Wang 08/13/1994
        ( !stat(filename, &buffer) && (buffer.st_mode & S_IFDIR) == S_IFDIR ) )
   {
      if ((ptr = (char *)strrchr(filename, '.')) == NULL)
         strcat(filename, ".OMF");
//      else
//         strcpy(ptr, ".OMF");
   }

#ifndef MICEPACK
   downCmdFlag = 1;
#endif
   tmp_out_flag = out_flag;
   if(cbuf = hlld_lmalloc(0 ,600)) {
      memcpy((struct malloc_tag *) &down_ptr_malloc,(struct malloc_tag *) &ptr_malloc,sizeof(struct malloc_tag));
      download(filename);
      memcpy(&ptr_malloc,&down_ptr_malloc,sizeof(struct malloc_tag));
      hlld_lfree(&ptr_malloc);
   } else prn_ferr(45);
   out_flag = tmp_out_flag;
#ifndef MICEPACK
   if (downLoadMode) emuEndLoad();
   downCmdFlag = 0;
#endif
   return(TRUE);
}        /* end of download_cmd() */

/**************************************************************************
**
** Name : download(filename)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

download(char *filename)
{
int i, j, k, r;
unsigned char c, *ptr;
char buf[80], c1;

   dfd=fopen(filename,"rb");
   if(dfd == NULL) {
      prn_ferr(15);
      return(0);
   }
   if(fread(dw_buf,1,80,dfd) <= 0) {
      prn_ferr(38);
      return(0);
   }
   first_c=dw_buf[0];
   fseek(dfd,0L,SEEK_SET);

// Chen 05/27/94
   if (first_c == OMF_86) {     // OMF_86 = ()(0x82); INTEL = (:)(0x3a)
      DisplayStr(" Download in process:   ");
      fclose(dfd);
      fddown=UsdOpenFile((LPSTR)filename,OF_READ);
      r = omf_86_down();
      close(fddown);
   }
   else if ( first_c == INTEL ) {   // added by Chen 05/27/94
        DisplayStr(" Download in process:   ");
        r = downrecord();
        fclose(dfd);
   }
   else {
        r = -2;
   }

   if (r == -1) {
      DisplayStr("\n\r Command aborted by user!\r\n");
   }
   else if ( r==-2 ) {
        DisplayStr(" Invalid download file!\r\n");
   }
   else {
      if (SymLoaded == OK) free_all();
      init_all(filename,MSG_OFF);
      if (r == 1) DisplayStr("\n\r WARNING: Download to illegal memory location!\n\r");
      else        DisplayStr("\n\r Download completed!\r\n");
   }

// Chen     ; r==0, download completed
    if ( first_c == OMF_86 && r == 0 ) {
        UpdateCODVP(-1);
        RedrawFlag = (~MaskRedrawFlag) & (~REDRAWCOD);
        UpdateVP();
    }
    else {      // when download a record, don't update code viewport
//        langMode = 2;   // MIX
//        dspMode = 2;    // MIX
    }
   return(r);
}        /* end of download() */

/**************************************************************************
**
** Name : downrecord()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

downrecord()
{
int dw_byte;
char *ptr;
unsigned long addr, l;
int i,j;
U16 status=0;

   dw_byte = 0;
   next_ip = 0;
   ptr = dw_buf2;
   for (;;) {
      if (chk_hlt() == ESC) return(-1);
      do {
         if (fgets(dw_buf, 1024, dfd) == NULL) return(status ? 1 : 0);
      } while (dw_buf[0] != ':');
      switch (dw_buf[8]) {
      case '2':
         if (dw_byte) {
            l = old_cs;
            addr = (l << 16) + next_ip - dw_byte;
            status |= SdEmuSetMemN(addr, dw_buf2, dw_byte);
            displayCSIP();
            ptr = dw_buf2;
            dw_byte = 0;
         }
         for (i=0;i<4;i++) cs_val[i]=dw_buf[9+i];
         old_cs = 0;
         for (i=0;i<4;i++) old_cs = (old_cs << 4) + asc__h(cs_val[i]);
         break;
      case '0':
         for (i=0;i<4;i++) tmp_ip[i]=dw_buf[3+i];
         old_ip = 0;
         for (i=0;i<4;i++) old_ip = (old_ip << 4) + asc__h(tmp_ip[i]);
         if (dw_byte && (old_ip != next_ip)) {
            l = old_cs;
            addr = (l << 16) + next_ip - dw_byte;
            status |= SdEmuSetMemN(addr, dw_buf2, dw_byte);
            displayCSIP();
            ptr = dw_buf2;
            dw_byte = 0;
         }
         j = asc2hex(dw_buf[1],dw_buf[2]);
         dw_byte += j;
//       next_ip = old_ip+j;   fixed by james 08/25/1994
         next_ip = (unsigned long)old_ip+j;
         j = j*2;
         for (i=0; i < j; i += 2)
         *ptr++ = asc2hex(dw_buf[i+9], dw_buf[i+10]);
         if (dw_byte >= 256) {
            l = old_cs;
            addr = (l << 16) + next_ip - dw_byte;
            status |= SdEmuSetMemN(addr, dw_buf2, dw_byte);
            displayCSIP();
            ptr = dw_buf2;
            dw_byte = 0;
         }
         break;
      case '1':
         if (dw_byte) {
            l = old_cs;
            addr = (l << 16) + next_ip - dw_byte;
            status |= SdEmuSetMemN(addr, dw_buf2, dw_byte);
            displayCSIP();
         }
         return (status ? 1 : 0);
      default:
         break;
      }
   }
   return (status ? 1 : 0);
}        /* end of downrecord() */

unsigned char asc2hex(unsigned char a,unsigned char b)
{
   unsigned char r;
   r = asc__h(a);
   r = (r << 4) | asc__h(b);
   return(r);
}

/**************************************************************************
**
** Name : displayCSIP()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

displayCSIP()
{
int i, rr, cc;
   for (i=0;i<4;i++) DisplayCh(cs_val[i]);
   DisplayCh(':');
   for (i=0;i<4;i++) DisplayCh(tmp_ip[i]);
   save_curs(&rr,&cc);
   set_cur(rr,cc-9);
}        /* end of displayCSIP() */

/**************************************************************************
**
** Name : hex2asc(p,data)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

hex2asc(p,data)
char *p;
unsigned data;
{
   *p++ = hex[(data >> 4) & 0xf];
   *p   = hex[data & 0xf];

}        /* end of hex2asc(p,data) */

/**************************************************************************
**
** Name : omf_86_down()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
omf_86_down()
{
unsigned int i;
char c;
unsigned char  *ptr,reg_id,ch;
unsigned long addr,l;
U16 status=0;

   dw_byte = 0;
   for (;;) {
      len_86 = 0;
      if (chk_hlt() == ESC) return(-1);
      i = read(fddown,dw_buf,3);
      if (i < 3 ) return(-1);
      if((ch=dw_buf[0]) != DAT_TYP && ch != MOD_END_REC
         && ch != PIDATA && ch != REGINT) {
         skip_rec();
         continue;
      } else {
         dis_cs  = 0;
         if (dw_buf[0] == DAT_TYP) {
            len_86 = rec_len()-4;
            getRecCSIP();

/*  Changed by Gates Hua , Date : 01/13/1995
            if (len_86 == 0) break;
*/
            if (len_86 == 0) {
                read(fddown,dw_buf,1);
                continue;
            }

            addr = old_cs;
            addr = (addr << 16) + ip_val;
            for (;;) {
               if (len_86 <= 256) {
                  read(fddown,dw_buf,len_86);
                  status |= SdEmuSetMemN(addr,dw_buf,len_86);
                  break;
               } else {
                  read(fddown,dw_buf,256);
                  status |= SdEmuSetMemN(addr, dw_buf, 256);
                  len_86 -= 256;
                  addr += 256;
               }
               displayCSIP();
               hex2asc(&cs_val[0],(char)(addr >> 24) &0xff);
               hex2asc(&cs_val[2],(char)(addr >> 16) &0xff);
               hex2asc(&tmp_ip[0],(char)(addr >> 8) &0xff);
               hex2asc(&tmp_ip[2],(char)addr&0xff);
            }
            dw_byte = 0;
            read(fddown,dw_buf,1);  /* skip checksum */
         } else if (dw_buf[0] == PIDATA ) {
            len_86 = rec_len() - 4;
            getRecCSIP();
            read(fddown,dw_buf,len_86);
            addr = old_cs;
            addr = (addr << 16) + ip_val;
            status |= ExpandPIdata(addr,dw_buf);
            read(fddown,dw_buf,1);  /* skip checksum */
         } else if (dw_buf[0]==REGINT) {
#ifndef MICEPACK
			if (downLoadMode) emuEndLoad();
#endif
            len_86 = rec_len();
            read(fddown,dw_buf,len_86);
            ptr = dw_buf;
            do {
               if (!(*ptr&1)) {   /* phy. addr. */
                  reg_id = ((*ptr++) & 0xC0) >> 6;
                  len_86 --;
                  if(!(*ptr++ & 0x80)) { /* one byte */
                     if (!(*ptr++ & 0x80)) {
                        len_86 = len_86-2;
                     } else {
                        ptr = ptr + 2;
                        len_86 = len_86 - 3;
                     }
                  } else {
                     ptr = ptr + 4;
                     len_86 = len_86 - 4;
                  }
                  if (reg_id==0x00) { /* CS:IP */
                     old_cs = *ptr++;
                     old_cs = (old_cs << 8) + *ptr++;
                     old_ip = *ptr++;
                     old_ip = (old_ip << 8) + *ptr++;
                     addr = (old_cs << 16) + old_ip;
                     emuSetReg(I86_REG, REG_PC, addr);
                     len_86 = len_86-4;
                  } else if (reg_id==0x01) { /* SS:SP */
                     old_cs = *ptr++;
                     old_cs = (old_cs << 8) + *ptr++;
                     old_ip = *ptr++;
                     old_ip = (old_ip << 8) + *ptr++;
                     addr = (old_cs << 16) + old_ip;
                     emuSetReg(I86_REG, REG_SP, addr);
                     len_86 = len_86-4;
                  } else if (reg_id==0x02) { /* DS */
                     old_cs = *ptr++;
                     addr = (old_cs << 8) + *ptr++;
                     emuSetReg(I86_REG, DS, addr);
                     len_86 = len_86-2;
                  } else { /* ES */
                     old_cs = *ptr++;
                     addr = (old_cs << 8) + *ptr++;
                     emuSetReg(I86_REG, ES, addr);
                     len_86 = len_86-2;
                  }
               }
            } while (len_86 == 1);
         } else {                   /*   end of module   */
#ifndef MICEPACK
			if (downLoadMode) emuEndLoad();
#endif
            len_86 = rec_len();
            read(fddown,dw_buf,len_86);
            if (dw_buf[0] == 0xc0) {
               addr = dw_buf[2];
               addr = (addr << 8) + dw_buf[1];
               // for RESTART command, 07/08/94
               RunStart = addr;
               RunStart <<= 16;
               emuSetReg(I86_REG, CS,addr);
               addr = dw_buf[4];
               addr = (addr << 8) + dw_buf[3];
               // for RESTART command, 07/08/94
               RunStart += addr;
               emuSetReg(I86_REG, IP,addr);
            }
            break;
         }
      }
   }
   return(status ? 1 : 0);
}        /* end of omf_86_down() */

/**************************************************************************
**
** Name : rec_len()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
rec_len()
{
int i;
int j;
   i = dw_buf[2] ;
   j = (i << 8)  + dw_buf[1];
   return(j);
}       /* end of rec_len() */

/**************************************************************************
**
** Name : skip_rec()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
skip_rec()
{
long l;
int i;
   l = rec_len();
   lseek(fddown,l,SEEK_CUR);
}        /* end of skip_rec() */

/**************************************************************************
**
** Name : getRecCSIP()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
getRecCSIP()
{
unsigned int i;
   read(fddown,dw_buf,3);  /* read frame no & offset */
   i = dw_buf[1];
   old_cs = (i << 8) + dw_buf[0];
   hex2asc(&cs_val[0],dw_buf[1]);
   hex2asc(&cs_val[2],dw_buf[0]);
   ip_val = dw_buf[2];
   hex2asc(&tmp_ip[0],0);
   hex2asc(&tmp_ip[2],dw_buf[2]);
}      /* end of getRecCSIP() */

/**************************************************************************
**
** Name : ExpandPIdata()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int ExpandPIdata(U32 addr, U8 *buffer)
{
U8 *RecursivePIDATA(U32 *addr, U8 *buffer, U16 *status);
U32 NextAddr;
U16 status=0;

   NextAddr = addr;
   RecursivePIDATA(&NextAddr, buffer, &status);
   return ( status ? 1 : 0);
}      /* end of ExpandPIdata() */

/**************************************************************************
**
** Name : getRecCSIP()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
static U8 *RecursivePIDATA(U32 *addr, U8 *buffer, U16 *status)
{
U32 StartAddr;
U16 RepeatCount, BlockCount, DataSize, i;
U8 *TempBuf;

   StartAddr = *addr;
   RepeatCount = (U16)buffer[0] + ((U16)buffer[1] << 8);
   BlockCount  = (U16)buffer[2] + ((U16)buffer[3] << 8);
   buffer += 4;
   if (BlockCount == 0) {
      DataSize = (U16) *(buffer++);
      *status |= SdEmuSetMemN(*addr, buffer, (U16)DataSize);
      buffer += DataSize;
      AdvanceAddr(addr, DataSize);
   }
   else
      while (BlockCount--)
         buffer = RecursivePIDATA(addr, buffer, status);

   if (RepeatCount > 1) {
      DataSize = *addr - StartAddr;
      TempBuf = (U8*) malloc(DataSize * RepeatCount);
#ifndef MICEPACK
      if (downLoadMode) emuEndLoad();
#endif
      emuGetMemN(StartAddr, TempBuf, DataSize );
      for (i = 1; i < RepeatCount; i++)
         memcpy(&TempBuf[DataSize * i], TempBuf, DataSize);
      *status |= SdEmuSetMemN(StartAddr, TempBuf, DataSize * RepeatCount);
      *addr = StartAddr;
      AdvanceAddr(addr, DataSize * RepeatCount);
      free(TempBuf);
   }
   return (buffer);
}      /* end of RecursivePIDATA() */

/**************************** End of File **********************************/
