/***************************************************************************
**
**  File name : DSMDEF.H
**
**  Description : include file of disassembler
**
**  Date : 11/13/1992  by C. H. Lin
**
**
**  Copyright (C) 1993 Microtek International Inc.
**  All Rights Reserved
**
****************************************************************************/


/***************************** Macro Definition ****************************/

#define EXTERN  extern
#define GLOBAL
#define LOCAL   static
#define PUBLIC
#define PRIVATE static

#define TRUE  1
#define FALSE 0

#define COUNT(x) (sizeof(x)/sizeof(x[0]))

/***************************** Type Declaration ****************************/

typedef unsigned char U8;
typedef unsigned int  U16;
typedef unsigned long U32;
typedef char          *STR;
typedef char          STRING[];
typedef int           BOOLEAN;
typedef long          PCTYPE;
typedef void          RETCODE;

typedef RETCODE (*TYPEROUTINE)();

typedef struct {
    STR Mnemonic;
    TYPEROUTINE Type;
} DISASMSTRUCT;

/****************************** End of File ********************************/
