/***************************************************************************
**
**  File name : DSMTBL.C
**
**  Description : tables used for disassembler
**
**  Date : 11/13/1992  by C. H. Lin
**
**
**  Copyright (C) 1993 Microtek International Inc.
**  All Rights Reserved
**
****************************************************************************/


/****************************** Include File *******************************/

#include <stdio.h>
#include <string.h>
#include "dsmdef.h"

/**************************** Macro Definition *****************************/

#define CODEID(x) (((x) & 0x38) >> 3)  /* xx???xxx */
#define ESCID(x)  ( (x) & 0x07 )       /* xxxxx??? */

/*********************** External Function Prototype ***********************/

/* defined in DSMTYPE.C */
EXTERN RETCODE Dtype_DB                   (U8*,  STR, int*);
EXTERN RETCODE Dtype_X                    (U8*,  STR, int*);
EXTERN RETCODE Dtype_X0sgX                (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xcw_modXrm           (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xd0_mod0sgrm         (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xdw                  (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xdw_laddr_haddr      (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xdw_modregrm         (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xdw_port             (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xreg                 (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xs0_data             (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xs1_disp             (PCTYPE, U8*,  STR, int*);
EXTERN RETCODE Dtype_Xs1_modregrm_data    (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xsw_modXrm_data      (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xv_type              (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xwreg_data           (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xw_data              (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xw_modregrm          (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xw_modXrm            (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xw_modXrm_count      (U8*,  STR, int*);
EXTERN RETCODE Dtype_Xw_modXrm_data       (U8*,  STR, int*);
EXTERN RETCODE Dtype_X_data               (U8*,  STR, int*);
EXTERN RETCODE Dtype_X_disp               (PCTYPE, U8*,  STR, int*);
EXTERN RETCODE Dtype_X_ldata_hdata        (U8*,  STR, int*);
EXTERN RETCODE Dtype_X_ldata_hdata_data   (U8*,  STR, int*);
EXTERN RETCODE Dtype_X_ldisp_hdisp        (PCTYPE, U8*,  STR, int*);
EXTERN RETCODE Dtype_X_loff_hoff_lseg_hseg(U8*,  STR, int*);
EXTERN RETCODE Dtype_X_modregrm           (U8*,  STR, int*);
EXTERN RETCODE Dtype_X_modXrm             (U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCxxx_modXrm (U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCdxx_11xxxrm(U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCqxx_modXrm (U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCwxx_modXrm (U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCxtx_modXrm (U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCxxx_110xxrm(U8*,  STR, int*);
EXTERN RETCODE Dtype_ESCxxx_X      (U8*,  STR, int*);

/************************* Local Function Prototype ************************/

/*** Routines checking second code ***/
PRIVATE RETCODE Code_80818283(U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_8C8E    (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_8F      (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_C0C1    (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_C6C7    (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_D0D1D2D3(U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_F6F7    (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_FE      (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_FF      (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_ESC     (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_ESC3A      (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_ESC3C3D3E3F(U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_ESC7C      (U8*,  STR, TYPEROUTINE*);
PRIVATE RETCODE Code_ESCDB      (U8*,  STR, TYPEROUTINE*);

/************************ Local Variable Definition ************************/

/*** mnemonic symbols ***/
LOCAL STRING M_UNDEF   = "???";
LOCAL STRING M_DB      = "DB";
LOCAL STRING M_CS      = "CS:";
LOCAL STRING M_DS      = "DS:";
LOCAL STRING M_ES      = "ES:";
LOCAL STRING M_SS      = "SS:";
LOCAL STRING M_AAA     = "AAA";
LOCAL STRING M_AAD     = "AAD";
LOCAL STRING M_AAM     = "AAM";
LOCAL STRING M_AAS     = "AAS";
LOCAL STRING M_ADC     = "ADC";
LOCAL STRING M_ADD     = "ADD";
LOCAL STRING M_AND     = "AND";
LOCAL STRING M_BOUND   = "BOUND";
LOCAL STRING M_CALL    = "CALL";
LOCAL STRING M_CBW     = "CBW";
LOCAL STRING M_CLC     = "CLC";
LOCAL STRING M_CLD     = "CLD";
LOCAL STRING M_CLI     = "CLI";
LOCAL STRING M_CMC     = "CMC";
LOCAL STRING M_CMP     = "CMP";
LOCAL STRING M_CMPSB   = "CMPSB";
LOCAL STRING M_CMPSW   = "CMPSW";
LOCAL STRING M_CWD     = "CWD";
LOCAL STRING M_DAA     = "DAA";
LOCAL STRING M_DAS     = "DAS";
LOCAL STRING M_DEC     = "DEC";
LOCAL STRING M_DIV     = "DIV";
LOCAL STRING M_ENTER   = "ENTER";
LOCAL STRING M_ESC     = "ESC";
LOCAL STRING M_F2XM1   = "F2XM1";
LOCAL STRING M_FABS    = "FABS";
LOCAL STRING M_FADD    = "FADD";
LOCAL STRING M_FADDP   = "FADDP";
LOCAL STRING M_FBLD    = "FBLD";
LOCAL STRING M_FBSTP   = "FBSTP";
LOCAL STRING M_FCHS    = "FCHS";
LOCAL STRING M_FCLEX   = "FCLEX";
LOCAL STRING M_FCOM    = "FCOM";
LOCAL STRING M_FCOMP   = "FCOMP";
LOCAL STRING M_FCOMPP  = "FCOMPP";
LOCAL STRING M_FDECSTP = "FDECSTP";
LOCAL STRING M_FDISI   = "FDISI";
LOCAL STRING M_FDIV    = "FDIV";
LOCAL STRING M_FDIVP   = "FDIVP";
LOCAL STRING M_FDIVR   = "FDIVR";
LOCAL STRING M_FDIVRP  = "FDIVRP";
LOCAL STRING M_FENI    = "FENI";
LOCAL STRING M_FFREE   = "FFREE";
LOCAL STRING M_FIADD   = "FIADD";
LOCAL STRING M_FICOM   = "FICOM";
LOCAL STRING M_FICOMP  = "FICOMP";
LOCAL STRING M_FIDIV   = "FIDIV";
LOCAL STRING M_FIDIVR  = "FIDIVR";
LOCAL STRING M_FILD    = "FILD";
LOCAL STRING M_FIMUL   = "FIMUL";
LOCAL STRING M_FINCSTP = "FINCSTP";
LOCAL STRING M_FINIT   = "FINIT";
LOCAL STRING M_FIST    = "FIST";
LOCAL STRING M_FISTP   = "FISTP";
LOCAL STRING M_FISUB   = "FISUB";
LOCAL STRING M_FISUBR  = "FISUBR";
LOCAL STRING M_FLD     = "FLD";
LOCAL STRING M_FLD1    = "FLD1";
LOCAL STRING M_FLDCW   = "FLDCW";
LOCAL STRING M_FLDENV  = "FLDENV";
LOCAL STRING M_FLDL2E  = "FLDL2E";
LOCAL STRING M_FLDL2T  = "FLDL2T";
LOCAL STRING M_FLDLG2  = "FLDLG2";
LOCAL STRING M_FLDLN2  = "FLDLN2";
LOCAL STRING M_FLDPI   = "FLDPI";
LOCAL STRING M_FLDZ    = "FLDZ";
LOCAL STRING M_FMUL    = "FMUL";
LOCAL STRING M_FMULP   = "FMULP";
LOCAL STRING M_FNOP    = "FNOP";
LOCAL STRING M_FPATAN  = "FPATAN";
LOCAL STRING M_FPREM   = "FPREM";
LOCAL STRING M_FPTAN   = "FPTAN";
LOCAL STRING M_FRNDINT = "FRNDINT";
LOCAL STRING M_FRSTOR  = "FRSTOR";
LOCAL STRING M_FSAVE   = "FSAVE";
LOCAL STRING M_FSCALE  = "FSCALE";
LOCAL STRING M_FSQRT   = "FSQRT";
LOCAL STRING M_FST     = "FST";
LOCAL STRING M_FSTCW   = "FSTCW";
LOCAL STRING M_FSTENV  = "FSTENV";
LOCAL STRING M_FSTP    = "FSTP";
LOCAL STRING M_FSTSW   = "FSTSW";
LOCAL STRING M_FSUB    = "FSUB";
LOCAL STRING M_FSUBP   = "FSUBP";
LOCAL STRING M_FSUBR   = "FSUBR";
LOCAL STRING M_FSUBRP  = "FSUBRP";
LOCAL STRING M_FTST    = "FTST";
LOCAL STRING M_FXAM    = "FXAM";
LOCAL STRING M_FXCH    = "FXCH";
LOCAL STRING M_FXTRACT = "FXTRACT";
LOCAL STRING M_FYL2X   = "FYL2X";
LOCAL STRING M_FYL2XP1 = "FYL2XP1";
LOCAL STRING M_HLT     = "HLT";
LOCAL STRING M_IDIV    = "IDIV";
LOCAL STRING M_IMUL    = "IMUL";
LOCAL STRING M_IN      = "IN";
LOCAL STRING M_INC     = "INC";
LOCAL STRING M_INSB    = "INSB";
LOCAL STRING M_INSW    = "INSW";
LOCAL STRING M_INT     = "INT";
LOCAL STRING M_INTO    = "INTO";
LOCAL STRING M_IRET    = "IRET";
LOCAL STRING M_JA      = "JA";
LOCAL STRING M_JB      = "JB";
LOCAL STRING M_JBE     = "JBE";
LOCAL STRING M_JCXZ    = "JCXZ";
LOCAL STRING M_JG      = "JG";
LOCAL STRING M_JGE     = "JGE";
LOCAL STRING M_JL      = "JL";
LOCAL STRING M_JLE     = "JLE";
LOCAL STRING M_JMP     = "JMP";
LOCAL STRING M_JNB     = "JNB";
LOCAL STRING M_JNO     = "JNO";
LOCAL STRING M_JNS     = "JNS";
LOCAL STRING M_JNZ     = "JNZ";
LOCAL STRING M_JO      = "JO";
LOCAL STRING M_JPE     = "JPE";
LOCAL STRING M_JPO     = "JPO";
LOCAL STRING M_JS      = "JS";
LOCAL STRING M_JZ      = "JZ";
LOCAL STRING M_LAHF    = "LAHF";
LOCAL STRING M_LDS     = "LDS";
LOCAL STRING M_LEA     = "LEA";
LOCAL STRING M_LEAVE   = "LEAVE";
LOCAL STRING M_LES     = "LES";
LOCAL STRING M_LOCK    = "LOCK";
LOCAL STRING M_LODSB   = "LODSB";
LOCAL STRING M_LODSW   = "LODSW";
LOCAL STRING M_LOOP    = "LOOP";
LOCAL STRING M_LOOPNZ  = "LOOPNZ";
LOCAL STRING M_LOOPZ   = "LOOPZ";
LOCAL STRING M_MOV     = "MOV";
LOCAL STRING M_MOVSB   = "MOVSB";
LOCAL STRING M_MOVSW   = "MOVSW";
LOCAL STRING M_MUL     = "MUL";
LOCAL STRING M_NEG     = "NEG";
LOCAL STRING M_NOP     = "NOP";
LOCAL STRING M_NOT     = "NOT";
LOCAL STRING M_OR      = "OR";
LOCAL STRING M_OUT     = "OUT";
LOCAL STRING M_OUTSB   = "OUTSB";
LOCAL STRING M_OUTSW   = "OUTSW";
LOCAL STRING M_POP     = "POP";
LOCAL STRING M_POPA    = "POPA";
LOCAL STRING M_POPF    = "POPF";
LOCAL STRING M_PUSH    = "PUSH";
LOCAL STRING M_PUSHA   = "PUSHA";
LOCAL STRING M_PUSHF   = "PUSHF";
LOCAL STRING M_RCL     = "RCL";
LOCAL STRING M_RCR     = "RCR";
LOCAL STRING M_REPNZ   = "REPNZ";
LOCAL STRING M_REPZ    = "REPZ";
LOCAL STRING M_RET     = "RET";
LOCAL STRING M_RETF    = "RETF";
LOCAL STRING M_ROL     = "ROL";
LOCAL STRING M_ROR     = "ROR";
LOCAL STRING M_SAHF    = "SAHF";
LOCAL STRING M_SAR     = "SAR";
LOCAL STRING M_SBB     = "SBB";
LOCAL STRING M_SCASB   = "SCASB";
LOCAL STRING M_SCASW   = "SCASW";
LOCAL STRING M_SHL     = "SHL";
LOCAL STRING M_SHR     = "SHR";
LOCAL STRING M_STC     = "STC";
LOCAL STRING M_STD     = "STD";
LOCAL STRING M_STI     = "STI";
LOCAL STRING M_STOSB   = "STOSB";
LOCAL STRING M_STOSW   = "STOSW";
LOCAL STRING M_SUB     = "SUB";
LOCAL STRING M_TEST    = "TEST";
LOCAL STRING M_WAIT    = "WAIT";
LOCAL STRING M_XCHG    = "XCHG";
LOCAL STRING M_XLAT    = "XLAT";
LOCAL STRING M_XOR     = "XOR";

/*** ESC instruction --- codes: 11011aaa bbcccddd, index = aaabbccc ***/
LOCAL DISASMSTRUCT ESCtable[256] = {
/* 0x00 */
   M_FADD,     Dtype_ESCqxx_modXrm,
   M_FMUL,     Dtype_ESCqxx_modXrm,
   M_FCOM,     Dtype_ESCqxx_modXrm,
   M_FCOMP,    Dtype_ESCqxx_modXrm,
   M_FSUB,     Dtype_ESCqxx_modXrm,
   M_FSUBR,    Dtype_ESCqxx_modXrm,
   M_FDIV,     Dtype_ESCqxx_modXrm,
   M_FDIVR,    Dtype_ESCqxx_modXrm,
   M_FADD,     Dtype_ESCqxx_modXrm,
   M_FMUL,     Dtype_ESCqxx_modXrm,
   M_FCOM,     Dtype_ESCqxx_modXrm,
   M_FCOMP,    Dtype_ESCqxx_modXrm,
   M_FSUB,     Dtype_ESCqxx_modXrm,
   M_FSUBR,    Dtype_ESCqxx_modXrm,
   M_FDIV,     Dtype_ESCqxx_modXrm,
   M_FDIVR,    Dtype_ESCqxx_modXrm,
/* 0x10 */
   M_FADD,     Dtype_ESCqxx_modXrm,
   M_FMUL,     Dtype_ESCqxx_modXrm,
   M_FCOM,     Dtype_ESCqxx_modXrm,
   M_FCOMP,    Dtype_ESCqxx_modXrm,
   M_FSUB,     Dtype_ESCqxx_modXrm,
   M_FSUBR,    Dtype_ESCqxx_modXrm,
   M_FDIV,     Dtype_ESCqxx_modXrm,
   M_FDIVR,    Dtype_ESCqxx_modXrm,
   M_FADD,     Dtype_ESCdxx_11xxxrm,
   M_FMUL,     Dtype_ESCdxx_11xxxrm,
   M_FCOM,     Dtype_ESCxxx_110xxrm,
   M_FCOMP,    Dtype_ESCxxx_110xxrm,
   M_FSUB,     Dtype_ESCdxx_11xxxrm,
   M_FSUBR,    Dtype_ESCdxx_11xxxrm,
   M_FDIV,     Dtype_ESCdxx_11xxxrm,
   M_FDIVR,    Dtype_ESCdxx_11xxxrm,
/* 0x20 */
   M_FLD,      Dtype_ESCqxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FST,      Dtype_ESCqxx_modXrm,
   M_FSTP,     Dtype_ESCqxx_modXrm,
   M_FLDENV,   Dtype_ESCxtx_modXrm,
   M_FLDCW,    Dtype_ESCxtx_modXrm,
   M_FSTENV,   Dtype_ESCxtx_modXrm,
   M_FSTCW,    Dtype_ESCxtx_modXrm,
   M_FLD,      Dtype_ESCqxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FST,      Dtype_ESCqxx_modXrm,
   M_FSTP,     Dtype_ESCqxx_modXrm,
   M_FLDENV,   Dtype_ESCxtx_modXrm,
   M_FLDCW,    Dtype_ESCxtx_modXrm,
   M_FSTENV,   Dtype_ESCxtx_modXrm,
   M_FSTCW,    Dtype_ESCxtx_modXrm,
/* 0x30 */
   M_FLD,      Dtype_ESCqxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FST,      Dtype_ESCqxx_modXrm,
   M_FSTP,     Dtype_ESCqxx_modXrm,
   M_FLDENV,   Dtype_ESCxtx_modXrm,
   M_FLDCW,    Dtype_ESCxtx_modXrm,
   M_FSTENV,   Dtype_ESCxtx_modXrm,
   M_FSTCW,    Dtype_ESCxtx_modXrm,
   M_FLD,      Dtype_ESCxxx_110xxrm,
   M_FXCH,     Dtype_ESCxxx_110xxrm,
   NULL,       Code_ESC3A,
   M_FSTP,     Dtype_ESCxxx_110xxrm,
   NULL,       Code_ESC3C3D3E3F,
   NULL,       Code_ESC3C3D3E3F,
   NULL,       Code_ESC3C3D3E3F,
   NULL,       Code_ESC3C3D3E3F,
/* 0x40 */
   M_FIADD,    Dtype_ESCwxx_modXrm,
   M_FIMUL,    Dtype_ESCwxx_modXrm,
   M_FICOM,    Dtype_ESCwxx_modXrm,
   M_FICOMP,   Dtype_ESCwxx_modXrm,
   M_FISUB,    Dtype_ESCwxx_modXrm,
   M_FISUBR,   Dtype_ESCwxx_modXrm,
   M_FIDIV,    Dtype_ESCwxx_modXrm,
   M_FIDIVR,   Dtype_ESCwxx_modXrm,
   M_FIADD,    Dtype_ESCwxx_modXrm,
   M_FIMUL,    Dtype_ESCwxx_modXrm,
   M_FICOM,    Dtype_ESCwxx_modXrm,
   M_FICOMP,   Dtype_ESCwxx_modXrm,
   M_FISUB,    Dtype_ESCwxx_modXrm,
   M_FISUBR,   Dtype_ESCwxx_modXrm,
   M_FIDIV,    Dtype_ESCwxx_modXrm,
   M_FIDIVR,   Dtype_ESCwxx_modXrm,
/* 0x50 */
   M_FIADD,    Dtype_ESCwxx_modXrm,
   M_FIMUL,    Dtype_ESCwxx_modXrm,
   M_FICOM,    Dtype_ESCwxx_modXrm,
   M_FICOMP,   Dtype_ESCwxx_modXrm,
   M_FISUB,    Dtype_ESCwxx_modXrm,
   M_FISUBR,   Dtype_ESCwxx_modXrm,
   M_FIDIV,    Dtype_ESCwxx_modXrm,
   M_FIDIVR,   Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
/* 0x60 */
   M_FILD,     Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FIST,     Dtype_ESCwxx_modXrm,
   M_FISTP,    Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FLD,      Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FSTP,     Dtype_ESCxtx_modXrm,
   M_FILD,     Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FIST,     Dtype_ESCwxx_modXrm,
   M_FISTP,    Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FLD,      Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FSTP,     Dtype_ESCxtx_modXrm,
/* 0x70 */
   M_FILD,     Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FIST,     Dtype_ESCwxx_modXrm,
   M_FISTP,    Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FLD,      Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FSTP,     Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   NULL,       Code_ESC7C,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
/* 0x80 */
   M_FADD,     Dtype_ESCqxx_modXrm,
   M_FMUL,     Dtype_ESCqxx_modXrm,
   M_FCOM,     Dtype_ESCqxx_modXrm,
   M_FCOMP,    Dtype_ESCqxx_modXrm,
   M_FSUB,     Dtype_ESCqxx_modXrm,
   M_FSUBR,    Dtype_ESCqxx_modXrm,
   M_FDIV,     Dtype_ESCqxx_modXrm,
   M_FDIVR,    Dtype_ESCqxx_modXrm,
   M_FADD,     Dtype_ESCqxx_modXrm,
   M_FMUL,     Dtype_ESCqxx_modXrm,
   M_FCOM,     Dtype_ESCqxx_modXrm,
   M_FCOMP,    Dtype_ESCqxx_modXrm,
   M_FSUB,     Dtype_ESCqxx_modXrm,
   M_FSUBR,    Dtype_ESCqxx_modXrm,
   M_FDIV,     Dtype_ESCqxx_modXrm,
   M_FDIVR,    Dtype_ESCqxx_modXrm,
/* 0x90 */
   M_FADD,     Dtype_ESCqxx_modXrm,
   M_FMUL,     Dtype_ESCqxx_modXrm,
   M_FCOM,     Dtype_ESCqxx_modXrm,
   M_FCOMP,    Dtype_ESCqxx_modXrm,
   M_FSUB,     Dtype_ESCqxx_modXrm,
   M_FSUBR,    Dtype_ESCqxx_modXrm,
   M_FDIV,     Dtype_ESCqxx_modXrm,
   M_FDIVR,    Dtype_ESCqxx_modXrm,
   M_FADD,     Dtype_ESCdxx_11xxxrm,
   M_FMUL,     Dtype_ESCdxx_11xxxrm,
   M_FCOM,     Dtype_ESCxxx_110xxrm,
   M_FCOMP,    Dtype_ESCxxx_110xxrm,
   M_FSUBR,    Dtype_ESCdxx_11xxxrm,
   M_FSUB,     Dtype_ESCdxx_11xxxrm,
   M_FDIVR,    Dtype_ESCdxx_11xxxrm,
   M_FDIV,     Dtype_ESCdxx_11xxxrm,
/* 0xA0 */
   M_FLD,      Dtype_ESCqxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FST,      Dtype_ESCqxx_modXrm,
   M_FSTP,     Dtype_ESCqxx_modXrm,
   M_FRSTOR,   Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FSAVE,    Dtype_ESCxtx_modXrm,
   M_FSTSW,    Dtype_ESCxtx_modXrm,
   M_FLD,      Dtype_ESCqxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FST,      Dtype_ESCqxx_modXrm,
   M_FSTP,     Dtype_ESCqxx_modXrm,
   M_FRSTOR,   Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FSAVE,    Dtype_ESCxtx_modXrm,
   M_FSTSW,    Dtype_ESCxtx_modXrm,
/* 0xB0 */
   M_FLD,      Dtype_ESCqxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FST,      Dtype_ESCqxx_modXrm,
   M_FSTP,     Dtype_ESCqxx_modXrm,
   M_FRSTOR,   Dtype_ESCxtx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FSAVE,    Dtype_ESCxtx_modXrm,
   M_FSTSW,    Dtype_ESCxtx_modXrm,
   M_FFREE,    Dtype_ESCxxx_110xxrm,
   M_FXCH,     Dtype_ESCxxx_110xxrm,
   M_FST,      Dtype_ESCxxx_110xxrm,
   M_FSTP,     Dtype_ESCxxx_110xxrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
/* 0xC0 */
   M_FIADD,    Dtype_ESCwxx_modXrm,
   M_FIMUL,    Dtype_ESCwxx_modXrm,
   M_FICOM,    Dtype_ESCwxx_modXrm,
   M_FICOMP,   Dtype_ESCwxx_modXrm,
   M_FISUB,    Dtype_ESCwxx_modXrm,
   M_FISUBR,   Dtype_ESCwxx_modXrm,
   M_FIDIV,    Dtype_ESCwxx_modXrm,
   M_FIDIVR,   Dtype_ESCwxx_modXrm,
   M_FIADD,    Dtype_ESCwxx_modXrm,
   M_FIMUL,    Dtype_ESCwxx_modXrm,
   M_FICOM,    Dtype_ESCwxx_modXrm,
   M_FICOMP,   Dtype_ESCwxx_modXrm,
   M_FISUB,    Dtype_ESCwxx_modXrm,
   M_FISUBR,   Dtype_ESCwxx_modXrm,
   M_FIDIV,    Dtype_ESCwxx_modXrm,
   M_FIDIVR,   Dtype_ESCwxx_modXrm,
/* 0xD0 */
   M_FIADD,    Dtype_ESCwxx_modXrm,
   M_FIMUL,    Dtype_ESCwxx_modXrm,
   M_FICOM,    Dtype_ESCwxx_modXrm,
   M_FICOMP,   Dtype_ESCwxx_modXrm,
   M_FISUB,    Dtype_ESCwxx_modXrm,
   M_FISUBR,   Dtype_ESCwxx_modXrm,
   M_FIDIV,    Dtype_ESCwxx_modXrm,
   M_FIDIVR,   Dtype_ESCwxx_modXrm,
   M_FADDP,    Dtype_ESCdxx_11xxxrm,
   M_FMULP,    Dtype_ESCdxx_11xxxrm,
   M_FCOMP,    Dtype_ESCxxx_110xxrm,
   NULL,       Code_ESCDB,
   M_FSUBRP,   Dtype_ESCdxx_11xxxrm,
   M_FSUBP,    Dtype_ESCdxx_11xxxrm,
   M_FDIVRP,   Dtype_ESCdxx_11xxxrm,
   M_FDIVP,    Dtype_ESCdxx_11xxxrm,
/* 0xE0 */
   M_FILD,     Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FIST,     Dtype_ESCwxx_modXrm,
   M_FISTP,    Dtype_ESCwxx_modXrm,
   M_FBLD,     Dtype_ESCxtx_modXrm,
   M_FILD,     Dtype_ESCqxx_modXrm,
   M_FBSTP,    Dtype_ESCxtx_modXrm,
   M_FISTP,    Dtype_ESCqxx_modXrm,
   M_FILD,     Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FIST,     Dtype_ESCwxx_modXrm,
   M_FISTP,    Dtype_ESCwxx_modXrm,
   M_FBLD,     Dtype_ESCxtx_modXrm,
   M_FILD,     Dtype_ESCqxx_modXrm,
   M_FBSTP,    Dtype_ESCxtx_modXrm,
   M_FISTP,    Dtype_ESCqxx_modXrm,
/* 0xF0 */
   M_FILD,     Dtype_ESCwxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FIST,     Dtype_ESCwxx_modXrm,
   M_FISTP,    Dtype_ESCwxx_modXrm,
   M_FBLD,     Dtype_ESCxtx_modXrm,
   M_FILD,     Dtype_ESCqxx_modXrm,
   M_FBSTP,    Dtype_ESCxtx_modXrm,
   M_FISTP,    Dtype_ESCqxx_modXrm,
   M_FFREE,    Dtype_ESCxxx_110xxrm,
   M_FXCH,     Dtype_ESCxxx_110xxrm,
   M_FST,      Dtype_ESCxxx_110xxrm,
   M_FSTP,     Dtype_ESCxxx_110xxrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm
};

LOCAL DISASMSTRUCT ESCsubtable[32] = {
   M_FCHS,     Dtype_ESCxxx_X,
   M_FABS,     Dtype_ESCxxx_X,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FTST,     Dtype_ESCxxx_X,
   M_FXAM,     Dtype_ESCxxx_X,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FLD1,     Dtype_ESCxxx_X,
   M_FLDL2T,   Dtype_ESCxxx_X,
   M_FLDL2E,   Dtype_ESCxxx_X,
   M_FLDPI,    Dtype_ESCxxx_X,
   M_FLDLG2,   Dtype_ESCxxx_X,
   M_FLDLN2,   Dtype_ESCxxx_X,
   M_FLDZ,     Dtype_ESCxxx_X,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_F2XM1,    Dtype_ESCxxx_X,
   M_FYL2X,    Dtype_ESCxxx_X,
   M_FPTAN,    Dtype_ESCxxx_X,
   M_FPATAN,   Dtype_ESCxxx_X,
   M_FXTRACT,  Dtype_ESCxxx_X,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FDECSTP,  Dtype_ESCxxx_X,
   M_FINCSTP,  Dtype_ESCxxx_X,
   M_FPREM,    Dtype_ESCxxx_X,
   M_FYL2XP1,  Dtype_ESCxxx_X,
   M_FSQRT,    Dtype_ESCxxx_X,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_FRNDINT,  Dtype_ESCxxx_X,
   M_FSCALE,   Dtype_ESCxxx_X,
   M_ESC,      Dtype_ESCxxx_modXrm,
   M_ESC,      Dtype_ESCxxx_modXrm
};

/************* Global Variable Definition for Related Modules **************/

/*** disassembler table ***/
GLOBAL DISASMSTRUCT DisasmTable[256] = {
/* 0x00 */
   M_ADD,      Dtype_Xdw_modregrm,
   M_ADD,      Dtype_Xdw_modregrm,
   M_ADD,      Dtype_Xdw_modregrm,
   M_ADD,      Dtype_Xdw_modregrm,
   M_ADD,      Dtype_Xw_data,
   M_ADD,      Dtype_Xw_data,
   M_PUSH,     Dtype_X0sgX,
   M_POP,      Dtype_X0sgX,
   M_OR,       Dtype_Xdw_modregrm,
   M_OR,       Dtype_Xdw_modregrm,
   M_OR,       Dtype_Xdw_modregrm,
   M_OR,       Dtype_Xdw_modregrm,
   M_OR,       Dtype_Xw_data,
   M_OR,       Dtype_Xw_data,
   M_PUSH,     Dtype_X0sgX,
   M_DB,       Dtype_DB,
/* 0x10 */
   M_ADC,      Dtype_Xdw_modregrm,
   M_ADC,      Dtype_Xdw_modregrm,
   M_ADC,      Dtype_Xdw_modregrm,
   M_ADC,      Dtype_Xdw_modregrm,
   M_ADC,      Dtype_Xw_data,
   M_ADC,      Dtype_Xw_data,
   M_PUSH,     Dtype_X0sgX,
   M_POP,      Dtype_X0sgX,
   M_SBB,      Dtype_Xdw_modregrm,
   M_SBB,      Dtype_Xdw_modregrm,
   M_SBB,      Dtype_Xdw_modregrm,
   M_SBB,      Dtype_Xdw_modregrm,
   M_SBB,      Dtype_Xw_data,
   M_SBB,      Dtype_Xw_data,
   M_PUSH,     Dtype_X0sgX,
   M_POP,      Dtype_X0sgX,
/* 0x20 */
   M_AND,      Dtype_Xdw_modregrm,
   M_AND,      Dtype_Xdw_modregrm,
   M_AND,      Dtype_Xdw_modregrm,
   M_AND,      Dtype_Xdw_modregrm,
   M_AND,      Dtype_Xw_data,
   M_AND,      Dtype_Xw_data,
   M_ES,       Dtype_X,
   M_DAA,      Dtype_X,
   M_SUB,      Dtype_Xdw_modregrm,
   M_SUB,      Dtype_Xdw_modregrm,
   M_SUB,      Dtype_Xdw_modregrm,
   M_SUB,      Dtype_Xdw_modregrm,
   M_SUB,      Dtype_Xw_data,
   M_SUB,      Dtype_Xw_data,
   M_CS,       Dtype_X,
   M_DAS,      Dtype_X,
/* 0x30 */
   M_XOR,      Dtype_Xdw_modregrm,
   M_XOR,      Dtype_Xdw_modregrm,
   M_XOR,      Dtype_Xdw_modregrm,
   M_XOR,      Dtype_Xdw_modregrm,
   M_XOR,      Dtype_Xw_data,
   M_XOR,      Dtype_Xw_data,
   M_SS,       Dtype_X,
   M_AAA,      Dtype_X,
   M_CMP,      Dtype_Xdw_modregrm,
   M_CMP,      Dtype_Xdw_modregrm,
   M_CMP,      Dtype_Xdw_modregrm,
   M_CMP,      Dtype_Xdw_modregrm,
   M_CMP,      Dtype_Xw_data,
   M_CMP,      Dtype_Xw_data,
   M_DS,       Dtype_X,
   M_AAS,      Dtype_X,
/* 0x40 */
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_INC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
   M_DEC,      Dtype_Xreg,
/* 0x50 */
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_PUSH,     Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
   M_POP,      Dtype_Xreg,
/* 0x60 */
   M_PUSHA,    Dtype_X,
   M_POPA,     Dtype_X,
   M_BOUND,    Dtype_X_modregrm,
   M_DB,       Dtype_DB,
   M_DB,       Dtype_DB,
   M_DB,       Dtype_DB,
   M_DB,       Dtype_DB,
   M_DB,       Dtype_DB,
   M_PUSH,     Dtype_Xs0_data,
   M_IMUL,     Dtype_Xs1_modregrm_data,
   M_PUSH,     Dtype_Xs0_data,
   M_IMUL,     Dtype_Xs1_modregrm_data,
   M_INSB,     Dtype_X,
   M_INSW,     Dtype_X,
   M_OUTSB,    Dtype_X,
   M_OUTSW,    Dtype_X,
/* 0x70 */
   M_JO,       Dtype_X_disp,
   M_JNO,      Dtype_X_disp,
   M_JB,       Dtype_X_disp,
   M_JNB,      Dtype_X_disp,
   M_JZ,       Dtype_X_disp,
   M_JNZ,      Dtype_X_disp,
   M_JBE,      Dtype_X_disp,
   M_JA,       Dtype_X_disp,
   M_JS,       Dtype_X_disp,
   M_JNS,      Dtype_X_disp,
   M_JPE,      Dtype_X_disp,
   M_JPO,      Dtype_X_disp,
   M_JL,       Dtype_X_disp,
   M_JGE,      Dtype_X_disp,
   M_JLE,      Dtype_X_disp,
   M_JG,       Dtype_X_disp,
/* 0x80 */
   NULL,       Code_80818283,
   NULL,       Code_80818283,
   NULL,       Code_80818283,
   NULL,       Code_80818283,
   M_TEST,     Dtype_Xw_modregrm,
   M_TEST,     Dtype_Xw_modregrm,
   M_XCHG,     Dtype_Xw_modregrm,
   M_XCHG,     Dtype_Xw_modregrm,
   M_MOV,      Dtype_Xdw_modregrm,
   M_MOV,      Dtype_Xdw_modregrm,
   M_MOV,      Dtype_Xdw_modregrm,
   M_MOV,      Dtype_Xdw_modregrm,
   NULL,       Code_8C8E,
   M_LEA,      Dtype_X_modregrm,
   NULL,       Code_8C8E,
   NULL,       Code_8F,
/* 0x90 */
   M_NOP,      Dtype_X,
   M_XCHG,     Dtype_Xreg,
   M_XCHG,     Dtype_Xreg,
   M_XCHG,     Dtype_Xreg,
   M_XCHG,     Dtype_Xreg,
   M_XCHG,     Dtype_Xreg,
   M_XCHG,     Dtype_Xreg,
   M_XCHG,     Dtype_Xreg,
   M_CBW,      Dtype_X,
   M_CWD,      Dtype_X,
   M_CALL,     Dtype_X_loff_hoff_lseg_hseg,
   M_WAIT,     Dtype_X,
   M_PUSHF,    Dtype_X,
   M_POPF,     Dtype_X,
   M_SAHF,     Dtype_X,
   M_LAHF,     Dtype_X,
/* 0xA0 */
   M_MOV,      Dtype_Xdw_laddr_haddr,
   M_MOV,      Dtype_Xdw_laddr_haddr,
   M_MOV,      Dtype_Xdw_laddr_haddr,
   M_MOV,      Dtype_Xdw_laddr_haddr,
   M_MOVSB,    Dtype_X,
   M_MOVSW,    Dtype_X,
   M_CMPSB,    Dtype_X,
   M_CMPSW,    Dtype_X,
   M_TEST,     Dtype_Xw_data,
   M_TEST,     Dtype_Xw_data,
   M_STOSB,    Dtype_X,
   M_STOSW,    Dtype_X,
   M_LODSB,    Dtype_X,
   M_LODSW,    Dtype_X,
   M_SCASB,    Dtype_X,
   M_SCASW,    Dtype_X,
/* 0xB0 */
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
   M_MOV,      Dtype_Xwreg_data,
/* 0xC0 */
   NULL,       Code_C0C1,
   NULL,       Code_C0C1,
   M_RET,      Dtype_X_ldata_hdata,
   M_RET,      Dtype_X,
   M_LES,      Dtype_X_modregrm,
   M_LDS,      Dtype_X_modregrm,
   NULL,       Code_C6C7,
   NULL,       Code_C6C7,
   M_ENTER,    Dtype_X_ldata_hdata_data,
   M_LEAVE,    Dtype_X,
   M_RETF,     Dtype_X_ldata_hdata,
   M_RETF,     Dtype_X,
   M_INT,      Dtype_Xv_type,
   M_INT,      Dtype_Xv_type,
   M_INTO,     Dtype_X,
   M_IRET,     Dtype_X,
/* 0xD0 */
   NULL,       Code_D0D1D2D3,
   NULL,       Code_D0D1D2D3,
   NULL,       Code_D0D1D2D3,
   NULL,       Code_D0D1D2D3,
   M_AAM,      Dtype_X_data,
   M_AAD,      Dtype_X_data,
   M_DB,       Dtype_DB,
   M_XLAT,     Dtype_X,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
   NULL,       Code_ESC,
/* 0xE0 */
   M_LOOPNZ,   Dtype_X_disp,
   M_LOOPZ,    Dtype_X_disp,
   M_LOOP,     Dtype_X_disp,
   M_JCXZ,     Dtype_X_disp,
   M_IN,       Dtype_Xdw_port,
   M_IN,       Dtype_Xdw_port,
   M_OUT,      Dtype_Xdw_port,
   M_OUT,      Dtype_Xdw_port,
   M_CALL,     Dtype_X_ldisp_hdisp,
   M_JMP,      Dtype_Xs1_disp,
   M_JMP,      Dtype_X_loff_hoff_lseg_hseg,
   M_JMP,      Dtype_Xs1_disp,
   M_IN,       Dtype_Xdw,
   M_IN,       Dtype_Xdw,
   M_OUT,      Dtype_Xdw,
   M_OUT,      Dtype_Xdw,
/* 0xF0 */
   M_LOCK,     Dtype_X,
   M_DB,       Dtype_DB,
   M_REPNZ,    Dtype_X,
   M_REPZ,     Dtype_X,
   M_HLT,      Dtype_X,
   M_CMC,      Dtype_X,
   NULL,       Code_F6F7,
   NULL,       Code_F6F7,
   M_CLC,      Dtype_X,
   M_STC,      Dtype_X,
   M_CLI,      Dtype_X,
   M_STI,      Dtype_X,
   M_CLD,      Dtype_X,
   M_STD,      Dtype_X,
   NULL,       Code_FE,
   NULL,       Code_FF
};


                           /*********************
                            *  Executable Code  *
                            *********************/


/***************************************************************************
**
** Name: Code_*(Code,  Mnemonic, Type)
**
** Description:
**    get mnemonic symbol and code type routine of codes by checking 2nd code
**
** Input:  code data
**
** Output: mnemonic symbol, code type routine
**
****************************************************************************/

/***************************************************************************/
PRIVATE RETCODE Code_80818283(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
static STR MnemonicTable[8] = {
   M_ADD, M_OR, M_ADC, M_SBB, M_AND, M_SUB, M_XOR, M_CMP
};

   strcpy(Mnemonic, MnemonicTable[ CODEID(Code[1]) ]);
   *Type = Dtype_Xsw_modXrm_data;
}

/***************************************************************************/
PRIVATE RETCODE Code_8C8E(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
   if (Code[1] & 0x20)
      strcpy(Mnemonic, M_UNDEF);
   else
      strcpy(Mnemonic, M_MOV);
   *Type = Dtype_Xd0_mod0sgrm;
}

/***************************************************************************/
PRIVATE RETCODE Code_8F(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
   if (CODEID(Code[1]) == 0)
      strcpy(Mnemonic, M_POP);
   else
      strcpy(Mnemonic, M_UNDEF);
   *Type = Dtype_X_modXrm;
}

/***************************************************************************/
PRIVATE RETCODE Code_C0C1(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
static STR MnemonicTable[8] = {
   M_ROL, M_ROR, M_RCL, M_RCR, M_SHL, M_SHR, M_UNDEF, M_SAR
};

   strcpy(Mnemonic, MnemonicTable[ CODEID(Code[1]) ]);
   *Type = Dtype_Xw_modXrm_count;
}

/***************************************************************************/
PRIVATE RETCODE Code_C6C7(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
   if (CODEID(Code[1]) == 0)
      strcpy(Mnemonic, M_MOV);
   else
      strcpy(Mnemonic, M_UNDEF);
   *Type = Dtype_Xw_modXrm_data;
}

/***************************************************************************/
PRIVATE RETCODE Code_D0D1D2D3(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
static STR MnemonicTable[8] = {
   M_ROL, M_ROR, M_RCL, M_RCR, M_SHL, M_SHR, M_UNDEF, M_SAR
};

   strcpy(Mnemonic, MnemonicTable[ CODEID(Code[1]) ]);
   *Type = Dtype_Xcw_modXrm;
}

/***************************************************************************/
PRIVATE RETCODE Code_F6F7(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
static STR MnemonicTable[8] = {
   M_TEST, M_UNDEF, M_NOT, M_NEG, M_MUL, M_IMUL, M_DIV, M_IDIV
};

   strcpy(Mnemonic, MnemonicTable[ CODEID(Code[1]) ]);
   if (CODEID(Code[1]) == 0)
      *Type = Dtype_Xw_modXrm_data;
   else
      *Type = Dtype_Xw_modXrm;
}

/***************************************************************************/
PRIVATE RETCODE Code_FE(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
STR ptr;
   switch (CODEID(Code[1])) {
      case 0:
         ptr = M_INC;
         *Type = Dtype_Xw_modXrm;
         break;
      case 1:
         ptr = M_DEC;
         *Type = Dtype_Xw_modXrm;
         break;
      default:
         ptr = M_UNDEF;
         *Type = Dtype_X_modXrm;
   }
   strcpy(Mnemonic, ptr);
}

/***************************************************************************/
PRIVATE RETCODE Code_FF(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
static STR MnemonicTable[8] = {
    M_INC, M_DEC, M_CALL, M_CALL, M_JMP, M_JMP, M_PUSH, M_UNDEF
};

   strcpy(Mnemonic, MnemonicTable[ CODEID(Code[1]) ]);
   if (CODEID(Code[1]) == 0 || CODEID(Code[1]) == 1)
      *Type = Dtype_Xw_modXrm;
   else
      *Type = Dtype_X_modXrm;
}

/***************************************************************************/
PRIVATE RETCODE Code_ESC(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
int Index;
STR MnemonicPtr;

   Index = ((Code[0] & 0x07) << 5) | ((Code[1] & 0xF8) >> 3);
   MnemonicPtr = ESCtable[Index].Mnemonic;
   *Type = ESCtable[Index].Type;
   if (MnemonicPtr != NULL)   /* unique mnemonic symbol */
      strcpy(Mnemonic, MnemonicPtr);
   else                       /* call further routine to identify */
      (**Type)(Code,  Mnemonic, Type);
}

/***************************************************************************/
PRIVATE RETCODE Code_ESC3A(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
   if (ESCID(Code[1]) == 0) {
      strcpy(Mnemonic, M_FNOP);
      *Type = Dtype_ESCxxx_X;
   }
   else {
      strcpy(Mnemonic, M_ESC);
      *Type = Dtype_ESCxxx_modXrm;
   }
}

/***************************************************************************/
PRIVATE RETCODE Code_ESC3C3D3E3F(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
int Subindex;

   Subindex = Code[1] & 0x1F;
   strcpy(Mnemonic, ESCsubtable[Subindex].Mnemonic);
   *Type = ESCsubtable[Subindex].Type;
}

/***************************************************************************/
PRIVATE RETCODE Code_ESC7C(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
static STR MnemonicTable[8] = {
   M_FENI, M_FDISI, M_FCLEX, M_FINIT, M_ESC, M_ESC, M_ESC, M_ESC
};

   strcpy(Mnemonic, MnemonicTable[ ESCID(Code[1]) ]);
   if (ESCID(Code[1]) < 4)
      *Type = Dtype_ESCxxx_X;
   else
      *Type = Dtype_ESCxxx_modXrm;
}

/***************************************************************************/
PRIVATE RETCODE Code_ESCDB(U8 *Code,  STR Mnemonic, TYPEROUTINE *Type)
{
   if (ESCID(Code[1]) == 1) {
      strcpy(Mnemonic, M_FCOMPP);
      *Type = Dtype_ESCxxx_X;
   }
   else {
      strcpy(Mnemonic, M_ESC);
      *Type = Dtype_ESCxxx_modXrm;
   }
}

/******************************* End of File *******************************/
