#include <bios.h>
#include <time.h>
#include <io.h>
#include <fcntl.h>
#include <string.h>
#include <dos.h>
#include "basetype.h"
int comPort;
extern int RS232, baud, RS232_COM;
extern int buffer_init();
extern int rx_data();
extern int tx_data(char);
extern void _com1init();
extern void _com2init();
extern void c192();
extern void c384();
extern void c576();

#define IO_PORT_COM1_NEC    0x30  /*CORE:COM1 address           (8250)*/
#define INT_VEC_COM1_NEC   (8+4)  /*CORE:Intr vect offset IRQ4 for NEC */
#define PORTC_NEC           0x37  /*CORE:Address of the PORTC    (8255)*/
#define INT_ENABLE_COM1_NEC 0x0EF /*CORE:Intr enable for IRQ4    (8259)*/
#define INT_MASK_PORT_NEC   0x02  /*CORE:Address of system int   (8259)*/

#define iostatNEC     2 /*CODE:Status register (8251)                        */
#define iocmdNEC      2 /*CORE:Cmmand register (8251)                        */
#define txemptyNEC 0x01 /*CORE:Xmit buffer empty bit in status register(8251)*/

#define IO_PORT_COM1 0x03f8 /*COM1 address */
#define IO_PORT_COM2 0x02f8 /*COM2 address */
#define INT_VEC_COM1	    (8+4) /* Interrupt vector offset for IRQ4*/
#define INT_ENABLE_COM1     0x0EF /* Interrupt enable for IRQ4 (COM1)*/
#define INT_VEC_COM2	    (8+3) /* Interrupt vector offset for IRQ3*/
#define INT_ENABLE_COM2     0x0F7 /* Interrupt enable for IRQ3 (COM2)*/
#define INT_MASK_PORT	    0x0021/*Address of system int. mask */

#define iotxrx		  0	 /* TX/RX data registers */
#define iobaudl		  0	 /* Low byte of baud rate */
#define iointen		  1	 /* Interrupt enables */
#define iobaudh		  1	 /* High byte of baud rate */
#define iointid		  2	 /* Interrupt ID */
#define iolinctl	  3	 /* Line control */
#define iomdmctl	  4	 /* Modem control */
#define iolinstat         5	 /* Line status */
#define iomdmstat	  6	 /* Modem status */
#define txempty	         0x20    /* Xmit buffer empty bit in iolinstat*/
#define rxdata		  1	 /* data ready on com port */

#define SERIALBUFSIZE	256
#define	SERIALBUFHIGH	SERIALBUFSIZE*3/4
#define	SERIALBUFLOW	SERIALBUFSIZE*1/4
volatile unsigned char SerialBuffer[SERIALBUFSIZE];
volatile unsigned short SerialBufferLen;
volatile unsigned short SerialBufferInPtr;
volatile unsigned short SerialBufferOutPtr;

unsigned short ioport, intenable,intvec;
int comType;
unsigned short baudRateTable[] = 
			{ 300,384,
			  600,192,
              1200,96,
              2400,48,
              4800,24,
			  9600,12,
			  19200,6,
			  38400,3,
			  57600,2,
			  0,0 
			};

int open_pcport();
int read_pcport(char *);
int write_pcport(char *);

/***********************************************************************
*
*			Local Equates
*
************************************************************************/
#define SE_NO_CR_IN_BUFFER	1
#define PROMPT_CHARACTER	'>'

/* state variables */
int numberOfLineStarts;
int numberOfReceivedPrompts;
int comPortErrors;
char emulatorStatusCharacter;
char charBuffer[5];
char markCharacter;

/* buffers */
#define RECEIVE_BUFFER_SIZE  8096
char receiveBuffer[RECEIVE_BUFFER_SIZE];
char *receiveBufferInPtr;
char *receiveBufferOutPtr;

#define CLOCKS_PER_SEC 100 
/************************************************************************
*
* int	open_pcport ()
*
*  Determine com port type and install ISR.
*
*	Return:	 0 = OK.
*                1 = FALSE
*
************************************************************************/
int HostCode=1; /*CORE:1-IBM,0-NEC*/
int open_pcport()
{
    if (init_vct() == FALSE ) return(1);
        init_rs232();
        if ( baud == 8 )  c192();
        else  if ( baud == 9 )  c384();
        else  if ( baud == 10)  c576();
    return(0);
}

init_vct()
{
 return( buffer_init() );
}

/****************************************************************************/
/*  call INT 14h to initialize RS-232					    */
/****************************************************************************/

init_rs232()
{
 union REGS  inregs, outregs;

/* CORE 90.08.14 Modify RS232C Setting (Same As SPEED Command) */
#ifdef NEC_PC9801 /*NEC_PC9801*/
    struct SREGS segregs ;
    unsigned int flags = 0 ;
    
    flags  = (((RS232 & 0x00e0)>> 5)+1)<<8 ; /* CORE 90.08.14 Set Baud Rate */
    flags |= ( (RS232 & 0x0003)<< 2)       ; /* CORE 90.08.14 Set Data Leng */
    flags |= ( (RS232 & 0x0018)<< 1)       ; /* CORE 90.08.14 Set Party Chk */
    flags |= 0x0040;                         /* CORE 90.08.14 Set Stop = 1  */
    segread (&segregs) ;                     /*              & X-Cntl = OFF */
    inregs.h.ah = 0 ;
    movedata(segregs.ds,(int)&flags,0x0060,0x0068,2);
    segregs.ds = 0x0060 ;
    int86x(0x19,&inregs,&outregs,&segregs);
#else /*NEC_PC9801*/
//    inregs.x.ax = RS232 & 0xff;
//    inregs.x.dx = RS232_COM;
//    int86( 0x14, &inregs, &outregs );

/* 
	Initialize COM port baud rate and parity settings
																		*/
if ( RS232_COM == 0 )
	_com1init(RS232);
else
	_com2init(RS232);

#endif /*NEC_PC9801*/

}  /*  of init_rs232()  */





/************************************************************************
* int read_pcport(c)
*
*
*
************************************************************************/
int read_pcport(c)
char *c;
{
  int x;
  x = rx_data();
  //*c=rx_data();

  if(x!=-1) {
         *c = x;
         return (1);
  }
  else return(-1);
}




/************************************************************************
* int write_pcport(txc)
*
*  write len bytes to Serial port from buffer.
*
*
************************************************************************/
int write_pcport(txc)
char *txc;
{
  return (tx_data(*txc));
}




/***********************************************************************
*
*  EmuLCom.ch - End of file
*
************************************************************************/
