/***********************************************************************
*
* EmuLCom.h - Emulator (ICE) Low level I/O Communication declarations
*
***********************************************************************
*
* Proprietary Rights Notice:  All rights reserved. This material
* contains the valuable properties and trade secrets of
* Microtec Research, Inc.  (MICROTEC) of Santa Clara, California,
* USA.	embodying substantial creative efforts and confidential
* information,	ideas,	and expressions;  no part of which may be
* reproduced or transmitted in any form or by any means
* electronic,  mechanical,  or otherwise -- including photo copying
* and recording or in connection with any information storage or
* retrieval system without permission in writing from MICROTEC.
*
*  Copyright Notice:  Copyright (C) 1985-1993 Microtec Research, Inc.
*
***********************************************************************
*
* Restricted Rights Legend:  Use, duplication, or disclosure by
* the Government is subject to restrictions as set forth in
* subdivision (b) (3) (ii) of the Rights in Technical Data and
* Computer Software clause at 52.227-7013 of DOD Regulation 27-401.
*
***********************************************************************
*
*		       Module Description
*
*  Function declarations for CtoIBM.asm
*
***********************************************************************
*
*		       Revision History
*  Dec 17, 1987        Chris Apple     original author
*
************************************************************************/
/***********************************************************************
*
*		       Global Equates
*
************************************************************************/

/* Ice communication bit equates - returned by GetIceCommunicationErrors */
#define	ELC_ERR_CharOverflow	1 /* char overflow during transmission */
#define	ELC_ERR_BufferOverflow	2 /* input circular buffer overflow */
#define	ELC_ERR_NoCrInBuffer	4 /* did not find expected CR in buffer */

/* type of communication ports */
#define COM_GENERIC	0	/* use whatever seems to work */
#define COM_UNIX_SYS5	1	/* Unix system 5 serial port */
#define COM_IBM 	2	/* compatible with IBM PC hardware registers */
#define COM_BIOS	3	/* compatible with IBM BIOS interface */
#define COM_HP037	4	/* compatible with HP 037 communication board */
#define COM_UNIX_BSD	5	/* BSD Unix serial port */
#define COM_UNIX_HP	6	/* HP Unix serial port */
#define COM_VAX_VMS	7	/* Vax VMS serial port */

/* ports to use when calling InitializeIceComPort */
#define	COM1	1
#define	COM2	2
#define COM3    3
#define COM4    4

#if !OS_MSDOS
extern int ELL_lansetup();  
extern int ELC_InitializeIceComPort _args(( char *, long ));
#else
extern int ELC_InitializeIceComPort _args(( char *, int , long , int ));
#endif
extern void ELC_DiscardAllEmulatorInput ();
extern unsigned int ELC_SendCharToEmulator _args(( unsigned char ));
extern unsigned int ELC_ReadCharFromEmulator ();
extern unsigned int ELC_ReadLineFromEmulator _args(( unsigned char * ));
extern unsigned int ELC_CheckIfAnyIceInput();
extern unsigned int ELC_GetNumberOfCrFromIce();
extern unsigned int ELC_GetNumberOfPromptsFromIce();
extern unsigned int ELC_GetStatusCharacterFromIce();
extern unsigned int ELC_GetIceCommunicationErrors();
extern void ELC_SetIceCommunicationTimer();
extern unsigned int ELC_CheckIceCommunicationTimer();
/***********************************************************************
*
*  EmuLCom.h - End of file
*
************************************************************************/
